/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JSplitPane;

public class SplitterPane
extends JSplitPane {
    private boolean splitPaneAtTop = false;
    private boolean splitPaneAtBottom = false;
    private SplitterComponentListener splitterListener = new SplitterComponentListener(this);

    public SplitterPane(int n, Component component, Component component2) {
        super(n, component, component2);
        component.addComponentListener(this.splitterListener);
    }

    public void setSplitterAtExtremeTop() {
        this.setDividerLocation(0.0);
        this.splitPaneAtTop = true;
        this.splitPaneAtBottom = false;
    }

    public boolean isSplitterAtExtremeTop() {
        return this.splitPaneAtTop;
    }

    public void setSplitterAtExtremeBottom() {
        this.setDividerLocation(1.0);
        this.splitPaneAtTop = false;
        this.splitPaneAtBottom = true;
    }

    public boolean isSplitterAtExtremeBottom() {
        return this.splitPaneAtBottom;
    }

    public void setDividerPercent(double d) {
        if (d <= 0.0) {
            this.setSplitterAtExtremeTop();
            return;
        }
        if (d >= 1.0) {
            this.setSplitterAtExtremeBottom();
            return;
        }
        this.setDividerLocation(d);
        this.splitPaneAtTop = false;
        this.splitPaneAtBottom = false;
    }

    public double getCurrentDividerPercent() {
        if (this.splitPaneAtTop) {
            return 0.0;
        }
        if (this.splitPaneAtBottom) {
            return 1.0;
        }
        return this.splitterListener.getDividerPercent();
    }

    public double getNonSnappedDividerPercent() {
        return this.splitterListener.getDividerPercent();
    }

    public void notifyResize() {
        int n = this.getTopComponent().getSize().height;
        int n2 = this.getBottomComponent().getSize().height;
        this.splitPaneAtBottom = false;
        this.splitPaneAtTop = false;
        if (n == 0) {
            this.splitPaneAtTop = true;
        }
        if (n2 == 0) {
            this.splitPaneAtBottom = true;
        }
    }

    class SplitterComponentListener
    extends ComponentAdapter {
        private double dividerPercent = 0.75;
        private SplitterPane splitPane;
        private int count;

        public SplitterComponentListener(SplitterPane splitterPane2) {
            SplitterPane.this = SplitterPane.this;
            this.splitPane = splitterPane2;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.splitPane.notifyResize();
            if (this.splitPane.isSplitterAtExtremeBottom()) {
                return;
            }
            if (this.splitPane.isSplitterAtExtremeTop()) {
                this.dividerPercent = 0.0;
                return;
            }
            int n = this.splitPane.getTopComponent().getSize().height;
            this.splitPane.getBottomComponent().getSize();
            int n2 = this.splitPane.getDividerSize();
            int n3 = this.splitPane.getSize().height;
            double d = (double)(n + n2 / 2 + 2) / (double)n3;
            if (Math.abs(d - this.dividerPercent) > 0.01) {
                this.dividerPercent = d;
            }
        }

        public double getDividerPercent() {
            return this.dividerPercent;
        }
    }
}

