/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.AdminClientException;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.service.security.AdminSecurityUtil;

public class AdminUserContext {
    private int usertype;
    private String username;
    private String userpswd;

    public AdminUserContext(int n, String string, String string2) throws AdminException {
        if (string == null || string.trim().length() == 0) {
            throw new AdminClientException("EXM_BUN");
        }
        this.username = string;
        if (n != 0 && n != 1) {
            throw new AdminClientException("EXM_BUT");
        }
        this.usertype = n;
        this.userpswd = null;
        if (string2 != null && string2.trim().length() > 0) {
            this.userpswd = AdminSecurityUtil.hashPassword(string2);
        }
    }

    public String getUserName() {
        return this.username;
    }

    public int getUserType() {
        return this.usertype;
    }

    public String getUserPassword() {
        return AdminSecurityUtil.unhashPassword(this.userpswd);
    }

    public void setUserPassword(String string) {
        this.userpswd = AdminSecurityUtil.hashPassword(string);
    }

    public AdminUserContext newCopy() throws AdminException {
        return new AdminUserContext(this.usertype, this.username, AdminSecurityUtil.unhashPassword(this.userpswd));
    }
}

