/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminContext;
import com.sun.admin.cis.client.AdminFrame;
import com.sun.admin.cis.client.MainHelpPanel;
import com.sun.admin.cis.client.SBConstants;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.Constants;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class TreeHolderPanel
extends JScrollPane {
    JPanel jPanel;
    JViewport jViewport;
    protected JButton rootBtn;
    private int SCREENPAD;
    GridBagConstraints grid;

    public void addToTreePanel(Component component) {
        AdminCommonTools.CMN_HandleOutput("Component count equals = " + this.jPanel.getComponentCount());
        int n = this.jPanel.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            try {
                Component component2 = this.jPanel.getComponent(0);
                this.jPanel.remove(component2);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridy = n2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.insets = n2 == 0 ? new Insets(5, 2, 0, this.SCREENPAD) : new Insets(0, 20, 0, 0);
                this.jPanel.add(component2, gridBagConstraints, -1);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                AdminCommonTools.CMN_HandleOutput("ArrayIndexOutOfBoundsException error");
                arrayIndexOutOfBoundsException.printStackTrace();
            }
            ++n2;
        }
        this.grid.anchor = 18;
        this.grid.gridx = 0;
        this.grid.gridy = n2;
        this.grid.weightx = 1.0;
        this.grid.weighty = 1.0;
        this.grid.insets = new Insets(0, 20, 0, 0);
        this.jPanel.add(component, this.grid, -1);
        this.jPanel.invalidate();
        this.jPanel.validate();
        this.jPanel.repaint();
    }

    private void initializeComponents() {
        try {
            this.rootBtn = new JButton();
            this.rootBtn.setText(this.createRootName());
            this.rootBtn.setBackground(Constants.ICONCOLOR);
            this.rootBtn.setMargin(new Insets(0, 0, 0, 0));
            this.rootBtn.setBorderPainted(false);
            this.rootBtn.setFocusPainted(false);
            this.rootBtn.addMouseListener(new RootMouseListener());
            return;
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Unexpected error");
            exception.printStackTrace();
            return;
        }
    }

    private String createRootName() {
        AdminMgmtScope adminMgmtScope = AdminContext.instance().getAdminMgmtScope();
        String string = new String("None available");
        if (adminMgmtScope.getMgmtScopeType().equals("file")) {
            string = adminMgmtScope.getMgmtServerName();
        }
        if (adminMgmtScope.getMgmtScopeType().equals("nis")) {
            string = adminMgmtScope.getMgmtDomainName();
        }
        if (adminMgmtScope.getMgmtScopeType().equals("nisplus")) {
            string = adminMgmtScope.getMgmtDomainName();
        }
        return string;
    }

    private void setUpRootHelp() {
        try {
            URL uRL = null;
            String string = AdminFrame.instance().getHelpUrl(SBConstants.getUMBHelpLocation(), "admin_apps.html");
            uRL = new URL(string);
            MainHelpPanel mainHelpPanel = MainHelpPanel.instance();
            mainHelpPanel.addToHelpPanel(uRL);
            return;
        }
        catch (MalformedURLException malformedURLException) {
            AdminCommonTools.CMN_HandleOutput("Malformed URL: " + malformedURLException);
            return;
        }
    }

    public TreeHolderPanel() {
        this.setBackground(SBConstants.getBackGroundColor());
        this.jPanel = new JPanel();
        this.jPanel.setBackground(SBConstants.getBackGroundColor());
        this.grid = new GridBagConstraints();
        this.jPanel.setLayout(new GridBagLayout());
        this.initializeComponents();
        this.grid.anchor = 18;
        this.grid.gridx = 0;
        this.grid.weightx = 1.0;
        this.grid.weighty = 1.0;
        this.grid.insets = new Insets(5, 2, 0, this.SCREENPAD);
        this.jPanel.add(this.rootBtn, this.grid, -1);
        this.jViewport = this.getViewport();
        this.jViewport.add(this.jPanel);
        AdminFrame.instance().setAppFocus(this.rootBtn);
        this.setUpRootHelp();
    }

    class RootMouseListener
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            AdminFrame.instance().waitOn();
            AdminFrame.instance().setAppFocus(TreeHolderPanel.this.rootBtn);
            TreeHolderPanel.this.rootBtn.setBackground(Constants.ICONCOLOR);
            Component component = mouseEvent.getComponent();
            AdminCommonTools.CMN_HandleOutput("Component = " + component.toString());
            TreeHolderPanel.this.setUpRootHelp();
            AdminFrame.instance().waitOff();
        }

        RootMouseListener() {
            TreeHolderPanel.this = TreeHolderPanel.this;
        }
    }
}

