/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.CommaParse;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.LimitInputDocument;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.common.GroupObj;
import com.sun.admin.usermgr.common.SGConstants;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jclass.bwt.JCSpinBox;
import jclass.bwt.JCSpinBoxEvent;
import jclass.bwt.JCSpinBoxListener;

public class AdminAddGroupDialog
extends AdminDialog {
    AdminDialog adminAddGroupDialog;
    JPanel groupPanel;
    JButton okButton;
    JButton cancelButton;
    JTextField groupTextField;
    JCSpinBox groupIDSpinBox;
    JTextArea groupMemTextArea;
    String[] members = new String[]{""};
    GenInfoPanel infoPanel;
    JPanel blankPanel;
    URL url;
    GroupObj newGroupObj;
    AdminMainPanel adminMainPanel;
    UserMgrClient userMgrClient;

    public AdminAddGroupDialog(JFrame jFrame) {
        super(jFrame, " ", false);
        this.adminAddGroupDialog = this;
        this.adminAddGroupDialog.setTitle(UMgrResourceStrings.getString("new_group_title"));
        this.userMgrClient = UserMgrClient.instance();
        this.adminMainPanel = AdminMainPanel.sharedInstance();
        this.infoPanel = this.getInfoPanel();
        this.blankPanel = this.getRightPanel();
        this.blankPanel.setLayout(new BorderLayout());
        this.blankPanel.add("Center", this.createGroupPanel());
        this.okButton = this.getOKBtn();
        this.okButton.addActionListener(new OKCancelButtonListener());
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new OKCancelButtonListener());
        this.pack();
        Dimension dimension = this.getSize();
        this.setMySize(dimension);
        this.setDefaultFocusListener(new UMgrContextHelpListener(this.infoPanel, "groups_add_group"), true);
        this.groupTextField.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "groups_add_group_name"));
        this.groupIDSpinBox.addFocusListener((FocusListener)new UMgrContextHelpListener(this.infoPanel, "groups_add_group_ID"));
        this.groupMemTextArea.addFocusListener(new UMgrContextHelpListener(this.infoPanel, "groups_add_group_members"));
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension2.width / 2 - this.getSize().width / 2, dimension2.height / 2 - this.getSize().height / 2);
        1 var4_4 = new 1();
        this.adminAddGroupDialog.addWindowListener(var4_4);
    }

    private JPanel createGroupPanel() {
        this.groupPanel = new JPanel();
        this.groupPanel.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("group_id"));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new GridBagLayout());
        Constraints.constrain(this.groupPanel, jPanel, 0, 0, 1, 1, 1, 10, 1.0, 0.3, 20, 16, 0, 16);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(UMgrResourceStrings.getString("group_mem"));
        jPanel2.setBorder(titledBorder2);
        jPanel2.setLayout(new GridBagLayout());
        Constraints.constrain(this.groupPanel, jPanel2, 0, 1, 1, 1, 1, 10, 0.0, 0.7, 12, 16, 5, 16);
        JLabel jLabel = new JLabel(UMgrResourceStrings.getString("group_name"));
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 24, 4, 0);
        LimitInputDocument limitInputDocument = new LimitInputDocument();
        this.groupTextField = new JTextField(limitInputDocument, "", 10);
        this.groupTextField.setMinimumSize(this.groupTextField.getPreferredSize());
        Constraints.constrain(jPanel, this.groupTextField, 1, 0, 1, 1, 0, 17, 1.0, 0.0, 0, 16, 4, 0);
        JLabel jLabel2 = new JLabel(UMgrResourceStrings.getString("group_id_num"));
        jLabel2.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel2.setFont(Constants.PROPS_LABEL_FONT);
        Constraints.constrain(jPanel, jLabel2, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 24, 0, 0);
        this.groupIDSpinBox = new JCSpinBox(6);
        this.groupIDSpinBox.addSpinBoxListener((JCSpinBoxListener)new spinBoxHelpListener(this.infoPanel));
        this.groupIDSpinBox.setMinimum(16);
        this.groupIDSpinBox.setMaximum(Integer.MAX_VALUE);
        this.groupIDSpinBox.setMaximumLength(10);
        this.groupIDSpinBox.setIntValue(Integer.parseInt(this.userMgrClient.getNextAvailableGID()));
        this.groupIDSpinBox.setAlignment(2);
        this.groupIDSpinBox.setBackground(Color.white);
        Constraints.constrain(jPanel, (Component)this.groupIDSpinBox, 1, 1, 1, 1, 0, 17, 1.0, 0.0, 0, 16, 0, 0);
        this.groupMemTextArea = new JTextArea(9, 33);
        this.groupMemTextArea.setLineWrap(true);
        this.groupMemTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.groupMemTextArea);
        Constraints.constrain(jPanel2, jScrollPane, 0, 0, 1, 1, 1, 17, 1.0, 0.9, 10, 10, 10, 10);
        return this.groupPanel;
    }

    public void onEnterKey() {
    }

    public boolean isGroupSyntaxOK() {
        if (!CheckSyntax.isNameOK(this.groupTextField.getText())) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, CheckSyntax.getErrorString());
            return false;
        }
        if (Integer.parseInt(this.groupIDSpinBox.getValue()) < 16 || Integer.parseInt(this.groupIDSpinBox.getValue()) > Integer.MAX_VALUE) {
            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, UMgrResourceStrings.getString("er_group_add_gid"));
            return false;
        }
        return true;
    }

    public boolean isCreateGroupOK() {
        if (this.isPopulateMembersOK(this.groupMemTextArea.getText())) {
            GroupObj groupObj = new GroupObj(this.groupTextField.getText());
            groupObj.setGroupID(this.groupIDSpinBox.getValue());
            groupObj.setGroupPassword("");
            groupObj.setGroupUsers(this.getMembers());
            this.setGroupObj(groupObj);
            AdminCommonTools.CMN_HandleOutput("Finished creating Group");
            return true;
        }
        return false;
    }

    public String[] getMembers() {
        return this.members;
    }

    public void setMembers(String[] stringArray) {
        this.members = stringArray;
    }

    public GroupObj getGroupObj() {
        return this.newGroupObj;
    }

    public void setGroupObj(GroupObj groupObj) {
        this.newGroupObj = groupObj;
    }

    public boolean isPopulateMembersOK(String string) {
        String[] stringArray = new String[]{"0", ",", " ", "\t", "\n"};
        boolean bl = false;
        JFrame jFrame = AdminMainPanel.sharedInstance().jFrame;
        String string2 = "";
        if (!CheckSyntax.isStringOK(string, stringArray)) {
            string2 = UMgrResourceStrings.getString("er_group_members_syntax");
            new ErrorDialog(jFrame, string2);
            bl = true;
        } else {
            String[] stringArray2;
            if (!string.equals("")) {
                int n;
                String[] stringArray3 = CommaParse.parseStringToStrArray(string);
                int n2 = stringArray3.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string3 = stringArray3[n3];
                    while (string3.startsWith(" ") || string3.startsWith("\t") || string3.startsWith("\n")) {
                        stringArray3[n3] = string3 = string3.substring(1);
                    }
                    while (string3.endsWith(" ") || string3.endsWith("\t") || string3.endsWith("\n")) {
                        n = string3.length();
                        stringArray3[n3] = string3 = string3.substring(0, n);
                    }
                    if (!string3.equals("")) {
                        if (!CheckSyntax.isNameOK(string3)) {
                            string2 = UMgrResourceStrings.getString("er_group_members_name");
                            new ErrorDialog(jFrame, string2);
                            return false;
                        }
                    } else {
                        string2 = UMgrResourceStrings.getString("er_group_members_emp");
                        new ErrorDialog(jFrame, string2);
                        return false;
                    }
                    ++n3;
                }
                int n4 = 0;
                n = 1;
                while (n < n2) {
                    int n5 = n4 + 1;
                    while (n5 < n2) {
                        if (stringArray3[n4].equals(stringArray3[n5])) {
                            string2 = UMgrResourceStrings.getString("er_group_members_dup");
                            new ErrorDialog(jFrame, string2);
                            return false;
                        }
                        ++n5;
                    }
                    ++n4;
                    ++n;
                }
                AdminCommonTools.CMN_HandleOutput("SUCCESS");
                stringArray2 = stringArray3;
            } else {
                AdminCommonTools.CMN_HandleOutput("TEXTAREA EMPTY");
                stringArray2 = new String[]{""};
            }
            this.setMembers(stringArray2);
        }
        return !bl;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            AdminAddGroupDialog.this.adminAddGroupDialog.dispose();
        }

        /* synthetic */ 1() {
        }
    }

    class spinBoxHelpListener
    implements JCSpinBoxListener {
        private GenInfoPanel infoPanel;

        public spinBoxHelpListener(GenInfoPanel genInfoPanel) {
            AdminAddGroupDialog.this = AdminAddGroupDialog.this;
            this.infoPanel = genInfoPanel;
        }

        public void spinBoxChangeBegin(JCSpinBoxEvent jCSpinBoxEvent) {
            try {
                if (jCSpinBoxEvent.getSource() == AdminAddGroupDialog.this.groupIDSpinBox) {
                    try {
                        String string = AdminMainPanel.sharedInstance().clientComm.getHelpUrl(SGConstants.getUMgrHelpLocation(), "/groups_add_group_ID.html");
                        this.infoPanel.setUrl(new URL(string));
                        return;
                    }
                    catch (MalformedURLException malformedURLException) {
                        AdminCommonTools.CMN_HandleOutput("Malformed URL: " + malformedURLException);
                        return;
                    }
                }
            }
            catch (Exception exception) {}
        }

        public void spinBoxChangeEnd(JCSpinBoxEvent jCSpinBoxEvent) {
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == AdminAddGroupDialog.this.okButton) {
                    if (AdminAddGroupDialog.this.isGroupSyntaxOK() && AdminAddGroupDialog.this.isCreateGroupOK()) {
                        AdminViews adminViews = AdminViews.instance();
                        try {
                            adminViews.addGroupToGroupViews(AdminAddGroupDialog.this.getGroupObj());
                            AdminAddGroupDialog.this.adminAddGroupDialog.dispose();
                            return;
                        }
                        catch (Exception exception) {
                            new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
                            return;
                        }
                    }
                } else {
                    AdminAddGroupDialog.this.adminAddGroupDialog.dispose();
                }
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack(1, exception);
                new ErrorDialog(AdminMainPanel.sharedInstance().jFrame, exception.getLocalizedMessage());
                return;
            }
        }

        OKCancelButtonListener() {
            AdminAddGroupDialog.this = AdminAddGroupDialog.this;
        }
    }
}

