/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.sort.TableSorter;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.ClientListView;
import com.sun.admin.fsmgr.client.share.ClientTableRow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class ClientTableView
extends ClientListView {
    JTable table;
    JScrollPane scrollPane;
    Object[][] theData;
    ClientTableModel dataModel;
    TableSorter tableSorter;
    int theSortColumn;
    boolean ascendSort = true;
    ClientTableView thisView;
    Vector vColumns = new Vector();
    Vector vClients = new Vector();
    ResourceBundle bundle = FsMgr.getFsMgr().getResourceBundle();
    ErrorDialog errorDlg;
    String[] columnKeys = new String[]{FsMgrResourceStrings.getString("share_wiz_auth_client_column"), FsMgrResourceStrings.getString("share_wiz_auth_access_column"), FsMgrResourceStrings.getString("share_wiz_auth_root_column")};

    public ClientTableView() {
        this.thisView = this;
        this.vColumns.addElement(FsMgrResourceStrings.getString("share_wiz_auth_client_column"));
        this.vColumns.addElement(FsMgrResourceStrings.getString("share_wiz_auth_access_column"));
        this.vColumns.addElement(FsMgrResourceStrings.getString("share_wiz_auth_root_column"));
        this.dataModel = new ClientTableModel();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.tableSorter = new TableSorter(this.dataModel);
        this.table = new JTable(this.tableSorter);
        this.table.setBackground(Color.white);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setAutoResizeMode(4);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new 1());
        this.table.addMouseListener(new TableMouseListener(this));
        this.table.getTableHeader();
        this.setViewportView(this.table);
        this.setBackground(Color.white);
        this.setPreferredSize(new Dimension(283, 100));
    }

    protected int getViewType() {
        return 1;
    }

    public void populate() {
        this.dataModel.refreshData();
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public boolean isPopulated() {
        return this.vClients.size() > 0;
    }

    protected boolean isFirstRow() {
        ClientTableRow clientTableRow = this.getSelectedItem();
        return clientTableRow != null && (clientTableRow == null || clientTableRow == this.vClients.firstElement());
    }

    public boolean isLastRow() {
        ClientTableRow clientTableRow = this.getSelectedItem();
        return clientTableRow != null && (clientTableRow == null || clientTableRow == this.vClients.lastElement());
    }

    public void clear() {
        this.clearSelection();
        this.theData = new Object[0][this.dataModel.getMaxColumnCount()];
        this.vClients.removeAllElements();
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void moveUp() {
        ClientTableRow clientTableRow = this.getSelectedItem();
        if (clientTableRow == null) {
            return;
        }
        int n = this.vClients.indexOf(clientTableRow);
        if (clientTableRow != this.vClients.firstElement()) {
            this.vClients.removeElementAt(n);
            this.vClients.insertElementAt(clientTableRow, n - 1);
            this.dataModel.refreshData();
            this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
            this.table.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    public void moveDown() {
        ClientTableRow clientTableRow = this.getSelectedItem();
        if (clientTableRow == null) {
            return;
        }
        int n = this.vClients.indexOf(clientTableRow);
        if (clientTableRow != this.vClients.lastElement()) {
            this.vClients.removeElementAt(n);
            this.vClients.insertElementAt(clientTableRow, n + 1);
            this.dataModel.refreshData();
            this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
            this.table.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    public boolean dup(ClientTableRow clientTableRow) {
        String string = clientTableRow.getClientName();
        int n = 0;
        while (n < this.vClients.size()) {
            ClientTableRow clientTableRow2 = (ClientTableRow)this.vClients.elementAt(n);
            if (string.equals(clientTableRow2.getClientName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void append(ClientTableRow clientTableRow) {
        if (this.dup(clientTableRow)) {
            this.errorDlg = new ErrorDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("client_table_err1"));
            return;
        }
        this.vClients.addElement(clientTableRow);
        this.dataModel.refreshData();
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void update(ClientTableRow clientTableRow) {
        ClientTableRow clientTableRow2 = this.getSelectedItem();
        if (clientTableRow2 == null) {
            return;
        }
        if (this.dup(clientTableRow) && !clientTableRow.getClientName().equals(clientTableRow2.getClientName())) {
            return;
        }
        int n = this.vClients.indexOf(clientTableRow2);
        this.vClients.setElementAt(clientTableRow, n);
        this.dataModel.refreshData();
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public void remove() {
        ClientTableRow clientTableRow = this.getSelectedItem();
        if (clientTableRow == null) {
            return;
        }
        int n = this.vClients.indexOf(clientTableRow);
        this.vClients.removeElementAt(n);
        this.dataModel.refreshData();
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
    }

    public ClientTableRow getSelectedItem() {
        int[] nArray = this.table.getSelectedRows();
        ClientTableRow clientTableRow = this.vClients.size() > 0 ? (ClientTableRow)this.vClients.elementAt(this.tableSorter.convertRowIndexToModel(nArray[0])) : null;
        return clientTableRow;
    }

    public Vector getRowData() {
        return this.vClients;
    }

    public int getNumSelections() {
        return this.table.getSelectedRowCount();
    }

    private void onSelect() {
        this.fireItemPressed(1);
    }

    public void selectAll() {
        this.table.setRowSelectionInterval(0, this.table.getRowCount() - 1);
    }

    public void clearSelection() {
        this.table.clearSelection();
        this.fireItemPressed(0);
    }

    public void sortAscending() {
        this.ascendSort = true;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortOrderChanged();
    }

    public void sortDescending() {
        this.ascendSort = false;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortOrderChanged();
    }

    protected int getSortOrder() {
        if (this.ascendSort) {
            return 10;
        }
        return 11;
    }

    class ClientTableModel
    extends AbstractTableModel {
        Vector tableColumns = new Vector();

        public int getColumnCount() {
            return ClientTableView.this.vColumns.size();
        }

        public int getRowCount() {
            return ClientTableView.this.theData.length;
        }

        public Object getValueAt(int n, int n2) {
            if (ClientTableView.this.theData.length == 0) {
                return null;
            }
            return ClientTableView.this.theData[n][n2];
        }

        public String getColumnName(int n) {
            String string = (String)ClientTableView.this.vColumns.elementAt(n);
            ActionString actionString = new ActionString(ClientTableView.this.bundle, string);
            return actionString.getString();
        }

        public void refreshData() {
            Object[][] objectArray = new Object[ClientTableView.this.vClients.size()][ClientTableView.this.dataModel.getMaxColumnCount()];
            int n = 0;
            while (n < ClientTableView.this.vClients.size()) {
                ClientTableRow clientTableRow = (ClientTableRow)ClientTableView.this.vClients.elementAt(n);
                objectArray[n][this.getColumnModelIndex((String)FsMgrResourceStrings.getString((String)"share_wiz_auth_client_column"))] = clientTableRow.getClientName();
                objectArray[n][this.getColumnModelIndex((String)FsMgrResourceStrings.getString((String)"share_wiz_auth_access_column"))] = clientTableRow.getAccessStr();
                objectArray[n][this.getColumnModelIndex((String)FsMgrResourceStrings.getString((String)"share_wiz_auth_root_column"))] = clientTableRow.isRoot() ? FsMgrResourceStrings.getString("share_wiz_auth_root_user") : FsMgrResourceStrings.getString("share_wiz_auth_anon_user");
                ++n;
            }
            ClientTableView.this.theData = objectArray;
        }

        public int getMaxColumnCount() {
            return ClientTableView.this.columnKeys.length;
        }

        public String getColumnModelKey(int n) {
            return ClientTableView.this.columnKeys[n];
        }

        public TableColumn getTableColumn(int n) {
            return (TableColumn)this.tableColumns.elementAt(n);
        }

        public int getColumnModelIndex(String string) {
            int n = 0;
            while (n < this.getMaxColumnCount()) {
                if (string.compareTo(ClientTableView.this.columnKeys[n]) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        public ClientTableModel() {
            ClientTableView.this = ClientTableView.this;
            int n = 0;
            while (n < ClientTableView.this.columnKeys.length) {
                String string = ClientTableView.this.columnKeys[n];
                ActionString actionString = new ActionString(ClientTableView.this.bundle, string);
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier(string);
                tableColumn.setHeaderValue(actionString.getString());
                tableColumn.setModelIndex(n);
                this.tableColumns.addElement(tableColumn);
                ++n;
            }
        }
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ClientTableView.this.onSelect();
        }

        /* synthetic */ 1() {
        }
    }

    class TableMouseListener
    extends MouseAdapter {
        MouseTimer mouseTimer;
        ClientListView listView;

        public TableMouseListener(ClientListView clientListView) {
            ClientTableView.this = ClientTableView.this;
            this.listView = clientListView;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isControlDown()) {
                if (this.mouseTimer != null) {
                    this.mouseTimer.stop();
                }
                this.mouseTimer = null;
                return;
            }
            if (this.mouseTimer == null || !this.mouseTimer.isAlive()) {
                this.mouseTimer = new MouseTimer();
                this.mouseTimer.start();
                return;
            }
            this.mouseTimer.stop();
            this.mouseTimer = null;
            this.listView.fireItemPressed(2);
        }
    }

    class MouseTimer
    extends Thread {
        public MouseTimer() {
            ClientTableView.this = ClientTableView.this;
        }

        public void run() {
            try {
                Thread.sleep(1000L);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

