/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.LAYOUT_ALIGNMENT;
import com.sun.admin.cis.common.RowLayout;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogRecordHeader;
import com.sun.admin.logviewer.client.LogPanel;
import com.sun.admin.logviewer.client.LogVContextHelpListener;
import com.sun.admin.logviewer.client.LogVMainPanel;
import com.sun.admin.logviewer.common.LogVResourceStrings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LogDetails
extends AdminDialog {
    public static String sccs_id = "@(#)EventDetails.java 1.1 10/30/98";
    protected LogPanel logPanel;
    JLabel date;
    JLabel time;
    JLabel user;
    JLabel computer;
    JLabel id;
    JLabel source;
    JLabel severity;
    JLabel category;
    JTextArea desc;
    JTextArea data;
    JButton prev;
    JButton next;
    JButton close;
    ImageIcon arrowUpIcon;
    ImageIcon arrowDownIcon;
    JButton OKBtn;
    JButton CancelBtn;
    JButton ApplyBtn;
    JPanel blankPanel;
    GenInfoPanel infoPanel;

    public LogDetails(Frame frame, LogPanel logPanel, LogRecordHeader logRecordHeader) {
        super(frame, LogVResourceStrings.getString("log_details_title"), true);
        this.logPanel = logPanel;
        this.infoPanel = this.getInfoPanel();
        this.prev = this.getOKBtn();
        this.next = this.getApplyBtn();
        this.CancelBtn = this.getCancelBtn();
        this.CancelBtn.setText(LogVResourceStrings.getString("close_lbl"));
        Insets insets = new Insets(8, 10, 7, 10);
        this.CancelBtn.setMargin(insets);
        this.CancelBtn.addActionListener(new OKCancelButtonListener());
        this.blankPanel = this.getRightPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.blankPanel.setLayout(new RowLayout(LAYOUT_ALIGNMENT.TOP, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        Dimension dimension = new Dimension(70, 15);
        Dimension dimension2 = new Dimension(90, 15);
        Font font = new Font("Dialog", 0, 12);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        JLabel jLabel = new JLabel(LogVResourceStrings.getString("date_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.date = new JLabel();
        this.date.setForeground(Color.black);
        this.date.setPreferredSize(dimension2);
        this.date.setFont(font);
        jPanel3.add(this.date);
        Constraints.constrain(jPanel2, jPanel3, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 20);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(LogVResourceStrings.getString("time_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.time = new JLabel();
        this.time.setForeground(Color.black);
        this.time.setPreferredSize(dimension2);
        this.time.setFont(font);
        jPanel3.add(this.time);
        Constraints.constrain(jPanel2, jPanel3, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 20);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(LogVResourceStrings.getString("src_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.source = new JLabel();
        this.source.setForeground(Color.black);
        this.source.setPreferredSize(dimension2);
        this.source.setFont(font);
        jPanel3.add(this.source);
        Constraints.constrain(jPanel2, jPanel3, 0, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 20);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(LogVResourceStrings.getString("cat_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.category = new JLabel();
        this.category.setForeground(Color.black);
        this.category.setPreferredSize(dimension2);
        this.category.setFont(font);
        jPanel3.add(this.category);
        Constraints.constrain(jPanel2, jPanel3, 0, 3, 1, 1, 0, 17, 0.0, 0.0, 0, 0, 0, 20);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(LogVResourceStrings.getString("user_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.user = new JLabel();
        this.user.setForeground(Color.black);
        this.user.setPreferredSize(dimension2);
        this.user.setFont(font);
        jPanel3.add(this.user);
        Constraints.constrain(jPanel2, jPanel3, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 0);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(LogVResourceStrings.getString("comp_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.computer = new JLabel();
        this.computer.setForeground(Color.black);
        this.computer.setPreferredSize(dimension2);
        this.computer.setFont(font);
        jPanel3.add(this.computer);
        Constraints.constrain(jPanel2, jPanel3, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 0);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(String.valueOf(LogVResourceStrings.getString("severity_lbl")) + ":");
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.severity = new JLabel();
        this.severity.setForeground(Color.black);
        this.severity.setPreferredSize(dimension2);
        this.severity.setFont(font);
        jPanel3.add(this.severity);
        Constraints.constrain(jPanel2, jPanel3, 1, 2, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 0);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 15, 0));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout(LAYOUT_ALIGNMENT.EXPAND, 10, 0));
        jLabel = new JLabel(LogVResourceStrings.getString("event_lbl"));
        jLabel.setForeground(Color.black);
        jLabel.setPreferredSize(dimension);
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this.id = new JLabel();
        this.id.setForeground(Color.black);
        this.id.setPreferredSize(dimension2);
        this.id.setFont(font);
        jPanel3.add(this.id);
        Constraints.constrain(jPanel2, jPanel3, 1, 3, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 0);
        Constraints.constrain(jPanel, jPanel2, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 5);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout());
        jLabel = new JLabel(LogVResourceStrings.getString("descr_lbl"));
        jLabel.setForeground(Color.black);
        Constraints.constrain(jPanel, jLabel, 0, 1, 1, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 5);
        this.desc = new JTextArea();
        this.desc.setLineWrap(true);
        this.desc.setWrapStyleWord(true);
        this.desc.setBackground(this.blankPanel.getBackground());
        this.desc.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.desc);
        jScrollPane.setPreferredSize(new Dimension(350, 120));
        Constraints.constrain(jPanel, jScrollPane, 0, 2, 1, 1, 1, 17, 0.0, 0.0, 10, 10, 0, 5);
        jLabel = new JLabel();
        jLabel.setPreferredSize(new Dimension(0, 10));
        Constraints.constrain(jPanel, jLabel, 0, 3, 1, 1, 0, 17, 0.0, 0.0, 10, 10, 0, 5);
        jPanel3 = new JPanel();
        jPanel3.setLayout(new RowLayout());
        jLabel = new JLabel(LogVResourceStrings.getString("sys_data"));
        jLabel.setForeground(Color.black);
        Constraints.constrain(jPanel, jLabel, 0, 4, 1, 1, 0, 17, 0.0, 0.0, 0, 10, 0, 5);
        this.data = new JTextArea();
        this.data.setLineWrap(true);
        this.data.setWrapStyleWord(true);
        this.data.setBackground(jPanel.getBackground());
        this.data.setEditable(false);
        jScrollPane = new JScrollPane(this.data);
        jScrollPane.setPreferredSize(new Dimension(350, 95));
        Constraints.constrain(jPanel, jScrollPane, 0, 5, 1, 1, 1, 17, 0.0, 0.0, 10, 10, 0, 5);
        jPanel.setBorder(BorderFactory.createEmptyBorder(15, 20, 15, 0));
        this.arrowUpIcon = LogVMainPanel.instance().loadImageIcon("arrow-up.gif", "UP");
        this.arrowDownIcon = LogVMainPanel.instance().loadImageIcon("arrow-down.gif", "DOWN");
        this.next.setIcon(this.arrowDownIcon);
        this.next.setText("");
        this.prev.setIcon(this.arrowUpIcon);
        this.prev.setText("");
        this.prev.addActionListener(new OKCancelButtonListener());
        this.next.addActionListener(new OKCancelButtonListener());
        this.blankPanel.add(jPanel);
        this.pack();
        Dimension dimension3 = this.getSize();
        this.setMySize(dimension3);
        this.setDefaultFocusListener(new LogVContextHelpListener(this.infoPanel, "lm_ctx_dlg_prop_overview"), true);
    }

    public void setLogRecord(LogRecordHeader logRecordHeader) {
        this.severity.setText(logRecordHeader.getSeverityString());
        this.date.setText(logRecordHeader.getDateString());
        this.time.setText(logRecordHeader.getTimeString());
        this.source.setText(logRecordHeader.getAppName());
        this.category.setText(logRecordHeader.getCategoryString());
        this.id.setText(logRecordHeader.getEventId());
        this.user.setText(logRecordHeader.getUserName());
        this.computer.setText(logRecordHeader.getClientHostName());
    }

    public void setDescription(LogRecord logRecord) {
        this.desc.setText("");
        this.desc.insert(logRecord.getDetailedMesg(true), 0);
    }

    public void disablePrev() {
        this.prev.setEnabled(false);
    }

    public void disableNext() {
        this.next.setEnabled(false);
    }

    public void enablePrev() {
        this.prev.setEnabled(true);
    }

    public void enableNext() {
        this.next.setEnabled(true);
    }

    public void setData(LogRecord logRecord) {
        this.data.setText("");
        int n = 0;
        n = logRecord.getLabelStrings(true).length;
        int n2 = 0;
        n2 = logRecord.getValueStrings().length;
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n2];
        String[] stringArray3 = new String[n];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = logRecord.getLabelStrings(true)[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < n2) {
            stringArray2[n4] = logRecord.getValueStrings()[n4];
            ++n4;
        }
        if (n != 0) {
            this.data.setText("");
            int n5 = 0;
            while (n5 < n) {
                stringArray3[n5] = String.valueOf(stringArray[n5]) + "     " + stringArray2[n5];
                this.data.insert(String.valueOf(stringArray3[n5]) + "\n", 0);
                ++n5;
            }
        }
    }

    class OKCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == LogDetails.this.CancelBtn) {
                LogDetails.this.dispose();
                return;
            }
            if (actionEvent.getSource() == LogDetails.this.prev) {
                LogDetails.this.enableNext();
                LogDetails.this.logPanel.selectNextUp();
                LogDetails.this.blankPanel.repaint();
                return;
            }
            if (actionEvent.getSource() == LogDetails.this.next) {
                LogDetails.this.enablePrev();
                LogDetails.this.logPanel.selectNextDown();
                LogDetails.this.blankPanel.repaint();
            }
        }

        OKCancelButtonListener() {
            LogDetails.this = LogDetails.this;
        }
    }
}

