/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NetworkAdvPropsPanel
extends AbstractPropsPanel {
    private NetworkData originalNetworkObj;
    private JTextField aliases;
    private JTextArea description;
    private JTextField etherAddress;

    public NetworkAdvPropsPanel(GenInfoPanel genInfoPanel, NetworkData networkData) {
        ResourceBundle resourceBundle = Main.getApp().getResourceBundle();
        this.setLayout(new GridBagLayout());
        ActionString actionString = new ActionString(resourceBundle, "NetAdvPropsTabName");
        this.setBorder(BorderFactory.createTitledBorder(actionString.getString()));
        actionString = new ActionString(resourceBundle, "NetGenPropsAliases");
        JLabel jLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, jLabel, 0, -1, 1, 1, 0, 17, 0.0, 0.0, 10, 5, 10, 5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.aliases = new JTextField(networkData.getAliases(), 24);
        Constraints.constrain(this, this.aliases, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 10, 0, 10, 5);
        this.aliases.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.aliases);
        actionString = new ActionString(resourceBundle, "NetGenPropsDescription");
        jLabel = new JLabel(actionString.getString());
        Constraints.constrain(this, jLabel, 0, -1, 1, 1, 0, 18, 0.0, 0.0, 0, 5, 10, 5);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setDisplayedMnemonic(actionString.getMnemonic());
        this.description = new JTextArea(networkData.getDescription(), 3, 24);
        this.description.setLineWrap(true);
        this.description.setFont(Constants.PROPS_RW_VALUE_FONT);
        jLabel.setLabelFor(this.description);
        JScrollPane jScrollPane = new JScrollPane(this.description, 20, 31);
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        Constraints.constrain(this, jScrollPane, 1, -1, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 10, 5);
        if (networkData.getNetworkAddress().length() != 0) {
            this.aliases.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_netprop_alias"));
            this.description.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_netprop_desc"));
        } else {
            this.aliases.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newnet_alias"));
            this.description.addFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newnet_desc"));
        }
        this.originalNetworkObj = networkData;
    }

    public void dialogDataExchange(Object object) throws HostException {
        NetworkData networkData = (NetworkData)object;
        if (this.description.getText().length() > 0) {
            try {
                NetworkData.validateDescription(this.description.getText());
                networkData.setDescription(this.description.getText());
            }
            catch (HostException hostException) {
                this.description.requestFocus();
                throw hostException;
            }
        }
        if (this.aliases.getText().length() > 0) {
            try {
                NetworkData.validateAliasNames(this.aliases.getText());
                networkData.setAliases(this.aliases.getText());
                return;
            }
            catch (HostException hostException) {
                this.aliases.requestFocus();
                throw hostException;
            }
        }
    }

    public void dialogDataInitialize(Object object) {
        NetworkData networkData = (NetworkData)object;
        this.description.setText(networkData.getDescription());
        this.aliases.setText(networkData.getAliases());
        this.originalNetworkObj = networkData;
    }
}

