/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.service.security.AdminSecurityException;
import java.io.Serializable;

public abstract class AuthenticationFlavor
implements Serializable {
    public static final int ADM_AUTH_WEAK = 0;
    public static final String ADM_AUTH_WEAK_NAME = "weak";
    public static final int ADM_AUTH_DIGEST = 1;
    public static final String ADM_AUTH_DIGEST_NAME = "digest";
    public static final int ADM_AUTH_ENCRYPT = 2;
    public static final String ADM_AUTH_ENCRYPT_NAME = "encryption";
    private static final int ADM_AUTH_STRONG = 2;
    public static final String ADM_SECURITY_PROVIDER_DFLT = "sun.security.provider.SUN";
    public static final String ADM_SECURITY_DIGEST_DFLT = "SHA";
    public static final String ADM_SECURITY_SIGN_DFLT = "DSA";
    public static final String ADM_SECURITY_KEYGEN_DFLT = "DSA";
    public static final String ADM_SECURITY_STRENGTH_DFLT = "1024";
    public static final int ADM_SECURITY_STRENGTH_MAX = 1024;
    private int authType;

    public AuthenticationFlavor(int n) throws AdminSecurityException {
        if (n < 0 || n > 2) {
            throw new AdminSecurityException("EXSS_UAF", new Integer(n));
        }
        this.authType = n;
    }

    public int getAuthType() {
        return this.authType;
    }

    public String getAuthTypeName() {
        String string = null;
        switch (this.authType) {
            case 0: {
                string = ADM_AUTH_WEAK_NAME;
                break;
            }
            case 1: {
                string = ADM_AUTH_DIGEST_NAME;
                break;
            }
            case 2: {
                string = ADM_AUTH_ENCRYPT_NAME;
                break;
            }
            default: {
                string = "Unknown";
            }
        }
        return string;
    }

    public abstract AuthenticationFlavor newCopy() throws AdminSecurityException;
}

