/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.logging;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.service.logging.Filterable;
import com.sun.admin.cis.service.logging.LogRecord;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class LogFilter
implements Filterable,
Serializable {
    public static final int REVERSE = 0;
    public static final int FORWARD = 1;
    public static final int USE_SCOPE = 0;
    public static final int NO_SCOPE = 1;
    private Vector appNames;
    private int[] category = new int[3];
    private int[] severity = new int[3];
    private Date start_date;
    private Date end_date;
    private String start_date_str;
    private String end_date_str;
    private String user;
    private String clientHostName;
    private String agentHostName;
    private int reverse;
    private int scope_filter;
    private String scopeName;

    public LogFilter() {
        this.appNames = new Vector();
        this.category[0] = -1;
        this.category[1] = -1;
        this.category[2] = -1;
        this.severity[0] = -1;
        this.severity[1] = -1;
        this.severity[2] = -1;
        this.start_date_str = null;
        this.end_date_str = null;
        this.user = null;
        this.clientHostName = null;
        this.agentHostName = null;
        this.reverse = 0;
        this.scope_filter = 0;
    }

    public LogFilter(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n3) {
        this.appNames = new Vector();
        if (string != null) {
            this.appNames.addElement(string);
        }
        this.category[0] = n;
        this.severity[0] = n2;
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string2 != null && string3 != null) {
            this.start_date_str = String.valueOf(string2) + " at " + string3;
            try {
                this.start_date = simpleDateFormat.parse(this.start_date_str);
            }
            catch (Exception exception) {}
            if (this.start_date == null) {
                try {
                    this.start_date = simpleDateFormat2.parse(this.start_date_str);
                }
                catch (Exception exception) {}
            }
        }
        if (string4 != null && string5 != null) {
            this.end_date_str = String.valueOf(string4) + " at " + string5;
            try {
                this.end_date = simpleDateFormat.parse(this.end_date_str);
            }
            catch (Exception exception) {}
            if (this.end_date == null) {
                try {
                    this.end_date = simpleDateFormat2.parse(this.end_date_str);
                }
                catch (Exception exception) {}
            }
        }
        this.user = string6;
        this.clientHostName = string7;
        this.agentHostName = string8;
        this.reverse = n3;
    }

    public Vector getAppNames() {
        return this.appNames;
    }

    public int[] getCategory() {
        return this.category;
    }

    public int[] getSeverity() {
        return this.severity;
    }

    public String getStartDate() {
        if (this.start_date_str != null) {
            return this.start_date_str;
        }
        return null;
    }

    public String getEndDate() {
        if (this.end_date_str != null) {
            return this.end_date_str;
        }
        return null;
    }

    public String getUser() {
        return this.user;
    }

    public String getclientHostName() {
        return this.clientHostName;
    }

    public String getAgentHostName() {
        return this.agentHostName;
    }

    public int getDirection() {
        return this.reverse;
    }

    public void setScopeFilter(int n) {
        if (n != 0 && n != 1) {
            this.scope_filter = 0;
            return;
        }
        this.scope_filter = n;
    }

    public int getScopeFilter() {
        return this.scope_filter;
    }

    public void setAppNames(String string, String string2, String string3) {
        if (string != null && string.length() != 0) {
            this.appNames.addElement(string);
        }
        if (string2 != null && string2.length() != 0) {
            this.appNames.addElement(string2);
        }
        if (string3 != null && string3.length() != 0) {
            this.appNames.addElement(string3);
        }
    }

    public void setAppNames(String string, String string2, String string3, String string4) {
        if (string != null && string.length() != 0) {
            this.appNames.addElement(string);
        }
        if (string2 != null && string2.length() != 0) {
            this.appNames.addElement(string2);
        }
        if (string3 != null && string3.length() != 0) {
            this.appNames.addElement(string3);
        }
        if (string4 != null && string4.length() != 0) {
            this.appNames.addElement(string4);
        }
    }

    public void setCategory(int n, int n2, int n3) {
        this.category[0] = n;
        this.category[1] = n2;
        this.category[2] = n3;
    }

    public void setSeverity(int n, int n2, int n3) {
        this.severity[0] = n;
        this.severity[1] = n2;
        this.severity[2] = n3;
    }

    public void setStartDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "00:00:00 AM";
        }
        this.start_date_str = String.valueOf(string) + " at " + string2;
        try {
            this.start_date = simpleDateFormat.parse(this.start_date_str);
        }
        catch (Exception exception) {}
        if (this.start_date == null) {
            try {
                this.start_date = simpleDateFormat2.parse(this.start_date_str);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void setEndDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        SimpleDateFormat simpleDateFormat2 = (SimpleDateFormat)DateFormat.getDateTimeInstance();
        simpleDateFormat.applyPattern("MM/dd/yyyy 'at' hh:mm:ss a");
        simpleDateFormat2.applyPattern("MM/dd/yyyy 'at' HH:mm:ss");
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "11:59:59 PM";
        }
        this.end_date_str = String.valueOf(string) + " at " + string2;
        try {
            this.end_date = simpleDateFormat.parse(this.end_date_str);
        }
        catch (Exception exception) {}
        if (this.end_date == null) {
            try {
                this.end_date = simpleDateFormat2.parse(this.end_date_str);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public void setUser(String string) {
        if (string != null && string.length() != 0) {
            this.user = string;
        }
    }

    public void setClientHostName(String string) {
        if (string != null && string.length() != 0) {
            this.clientHostName = string;
        }
    }

    public void setAgentHostName(String string) {
        if (string != null && string.length() != 0) {
            this.agentHostName = string;
        }
    }

    public void setDirection(int n) {
        this.reverse = n;
    }

    public boolean checkConstraints(LogRecord logRecord) {
        block17: {
            if (this.appNames.size() != 0) {
                int n = 0;
                boolean bl = false;
                n = 0;
                while (n < this.appNames.size()) {
                    String string = (String)this.appNames.elementAt(n);
                    bl = this.is_app_name_OK(string, logRecord);
                    if (bl) break;
                    bl |= false;
                    ++n;
                }
                if (!bl) {
                    return false;
                }
            }
            if ((this.category[0] != -1 || this.category[1] != -1 || this.category[2] != -1) && this.category[0] != logRecord.getCategory() && this.category[1] != logRecord.getCategory() && this.category[2] != logRecord.getCategory()) {
                return false;
            }
            if ((this.severity[0] != -1 || this.severity[1] != -1 || this.severity[2] != -1) && this.severity[0] != logRecord.getSeverity() && this.severity[1] != logRecord.getSeverity() && this.severity[2] != logRecord.getSeverity()) {
                return false;
            }
            if (this.start_date != null && this.end_date != null && (this.start_date.after(logRecord.getDate()) || this.end_date.before(logRecord.getDate()))) {
                return false;
            }
            if (this.start_date == null && this.end_date != null && this.end_date.before(logRecord.getDate())) {
                return false;
            }
            if (this.start_date != null && this.end_date == null && this.start_date.after(logRecord.getDate())) {
                return false;
            }
            if (this.user != null && !this.user.equalsIgnoreCase(logRecord.getUserName())) {
                return false;
            }
            if (this.clientHostName != null && !this.clientHostName.equalsIgnoreCase(logRecord.getClientHostName())) {
                return false;
            }
            if (this.agentHostName != null && !this.agentHostName.equalsIgnoreCase(logRecord.getAgentHostName())) {
                return false;
            }
            if (this.scope_filter != 0 || this.scopeName == null) break block17;
            AdminMgmtScope adminMgmtScope = null;
            try {
                adminMgmtScope = new AdminMgmtScope(null, this.scopeName);
            }
            catch (AdminException adminException) {}
            if (logRecord.getScopeString() != null && logRecord.getScopeString().length() != 0 && adminMgmtScope != null) {
                try {
                    if (!adminMgmtScope.equals(logRecord.getScopeString())) {
                        return false;
                    }
                }
                catch (AdminException adminException) {}
            }
        }
        return true;
    }

    private boolean is_app_name_OK(String string, LogRecord logRecord) {
        if (string.equalsIgnoreCase(logRecord.getAppKey()) || logRecord.getAppName().toLowerCase().lastIndexOf("computer") != -1 && string.toLowerCase().lastIndexOf("computer") != -1 || logRecord.getAppName().toLowerCase().lastIndexOf("user") != -1 && string.toLowerCase().lastIndexOf("user") != -1 || logRecord.getAppName().toLowerCase().lastIndexOf("mount") != -1 && string.toLowerCase().lastIndexOf("mount") != -1 || logRecord.getAppName().toLowerCase().lastIndexOf("serial") != -1 && string.toLowerCase().lastIndexOf("serial") != -1) {
            return true;
        }
        return !((!logRecord.getAppKey().equalsIgnoreCase("LM_SYS_APP_NAME") && logRecord.getAppKey().toLowerCase().lastIndexOf("cis") == -1 || this.category[0] != 2 && this.category[1] != 2 && this.category[2] != 2) && (!logRecord.getAppKey().equalsIgnoreCase("LM_SECURITY_APP_NAME") && logRecord.getAppKey().toLowerCase().lastIndexOf("security") == -1 || this.category[0] != 1 && this.category[1] != 1 && this.category[2] != 1));
    }

    public void setScope(String string) {
        if (string != null) {
            this.scopeName = string;
        }
    }
}

