/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryUtility;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.cis.service.directorytable.TableSetup;
import java.util.StringTokenizer;
import java.util.Vector;

public class DirectoryTableSetup
implements TableSetup {
    protected static final int NUM_OF_DIRSERVICES = 4;
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private static final String nssFileName = "/etc/nsswitch.conf";
    protected static final String[] dirServiceName = new String[]{"File", "Nis", "Nisplus", "Dns"};

    public Vector getNameServiceSwitchOrder(String string) {
        Vector<String> vector = null;
        boolean bl = false;
        String[] stringArray = new String[]{"sh", "-c", "/bin/grep '^" + string + ":' " + nssFileName + " | " + sedCmd + " 's/^" + string + "://'"};
        String[] stringArray2 = new String[]{"sh", "-c", "/bin/grep '^" + string + "_compat" + ":' " + nssFileName + " | " + sedCmd + " 's/^" + string + "_compat" + "://'"};
        String[] stringArray3 = AdminCommonTools.CMN_exec(stringArray);
        if (stringArray3 == null || stringArray3.length < 1) {
            return vector;
        }
        stringArray3[0].trim();
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray3[0], " \t\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            string2.trim();
            if (string2.equals("compat")) {
                if (vector == null) {
                    vector = new Vector<String>();
                }
                bl = this.compatPlusAtEndOfTable(string);
                String[] stringArray4 = AdminCommonTools.CMN_exec(stringArray2);
                if (stringArray4 == null || stringArray4.length < 1) {
                    vector.addElement("file");
                    if (bl) {
                        vector.addElement("nis");
                    }
                } else {
                    stringArray4[0].trim();
                    vector.addElement("file");
                    if (bl) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray4[0], " \t\n\r");
                        while (stringTokenizer2.hasMoreTokens()) {
                            String string3 = stringTokenizer2.nextToken();
                            string3.trim();
                            if (string3.equals("nis")) {
                                vector.addElement("nis");
                            }
                            if (!string3.equals("nisplus")) continue;
                            vector.addElement("nisplus");
                        }
                    }
                }
            }
            if (string2.equals("files")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("file");
            }
            if (string2.equals("nisplus")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("nisplus");
            }
            if (string2.equals("nis")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("nis");
            }
            if (string2.equals("dns")) {
                if (vector == null) {
                    vector = new Vector();
                }
                vector.addElement("dns");
            }
            if (string2.indexOf("NOTFOUND=return") == -1) continue;
            return vector;
        }
        return vector;
    }

    public Vector getScopes(String string, int n) {
        Vector vector = null;
        String string2 = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, string.length()).toLowerCase();
        String string3 = "com.sun.admin.cis.service.directorytable." + string2 + "DirectoryTable";
        try {
            TableSetup tableSetup = (TableSetup)Class.forName(string3).newInstance();
            if (tableSetup != null) {
                vector = tableSetup.getScopes(n);
            }
            tableSetup = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return vector;
    }

    public Vector getScopes(int n) {
        Vector vector = null;
        Vector<String> vector2 = null;
        if ((n & 1) == 1) {
            vector2 = this.getNameServiceSwitchOrder("passwd");
            if (vector2 == null) {
                return vector;
            }
        } else {
            vector2 = new Vector<String>(4);
            vector2.addElement("File");
            vector2.addElement("Nis");
            vector2.addElement("Nisplus");
            vector2.addElement("Dns");
        }
        int n2 = 0;
        while (n2 < vector2.size()) {
            String string = (String)vector2.elementAt(n2);
            Vector vector3 = this.getScopes(string = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, string.length()).toLowerCase(), n);
            if (vector3 != null) {
                if (vector == null) {
                    vector = new Vector();
                }
                int n3 = 0;
                while (n3 < vector3.size()) {
                    vector.addElement(vector3.elementAt(n3));
                    ++n3;
                }
            }
            ++n2;
        }
        return vector;
    }

    public boolean isValidScope(String string) {
        int n = 0;
        n = string.indexOf(":/");
        if (n == -1 || n < 2) {
            return false;
        }
        String string2 = String.valueOf(string.substring(0, 1).toUpperCase()) + string.substring(1, n).toLowerCase();
        if (string.length() <= n + 2) {
            return false;
        }
        String string3 = string.substring(n + 2);
        String string4 = DirectoryUtility.getContextProperty(string3, "serverName");
        String string5 = DirectoryUtility.getContextProperty(string3, "domainName");
        if (!DirectoryUtility.isLocalServer(string4)) {
            return false;
        }
        Vector vector = this.getScopes(0);
        if (vector.size() == 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string6;
            String string7 = (String)vector.elementAt(n2);
            n = string7.indexOf(":/");
            if (n != -1 && n >= 2 && (string6 = String.valueOf(string7.substring(0, 1).toUpperCase()) + string7.substring(1, n).toLowerCase()).equals(string2) && string7.length() > n + 2) {
                String string8 = string7.substring(n + 2);
                if (string6.equals("File")) {
                    return DirectoryUtility.isLocalServer(string5);
                }
                String string9 = DirectoryUtility.getContextProperty(string8, "domainName");
                if (string9.equals(string5)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public void setup() {
        int n = 0;
        while (n < 4) {
            String string = "com.sun.admin.cis.service.directorytable." + dirServiceName[n] + "DirectoryTable";
            try {
                TableSetup tableSetup = (TableSetup)Class.forName(string).newInstance();
                if (tableSetup != null) {
                    tableSetup.setup();
                }
                tableSetup = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n;
        }
    }

    public void refreshSetup() {
        int n = 0;
        while (n < 4) {
            String string = "com.sun.admin.cis.service.directorytable." + dirServiceName[n] + "DirectoryTable";
            try {
                TableSetup tableSetup = (TableSetup)Class.forName(string).newInstance();
                if (tableSetup != null) {
                    tableSetup.refreshSetup();
                }
                tableSetup = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n;
        }
    }

    private boolean compatPlusAtEndOfTable(String string) {
        boolean bl = false;
        try {
            String string2;
            DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance("File", "", "");
            TableDefinitions tableDefinitions = directoryTable.getTableDefinitionsInstance();
            tableDefinitions.loadTableDefinitions(string);
            try {
                directoryTable.open(tableDefinitions);
            }
            catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
                return bl;
            }
            DirectoryRow directoryRow = directoryTable.getAll();
            bl = directoryRow != null ? (string2 = directoryRow.getColumn(1, directoryRow.getNumberOfRows())).equals("+") : false;
            directoryTable.close();
            return bl;
        }
        catch (DirectoryTableException directoryTableException) {
            return bl;
        }
    }

    public static void main(String[] stringArray) {
        DirectoryTableSetup directoryTableSetup = new DirectoryTableSetup();
        if (stringArray[0].equals("initial")) {
            directoryTableSetup.setup();
            return;
        }
        if (stringArray[0].equals("refresh")) {
            directoryTableSetup.refreshSetup();
            return;
        }
        if (stringArray[0].equals("validate")) {
            if (directoryTableSetup.isValidScope(stringArray[1])) {
                System.out.println("Scope is valid");
                return;
            }
            System.out.println("Scope is not valid");
            return;
        }
        if (stringArray[0].equals("scopes")) {
            System.out.println("Getting list of managable scopes...");
            Vector vector = directoryTableSetup.getScopes(0);
            if (vector != null) {
                int n = 0;
                while (n < vector.size()) {
                    System.out.println("Scope " + (n + 1) + " " + vector.elementAt(n));
                    ++n;
                }
            }
        }
    }
}

