/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.server;

import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.common.FilterItem;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.service.directorytable.DirectoryFilter;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.usermgr.common.EmailAliasObj;
import com.sun.admin.usermgr.common.SolServerException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SolarisAliasesTable {
    private String table = new String("aliases");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String aliasCol = "alias";
    private String expansionCol = "expansion";
    private String commentCol = "comment";
    private AdminMgmtScope scope;

    public SolarisAliasesTable(AdminMgmtScope adminMgmtScope) {
        this.scope = adminMgmtScope;
    }

    public static String[] parseMembersIntoArray(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static String formatMembersIntoString(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private boolean isAliasesMember(String string, String string2) {
        if (string2 == null) {
            return false;
        }
        if (string2 == "") {
            return false;
        }
        String[] stringArray = SolarisAliasesTable.parseMembersIntoArray(string2);
        int n = 0;
        while (n < stringArray.length) {
            if (string.compareTo(stringArray[n]) == 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private DirectoryTable createAliasesTable() throws DirectoryTableException {
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
        directoryTable.create(this.table);
        return directoryTable;
    }

    private DirectoryTable openAliasesTable() throws DirectoryTableException, SolServerException {
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope.toDirectoryTableURL());
        directoryTable.open(this.table);
        return directoryTable;
    }

    public void addEmailRow(EmailAliasObj emailAliasObj) throws SolServerException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            directoryTable = this.openAliasesTable();
        }
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.aliasCol), emailAliasObj.getAliasName());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.expansionCol), emailAliasObj.getAliasExpansion());
            directoryTable.addRow(directoryRow);
            Object var4_6 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block7: {
                Object var4_7 = null;
                if (directoryTable == null) break block7;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    public void modifyEmailRow(EmailAliasObj emailAliasObj, String string) throws SolServerException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            directoryTable = this.openAliasesTable();
        }
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            if (string != null) {
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.aliasCol), string);
            } else {
                directoryRow.putColumn(tableDefinitions.getColumnNumber(this.aliasCol), emailAliasObj.getAliasName());
            }
            if (!string.equals(emailAliasObj.getAliasName())) {
                try {
                    this.getEmailRow(emailAliasObj.getAliasName());
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) {
                    throw new DirectoryTableRowNotUniqueException();
                }
            }
            if ((directoryRow = directoryTable.getFirstRow(directoryRow)) == null) {
                throw new SolServerException("EXM_SUS21", emailAliasObj.getAliasName());
            }
            DirectoryRow directoryRow2 = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.aliasCol), emailAliasObj.getAliasName());
            directoryRow2.putColumn(tableDefinitions.getColumnNumber(this.expansionCol), emailAliasObj.getAliasExpansion());
            directoryTable.modifyRow(directoryRow, directoryRow2);
            Object var6_9 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block14: {
                Object var6_10 = null;
                if (directoryTable == null) break block14;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    public void deleteEmailRow(EmailAliasObj emailAliasObj) throws SolServerException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            return;
        }
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.aliasCol), emailAliasObj.getAliasName());
            directoryRow = directoryTable.getFirstRow(directoryRow);
            if (directoryRow == null) {
                throw new SolServerException("EXM_SUS21", emailAliasObj.getAliasName());
            }
            directoryTable.deleteRow(directoryRow);
            Object var4_6 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            return;
        }
        catch (Throwable throwable) {
            block8: {
                Object var4_7 = null;
                if (directoryTable == null) break block8;
                directoryTable.close();
            }
            throw throwable;
        }
    }

    public Vector getAllAliasRows(ListProperties listProperties) throws SolServerException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        Vector<EmailAliasObj> vector = new Vector<EmailAliasObj>();
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
        }
        Vector vector2 = listProperties.getFilters();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryFilter directoryFilter = new DirectoryFilter(vector2.size());
            int n = 0;
            while (n < vector2.size()) {
                FilterItem filterItem = (FilterItem)vector2.elementAt(n);
                String string = filterItem.getAttribute();
                int n2 = 0;
                if (string.equals("filter_email_name")) {
                    n2 = tableDefinitions.getColumnNumber(this.aliasCol);
                } else if (string.equals("filter_email_members")) {
                    n2 = tableDefinitions.getColumnNumber(this.expansionCol);
                }
                directoryFilter.add(n2, filterItem.getBooleanOperator(), filterItem.getOperator(), filterItem.getValue());
                ++n;
            }
            DirectoryRow directoryRow = directoryTable.getAll(directoryFilter);
            if (directoryRow == null) {
                Vector<EmailAliasObj> vector3 = vector;
                Object var8_14 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                return vector3;
            }
            int n3 = 1;
            while (n3 <= directoryRow.getNumberOfRows()) {
                EmailAliasObj emailAliasObj = new EmailAliasObj();
                emailAliasObj.setAliasName(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.aliasCol), n3));
                emailAliasObj.setAliasExpansion(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.expansionCol), n3));
                vector.addElement(emailAliasObj);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var8_15 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public Vector getAllAliasRows() throws SolServerException, DirectoryTableException {
        Vector<EmailAliasObj> vector = new Vector<EmailAliasObj>();
        DirectoryTable directoryTable = this.openAliasesTable();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = directoryTable.getAll();
            if (directoryRow == null) {
                Vector<EmailAliasObj> vector2 = vector;
                Object var6_7 = null;
                if (directoryTable != null) {
                    directoryTable.close();
                }
                return vector2;
            }
            int n = 1;
            while (n <= directoryRow.getNumberOfRows()) {
                EmailAliasObj emailAliasObj = new EmailAliasObj();
                emailAliasObj.setAliasName(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.aliasCol), n));
                emailAliasObj.setAliasExpansion(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.expansionCol), n));
                String string = emailAliasObj.getAliasName();
                string = string.trim();
                if (string != null && !string.equals("")) {
                    vector.addElement(emailAliasObj);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        Object var6_8 = null;
        if (directoryTable != null) {
            directoryTable.close();
        }
        return vector;
    }

    public EmailAliasObj getEmailRow(String string) throws SolServerException, DirectoryTableException {
        DirectoryTable directoryTable = null;
        EmailAliasObj emailAliasObj = null;
        try {
            directoryTable = this.openAliasesTable();
        }
        catch (DirectoryTableException directoryTableException) {
            this.createAliasesTable();
            directoryTable = this.openAliasesTable();
        }
        if (string == null || string.equals("")) {
            return emailAliasObj;
        }
        emailAliasObj = new EmailAliasObj();
        try {
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
            directoryRow.putColumn(tableDefinitions.getColumnNumber(this.aliasCol), string);
            directoryRow = directoryTable.getFirstRow(directoryRow);
            if (directoryRow == null) {
                throw new SolServerException("EXM_SUS21", string);
            }
            emailAliasObj.setAliasName(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.aliasCol)));
            emailAliasObj.setAliasExpansion(directoryRow.getColumn(tableDefinitions.getColumnNumber(this.expansionCol)));
            Object var5_7 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (directoryTable != null) {
                directoryTable.close();
            }
            throw throwable;
        }
        return emailAliasObj;
    }
}

