/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.client.AdminClientComponent;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.usermgr.client.AdminMainTree;
import com.sun.admin.usermgr.client.AdminUserIconPane;
import com.sun.admin.usermgr.client.AdminUserTable;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.FindObj;
import com.sun.admin.usermgr.client.UMgrContextHelpListener;
import com.sun.admin.usermgr.client.UserMgrClient;
import com.sun.admin.usermgr.client.UserMgrHelp;
import com.sun.admin.usermgr.client.UserMgrMTB;
import com.sun.admin.usermgr.client.UserMgrStatus;
import com.sun.admin.usermgr.common.SGConstants;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;

public class AdminMainPanel
extends JPanel
implements AdminClientComponent {
    public UserMgrMTB userMgrMTB;
    public AdminUserIconPane adminUserIconPane;
    public AdminUserTable adminUserTable;
    public UserMgrHelp userMgrHelp;
    public UserMgrStatus userMgrStatus;
    UserMgrClient userMgrClient;
    protected JSplitPane lowerSplitPane;
    public AdminMainTree adminMainTree;
    JTree theTree;
    public JFrame jFrame;
    FindObj findObj;
    static AdminMainPanel instance;
    IClientComm clientComm;
    private static String baseDir;
    private Component activeComponent;

    public void appReceivingMainFocus() {
        if (this.theTree != null && this.theTree.getSelectionRows() != null) {
            this.clientComm.addToMainView(this);
        }
    }

    public void appLosingMainFocus() {
        this.adminMainTree.removeAllSelections();
    }

    public void appCloseDown() {
        if (UserMgrClient.instance().pdcSession != null) {
            try {
                UserMgrClient.instance().pdcSession.close();
                return;
            }
            catch (AdminException adminException) {
                AdminCommonTools.CMN_HandleOutput("Unable close Cascade Session");
                return;
            }
        }
    }

    public ImageIcon createImageIcon(String string, String string2) {
        ImageIcon imageIcon = null;
        String string3 = SGConstants.getUMgrImagesLocation();
        String string4 = this.clientComm.getImagePath();
        try {
            imageIcon = new ImageIcon(String.valueOf(string4) + string3 + "/" + string, string2);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Can't create image");
            AdminCommonTools.CMN_TraceStack(1, exception);
        }
        return imageIcon;
    }

    public Component getActiveComponent() {
        return this.activeComponent;
    }

    public void switchToIconPanel() {
        if (this.getActiveComponent() != this.adminUserIconPane) {
            this.remove(this.adminUserTable);
            this.invalidate();
            this.validate();
            this.repaint();
            this.activeComponent = this.adminUserIconPane;
            this.adminUserIconPane.iconPanel.setElements(null);
            AdminViews adminViews = AdminViews.instance();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            adminViews.setCurrentView(adminViews.getAncestorViewName(), adminViews.getCurrentViewName());
            this.add(this.adminUserIconPane, gridBagConstraints, -1);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void switchToDetailPanel() {
        if (this.getActiveComponent() != this.adminUserTable) {
            this.remove(this.adminUserIconPane);
            this.activeComponent = this.adminUserTable;
            AdminViews adminViews = AdminViews.instance();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            adminViews.setCurrentViewWithoutProgress(adminViews.getAncestorViewName(), adminViews.getCurrentViewName());
            this.add(this.adminUserTable, gridBagConstraints, -1);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void addHelpListener(GenInfoPanel genInfoPanel, Component component, String string) {
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                this.addHelpListener(genInfoPanel, componentArray[n], string);
                ++n;
            }
        }
        component.addFocusListener(new UMgrContextHelpListener(genInfoPanel, string));
    }

    public static AdminMainPanel sharedInstance() {
        return instance;
    }

    public static String getBaseDir() {
        return baseDir;
    }

    public String getHelpUrlString(String string, String string2) {
        return this.clientComm.getHelpUrl(string, string2);
    }

    public void doPopupMenu(Point point) {
        JMenuPlus jMenuPlus = null;
        if (AdminViews.instance().getCurrentViewName().equals(UMgrResourceStrings.getString("users"))) {
            jMenuPlus = this.userMgrMTB.userMenuBar.getActionMenu();
        }
        if (AdminViews.instance().getCurrentViewName().equals(UMgrResourceStrings.getString("groups"))) {
            jMenuPlus = this.userMgrMTB.groupMenuBar.getActionMenu();
        }
        if (AdminViews.instance().getCurrentViewName().equals(UMgrResourceStrings.getString("email"))) {
            jMenuPlus = this.userMgrMTB.emailMenuBar.getActionMenu();
        }
        if (jMenuPlus != null) {
            jMenuPlus.showPopupAt(this, point.x, point.y);
        }
    }

    private void initializeComponents() {
        AdminViews adminViews = AdminViews.instance();
        adminViews.initAdminViews();
        UserMgrClient userMgrClient = UserMgrClient.instance();
        userMgrClient.initUserMgrClient();
        FindObj findObj = FindObj.instance();
        findObj.initFindObj();
        this.userMgrMTB = null;
        this.adminUserIconPane = null;
        this.adminUserTable = null;
        this.adminMainTree = null;
        this.theTree = null;
        this.userMgrHelp = null;
        this.userMgrStatus = null;
        userMgrClient = UserMgrClient.instance();
        try {
            userMgrClient.setUpConnection(this.clientComm);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_TraceStack(1, exception);
        }
        this.userMgrMTB = new UserMgrMTB();
        this.adminUserIconPane = new AdminUserIconPane();
        this.adminUserTable = new AdminUserTable();
        this.adminMainTree = new AdminMainTree();
        this.theTree = this.adminMainTree.createTree();
        this.userMgrHelp = new UserMgrHelp();
        this.userMgrStatus = new UserMgrStatus();
        findObj = FindObj.instance();
        this.addMouseListener(new PanelMouseListener());
    }

    public AdminMainPanel(IClientComm iClientComm) {
        instance = this;
        this.clientComm = iClientComm;
        baseDir = iClientComm.getImagePath();
        this.jFrame = iClientComm.getFrame();
        this.initializeComponents();
        this.setBackground(SGConstants.getBackGroundColor());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.add(this.userMgrMTB, gridBagConstraints, -1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        this.add(this.adminUserIconPane, gridBagConstraints, -1);
        this.activeComponent = this.adminUserIconPane;
        iClientComm.addToTreePanel(this.theTree);
    }

    class PanelMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            AdminCommonTools.CMN_HandleOutput("In AdminMainPanel mouse clicked");
            if (!mouseEvent.isControlDown() && AdminViews.instance().getSelectedNodeNames().size() > 0 && AdminMainPanel.this.getActiveComponent() == AdminMainPanel.this.adminUserTable) {
                AdminViews.instance().removeAllSelectedNodes();
                AdminViews.instance().notifySelectionObservers();
                AdminMainPanel.this.adminUserTable.setSelections(null);
            }
            if (mouseEvent.isPopupTrigger()) {
                AdminMainPanel.this.doPopupMenu(mouseEvent.getPoint());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AdminCommonTools.CMN_HandleOutput(" In Mouse Released");
            if (!mouseEvent.isControlDown() && AdminViews.instance().getSelectedNodeNames().size() > 0 && AdminMainPanel.this.getActiveComponent() == AdminMainPanel.this.adminUserTable) {
                AdminViews.instance().removeAllSelectedNodes();
                AdminViews.instance().notifySelectionObservers();
                AdminMainPanel.this.adminUserTable.setSelections(null);
            }
            if (mouseEvent.isPopupTrigger()) {
                AdminMainPanel.this.doPopupMenu(mouseEvent.getPoint());
            }
        }

        PanelMouseListener() {
            AdminMainPanel.this = AdminMainPanel.this;
        }
    }
}

