/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.logviewer.client.LogVFilter;
import com.sun.admin.logviewer.client.LogVMainPanel;
import com.sun.admin.logviewer.common.LogVResourceStrings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class LogVToolBar
extends JPanel {
    private static final Color bgColor = Color.lightGray;
    private static final Font boldFont = new Font("Dialog", 1, 12);
    private static final Border raisedBorder = new BevelBorder(0);
    private static final Color FILTERON = Color.red;
    private LogVToolBar logVToolBar;
    ToolBarButton filterBtn;
    ToolBarButton refreshBtn;
    ToolBarButton propBtn;
    JLabel filter_string;
    JLabel nonfilter_string;
    LogVFilter logVFilter;
    public static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    private LogVMainPanel mainPanel;

    public LogVToolBar() {
        this.setLayout(new GridBagLayout());
        this.mainPanel = LogVMainPanel.instance();
        this.logVToolBar = this;
        this.filterBtn = new ToolBarButton("TBfilter", "FILTER");
        this.refreshBtn = new ToolBarButton("TBrefresh", "REFRESH");
        this.propBtn = new ToolBarButton("TBprop", "PROPERTIES");
        this.propBtn.setEnabled(false);
        Constraints.constrain(this, this.propBtn, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 5, 3, 0);
        Constraints.constrain(this, this.filterBtn, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 5, 3, 0);
        Constraints.constrain(this, this.refreshBtn, 2, 0, 1, 1, 0, 17, 0.0, 0.0, 2, 2, 3, 0);
        JPanel jPanel = new JPanel();
        Constraints.constrain(this, jPanel, 3, 0, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
        this.filter_string = new JLabel();
        this.filter_string.setForeground(FILTERON);
        Constraints.constrain(this, this.filter_string, 4, 0, 1, 1, 0, 13, 0.0, 0.0, 2, 5, 3, 5);
    }

    public void displayFilterString() {
        if (LogVMainPanel.instance().getLogPanel().getFilterState()) {
            this.filter_string.setText(LogVResourceStrings.getString("filter_lbl"));
        } else {
            this.filter_string.setText("");
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public JButton getPropBtn() {
        return this.propBtn;
    }

    public JButton getFilterBtn() {
        return this.filterBtn;
    }

    public JButton getRefreshBtn() {
        return this.refreshBtn;
    }

    class ToolBarButton
    extends JButton {
        private ImageIcon enabledIcon;
        private Border defaultBorder;

        public ToolBarButton(String string) {
            this(string, "undefined");
        }

        public ToolBarButton(String string, String string2) {
            LogVToolBar.this = LogVToolBar.this;
            this.enabledIcon = LogVMainPanel.instance().loadImageIcon(LogVResourceStrings.getString(String.valueOf(string) + "EnabledGif"), string);
            if (this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(LogVResourceStrings.getString(string));
            }
            this.setBorderPainted(true);
            this.defaultBorder = this.getBorder();
            this.setFocusPainted(false);
            this.setActionCommand(string2);
            this.setToolTipText(LogVResourceStrings.getString(String.valueOf(string) + "Tooltip"));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(new TButtonListener());
        }

        class TButtonListener
        implements ActionListener {
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == ((ToolBarButton)ToolBarButton.this).LogVToolBar.this.propBtn) {
                    LogVMainPanel.instance().getLogPanel().displayDetails();
                }
                if (actionEvent.getSource() == ((ToolBarButton)ToolBarButton.this).LogVToolBar.this.filterBtn) {
                    if (((ToolBarButton)ToolBarButton.this).LogVToolBar.this.logVFilter == null) {
                        LogVMainPanel.instance().getLogPanel().logVFilter = ((ToolBarButton)ToolBarButton.this).LogVToolBar.this.logVFilter = new LogVFilter((Frame)LogVMainPanel.getFrame(), LogVMainPanel.instance().getLogPanel());
                    }
                    ((Component)((ToolBarButton)ToolBarButton.this).LogVToolBar.this.logVFilter).setLocation(LogVToolBar.screenSize.width / 2 - ((ToolBarButton)ToolBarButton.this).LogVToolBar.this.logVFilter.getSize().width / 2, LogVToolBar.screenSize.height / 2 - ((ToolBarButton)ToolBarButton.this).LogVToolBar.this.logVFilter.getSize().height / 2);
                    ((Component)((ToolBarButton)ToolBarButton.this).LogVToolBar.this.logVFilter).setVisible(true);
                    return;
                }
                if (actionEvent.getSource() == ((ToolBarButton)ToolBarButton.this).LogVToolBar.this.refreshBtn) {
                    LogVMainPanel.instance().getLogPanel().refresh();
                }
            }

            TButtonListener() {
                ToolBarButton.this = ToolBarButton.this;
            }
        }
    }
}

