/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.HostActionsListener;
import com.sun.admin.hostmgr.client.HostMgrTreeEvent;
import com.sun.admin.hostmgr.client.HostMgrTreeListener;
import com.sun.admin.hostmgr.client.ListView;
import com.sun.admin.hostmgr.client.ListViewEvent;
import com.sun.admin.hostmgr.client.ListViewListener;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.client.NetworkContentPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class MainToolBar
extends JPanel {
    private ToolBarButton tbNewHost;
    private ToolBarButton tbNewNetwork;
    private ToolBarButton tbProperties;
    private ToolBarButton tbDelete;
    private ToolBarButton tbFind;
    private ToolBarButton tbFilter;
    private ToolBarButton tbIconView;
    private ToolBarButton tbTableView;
    private ListViewListener listViewListener;
    private ContentPanel contentPanel;
    private int newButtonPosition;
    private final int groupGap = 9;
    HostActionsListener buttonClickListener = new HostActionsListener();

    public MainToolBar() {
        this.setLayout(new GridBagLayout());
        this.tbNewHost = new ToolBarButton("TBNewHost", "New");
        Constraints.constrain(this, this.tbNewHost, -1, 0, 1, 1, 2, 5, 3, 0);
        this.newButtonPosition = 0;
        this.tbNewNetwork = new ToolBarButton("TBNewNetwork", "New");
        this.tbProperties = new ToolBarButton("TBProperties", "ViewProps");
        Constraints.constrain(this, this.tbProperties, -1, 0, 1, 1, 2, 2, 3, 0);
        Constraints.constrain(this, new Box.Filler(new Dimension(9, 1), new Dimension(9, 1), new Dimension(9, 1)), -1, 0, 1, 1);
        this.tbFind = new ToolBarButton("TBFind", "Find");
        Constraints.constrain(this, this.tbFind, -1, 0, 1, 1, 2, 2, 3, 0);
        this.tbFilter = new ToolBarButton("TBFilter", "Filter");
        Constraints.constrain(this, this.tbFilter, -1, 0, 1, 1, 2, 2, 3, 0);
        Constraints.constrain(this, new Box.Filler(new Dimension(9, 1), new Dimension(9, 1), new Dimension(9, 1)), -1, 0, 1, 1);
        this.tbDelete = new ToolBarButton("TBDelete", "Delete");
        Constraints.constrain(this, this.tbDelete, -1, 0, 1, 1, 2, 2, 3, 0);
        Constraints.constrain(this, new Box.Filler(new Dimension(9, 1), new Dimension(9, 1), new Dimension(9, 1)), -1, 0, 1, 1);
        this.tbIconView = new ToolBarButton("TBIconView", "ViewIcons");
        Constraints.constrain(this, this.tbIconView, -1, 0, 1, 1, 2, 2, 3, 0);
        this.tbTableView = new ToolBarButton("TBTableView", "ViewDetails");
        Constraints.constrain(this, this.tbTableView, -1, 0, 1, 1, 2, 2, 3, 5);
        Constraints.constrain(this, new Box.Filler(new Dimension(9, 1), new Dimension(9, 1), new Dimension(9, 1)), -1, 0, 1, 1);
        Constraints.constrain(this, new ToolBarButton("TBRefresh", "Refresh"), -1, 0, 1, 1, 2, 2, 3, 0);
        Constraints.constrain(this, new Box.Filler(new Dimension(1, 1), new Dimension(1, 1), new Dimension(1, 1)), -1, 0, 0, 1, 2, 17, 1.0, 0.0, 2, 0, 3, 0);
        this.listViewListener = new 1();
        this.contentPanel = Main.getApp().getTree().getCurrentContentPanel();
        this.contentPanel.addListViewListener(this.listViewListener);
        this.configureForContent();
        Main.getApp().getTree().addHostMgrTreeListener(new 2());
    }

    private void configureForContent() {
        if (this.contentPanel.hasViewType(1)) {
            this.tbIconView.setEnabled(true);
        } else {
            this.tbIconView.setEnabled(false);
        }
        if (this.contentPanel.hasViewType(2)) {
            this.tbTableView.setEnabled(true);
        } else {
            this.tbTableView.setEnabled(false);
        }
        this.tbFilter.setEnabled(this.contentPanel.isFilteringSupported());
        this.remove(this.newButtonPosition);
        Component component = this.getComponent(this.newButtonPosition);
        component.setCursor(Cursor.getDefaultCursor());
        GridBagConstraints gridBagConstraints = ((GridBagLayout)this.getLayout()).getConstraints(component);
        if (this.contentPanel instanceof NetworkContentPanel) {
            this.add(this.tbNewNetwork, gridBagConstraints, 0);
        } else {
            this.add(this.tbNewHost, gridBagConstraints, 0);
        }
        Vector vector = Main.getApp().getHostMgr().getUserRights();
        if (!vector.contains("solaris.admin.hostmgr.write")) {
            this.tbNewHost.setEnabled(false);
            this.tbNewNetwork.setEnabled(false);
            this.tbDelete.setEnabled(false);
        }
    }

    private void showIconView() {
        this.tbIconView.showAsDepressed();
        if (this.tbTableView.isEnabled()) {
            this.tbTableView.showAsEnabled();
        }
    }

    private void showTableView() {
        this.tbTableView.showAsDepressed();
        if (this.tbIconView.isEnabled()) {
            this.tbIconView.showAsEnabled();
        }
    }

    private void notifySelectionChange(int n) {
        if (n == 1) {
            this.tbProperties.setEnabled(true);
        } else {
            this.tbProperties.setEnabled(false);
        }
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        this.tbDelete.setEnabled(bl);
        Vector vector = Main.getApp().getHostMgr().getUserRights();
        if (!vector.contains("solaris.admin.hostmgr.write")) {
            this.tbNewHost.setEnabled(false);
            this.tbNewNetwork.setEnabled(false);
            this.tbDelete.setEnabled(false);
        }
    }

    private final class 1
    implements ListViewListener {
        public void itemPressed(ListViewEvent listViewEvent) {
            ListView listView = listViewEvent.getSource();
            MainToolBar.this.notifySelectionChange(listView.getNumSelections());
        }

        public void viewChanged(ListViewEvent listViewEvent) {
            if (listViewEvent.getViewType() == 1) {
                MainToolBar.this.showIconView();
            }
            if (listViewEvent.getViewType() == 2) {
                MainToolBar.this.showTableView();
            }
        }

        public void sortChanged(ListViewEvent listViewEvent) {
        }

        public void popupTriggered(ListViewEvent listViewEvent) {
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements HostMgrTreeListener {
        public void contentPanelChanged(HostMgrTreeEvent hostMgrTreeEvent) {
            MainToolBar.this.contentPanel.removeListViewListener(MainToolBar.this.listViewListener);
            MainToolBar.this.contentPanel = hostMgrTreeEvent.getContentPanel();
            MainToolBar.this.contentPanel.addListViewListener(MainToolBar.this.listViewListener);
            MainToolBar.this.configureForContent();
        }

        /* synthetic */ 2() {
        }
    }

    class ToolBarButton
    extends JButton {
        private ImageIcon enabledIcon;
        private Border defaultBorder;

        public ToolBarButton(String string) {
            this(string, "undefined");
        }

        public ToolBarButton(String string, String string2) {
            MainToolBar.this = MainToolBar.this;
            Main main = Main.getApp();
            ResourceBundle resourceBundle = main.getResourceBundle();
            this.enabledIcon = main.loadImageIcon(ResourceStrings.getString(resourceBundle, String.valueOf(string) + "EnabledGif"), string);
            if (this.enabledIcon.getIconHeight() != -1) {
                this.setIcon(this.enabledIcon);
            } else {
                this.setText(ResourceStrings.getString(resourceBundle, string));
            }
            this.setBorderPainted(true);
            this.defaultBorder = this.getBorder();
            this.setFocusPainted(false);
            this.setActionCommand(string2);
            this.setToolTipText(ResourceStrings.getString(resourceBundle, String.valueOf(string) + "Tooltip"));
            this.setMargin(new Insets(0, 0, 0, 0));
            this.addActionListener(MainToolBar.this.buttonClickListener);
        }

        public void showAsDepressed() {
            this.setBorder(BorderFactory.createBevelBorder(1));
        }

        public void showAsEnabled() {
            this.setBorder(this.defaultBorder);
            this.setEnabled(true);
        }
    }
}

