/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.Constraints;
import com.sun.admin.hostmgr.client.ListView;
import com.sun.admin.hostmgr.client.ListViewListener;
import com.sun.admin.hostmgr.client.Main;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class ContentPanel
extends JPanel {
    private static Vector instances = new Vector();
    private static int defaultViewType = 1;
    private Vector vViews = new Vector();
    private ListView currentView;
    protected boolean bRefresh = false;
    protected DefaultMutableTreeNode treeNode;
    protected Vector vDataCache = new Vector();

    public abstract void refresh();

    public abstract void createProperties();

    public abstract void viewProperties();

    public abstract void deleteSelected();

    public void renameSelected() {
    }

    public abstract String whatAmI();

    protected abstract void updateStatusBar();

    public String[] getFilterAttributes() {
        return null;
    }

    public Vector getFilters() {
        return null;
    }

    public boolean isFilteringSupported() {
        return false;
    }

    public boolean isShowByTypeSupported() {
        return false;
    }

    public void setFilters(Vector vector) {
    }

    public void showByType() {
    }

    public ContentPanel() {
        this.setLayout(new GridBagLayout());
        instances.addElement(this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.die();
    }

    public void die() {
        instances.removeElement(this);
    }

    public static int getNumInstances() {
        return instances.size();
    }

    public static ContentPanel getInstance(int n) {
        if (n < 0 || n >= instances.size()) {
            return null;
        }
        return (ContentPanel)instances.elementAt(n);
    }

    public static void broadcastView(int n) {
        int n2 = n;
        1 var2_2 = new 1(n2);
        var2_2.start();
    }

    public static void broadcastUpdate(Object object, Object object2, boolean bl) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object2 == null && !bl) {
            return;
        }
        int n = 0;
        while (n < instances.size()) {
            ContentPanel contentPanel = (ContentPanel)instances.elementAt(n);
            if (contentPanel.isRefreshed()) {
                if (object != null && object2 != null) {
                    contentPanel.offerDelete(object, false);
                    contentPanel.offerNew(object2, false);
                } else if (object == null && object2 != null) {
                    contentPanel.offerNew(object2, false);
                } else {
                    contentPanel.offerDelete(object, false);
                }
            }
            ++n;
        }
    }

    public abstract boolean offerNew(Object var1, boolean var2);

    public abstract boolean offerDelete(Object var1, boolean var2);

    public void addView(ListView listView) {
        this.vViews.addElement(listView);
        listView.setDataCache(this.vDataCache);
        if (this.currentView == null) {
            this.currentView = listView;
        }
        this.setViewType(defaultViewType);
    }

    public void setTreeNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.treeNode = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    public boolean hasViewType(int n) {
        int n2 = 0;
        while (n2 < this.vViews.size()) {
            ListView listView = (ListView)this.vViews.elementAt(n2);
            if (listView.getViewType() == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setViewType(int n) {
        int n2 = 0;
        while (n2 < this.vViews.size()) {
            ListView listView = (ListView)this.vViews.elementAt(n2);
            if (listView.getViewType() == n) {
                this.currentView = listView;
                return;
            }
            ++n2;
        }
    }

    public Vector getDataCache() {
        return this.vDataCache;
    }

    public ListView getCurrentView() {
        return this.currentView;
    }

    public void clear() {
        this.getDataCache().removeAllElements();
        System.gc();
        this.repaintView();
        this.bRefresh = true;
    }

    public void repaintView() {
        this.setView(this.currentView);
    }

    public boolean isRefreshed() {
        return this.bRefresh;
    }

    private void setView(ListView listView) {
        this.removeAll();
        listView.populate();
        this.currentView = listView;
        Constraints.constrain(this, listView, 0, 0, 1, 1, 1, 18, 1.0, 1.0, 0, 0, 0, 0);
        this.invalidate();
        this.validate();
        this.repaint();
        this.currentView.clearSelection();
        this.currentView.fireViewChanged();
        this.updateStatusBar();
    }

    public void addListViewListener(ListViewListener listViewListener) {
        int n = 0;
        while (n < this.vViews.size()) {
            ListView listView = (ListView)this.vViews.elementAt(n);
            listView.addListViewListener(listViewListener);
            ++n;
        }
    }

    public void removeListViewListener(ListViewListener listViewListener) {
        int n = 0;
        while (n < this.vViews.size()) {
            ListView listView = (ListView)this.vViews.elementAt(n);
            listView.removeListViewListener(listViewListener);
            ++n;
        }
    }

    static /* synthetic */ int access$0() {
        return defaultViewType;
    }

    private static final class 1
    extends Thread {
        private final /* synthetic */ int val$viewType;

        public void run() {
            Main.getApp().getClientComm().waitOn();
            defaultViewType = this.val$viewType;
            int n = 0;
            while (n < instances.size()) {
                ContentPanel contentPanel = (ContentPanel)instances.elementAt(n);
                ListView listView = contentPanel.getCurrentView();
                int n2 = contentPanel.getCurrentView().getViewType();
                contentPanel.setViewType(this.val$viewType);
                if (Main.getApp().getTree().getCurrentContentPanel() == contentPanel && n2 != this.val$viewType) {
                    Vector vector = listView.getSelected();
                    contentPanel.repaintView();
                    contentPanel.getCurrentView().setSelected(vector);
                }
                ++n;
            }
            Main.getApp().getClientComm().waitOff();
        }

        /* synthetic */ 1(int n) {
            this.val$viewType = n;
        }
    }
}

