/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.server;

import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.FileDirectoryTable;
import com.sun.admin.cis.service.directorytable.FileTableDefinitions;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.fsmgr.common.FsMgrMount;
import com.sun.admin.fsmgr.server.FsMgrFactoryImpl;
import com.sun.admin.fsmgr.server.FsMgrMountInterface;
import java.util.Vector;

public class FsMgrVfsTable
implements FsMgrMountInterface {
    public static final String VFSTAB = new String("vfstab");
    private static final String MOUNTTAB = new String("mounttab");
    private static String resource = new String("resource");
    private static String fsckDevice = new String("fsckDevice");
    private static String mountPoint = new String("mountPoint");
    private static String fsType = new String("fsType");
    private static String fsckPass = new String("fsckPass");
    private static String bootMount = new String("bootMount");
    private static String options = new String("options");
    private int resourceColumn;
    private int fsckDeviceColumn;
    private int mountPointColumn;
    private int fsTypeColumn;
    private int fsckPassColumn;
    private int bootMountColumn;
    private int optionsColumn;
    private static final String fileType = new String("File");
    private static final String emptyString = new String("");
    private static final String DASH = new String("-");
    private static final String NO = new String("no");
    private FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
    private FsMgrFactoryImpl factoryImpl;

    public FsMgrVfsTable(FsMgrFactoryImpl fsMgrFactoryImpl) throws DirectoryTableException {
        this.factoryImpl = fsMgrFactoryImpl;
        this.fileTableDefinitions.loadTableDefinitions(MOUNTTAB);
        this.resourceColumn = this.fileTableDefinitions.getColumnNumber(resource);
        this.fsckDeviceColumn = this.fileTableDefinitions.getColumnNumber(fsckDevice);
        this.mountPointColumn = this.fileTableDefinitions.getColumnNumber(mountPoint);
        this.fsTypeColumn = this.fileTableDefinitions.getColumnNumber(fsType);
        this.fsckPassColumn = this.fileTableDefinitions.getColumnNumber(fsckPass);
        this.bootMountColumn = this.fileTableDefinitions.getColumnNumber(bootMount);
        this.optionsColumn = this.fileTableDefinitions.getColumnNumber(options);
    }

    public Vector list() throws DirectoryTableException {
        DirectoryTable directoryTable = this.openMountTable();
        Vector<FsMgrMount> vector = new Vector<FsMgrMount>();
        try {
            DirectoryRow directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                FsMgrMount fsMgrMount = this.parseMountEntry(directoryRow);
                if (fsMgrMount != null) {
                    FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
                    fsMgrMount.setRawString(fileDirectoryTable.getRowAsString(directoryRow, 1));
                    vector.addElement(fsMgrMount);
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
        return vector;
    }

    public FsMgrMount getMountEntry(String string, String string2) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openMountTable();
        DirectoryRow directoryRow = null;
        FsMgrMount fsMgrMount = null;
        try {
            directoryRow = directoryTable.getFirstRow();
            while (directoryRow != null) {
                fsMgrMount = this.parseMountEntry(directoryRow);
                if (fsMgrMount != null) {
                    if (string.equals(fsMgrMount.getResource()) && string2.equals(fsMgrMount.getMountPoint())) {
                        FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
                        fsMgrMount.setRawString(fileDirectoryTable.getRowAsString(directoryRow, 1));
                        break;
                    }
                    fsMgrMount = null;
                }
                directoryRow = directoryTable.getNextRow();
            }
            directoryTable.close();
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
        return fsMgrMount;
    }

    public void addMount(FsMgrMount fsMgrMount, SecurityToken securityToken) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openMountTable();
        try {
            DirectoryRow directoryRow = this.makeRow(directoryTable, fsMgrMount);
            directoryTable.addRow(directoryRow);
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    public void removeMount(FsMgrMount fsMgrMount, SecurityToken securityToken) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openMountTable();
        try {
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
            fileDirectoryTable.parseStringIntoRow(fsMgrMount.getRawString(), directoryRow, 1);
            directoryTable.deleteRow(directoryRow);
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    public void modifyMount(FsMgrMount fsMgrMount, FsMgrMount fsMgrMount2, SecurityToken securityToken) throws DirectoryTableException {
        DirectoryTable directoryTable = this.openMountTable();
        try {
            DirectoryRow directoryRow = directoryTable.getRowInstance();
            FileDirectoryTable fileDirectoryTable = (FileDirectoryTable)directoryTable;
            fileDirectoryTable.parseStringIntoRow(fsMgrMount.getRawString(), directoryRow, 1);
            DirectoryRow directoryRow2 = this.makeRow(directoryTable, fsMgrMount2);
            directoryTable.modifyRow(directoryRow, directoryRow2);
            directoryTable.close();
            return;
        }
        catch (DirectoryTableException directoryTableException) {
            directoryTable.close();
            throw directoryTableException;
        }
    }

    private DirectoryTable openMountTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(fileType, emptyString, emptyString);
        directoryTable.open(MOUNTTAB);
        return directoryTable;
    }

    private DirectoryRow makeRow(DirectoryTable directoryTable, FsMgrMount fsMgrMount) throws DirectoryTableException {
        String string;
        String string2;
        DirectoryRow directoryRow = directoryTable.getRowInstance();
        String string3 = fsMgrMount.getResource();
        String string4 = fsMgrMount.getFsckDevice();
        if (string4 == null || string4.trim().length() == 0) {
            string4 = DASH;
        }
        String string5 = fsMgrMount.getMountPoint();
        String string6 = fsMgrMount.getFsType();
        String string7 = fsMgrMount.getFsckPass();
        if (string7 == null || string7.trim().length() == 0) {
            string7 = DASH;
        }
        if ((string2 = fsMgrMount.getBootMount()) == null || string2.trim().length() == 0) {
            string2 = NO;
        }
        if ((string = fsMgrMount.getOptions()) == null || string.trim().length() == 0) {
            string = DASH;
        }
        directoryRow.putColumn(this.resourceColumn, string3);
        directoryRow.putColumn(this.fsckDeviceColumn, string4);
        directoryRow.putColumn(this.mountPointColumn, string5);
        directoryRow.putColumn(this.fsTypeColumn, string6);
        directoryRow.putColumn(this.fsckPassColumn, string7);
        directoryRow.putColumn(this.bootMountColumn, string2);
        directoryRow.putColumn(this.optionsColumn, string);
        return directoryRow;
    }

    private FsMgrMount parseMountEntry(DirectoryRow directoryRow) throws DirectoryTableException {
        String string = directoryRow.getColumn(this.resourceColumn);
        String string2 = directoryRow.getColumn(this.fsckDeviceColumn);
        String string3 = directoryRow.getColumn(this.mountPointColumn);
        String string4 = directoryRow.getColumn(this.fsTypeColumn);
        String string5 = directoryRow.getColumn(this.fsckPassColumn);
        String string6 = directoryRow.getColumn(this.bootMountColumn);
        String string7 = directoryRow.getColumn(this.optionsColumn);
        FsMgrMount fsMgrMount = new FsMgrMount(string, string2, string3, string4, string5, string6, string7);
        return fsMgrMount;
    }
}

