/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.mount;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.mount.FsMgrMountData;

public class MountCacheEntry {
    private FsMgrMountData nowData;
    private FsMgrMountData bootData;
    public static final String NOW = FsMgrResourceStrings.getString("now");
    public static final String ATBOOT = FsMgrResourceStrings.getString("atboot");
    public static final String BOTH = FsMgrResourceStrings.getString("both");
    public static final String NOTMOUNTED = FsMgrResourceStrings.getString("not_mounted");
    public static final String CONFLICT = FsMgrResourceStrings.getString("conflict");
    private static final String COMMA = new String(", ");
    private static final String DASH = new String("-");
    private static final String READONLY = FsMgrResourceStrings.getString("read_only");
    private static final String READWRITE = FsMgrResourceStrings.getString("read_write");

    public MountCacheEntry(FsMgrMountData fsMgrMountData, FsMgrMountData fsMgrMountData2) {
        this.bootData = fsMgrMountData;
        this.nowData = fsMgrMountData2;
    }

    public void setNowData(FsMgrMountData fsMgrMountData) {
        this.nowData = fsMgrMountData;
    }

    public FsMgrMountData getNowData() {
        return this.nowData;
    }

    public void setBootData(FsMgrMountData fsMgrMountData) {
        this.bootData = fsMgrMountData;
    }

    public FsMgrMountData getBootData() {
        return this.bootData;
    }

    public String getResource() {
        if (this.nowData != null) {
            return this.nowData.getResource();
        }
        return this.bootData.getResource();
    }

    public String getMountPoint() {
        if (this.nowData != null) {
            return this.nowData.getMountPoint();
        }
        return this.bootData.getMountPoint();
    }

    public String getType() {
        FsMgrMountData fsMgrMountData = null;
        String string = null;
        if (this.nowData != null) {
            fsMgrMountData = this.nowData;
        } else if (this.bootData != null) {
            fsMgrMountData = this.bootData;
        } else {
            AdminCommonTools.CMN_HandleOutput("getAccess(): Illegal MountCacheEntry object");
            return string;
        }
        string = this.isConflict() && !this.nowData.getFsType().equals(this.bootData.getFsType()) ? DASH : fsMgrMountData.getFsType();
        return string;
    }

    public String getAccess() {
        FsMgrMountData fsMgrMountData = null;
        String string = null;
        if (this.nowData != null) {
            fsMgrMountData = this.nowData;
        } else if (this.bootData != null) {
            fsMgrMountData = this.bootData;
        } else {
            AdminCommonTools.CMN_HandleOutput("getAccess(): Illegal MountCacheEntry object");
            return string;
        }
        if (this.isConflict() && !this.nowData.equalAccess(this.bootData)) {
            string = DASH;
        } else if (fsMgrMountData.isRw()) {
            string = READWRITE;
        } else if (fsMgrMountData.isRo()) {
            string = READONLY;
        } else {
            AdminCommonTools.CMN_HandleOutput("getAccess(): Illegal MountCacheEntry object");
        }
        return string;
    }

    public FsMgrMountData getData(String string) {
        FsMgrMountData fsMgrMountData = null;
        if (string.equals(BOTH) && this.nowData != null && this.bootData != null && !this.isConflict()) {
            fsMgrMountData = this.bootData;
        } else if (string.equals(NOW)) {
            fsMgrMountData = this.nowData;
        } else if (string.equals(ATBOOT)) {
            fsMgrMountData = this.bootData;
        } else {
            AdminCommonTools.CMN_HandleOutput("Invalid data type specified in MountCacheEntry.getData()");
        }
        return fsMgrMountData;
    }

    public String getTable(String string) {
        String string2 = null;
        if (string.equals(NOW)) {
            string2 = FsMgrMountData.MOUNTTAB;
        } else if (string.equals(ATBOOT)) {
            string2 = FsMgrMountData.VFSTAB;
        } else {
            AdminCommonTools.CMN_HandleOutput("Invalid data type specified in MountCacheEntry.getTable()");
        }
        return string2;
    }

    public String[] getTableArray(String string) {
        String[] stringArray = null;
        if (string.equals(BOTH)) {
            stringArray = FsMgrMountData.MOUNTBOTH_ARRAY;
        } else if (string.equals(NOW)) {
            stringArray = FsMgrMountData.MOUNTTAB_ARRAY;
        } else if (string.equals(ATBOOT)) {
            stringArray = FsMgrMountData.VFSTAB_ARRAY;
        } else {
            AdminCommonTools.CMN_HandleOutput("Invalid data type specified in MountCacheEntry.getData()");
        }
        return stringArray;
    }

    public String getStatus() {
        String string = null;
        if (this.isConflict()) {
            string = CONFLICT;
        } else if (this.nowData != null && this.bootData != null) {
            string = BOTH;
        } else if (this.nowData != null) {
            string = NOW;
        } else if (this.bootData != null) {
            string = ATBOOT;
        }
        return string;
    }

    public String getStatusString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this.isConflict()) {
            stringBuffer.append(CONFLICT);
        } else {
            if (this.nowData != null) {
                stringBuffer.append(NOW);
                stringBuffer.append(COMMA);
            }
            if (this.bootData != null) {
                if (this.bootData.isSpecial() || !this.bootData.getBootMount().equals(FsMgrMountData.NO)) {
                    stringBuffer.append(ATBOOT);
                    stringBuffer.append(COMMA);
                } else if (this.nowData == null) {
                    stringBuffer.append(NOTMOUNTED);
                    stringBuffer.append(COMMA);
                }
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.setLength(stringBuffer.length() - 2);
            }
        }
        return stringBuffer.toString();
    }

    public boolean isConflict() {
        if (this.nowData == null || this.bootData == null) {
            return false;
        }
        return !this.nowData.equals(this.bootData);
    }
}

