/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.ClientSecurityContext;
import com.sun.admin.cis.service.security.ConfirmSecurityToken;
import com.sun.admin.cis.service.security.ResponseSecurityToken;
import com.sun.admin.cis.service.security.SecurityIdentifier;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import com.sun.admin.cis.service.security.WeakAuthFlavor;
import com.sun.admin.cis.service.security.WeakRequestSecurityToken;

public class WeakClientSecurityContext
extends ClientSecurityContext {
    public WeakClientSecurityContext() throws AdminSecurityException {
        super(new WeakAuthFlavor());
    }

    public SecurityToken generateRequest() throws AdminSecurityException {
        AdminPrincipal adminPrincipal = this.getAdminPrincipal();
        String string = this.getUserPassword();
        if (adminPrincipal == null || string == null) {
            throw new AdminSecurityException("EXSS_NUI");
        }
        AdminCommonTools.CMN_Trace3("Security service: generate authentication request");
        WeakRequestSecurityToken weakRequestSecurityToken = new WeakRequestSecurityToken(adminPrincipal);
        weakRequestSecurityToken.setUserPassword(this.encryptPswd(string));
        this.setAuthState(1);
        this.setSecurityToken(weakRequestSecurityToken);
        return weakRequestSecurityToken;
    }

    public SecurityToken verifyResponse(ResponseSecurityToken responseSecurityToken) throws AdminSecurityException {
        SecurityToken securityToken = null;
        if (securityToken == null) {
            throw new AdminSecurityException("EXSS_NVR");
        }
        return securityToken;
    }

    public SecurityToken verifyConfirm(ConfirmSecurityToken confirmSecurityToken) throws AdminSecurityException {
        if (confirmSecurityToken.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_BCT");
        }
        this.setSecurityId(confirmSecurityToken.getSecurityId());
        this.setAuthState(4);
        this.setSecurityToken(confirmSecurityToken);
        return confirmSecurityToken;
    }

    public SecurityToken generateVerifier(Object[] objectArray) throws AdminSecurityException {
        if (this.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_VBA");
        }
        SecurityIdentifier securityIdentifier = this.getSecurityId();
        VerifierSecurityToken verifierSecurityToken = new VerifierSecurityToken(0, securityIdentifier);
        return verifierSecurityToken;
    }

    public byte[] encryptPassword(String string) throws AdminSecurityException {
        if (this.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_NAX", "encryptPassword");
        }
        return this.encryptPswd(string);
    }

    public ClientSecurityContext newCopy() throws AdminSecurityException {
        WeakClientSecurityContext weakClientSecurityContext = new WeakClientSecurityContext();
        super.copyAttrs(weakClientSecurityContext);
        return weakClientSecurityContext;
    }

    private byte[] encryptPswd(String string) throws AdminSecurityException {
        int n;
        if (string == null || (n = string.trim().length()) == 0 || n > 16) {
            throw new AdminSecurityException("EXSS_BUP");
        }
        byte[] byArray = "pAsSwOrDsEcUrItY".getBytes();
        byte[] byArray2 = string.getBytes();
        n = 0;
        while (n < byArray2.length) {
            int n2 = n;
            byArray[n2] = (byte)(byArray[n2] ^ byArray2[n]);
            ++n;
        }
        if (n < 16) {
            int n3 = n;
            byArray[n3] = (byte)(byArray[n3] ^ 0);
        }
        return byArray;
    }
}

