/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminMgmtScope;
import com.sun.admin.cis.server.AdminServerLibrary;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactoryImpl;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.AuthenticationFlavor;
import com.sun.admin.cis.service.security.AuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.RequestSecurityToken;
import com.sun.admin.cis.service.security.SecurityContext;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.cis.service.security.VerifierSecurityToken;
import java.net.InetAddress;
import java.util.Vector;

public abstract class ServerSecurityContext
extends SecurityContext {
    private boolean msgVerify = false;
    private long clientVers = 0L;
    private String clientHost = null;
    private AdminMgmtScope mgmtScope = null;
    private UserAttrObj userAuth;
    private LogServiceFactoryImpl logsvc;

    public ServerSecurityContext(AuthenticationFlavor authenticationFlavor) throws AdminSecurityException {
        super(authenticationFlavor);
        this.setAuthState(0);
    }

    public abstract ServerSecurityContext newCopy() throws AdminSecurityException;

    public abstract boolean verifyAuthFlavor(AuthenticationFlavor var1) throws AdminSecurityException;

    public abstract SecurityToken verifyRequest(RequestSecurityToken var1) throws AdminSecurityException;

    public abstract SecurityToken verifyAuthenticator(AuthenticatorSecurityToken var1) throws AdminSecurityException;

    public abstract void checkVerifier(VerifierSecurityToken var1, Object[] var2) throws AdminSecurityException;

    public abstract String decryptPassword(byte[] var1) throws AdminSecurityException;

    public long getClientVersion() {
        return this.clientVers;
    }

    public void setClientVersion(long l) {
        this.clientVers = l;
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String string) {
        this.clientHost = string;
    }

    public AdminMgmtScope getMgmtScope() {
        return this.mgmtScope;
    }

    public void setMgmtScope(AdminMgmtScope adminMgmtScope) {
        this.mgmtScope = adminMgmtScope;
    }

    public boolean isVerify() {
        return this.msgVerify;
    }

    public void setVerify(boolean bl) {
        this.msgVerify = bl;
    }

    public void disableVerify() {
        this.msgVerify = false;
    }

    public UserAttrObj getUserAttr() {
        return this.userAuth;
    }

    public void setUserAttr(UserAttrObj userAttrObj) {
        this.userAuth = userAttrObj;
    }

    public void setLogService(LogServiceFactoryImpl logServiceFactoryImpl) {
        this.logsvc = logServiceFactoryImpl;
    }

    protected void writeLog(int n, String string, String string2) {
        Vector vector = new Vector();
        this.writeLog(n, string, string2, vector);
    }

    protected void writeLog(int n, String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string3);
        this.writeLog(n, string, string2, vector);
    }

    protected void writeLog(int n, String string, String string2, String string3, String string4) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string3);
        vector.addElement(string4);
        this.writeLog(n, string, string2, vector);
    }

    protected void writeLog(int n, String string, String string2, String string3, String string4, String string5) {
        Vector<String> vector = new Vector<String>();
        vector.addElement(string3);
        vector.addElement(string4);
        vector.addElement(string5);
        this.writeLog(n, string, string2, vector);
    }

    protected void writeLog(int n, String string, String string2, Vector vector) {
        if (this.logsvc != null) {
            String string3;
            AdminPrincipal adminPrincipal = this.getAdminPrincipal();
            String string4 = adminPrincipal != null ? adminPrincipal.getName() : "(Unknown)";
            String string5 = this.getClientHost();
            if (string5 == null) {
                string5 = "(Unknown)";
            }
            try {
                string3 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string3 = "(Unknown)";
            }
            LogRecord logRecord = new LogRecord("Security Service", 1, n, string4, string5, string3, string, string2, vector, this.getMgmtScope());
            try {
                this.logsvc.writeRecord(logRecord, false);
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_Trace1("Security service: error writing to log: " + exception.getMessage());
                return;
            }
        }
    }

    protected void logBadUser() {
        AdminPrincipal adminPrincipal = this.getAdminPrincipal();
        String string = adminPrincipal != null ? adminPrincipal.getName() : "(Unknown)";
        String string2 = this.getClientHost();
        if (string2 == null) {
            string2 = "(Unknown)";
        }
        this.writeLog(1, "LM_1000", "LM_1001", string);
        try {
            AdminCommonTools.CMN_Trace1("Auditing bad user");
            AdminServerLibrary.auditLogin(string2, string, -1L);
            AdminCommonTools.CMN_Trace1("Done Auditing bad user");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void logBadPasswd(String string) {
        AdminPrincipal adminPrincipal = this.getAdminPrincipal();
        String string2 = adminPrincipal != null ? adminPrincipal.getName() : "(Unknown)";
        String string3 = this.getClientHost();
        if (string3 == null) {
            string3 = "(Unknown)";
        }
        this.writeLog(1, "LM_1000", string, string2);
        try {
            AdminCommonTools.CMN_Trace1("Auditing bad passwd");
            AdminServerLibrary.auditLogin(string3, string2, -2L);
            AdminCommonTools.CMN_Trace1("Done Auditing bad passwd");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void logAuthSuccess() {
        AdminPrincipal adminPrincipal = this.getAdminPrincipal();
        String string = adminPrincipal != null ? adminPrincipal.getName() : "(Unknown)";
        String string2 = this.getClientHost();
        if (string2 == null) {
            string2 = "(Unknown)";
        }
        long l = this.getSecurityId().getValue();
        this.writeLog(1, "LM_0002", "LM_0012", string, string2, String.valueOf(l));
        try {
            AdminCommonTools.CMN_Trace1("Auditing Successful login");
            AdminServerLibrary.auditLogin(string2, string, l);
            AdminCommonTools.CMN_Trace1("Done Auditing Successful login");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void copyAttrs(ServerSecurityContext serverSecurityContext) throws AdminSecurityException {
        super.copyAttrs(serverSecurityContext);
        serverSecurityContext.setVerify(this.msgVerify);
        serverSecurityContext.setClientVersion(this.clientVers);
        serverSecurityContext.setLogService(this.logsvc);
        serverSecurityContext.setUserAttr(this.userAuth);
        if (this.clientHost != null) {
            serverSecurityContext.setClientHost(new String(this.clientHost));
        }
        if (this.mgmtScope != null) {
            try {
                serverSecurityContext.setMgmtScope(this.mgmtScope.newCopy());
                return;
            }
            catch (AdminException adminException) {
                return;
            }
        }
    }
}

