/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.security.AdminAuthenticationException;
import com.sun.admin.cis.service.security.AdminPrincipal;
import com.sun.admin.cis.service.security.AdminSecurityException;
import com.sun.admin.cis.service.security.ClientSecurityContext;
import com.sun.admin.cis.service.security.ConfirmSecurityToken;
import com.sun.admin.cis.service.security.DigestAuthFlavor;
import com.sun.admin.cis.service.security.DigestAuthenticatorSecurityToken;
import com.sun.admin.cis.service.security.DigestConfirmSecurityToken;
import com.sun.admin.cis.service.security.DigestResponseSecurityToken;
import com.sun.admin.cis.service.security.DigestSecurityUtil;
import com.sun.admin.cis.service.security.DigestVerifierSecurityToken;
import com.sun.admin.cis.service.security.Pwcx;
import com.sun.admin.cis.service.security.RequestSecurityToken;
import com.sun.admin.cis.service.security.ResponseSecurityToken;
import com.sun.admin.cis.service.security.SecurityIdentifier;
import com.sun.admin.cis.service.security.SecurityToken;
import java.security.PublicKey;

public class DigestClientSecurityContext
extends ClientSecurityContext {
    private PublicKey serverkey = null;
    private byte[] serverchg = null;
    private byte[] clientchg;
    private byte[] sessionkey = null;
    private byte[] hashpswd = null;
    private byte[] salt = null;
    private boolean integrity = false;
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestClientSecurityContext(DigestAuthFlavor digestAuthFlavor) throws AdminSecurityException {
        super(digestAuthFlavor);
    }

    public SecurityToken generateRequest() throws AdminSecurityException {
        AdminPrincipal adminPrincipal = this.getAdminPrincipal();
        if (adminPrincipal == null || this.getUserPassword() == null) {
            throw new AdminSecurityException("EXSS_NUI");
        }
        RequestSecurityToken requestSecurityToken = new RequestSecurityToken(this.getAuthFlavor(), adminPrincipal);
        this.setAuthState(1);
        this.setSecurityToken(requestSecurityToken);
        return requestSecurityToken;
    }

    public SecurityToken verifyResponse(ResponseSecurityToken responseSecurityToken) throws AdminSecurityException {
        DigestResponseSecurityToken digestResponseSecurityToken = null;
        try {
            digestResponseSecurityToken = (DigestResponseSecurityToken)responseSecurityToken;
        }
        catch (Exception exception) {
            throw new AdminSecurityException("EXSS_BRT");
        }
        SecurityIdentifier securityIdentifier = digestResponseSecurityToken.getSecurityId();
        this.setSecurityId(securityIdentifier);
        this.serverchg = digestResponseSecurityToken.getChallenge();
        this.salt = digestResponseSecurityToken.getPasswordSalt();
        this.serverkey = digestResponseSecurityToken.getServerKey();
        AdminCommonTools.CMN_Trace3("Security service: verifying server response...");
        AdminCommonTools.CMN_Trace3("   Id=" + securityIdentifier.getValue());
        AdminCommonTools.CMN_Trace3("   challenge=" + this.toHex(this.serverchg));
        AdminCommonTools.CMN_Trace3("   salt=" + new String(this.salt));
        String string = this.getUserPassword();
        byte[] byArray = string.getBytes();
        this.hashpswd = null;
        if (string != null) {
            Pwcx pwcx = new Pwcx();
            this.hashpswd = pwcx.pwcx(byArray, this.salt);
        }
        if (this.hashpswd == null) {
            AdminCommonTools.CMN_Trace1("Security service: cannot generate encrypted password");
            throw new AdminSecurityException("EXSS_BUP");
        }
        this.sessionkey = DigestSecurityUtil.getSessionKey();
        byte[] byArray2 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        byte[] byArray3 = DigestSecurityUtil.encryptPassword(byArray2, byArray);
        byte[] byArray4 = DigestSecurityUtil.encryptDigest(this.sessionkey, byArray2);
        PublicKey publicKey = DigestSecurityUtil.getPublicKey();
        byte[] byArray5 = publicKey.getEncoded();
        if (byArray5 == null) {
            byArray5 = publicKey.toString().getBytes();
        }
        byte[] byArray6 = DigestSecurityUtil.generateDigest(byArray3, byArray5, byArray);
        this.clientchg = new byte[16];
        DigestSecurityUtil.getRandomBytes(this.clientchg);
        AdminCommonTools.CMN_Trace3("Security service: generating client authenticator...");
        AdminCommonTools.CMN_Trace3("   digest=" + this.toHex(byArray3));
        AdminCommonTools.CMN_Trace3("   auth=" + this.toHex(byArray6));
        AdminCommonTools.CMN_Trace3("   challenge=" + this.toHex(this.clientchg));
        DigestAuthenticatorSecurityToken digestAuthenticatorSecurityToken = new DigestAuthenticatorSecurityToken(securityIdentifier);
        digestAuthenticatorSecurityToken.setMessageDigest(byArray3);
        digestAuthenticatorSecurityToken.setAuthenticatorDigest(byArray6);
        digestAuthenticatorSecurityToken.setSessionDigest(byArray4);
        digestAuthenticatorSecurityToken.setChallenge(this.clientchg);
        digestAuthenticatorSecurityToken.setClientKey(publicKey);
        this.setAuthState(3);
        return digestAuthenticatorSecurityToken;
    }

    public SecurityToken verifyConfirm(ConfirmSecurityToken confirmSecurityToken) throws AdminSecurityException {
        DigestConfirmSecurityToken digestConfirmSecurityToken;
        try {
            digestConfirmSecurityToken = (DigestConfirmSecurityToken)confirmSecurityToken;
        }
        catch (Exception exception) {
            throw new AdminSecurityException("EXSS_BCT");
        }
        byte[] byArray = digestConfirmSecurityToken.getResultMessage().getBytes();
        AdminCommonTools.CMN_Trace3("Security service: verifying confirm...");
        AdminCommonTools.CMN_Trace3("   Result=" + digestConfirmSecurityToken.getResultMessage());
        AdminCommonTools.CMN_Trace3("   digest=" + this.toHex(digestConfirmSecurityToken.getMessageDigest()));
        byte[] byArray2 = DigestSecurityUtil.generateDigest(this.clientchg, this.hashpswd, byArray);
        if (!DigestSecurityUtil.compareDigests(byArray2, digestConfirmSecurityToken.getMessageDigest())) {
            AdminCommonTools.CMN_Trace1("Security service: confirmation digests differ");
            throw new AdminAuthenticationException(this.getAdminPrincipal().getName());
        }
        if (digestConfirmSecurityToken.isIntegrityRequired()) {
            this.integrity = true;
        }
        this.setAuthState(4);
        this.setSecurityToken(confirmSecurityToken);
        return digestConfirmSecurityToken;
    }

    public SecurityToken generateVerifier(Object[] objectArray) throws AdminSecurityException {
        if (this.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_VBA");
        }
        SecurityIdentifier securityIdentifier = this.getSecurityId();
        DigestVerifierSecurityToken digestVerifierSecurityToken = new DigestVerifierSecurityToken(securityIdentifier);
        byte[] byArray = null;
        if (this.isIntegrityRequired()) {
            byArray = objectArray != null && objectArray.length > 0 ? DigestSecurityUtil.generateDigest(objectArray) : this.serverchg;
            byte[] byArray2 = DigestSecurityUtil.encryptDigest(byArray, this.sessionkey);
            AdminCommonTools.CMN_Trace3("Security service: generate message verifier: digest=" + this.toHex(byArray));
            digestVerifierSecurityToken.setDigest(byArray2);
        }
        return digestVerifierSecurityToken;
    }

    public byte[] encryptPassword(String string) throws AdminSecurityException {
        int n;
        if (this.getAuthState() != 4) {
            throw new AdminSecurityException("EXSS_NAX", "encryptPassword");
        }
        if (string == null || (n = string.trim().length()) == 0 || n > 16) {
            throw new AdminSecurityException("EXSS_BUP");
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = DigestSecurityUtil.generateDigest(this.serverchg, this.hashpswd, null);
        byArray2 = DigestSecurityUtil.encryptPassword(byArray2, byArray);
        return byArray2;
    }

    public ClientSecurityContext newCopy() throws AdminSecurityException {
        DigestClientSecurityContext digestClientSecurityContext = new DigestClientSecurityContext((DigestAuthFlavor)this.getAuthFlavor());
        super.copyAttrs(digestClientSecurityContext);
        digestClientSecurityContext.setServerKey(this.serverkey);
        digestClientSecurityContext.setServerChallenge(this.serverchg);
        digestClientSecurityContext.setClientChallenge(this.clientchg);
        digestClientSecurityContext.setPasswordHash(this.hashpswd);
        digestClientSecurityContext.setPasswordSalt(this.salt);
        if (this.integrity) {
            digestClientSecurityContext.setIntegrity();
        }
        return digestClientSecurityContext;
    }

    public void setServerKey(PublicKey publicKey) {
        this.serverkey = publicKey;
    }

    public void setServerChallenge(byte[] byArray) {
        if (byArray != null) {
            this.serverchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.serverchg, 0, byArray.length);
            return;
        }
        this.serverchg = null;
    }

    public void setClientChallenge(byte[] byArray) {
        if (byArray != null) {
            this.clientchg = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.clientchg, 0, byArray.length);
            return;
        }
        this.clientchg = null;
    }

    public void setPasswordHash(byte[] byArray) {
        if (byArray != null) {
            this.hashpswd = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.hashpswd, 0, byArray.length);
            return;
        }
        this.hashpswd = null;
    }

    public void setPasswordSalt(byte[] byArray) {
        if (byArray != null) {
            this.salt = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.salt, 0, byArray.length);
            return;
        }
        this.salt = null;
    }

    public PublicKey getServerKey() {
        return this.serverkey;
    }

    public boolean isIntegrityRequired() {
        return this.integrity;
    }

    public void setIntegrity() {
        this.integrity = true;
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

