/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common.iconpanel;

import com.sun.admin.cis.common.CorkBoard;
import com.sun.admin.cis.common.QuickVector;
import com.sun.admin.cis.common.iconpanel.IconPanelButton;
import com.sun.admin.cis.common.iconpanel.IconPanelElement;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class IconPanel
extends JPanel
implements AdjustmentListener {
    protected static final int X_SPACING = 10;
    protected static final int Y_SPACING = 10;
    protected static final int DEFAULT_ELEMENT_WIDTH = 90;
    protected static final int DEFAULT_ELEMENT_HEIGHT = 90;
    protected static final Color DEFAULT_UNSELECTED_COLOR = Color.white;
    protected static final Color DEFAULT_SELECTED_COLOR = Color.blue;
    QuickVector elements;
    Dimension elementSize = new Dimension(0, 0);
    Dimension jpSize = new Dimension(0, 0);
    Dimension panelSize = new Dimension(0, 0);
    Dimension vsbPreferredSize = new Dimension(0, 0);
    Color unselectedColor;
    Color selectedColor;
    int iconColumns;
    int iconRows;
    int firstRowInView;
    boolean vsbNeeded = false;
    QuickVector mouseListeners = new QuickVector(1);
    QuickVector keyListeners = new QuickVector(1);
    JScrollBar vsb;
    JPanel jp;
    IconPanelButton[] buttons;

    public IconPanel(QuickVector quickVector, Dimension dimension, Color color, Color color2) {
        this.elements = quickVector == null ? new QuickVector(1) : quickVector;
        this.elementSize = dimension;
        this.unselectedColor = color;
        this.selectedColor = color2;
        this.vsb = new JScrollBar(1);
        this.jp = new JPanel();
        this.jp.setBackground(this.unselectedColor);
        this.jp.setLayout(new CorkBoard());
        this.setBackground(this.unselectedColor);
        this.setLayout(null);
        this.add(this.jp);
        this.vsbPreferredSize = this.vsb.getPreferredSize();
    }

    public IconPanel(QuickVector quickVector, Dimension dimension) {
        this(quickVector, dimension, DEFAULT_UNSELECTED_COLOR, DEFAULT_SELECTED_COLOR);
    }

    public IconPanel(QuickVector quickVector) {
        this(quickVector, new Dimension(90, 90));
    }

    public IconPanel() {
        this((QuickVector)null);
    }

    public void setElements(QuickVector quickVector) {
        this.elements = quickVector == null ? new QuickVector(1) : quickVector;
        this.setSize(this.panelSize);
        this.updateIcons();
    }

    public void setElementSize(Dimension dimension) {
        if (this.elementSize.width == dimension.width && this.elementSize.height == dimension.height) {
            return;
        }
        this.elementSize.width = dimension.width;
        this.elementSize.height = dimension.height;
        this.setSize(this.panelSize);
        this.createIcons();
    }

    public void addIconMouseListener(MouseListener mouseListener) {
        this.mouseListeners.addElement(mouseListener);
    }

    public void addIconKeyListener(KeyListener keyListener) {
        this.keyListeners.addElement(keyListener);
    }

    public void removeAllIconMouseListeners() {
        this.mouseListeners.removeAllElements();
    }

    public void removeAllIconKeyListeners() {
        this.keyListeners.removeAllElements();
    }

    public void setElementSelected(int n, boolean bl) {
        ((IconPanelElement)this.elements.quickElementAt(n)).setSelected(bl);
        this.updateIcons();
    }

    public void setAllElementsSelected(boolean bl) {
        int n = 0;
        while (n < this.elements.size()) {
            ((IconPanelElement)this.elements.quickElementAt(n)).setSelected(bl);
            ++n;
        }
        this.updateIcons();
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public Color getUnselectedColor() {
        return this.unselectedColor;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.elementSize.width + 10 + 10 + this.vsbPreferredSize.width, this.elementSize.height + 10 + 10);
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = new Dimension((this.elementSize.width + 10) * 20 + 10 + this.vsbPreferredSize.width, (this.elementSize.height + 10) * 20 + 10);
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(this.elementSize.width + 10 + 10 + this.vsbPreferredSize.width, this.elementSize.height + 10 + 10);
        return dimension;
    }

    public void setSize(Dimension dimension) {
        super.setSize(dimension);
        int n = this.iconColumns;
        int n2 = this.iconRows;
        this.panelSize = dimension;
        if ((this.panelSize.width - 10) / (this.elementSize.width + 10) * ((this.panelSize.height - 10) / (this.elementSize.height + 10)) >= this.elements.size()) {
            this.jp.setBounds(0, 0, this.panelSize.width, this.panelSize.height);
            if (this.vsbNeeded) {
                this.vsb.removeAdjustmentListener(this);
                this.remove(this.vsb);
                this.vsbNeeded = false;
                this.firstRowInView = 0;
            }
        } else {
            if (!this.vsbNeeded) {
                this.vsb.addAdjustmentListener(this);
                this.add(this.vsb);
                this.vsbNeeded = true;
            }
            this.vsb.setBounds(this.panelSize.width - this.vsbPreferredSize.width, 0, this.vsbPreferredSize.width, this.panelSize.height);
            this.jp.setBounds(0, 0, this.panelSize.width - this.vsbPreferredSize.width, this.panelSize.height);
        }
        this.jpSize = this.jp.getSize();
        this.iconColumns = (this.jpSize.width - 10) / (this.elementSize.width + 10);
        this.iconRows = (this.jpSize.height - 10) / (this.elementSize.height + 10);
        if (this.iconColumns != 0 && this.iconRows != 0) {
            if (this.vsbNeeded) {
                this.vsb.setMinimum(0);
                if (this.elements.size() / this.iconColumns * this.iconColumns == this.elements.size()) {
                    this.vsb.setMaximum(this.elements.size() / this.iconColumns);
                } else {
                    this.vsb.setMaximum(this.elements.size() / this.iconColumns + 1);
                }
                this.vsb.setVisibleAmount(this.iconRows);
                this.firstRowInView = this.firstRowInView * n / this.iconColumns;
                this.vsb.setValue(this.firstRowInView);
            } else {
                this.firstRowInView = 0;
            }
            if (this.iconColumns != n || this.iconRows != n2) {
                this.createIcons();
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        int n5 = this.iconColumns;
        int n6 = this.iconRows;
        this.panelSize = new Dimension(n3, n4);
        if ((this.panelSize.width - 10) / (this.elementSize.width + 10) * ((this.panelSize.height - 10) / (this.elementSize.height + 10)) >= this.elements.size()) {
            this.jp.setBounds(0, 0, this.panelSize.width, this.panelSize.height);
            if (this.vsbNeeded) {
                this.vsb.removeAdjustmentListener(this);
                this.remove(this.vsb);
                this.vsbNeeded = false;
                this.firstRowInView = 0;
            }
        } else {
            if (!this.vsbNeeded) {
                this.vsb.addAdjustmentListener(this);
                this.add(this.vsb);
                this.vsbNeeded = true;
            }
            this.vsb.setBounds(this.panelSize.width - this.vsbPreferredSize.width, 0, this.vsbPreferredSize.width, this.panelSize.height);
            this.jp.setBounds(0, 0, this.panelSize.width - this.vsbPreferredSize.width, this.panelSize.height);
        }
        this.jpSize = this.jp.getSize();
        this.iconColumns = (this.jpSize.width - 10) / (this.elementSize.width + 10);
        this.iconRows = (this.jpSize.height - 10) / (this.elementSize.height + 10);
        if (this.iconColumns != 0 && this.iconRows != 0) {
            if (this.vsbNeeded) {
                this.vsb.setMinimum(0);
                if (this.elements.size() / this.iconColumns * this.iconColumns == this.elements.size()) {
                    this.vsb.setMaximum(this.elements.size() / this.iconColumns);
                } else {
                    this.vsb.setMaximum(this.elements.size() / this.iconColumns + 1);
                }
                this.vsb.setVisibleAmount(this.iconRows);
                this.vsb.setBlockIncrement(this.iconRows - 1);
                this.firstRowInView = this.firstRowInView * n5 / this.iconColumns;
                this.vsb.setValue(this.firstRowInView);
            } else {
                this.firstRowInView = 0;
            }
            if (this.iconColumns != n5 || this.iconRows != n6) {
                this.createIcons();
            }
        }
    }

    public void createIcons() {
        if (this.elements == null || this.jpSize == null || this.iconColumns == 0 || this.iconRows == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.firstRowInView * this.iconColumns;
        int n4 = n3 + this.iconColumns * this.iconRows - 1;
        if (n4 > this.elements.size() - 1) {
            n4 = this.elements.size() - 1;
        }
        this.jp.removeAll();
        this.buttons = new IconPanelButton[n4 - n3 + 1];
        int n5 = 0;
        while (n5 <= n4 - n3) {
            this.buttons[n5] = new IconPanelButton();
            this.buttons[n5].setPreferredSize(this.elementSize);
            this.buttons[n5].setLocation(n * (this.elementSize.width + 10) + 5, n2 * (this.elementSize.height + 10) + 5);
            int n6 = 0;
            while (n6 < this.mouseListeners.size()) {
                this.buttons[n5].removeMouseListener((MouseListener)this.mouseListeners.elementAt(n6));
                this.buttons[n5].addMouseListener((MouseListener)this.mouseListeners.elementAt(n6));
                ++n6;
            }
            int n7 = 0;
            while (n7 < this.keyListeners.size()) {
                this.buttons[n5].removeKeyListener((KeyListener)this.keyListeners.elementAt(n7));
                this.buttons[n5].addKeyListener((KeyListener)this.keyListeners.elementAt(n7));
                ++n7;
            }
            this.jp.add(this.buttons[n5]);
            this.buttons[n5].copyFromIconPanelElement((IconPanelElement)this.elements.quickElementAt(n5 + n3), n5 + n3, this);
            if (++n >= this.iconColumns) {
                n = 0;
                ++n2;
            }
            ++n5;
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void updateIcons() {
        int n = this.firstRowInView * this.iconColumns;
        int n2 = n + this.iconColumns * this.iconRows - 1;
        if (n2 > this.elements.size() - 1) {
            n2 = this.elements.size() - 1;
        }
        if (this.buttons != null && this.buttons.length == n2 - n + 1) {
            int n3 = n;
            while (n3 <= n2) {
                this.buttons[n3 - n].copyFromIconPanelElement((IconPanelElement)this.elements.quickElementAt(n3), n3, this);
                ++n3;
            }
            this.invalidate();
            this.validate();
            this.repaint();
            return;
        }
        this.createIcons();
    }

    public void scrollToElement(String string) {
        if (this.iconColumns == 0) {
            return;
        }
        if (this.vsbNeeded) {
            int n = 0;
            while (n < this.elements.size()) {
                if (((IconPanelElement)this.elements.quickElementAt(n)).getName().equals(string)) {
                    this.firstRowInView = n / this.iconColumns;
                    this.vsb.setValue(this.firstRowInView);
                    this.updateIcons();
                    return;
                }
                ++n;
            }
        }
    }

    public void scrollToElement(int n) {
        if (this.iconColumns == 0) {
            return;
        }
        if (this.vsbNeeded && n < this.elements.size()) {
            this.firstRowInView = n / this.iconColumns;
            this.vsb.setValue(this.firstRowInView);
            this.updateIcons();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getID() == 601) {
            int n = adjustmentEvent.getValue();
            if (n == this.firstRowInView) {
                return;
            }
            this.firstRowInView = n;
            if (this.firstRowInView * this.iconColumns > this.elements.size()) {
                this.firstRowInView = this.elements.size() / this.iconColumns;
            }
            this.updateIcons();
        }
    }
}

