/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.client.SBConstants;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.CheckSyntax;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ContextHelpListener;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ResourceStrings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FindDialog
extends AdminDialog {
    FindDialog findDialog = this;
    public JButton findNextButton;
    public JButton cancelButton;
    JTextField findTextField;
    URL url;
    GenInfoPanel infoPanel;
    String searchString = "";
    IClientComm clientComm;
    JFrame parentFrame;

    public FindDialog(Frame frame) {
        this(frame, "");
    }

    public FindDialog(Frame frame, String string) {
        super(frame, "Find", false);
        Object object;
        this.findDialog.setTitle(ResourceStrings.getString("find"));
        this.searchString = string;
        this.parentFrame = (JFrame)frame;
        this.infoPanel = this.getInfoPanel();
        this.clientComm = (IClientComm)((Object)frame);
        try {
            object = this.clientComm.getHelpUrl(SBConstants.getUMBHelpLocation(), "/find.html");
            this.infoPanel.setUrl(new URL((String)object));
        }
        catch (MalformedURLException malformedURLException) {
            AdminCommonTools.CMN_HandleOutput("Malformed URL: " + malformedURLException);
        }
        object = this.getRightPanel();
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add("Center", this.createFindPanel());
        this.findNextButton = this.getOKBtn();
        this.findNextButton.setText(ResourceStrings.getString("find_next_button"));
        this.findNextButton.addActionListener(new findAndCancelButtonListener());
        this.cancelButton = this.getCancelBtn();
        this.cancelButton.addActionListener(new findAndCancelButtonListener());
        1 var4_5 = new 1();
        this.findTextField.addKeyListener(var4_5);
        var4_5.keyReleased(null);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.height = Constants.SMALL_HELP_DLG.height;
        this.setMySize(dimension);
        ((Component)this).setSize(this.getMySize(this.hidden));
        this.findDialog.setDefaultFocusListener(new ContextHelpListener(this.clientComm, this.infoPanel, "cis", "find.html"), true);
        this.findTextField.requestFocus();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension2.width / 2 - this.getSize().width / 2, dimension2.height / 2 - this.getSize().height / 2);
        2 var7_8 = new 2();
        this.findDialog.addWindowListener(var7_8);
    }

    private JPanel createFindPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(ResourceStrings.getString("find_label"));
        jLabel.setFont(Constants.PROPS_LABEL_FONT);
        jLabel.setForeground(Constants.PROPS_LABEL_COLOR);
        Constraints.constrain(jPanel, jLabel, 0, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 24, 0, 0);
        this.findTextField = new JTextField(this.getSearchString(), 10);
        this.findTextField.setMinimumSize(this.findTextField.getPreferredSize());
        Constraints.constrain(jPanel, this.findTextField, 1, 0, 1, 1, 0, 17, 0.0, 0.0, 0, 16, 0, 0);
        return jPanel;
    }

    public boolean isSearchKeyOK(String string) {
        String[] stringArray = new String[]{"0", " ", ".", "_", "-"};
        if (!CheckSyntax.isStringOK(string, stringArray)) {
            new ErrorDialog(this.parentFrame, ResourceStrings.getString("search_error"));
            return false;
        }
        return true;
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setPopulateString(String string) {
        this.searchString = string;
        this.findTextField.setText(this.searchString);
    }

    public void addFindNextListener(ActionListener actionListener) {
        this.findTextField.addActionListener(actionListener);
    }

    private final class 1
    implements KeyListener {
        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (FindDialog.this.findTextField.getText().length() == 0) {
                FindDialog.this.findNextButton.setEnabled(false);
                return;
            }
            FindDialog.this.findNextButton.setEnabled(true);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            FindDialog.this.findDialog.dispose();
        }

        /* synthetic */ 2() {
        }
    }

    class findAndCancelButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == FindDialog.this.cancelButton) {
                    FindDialog.this.findDialog.dispose();
                    return;
                }
                if (actionEvent.getSource() == FindDialog.this.findNextButton) {
                    FindDialog.this.findTextField.postActionEvent();
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        findAndCancelButtonListener() {
            FindDialog.this = FindDialog.this;
        }
    }
}

