/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.common;

import com.sun.admin.cis.common.CollisionArena;
import com.sun.admin.cis.common.CollisionDetector;
import com.sun.admin.cis.common.Orientation;
import com.sun.admin.cis.common.Sprite;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Enumeration;

public class EdgeCollisionDetector
extends CollisionDetector {
    public EdgeCollisionDetector(CollisionArena collisionArena) {
        super(collisionArena);
    }

    public void detectCollisions() {
        Enumeration enumeration = this.arena.getSprites().elements();
        Dimension dimension = this.arena.getSize();
        Insets insets = this.arena.getInsets();
        while (enumeration.hasMoreElements()) {
            Sprite sprite = (Sprite)enumeration.nextElement();
            Point point = sprite.getNextLocation();
            sprite.getMoveVector();
            int n = sprite.getBounds().width;
            int n2 = sprite.getBounds().height;
            int n3 = point.x + n;
            int n4 = point.y + n2;
            int n5 = dimension.height - insets.bottom;
            int n6 = dimension.width - insets.right;
            if (n3 > n6) {
                this.arena.edgeCollision(sprite, Orientation.LEFT);
            } else if (point.x < insets.left) {
                this.arena.edgeCollision(sprite, Orientation.RIGHT);
            }
            if (n4 > n5) {
                this.arena.edgeCollision(sprite, Orientation.BOTTOM);
                continue;
            }
            if (point.y >= insets.top) continue;
            this.arena.edgeCollision(sprite, Orientation.TOP);
        }
    }
}

