/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.client;

import com.sun.admin.cis.client.AdminFrame;
import com.sun.admin.cis.client.SBConstants;
import com.sun.admin.cis.client.TreeHolderPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class AppSplitPane
extends JSplitPane {
    public TreeHolderPanel treeHolderPanel;
    private static AppSplitPane appSplitPane;

    public static AppSplitPane instance() {
        if (appSplitPane == null) {
            appSplitPane = new AppSplitPane();
        }
        return appSplitPane;
    }

    public void closeTree() {
        appSplitPane.remove(this.treeHolderPanel);
        appSplitPane.invalidate();
        appSplitPane.validate();
        appSplitPane.repaint();
    }

    public void openTree() {
        appSplitPane.setLeftComponent(this.treeHolderPanel);
        appSplitPane.setDividerLocation(this.getNewDividerLocation());
        appSplitPane.invalidate();
        appSplitPane.validate();
        appSplitPane.repaint();
    }

    private int getNewDividerLocation() {
        Dimension dimension = AdminFrame.instance().getSize();
        double d = dimension.width >= 4 ? (double)dimension.width * 0.22 : 1.0;
        return (int)d;
    }

    public void addToTreePanel(Component component) {
        this.treeHolderPanel.addToTreePanel(component);
        appSplitPane.setDividerLocation(this.getNewDividerLocation());
    }

    void addToMainView(JComponent jComponent) {
        this.setRightComponent(jComponent);
        jComponent.setMinimumSize(new Dimension(10, 10));
        this.invalidate();
        this.validate();
        this.repaint();
    }

    void doInitComponents() {
        this.treeHolderPanel = new TreeHolderPanel();
        JPanel jPanel = new JPanel();
        this.setOneTouchExpandable(true);
        this.setOrientation(1);
        this.treeHolderPanel.setMinimumSize(new Dimension(10, 10));
        jPanel.setMinimumSize(new Dimension(10, 10));
        this.setLeftComponent(this.treeHolderPanel);
        this.setRightComponent(jPanel);
    }

    private AppSplitPane() {
        this.setBackground(SBConstants.getBackGroundColor());
        this.doInitComponents();
    }
}

