/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.usermgr.client;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.IObserver;
import com.sun.admin.usermgr.client.AdminMainPanel;
import com.sun.admin.usermgr.client.AdminViews;
import com.sun.admin.usermgr.client.FilterObj;
import com.sun.admin.usermgr.client.IViews;
import com.sun.admin.usermgr.common.SGConstants;
import com.sun.admin.usermgr.common.UMgrResourceStrings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class AdminMainTree
implements IObserver {
    JTree tree;
    DefaultMutableTreeNode treeRoot = new DefaultMutableTreeNode(UMgrResourceStrings.getString("rootname"));
    private TreeCellRenderer oldRenderer;

    public void update(Object object, Object object2) {
        AdminCommonTools.CMN_HandleOutput("In AdminMainTree");
        AdminCommonTools.CMN_HandleOutput("update method called by observerable");
        if (object2 instanceof String) {
            String string = (String)object2;
            AdminCommonTools.CMN_HandleOutput("Change code = " + string);
            if (string.equalsIgnoreCase("changeView") && object instanceof IViews) {
                IViews iViews = (IViews)object;
                String string2 = iViews.getCurrentViewName();
                this.setSelectedNode(string2);
            }
        }
    }

    public void setSelectedNode(String string) {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            String string2 = treePath.getLastPathComponent().toString();
            if (string.equals(string2)) {
                return;
            }
        } else {
            this.tree.setSelectionRow(0);
        }
        this.tree.expandRow(0);
        int n = 0;
        while (n < this.tree.getRowCount()) {
            treePath = this.tree.getPathForRow(n);
            if (string.equals(treePath.getLastPathComponent().toString())) {
                this.tree.setSelectionPath(treePath);
                return;
            }
            ++n;
        }
    }

    public void removeAllSelections() {
        AdminCommonTools.CMN_HandleOutput("In removeAllSelections");
        int[] nArray = null;
        nArray = this.tree.getSelectionRows();
        if (nArray == null) {
            return;
        }
        this.tree.removeSelectionRows(nArray);
        this.tree.invalidate();
        this.tree.validate();
        this.tree.repaint();
    }

    private void setUpObservers() {
        AdminViews adminViews = AdminViews.instance();
        adminViews.myObservableComp.addIObserver(this);
    }

    public JTree createTree() {
        this.tree = new JTree(this.treeRoot);
        this.tree.setBackground(SGConstants.getBackGroundColor());
        this.tree.setRootVisible(true);
        TreePath treePath = new TreePath(this.tree.getModel().getRoot());
        this.tree.collapsePath(treePath);
        this.tree.addMouseListener(new TreeMouseListener());
        this.oldRenderer = this.tree.getCellRenderer();
        UserMgrTreeCellRenderer userMgrTreeCellRenderer = new UserMgrTreeCellRenderer();
        this.tree.setCellRenderer(userMgrTreeCellRenderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        return this.tree;
    }

    public AdminMainTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(UMgrResourceStrings.getString("users"));
        this.treeRoot.add(defaultMutableTreeNode);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(UMgrResourceStrings.getString("groups"));
        this.treeRoot.add(defaultMutableTreeNode2);
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(UMgrResourceStrings.getString("email"));
        this.treeRoot.add(defaultMutableTreeNode3);
        this.setUpObservers();
    }

    private ImageIcon createImageIcon(String string, String string2) {
        ImageIcon imageIcon = null;
        try {
            String string3 = SGConstants.getUMgrImagesLocation();
            imageIcon = new ImageIcon(String.valueOf(AdminMainPanel.getBaseDir()) + string3 + "/" + string, string2);
        }
        catch (Exception exception) {
            AdminCommonTools.CMN_HandleOutput("Can't create View image");
            AdminCommonTools.CMN_TraceStack(1, exception);
        }
        return imageIcon;
    }

    class TreeMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            TreePath treePath = null;
            try {
                if (mouseEvent.getClickCount() == 1) {
                    treePath = AdminMainTree.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath == null) {
                        return;
                    }
                    AdminViews adminViews = AdminViews.instance();
                    if (treePath != null) {
                        AdminMainPanel.sharedInstance().clientComm.setAppFocus(AdminMainPanel.sharedInstance());
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                        if (!defaultMutableTreeNode.isRoot()) {
                            adminViews.removeAllSelectedNodes();
                            if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("users"))) {
                                if (adminViews.showUserFilterDialog()) {
                                    adminViews.enableUserFilterDialog(false);
                                    new FilterObj(UMgrResourceStrings.getString("users"), true);
                                }
                            } else if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("groups"))) {
                                if (adminViews.showGroupFilterDialog()) {
                                    adminViews.enableGroupFilterDialog(false);
                                    new FilterObj(UMgrResourceStrings.getString("groups"), true);
                                }
                            } else if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("email")) && adminViews.showEmailFilterDialog()) {
                                adminViews.enableEmailFilterDialog(false);
                                new FilterObj(UMgrResourceStrings.getString("email"), true);
                            }
                            adminViews.setCurrentView(defaultMutableTreeNode.getParent().toString(), defaultMutableTreeNode.toString());
                            AdminCommonTools.CMN_HandleOutput("Node selected = " + defaultMutableTreeNode.toString());
                            return;
                        }
                        adminViews.removeAllSelectedNodes();
                        adminViews.setCurrentView(defaultMutableTreeNode.getRoot().toString(), defaultMutableTreeNode.toString());
                        AdminCommonTools.CMN_HandleOutput("Root node selected = " + defaultMutableTreeNode.toString());
                        return;
                    }
                } else {
                    mouseEvent.getClickCount();
                }
                return;
            }
            catch (Exception exception) {
                AdminCommonTools.CMN_TraceStack(1, exception);
                return;
            }
        }

        TreeMouseListener() {
            AdminMainTree.this = AdminMainTree.this;
        }
    }

    class UserMgrTreeCellRenderer
    implements TreeCellRenderer {
        ImageIcon rootIcon;
        Dimension rootDim;
        ImageIcon usersIcon;
        Dimension usersDim;
        ImageIcon groupsIcon;
        Dimension groupsDim;
        ImageIcon emailIcon;
        Dimension emailDim;

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = AdminMainTree.this.oldRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
                ImageIcon imageIcon = null;
                Dimension dimension = null;
                if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("rootname"))) {
                    if (this.rootIcon == null) {
                        this.rootIcon = AdminMainTree.this.createImageIcon("user_app_18_temp.gif", "User Manager");
                        this.rootDim = jLabel.getMinimumSize();
                        this.rootDim.height += 4;
                    }
                    imageIcon = this.rootIcon;
                    dimension = this.rootDim;
                }
                if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("users"))) {
                    if (this.usersIcon == null) {
                        this.usersIcon = AdminMainTree.this.createImageIcon("user_18_temp.gif", "Users");
                        this.usersDim = jLabel.getMinimumSize();
                        this.usersDim.height += 4;
                    }
                    imageIcon = this.usersIcon;
                    dimension = this.usersDim;
                }
                if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("groups"))) {
                    if (this.groupsIcon == null) {
                        this.groupsIcon = AdminMainTree.this.createImageIcon("group_18_temp.gif", "Groups");
                        this.groupsDim = jLabel.getMinimumSize();
                        this.groupsDim.height += 4;
                    }
                    imageIcon = this.groupsIcon;
                    dimension = this.groupsDim;
                }
                if (defaultMutableTreeNode.toString().equals(UMgrResourceStrings.getString("email"))) {
                    if (this.emailIcon == null) {
                        this.emailIcon = AdminMainTree.this.createImageIcon("email_18_temp.gif", "Email");
                        this.emailDim = jLabel.getMinimumSize();
                        this.emailDim.height += 4;
                    }
                    imageIcon = this.emailIcon;
                    dimension = this.emailDim;
                }
                if (imageIcon != null) {
                    jLabel.setIcon(imageIcon);
                    jLabel.setPreferredSize(dimension);
                    jLabel.setMaximumSize(dimension);
                }
            }
            return component;
        }

        UserMgrTreeCellRenderer() {
            AdminMainTree.this = AdminMainTree.this;
        }
    }
}

