/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.logviewer.client.LogVMainPanel;
import com.sun.admin.logviewer.common.LogVResourceStrings;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class LogVTree
extends JTree {
    DefaultTreeModel treeModel;
    DefaultTreeSelectionModel treeSelectionModel;
    public static String LOGVIEWER = LogVResourceStrings.getString("toolname");
    final TreeCellRenderer oldRenderer = this.getCellRenderer();

    public LogVTree() {
        super((TreeModel)null);
        LogVTreeNode logVTreeNode = new LogVTreeNode(LOGVIEWER, true);
        this.treeModel = new DefaultTreeModel(logVTreeNode);
        this.setModel(this.treeModel);
        LogVTreeCellRenderer logVTreeCellRenderer = new LogVTreeCellRenderer();
        this.setCellRenderer(logVTreeCellRenderer);
        this.treeSelectionModel = new DefaultTreeSelectionModel();
        this.treeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(this.treeSelectionModel);
        this.addTreeSelectionListener(new LogVTreeSelectionHandler());
    }

    public void setPanel(String string) {
        LogVMainPanel.instance();
        string.equals(LOGVIEWER);
    }

    protected class LogVTreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            LogVTree logVTree = (LogVTree)treeSelectionEvent.getSource();
            LogVTreeNode logVTreeNode = (LogVTreeNode)treeSelectionEvent.getPath().getLastPathComponent();
            String string = logVTreeNode.getName();
            if (treeSelectionEvent.isAddedPath()) {
                LogVMainPanel.instance().clientComm.setAppFocus(LogVMainPanel.instance());
                logVTree.setPanel(string);
                if (LogVMainPanel.instance().getLogPanel() != null) {
                    LogVMainPanel.instance().getLogPanel().setStatusPanel();
                }
            }
        }

        protected LogVTreeSelectionHandler() {
            LogVTree.this = LogVTree.this;
        }
    }

    protected class LogVTreeNode
    extends DefaultMutableTreeNode {
        String name;
        boolean isLeaf;

        public LogVTreeNode(String string, boolean bl) {
            LogVTree.this = LogVTree.this;
            this.name = string;
            this.isLeaf = bl;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public boolean getAllowsChildren() {
            return !this.isLeaf;
        }

        public String toString() {
            return this.name;
        }
    }

    private class LogVTreeCellRenderer
    implements TreeCellRenderer {
        private ImageIcon appIcon = LogVMainPanel.instance().loadImageIcon("log_viewer.gif", "Application Icon");
        private Dimension dim;

        public LogVTreeCellRenderer() {
            LogVTree.this = LogVTree.this;
            if (this.appIcon.getIconHeight() == -1) {
                this.appIcon = null;
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = LogVTree.this.oldRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                ((DefaultMutableTreeNode)object).getUserObject();
                if (this.dim == null) {
                    this.dim = jLabel.getMinimumSize();
                    this.dim.height += 4;
                }
                jLabel.setIcon(this.appIcon);
                jLabel.setPreferredSize(this.dim);
                jLabel.setMaximumSize(this.dim);
            }
            return component;
        }
    }
}

