/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.IConnection;
import com.sun.admin.cis.service.logging.LogFilter;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogServiceFactory;
import com.sun.admin.cis.service.logging.LogServiceWrapper;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.logviewer.client.LogEntries;
import com.sun.admin.logviewer.client.LogSettings;
import com.sun.admin.logviewer.client.LogVException;
import com.sun.admin.logviewer.client.LogVFilter;
import com.sun.admin.logviewer.client.LogVMainPanel;
import java.util.Vector;

public class LogVClient
implements IConnection {
    private static LogVClient logVClient;
    static final String APP_NAME = "com.sun.admin.cis.service.logging.LogServiceFactoryImpl";
    private LogServiceFactory logFactory;
    private LogServiceWrapper logSWrapper;
    private AdminSession session;
    Vector logRights;
    Vector logheaders;
    private String filename;
    private LogEntries logentries;
    private LogFilter logfilter;

    public static LogVClient instance() {
        if (logVClient == null) {
            logVClient = new LogVClient();
        }
        return logVClient;
    }

    public void setUpConnection(IClientComm iClientComm) throws Exception {
        this.session = iClientComm.getAdminSession();
        try {
            SecurityToken securityToken = this.session.getSecurityToken();
            this.logFactory = (LogServiceFactory)this.session.getAppFactory(APP_NAME);
            this.logRights = this.logFactory.getUserRights(securityToken);
            this.logSWrapper = new LogServiceWrapper(this.session, this.logFactory);
            return;
        }
        catch (AdminException adminException) {
            AdminCommonTools.CMN_HandleOutput("Unable to get factory");
            return;
        }
    }

    public void terminateConnection() throws Exception {
        this.session.closeAppFactory(APP_NAME);
        return;
    }

    public boolean hasUpdateRights() {
        if (this.logRights == null) {
            return false;
        }
        return this.logRights.contains("solaris.admin.logsvc.write");
    }

    public boolean hasDeleteRights() {
        if (this.logRights == null) {
            return false;
        }
        return this.logRights.contains("solaris.admin.logsvc.purge");
    }

    public int getRowCount() {
        long l = 0L;
        try {
            this.filename = this.logSWrapper.getCurrentLogFileName();
            l = this.logSWrapper.getNumRecords(this.filename);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return (int)l;
    }

    public int getRowCount(String string) {
        int n = 0;
        if (this.filename.compareTo("") == 0) {
            n = this.getRowCount();
        } else {
            try {
                n = (int)this.logSWrapper.getNumRecords(string);
            }
            catch (Exception exception) {
                new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
            }
        }
        return n;
    }

    public Vector getRowHeaders() {
        int n = this.getRowCount();
        LogFilter logFilter = new LogFilter();
        logFilter.setDirection(0);
        try {
            this.filename = this.logSWrapper.getCurrentLogFileName();
            this.logheaders = this.logSWrapper.getList(n, logFilter, 0L, this.filename);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return this.logheaders;
    }

    public LogFilter getFilter(LogVFilter logVFilter) {
        int n = 0;
        String string = null;
        int n2 = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        LogFilter logFilter = new LogFilter();
        String string5 = logVFilter.getStartDate();
        string3 = logVFilter.getStartTime();
        String string6 = logVFilter.getEndDate();
        string4 = logVFilter.getEndTime();
        int n3 = logVFilter.getInfoSev();
        int n4 = logVFilter.getWarnSev();
        n = logVFilter.getErrorSev();
        String string7 = logVFilter.getHMgrName();
        String string8 = logVFilter.getUMgrName();
        String string9 = logVFilter.getFsMgrName();
        string = logVFilter.getSerPortName();
        int n5 = logVFilter.getAppCat();
        int n6 = logVFilter.getSysCat();
        n2 = logVFilter.getSecCat();
        String string10 = logVFilter.getUser();
        string2 = logVFilter.getComputer();
        logFilter.setSeverity(n3, n4, n);
        logFilter.setCategory(n5, n6, n2);
        logFilter.setAppNames(string7, string8, string9, string);
        logFilter.setUser(string10);
        logFilter.setClientHostName(string2);
        logFilter.setStartDate(string5, string3);
        logFilter.setEndDate(string6, string4);
        if (this.logentries != null) {
            int n7 = this.logentries.getScope();
            logFilter.setScopeFilter(n7);
        }
        return logFilter;
    }

    public Vector getFilteredRowHeaders(String string, LogVFilter logVFilter) {
        int n = 50;
        String string2 = "";
        LogFilter logFilter = this.getFilter(logVFilter);
        if (string.compareTo("") == 0) {
            string2 = this.getFileName();
            try {
                n = (int)this.logSWrapper.getNumRecords(string2);
                this.logheaders = this.logSWrapper.getList(n, logFilter, 0L, string2);
            }
            catch (Exception exception) {
                new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
            }
            return this.logheaders;
        }
        try {
            n = (int)this.logSWrapper.getNumRecords(string);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        try {
            this.logheaders = this.logSWrapper.getList(n, logFilter, 0L, string);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return this.logheaders;
    }

    public Vector getDomainHeaders(String string, LogEntries logEntries) {
        int n = 50;
        String string2 = "";
        this.logentries = logEntries;
        int n2 = 0;
        n2 = logEntries.getScope();
        if (this.logfilter == null) {
            this.logfilter = new LogFilter();
        }
        this.logfilter.setScopeFilter(n2);
        if (string.compareTo("") == 0) {
            string2 = this.getFileName();
            try {
                n = (int)this.logSWrapper.getNumRecords(string2);
                this.logheaders = this.logSWrapper.getList(n, this.logfilter, 0L, string2);
            }
            catch (Exception exception) {
                new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
            }
            return this.logheaders;
        }
        try {
            n = (int)this.logSWrapper.getNumRecords(string);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        try {
            this.logheaders = this.logSWrapper.getList(n, this.logfilter, 0L, string);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return this.logheaders;
    }

    public Vector getSelectedFileHeaders(String string) {
        this.filename = string;
        int n = 50;
        try {
            n = (int)this.logSWrapper.getNumRecords(this.filename);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        LogFilter logFilter = new LogFilter();
        logFilter.setDirection(0);
        try {
            this.logheaders = this.logSWrapper.getList(n, logFilter, 0L, this.filename);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return this.logheaders;
    }

    public LogRecord getLogRecord(long l, int n) {
        LogRecord logRecord = null;
        try {
            this.filename = this.logSWrapper.getCurrentLogFileName();
            logRecord = this.logSWrapper.readRecord(l, n, this.filename);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return logRecord;
    }

    public LogRecord getLogRecord(long l, int n, String string) {
        LogRecord logRecord = null;
        try {
            logRecord = this.logSWrapper.readRecord(l, n, string);
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return logRecord;
    }

    public String[] getListOfFiles() {
        int n = 0;
        try {
            n = this.logSWrapper.listLogFiles().length;
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        String[] stringArray = new String[n];
        try {
            stringArray = this.logSWrapper.listLogFiles();
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return stringArray;
    }

    public String getFileName() {
        try {
            this.filename = this.logSWrapper.getCurrentLogFileName();
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return this.filename;
    }

    public void setFileName(String string) {
        this.filename = string;
    }

    public void backUp(String string) {
        try {
            this.logSWrapper.clearLog(string);
            return;
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
            return;
        }
    }

    public void deleteFile(String string) {
        try {
            this.logSWrapper.clearLog(string);
            return;
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
            return;
        }
    }

    public void setProps(LogSettings logSettings) {
        int n = 0;
        int n2 = 0;
        String string = null;
        String string2 = null;
        try {
            n = logSettings.getFileSize();
        }
        catch (LogVException logVException) {}
        try {
            n2 = logSettings.getNumFiles();
        }
        catch (LogVException logVException) {}
        string = logSettings.getDirName();
        string2 = logSettings.getSysLogValue();
        try {
            this.logSWrapper.setProperties(n, n2, string2, string);
            return;
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
            return;
        }
    }

    public int getLogFilesNum() {
        int n = 0;
        try {
            n = this.logSWrapper.getNumLogFiles();
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return n;
    }

    public String getPathLogFile() {
        String string = null;
        try {
            string = this.logSWrapper.getLogFileDir();
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return string;
    }

    public int getSizeLogFile() {
        int n = 0;
        try {
            n = this.logSWrapper.getLogFileSize();
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return n;
    }

    public String getSwitch() {
        String string = null;
        try {
            string = this.logSWrapper.getSyslogSwitch();
        }
        catch (Exception exception) {
            new ErrorDialog(LogVMainPanel.getFrame(), exception.getMessage());
        }
        return string;
    }
}

