/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.logviewer.client;

import com.sun.admin.cis.common.JMenuPlus;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.service.logging.LogRecord;
import com.sun.admin.cis.service.logging.LogRecordHeader;
import com.sun.admin.logviewer.client.AbstractTableViewModel;
import com.sun.admin.logviewer.client.LogDetails;
import com.sun.admin.logviewer.client.LogEntries;
import com.sun.admin.logviewer.client.LogFileOpen;
import com.sun.admin.logviewer.client.LogSettings;
import com.sun.admin.logviewer.client.LogVClient;
import com.sun.admin.logviewer.client.LogVFilter;
import com.sun.admin.logviewer.client.LogVMainPanel;
import com.sun.admin.logviewer.client.LogViewEvent;
import com.sun.admin.logviewer.client.LogViewListener;
import com.sun.admin.logviewer.client.LogViewerTableSorter;
import com.sun.admin.logviewer.common.LogVResourceStrings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class LogPanel
extends JPanel {
    public static String sccs_id = "@(#)LogPanel.java 1.17 98/10/22 SMI";
    protected JTable table;
    protected SimpleDateFormat timeform;
    protected SimpleDateFormat dateform;
    protected JScrollPane scroller;
    protected String saved_file_name;
    protected int numOfLogs;
    private boolean retrieved = false;
    public LogVFilter logVFilter;
    public LogSettings logsettings;
    public LogFileOpen openlogfile;
    public LogEntries logEntries;
    private LogVClient logVClient;
    private RealDataModel dataModel;
    private boolean filterOn;
    private boolean Filecurrent = true;
    LogViewerTableSorter tableSorter;
    DefaultTableCellRenderer renderer;
    int sevInt;
    int theSortColumn;
    int oldSortColumn;
    boolean ascendSort = false;
    private Object[][] theData;
    Vector cache;
    Vector vColumns = new Vector();
    LogRecordHeader logRecordHeader;
    LogDetails logDetails;
    LogPanel logPanel = this;
    public static final int TABLE_VIEW = 1;
    public static final int ASCEND_SORT = 10;
    public static final int DESCEND_SORT = 11;
    public static final int NO_SORT = 12;
    public static String DATE = LogVResourceStrings.getString("date_col");
    public static String SUMMARY = LogVResourceStrings.getString("summary_col");
    public static String SOURCE = LogVResourceStrings.getString("source_col");
    public static String CATEGORY = LogVResourceStrings.getString("category_col");
    public static String USER = LogVResourceStrings.getString("user_col");
    public static String COMPUTER = LogVResourceStrings.getString("computer_col");
    public static String EVENT = LogVResourceStrings.getString("event_col");
    public static final String DATE_SORT = DATE;
    public static final String SUMMARY_SORT = SUMMARY;
    public static final String CAT_SORT = CATEGORY;
    public static final String USER_SORT = USER;
    public static final String COMP_SORT = COMPUTER;
    public static final String SOURCE_SORT = SOURCE;
    public static final String EVENT_SORT = EVENT;
    String[] columnNames = new String[]{DATE, SUMMARY, SOURCE, CATEGORY, USER, COMPUTER, EVENT};
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$com$sun$admin$logviewer$client$LogPanel$DateTimeEntry;

    public LogPanel() {
        this.logVClient = LogVClient.instance();
        this.dateform = (SimpleDateFormat)DateFormat.getDateInstance(3);
        this.timeform = (SimpleDateFormat)DateFormat.getTimeInstance();
    }

    public JTable getTable() {
        return this.table;
    }

    public int getNumSelections() {
        return this.table.getSelectedRowCount();
    }

    protected int getViewType() {
        return 1;
    }

    protected int getSortOrder() {
        if (this.ascendSort) {
            return 10;
        }
        return 11;
    }

    public String getSortAttribute() {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(this.theSortColumn);
        return (String)tableColumn.getIdentifier();
    }

    public Vector getAvailableSortAttributes() {
        return this.vColumns;
    }

    public synchronized void addListViewListener(LogViewListener logViewListener) {
        this.listeners.addElement(logViewListener);
    }

    public void fireSortChanged() {
        LogViewEvent logViewEvent = new LogViewEvent(this, 0, this.getViewType(), this.getSortOrder(), this.getSortAttribute(), this.getAvailableSortAttributes());
        int n = 0;
        while (n < this.listeners.size()) {
            LogViewListener logViewListener = (LogViewListener)this.listeners.elementAt(n);
            logViewListener.sortChanged(logViewEvent);
            ++n;
        }
    }

    public void selectNextUp() {
        int n = this.table.getSelectedRow();
        if (n == 1) {
            this.logDetails.disablePrev();
        } else {
            this.logDetails.enablePrev();
        }
        this.table.addRowSelectionInterval(this.table.getSelectedRow() - 1, this.table.getSelectedRow() - 1);
        this.table.requestFocus();
        this.setDetailWindow();
    }

    public void selectNextDown() {
        int n;
        int n2 = this.table.getSelectedRow();
        if (n2 + 2 == (n = this.theData.length)) {
            this.logDetails.disableNext();
        } else {
            this.logDetails.enableNext();
        }
        this.table.addRowSelectionInterval(this.table.getSelectedRow() + 1, this.table.getSelectedRow() + 1);
        this.table.requestFocus();
        this.setDetailWindow();
    }

    public void setStatusPanel() {
        LogVMainPanel.instance().clientComm.addToStatusPanel(String.valueOf(LogVResourceStrings.getString("num_of_logs")) + " " + this.numOfLogs, 0);
    }

    public JComponent getDisplayComponent() {
        return this.scroller;
    }

    public void prepareData() {
        Object object;
        if (this.dataModel != null) {
            return;
        }
        this.dataModel = new RealDataModel();
        if (this.Filecurrent) {
            this.numOfLogs = this.logVClient.getRowCount();
        } else {
            object = this.getSavedFileName();
            this.numOfLogs = this.logVClient.getRowCount((String)object);
        }
        this.logPanel.addMouseListener(new ViewMouseListener());
        this.tableSorter = new LogViewerTableSorter(this.dataModel);
        this.table = new JTable(this.tableSorter);
        this.vColumns.addElement(new String(DATE));
        this.vColumns.addElement(new String(SUMMARY));
        this.vColumns.addElement(new String(SOURCE));
        this.vColumns.addElement(new String(CATEGORY));
        this.vColumns.addElement(new String(USER));
        this.vColumns.addElement(new String(COMPUTER));
        this.vColumns.addElement(new String(EVENT));
        this.table.setSelectionMode(0);
        this.table.setDefaultRenderer(class$com$sun$admin$logviewer$client$LogPanel$DateTimeEntry != null ? class$com$sun$admin$logviewer$client$LogPanel$DateTimeEntry : (class$com$sun$admin$logviewer$client$LogPanel$DateTimeEntry = LogPanel.class$("com.sun.admin.logviewer.client.LogPanel$DateTimeEntry")), new SeverityRenderer());
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        object = this.table.getSelectionModel();
        object.addListSelectionListener(new 1());
        this.table.addMouseListener(new TblMouseListener());
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new 2());
        this.scroller = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        LogVMainPanel.instance().getLogVClient().getFileName();
        this.add("Center", this.scroller);
        this.setBackground(Color.white);
        LogVMainPanel.instance().clientComm.addToStatusPanel(String.valueOf(LogVResourceStrings.getString("num_of_logs")) + " " + this.numOfLogs, 0);
    }

    public void populate() {
        this.theData = new Object[this.cache.size()][this.dataModel.getMaxColumnCount()];
        int n = 0;
        while (n < this.cache.size()) {
            this.logRecordHeader = (LogRecordHeader)this.cache.elementAt(n);
            this.dataModel.addLOGRows(n, this.logRecordHeader);
            ++n;
        }
        this.tableSorter.tableChanged(new TableModelEvent(this.dataModel));
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
        this.setStatusPanel();
    }

    public String getSev(LogRecordHeader logRecordHeader) {
        String string = null;
        string = logRecordHeader.getSeverityString();
        return string;
    }

    public int getSevInt(LogRecordHeader logRecordHeader) {
        int n = 0;
        n = logRecordHeader.getSeverity();
        return n;
    }

    public void setFilteredCache() {
        if (this.cache.size() > 0) {
            this.cache.removeAllElements();
        }
        if (this.isFileCurrent()) {
            this.cache = this.logVClient.getFilteredRowHeaders("", this.logVFilter);
            this.numOfLogs = this.cache.size();
        } else {
            String string = this.getSavedFileName();
            this.cache = this.logVClient.getFilteredRowHeaders(string, this.logVFilter);
            this.numOfLogs = this.cache.size();
        }
        this.filterOn = true;
    }

    public void setSettings() {
        if (this.logsettings != null) {
            this.logVClient.setProps(this.logsettings);
        }
    }

    public boolean getFilterState() {
        return this.filterOn;
    }

    public void setFilterState(boolean bl) {
        this.filterOn = bl;
    }

    public boolean isFileCurrent() {
        return this.Filecurrent;
    }

    public void setFileState(boolean bl) {
        this.Filecurrent = bl;
    }

    public void displaySettings(LogSettings logSettings) {
        logSettings.numFilesField.setIntValue(0);
        logSettings.numFilesField.setIntValue(this.logVClient.getLogFilesNum());
        logSettings.fileSizeField.setIntValue(0);
        logSettings.fileSizeField.setIntValue(this.logVClient.getSizeLogFile());
        logSettings.fileTextf.setText("");
        logSettings.fileTextf.setText(this.logVClient.getPathLogFile());
        if (this.logVClient.getSwitch().compareTo("on") == 0) {
            logSettings.sysLogBtn.setSelected(true);
            return;
        }
        if (this.logVClient.getSwitch().compareTo("off") == 0) {
            logSettings.sysLogBtn.setSelected(false);
        }
    }

    public void setCurrentDomain() {
        if (this.cache.size() > 0) {
            this.cache.removeAllElements();
        }
        if (this.isFileCurrent()) {
            this.cache = this.logVClient.getDomainHeaders("", this.logEntries);
            this.numOfLogs = this.cache.size();
            return;
        }
        String string = this.getSavedFileName();
        this.cache = this.logVClient.getDomainHeaders(string, this.logEntries);
        this.numOfLogs = this.cache.size();
    }

    public void setSelectedFile(String string) {
        JButton jButton = LogVMainPanel.instance().getToolBar().getFilterBtn();
        JButton jButton2 = LogVMainPanel.instance().getToolBar().getRefreshBtn();
        JButton jButton3 = LogVMainPanel.instance().getToolBar().getPropBtn();
        if (this.cache.size() > 0) {
            this.cache.removeAllElements();
        }
        this.cache = this.logVClient.getSelectedFileHeaders(string);
        LogVMainPanel.instance().setContentLbl(string);
        this.saveSelectedFileName(string);
        this.numOfLogs = this.cache.size();
        String string2 = LogVMainPanel.instance().getLogVClient().getFileName();
        if (string.compareTo(string2) == 0) {
            this.Filecurrent = true;
            JMenu jMenu = LogVMainPanel.instance().getMenuBar().getMenu(0);
            JMenu jMenu2 = LogVMainPanel.instance().getMenuBar().getMenu(1);
            JMenuItem jMenuItem = jMenu.getItem(5);
            JMenuItem jMenuItem2 = jMenu.getItem(4);
            jMenuItem.setEnabled(false);
            jMenuItem2.setEnabled(true);
            JMenuItem jMenuItem3 = jMenu2.getItem(3);
            JMenuItem jMenuItem4 = jMenu2.getItem(1);
            JMenuItem jMenuItem5 = jMenu2.getItem(9);
            jMenuItem4.setEnabled(true);
            jMenuItem5.setEnabled(true);
            jMenuItem3.setEnabled(false);
            jButton3.setEnabled(true);
            jButton.setEnabled(true);
            jButton2.setEnabled(true);
            return;
        }
        this.Filecurrent = false;
        JMenu jMenu = LogVMainPanel.instance().getMenuBar().getMenu(0);
        JMenu jMenu3 = LogVMainPanel.instance().getMenuBar().getMenu(1);
        JMenuItem jMenuItem = jMenu.getItem(5);
        JMenuItem jMenuItem6 = jMenu.getItem(4);
        JMenuItem jMenuItem7 = jMenu3.getItem(3);
        JMenuItem jMenuItem8 = jMenu3.getItem(1);
        JMenuItem jMenuItem9 = jMenu3.getItem(9);
        jMenuItem.setEnabled(true);
        jMenuItem6.setEnabled(false);
        jMenuItem8.setEnabled(true);
        jMenuItem9.setEnabled(false);
        jMenuItem7.setEnabled(false);
        jButton3.setEnabled(false);
        jButton.setEnabled(true);
        jButton2.setEnabled(false);
    }

    public void saveSelectedFileName(String string) {
        this.saved_file_name = string;
    }

    public String getSavedFileName() {
        return this.saved_file_name;
    }

    public String[] getLogFiles() {
        String[] stringArray = this.logVClient.getListOfFiles();
        return stringArray;
    }

    public void showAllLogs() {
        this.setFilterState(false);
        this.setFileState(true);
        3 var1_1 = new 3();
        if (this.cache.size() > 0) {
            this.cache.removeAllElements();
        }
        this.populate();
        LogVMainPanel.instance().getToolBar().invalidate();
        LogVMainPanel.instance().getToolBar().validate();
        LogVMainPanel.instance().getToolBar().repaint();
        LogVMainPanel.instance().invalidate();
        LogVMainPanel.instance().validate();
        LogVMainPanel.instance().repaint();
        var1_1.start();
    }

    public void refresh() {
        4 var1_1 = new 4();
        if (this.cache.size() > 0) {
            this.cache.removeAllElements();
        }
        this.populate();
        LogVMainPanel.instance().getToolBar().invalidate();
        LogVMainPanel.instance().getToolBar().validate();
        LogVMainPanel.instance().getToolBar().repaint();
        LogVMainPanel.instance().invalidate();
        LogVMainPanel.instance().validate();
        LogVMainPanel.instance().repaint();
        var1_1.start();
    }

    public void refresh(String string) {
        if (this.cache.size() > 0) {
            this.cache.removeAllElements();
        }
        this.populate();
        String string2 = LogVMainPanel.instance().getLogVClient().getFileName();
        LogVMainPanel.instance().setContentLbl(string2);
    }

    public void sortAscending() {
        this.ascendSort = true;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
        this.fireSortChanged();
    }

    public void sortDescending() {
        this.ascendSort = false;
        this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
    }

    public void sortByAttribute(String string) {
        try {
            int n;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            this.theSortColumn = n = tableColumnModel.getColumnIndex(string);
            this.tableSorter.sortByColumn(this.theSortColumn, this.ascendSort);
            this.fireSortChanged();
            return;
        }
        catch (Exception exception) {
            this.fireSortChanged();
            return;
        }
    }

    public LogVClient getLogVClient() {
        this.logVClient = LogVClient.instance();
        return this.logVClient;
    }

    public Object getSelectedItem() {
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            return null;
        }
        Object e = this.cache.elementAt(this.tableSorter.convertRowIndexToModel(nArray[0]));
        return e;
    }

    public void setDetailWindow() {
        String string = this.getSavedFileName();
        if (string == null) {
            string = LogVMainPanel.instance().getLogVClient().getFileName();
        }
        this.logRecordHeader = null;
        long l = 0L;
        int n = 0;
        this.logRecordHeader = (LogRecordHeader)this.getSelectedItem();
        if (this.logDetails != null) {
            this.logDetails.setLogRecord(this.logRecordHeader);
            l = this.logRecordHeader.getRecordId();
            n = this.logRecordHeader.getHashCode();
            LogRecord logRecord = null;
            logRecord = this.logVClient.getLogRecord(l, n, string);
            this.logDetails.setDescription(logRecord);
            this.logDetails.setData(logRecord);
        }
    }

    public void displayDetails() {
        this.logRecordHeader = null;
        long l = 0L;
        int n = 0;
        String string = this.getSavedFileName();
        if (string == null) {
            string = LogVMainPanel.instance().getLogVClient().getFileName();
        }
        int n2 = this.table.getSelectedRow();
        this.logRecordHeader = (LogRecordHeader)this.getSelectedItem();
        if (this.logRecordHeader != null) {
            this.logDetails = new LogDetails((Frame)LogVMainPanel.getFrame(), this.logPanel, this.logRecordHeader);
            if (n2 == 0) {
                this.logDetails.disablePrev();
            } else {
                this.logDetails.enablePrev();
            }
            int n3 = this.theData.length;
            if (n2 + 1 == n3) {
                this.logDetails.disableNext();
            } else {
                this.logDetails.enableNext();
            }
            this.logDetails.setLogRecord(this.logRecordHeader);
            l = this.logRecordHeader.getRecordId();
            n = this.logRecordHeader.getHashCode();
            LogRecord logRecord = null;
            logRecord = this.logVClient.getLogRecord(l, n, string);
            this.logDetails.setDescription(logRecord);
            this.logDetails.setData(logRecord);
            this.logDetails.invalidate();
            this.logDetails.validate();
            ((Component)this.logDetails).setVisible(true);
        }
    }

    public void doPopupMenu(MouseEvent mouseEvent, boolean bl) {
        int n = this.table.rowAtPoint(mouseEvent.getPoint());
        if (bl) {
            this.table.clearSelection();
            this.table.setRowSelectionInterval(n, n);
        }
        JMenuPlus jMenuPlus = (JMenuPlus)LogVMainPanel.instance().getMenuBar().getMenu(0);
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.table, mouseEvent, this.scroller.getViewport());
        Point point = mouseEvent2.getPoint();
        jMenuPlus.showPopupAt(this, point.x, point.y);
    }

    public void popViewMenu(Point point) {
        int n = this.table.rowAtPoint(point);
        if (n != -1 && !this.table.isRowSelected(n)) {
            this.table.clearSelection();
            this.table.setRowSelectionInterval(n, n);
        }
        JMenuPlus jMenuPlus = (JMenuPlus)LogVMainPanel.instance().getMenuBar().getMenu(1);
        jMenuPlus.showPopupAt(this, point.x, point.y);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$2(LogPanel logPanel) {
        return logPanel.Filecurrent;
    }

    static /* synthetic */ boolean access$4(LogPanel logPanel) {
        return logPanel.filterOn;
    }

    class RealDataModel
    extends AbstractTableViewModel {
        public RealDataModel() {
            LogPanel.this = LogPanel.this;
            LogPanel.this.logVClient = LogVClient.instance();
            LogPanel.this.cache = LogPanel.this.logVClient.getRowHeaders();
            LogPanel.this.Filecurrent = true;
            LogPanel.this.filterOn = false;
            LogPanel.this.theData = new Object[0][this.getMaxColumnCount()];
        }

        public int getRowCount() {
            return LogPanel.this.theData.length;
        }

        public int getColumnCount() {
            return 7;
        }

        public String getColumnName(int n) {
            return LogPanel.this.columnNames[n];
        }

        public Class getColumnClass(int n) {
            try {
                return LogPanel.this.theData[0][n].getClass();
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("column index = " + n);
                if (LogPanel.this.theData == null) {
                    System.out.println("The data is null");
                }
                if (LogPanel.this.theData[0] == null) {
                    System.out.println("The data row value is null");
                }
                if (LogPanel.this.theData[0][n] == null) {
                    System.out.println("The data column value is null");
                }
                throw nullPointerException;
            }
        }

        public Object getDateValueAt(int n, int n2) throws Exception {
            if (n2 != this.getColumnModelIndex(DATE)) {
                throw new Exception();
            }
            return ((DateTimeEntry)LogPanel.this.theData[n][n2]).get_date();
        }

        public Object getValueAt(int n, int n2) {
            if (LogPanel.this.theData.length == 0) {
                return null;
            }
            return LogPanel.this.theData[n][n2];
        }

        public int getMaxColumnCount() {
            return LogPanel.this.columnNames.length;
        }

        public void addLOGRows(int n, LogRecordHeader logRecordHeader) {
            int n2 = this.getColumnModelIndex(DATE);
            DateTimeEntry dateTimeEntry = new DateTimeEntry(LogPanel.this.getSev(LogPanel.this.logRecordHeader), logRecordHeader.getDate());
            ((LogPanel)LogPanel.this).theData[n][n2] = dateTimeEntry;
            n2 = this.getColumnModelIndex(USER);
            ((LogPanel)LogPanel.this).theData[n][n2] = logRecordHeader.getUserName();
            n2 = this.getColumnModelIndex(SUMMARY);
            ((LogPanel)LogPanel.this).theData[n][n2] = logRecordHeader.getSummaryMesg(true);
            n2 = this.getColumnModelIndex(SOURCE);
            ((LogPanel)LogPanel.this).theData[n][n2] = logRecordHeader.getAppName();
            n2 = this.getColumnModelIndex(CATEGORY);
            ((LogPanel)LogPanel.this).theData[n][n2] = logRecordHeader.getCategoryString();
            n2 = this.getColumnModelIndex(COMPUTER);
            ((LogPanel)LogPanel.this).theData[n][n2] = logRecordHeader.getClientHostName();
            n2 = this.getColumnModelIndex(EVENT);
            ((LogPanel)LogPanel.this).theData[n][n2] = logRecordHeader.getEventId();
        }

        public int getColumnModelIndex(String string) {
            int n = 0;
            while (n < this.getMaxColumnCount()) {
                if (string.compareTo(LogPanel.this.columnNames[n]) == 0) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }

    private final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (listSelectionModel.isSelectionEmpty()) {
                LogPanel.this.setEnabled(false);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        boolean needSort = false;

        public void mouseExited(MouseEvent mouseEvent) {
            this.needSort = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.needSort = true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.needSort) {
                return;
            }
            this.needSort = false;
            TableColumnModel tableColumnModel = LogPanel.this.table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = LogPanel.this.table.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                LogPanel.this.oldSortColumn = LogPanel.this.theSortColumn;
                LogPanel.this.theSortColumn = n2;
                LogPanel.this.ascendSort = LogPanel.this.theSortColumn == LogPanel.this.oldSortColumn ? !LogPanel.this.ascendSort : true;
                LogPanel.this.tableSorter.sortByColumn(LogPanel.this.theSortColumn, LogPanel.this.ascendSort);
                LogPanel.this.fireSortChanged();
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends Thread {
        public void run() {
            LogVMainPanel.instance().clientComm.waitOn();
            String string = LogVResourceStrings.getString("LogViewerProgressPanelTitle");
            String string2 = LogVResourceStrings.getString("LogViewerProgressPanelText");
            LogVMainPanel.instance();
            ProgressPanel progressPanel = new ProgressPanel(LogVMainPanel.getFrame(), 1, 30, false, false);
            progressPanel.setTitle(string);
            progressPanel.setText(string2);
            ((Component)progressPanel).setVisible(true);
            progressPanel.show();
            if (LogPanel.this.cache.size() > 0) {
                LogPanel.this.cache.removeAllElements();
            }
            String string3 = LogPanel.this.logVClient.getFileName();
            LogPanel.this.cache = LogPanel.this.logVClient.getRowHeaders();
            LogPanel.this.numOfLogs = LogPanel.this.cache.size();
            LogPanel.this.populate();
            LogVMainPanel.instance().getToolBar().displayFilterString();
            LogVMainPanel.instance().setContentLbl(string3);
            if (LogPanel.this.logVFilter != null) {
                LogPanel.this.logVFilter.setDefaults();
            }
            LogVMainPanel.instance().getToolBar().invalidate();
            LogVMainPanel.instance().getToolBar().validate();
            LogVMainPanel.instance().getToolBar().repaint();
            LogVMainPanel.instance().invalidate();
            LogVMainPanel.instance().validate();
            LogVMainPanel.instance().repaint();
            JButton jButton = LogVMainPanel.instance().getToolBar().getFilterBtn();
            JButton jButton2 = LogVMainPanel.instance().getToolBar().getRefreshBtn();
            JButton jButton3 = LogVMainPanel.instance().getToolBar().getPropBtn();
            JMenu jMenu = LogVMainPanel.instance().getMenuBar().getMenu(0);
            LogVMainPanel.instance().getMenuBar().getMenu(1);
            JMenuItem jMenuItem = jMenu.getItem(5);
            JMenuItem jMenuItem2 = jMenu.getItem(4);
            JMenuItem jMenuItem3 = jMenu.getItem(1);
            if (LogVMainPanel.instance().getLogVClient().hasDeleteRights()) {
                jMenuItem.setEnabled(false);
            }
            jMenuItem2.setEnabled(true);
            jMenuItem3.setEnabled(true);
            jButton3.setEnabled(true);
            jButton.setEnabled(true);
            jButton2.setEnabled(true);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            LogVMainPanel.instance().clientComm.waitOff();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends Thread {
        public void run() {
            LogVMainPanel.instance().clientComm.waitOn();
            String string = LogVResourceStrings.getString("LogViewerProgressPanelTitle");
            String string2 = LogVResourceStrings.getString("LogViewerProgressPanelText");
            LogVMainPanel.instance();
            ProgressPanel progressPanel = new ProgressPanel(LogVMainPanel.getFrame(), 1, 30, false, false);
            progressPanel.setTitle(string);
            progressPanel.setText(string2);
            ((Component)progressPanel).setVisible(true);
            progressPanel.show();
            if (LogPanel.this.cache.size() > 0) {
                LogPanel.this.cache.removeAllElements();
            }
            String string3 = LogPanel.this.logVClient.getFileName();
            String string4 = LogPanel.this.getSavedFileName();
            if (LogPanel.this.getFilterState() && LogPanel.this.isFileCurrent()) {
                LogPanel.this.cache = LogPanel.this.logVClient.getFilteredRowHeaders("", LogPanel.this.logVFilter);
                LogVMainPanel.instance().getToolBar().displayFilterString();
                LogVMainPanel.instance().setContentLbl(string3);
            } else if (LogPanel.this.getFilterState() && !LogPanel.this.isFileCurrent()) {
                LogPanel.this.cache = LogPanel.this.logVClient.getFilteredRowHeaders(string4, LogPanel.this.logVFilter);
                LogVMainPanel.instance().getToolBar().displayFilterString();
                LogVMainPanel.instance().setContentLbl(string4);
            } else if (!LogPanel.this.getFilterState() && LogPanel.this.isFileCurrent()) {
                LogPanel.this.cache = LogPanel.this.logVClient.getRowHeaders();
                LogVMainPanel.instance().getToolBar().displayFilterString();
                LogVMainPanel.instance().setContentLbl(string3);
            } else if (!LogPanel.this.getFilterState() && !LogPanel.this.isFileCurrent()) {
                LogPanel.this.cache = LogPanel.this.logVClient.getSelectedFileHeaders(string4);
                LogVMainPanel.instance().getToolBar().displayFilterString();
                LogVMainPanel.instance().setContentLbl(string4);
            }
            LogPanel.this.numOfLogs = LogPanel.this.cache.size();
            LogPanel.this.populate();
            LogVMainPanel.instance().getToolBar().invalidate();
            LogVMainPanel.instance().getToolBar().validate();
            LogVMainPanel.instance().getToolBar().repaint();
            LogVMainPanel.instance().invalidate();
            LogVMainPanel.instance().validate();
            LogVMainPanel.instance().repaint();
            JButton jButton = LogVMainPanel.instance().getToolBar().getFilterBtn();
            JButton jButton2 = LogVMainPanel.instance().getToolBar().getRefreshBtn();
            JButton jButton3 = LogVMainPanel.instance().getToolBar().getPropBtn();
            JMenu jMenu = LogVMainPanel.instance().getMenuBar().getMenu(0);
            LogVMainPanel.instance().getMenuBar().getMenu(1);
            JMenuItem jMenuItem = jMenu.getItem(5);
            JMenuItem jMenuItem2 = jMenu.getItem(4);
            JMenuItem jMenuItem3 = jMenu.getItem(1);
            if (LogPanel.this.isFileCurrent()) {
                if (LogVMainPanel.instance().getLogVClient().hasDeleteRights()) {
                    jMenuItem.setEnabled(false);
                }
                jMenuItem2.setEnabled(true);
                jMenuItem3.setEnabled(true);
                jButton3.setEnabled(true);
                jButton.setEnabled(true);
                jButton2.setEnabled(true);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            LogVMainPanel.instance().clientComm.waitOff();
        }

        /* synthetic */ 4() {
        }
    }

    class ViewMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (LogPanel.this.logPanel != null) {
                    LogPanel.this.logPanel.doPopupMenu(mouseEvent, true);
                }
                return;
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                LogPanel.this.table.clearSelection();
                return;
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                LogPanel.this.logPanel.doPopupMenu(mouseEvent, true);
            }
        }

        ViewMouseListener() {
            LogPanel.this = LogPanel.this;
        }
    }

    class TblMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            LogPanel.this.table.rowAtPoint(point);
            LogPanel.this.table.columnAtPoint(point);
            JMenu jMenu = LogVMainPanel.instance().getMenuBar().getMenu(1);
            JMenuItem jMenuItem = jMenu.getItem(3);
            if (mouseEvent.isPopupTrigger()) {
                LogPanel.this.logPanel.popViewMenu(mouseEvent.getPoint());
                return;
            }
            if (mouseEvent.getClickCount() == 2) {
                LogPanel.this.displayDetails();
            }
            if (mouseEvent.getClickCount() == 1) {
                LogVMainPanel.instance().getToolBar().getPropBtn().setEnabled(true);
                jMenuItem.setEnabled(true);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                return;
            }
        }

        TblMouseListener() {
            LogPanel.this = LogPanel.this;
        }
    }

    private class DateTimeEntry {
        String severity;
        Date date;
        String datestring;
        String timestring;

        public DateTimeEntry(String string, Date date) {
            LogPanel.this = LogPanel.this;
            this.severity = string;
            this.date = date;
            this.datestring = LogPanel.this.dateform.format(date);
            this.timestring = LogPanel.this.timeform.format(date);
        }

        public String toString() {
            return new String(String.valueOf(this.datestring) + "  " + this.timestring);
        }

        public String getSeverity() {
            return this.severity;
        }

        public Date get_date() {
            return this.date;
        }
    }

    private class SeverityRenderer
    extends DefaultTableCellRenderer {
        ImageIcon warningIcon = LogVMainPanel.instance().loadImageIcon("log-warning.gif", "Warning");
        ImageIcon errorIcon = LogVMainPanel.instance().loadImageIcon("log-error.gif", "Error");
        ImageIcon infoIcon = LogVMainPanel.instance().loadImageIcon("log-info.gif", "Information");

        public SeverityRenderer() {
            LogPanel.this = LogPanel.this;
        }

        protected void setValue(Object object) {
            if (object == null) {
                this.setText("");
                return;
            }
            if (object instanceof DateTimeEntry) {
                this.setText(((DateTimeEntry)object).toString());
                this.setIcon(((DateTimeEntry)object).getSeverity());
                return;
            }
            this.setText("");
        }

        public void setIcon(String string) {
            if (string.equals(LogRecordHeader.getSeverityString(1))) {
                this.setIcon(this.warningIcon);
                return;
            }
            if (string.equals(LogRecordHeader.getSeverityString(2))) {
                this.setIcon(this.errorIcon);
                return;
            }
            if (string.equals(LogRecordHeader.getSeverityString(0))) {
                this.setIcon(this.infoIcon);
                return;
            }
            this.setIcon(this.errorIcon);
        }
    }
}

