/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminDialog;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.hostmgr.client.AbstractPropsPanel;
import com.sun.admin.hostmgr.client.ContentPanel;
import com.sun.admin.hostmgr.client.HostAdvPropsPanel;
import com.sun.admin.hostmgr.client.HostGenPropsPanel;
import com.sun.admin.hostmgr.client.HostMgrContextHelpListener;
import com.sun.admin.hostmgr.client.HostPropsDialog;
import com.sun.admin.hostmgr.client.Main;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.HostWarningException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class HostPropsDialog
extends AdminDialog {
    HostData originalHostObj;
    ResourceBundle bundle;
    Vector groupPanels;
    boolean bNewHost;

    public HostPropsDialog(JFrame jFrame, HostData hostData, boolean bl) {
        super(jFrame, "", true);
        this.bNewHost = bl;
        this.bundle = Main.getApp().getResourceBundle();
        if (!bl) {
            this.setTitle(String.valueOf(ResourceStrings.getString(this.bundle, "ModHost")) + " " + hostData.getHostName());
        } else {
            this.setTitle(ResourceStrings.getString(this.bundle, "NewHost"));
        }
        GenInfoPanel genInfoPanel = this.getInfoPanel();
        this.groupPanels = new Vector();
        this.groupPanels.addElement(new HostGenPropsPanel(genInfoPanel, hostData, bl));
        this.groupPanels.addElement(new HostAdvPropsPanel(genInfoPanel, hostData, bl));
        JPanel jPanel = this.getRightPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        while (n < this.groupPanels.size()) {
            Constraints.constrain(jPanel, (JPanel)this.groupPanels.elementAt(n), 0, -1, 1, 1, 2, 18, 1.0, 0.0, 10, 5, 20, 5);
            ++n;
        }
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        JButton jButton = this.getOKBtn();
        jButton.addActionListener(new 1());
        Vector vector = Main.getApp().getHostMgr().getUserRights();
        if (!vector.contains("solaris.admin.hostmgr.write")) {
            jButton.setEnabled(false);
        }
        JPanel jPanel2 = this.getbuttonPanel();
        JButton jButton2 = this.getApplyBtn();
        if (bl) {
            jButton2.addActionListener(new 3());
        } else {
            jPanel2.remove(jButton2);
        }
        JButton jButton3 = this.getCancelBtn();
        jButton3.addActionListener(new 5());
        this.pack();
        this.setMySize(this.getSize());
        if (!bl) {
            this.setDefaultFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_hostprop_overview"), true);
        } else {
            this.setDefaultFocusListener(new HostMgrContextHelpListener(genInfoPanel, "dlg_newhost_overview"), true);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.originalHostObj = hostData;
    }

    public void onApply() throws HostException {
        int n;
        HostData hostData = new HostData();
        Main.getApp().getTree().getCurrentContentPanel().getDataCache();
        ContentPanel contentPanel = Main.getApp().getTree().getCurrentContentPanel();
        AbstractPropsPanel abstractPropsPanel = null;
        ProgressPanel progressPanel = new ProgressPanel(Main.getApp().getFrame(), 3, 30, false);
        try {
            Object[] objectArray;
            String string;
            n = 0;
            while (n < this.groupPanels.size()) {
                abstractPropsPanel = (AbstractPropsPanel)this.groupPanels.elementAt(n);
                abstractPropsPanel.dialogDataExchange(hostData);
                ++n;
            }
            boolean bl = false;
            if (this.bNewHost) {
                if (!contentPanel.offerNew(hostData, true)) {
                    string = "\n";
                    string = String.valueOf(string) + ResourceStrings.getString(this.bundle, "OptionAddHostFitMessage");
                    int n2 = JOptionPane.showConfirmDialog(null, string = String.valueOf(string) + "\n\n", ResourceStrings.getString(this.bundle, "OptionFitMessageTitle"), 0, 3);
                    if (n2 == 1) {
                        throw new HostException("");
                    }
                } else {
                    bl = true;
                }
                progressPanel.setTitle(ResourceStrings.getString(this.bundle, "AddHostTitle"));
                ((Component)progressPanel).setVisible(true);
                string = ResourceStrings.getString(this.bundle, "AddingHost");
                objectArray = new Object[]{hostData.getHostName()};
                progressPanel.setText(MessageFormat.format(string, objectArray));
                try {
                    Main.getApp().getHostMgr().addHost(hostData);
                }
                catch (HostWarningException hostWarningException) {
                    Main.getApp().reportErrorException(hostWarningException);
                    hostData = Main.getApp().getHostMgr().getHostByNameAddr(hostData.getHostName(), hostData.getNetworkAddress());
                }
                catch (Exception exception) {
                    throw exception;
                }
                progressPanel.appendText(ResourceStrings.getString(this.bundle, "UpdatingOtherViews"));
                ContentPanel.broadcastUpdate(null, hostData, false);
            } else {
                if (!contentPanel.offerNew(hostData, true)) {
                    string = "\n";
                    string = String.valueOf(string) + ResourceStrings.getString(this.bundle, "OptionModHostFitMessage");
                    int n3 = JOptionPane.showConfirmDialog(null, string = String.valueOf(string) + "\n\n", ResourceStrings.getString(this.bundle, "OptionFitMessageTitle"), 0, 3);
                    if (n3 == 1) {
                        throw new HostException("");
                    }
                }
                progressPanel.setTitle(ResourceStrings.getString(this.bundle, "ModifyHostTitle"));
                ((Component)progressPanel).setVisible(true);
                string = ResourceStrings.getString(this.bundle, "ModifyingHost");
                objectArray = new Object[]{hostData.getHostName()};
                progressPanel.setText(MessageFormat.format(string, objectArray));
                try {
                    Main.getApp().getHostMgr().setHost(this.originalHostObj, hostData);
                }
                catch (HostWarningException hostWarningException) {
                    Main.getApp().reportErrorException(hostWarningException);
                    hostData = Main.getApp().getHostMgr().getHostByNameAddr(hostData.getHostName(), hostData.getNetworkAddress());
                }
                catch (Exception exception) {
                    throw exception;
                }
                progressPanel.appendText(ResourceStrings.getString(this.bundle, "UpdatingOtherViews"));
                ContentPanel.broadcastUpdate(this.originalHostObj, hostData, false);
            }
            progressPanel.appendText(ResourceStrings.getString(this.bundle, "RepaintingCurrentView"));
            contentPanel.repaintView();
            if (bl) {
                contentPanel.getCurrentView().find(hostData);
            }
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
        }
        catch (Exception exception) {
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            if (exception.getLocalizedMessage().length() > 0) {
                Main.getApp().reportErrorException(exception);
            }
            throw new HostException(exception.getMessage());
        }
        n = 0;
        while (n < this.groupPanels.size()) {
            abstractPropsPanel = (AbstractPropsPanel)this.groupPanels.elementAt(n);
            this.originalHostObj = new HostData();
            abstractPropsPanel.dialogDataInitialize(this.originalHostObj);
            ++n;
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            2 var2_2 = new 2(HostPropsDialog.this);
            var2_2.start();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            4 var2_2 = new 4(HostPropsDialog.this);
            var2_2.start();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            HostPropsDialog.this.dispose();
        }

        /* synthetic */ 5() {
        }
    }
}

