/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.client.AdminSession;
import com.sun.admin.cis.client.IClientComm;
import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.cis.service.security.SecurityToken;
import com.sun.admin.hostmgr.client.ClientProxy;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import com.sun.admin.hostmgr.server.HostMgr;
import java.rmi.RemoteException;
import java.util.Vector;

public class HostMgrClient
extends ClientProxy {
    private HostMgr hostMgrServer;
    private AdminSession adminSession;
    private Vector vRights = new Vector();

    public boolean isDemo() {
        return false;
    }

    public Vector getUserRights() {
        return this.vRights;
    }

    public void setUpConnection(IClientComm iClientComm) throws Exception {
        this.adminSession = iClientComm.getAdminSession();
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        this.hostMgrServer = (HostMgr)this.adminSession.getAppFactory("com.sun.admin.hostmgr.server.HostMgrImpl");
        this.hostMgrServer.initializeScope(securityToken);
        try {
            this.vRights = this.hostMgrServer.getUserRights(securityToken);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void terminateConnection() throws Exception {
        this.adminSession.closeAppFactory("com.sun.admin.hostmgr.server.HostMgrImpl");
        return;
    }

    public Vector listHosts(ListProperties listProperties) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listHosts(securityToken, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int listHostsPrime(ListProperties listProperties) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listHostsPrime(securityToken, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listHostsNext() throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listHostsNext(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void listHostsEnd() throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            this.hostMgrServer.listHostsEnd(securityToken);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listHostsByNetwork(NetworkData networkData, ListProperties listProperties) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listHostsByNetwork(securityToken, networkData, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int listHostsByNetworkPrime(NetworkData networkData, ListProperties listProperties) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listHostsByNetworkPrime(securityToken, networkData, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listHostsByNetworkNext() throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listHostsByNetworkNext(securityToken);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void listHostsByNetworkEnd() throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            this.hostMgrServer.listHostsByNetworkEnd(securityToken);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void addHost(HostData hostData) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{hostData};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            this.hostMgrServer.addHost(securityToken, hostData);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void setHost(HostData hostData, HostData hostData2) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{hostData, hostData2};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            this.hostMgrServer.setHost(securityToken, hostData, hostData2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public int renameHost(HostData hostData, String string, Integer n) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{hostData, string, n};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            return this.hostMgrServer.renameHost(securityToken, hostData, string, n);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void deleteHost(HostData hostData) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{hostData};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            this.hostMgrServer.deleteHost(securityToken, hostData);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public HostData getHostByNameAddr(String string, String string2) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.getHostByNameAddr(securityToken, string, string2);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector getHostOtherAddrs(HostData hostData) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.getHostOtherAddrs(securityToken, hostData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public NetworkData getNetwork(NetworkData networkData) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.getNetwork(securityToken, networkData);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listNetworks(ListProperties listProperties) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listNetworks(securityToken, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public Vector listNetworkSubnets(NetworkData networkData, ListProperties listProperties) throws AdminException {
        SecurityToken securityToken = this.adminSession.getSecurityToken();
        try {
            return this.hostMgrServer.listNetworkSubnets(securityToken, networkData, listProperties);
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void addNetwork(NetworkData networkData) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{networkData};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            this.hostMgrServer.addNetwork(securityToken, networkData);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void deleteNetwork(NetworkData networkData) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{networkData};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            this.hostMgrServer.deleteNetwork(securityToken, networkData);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }

    public void setNetwork(NetworkData networkData, NetworkData networkData2) throws AdminException {
        Object[] objectArray = null;
        if (this.adminSession.isVerify()) {
            objectArray = new Object[]{networkData, networkData2};
        }
        SecurityToken securityToken = this.adminSession.getSecurityToken(objectArray);
        try {
            this.hostMgrServer.setNetwork(securityToken, networkData, networkData2);
            return;
        }
        catch (RemoteException remoteException) {
            throw new HostException("EXM_REMOTE", remoteException);
        }
    }
}

