/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.fsmgr.client.share;

import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.FlowArea;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.WarningDialog;
import com.sun.admin.fsmgr.client.FsMgr;
import com.sun.admin.fsmgr.client.FsMgrClient;
import com.sun.admin.fsmgr.client.FsMgrResourceStrings;
import com.sun.admin.fsmgr.client.share.FsMgrShareData;
import com.sun.admin.fsmgr.client.share.Share;
import com.sun.admin.fsmgr.client.share.ShareCacheEntry;
import com.sun.admin.fsmgr.common.FsMgrException;
import com.sun.admin.fsmgr.common.FsMgrShare;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UpdateAction {
    private ShareCacheEntry cacheEntry;
    private String cacheStatus;
    private FsMgrShareData newShareData;
    private boolean canUpdate = false;

    public UpdateAction(ShareCacheEntry shareCacheEntry, String string, FsMgrShareData fsMgrShareData) {
        String string2;
        this.cacheEntry = shareCacheEntry;
        this.cacheStatus = string;
        this.newShareData = fsMgrShareData;
        if (string.equals(ShareCacheEntry.ATBOOT)) {
            this.canUpdate = true;
            return;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        try {
            string2 = FsMgrResourceStrings.getString("ConfirmUpdateShareNumColumns");
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 30;
        }
        string2 = FsMgrResourceStrings.getString("ConfirmUpdateShare");
        FlowArea flowArea = new FlowArea(string2, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 0, 2, 1, 20, 5, 0, 5);
        String string3 = FsMgrResourceStrings.getString("ConfirmUpdateShareWill");
        flowArea = new FlowArea(string3, n, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 0, 1, 2, 1, 20, 5, 10, 5);
        String string4 = FsMgrResourceStrings.getString("DialogBulletGif");
        ImageIcon imageIcon = FsMgr.getFsMgr().loadImageIcon(string4, "DialogBulletGif");
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 2, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        String string5 = FsMgrResourceStrings.getString("ConfirmUpdateShareBullet1");
        flowArea = new FlowArea(string5, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 2, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new JLabel(imageIcon), 0, 3, 1, 1, 0, 18, 0.0, 0.0, 0, 10, 10, 5);
        String string6 = FsMgrResourceStrings.getString("ConfirmUpdateShareBullet2");
        flowArea = new FlowArea(string6, n - 5, Constants.ERROR_DIALOG_FONT);
        Constraints.constrain(jPanel, flowArea, 1, 3, 1, 1, 0, 5, 10, 5);
        Constraints.constrain(jPanel, new Box.Filler(new Dimension(10, 10), new Dimension(10, 10), new Dimension(10, 10)), 0, -1, 1, 0, 3, 18, 0.0, 1.0, 0, 0, 0, 0);
        new WarningDialog(FsMgr.getFsMgr().getFrame(), FsMgrResourceStrings.getString("ConfirmUpdateShareTitle"), jPanel, (ActionListener)new ConfirmUpdateListener(shareCacheEntry, string, fsMgrShareData), FsMgrResourceStrings.getString("UpdateShare"));
    }

    public void update() throws FsMgrException {
        if (!this.canUpdate) {
            return;
        }
        String string = FsMgrResourceStrings.getString("ModifyShareTitle");
        String string2 = FsMgrResourceStrings.getString("ModifyShareMessage");
        Object[] objectArray = new Object[]{this.newShareData.getPathname()};
        String string3 = MessageFormat.format(string2, objectArray);
        ProgressPanel progressPanel = new ProgressPanel(FsMgr.getFsMgr().getFrame(), 1, 30, false, false);
        progressPanel.setTitle(string);
        progressPanel.setText(string3);
        ((Component)progressPanel).setVisible(true);
        progressPanel.show();
        FsMgrShare fsMgrShare = this.newShareData.toFsMgrShare();
        try {
            String string4;
            FsMgrShare fsMgrShare2;
            if (this.cacheStatus.equals(ShareCacheEntry.BOTH) || this.cacheStatus.equals(ShareCacheEntry.NOW)) {
                fsMgrShare2 = this.cacheEntry.getData(ShareCacheEntry.NOW).toFsMgrShare();
                string4 = this.cacheEntry.getTable(ShareCacheEntry.NOW);
                FsMgrClient.instance().modifyShare(fsMgrShare2, fsMgrShare, string4);
            }
            if (this.cacheStatus.equals(ShareCacheEntry.BOTH) || this.cacheStatus.equals(ShareCacheEntry.ATBOOT)) {
                fsMgrShare2 = this.cacheEntry.getData(ShareCacheEntry.ATBOOT).toFsMgrShare();
                string4 = this.cacheEntry.getTable(ShareCacheEntry.ATBOOT);
                FsMgrClient.instance().modifyShare(fsMgrShare2, fsMgrShare, string4);
            }
        }
        catch (FsMgrException fsMgrException) {
            ((Component)progressPanel).setVisible(false);
            progressPanel.dispose();
            throw fsMgrException;
        }
        Share.getInstance().refresh(fsMgrShare.getPathname());
        try {
            Thread.currentThread();
            Thread.sleep(1500L);
        }
        catch (Exception exception) {}
        ((Component)progressPanel).setVisible(false);
        progressPanel.dispose();
    }

    static /* synthetic */ boolean access$0(UpdateAction updateAction) {
        return updateAction.canUpdate;
    }

    private class ConfirmUpdateListener
    implements ActionListener {
        ShareCacheEntry cacheEntry;
        String cacheStatus;
        FsMgrShareData newShareData;

        public ConfirmUpdateListener(ShareCacheEntry shareCacheEntry, String string, FsMgrShareData fsMgrShareData) {
            UpdateAction.this = UpdateAction.this;
            this.cacheEntry = shareCacheEntry;
            this.cacheStatus = string;
            this.newShareData = fsMgrShareData;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UpdateAction.this.canUpdate = true;
        }
    }
}

