/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.security;

import com.sun.admin.cis.common.AdminException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class SecurityPolicyObj
implements Serializable {
    public static final String ADM_AUTH_POLICY_FILES = "files";
    public static final String ADM_AUTH_POLICY_DOMAIN = "domain";
    public static final String ADM_SECMSG_POLICY_ON = "on";
    public static final String ADM_SECMSG_POLICY_OFF = "off";
    private boolean localEnabled = false;
    private boolean domainEnabled = false;
    private boolean localFirst = false;
    private boolean secureMsgEnabled = false;
    private String domainType = null;
    private String domainName = null;

    public SecurityPolicyObj() {
    }

    public SecurityPolicyObj(String string, String string2) throws AdminException {
        this();
        this.parseAuthPolicy(string);
        this.parseMsgPolicy(string2);
    }

    public boolean isLocalEnabled() {
        return this.localEnabled;
    }

    public boolean isDomainEnabled() {
        return this.domainEnabled;
    }

    public boolean isLocalFirst() {
        return this.localFirst;
    }

    public boolean isSecureMsgEnabled() {
        return this.secureMsgEnabled;
    }

    public String getDomainType() {
        return this.domainType;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void enableLocal() {
        this.localEnabled = true;
    }

    public void disableLocal() {
        this.localEnabled = false;
    }

    public void enableDomain() {
        this.domainEnabled = true;
    }

    public void disableDomain() {
        this.domainEnabled = false;
    }

    public void setLocalFirst() {
        this.localFirst = true;
    }

    public void setDomainFirst() {
        this.localFirst = false;
    }

    public void enableSecureMsg() {
        this.secureMsgEnabled = true;
    }

    public void disableSecureMsg() {
        this.secureMsgEnabled = false;
    }

    public void setDomainType(String string) {
        this.domainType = string;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public String getAuthPolicy() {
        String string = "";
        if (this.isLocalEnabled() && this.isDomainEnabled()) {
            string = this.isLocalFirst() ? "files domain" : "domain files";
        } else if (this.isLocalEnabled()) {
            string = ADM_AUTH_POLICY_FILES;
        } else if (this.isDomainEnabled()) {
            string = ADM_AUTH_POLICY_DOMAIN;
        }
        return string;
    }

    public String getSecureMsgPolicy() {
        String string = ADM_SECMSG_POLICY_OFF;
        if (this.isSecureMsgEnabled()) {
            string = ADM_SECMSG_POLICY_ON;
        }
        return string;
    }

    public Object clone() {
        SecurityPolicyObj securityPolicyObj = new SecurityPolicyObj();
        if (this.localEnabled) {
            securityPolicyObj.enableLocal();
        }
        if (this.domainEnabled) {
            securityPolicyObj.enableDomain();
        }
        if (this.localFirst) {
            securityPolicyObj.setLocalFirst();
        }
        if (this.secureMsgEnabled) {
            securityPolicyObj.enableSecureMsg();
        }
        securityPolicyObj.setDomainType(this.domainType);
        securityPolicyObj.setDomainName(this.domainName);
        return securityPolicyObj;
    }

    public String toString() {
        return "Security policy: auth=" + this.getAuthPolicy() + ", secure msg=" + this.getSecureMsgPolicy();
    }

    private void parseAuthPolicy(String string) throws AdminException {
        if (string != null) {
            String string2;
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            try {
                string3 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                string3 = null;
            }
            try {
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                string2 = null;
            }
            if (string3 != null) {
                if (string3.equals(ADM_AUTH_POLICY_FILES)) {
                    this.enableLocal();
                    this.setLocalFirst();
                } else if (string3.equals(ADM_AUTH_POLICY_DOMAIN)) {
                    this.enableDomain();
                    this.setDomainFirst();
                } else {
                    string3 = null;
                }
            }
            if (string3 == null) {
                throw new AdminException("Invalid authorization search policy");
            }
            if (string2 != null) {
                if (string2.equals(ADM_AUTH_POLICY_FILES)) {
                    if (this.isLocalEnabled()) {
                        throw new AdminException("Invalid authorization search policy");
                    }
                    this.enableLocal();
                    return;
                }
                if (string2.equals(ADM_AUTH_POLICY_DOMAIN)) {
                    if (this.isDomainEnabled()) {
                        throw new AdminException("Invalid authorization search policy");
                    }
                    this.enableDomain();
                    return;
                }
                throw new AdminException("Invalid authorization search policy");
            }
        } else {
            throw new AdminException("Invalid authorizatino search policy");
        }
    }

    private void parseMsgPolicy(String string) throws AdminException {
        this.disableSecureMsg();
        if (string.equals(ADM_SECMSG_POLICY_ON)) {
            this.enableSecureMsg();
        }
    }
}

