/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableAccessException;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableLibrary;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotFoundException;
import com.sun.admin.cis.service.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.admin.cis.service.directorytable.FileEditor;
import com.sun.admin.cis.service.directorytable.FileTableDefinitions;
import com.sun.admin.cis.service.directorytable.SearchTemplate;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import com.sun.admin.cis.service.directorytable.TableSetup;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class FileDirectoryTable
implements DirectoryTable,
TableSetup {
    private static int ROW_INCREMENT = 5;
    FileEditor fileEditor;
    TableDefinitions tableDefinitions;
    boolean singleSeparatorOnly;
    boolean allowsInlineComment;
    boolean allowEscapes;
    boolean caseSensitive;
    boolean needsFlush;
    String directoryContext;

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
        fileTableDefinitions.loadTableDefinitions(string);
        String string2 = fileTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string2, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public void open(String string) throws DirectoryTableException {
        FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
        fileTableDefinitions.loadTableDefinitions(string);
        if (DirectoryTableLibrary.fileAccess(fileTableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(string, "file", string);
        }
        this.tableDefinitions = fileTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (DirectoryTableLibrary.fileAccess(tableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "file", tableDefinitions.getMappedTableName());
        }
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        n = DirectoryTableLibrary.convertAccessToMode(tableDefinitions.getAccess());
        n2 = DirectoryTableLibrary.fileCreate(tableDefinitions.getMappedTableName(), tableDefinitions.getUser(), tableDefinitions.getGroup(), n);
        DirectoryTableLibrary.errnoToException(n2, tableDefinitions);
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void create(String string) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
        fileTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.convertAccessToMode(fileTableDefinitions.getAccess());
        n2 = DirectoryTableLibrary.fileCreate(fileTableDefinitions.getMappedTableName(), fileTableDefinitions.getUser(), fileTableDefinitions.getGroup(), n);
        DirectoryTableLibrary.errnoToException(n2, fileTableDefinitions);
        this.tableDefinitions = fileTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.allowEscapes = (this.tableDefinitions.getTableAttributes() & 0x10) == 16;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.needsFlush = false;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.fileDelete(tableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
        fileTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.fileDelete(fileTableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, fileTableDefinitions);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (DirectoryTableException directoryTableException) {
            this.needsFlush = false;
        }
        this.tableDefinitions = null;
        this.fileEditor = null;
        this.singleSeparatorOnly = false;
        this.allowsInlineComment = false;
        this.allowEscapes = false;
    }

    public void flush() throws DirectoryTableException {
        if (this.needsFlush) {
            this.needsFlush = false;
        }
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = 0;
        DirectoryRow directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.fileEditor.getFirstLine();
        if (string != null) {
            this.parseStringIntoRow(string, directoryRow2, 1);
            if (!directoryRow2.isEmpty()) {
                n = 1;
                while (n <= directoryRow.getNumberOfRows()) {
                    if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                        throw new DirectoryTableRowNotUniqueException();
                    }
                    ++n;
                }
            }
            string = this.fileEditor.getNextLine();
            while (string != null) {
                directoryRow2.clearRow(1);
                this.parseStringIntoRow(string, directoryRow2, 1);
                if (!directoryRow2.isEmpty()) {
                    n = 1;
                    while (n <= directoryRow.getNumberOfRows()) {
                        if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                            throw new DirectoryTableRowNotUniqueException();
                        }
                        ++n;
                    }
                }
                string = this.fileEditor.getNextLine();
            }
        }
        n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            String string2 = this.getRowAsString(directoryRow, n);
            this.fileEditor.addLine(string2);
            ++n;
        }
        this.needsFlush = true;
    }

    public void deleteRow(DirectoryRow directoryRow) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        int n = 0;
        DirectoryRow directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.fileEditor.getFirstLine();
        int n2 = directoryRow.getNumberOfRows();
        Vector<String> vector = new Vector<String>();
        vector.setSize(n2);
        if (string != null) {
            this.parseStringIntoRow(string, directoryRow2, 1);
            if (!directoryRow2.isEmpty()) {
                n = 1;
                while (n <= n2) {
                    if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                        vector.setElementAt(string, n - 1);
                    }
                    ++n;
                }
            }
            string = this.fileEditor.getNextLine();
            while (string != null) {
                directoryRow2.clearRow(1);
                this.parseStringIntoRow(string, directoryRow2, 1);
                if (!directoryRow2.isEmpty()) {
                    n = 1;
                    while (n <= n2) {
                        if (directoryRow.matchRow(directoryRow2, 1, n, this.tableDefinitions)) {
                            vector.setElementAt(string, n - 1);
                        }
                        ++n;
                    }
                }
                string = this.fileEditor.getNextLine();
            }
        }
        n = 0;
        while (n < n2) {
            if (vector.elementAt(n) == null) {
                throw new DirectoryTableRowNotFoundException();
            }
            ++n;
        }
        n = 0;
        while (n < n2) {
            this.fileEditor.deleteLine((String)vector.elementAt(n));
            ++n;
        }
        this.needsFlush = true;
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        if ((this.tableDefinitions.getTableAttributes() & 1) == 1) {
            throw new DirectoryTableAccessException("EXM_READONLY");
        }
        DirectoryRow directoryRow3 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.fileEditor.getFirstLine();
        String string2 = this.getRowAsString(directoryRow2, 1);
        if (string == null) {
            throw new DirectoryTableRowNotFoundException();
        }
        String string3 = string;
        this.parseStringIntoRow(string, directoryRow3, 1);
        if (directoryRow3.getNumberOfColumns() > 0 && directoryRow.matchRow(directoryRow3, 1, this.tableDefinitions)) {
            this.fileEditor.modifyLine(string3, string2);
            this.needsFlush = true;
            return;
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            directoryRow3.clearRow(1);
            string3 = string;
            this.parseStringIntoRow(string, directoryRow3, 1);
            if (directoryRow3.getNumberOfColumns() > 0 && directoryRow.matchRow(directoryRow3, 1, this.tableDefinitions)) {
                this.fileEditor.modifyLine(string3, string2);
                this.needsFlush = true;
                return;
            }
            string = this.fileEditor.getNextLine();
        }
        throw new DirectoryTableRowNotFoundException();
    }

    public DirectoryRow getFirstRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getFirstRow(directoryRow);
    }

    public DirectoryRow getNextRow() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        return this.getNextRow(directoryRow);
    }

    public DirectoryRow getFirstRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.fileEditor.getFirstLine();
        if (string == null) {
            return null;
        }
        this.parseStringIntoRow(string, directoryRow, 1);
        if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
            return directoryRow;
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            directoryRow.clearRow(1);
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            string = this.fileEditor.getNextLine();
        }
        return null;
    }

    public DirectoryRow getNextRow(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns());
        String string = this.fileEditor.getNextLine();
        while (string != null) {
            directoryRow.clearRow(1);
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                return directoryRow;
            }
            string = this.fileEditor.getNextLine();
        }
        return null;
    }

    public DirectoryRow getAll() throws DirectoryTableException {
        DirectoryRow directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), ROW_INCREMENT);
        String string = this.fileEditor.getFirstLine();
        int n = 1;
        int n2 = ROW_INCREMENT;
        int n3 = 0;
        if (string == null) {
            return null;
        }
        n3 = this.parseStringIntoRow(string, directoryRow, n);
        if (n3 > 0) {
            if (--n2 == 0) {
                directoryRow.addRows(ROW_INCREMENT);
                n2 = ROW_INCREMENT;
            }
            ++n;
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            n3 = this.parseStringIntoRow(string, directoryRow, n);
            if (n3 > 0) {
                if (--n2 == 0) {
                    directoryRow.addRows(ROW_INCREMENT);
                    n2 = ROW_INCREMENT;
                }
                ++n;
            }
            string = this.fileEditor.getNextLine();
        }
        if (n == 1 && directoryRow.isEmpty(n)) {
            return null;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            directoryRow.deleteRow(n + n4);
            --n4;
        }
        return directoryRow;
    }

    public DirectoryRow getAll(SearchTemplate searchTemplate) throws DirectoryTableException {
        DirectoryRow directoryRow = null;
        DirectoryRow directoryRow2 = null;
        String string = this.fileEditor.getFirstLine();
        int n = 0;
        if (string == null) {
            return directoryRow2;
        }
        directoryRow = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
        this.parseStringIntoRow(string, directoryRow, 1);
        if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
            if (n == 0) {
                directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                n = 1;
            }
            this.parseStringIntoRow(string, directoryRow2, n);
            ++n;
        }
        string = this.fileEditor.getNextLine();
        while (string != null) {
            directoryRow.clearRow(1);
            this.parseStringIntoRow(string, directoryRow, 1);
            if (!directoryRow.isEmpty() && searchTemplate.matchRow(directoryRow, 1, this.tableDefinitions)) {
                if (n == 0) {
                    directoryRow2 = new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
                    n = 1;
                } else {
                    directoryRow2.addRows(1);
                }
                this.parseStringIntoRow(string, directoryRow2, n);
                ++n;
            }
            string = this.fileEditor.getNextLine();
        }
        return directoryRow2;
    }

    public DirectoryRow getRowInstance() {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), 1);
    }

    public DirectoryRow getRowInstance(int n) {
        return new DirectoryRow(this.tableDefinitions.getNumberOfColumns(), n);
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new FileTableDefinitions();
    }

    public TableDefinitions getCurrentTableDefinitions() {
        return this.tableDefinitions;
    }

    public int parseStringIntoRow(String string, DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2;
        int n3 = 0;
        boolean bl = false;
        bl = this.tableDefinitions.getTableName().equals("aliases");
        char[] cArray = string.toCharArray();
        int n4 = cArray.length;
        char[] cArray2 = this.tableDefinitions.getCommentSeparators().toCharArray();
        int n5 = cArray2.length;
        char[] cArray3 = this.tableDefinitions.getColumnSeparators().toCharArray();
        int n6 = cArray3.length;
        boolean bl2 = false;
        int n7 = 0;
        while (n7 < n4) {
            if (n6 > 1) {
                n2 = 1;
                while (n2 < n6) {
                    if (cArray[n7] == cArray3[n2]) {
                        cArray[n7] = cArray3[0];
                    }
                    ++n2;
                }
            }
            if (!bl2 && cArray[n7] != cArray3[0]) {
                bl2 = true;
            }
            n2 = 0;
            while (n2 < n5) {
                if (cArray[n7] == cArray2[n2]) {
                    if (n7 == 0) {
                        return n3;
                    }
                    if (this.allowsInlineComment && n7 < n4) {
                        directoryRow.putColumn(this.tableDefinitions.getNumberOfColumns(), n, new String(cArray, n7 + 1, n4 - n7 - 1));
                        ++n3;
                        n4 = n7;
                    }
                }
                ++n2;
            }
            ++n7;
        }
        if (!bl2) {
            return n3;
        }
        char c = cArray3[0];
        int n8 = 1;
        n2 = 0;
        if (n2 < n4 && cArray[n2] == c) {
            ++n2;
        }
        if (!bl) {
            while (n2 < n4 && cArray[n2] == c) {
                ++n2;
                if (!this.singleSeparatorOnly) continue;
                ++n8;
            }
        }
        while (n2 < n4) {
            if (this.tableDefinitions.getColumnName(n8).equals("aliases")) {
                directoryRow.putColumn(n8, n, new String(cArray, n2, n4 - n2));
                return ++n3;
            }
            if (this.tableDefinitions.getColumnName(n8).equals("expansion")) {
                directoryRow.putColumn(n8, n, new String(cArray, n2, n4 - n2));
                return ++n3;
            }
            n7 = n2;
            while (n7 < n4 && cArray[n7] != c) {
                ++n7;
            }
            if (n7 != n2) {
                directoryRow.putColumn(n8, n, new String(cArray, n2, n7 - n2));
                ++n8;
                ++n3;
            }
            n2 = n7 + 1;
            if (bl) continue;
            while (n2 < n4 && cArray[n2] == c) {
                ++n2;
                if (!this.singleSeparatorOnly) continue;
                ++n8;
            }
        }
        return n3;
    }

    public String getRowAsString(DirectoryRow directoryRow, int n) throws DirectoryTableException {
        int n2;
        String string = "";
        char c = this.tableDefinitions.getColumnSeparators().charAt(0);
        char c2 = this.tableDefinitions.getCommentSeparators().charAt(0);
        int n3 = 0;
        if (this.allowsInlineComment) {
            n2 = this.tableDefinitions.getNumberOfColumns() - 1;
            n3 = this.tableDefinitions.getNumberOfColumns();
        } else {
            n2 = this.tableDefinitions.getNumberOfColumns();
        }
        int n4 = 1;
        while (n4 <= n2) {
            if (n4 != 1) {
                string = String.valueOf(string) + c;
            }
            if (!directoryRow.getColumn(n4, n).equals("")) {
                string = string.concat(directoryRow.getColumn(n4, n));
            }
            ++n4;
        }
        if (this.allowsInlineComment && !directoryRow.getColumn(n3, n).equals("")) {
            string = string.concat(String.valueOf(c2) + directoryRow.getColumn(n3, n));
        }
        return string;
    }

    public void setContext(String string) throws DirectoryTableException {
        this.directoryContext = string;
    }

    public Vector getScopes(int n) {
        String string;
        Vector<String> vector = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = "";
        }
        FileTableDefinitions fileTableDefinitions = new FileTableDefinitions();
        try {
            fileTableDefinitions.loadTableDefinitions("group");
        }
        catch (Exception exception) {
            return vector;
        }
        String string2 = fileTableDefinitions.getMappedTableName();
        if ((n & 2) == 2) {
            if (DirectoryTableLibrary.fileAccess(string2, 2) == 0) {
                vector = new Vector<String>();
                vector.addElement("file:/" + string + "/" + string);
            }
        } else if (DirectoryTableLibrary.fileAccess(string2, 4) == 0) {
            vector = new Vector();
            vector.addElement("file:/" + string + "/" + string);
        }
        return vector;
    }

    public void setup() {
    }

    public void refreshSetup() {
    }
}

