/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.directorytable;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.AdminProps;
import com.sun.admin.cis.service.directorytable.DirectoryTableLibrary;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class DirectoryUtility {
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_ISMASTER = "check";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_PWDIR = "/etc";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_ALIASES = "/etc/mail/aliases";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_DIR = "/etc";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_MAKEPATH = "/var/yp";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_MAKEFILE = "Makefile";
    public static final String DEFAULT_DIRECTORY_TABLE_NIS_UPDATESCHEDULE = "always";

    protected static int compareColumns(String string, String string2, int n) {
        if ((n & 8) == 8) {
            return string2.compareTo(string);
        }
        if ((n & 4) == 4) {
            int n2 = Integer.valueOf(string);
            int n3 = Integer.valueOf(string2);
            return n2 - n3;
        }
        if ((n & 2) == 2) {
            return DirectoryTableLibrary.addressCompare(string, string2);
        }
        return 0;
    }

    protected static String getDirectoryTableProperty(String string) throws AdminException {
        AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 0);
        return adminProps.getAdminProp(string);
    }

    protected static Vector getDirectoryTablePropertyList(String string) throws AdminException {
        AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 0);
        return adminProps.getAdminPropList(string);
    }

    protected static void setDirectoryTableProperty(String string, String string2) throws AdminException {
        AdminProps adminProps = new AdminProps("admin.server.properties", "AdminServer.properties", 1);
        adminProps.putAdminProp(string, string2);
        adminProps.saveAdminProps("Management Server Properties - Do Not Edit");
    }

    protected static String getServerFromContext(String string) {
        String string2;
        int n = 0;
        int n2 = 0;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = new String("");
        }
        n2 = string.indexOf("/");
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n2 > 0) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }

    protected static String getDomainFromContext(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = new String("");
        n2 = string.indexOf("/");
        if (n2 == -1) {
            return string2;
        }
        if (n2 == string.length()) {
            return string2;
        }
        n = n2 + 1;
        if ((n2 = string.indexOf("/", n)) == -1) {
            n2 = string.length();
        }
        if (n2 - n > 0) {
            string2 = string.substring(n, n2);
        }
        return string2;
    }
}

