/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.cis.service.authorization;

import com.sun.admin.cis.common.AdminCommonTools;
import com.sun.admin.cis.service.authorization.KeyValue;
import com.sun.admin.cis.service.authorization.UserAttrObj;
import com.sun.admin.cis.service.authorization.UserAttrTable;
import com.sun.admin.cis.service.directorytable.DirectoryRow;
import com.sun.admin.cis.service.directorytable.DirectoryTable;
import com.sun.admin.cis.service.directorytable.DirectoryTableDoesNotExistException;
import com.sun.admin.cis.service.directorytable.DirectoryTableException;
import com.sun.admin.cis.service.directorytable.DirectoryTableFactory;
import com.sun.admin.cis.service.directorytable.TableDefinitions;
import java.util.Hashtable;

public class SolarisUserAttrTable
implements UserAttrTable {
    private static final String table = new String("user_attr");
    private static final String emptyString = new String("");
    private static final String nameCol = "name";
    private static final String qualCol = "qualifier";
    private static final String res1Col = "res1";
    private static final String res2Col = "res2";
    private static final String attrCol = "attr";
    private Hashtable attrGetterHash;
    private Hashtable attrSetterHash;
    private String scope;
    static /* synthetic */ Class array$Ljava$lang$String;

    public SolarisUserAttrTable(String string) {
        this.scope = string;
        Class[] classArray = new Class[]{};
        Class[] classArray2 = new Class[]{array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = SolarisUserAttrTable.class$("[Ljava.lang.String;"))};
        UserAttrObj userAttrObj = new UserAttrObj();
        this.attrGetterHash = KeyValue.getAttrHash(userAttrObj, classArray, UserAttrObj.knownKeys, UserAttrObj.getters);
        this.attrSetterHash = KeyValue.getAttrHash(userAttrObj, classArray2, UserAttrObj.knownKeys, UserAttrObj.setters);
    }

    public UserAttrObj readUserAttr(String string) throws DirectoryTableException {
        String string2 = null;
        return this.readUserAttr(string, string2);
    }

    public UserAttrObj readUserAttr(String string, String string2) throws DirectoryTableException {
        DirectoryTable directoryTable;
        UserAttrObj userAttrObj;
        block4: {
            userAttrObj = null;
            directoryTable = this.openUserAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                if (string2 != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(qualCol), string2);
                }
                if ((directoryRow = directoryTable.getFirstRow(directoryRow)) != null) {
                    userAttrObj = new UserAttrObj(string);
                    userAttrObj.setQualifier(directoryRow.getColumn(tableDefinitions.getColumnNumber(qualCol)));
                    String string3 = directoryRow.getColumn(tableDefinitions.getColumnNumber(attrCol));
                    KeyValue.getAttributes(userAttrObj, string3, this.attrSetterHash);
                    break block4;
                }
                AdminCommonTools.CMN_Trace3("Attributes for " + string + " do not exist");
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var6_8 = null;
        directoryTable.close();
        return userAttrObj;
    }

    public UserAttrObj newUserAttr(String string) throws DirectoryTableException {
        return new UserAttrObj(string);
    }

    public UserAttrObj newUserAttr(String string, String string2) throws DirectoryTableException {
        UserAttrObj userAttrObj = new UserAttrObj(string);
        userAttrObj.setQualifier(string2);
        return userAttrObj;
    }

    public void writeUserAttr(UserAttrObj userAttrObj) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openUserAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), userAttrObj.getUserName());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(qualCol), userAttrObj.getQualifier());
                DirectoryRow directoryRow2 = directoryTable.getFirstRow(directoryRow);
                String string = directoryRow2 != null ? directoryRow2.getColumn(tableDefinitions.getColumnNumber(attrCol)) : null;
                String string2 = KeyValue.putAttributes(userAttrObj, string, this.attrGetterHash);
                directoryRow.putColumn(tableDefinitions.getColumnNumber(attrCol), string2);
                if (directoryRow2 == null) {
                    directoryTable.addRow(directoryRow);
                    break block3;
                }
                directoryTable.modifyRow(directoryRow2, directoryRow);
            }
            catch (Throwable throwable) {
                Object var4_9 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var4_8 = null;
        directoryTable.close();
    }

    public void removeUserAttr(String string) throws DirectoryTableException {
        String string2 = null;
        this.removeUserAttr(string, string2);
    }

    public void removeUserAttr(String string, String string2) throws DirectoryTableException {
        DirectoryTable directoryTable;
        block3: {
            directoryTable = this.openUserAttrTable();
            try {
                TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
                DirectoryRow directoryRow = new DirectoryRow(tableDefinitions.getNumberOfColumns());
                directoryRow.putColumn(tableDefinitions.getColumnNumber(nameCol), string);
                if (string2 != null) {
                    directoryRow.putColumn(tableDefinitions.getColumnNumber(qualCol), string2);
                }
                if ((directoryRow = directoryTable.getFirstRow(directoryRow)) == null) break block3;
                directoryTable.deleteRow(directoryRow);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                directoryTable.close();
                throw throwable;
            }
        }
        Object var5_6 = null;
        directoryTable.close();
    }

    public void removeUserAttr(UserAttrObj userAttrObj) throws DirectoryTableException {
        String string = userAttrObj.getUserName();
        String string2 = userAttrObj.getQualifier();
        this.removeUserAttr(string, string2);
    }

    public void createUserAttrTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        boolean bl = true;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope);
            directoryTable.open(table);
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            bl = false;
        }
        catch (DirectoryTableException directoryTableException) {
            AdminCommonTools.CMN_Trace1("Unexpected error creating user auth table: " + directoryTableException.getMessage());
            directoryTable.close();
            throw directoryTableException;
        }
        TableDefinitions tableDefinitions = null;
        try {
            try {
                if (!bl) {
                    tableDefinitions = directoryTable.getTableDefinitionsInstance();
                    tableDefinitions.loadTableDefinitions(table);
                    directoryTable.create(table);
                }
            }
            catch (DirectoryTableException directoryTableException) {
                AdminCommonTools.CMN_Trace1("Auth: error creating user attr table: " + directoryTableException.getMessage());
                throw directoryTableException;
            }
            Object var5_7 = null;
            directoryTable.close();
            return;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            directoryTable.close();
            throw throwable;
        }
    }

    private DirectoryTable openUserAttrTable() throws DirectoryTableException {
        DirectoryTableFactory directoryTableFactory = new DirectoryTableFactory();
        DirectoryTable directoryTable = DirectoryTableFactory.getDirectoryTableInstance(this.scope);
        directoryTable.open(table);
        return directoryTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

