/*
 * Copyright (c) 1991, 1992, 1993, 1994 by Network Peripherals Inc. All
 * rights reserved.
 */
/*
 * Common .h between smt driver and smt daemon/stat programs
 */
#pragma	ident	"@(#)nfsmt.h	2.2	09/28/98	NPI"

/* NOTE BASED ON STANDARD DOCUMENT X3T9.5/84-49 IE SMT6.1 */

/*
 * Ioctl controls
 */
#include <sys/ioccom.h>
#include <sys/socket.h>
#include <net/if.h>
typedef struct {
	unsigned char   address[6];
}               network_address_type_def;

#define USE_STR_IOC

#ifdef USE_STR_IOC
#define SMTIOC	(u_int) (('S'+'M'+'T') << 8)
#define SMT_IOCTL_R_MYFDDIADDR (SMTIOC | 1)
#define SMT_IOCTL_R_MYENETADDR (SMTIOC | 2)
#define SMT_IOCTL_P_Basic_HPC (SMTIOC | 4)
#define SMT_IOCTL_R_HPC (SMTIOC | 5)
#define SMT_IOCTL_W_HPC (SMTIOC | 6)
#define SMT_IOCTL_R_SMT_TIMESTAMP (SMTIOC | 7)
#define SET_LLC_NOT_AVAIL (SMTIOC | 13)
#define SET_LLC_AVAIL (SMTIOC | 12)

#define SMT_GET	(SMTIOC | 21)
#define SMT_SET	(SMTIOC | 22)
#define SMT_ACT	(SMTIOC | 23)

#else
#define SMT_IOCTL_R_MYFDDIADDR _IOR('w',1,network_address_type_def)
#define SMT_IOCTL_R_MYENETADDR _IOR('w',2,network_address_type_def)
#define SMT_IOCTL_P_Basic_HPC _IO('w',4)
#define SMT_IOCTL_R_HPC _IOWR('w',5,int)
#define SMT_IOCTL_W_HPC _IOW('w',6,int)
#define SMT_IOCTL_R_SMT_TIMESTAMP _IORN('w',7,2*sizeof(int))
#define SET_LLC_NOT_AVAIL _IO('w',13)
#define SET_LLC_AVAIL _IO('w',12)
#endif				/* USE_STR_IOC */

/*
 * ***********************************************************
 * 
********************* HPC DEFINITIONS ********************* ***********************************************************
 * 
 */

/* HPC - Misc stuff */
#define HPC_NOT_WRITE_READY ((char)0x01)
#define HPC_NOT_READ_READY ((char)0x02)


/*
 * HPC data size definition bits
 */
#define HPC_SIZE_MASK 0x1800
#define HPC_NO_DATA   0x0000
#define HPC_SIZE_LONG 0x0800
#define HPC_SIZE_WORD 0x1000
#define HPC_SIZE_BYTE 0x1800


/* HPC  Dependant defines Mailbox commands */
/* Operations (other than heart bypass which is defined in med.h) */
#define HPC_SIGNAL 	0x0000
#define HPC_WRITE		0x2000
#define HPC_OR			0x4000
#define HPC_AND		0x6000
#define HPC_READ		0x8000
#define HPC_XCHG		0xA000
#define HPC_TEST_AND_SET 0xC000
#define HPC_TEST_AND_CLR 0xE000

/* Memory map of HPC controlled data space */
#define HPC_SMT_REGS 0x0200

#define HPC_MAC1_REGS 0x0280
#define HPC_MAC2_REGS 0x02C0
#define HPC_RMT1_REGS HPC_MAC1_REGS
#define HPC_RMT2_REGS HPC_MAC2_REGS

#define HPC_PORT1_REGS 0x0300
#define HPC_PORT2_REGS 0x0340
#define HPC_PORT3_REGS 0x0380
#define HPC_PORT4_REGS 0x03C0
#define HPC_CMT1_REGS HPC_PORT1_REGS
#define HPC_CMT2_REGS HPC_PORT2_REGS
#define HPC_CMT3_REGS HPC_PORT3_REGS
#define HPC_CMT4_REGS HPC_PORT4_REGS

#define HPC_PLAYER1_REGS 0x0500
#define HPC_PLAYER2_REGS 0x0540
#define HPC_PLAYER3_REGS 0x0580
#define HPC_PLAYER4_REGS 0x05C0

#define HPC_BMAC1_REGS 0x0600
#define HPC_BMAC2_REGS 0x0700

/* composits and bit definitions */
#define HPC_SIGNAL_RESET ((unsigned short)(0x001a))
#define HPC_SIGNAL_EC_CONNECT ((unsigned short)(0x0003 | HPC_SMT_REGS))
#define HPC_SIGNAL_EC_DISCONNECT ((unsigned short)(0x0002 | HPC_SMT_REGS))
#define HPC_SIGNAL_EC_PTPASS ((unsigned short)(0x0006 | HPC_SMT_REGS))
#define HPC_SIGNAL_RMT1_ISOLATE ((unsigned short)(0x0032 | HPC_RMT1_REGS))
#define CLEAR_HPC_INT_COND 0x000f

#define HPC_SIGNAL_DAD_FAIL  0x0034
#define HPC_SIGNAL_DAD_PASS  0x0035

#define HPC_BMAC1_ADDR_REG (0x0040 | HPC_BMAC1_REGS | HPC_WRITE | HPC_SIZE_BYTE)
#define HPC_RMT1_TREQ_REG (0x000c | HPC_RMT1_REGS | HPC_WRITE | HPC_SIZE_WORD)

#define HPC_BMAC1_MCAST_REG (0x0048 | HPC_BMAC1_REGS | HPC_SIZE_BYTE)
#define HPC_BMAC1_PGM0_REG	(0x0070 | HPC_BMAC1_REGS | HPC_SIZE_BYTE)
#define HPC_BMAC1_PGM10_REG	(0x0060 | HPC_BMAC1_REGS | HPC_SIZE_BYTE)

#define HPC_RMT1_STATE_REG (0x0000 | HPC_RMT1_REGS | HPC_SIZE_WORD)



/* RMT State/Status Register */

#if (SMT7_2 != CFG_YES)
#define RMT_ST_MASK			0x07
#define RMT_ST_ISOLATED		0x00
#define RMT_ST_NON_OP		0x01
#define RMT_ST_RIGN_OP		0X02
#define RMT_ST_DETECT 		0x03
#define RMT_ST_NON_OP_DUP	0x04
#define RMT_ST_RING_OP_DUP	0x05
#define RMT_ST_DIRECTED		0x06
#define RMT_ST_TRACE		0x07
#endif


/* Clearing ints from HPC */
#define HPC_PORTP (0x0152 | HPC_SIZE_WORD)
#define HPC_PORTP_INT_BIT 0x1000
#define HPC_PORTP_ENBP    0x0100/* Optical Bypass Control Bit */

/* HPC Registers */
#define HPC_CBUS_DEVICES         (0x07 | HPC_SMT_REGS | HPC_SIZE_BYTE)

/* Interrupt summary */
#define HPC_INT_SUMMARY (0x0A | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_INT_SUMMARY_MASK (0x0B | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_INT_SUMMARY_TMR_EVENT BIT_0
#define HPC_INT_SUMMARY_SMT_EVENT BIT_1
#define HPC_INT_SUMMARY_RMT_EVENT BIT_2
#define HPC_INT_SUMMARY_PORT_EVENT BIT_4
#define HPC_INT_SUMMARY_PORT1_EVENT BIT_4
#define HPC_INT_SUMMARY_PORT2_EVENT BIT_5
#define HPC_SMT_EVENT_SUMMARY 	(0x0c | HPC_SMT_REGS | HPC_SIZE_WORD)
#define HPC_SMT_EVENT_MASK 		(0x0e | HPC_SMT_REGS | HPC_SIZE_WORD)
#define HPC_RMT_EVENT_SUMMARY 	(0x04 | HPC_RMT1_REGS | HPC_SIZE_WORD)
#define HPC_RMT_EVENT_MASK 		(0x06 | HPC_RMT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT_EVENT_SUMMARY 	(0x34 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT_EVENT_MASK 		(0x36 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT1_EVENT_SUMMARY 	(0x34 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT1_EVENT_MASK 		(0x36 | HPC_PORT1_REGS | HPC_SIZE_WORD)
#define HPC_PORT2_EVENT_SUMMARY 	(0x34 | HPC_PORT2_REGS | HPC_SIZE_WORD)
#define HPC_PORT2_EVENT_MASK 		(0x36 | HPC_PORT2_REGS | HPC_SIZE_WORD)
#define HPC_TMR_EVENT_SUMMARY 	(0x16 | HPC_SMT_REGS | HPC_SIZE_BYTE)
#define HPC_TMR_EVENT_MASK 		(0x17 | HPC_SMT_REGS | HPC_SIZE_BYTE)
/* Used int bits */
#define SMT_INT_TSTAMP BIT_7
#define RMT_INT_CHGMAV BIT_1
#define RMT_INT_DETECT BIT_3
#define RMT_INT_DIRECT BIT_4
#define RMT_INT_DAD    BIT_6
#define RMT_INT_JAM    BIT_7
#define SMT_INT_PATHTEST BIT_8
#define PORT_INT_LER_CUTOFF BIT_15
#define PORT_INT_PCM_ACTIVE BIT_9

/* Registers inside MAC */
#define HPC_MAC1_ADDR_RD (HPC_READ | HPC_SIZE_LONG | HPC_MAC1_REGS )
#define HPC_LATE_COUNT	0x0E
#define HPC_TO_COUNT 0x10
#define HPC_TX_COUNT 0x14
#define HPC_NC_COUNT 0x18
#define HPC__C_COUNT 0x1c
#define HPC_RX_COUNT 0x28
#define HPC_LO_COUNT 0x20
#define HPC_ER_COUNT 0x24

/* Registers inside Player */
#define PLYR_UDR	0x17
#define PLYR_REV    0x18
#define PLYR_CRD    0x38
#define PLYR_CGM1	0x3b
#define PLYR_CGM2	0x3c


#define PLYR_PLUS_REV1  0x10
#define PLYR_REV_RD  (HPC_READ|HPC_SIZE_BYTE|PLYR_REV)
#define PLYR_CRD_WR  (HPC_WRITE|HPC_SIZE_BYTE|PLYR_CRD)


#define PLYR_UDR_RD  (HPC_READ |HPC_SIZE_BYTE|PLYR_UDR)
#define PLYR_CGM1_WR (HPC_WRITE|HPC_SIZE_BYTE|PLYR_CGM1)
#define PLYR_CGM2_WR (HPC_WRITE|HPC_SIZE_BYTE|PLYR_CGM2)

#define	HPC_PLAYER1_REV_RD	(HPC_PLAYER1_REGS | PLYR_REV_RD)
#define	HPC_PLAYER2_REV_RD	(HPC_PLAYER2_REGS | PLYR_REV_RD)
#define	HPC_PLAYER1_CRD_WR	(HPC_PLAYER1_REGS | PLYR_CRD_WR)
#define	HPC_PLAYER2_CRD_WR	(HPC_PLAYER2_REGS | PLYR_CRD_WR)

#define	HPC_PLAYER1_UDR_RD	(HPC_PLAYER1_REGS | PLYR_UDR_RD)
#define	HPC_PLAYER2_UDR_RD	(HPC_PLAYER2_REGS | PLYR_UDR_RD)

#define HPC_PLAYER1_CGM1_WR	(HPC_PLAYER1_REGS | PLYR_CGM1_WR)
#define HPC_PLAYER1_CGM2_WR	(HPC_PLAYER1_REGS | PLYR_CGM2_WR)
#define HPC_PLAYER2_CGM1_WR	(HPC_PLAYER2_REGS | PLYR_CGM1_WR)
#define HPC_PLAYER2_CGM2_WR	(HPC_PLAYER2_REGS | PLYR_CGM2_WR)

#define PLYR_UDR_NOSCRAM	0x10

#define HPC_SMT_TIME_STAMP_READ (0x10|HPC_SIZE_LONG|HPC_SMT_REGS|HPC_READ)
/*
 * HARDWARE dependant STUFF
 */
#define SMT_FRAME_FIFO_CONTROL (BYTE_SWAP(0x0208))

#define CONFIRMED 0x20
#define FRAME_COPIED 0x8000
#define A_INDICATOR 0x4000

/*
 * smt header template
 */
typedef struct {

	unsigned short  packet_count;
	unsigned short  control;
	unsigned short  pad0;
	unsigned short  FC;
	union {
		unsigned short  w[3];
		unsigned char   b[6];
	}               DA;
	union {
		unsigned short  w[3];
		unsigned char   b[6];
	}               SA;
	unsigned char   Frame_Class;
	unsigned char   Frame_Type;
	unsigned short  Version_ID;
	unsigned int	Transaction_ID;
	struct {
		unsigned char   yy[2];
		unsigned char   xx[6];
	}               Station_ID;
	unsigned short  Pad;
	unsigned short  InfoField_Length;
}               Npi_smt_header;

/*
 * SMT standard definitions
 */

#define SMT_MIN_PACKET_LENGTH sizeof(Npi_smt_header)

/*
 * Frame Classes & types page 273 of 5.1
 */
#define SMT_FRAME_CLASS_NIF 0x01
#define SMT_FRAME_CLASS_C_SIF 0x02
#define SMT_FRAME_CLASS_O_SIF 0x03
#define SMT_FRAME_CLASS_ECF 0x04
#define SMT_FRAME_CLASS_RAF 0x05
#define SMT_FRAME_CLASS_RDF 0x06
#define SMT_FRAME_CLASS_SRF 0x07
#define SMT_FRAME_CLASS_G_PMF 0x08
#define SMT_FRAME_CLASS_C_PMF 0x09
#define SMT_FRAME_CLASS_A_PMF 0x0A
#define SMT_FRAME_CLASS_R_PMF 0x0B
#define SMT_FRAME_CLASS_ESF 0xFF
#define SMT_FRAME_TYPE_ANNOUNCE 0x01
#define SMT_FRAME_TYPE_REQUEST 0x02
#define SMT_FRAME_TYPE_RESPONSE 0x03

/* SMT stuff needed in drivers */
#define FRAME_CLASS_NIF SMT_FRAME_CLASS_NIF
#define FRAME_TYPE_NIF_REQUEST SMT_FRAME_TYPE_REQUEST
#define FRAME_TYPE_NIF_RESPONSE SMT_FRAME_TYPE_RESPONSE
#define FRAME_TYPE_NIF_ANNOUNCE SMT_FRAME_TYPE_ANNOUNCE
#define SMT_VERSION_ID_51 1
#define SMT_VERSION_ID_61 1
#define FC_NSA 0x4F
#define FC_SMT_INFO 0x41
#define SMT52_NIF_LEN_old 0x3D
#define NIF_INFO_LEN_old 0x1C
#define NIF_INFO_LEN 0x28
#define SMT52_NIF_LEN (0x3D+36-0x1C+4)

/*
 * Bit number to hex
 */
#define BIT_31 0x80000000
#define BIT_30 0x40000000
#define BIT_29 0x20000000
#define BIT_28 0x10000000
#define BIT_27 0x08000000
#define BIT_26 0x04000000
#define BIT_25 0x02000000
#define BIT_24 0x01000000
#define BIT_23 0x00800000
#define BIT_22 0x00400000
#define BIT_21 0x00200000
#define BIT_20 0x00100000
#define BIT_19 0x00080000
#define BIT_18 0x00040000
#define BIT_17 0x00020000
#define BIT_16 0x00010000
#define BIT_15 0x8000
#define BIT_14 0x4000
#define BIT_13 0x2000
#define BIT_12 0x1000
#define BIT_11 0x0800
#define BIT_10 0x0400
#define BIT_9 0x0200
#define BIT_8 0x0100
#define BIT_7 0x0080
#define BIT_6 0x0040
#define BIT_5 0x0020
#define BIT_4 0x0010
#define BIT_3 0x0008
#define BIT_2 0x0004
#define BIT_1 0x0002
#define BIT_0 0x0001

typedef struct {
	u_short         a[3];
}               Integer48;

#ifdef _KERNEL
typedef struct smt {
	struct smt     *next;
	int             unit;
	dev_info_t	*dip;
	struct nfdev 	*nfp;
	int		smt_flags;
	/*
	 * store some frequently reference FDDI driver variables for memory
	 * access efficiency
	 */
	struct fdi_dev {
		int             MAC_is_available;
		int             (*output) ();	/* output routine for SMT API
						 * Driver */
		void            (*get_smt_mib) ();	/* get SMT mib routine
							 * for SMT API Driver */
		                u_int (*rd_hpc_reg) ();	/* read hpc register
							 * routine for SMT API
							 * driver */
		void            (*wr_hpc_reg) ();	/* write hpc register
							 * routine for SMT API
							 * driver */

	}               fddidev;
	Integer48       SA;	/* in canonical form */
	Integer48       SA_MSB;	/* in MSB (FDDI) form */
	Integer48       UNA;
	Integer48       DNA;
	Integer48       OLD_UNA;
	Integer48       OLD_DNA;
	kmutex_t	*smtdrv_lockp;
	smt_t           smt_varp;
}               SMTDEV;

#endif				/* _KERNEL */


typedef struct {
	int             command;/* command or index of registers */
	int             sub_command;
	int             param1;
	int             param2;
	int             param3;
	u_char          buf[256];
#ifdef _LP64
	u_int           where;	/* where the input or output string is */
#else
	char           *where;	/* where the input or output string is */
#endif
	int             length;	/* length of the string */
}               SMTCB;

#ifndef USE_STR_IOC
#define SMT_GET	_IOWR('w', 14, SMTCB)
#define SMT_SET	_IOWR('w', 15, SMTCB)
#define SMT_ACT	_IOWR('w', 16, SMTCB)
#endif				/* !USE_STR_IOC */


/* sub command number for SMT_GET */
#define GET_COUNTER_GROUP	0x1
#define GET_PORT_GROUP		0x2
#define GET_NEIGHBOR_ADDR	0x3
#define GET_DUP_ADDR_TEST	0x4

/* sub command number for SMT_SET */
#define SET_UNA				0x1
#define SET_DNA				0x2
#define XCHG_DUP_ADDR_TEST	0x3

/* command number for SMT_ACT */
#define SMT_CTL				0x1

/* sub command number for SMT_ACT */
#define SMT_CLOSE				0x1
#define SMT_ACCEPT_FRAME		0x2

typedef struct {
	u_int           late_ct;
	u_int           token_ct;
	u_int           xmit_ct;
	u_int           notcopy_ct;
	u_int           copy_ct;
	u_int           lost_ct;
	u_int           err_ct;
	u_int           frame_ct;
	u_int           ring_ct;
	u_int           tvx_ct;
	u_int           latency_ct;
	u_int           bogus_ct;
}               COUNTER_GROUP;

typedef struct {
	u_char          pcm_state;	/* 0x00 */
	u_char          pcm_idx;/* 0x01 */
	u_short         pcm_policy;	/* 0x10 */
	u_short         r_val;	/* 0x12 */
	u_short         t_val;	/* 0x14 */
	u_char          psc_status;	/* 0x16 */
	u_char          lct_fail;	/* 0x17 */
	u_short         cem_policy;	/* 0x18 */
	u_char          cem_state;	/* 0x1A */
	u_char          lem_reject_ct;	/* 0x1C */
	u_char          ler_average;	/* 0x1D */
	u_char          ler_alarm;	/* 0x1E */
	u_char          ler_cutoff;	/* 0x1F */
	u_char          lem_ct;	/* 0x20 */
	u_char          ebe_ct;	/* 0x24 */
	u_char          ecm_state;	/* 0x30 */
}               FDDI_PORT_GROUP;/* rename to avoid name conflict with SMT 7.2 */

/* Duplicate address test values */
#define DAT_UNKNOWN 0
#define DAT_PASS 1
#define DAT_FAIL 2

#define CLEAR 0
#define SET 1
#define NN_SEND 0
#define NN_WAIT 1


#undef PRINTFS
