/*
 * Copyright (c) 1993, 1994 by Network Peripherals Inc. All rights reserved.
 */
/*
 * FDDI S-Bus Device Driver for Solaris 2.x
 */
#pragma ident   "@(#)nf.h 2.05     00/01/07     NPI"

#ifndef SUCCESS
#define SUCCESS 0
#endif	/* !SUCCESS */

#ifndef FAILURE
#define FAILURE -1
#endif	/* !FAILURE */

#ifdef NFDEBUG
#define DEBUG(x)	x
#else
#define DEBUG(x)
#endif	/* NFDEBUG */

#ifndef NSMT
#define NSMT 4
#endif	/* NSMT */

#define DMA_SEGMENTS	4	/* maximum number of dma segments used for */
				/* mapping the memory */
#define FIRST_ODD_SIZE	256

#define MLEN	FIRST_ODD_SIZE

#ifndef HZ
#define HZ hz
#endif

#if !defined(_LP64) && !defined(_I32LPx)
typedef int		timeout_id_t;
typedef long		t_scalar_t;
typedef unsigned long	t_uscalar_t;
#endif

#ifndef D_HOTPLUG
#define D_HOTPLUG 0x04
#endif

/*
 * Reserved room for two channels. On SMT because we want to slap a header
 * in front. In LLC it is because BSI has a "Erroneous PSP resuse" bug
 * where if it receives a packet > 4K and is out of PSP, that it will
 * wrap around and overwrite the first 32 bytes in the PSP that it
 * just finised writing in.
 */
#define SMT_HDR_OFFSET	32
#define BSI_BUG_OFFSET	32

#define MAX_FDDI_MINORDEVS 64	/* number of minor devices allowed for */
/* all of our adapters configured      */
#define	UPPER_RANGE_802_3_MODE 1500	/* upper range of 802.3 mode */

#define NUM_MCAST	16	/* max. # of multicast entries per stream */
#define	NFMCALLOC	(nf_num_mcast * sizeof (struct ether_addr))

#define FCS_SIZE	4	/* 4-byte Frame Checksum */

#define TX_Q0		0	/* BSI output ch 0 */
#define TX_Q1		1	/* BSI output ch 1 */

				/* total kmem memory required in Kbytes */
#define	NF_KMEM_SIZE	160	/* 40 */

#define NF_NUM_SMT_RX 	4
#define NF_NUM_SYNC_RX 	(2+14)	/* added 14 to support Tsync */
#define NF_NUM_ASYNC_RX	64

#define NF_NUM_TX 	128

#ifdef NF_NUM_COPY_16
#define NF_NUM_COPY     16
#endif
#ifdef NF_NUM_COPY_32
#define NF_NUM_COPY     32
#endif
#ifdef NF_NUM_COPY_64
#define NF_NUM_COPY     64
#endif

#define	NF_NUM_DMA	( NF_NUM_TX - NF_NUM_COPY )
#define RING_SIZE 	NF_NUM_TX	/* ringsize 2 times NF_NUM_TX */

#define BSI_QUEUE_SIZE	(K(1))
#define	BSI_LMT		(128)   	/* Descriptor ring size */
#define BSI_LMT_MASK 	(BSI_LMT - 1)	/* 127 for 1K, 511 for 4K - queues */
#define BSI_4KQ_LMT_MASK (0x1ff)	/* 127 for 1K, 511 for 4K - queues */

/* SMTOperationg Modes */
#define SMT_PROMISC	0x0100	/* receive all smt packets */
#define SMT_SUSPENDED   0x1000  


/* Useful macros */

#define BYTE_SWAP(x) (((((x)&0xff00)>>8)&0x00ff) | ((((x)&0x00ff)<<8)&0xff00))

/*
 * Types for ehternet demuxing
 */

#ifndef ETHERTYPE_IP
#define ETHERTYPE_IP    0x0800  /* IP protocol */
#endif  ETHERTYPE_IP

#ifndef ETHERTYPE_ARP
#define ETHERTYPE_ARP   0x0806  /* Addr. resolution protocol */
#endif  ETHERTYPE_ARP

#ifndef ETHERTYPE_RARP
#define ETHERTYPE_RARP  0x8035  /* Reverse ARP */
#endif  ETHERTYPE_RARP

#ifndef	ETHERADDRL
#define	ETHERADDRL	(6)	/* ethernet address length in octets. */
#endif	ETHERADDRL

#ifndef	ETHERMTU
#define	ETHERMTU	(1500)
#endif	ETHERMTU

#ifndef	ETHERTYPE_MAX
#define	ETHERTYPE_MAX	(0xffff) /* Max valid ethernet type */
#endif	ETHERTYPE_MAX

#define	APPLE_ARP	(0x80f3)	/* Appletalk arp */


#define K(x) ((x)*1024)

typedef	union   {
	struct {
		uint_t  first   : 1;
		uint_t  last    : 1;
		uint_t  res     : 2;
		uint_t  loc     : 28;
	} loc_bit;
	uint_t	loc_long;
} loc_un_t;


typedef  struct psp_descriptor_struct {
        union   {
                struct {
                        uint_t  res     : 19;
                        uint_t  cnt     : 13;
                } cnt_bit;
                uint_t  cnt_long;
        } cnt_un;
	loc_un_t 	loc_un;
} psp_descriptor_t;

		


typedef struct req_descriptor_struct {
	union {
		struct {
			uint_t	res		: 2;
			uint_t	uid		: 6;
			uint_t	size		: 8;
			uint_t	cnfcls		: 4;
			uint_t	rqcls		: 4;
			uint_t	fc		: 8;
		} ctl_bit;
		uint_t ctl_long;
	} ctl_un;
	loc_un_t	loc_un;
} req_descriptor_t;

typedef struct odd_descriptor_struct {
        union   {
                struct {
                        uint_t  res     : 19;
                        uint_t  cnt     : 13;
                } cnt_bit;
                uint_t  cnt_long;
        } cnt_un;
        loc_un_t	loc_un;
} odd_descriptor_t;

typedef struct idd_descriptor_struct {
	union	{
		struct {
			uint_t	is	: 4;
			uint_t	fra	: 4;
			uint_t	frs	: 8;
			uint_t	vc	: 1;
			uint_t	res	: 2;
			uint_t	cnt	: 13;
		} cnt_bit;
		uint_t	cnt_long;
	} cnt_un;
	loc_un_t        loc_un;
} idd_descriptor_t;

typedef struct cnf_descriptor_struct {
	union	{
		struct {
			uint_t	req_stat	: 4;

			uint_t	m_flag		: 1;
			uint_t	a_flag		: 1;
			uint_t	tc		: 2;

			uint_t	vdl		: 1;
			uint_t	vfcs		: 1;
			uint_t	e_ind		: 2;
			uint_t	a_ind		: 2;
			uint_t	c_ind		: 2;

			uint_t	tfc		: 8;
			uint_t	cfc		: 8;
		} c0_bit;
		uint_t	c0_long;
	} c0_un;
	union	{
		struct {
			uint_t	first		: 1;
			uint_t	last		: 1;
			uint_t	uid		: 6;
			uint_t	fc		: 8;
			uint_t	cs		: 8;
			uint_t	res		: 8;
		} c1_bit;
		uint_t	c1_long;
	} c1_un;
} cnf_descriptor_t;

#define		data_cnt	cnt_un.cnt_bit.cnt
#define		data_loc	loc_un.loc_bit.loc

#define		MATCH_COPY_TYPE	1
#define		MATCH_DMA_TYPE	2


#define ODDNUM_PKT		6

typedef struct dma_req {
	mblk_t           *mp;
	struct nfstr     *snp;
	int              type;
	int              tx_dvma_idx;
	u_char           *data;
	u_char           *dvma;
	odd_descriptor_t *odd;
	ulong_t 	 odd_iopb;
	uint_t		 req_ctl;
	ddi_dma_handle_t dma_handle[ODDNUM_PKT];
} dma_req_t;

/* psp_cb : control struct for per page space */
typedef struct psp_cb {
	struct nfdev *devp;
	int             on_loan;
	int             qind;	/* on which q ? */
	mblk_t         *mp;	/* data buffer allocated via esballoc() */
	ulong_t         psp_loc;/* dvma address for this buffer */
	uint_t          psp_cnt;/* # of bytes BSI can use in case we */
	ulong_t         psp_kern;/* # of bytes BSI can use in case we */
	int             page_index;
	frtn_t          fr_rtn;
} psp_cb_t;


typedef struct {
	kmutex_t        ring_lock;	/* lock for this structure */
	short           r_rdidx;
	short           r_wrtidx;
	short           r_size;
	short           r_pad;
	void            *r_slot[RING_SIZE];
}               RINGn;


#define NPI_MBOX_OFFSET 	0x10
#define NPI_BSI_OFFSET 		0x50
#define NPI_MCAST_OFFSET 	0x90

#define PROM_REG_SIZE 	0x10
#define MBOX_REG_SIZE 	0x40
#define BSI_REG_SIZE  	0x40
#define MCAST_ADDR_SIZE	0x20


/* SBus DAS Multicast register bits */
#define	SB_PROMISC 		0x01	/* Enable Promiscous Mode */
#define	SB_MCAST		0x02	/* Enable all Multicast packets */
#define	SB_EN_UTP		0x04	/* Enable UTP , WR_ONLY */
#define	SB_SENSE_UTP		0x08	/* 0-UTP stffed, 1-Fiber, RD_ONLY */
#define	SB_RESET		0x10	/* Reset the Hardware , WR_ONLY */
#define	SB_SENSE_RESET		0x20	/* Reset Completed, RD_ONLAY */
#define	SB_EN_HPCINT		0x40	/* enable HPC interrupt */
#define	SB_HPCINT		0x80	/* HPC the interrupter */

/* per-stream flags */
#define	SLFAST		0x01	/* "M_DATA fastpath" mode */
#define	SLRAW		0x02	/* M_DATA plain raw mode */
#define	SLALLPHYS	0x04	/* "promiscuous mode" */
#define	SLALLMULTI	0x08	/* enable all multicast addresses */
#define	SLALLSAP	0x10	/* enable all ether type values */

/*
 * Per interface flags for LLC
 */
#define	NFRUNNING	0x01	/* chip is initialized */
#define	NFPROMISC	0x02	/* promiscuous mode enabled */
#define	NFMULTI		0x04	/* promiscuous multicast enabled */
#define	NFLOOPBACK	0x08	/* card in loopback mode , smt not active */

/*
 * Per interface flags for SMT
 */
#define	SMTRUNNING	0x01	/* SMT has been initialized */
#define	SMTPROMISC	0x02	/* promiscuous mode enabled */
#define	SMTMULTI	0x04	/* promiscuous multicast enabled */

typedef struct nfstr {
	struct nfstr *next_sap_p;
	queue_t         *r_qptr;	/* read q */
	queue_t         *w_qptr;	/* write q */
	struct nfdev    *devp;
	int             op_mode;	/* operation mode */
	uint_t          dl_sap;	/* LLC SAP */
	ushort          state;	/* state of service provider */
	int             minor_dev;	/* minor device number */
	int 		qnum;		/* Transmit Channel */
	uint_t          tsync;	/* synchronous bandwidth value in 80ns unit */
	uint_t		sn_mccount;	/* # enabled multicast addrs */
	struct		ether_addr *sn_mctab;	/* table of multicast addrs */
	kmutex_t	sq_lock;	/* protect this structure */
	uint_t          sn_mcsize;      /* mc table size */
} nfstr_t;

typedef struct nfstat {
	kstat_named_t   nf_ipackets;
	kstat_named_t   nf_ierrors;
	kstat_named_t   nf_opackets;
	kstat_named_t   nf_oerrors;
	kstat_named_t   nf_rbytes;
	kstat_named_t   nf_obytes;
	kstat_named_t   nf_tx_underruns0;
	kstat_named_t   nf_tx_underruns1;
	kstat_named_t   nf_rx_overruns;
	kstat_named_t   nf_cnf_invalids0;
	kstat_named_t   nf_cnf_invalids1;
	kstat_named_t   nf_norxllcbufs;
	kstat_named_t   nf_norxsmtbufs;
	kstat_named_t   nf_cannotput;
	kstat_named_t   nf_allocbfail;
	kstat_named_t   nf_bsi_iar_exci0;
	kstat_named_t   nf_bsi_iar_exci1;
	kstat_named_t   nf_bsi_iar_exci2;
	kstat_named_t   nf_no_copy_reqp0;
	kstat_named_t   nf_no_copy_reqp1;
	kstat_named_t   nf_no_reqp0;
	kstat_named_t   nf_no_reqp1;
	kstat_named_t   nf_pkt_toobig0;
	kstat_named_t   nf_pkt_toobig1;
	kstat_named_t   nf_tsync_underrun;
	kstat_named_t   nf_bad_fc;
	kstat_named_t   nf_invalid_idud0;
	kstat_named_t   nf_invalid_idud1;
	kstat_named_t   nf_invalid_idud2;
	kstat_named_t   nf_psp_on_loan;
	kstat_named_t   nf_invalid_frame;
	kstat_named_t   nf_putbq;
#if defined(NFDEBUG_STATS) || defined(WXDDB)
	kstat_named_t   nf_interrupts;
	kstat_named_t   nf_async_frame;
	kstat_named_t   nf_sync_frame;
	kstat_named_t   nf_smt_frame;
#endif
#ifdef WXDDB
	kstat_named_t   nf_sync_reset;
#endif
#ifdef	NFDEBUG_STATS
	kstat_named_t   nf_tx_reset;
	kstat_named_t   nf_ch0_copy_size;
	kstat_named_t   nf_ch0_size;
	kstat_named_t   nf_ch1_copy_size;
	kstat_named_t   nf_ch1_size;
	kstat_named_t   nf_comp_frame;
	kstat_named_t   nf_cnf0;
	kstat_named_t   nf_cnf1;
	kstat_named_t   nf_num_rx_posted0;
	kstat_named_t   nf_num_rx_consume0;
	kstat_named_t   nf_num_rx_posted1;
	kstat_named_t   nf_num_rx_consume1;
	kstat_named_t   nf_num_rx_posted2;
	kstat_named_t   nf_num_rx_consume2;
#endif NFDEBUG_STATS
} nfstat_t;


typedef	struct {
	u_char	mr0;
	u_char	mr1;
	u_char	pcar;
	u_char	mbar;
	u_char	mar;
	u_char	mnr;
	u_char	star;
	u_char	stnr;
	u_char	sar;
	u_char	snr;
	u_char	nsar;
	u_char	nsnr;
	u_char	lar;
	u_char	ldr;
	u_char	rar;
	u_char	rnr;

	u_char  rcr0[2];
	u_char	refsr[2];

	u_char	iar;
	u_char	inr;
	u_char	itr;
	u_char	imr;
	u_char	icr;
	u_char	ihlr;
	u_char	acr;

	u_char	rcr1[2];
	u_char	pad[2];
	u_char	cmp[2];
} bsi_regs_t;

typedef struct nfdev {
	struct nfdev *next;
	int             unit;
	queue_t        *ipq;		/* IP fastpath */
#ifdef NFIPV6
	queue_t        *ipv6q;		/* IP fastpath */
#endif
	int             ints_received;
	kmutex_t        nf_lock;	/* general purpose lock.*/
	kmutex_t        smt_rxlock;	/* lck to serialize smt rx frames */
	kmutex_t        nf_mbox_lock;	/* hpc mailbox lock */
	Integer48       SA;		/* canonical addr */
	Integer48       SA_MSB;		/* MSB (FDDI) addr */
	int             das;
	int             old_hdwr;
	dev_info_t     *dip;
	uint_t		nf_flags;

	struct {
		char			*prom;
		short			*mbc_upic;
		volatile bsi_regs_t	*bsi_regs;
		char			*mcast;
	}               reg;

	int		llc_available_state;
	int             bsi_rev;
	ddi_iblock_cookie_t iblock_cookie;

	uint_t           smt_op_mode;	/* flags for SMT operating modes, */

	struct ddi_dma_lim dma_limit;	/* dma engine limit */

	struct {
		uint_t           tx_len;
		caddr_t          tx_kern;
		ulong_t		 tx_bsi;
		ddi_dma_handle_t tx_dvma_handle;
		ddi_dma_handle_t tx_dma_handle;
		uint_t           rx_len;
		caddr_t          rx_kern;
		ulong_t          rx_bsi;
		ddi_dma_handle_t rx_dvma_handle;
		ddi_dma_handle_t rx_dma_handle;
		caddr_t          rx_kern_start;
                ddi_dma_cookie_t tx_dma_cookie;
		ddi_dma_cookie_t rx_dma_cookie;
	}               dvma;

	struct {
		int             tot_len;
		caddr_t         kvaddrp;	/* kernel virtual address */
		ulong_t		bsi;		/* address BSI sees */
		ddi_dma_handle_t dma_handle;
		ddi_dma_cookie_t dma_cookie;
	}               iopb;

	ulong_t		tx_mem_delta;
	ulong_t		rx_mem_delta;
	ulong_t		iopb_delta;

	kmutex_t        bsi_lmop_ptop_lock;	/* lock for Limit RAM and
						 * Pointer RAM operations */
	struct bsi {
		struct q {
			req_descriptor_t *req[2];
			int             req_lmt[2];
			cnf_descriptor_t *cnf[2];
			int             cnf_lmt[2];
			idd_descriptor_t *idd[3];
			int             idd_lmt[3];
			psp_descriptor_t *psp[3];
			int             psp_lmt[3];
			odd_descriptor_t *odud[2];	/* driver odud quads */
							/* Locks for the
							 * Descriptors
							 */
			kmutex_t        req_lock;	
			kmutex_t        cnf_lock;
			kmutex_t        idd_lock;
			kmutex_t        psp_lock;
		}               q;
		uint_t          *mbox;
	}               bsi;

	struct kmem {
		char           *start;
		char           *next;
		int             tot_len;
		int             avail_len;
	}               kmem;

	int		smtflags;	/* smt driver flags */
#ifdef	_KERNEL
	SMT_CONFIG_INFO *smtcfgp;	/* smt config stuffs used by smt core */
#else
	void		*smtcfgp;
#endif	_KERNEL

	short           cputype;
	int             pver;	/* adapter prom version */
	psp_cb_t	*psp_cb;	
	int             psp_inflight[3];
	int             psp_freed[3];
	uint_t          bogus_ct;
	RINGn           tx_free[2];
	RINGn           tx_copy_free[2];
	RINGn           tx_req[2];
	int             sync_inited;
	int             MAC_is_available;
	uint_t          idud_other;
	uint_t		tx_full_duplex;
	int             MAC_DA_Flag;
	int             cnf_ct[2];
	int             idd_ct[3];
	int             psps_dangling;
#ifdef	_KERNEL
	SMTDEV         *smtdevp;
#else
	void	       *smtdevp;
#endif	_KERNEL
	struct smtdrv {
		int             (*output) ();	/* output routine for SMT API */
		int             (*input) ();	/* input routine for SMT API */
		void            (*get_smt_mib) ();	/* get SMT mib routine
							 * for SMT API */
		uint_t		(*rd_hpc_reg) ();	/* read hpc register
							 * routine for SMT API
							 * driver */
		void            (*wr_hpc_reg) ();	/* write hpc register
							 * routine for SMT API
							 * driver */
		int             accept_smt;	/* = 1 if any smt api client
						 * is active */
	}               smtdrv;

	kstat_t        *kstatp;	/* kernel statistics structure pointer */


	timeout_id_t    kick_bsi_timeout_id;

	ulong_t         nf_ipackets;	/* # packets received */
	ulong_t         nf_ierrors;	/* # total input errors */
	ulong_t         nf_opackets;	/* # packets sent */
	ulong_t         nf_oerrors;	/* # total output errors */
	ulong_t         nf_tx_underruns[2];	/* # of transmit underruns */
	ulong_t         nf_rx_overruns;	/* # of receive overruns */
	ulong_t         nf_cnf_invalids[2];	/* # of bad tx confirmations
						 * other than underrun */
	ulong_t         nf_norxllcbufs;	/* no BSI LLC receive buffers */
	ulong_t         nf_norxsmtbufs;	/* no BSI SMT receive buffers */
	ulong_t         nf_cannotput;	/* canput() failed */
	ulong_t         nf_allocbfail;	/* allocb failures */
	ulong_t         nf_bsi_iar_exci0;
	ulong_t         nf_bsi_iar_exci1;
	ulong_t         nf_bsi_iar_exci2;
	ulong_t         nf_no_copy_reqp[2];	/* Out of reqp on channel 0*/
	ulong_t         nf_no_reqp[2];		/* Out of reqp */
	ulong_t         nf_pkt_toobig[2];	/* Pkt size greater than MTU  */
	ulong_t         nf_tsync_underrun;	/* FIFO underrun on channel 0 */
	ulong_t         nf_bad_fc;	/* Bad FC field */
	ulong_t         nf_invalid_idud[3];	/* Invalid IDUD */
	ulong_t		nf_psp_on_loan;
	ulong_t         nf_invalid_frame;	/* Invalid frame */
	ulong_t         nf_putbq;	/* Invalid frame */
#if defined(NFDEBUG_STATS) || defined(WXDDB)
	ulong_t         nf_interrupts; 
	ulong_t         nf_async_frame;
	ulong_t         nf_sync_frame;
	ulong_t         nf_smt_frame;
#endif
#ifdef WXDDB
	ulong_t         nf_sync_reset;
#endif
#ifdef	NFDEBUG_STATS
	ulong_t         nf_tx_reset;	
	ulong_t         nf_ch0_copy_size;	
	ulong_t         nf_ch0_size;	
	ulong_t         nf_ch1_copy_size;
	ulong_t         nf_ch1_size;	
	ulong_t         nf_comp_frame;
	ulong_t         nf_cnf[2];  
	ulong_t         nf_num_rx_posted[3]; 
	ulong_t         nf_num_rx_consume[3]; 
#endif	NFDEBUG_STATS

	ulong_t		nf_bytes_xmit;
	ulong_t		nf_bytes_recv;
	int             no_tx_in_1sec;	/* keep track of BSI transmit sleep
					 * (comatose) problem */
	int             cnf_norxllc_int;	/* for BSI no LLC receive
						 * problem - the assumption */
	/* is that if there are transmits than there should be */
	/* some receives also. */
	int             norxsmt_int;
	uint_t	nf_psp_tail[3];
	uint_t	nf_old_psp[3];
        timeout_id_t    nf_free_timeout_id;     /* save id for untimeout */
        timeout_id_t    nf_reset_bmac_timeout_id; /* save id for untimeout */
	int		nf_wantw;		/* Want write queue enables */

	ksema_t		nf_sem_die;		/* track timeout death */
}               nfdev_t;

#define PSP_ON_QUEUE 0
#define PSP_ON_LOAN  1
#define PSP_DANGLE   2
#define FDDIMTU 4352
#define MIN_MTU 0
#define MAC_ADDR_LEN 		ETHERADDRL
#define FDDI_LLC_HDR_LEN	24	/* FC(4) + DA(6) + SA(6) + SNAP(8) */
#define FDDI_MAC_HDR_LEN	16	/* FC(4) + DA(6) + SA(6) */
/* 
 * this is to catch the bug in BSI that
 * sometimes puts only 13 bytes in 1st buffer 
 * sizeof(fddi_llc_header) + sizeof(struct ip) 
 */
#define MIN_FIRST_FRAG_SIZE	44

/* For dlpi */
#define DLSAP_LEN 8
#define DL_MULTI	1	/* destination address is multicast/broadcast */

/*
 * Full DLSAP address length (in struct dladdr format).
 */
#define	NFADDRL	(sizeof (u_short) + ETHERADDRL)

/* The following are definition from RFC1188 */
#define UI				3	/* unumbered information */
#define SNAP_SAP		170
#define GLOBAL_SAP		255
#define NULL_SAP		0
#define XID			175
#define XID_PF			191	/* XID with Poll/Final */
#define TEST			227
#define TEST_PF			243	/* TEST with Poll/Final */

#define LLC_UI 0xAAAA0300

/*
 * struct for 802.2 LLC & SNAP checking, I move one byte from snap into llc
 * to get an integer structure, since the 1st byte of SNAP should be 0
 * anyway.
 */
typedef struct {
	uint_t llc;
	union {
		uint_t           snap;
		struct {
			u_short         pad;
			u_short         ether_type;
		}               ether_type;
	}               snap;

} fddi_llc_hdr_t;


#define LLC		snap.llc
#define SNAP	snap.snap
#define ether 	snap.ether_type.ether_type

/*
 * FDDI header is FC(1) + DA(6) + SA(6) + SAP(2) + CTL(1) + ID(3)
 */
#define	FDDI_HDR_SIZE	19

#define ASYNC_HIGHEST 	0x57
#define SYNC_HIGHEST 	0xd7
#define VOID_FC			0x40

#define IOPB_K2B(a) ((ulong_t)(a) + nfp->iopb_delta)
#define IOPB_B2K(a) (((ulong_t)(a) | BSI_PSP_LOC) - nfp->iopb_delta)


/* in reg structure */
#define 	upic mbc_upic[0]
#define 	mbcmd mbc_upic[0]
#define 	mbdata mbc_upic[2]


/* FDDI MAC header */
typedef struct fddi_mac_hdr {
	uint_t           	fc;
	struct ether_addr       da;
	struct ether_addr       sa;
} fddi_mac_hdr_t;

typedef struct fddi_hdr {
	fddi_mac_hdr_t	mh;
	fddi_llc_hdr_t	llch;
} fddi_hdr_t;


#define MDATA_WR_OFF(mp) ((mp)->b_rptr - (mp)->b_datap->db_base)


/* free structure used in SMT transmit */
typedef struct {
	frtn_t          fr_rtn;
	char           *bufp;
}               smt_xmit_t;




/* nf_debug flag definitions */
#define NF_DEBUG_DRVINIT		0x00000001	/* driver initialization */
#define NF_DEBUG_RX			0x00000002	/* receive */
#define NF_DEBUG_TX 			0x00000004	/* transmit */
#define NF_DEBUG_SMTIF			0x00000008	/* smtcore interface */
#define NF_DEBUG_RX_SMT		0x00000010
#define NF_DEBUG_RPTR_ODD		0x00000010

#define	TX_RAW			3
#define	TX_NORMAL		0
