#pragma ident "@(#)pf.h	1.2 11/27/01 SMI"
/*
 * Copyright (c) 1993-1997 by Network Peripherals Inc. All rights reserved.
 */
/*
 * FDDI PCI Device Driver for Solaris 2.x
 */

#if !defined(_LP64) && !defined(_I32LPx)
typedef int              timeout_id_t;
typedef long             t_scalar_t;
typedef unsigned long    t_uscalar_t;
typedef unsigned short	 uint16_t;
#define pci_config_get8  pci_config_getb
#define pci_config_get16 pci_config_getw
#define pci_config_get32 pci_config_getl
#define pci_config_get64 pci_config_getll
#define pci_config_put8  pci_config_putb
#define pci_config_put16 pci_config_putw
#define pci_config_put32 pci_config_putl
#define pci_config_put64 pci_config_putll
#define ddi_get8         ddi_getb
#define ddi_get16        ddi_getw
#define ddi_get32        ddi_getl
#define ddi_get64        ddi_getll
#define ddi_rep_get8     ddi_rep_getb
#define ddi_rep_get16    ddi_rep_getw
#define ddi_rep_get32    ddi_rep_getl
#define ddi_rep_get64    ddi_rep_getll
#define ddi_put8         ddi_putb
#define ddi_put16        ddi_putw
#define ddi_put32        ddi_putl
#define ddi_put64        ddi_putll
#define ddi_rep_put8     ddi_rep_putb
#define ddi_rep_put16    ddi_rep_putw
#define ddi_rep_put32    ddi_rep_putl
#define ddi_rep_put64    ddi_rep_putll
#endif

#ifndef D_HOTPLUG
#define D_HOTPLUG 0x04
#endif

typedef struct fddi_802_2 {
	u_char		dsap;
	u_char		ssap;
	u_char		cntrl;
} fddi_802_2;

typedef struct fddi_snap_hdr {
	u_char 		dsap;
	u_char		ssap;
	u_char		cntrl;
	u_char		org[3];
	u_short		type;
}fddi_snap_hdr_t;

typedef struct fddi_hdr_t {
	u_char		pad1;
	u_char		pad2;
	u_char		pad3;
	u_char		fc;
	u_char		da[ETHERADDRL];
	u_char		sa[ETHERADDRL];
} fddi_hdr_t;

typedef struct pfdladdr {
	struct ether_addr dl_phys;
	u_short		dl_sap;
} pfdladdr;

#ifndef ETHERTYPE_MAX
#define	ETHERTYPE_MAX			0xFFFF
#endif ETHERTYPE_MAX
#define	FDDI_SNAP_HDR_LEN		sizeof (fddi_snap_hdr_t)
#define	PF_LLC_SNAP_HDR_LEN		28	/* FRAME_HDR + DA + SA + SNAP */
#define	PF_LLC_HDR_LEN			20	/* FRAME_HDR + DA + SA */
#define PF_MAC_HDR_LEN			20
#define FDDI_LLC_HDR_LEN		24      /* FC(4)+DA(6)+SA(6)+ SNAP(8) */
#define FDDI_MAC_HDR_LEN		16      /* FC(4)+DA(6)+SA(6) */
#define	FDDI_802_2_SNAP_DSAP		0xAA
#define	FDDI_802_2_SNAP_SSAP		0xAA
#define	FDDI_802_2_SNAP_CNTRL		0x03
#define	PF_802_3_MODE			1500
#define	APPLE_ARP			0x80F3

#define	PFADDRL				ETHERADDRL + 2
#define	ASYNC_HIGHEST			0x57

/* PER-STREAM OPERATION MODES */
#define	SLFAST				0x01		/* Fast path */
#define	SLRAW				0x02		/* Raw mode */
#define	SLALLPHYS			0x04		/* Promiscuous flags */
#define	SLALLMULTI			0x08		/* All multicast */
#define	SLALLSAP			0x10		/* All sap's */
#define	SLDIAG				0x20		/* Diag  sap */

/* PER-INTERFACE LLC FLAGS */
#define	PFRUNNING			0x01
#define	PFPROMISC			0x02
#define	PFSUSPENDED			0x04
#define	PFMULTI				0x08
#define	PFNORMAL			0x10
#define	PFDOWN				0x20
#define	PFLOOPBACK			0x40
#define	PFBUSY				0x80

/* Flags for setting packet filters */
#define	PF_FILTER_NORMAL		0x01
#define	PF_FILTER_MCAST			0x02
#define	PF_FILTER_PROMISC		0x04

#define	PF_MAX_MCAST			16

#define	ISBCAST(addr)			(addr[0] == 0xFF)
#define	ISMCAST(addr)			(addr[0] & 0x01)
#define	SAPMATCH(sap, type, flags)	((sap == type)? 1 : \
	((flags & SLALLSAP) ? 1 : \
	((sap <= ETHERMTU) && (sap >= 0) && (type <= ETHERMTU))? 1 : 0))

/* Frame types */
#define	MCAST_FRAME			0x01
#define	BCAST_FRAME			0x02
#define	DIRECTED_FRAME			0x04

#define	PF_MODULEID			0x70	/* Module ID of this driver */
#define	FDDIMTU				4500	/* MTU for FDDI */
#define	PF_HDR_LEN			21	/* FC + SA + DA + SNAP */
#define	PFDDIMAXPDU			4376	/* 4352 + 21 + 3 */
#define	PFDDIDATA			4352	/* 4352 + 21 + 3 */
#define	PFDDIMINPDU			13
#define	PF_HIWAT_MARK			(15 * PFDDIMTU)
#define	PF_LOWWAT_MARK			(5 * PFDDIMTU)
#define	DLSAP_LEN			8	/* Our Sap len */

#define	SUCCESS				0
#define	FAILURE				1

#define	PF_DEVNAME			"pf"
#define	PF_MINORDEVNAME			"pfm"

#define	PF_TX_KBUF_NO			32
#define	PF_TX_KBUF_SIZE			256
#define	PF_TX_SMTBUF_SIZE		4516
#define	PF_RX_SMTBUF_SIZE		4516
#define	PF_RX_KBUF_SIZE			4096

#define	PF_DEF_TX_DESC			128
#define	PF_MAX_TX_DESC			256
#define	PF_DEF_RX_DESC			64
#define	PF_MAX_RX_DESC			128

#define	PF_TX_DMA_FROM_PKT		0x01
#define	PF_TX_DMA_FROM_KBUF		0x02
#define	PF_TX_DMA_SMT			0x04
#define	PF_TX_DMA_FROM_DESC		0x08

#define	PF_SET				1
#define	PF_CLEAR			0

typedef struct pfkstat {
	kstat_named_t	k_inpkts;
	kstat_named_t	k_inerrs;
	kstat_named_t	k_obytes;
	kstat_named_t	k_rbytes;
	kstat_named_t	k_outpkts;
	kstat_named_t	k_outerrs;
	kstat_named_t	k_outsmt;
	kstat_named_t	k_macstate;
	kstat_named_t	k_llcstate;
	kstat_named_t	k_notxbufs;
	kstat_named_t	k_notmds;
	kstat_named_t	k_notxsmtbufs;
	kstat_named_t	k_txsetupfail;
	kstat_named_t	k_insmt;
	kstat_named_t	k_indiscards;
	kstat_named_t	k_norxbufs;
	kstat_named_t	k_rxpfail;
	kstat_named_t	k_rxefail;
	kstat_named_t	k_rxdupfail;
	kstat_named_t	k_nocanputs;
	kstat_named_t	k_bad_fc;
	kstat_named_t	k_intr;
	kstat_named_t	k_reset;
} pfkstat_t;

typedef struct pfstats {
	u_long		p_inpkts;
	u_long		p_inerrs;
	u_long		p_obytes;
	u_long		p_rbytes;
	u_long		p_outpkts;
	u_long		p_outerrs;
	u_long		p_outsmt;
	u_long		p_notxbufs;
	u_long		p_insmt;
	u_long		p_indiscards;
	u_long		p_norxbufs;
	u_long		p_notmds;
	u_long		p_notxsmtbufs;
	u_long		p_txsetupfail;
	u_long		p_rxpfail;
	u_long		p_rxefail;
	u_long		p_rxdupfail;
	u_long		p_nocanputs;
	u_long		p_bad_fc;
	u_long		p_intr;
	u_long		p_reset;
}pfstats_t;

#define	ROUNDUP(a, n)		(((a) + ((n) - 1)) & ~((n) - 1))

#define READL_REG(reg)		\
		ddi_get32(pfp->acc_handle, (uint32_t *)(pfp->pbsregp + reg))
#define READW_REG(reg)		\
		ddi_get16(pfp  ->acc_handle, (uint16_t *)(pfp->pbsregp + reg))
#define READB_REG(reg)		\
		ddi_get8(pfp->acc_handle, (uint8_t *)(pfp->pbsregp + reg))

#define WRITEL_REG(reg, val)	\
		ddi_put32(pfp->acc_handle,\
		(uint32_t *)(pfp->pbsregp + reg), (uint32_t)val)
#define WRITEW_REG(reg, val)	\
		ddi_put16(pfp->acc_handle,\
		(uint16_t *)(pfp->pbsregp + reg), (uint16_t)val)
#define WRITEB_REG(reg, val)	\
		ddi_put8(pfp->acc_handle,\
		(uint8_t *)(pfp->pbsregp + reg), (uint8_t)val)

typedef struct {
	u_int		desc_no;		/* no of descriptors */
	caddr_t		kmemp;			/* ptr to huge chunk */
	u_int		head;			/* Start of DMA */
	u_int		tail;
	desc_t		*descp;			/* pointer to decriptor list */
	caddr_t		smtbufp;
	u_int		smtqueued;
	u_int		smtindex;
	ddi_dma_handle_t descp_dma_handle;
	ddi_acc_handle_t descp_iopb_handle;
	ddi_dma_handle_t smtp_dma_handle;
	ddi_acc_handle_t smtp_iopb_handle;
	ddi_dma_cookie_t descp_cookie;
	ddi_dma_cookie_t smtp_cookie;
	u_int		smtp_cookie_count;
#ifdef SOLARIS_PCI_sparc
	ddi_dma_handle_t dvma_handle;
#endif
	ddi_dma_handle_t smt_handle;
	kmutex_t	txlock;
} txi_t;

typedef struct {
	u_int		desc_no;		/* no of descriptors */
	caddr_t		kmemp;			/* ptr to huge chunk */
	u_int		head;			/* start of DMA */
	desc_t		*descp;			/* pointer to descriptor list */
	u_int		winhead;		/* out window head */
	rxbufp_t	rxpoolp[PF_MAX_RX_DESC];	/* RX pool: **pfbuf_t */
	int		rxphead;
	caddr_t		smtbufp;
	ddi_dma_handle_t descp_dma_handle;
	ddi_acc_handle_t descp_iopb_handle;
	ddi_dma_cookie_t descp_cookie;

#ifdef SOLARIS_PCI_sparc
	ddi_dma_handle_t dvma_handle;
#endif
	kmutex_t	rxlock;
	kmutex_t	rxpoollock;
} rxi_t;

typedef struct pfdev {
	u_char		*pbsregp;
	struct pfdev	*pf_next;		/* Next in list */
	u_int		pbsrev;
	u_int		flags;
	caddr_t		membase;
	queue_t		*ipq;			/* fast path for IP */
#ifdef PFIPV6
	queue_t		*ipv6q;			/* fast path for IPV6 */
#endif
	int		llc_available_state;
	int		mac_available_state;
	int		defered;		/* Flag set if defered a xmit */
	u_int		unit;			/* instance number */
	txi_t		txi;				/* TX related info */
	rxi_t		rxi;				/* RX related info */
	u_int		tNotify;
	u_int		tRequest;
	mblk_t		*(*sendfunc)();
	void		(*txreclaimfunc)();
	void		(*recvfunc)();
	dev_info_t	*devinfo;
	ddi_acc_handle_t acc_handle;
	ddi_acc_handle_t acc_handle1;
	ddi_iblock_cookie_t iblock_cookie;	/* interrupt cookie */
	int		utp_present;

	int		MAC_DA_Flag;
	int		tx_fullduplex;
	ddi_acc_handle_t pci_handle;
	u_int		page_size;
#ifdef SOLARIS_PCI_sparc
	ddi_dma_lim_t	dma_limit;
	int		mpages;
#else
	u_int		page_shift;
	u_int		page_mask;
#endif
	u_int		pbsmbc;
	u_int		pbsmbd;
	SMT_CONFIG_INFO	smtcfgp;
	SMT_MIB_INFO	smtmibp;
	smt_ops_t	smtp;
	smt_ops_t	local_smtp;
	smt_t		smt_varp;
	kmutex_t	hpc_lock;
	kmutex_t	pf_lock;
	pfkstat_t	kstats;
	pfstats_t	stats;
	kstat_t		*kstatp;
	u_char		SA[ETHERADDRL];		/* Current address */
	u_char		hw_addr[ETHERADDRL];	/* Hardware address */
	char		vlan_fc;
} pfdev_t;

/* Per Stream structure */
typedef struct pfstr {
	struct pfstr	*pf_next;
	queue_t		*r_qptr;
	queue_t		*w_qptr;
	pfdev_t		*devp;
	int		opmode;
	int		dl_sap;
	int		state;
	int		smt_act;
	struct	ether_addr *mcast_table;
	u_int		mcast_count;
	minor_t		minor_dev;
	kmutex_t	strm_lock;
} pfstrm_t;

#ifndef FALSE
#define FALSE	(0)
#endif

#ifndef TRUE
#define TRUE	(1)
#endif
