/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_SYSEVENT_ENV_H
#define	_SYS_SYSEVENT_ENV_H

#pragma ident	"@(#)env.h	1.1	00/05/11 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Event type EC_ENV/ESC_ENV_TEMP schema
 *	Event Class	- EC_ENV
 *	Event Sub-Class	- ESC_ENV_TEMP
 *	Event Publisher	- SUNW:kern:[environmental monitor name]
 *	Attribute Name	- ENV_FRU_ID
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_RESOURCE_ID
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_DEVICE
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_STATE
 *	Attribute Type  - SE_DATA_TYPE_INT32
 *	Attribute Value	- ENV_OK | ENV_WARNING | ENV_FAILED
 *	Attribute Name	- ENV_MSG
 *	Attribute Type	- SE_DATA_TYPE_STRING
 *	Attribute Value	- [message passed by environmental monitor]
 */

#define	ENV_FRU_ID	"env_fru_id"		/* PICL FRU name */
#define	ENV_FRU_RESOURCE_ID	"env_fru_resource_id"	/* FRU resource name */
#define	ENV_FRU_DEVICE	"env_fru_device_path"	/* Device path of sensor */
#define	ENV_FRU_STATE	"env_fru_state"		/* State of FRU */
#define	ENV_MSG		"env_msg"		/* environmental montitor msg */
#define	ENV_RESERVED_ATTR	""		/* Reserved attribute */

/*
 * Event type EC_ENV/ESC_ENV_POWER schema
 *		Event Class	- EC_ENV
 *	Event Sub-Class	- ESC_ENV_POWER
 *	Event Publisher	- SUNW:kern:[environmental monitor name]
 *	Attribute Name	- ENV_FRU_ID
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_RESOURCE_ID
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_DEVICE
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_STATE
 *	Attribute Type  - SE_DATA_TYPE_INT32
 *	Attribute Value	- ENV_OK | ENV_WARNING | ENV_FAILED
 *	Attribute Name	- ENV_MSG
 *	Attribute Type	- SE_DATA_TYPE_STRING
 *	Attribute Value	- [message passed by environmental monitor]
 *
 *
 *
 * Event type EC_ENV/ESC_ENV_FAN event schema
 *	Event Class	- EC_ENV
 *	Event Sub-Class	- ESC_ENV_FAN
 *	Event Publisher	- SUNW:kern:[environmental monitor name]
 *	Attribute Name	- ENV_FRU_ID
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_RESOURCE_ID
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_DEVICE
 *	Attribute Type  - SE_DATA_TYPE_STRING
 *	Attribute Value	- ENV_RESERVED_ATTR
 *	Attribute Name	- ENV_FRU_STATE
 *	Attribute Type  - SE_DATA_TYPE_INT32
 *	Attribute Value	- ENV_OK | ENV_WARNING | ENV_FAILED
 *	Attribute Name	- ENV_MSG
 *	Attribute Type	- SE_DATA_TYPE_STRING
 *	Attribute Value	- [message passed by environmental monitor]
 */

#define	ENV_OK		1
#define	ENV_WARNING	2
#define	ENV_FAILED	3

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_SYSEVENT_ENV_H */
