/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_SYSEVENT_DOMAIN_H
#define	_SYS_SYSEVENT_DOMAIN_H

#pragma ident	"@(#)domain.h	1.1	00/05/11 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Event type EC_DOMAIN/ESC_DOMAIN_STATE_CHANGE schema
 *	Event Class	- EC_DOMAIN
 *	Event Sub-Class	- ESC_DOMAIN_STATE_CHANGE
 *	Event Publisher	- SUNW:kern:[domain env monitor]
 *	Attribute Name	- WHAT_CHANGED
 *	Attribute Type	- SE_DATA_TYPE_STRING
 *	Attribute Value	- DOMAIN_RESERVED_ATTR | DOMAIN_KEYSWITCH
 */
#define	DOMAIN_WHAT_CHANGED	"domain_what_changed"
#define	DOMAIN_KEYSWITCH	"domain_keyswitch"
#define	DOMAIN_RESERVED_ATTR	""

/*
 * Event type EC_DOMAIN/ESC_DOMAIN_LOGHOST_CHANGE schema
 *	Event Class	- EC_DOMAIN
 *	Event Sub-Class	- ESC_DOMAIN_LOGHOST_CHANGE
 *	Event Publisher	- SUNW:kern:[domain env monitor]
 *	Attribute Name	- DOMAIN_LOGHOSTS
 *	Attribute Type	- SE_DATA_TYPE_STRING
 *	Attribute Value	- [New domain loghost names]
 */
#define	DOMAIN_LOGHOSTS	"domain_loghost_name"

#ifdef	__cplusplus
}
#endif

#endif /* _SYS_SYSEVENT_DOMAIN_H */
