/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _SYS_PPMIO_H
#define	_SYS_PPMIO_H

#pragma ident	"@(#)ppmio.h	1.1	00/05/22 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#define	PPMIOC			('p' << 8)
#define	PPMIOCSET		(PPMIOC | 1)
#define	PPMIOCGET		(PPMIOC | 2)

/*
 * ppm_idev_level_t defines the platform internal device power level
 */
typedef enum {
	PPM_IDEV_POWER_OFF,
	PPM_IDEV_POWER_ON
} ppm_idev_level_t;

typedef struct ppmreq {
	int	ppmdev;
	union ppmop {
		/*
		 * PPM_INTERNAL_DEVICE_POWER
		 */
		struct idev_power {
			ppm_idev_level_t level;
		} idev_power;
	} ppmop;
} ppmreq_t;

/*
 * The following defines the type of platform devices for
 * ppmdev field in struct ppmreq currently supported.
 */
#define	PPM_INTERNAL_DEVICE_POWER	1

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_PPMIO_H */
