/*
 * Copyright (c) FUJITSU LIMITED 1999
 * All Rights Reserved
 */

#ifndef _U2U_H
#define _U2U_H

#pragma ident "@(#)u2u.h	1.2 99/09/08 20:18:11"

#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _KAISER

/*
 * Number of dispatch target entries.
 */
#define U2U_DATA_NUM  16

/*
 *  Offsets of registers in the Interrupt Dispatch Table:
 */
#define U2U_MODE_STATUS_REGISTER_OFFSET		0x00000000
#define U2U_PID_REGISTER_OFFSET 		0x00000008
#define U2U_DATA_REGISTER_OFFSET                0x00000010

/*
 *  The following two difinitions are used to
 *  represent construction of the Interrupt Dispatch Table 
 *  on Kaiser's U2U, for software coding.
 */
typedef struct u2u_data_regs {
	uint16_t	u2u_data_dm16;
	uint8_t		u2u_data_dm8;
	uint8_t		u2u_data_reg;
	uint32_t	u2u_data_dm32;
} u2u_data_regs_t;

typedef struct u2u_dispatch_regs {
	uint32_t	u2u_mode_status_reg;
	uint32_t	u2u_dummy1;
	uint32_t	u2u_pid_reg;
	uint32_t	u2u_dummy2;
	u2u_data_regs_t	u2u_data_regs[U2U_DATA_NUM];
} u2u_dispatch_regs_t;

/*
 * Mode Status register bit definitions:
 */
#define U2U_MS_CEN    0x00000080 /* bit-7; UE data conversion enable      */
#define U2U_MS_IEV    0x00000040 /* bit-6; Interrupt Extension enable     */
#define U2U_MS_OFEN   0x00000020 /* bit-5; PCI bus error offline enable   */
#define U2U_MS_ECC_U  0x00000008 /* bit-3; UE-ECC error detected          */
#define U2U_MS_ECC_C  0x00000004 /* bit-2; CE-ECC error detected          */
#define U2U_MS_RESET  0x00000002 /* bit-1; U2P Reset                      */
#define U2U_MS_OFFLN  0x00000001 /* bit-0; PCI bus offline status/command */

/*
 * Index number of U2U registers in OBP's "regs-property" 
 * of PSYCHO.
 */
#define REGS_INDEX_OF_U2U     3

/*
 * The following two difinitions are used to control target id 
 * for Interrupt dispatch data by software.
 */
typedef struct u2u_ittrans_id {
	u_int		u2u_tgt_cpu_id;
	u_int		u2u_rsv1;
	volatile uint64_t	*u2u_ino_map_reg;
} u2u_ittrans_id_t;

typedef struct u2u_ittrans_data {
	kmutex_t		u2u_ittrans_lock;
	uintptr_t		u2u_regs_base;	/* "reg" property    */
	ddi_acc_handle_t	u2u_acc;	/* pointer to acc */
	u_int			u2u_port_id;	/* "PID" register n U2U */
	u_int			u2u_board;	/* "board#" property */ 
	u_int			u2u_u2u;	/* "u2u#" property   */
	u_short			u2u_ce_occured; /* correctable error counter */
	u_short			u2u_peek_fail;	/* peek fail counter */
	u2u_ittrans_id_t	u2u_ittrans_id[U2U_DATA_NUM];
} u2u_ittrans_data_t;


/* U2U Offline feature */

#define U2U_OFFLINE_DISABLE      0
#define U2U_OFFLINE_ENABLE       1

#define U2U_OFFLINE              0
#define U2U_ONLINE               1

#define ACCESS_CHK_DISABLE       0
#define ACCESS_CHK_ENABLE       10
#define ACCESS_CHK_INTR_ENABLE  11

#define U2P_RESET_OFF            0
#define U2P_RESET_ON             1

#define OFFLINE_MODE             0
#define PANIC_MODE               1

#define RETRY_ERR_PANIC  0
#define RETRY_ERR_WARN_ONLY 1

/*
 * fjsv_panic_mode is panic mode flag for cluster sysyem.
 * If fjsv_panic_mode is 1, then U2U offline feature disable
 * and system should panic when pci bus error occurs.
 */
extern int  fjsv_panic_mode;

/*
 * nscfcnode is the number of SCFC node.
 * If nscfcnode is less than 2, then U2U offline feature of U2U#3
 * on each system board disable and system should panic when pci
 * bus error occurs on U2U#3.
 */
extern int  nscfcnode;

/*
 * Functions for U2U Offline
 */
extern void  u2u_offline_init(pci_t *pci_p);
extern void  u2u_offline_child_check(pci_t *pci_p, dev_info_t *rdip,
				     caddr_t *addrp, struct regspec *rp);
extern void  u2u_set_offline_enable(pci_t *pci_p);
extern void  u2u_set_offline_disable(pci_t *pci_p);
extern void  u2u_set_offline_state(pci_t *pci_p);
extern int   u2u_get_online_state(dev_info_t *dip);
extern void  u2u_u2p_reset(pci_t *pci_p);
extern void  u2u_pause_other_cpus(void);
extern void  u2u_restart_other_cpus(void);
extern void  u2u_u2p_reset_cpu_loop(void);
extern void  u2u_set_u2p_reset(pci_t *pci_p, int flag);
extern void  u2u_ittrans_resume(pci_t *pci_p,
				u2u_ittrans_data_t **ittrans_cookie);


#endif /* _KAISER */

#ifdef __cplusplus
}
#endif

#endif /* _U2U_H */
