/*
 * Copyright (c) 1996,1998-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_CPU_SGNBLK_DEFS_H
#define	_CPU_SGNBLK_DEFS_H

#pragma ident	"@(#)cpu_sgnblk_defs.h	1.14	00/07/11 SMI"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _ASM

#include <sys/types.h>
#include <sys/cpuvar.h>

#endif /* _ASM */

/*
 * Build a CPU signature given a signature, state and sub-state.
 */
#define	CPU_SIG_BLD(sig, state, sub_state) \
	(((sig) << 16) | ((state) << 8) | (sub_state))

/*
 * Definition of a CPU signature.
 */
typedef union {
	struct cpu_signature {
		ushort_t	sig;		/* see xxxx_SIG below. */
		uchar_t		state;		/* see SIGBST_xxxx below. */
		uchar_t		sub_state;	/* EXIT_xxx if SIGBST_EXIT. */
	} state_t;
	uint32_t	signature;
} sig_state_t;

/*
 *  CPU Signatures - the signature defines the entity that the CPU is
 *  executing. This entity can be the OS, OPB or KADB. This signature
 *  consists of two ASCII characters.
 */
#define	SIG_BLD(f, s)	(((f) << 8) | (s))

#define	OBP_SIG		SIG_BLD('O', 'B')
#define	OS_SIG		SIG_BLD('O', 'S')
#define	DBG_SIG		SIG_BLD('D', 'B')

/*
 * CPU State - the state identifies what the CPU is doing.
 * The states should be defined in an increasing, linear
 * manner.
 */
#define	SIGST_NONE			0
#define	SIGST_RUN			1
#define	SIGST_EXIT			2
#define	SIGST_PRERUN			3
#define	SIGST_DOMAINSTOP		4
#define	SIGST_RESET			5
#define	SIGST_POWEROFF			6
#define	SIGST_DETACHED			7
#define	SIGST_CALLBACK			8
#define	SIGST_OFFLINE			9
#define	SIGST_BOOTING			10
#define	SIGST_UNKNOWN			11
#define	SIGST_ERROR_RESET		12
#define	SIGST_ERROR_RESET_SYNC		13
#define	SIGST_QUIESCED			14
#define	SIGST_QUIESCE_INPROGRESS	15
#define	SIGST_RESUME_INPROGRESS		16

/*
 *  CPU sub-state - the sub-state is used to further qualify
 *  the state.
 */
#define	SIGSUBST_NULL			0
#define	SIGSUBST_HALT			1
#define	SIGSUBST_ENVIRON		2
#define	SIGSUBST_REBOOT			3
#define	SIGSUBST_PANIC			4
#define	SIGSUBST_PANIC_CONT		5
#define	SIGSUBST_HUNG			6
#define	SIGSUBST_WATCH			7
#define	SIGSUBST_PANIC_REBOOT		8
#define	SIGSUBST_ERROR_RESET_REBOOT	9
#define	SIGSUBST_OBP_RESET		10
#define	SIGSUBST_DEBUG			11
#define	SIGSUBST_DUMP			12

#ifdef _KERNEL

/*
 * This header file is common between OS and KADB.  We use
 * _CPU_SIGNATURE to indicate that our version of KADB supports
 * CPU signatures (which it handles through OBP callbacks.)
 */
#ifdef _CPU_SIGNATURE
#define	DBGR_SGN_UPDATE_OBP()   \
	prom_interpret("sigb-sig! my-sigb-sig!", OBP_SIG, OBP_SIG, 0, 0, 0)
#define	DBGR_SGN_UPDATE_OS()    \
	prom_interpret("sigb-sig! my-sigb-sig!", OS_SIG, OS_SIG, 0, 0, 0)
#else /* _CPU_SIGNATURE */
#define	DBGR_SGN_UPDATE_OBP()
#define	DBGR_SGN_UPDATE_OS()
#endif /* _CPU_SIGNATURE */

#define	CPU_SIGNATURE(sig, state, sub_state, cpuid)			\
{									\
	if (cpu_sgn_func)						\
		(*cpu_sgn_func)((sig), (state), (sub_state), (cpuid));	\
}

extern void (*cpu_sgn_func)(ushort_t, uchar_t, uchar_t, int);



#ifdef _STARFIRE

extern void register_bbus_intr();
extern void cpu_sgn_mapin(int);
extern void cpu_sgn_mapout(int);
extern int cpu_sgn_exists(int);
extern ushort_t get_cpu_sgn(int);
extern uchar_t get_cpu_sgn_state(int);

#define	REGISTER_BBUS_INTR()	register_bbus_intr()
#define	CPU_SGN_MAPIN(cpuid)	cpu_sgn_mapin(cpuid)
#define	CPU_SGN_MAPOUT(cpuid)	cpu_sgn_mapout(cpuid)
#define	CPU_SGN_EXISTS(cpuid)	cpu_sgn_exists(cpuid)
#define	SGN_CPU_IS_OS(cpuid)	(get_cpu_sgn(cpuid) == OS_SIG)
#define	SGN_CPU_IS_OBP(cpuid)	(get_cpu_sgn(cpuid) == OBP_SIG)
#define	SGN_CPU_STATE_IS_DETACHED(cpuid)	\
				(get_cpu_sgn_state(cpuid) == SIGST_DETACHED)

#else

#define	REGISTER_BBUS_INTR()
#define	CPU_SGN_MAPIN(cpuid)
#define	CPU_SGN_MAPOUT(cpuid)
#define	CPU_SGN_EXISTS(cpuid)	(0)
#define	SGN_CPU_IS_OS(cpuid)	(0)
#define	SGN_CPU_IS_OBP(cpuid)	(0)
#define	SGN_CPU_STATE_IS_DETACHED(cpuid)	(0)

#endif	/* _STARFIRE */

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _CPU_SGNBLK_DEFS_H */
