/*
 * Copyright (c) 1999-2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef _I2C_CLIENT_H
#define	_I2C_CLIENT_H

#pragma ident   "@(#)i2c_client.h 1.2     00/08/03 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Common IOCTL definitions for client drivers.
 */

#define	I2C_BASE_IOCTL	('M' << 8)

#define	I2C_GET_PORT		(I2C_BASE_IOCTL | 0)
#define	I2C_SET_PORT		(I2C_BASE_IOCTL | 1)
#define	I2C_GET_BIT		(I2C_BASE_IOCTL | 2)
#define	I2C_SET_BIT		(I2C_BASE_IOCTL | 3)
#define	I2C_GET_REG		(I2C_BASE_IOCTL | 4)
#define	I2C_SET_REG		(I2C_BASE_IOCTL | 5)
#define	I2C_GET_TEMPERATURE	(I2C_BASE_IOCTL | 7)
#define	I2C_GET_FAN_SPEED	(I2C_BASE_IOCTL | 8)
#define	I2C_SET_FAN_SPEED	(I2C_BASE_IOCTL | 9)
#define	I2C_SET_OUTPUT		(I2C_BASE_IOCTL | 10)
#define	I2C_GET_OUTPUT		(I2C_BASE_IOCTL | 11)
#define	I2C_GET_INPUT		(I2C_BASE_IOCTL | 12)
#define	I2C_SET_MODE		(I2C_BASE_IOCTL | 13)
#define	I2C_GET_MODE		(I2C_BASE_IOCTL | 14)

/*
 * ARGS for I2C_*_MODE
 */
#define	I2C_NORMAL	0
#define	I2C_DEBUG	1

/*
 * ARGS for i2c_bit_t direction
 */

#define	DIR_NO_CHANGE	0
#define	DIR_OUTPUT	1
#define	DIR_INPUT	2


#define	INST_TO_MINOR(x) (x << 4)
#define	MINOR_TO_INST(x) ((x & 0xFFFFFFF0) >> 4)
#define	PORT_TO_MINOR(x)  (x)
#define	MINOR_TO_PORT(x)  (0x0F & x)

#define	I2C_PORT(x)		(0x00 + x)

typedef struct i2c_port {
	uint8_t		value;
	uint8_t		direction;
	uint8_t		dir_mask;
} i2c_port_t;

typedef struct i2c_bit {
	uchar_t		bit_num;
	boolean_t	bit_value;
	uint8_t		direction;
} i2c_bit_t;

typedef struct i2c_reg {
	uint8_t		reg_num;
	int32_t		reg_value;
} i2c_reg_t;

#if defined(_KERNEL)

#include <sys/i2c/misc/i2c_svc.h>

#endif /* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif /* _I2C_CLIENT_H */
