/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import com.sun.prodreg.util.LogThread;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class ExecuteCommand {
    private boolean collectOutput = false;
    private String[] errorLogFiles = null;
    private String[] outputLogFiles = null;
    private int outputType = 0;
    public static final int STDOUT = 1;
    public static final int STDERR = 2;
    private int result = -1;
    private String output = "";
    private String errors = "";
    private String both = "";
    private boolean state = false;
    private String errorMessage = null;
    private InputStream stdin = null;
    private Hashtable env = null;
    private String[] command = null;

    public ExecuteCommand(String string) {
        this(string, null);
    }

    public ExecuteCommand(String string, InputStream inputStream) {
        this(string, inputStream, null, 3);
    }

    public ExecuteCommand(String string, InputStream inputStream, String[] stringArray, int n) {
        this.setStdin(inputStream);
        this.setCollectOutput(true);
        this.setOutputType(n);
        this.setCommand(string);
        this.setLogFiles(stringArray);
    }

    public ExecuteCommand(String[] stringArray) {
        this("", null);
        this.setCommand(stringArray);
    }

    public void addLogFiles(int n, String[] stringArray) {
        String[] stringArray2;
        if ((n & 1) != 0) {
            if (this.outputLogFiles == null) {
                this.outputLogFiles = stringArray;
            } else {
                stringArray2 = this.outputLogFiles;
                this.outputLogFiles = new String[stringArray2.length + stringArray.length];
                System.arraycopy(stringArray2, 0, this.outputLogFiles, 0, stringArray2.length);
                System.arraycopy(stringArray, 0, this.outputLogFiles, stringArray2.length, stringArray.length);
            }
        }
        if ((n & 2) != 0) {
            if (this.errorLogFiles == null) {
                this.errorLogFiles = stringArray;
            } else {
                stringArray2 = this.errorLogFiles;
                this.errorLogFiles = new String[stringArray2.length + stringArray.length];
                System.arraycopy(stringArray2, 0, this.errorLogFiles, 0, stringArray2.length);
                System.arraycopy(stringArray, 0, this.errorLogFiles, stringArray2.length, stringArray.length);
            }
        }
    }

    private static String[] createEnvArray(Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Enumeration enumeration = hashtable.keys();
        String[] stringArray = new String[hashtable.size()];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            stringArray[n++] = String.valueOf(string) + "=" + string2;
        }
        return stringArray;
    }

    public void execute() {
        Process process = null;
        try {
            String[] stringArray = ExecuteCommand.createEnvArray(this.env);
            process = Runtime.getRuntime().exec(this.command, stringArray);
            if (process != null) {
                LogThread logThread = null;
                if (this.stdin != null) {
                    logThread = new LogThread(this.stdin, process.getOutputStream());
                    logThread.setClose(true);
                    logThread.setName("Feeder");
                    logThread.start();
                }
                if (this.collectOutput) {
                    this.readOutput(process);
                } else {
                    this.result = process.waitFor();
                }
                if (logThread != null) {
                    logThread.join();
                }
                process.getInputStream().close();
                process.getOutputStream().close();
                process.getErrorStream().close();
                process.destroy();
                process = null;
                this.state = true;
            }
        }
        catch (Exception exception) {
            if (process == null) {
                this.errorMessage = "ExecuteCommand: " + ExecuteCommand.expandCommand(this.command) + " failed";
            }
            System.out.println("ExecuteCommand Error: " + exception);
            exception.printStackTrace();
        }
    }

    public static String expandCommand(String[] stringArray) {
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + stringArray[n] + " +++ ";
            ++n;
        }
        string = string.trim();
        return string;
    }

    public String getAllOutput() {
        return this.both;
    }

    public boolean getCollectOutput() {
        return this.collectOutput;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrors() {
        return this.errors;
    }

    public String getOutput() {
        return this.output;
    }

    public int getResult() {
        return this.result;
    }

    public boolean getState() {
        return this.state;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public static String[] parseCommand(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public void putEnvironmentSetting(String string, String string2) {
        if (this.env == null) {
            this.env = new Hashtable();
        }
        if (string == null) {
            throw new IllegalArgumentException("ExecuteCommand: putEnvironmentSetting: setting cannot be null");
        }
        if (string2 == null) {
            this.env.remove(string);
        } else {
            this.env.put(string, string2);
        }
    }

    private void readOutput(Process process) throws IOException {
        OutputStream[] outputStreamArray;
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        DataInputStream dataInputStream = new DataInputStream(process.getInputStream());
        DataInputStream dataInputStream2 = new DataInputStream(process.getErrorStream());
        Object var7_7 = null;
        String string = System.getProperty("line.separator");
        if (string == null) {
            string = "\r\n";
        }
        FileOutputStream[] fileOutputStreamArray = null;
        OutputStream[] outputStreamArray2 = null;
        FileOutputStream[] fileOutputStreamArray2 = null;
        OutputStream[] outputStreamArray3 = null;
        if (this.outputLogFiles != null) {
            fileOutputStreamArray = new FileOutputStream[this.outputLogFiles.length];
            outputStreamArray2 = new DataOutputStream[this.outputLogFiles.length];
            n = 0;
            try {
                n = 0;
                while (n < this.outputLogFiles.length) {
                    fileOutputStreamArray[n] = new FileOutputStream(this.outputLogFiles[n], true);
                    outputStreamArray2[n] = new DataOutputStream(fileOutputStreamArray[n]);
                    ++n;
                }
                if ((this.outputType & 1) != 0) {
                    this.output.concat("---> " + this.outputLogFiles[0]);
                    this.both.concat("---> " + this.outputLogFiles[0]);
                }
            }
            catch (IOException iOException) {
                System.out.println("ExecuteCommand: Error opening log file \"" + this.outputLogFiles[n] + "\" for writing standard output");
                fileOutputStreamArray = null;
            }
        }
        if (this.errorLogFiles != null) {
            fileOutputStreamArray2 = new FileOutputStream[this.errorLogFiles.length];
            outputStreamArray3 = new DataOutputStream[this.errorLogFiles.length];
            n = 0;
            try {
                n = 0;
                while (n < this.errorLogFiles.length) {
                    fileOutputStreamArray2[n] = new FileOutputStream(this.errorLogFiles[n], true);
                    outputStreamArray3[n] = new DataOutputStream(fileOutputStreamArray2[n]);
                    ++n;
                }
                if ((this.outputType & 1) != 0) {
                    this.output.concat("---> " + this.errorLogFiles[0]);
                    this.both.concat("---> " + this.errorLogFiles[0]);
                }
            }
            catch (IOException iOException) {
                System.out.println("ExecuteCommand: Error opening log file \"" + this.errorLogFiles[n] + "\" for writing standard error");
                fileOutputStreamArray2 = null;
            }
        }
        LogThread logThread = null;
        LogThread logThread2 = null;
        if ((this.outputType & 1) != 0) {
            if (fileOutputStreamArray != null) {
                logThread = new LogThread((InputStream)dataInputStream, outputStreamArray2);
            } else {
                outputStreamArray = new ByteArrayOutputStream[]{byteArrayOutputStream, byteArrayOutputStream3};
                logThread = new LogThread((InputStream)dataInputStream, outputStreamArray);
            }
            logThread.setName("STDIN Reader");
            logThread.start();
        }
        if ((this.outputType & 2) != 0) {
            if (fileOutputStreamArray2 != null) {
                logThread2 = new LogThread((InputStream)dataInputStream2, outputStreamArray3);
            } else {
                outputStreamArray = new ByteArrayOutputStream[]{byteArrayOutputStream2, byteArrayOutputStream3};
                logThread2 = new LogThread((InputStream)dataInputStream2, outputStreamArray);
            }
            logThread2.setName("STDERR Reader");
            logThread2.start();
        }
        try {
            this.result = process.waitFor();
            if (logThread != null) {
                logThread.join();
            }
            if (logThread2 != null) {
                logThread2.join();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(String.valueOf(String.valueOf(this)) + ": could not wait for process");
        }
        dataInputStream.close();
        dataInputStream2.close();
        this.output = byteArrayOutputStream.toString();
        this.errors = byteArrayOutputStream2.toString();
        this.both = byteArrayOutputStream3.toString();
        if (outputStreamArray2 != null) {
            int n2 = 0;
            while (n2 < outputStreamArray2.length) {
                ((DataOutputStream)outputStreamArray2[n2]).flush();
                ((FilterOutputStream)outputStreamArray2[n2]).close();
                ++n2;
            }
        }
        if (outputStreamArray3 != null) {
            int n3 = 0;
            while (n3 < outputStreamArray3.length) {
                ((DataOutputStream)outputStreamArray3[n3]).flush();
                ((FilterOutputStream)outputStreamArray3[n3]).close();
                ++n3;
            }
        }
        if (fileOutputStreamArray != null) {
            int n4 = 0;
            while (n4 < fileOutputStreamArray.length) {
                fileOutputStreamArray[n4].flush();
                fileOutputStreamArray[n4].close();
                ++n4;
            }
        }
        if (fileOutputStreamArray2 != null) {
            int n5 = 0;
            while (n5 < fileOutputStreamArray2.length) {
                fileOutputStreamArray2[n5].flush();
                fileOutputStreamArray2[n5].close();
                ++n5;
            }
        }
    }

    public String removeEnvironmentSetting(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ExecuteCommand: removeEnvironmentSetting: setting cannot be null");
        }
        if (this.env == null) {
            return null;
        }
        return (String)this.env.remove(string);
    }

    public void setCollectOutput(boolean bl) {
        this.collectOutput = bl;
    }

    public void setCommand(String string) {
        this.command = ExecuteCommand.parseCommand(string);
    }

    public void setCommand(String[] stringArray) {
        this.command = stringArray;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public void setLogFiles(String[] stringArray) {
        this.addLogFiles(3, stringArray);
    }

    public void setOutputType(int n) {
        this.outputType = n;
    }

    public void setResult(int n) {
        this.result = n;
    }

    public void setState(boolean bl) {
        this.state = bl;
    }

    public void setStdin(InputStream inputStream) {
        this.stdin = inputStream;
    }
}

