#pragma	ident "@(#)glmacros.h 1.4 97/05/05 SMI"

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */

#ifndef _GLMACROS_H
#define _GLMACROS_H


#include "GL/gl.h"

typedef void *OglContextPtr;

typedef struct OglPrimTableRec {
 
   /* NOTE: Don't change the ordering of these function pointers.
    */

   /* Mostly used vertex functions 
    */

   GLvoid (*oglVertex3f)(OglContextPtr, GLfloat x, GLfloat y, GLfloat z);
   GLvoid (*oglVertex3fv)(OglContextPtr,  const GLfloat v[3]);
   GLvoid (*oglVertex3d)(OglContextPtr, GLdouble x, GLdouble y, GLdouble z);
   GLvoid (*oglVertex3dv)(OglContextPtr,  const GLdouble v[3]);

   GLvoid (*oglNormal3f)(OglContextPtr, GLfloat nx, GLfloat ny, GLfloat nz);
   GLvoid (*oglNormal3fv)(OglContextPtr,  const GLfloat v[3]);
   GLvoid (*oglNormal3d)(OglContextPtr, GLdouble nx, GLdouble ny, GLdouble nz);
   GLvoid (*oglNormal3dv)(OglContextPtr,  const GLdouble v[3]);

   GLvoid (*oglColor3f)(OglContextPtr, GLfloat red, GLfloat green, GLfloat blue);
   GLvoid (*oglColor3fv)(OglContextPtr,  const GLfloat vp[3]);
   GLvoid (*oglColor3d)(OglContextPtr, GLdouble red, GLdouble green, GLdouble blue);
   GLvoid (*oglColor3dv)(OglContextPtr,  const GLdouble vp[3]);


   GLvoid (*oglVertex4f)(OglContextPtr, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
   GLvoid (*oglVertex4fv)(OglContextPtr,  const GLfloat v[4]);
   GLvoid (*oglVertex4d)(OglContextPtr, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
   GLvoid (*oglVertex4dv)(OglContextPtr,  const GLdouble v[4]);

   GLvoid (*oglColor4d)(OglContextPtr, GLdouble red, GLdouble green, GLdouble blue, GLdouble alpha);
   GLvoid (*oglColor4dv)(OglContextPtr,  const GLdouble vp[4]);
   GLvoid (*oglColor4f)(OglContextPtr, GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);    
   GLvoid (*oglColor4fv)(OglContextPtr,  const GLfloat vp[4]);

   GLvoid (*oglTexCoord3f)(OglContextPtr, GLfloat s, GLfloat t, GLfloat r);
   GLvoid (*oglTexCoord3fv)(OglContextPtr,  const GLfloat *v);
   GLvoid (*oglTexCoord3d)(OglContextPtr, GLdouble s, GLdouble t, GLdouble r);
   GLvoid (*oglTexCoord3dv)(OglContextPtr,  const GLdouble *v);
 
   GLvoid (*oglTexCoord4f)(OglContextPtr, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
   GLvoid (*oglTexCoord4fv)(OglContextPtr,  const GLfloat *v);
   GLvoid (*oglTexCoord4d)(OglContextPtr, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
   GLvoid (*oglTexCoord4dv)(OglContextPtr,  const GLdouble *v);
 
   GLvoid (*oglTexCoord2f)(OglContextPtr, GLfloat s, GLfloat t);
   GLvoid (*oglTexCoord2fv)(OglContextPtr,  const GLfloat *v);
   GLvoid (*oglTexCoord2d)(OglContextPtr, GLdouble u, GLdouble v);
   GLvoid (*oglTexCoord2dv)(OglContextPtr,  const GLdouble *v);


   /* Heavily used in 2D CAD 
    */

   GLvoid (*oglVertex2f)(OglContextPtr, GLfloat x, GLfloat y);
   GLvoid (*oglVertex2fv)(OglContextPtr,  const GLfloat v[2]);
   GLvoid (*oglVertex2d)(OglContextPtr, GLdouble x, GLdouble y);
   GLvoid (*oglVertex2dv)(OglContextPtr,  const GLdouble v[2]);

   GLvoid (*oglVertex2i)(OglContextPtr, GLint x, GLint y);
   GLvoid (*oglVertex2iv)(OglContextPtr,  const GLint v[2]);
   GLvoid (*oglVertex2s)(OglContextPtr, GLshort x, GLshort y);
   GLvoid (*oglVertex2sv)(OglContextPtr,  const GLshort v[2]);

   GLvoid (*oglIndexf)(OglContextPtr, GLfloat c);
   GLvoid (*oglIndexfv)(OglContextPtr,  const GLfloat *c);
   GLvoid (*oglIndexd)(OglContextPtr, GLdouble c);
   GLvoid (*oglIndexdv)(OglContextPtr,  const GLdouble *c);
   GLvoid (*oglIndexi)(OglContextPtr, GLint c);
   GLvoid (*oglIndexiv)(OglContextPtr,  const GLint *c);
   GLvoid (*oglIndexs)(OglContextPtr, GLshort c);
   GLvoid (*oglIndexsv)(OglContextPtr,  const GLshort *c);
   GLvoid (*oglIndexub)(OglContextPtr, GLubyte c);
   GLvoid (*oglIndexubv)(OglContextPtr, const GLubyte *c);


   /* infrequent functions
    */

   GLvoid (*oglVertex3i)(OglContextPtr, GLint x, GLint y, GLint z);
   GLvoid (*oglVertex3iv)(OglContextPtr,  const GLint v[3]);
   GLvoid (*oglVertex3s)(OglContextPtr, GLshort x, GLshort y, GLshort z);
   GLvoid (*oglVertex3sv)(OglContextPtr,  const GLshort v[3]);

   GLvoid (*oglVertex4i)(OglContextPtr, GLint x, GLint y, GLint z, GLint w);
   GLvoid (*oglVertex4iv)(OglContextPtr,  const GLint v[4]);
   GLvoid (*oglVertex4s)(OglContextPtr, GLshort x, GLshort y, GLshort z, GLshort w);
   GLvoid (*oglVertex4sv)(OglContextPtr,  const GLshort v[4]);

   GLvoid (*oglNormal3i)(OglContextPtr, GLint nx, GLint ny, GLint nz);
   GLvoid (*oglNormal3iv)(OglContextPtr,  const GLint v[3]);
   GLvoid (*oglNormal3s)(OglContextPtr, GLshort nx, GLshort ny, GLshort nz);
   GLvoid (*oglNormal3sv)(OglContextPtr,  const GLshort v[3]);
   GLvoid (*oglNormal3b)(OglContextPtr, GLbyte nx, GLbyte ny, GLbyte nz);
   GLvoid (*oglNormal3bv)(OglContextPtr,  const GLbyte v[3]);
 
   GLvoid (*oglColor3i)(OglContextPtr, GLint red, GLint green, GLint blue);
   GLvoid (*oglColor3iv)(OglContextPtr,  const GLint vp[3]);
   GLvoid (*oglColor3s)(OglContextPtr, GLshort red, GLshort green, GLshort blue);
   GLvoid (*oglColor3sv)(OglContextPtr,  const GLshort vp[3]);

   GLvoid (*oglColor3b)(OglContextPtr, GLbyte red,GLbyte green,GLbyte blue);
   GLvoid (*oglColor3bv)(OglContextPtr,  const GLbyte vp[3]);
   GLvoid (*oglColor3ub)(OglContextPtr, GLubyte red,GLubyte green,GLubyte blue);
   GLvoid (*oglColor3ubv)(OglContextPtr,  const GLubyte vp[3]);

   GLvoid (*oglColor3ui)(OglContextPtr, GLuint red,GLuint green,GLuint blue);
   GLvoid (*oglColor3uiv)(OglContextPtr,  const GLuint vp[3]);
   GLvoid (*oglColor3us)(OglContextPtr, GLushort red, GLushort green, GLushort blue);
   GLvoid (*oglColor3usv)(OglContextPtr,  const GLushort vp[3]);

   GLvoid (*oglColor4b)(OglContextPtr, GLbyte red,GLbyte green,GLbyte blue,GLbyte alpha);
   GLvoid (*oglColor4bv)(OglContextPtr,  const GLbyte vp[4]);
   GLvoid (*oglColor4i)(OglContextPtr, GLint red, GLint green, GLint blue, GLint alpha);
   GLvoid (*oglColor4iv)(OglContextPtr,  const GLint vp[4]);

   GLvoid (*oglColor4s)(OglContextPtr, GLshort red, GLshort green, GLshort blue, short alpha);
   GLvoid (*oglColor4sv)(OglContextPtr,  const GLshort vp[4]);
   GLvoid (*oglColor4ub)(OglContextPtr, GLubyte red,GLubyte green,GLubyte blue,GLubyte alpha);
   GLvoid (*oglColor4ubv)(OglContextPtr,  const GLubyte vp[4]);
 
   GLvoid (*oglColor4ui)(OglContextPtr, GLuint red,GLuint green,GLuint blue,GLuint alpha);
   GLvoid (*oglColor4uiv)(OglContextPtr,  const GLuint vp[4]);
   GLvoid (*oglColor4us)(OglContextPtr, GLushort red, GLushort green, GLushort blue, GLushort alpha);
   GLvoid (*oglColor4usv)(OglContextPtr,  const GLushort vp[4]);


   GLvoid (*oglTexCoord1f)(OglContextPtr, GLfloat s);
   GLvoid (*oglTexCoord1fv)(OglContextPtr,  const GLfloat *s);
   GLvoid (*oglTexCoord1d)(OglContextPtr, GLdouble s);
   GLvoid (*oglTexCoord1dv)(OglContextPtr,  const GLdouble *s);

   GLvoid (*oglTexCoord2s)(OglContextPtr, GLshort s, GLshort t);
   GLvoid (*oglTexCoord2sv)(OglContextPtr,  const GLshort *v);
   GLvoid (*oglTexCoord2i)(OglContextPtr, GLint s, GLint t);
   GLvoid (*oglTexCoord2iv)(OglContextPtr,  const GLint *v);

   GLvoid (*oglTexCoord1s)(OglContextPtr, GLshort s);
   GLvoid (*oglTexCoord1sv)(OglContextPtr,  const GLshort *s);
   GLvoid (*oglTexCoord1i)(OglContextPtr, GLint s);
   GLvoid (*oglTexCoord1iv)(OglContextPtr,  const GLint *s);

   GLvoid (*oglTexCoord3s)(OglContextPtr, GLshort s, GLshort t, GLshort r);
   GLvoid (*oglTexCoord3sv)(OglContextPtr,  const GLshort *v);
   GLvoid (*oglTexCoord3i)(OglContextPtr, GLint s, GLint t, GLint r);
   GLvoid (*oglTexCoord3iv)(OglContextPtr,  const GLint *v);

   GLvoid (*oglTexCoord4s)(OglContextPtr,  GLshort s, GLshort t, GLshort r, GLshort q);
   GLvoid (*oglTexCoord4sv)(OglContextPtr,   const GLshort *v);
   GLvoid (*oglTexCoord4i)(OglContextPtr,  GLint s, GLint t, GLint r, GLint q);
   GLvoid (*oglTexCoord4iv)(OglContextPtr,   const GLint *v);

   GLvoid (*unused[10])(OglContextPtr);
 
} OglPrimTable;

extern struct OglContextRec *sunOglCurrentContext;
extern OglPrimTable *sunOglCurPrimTablePtr;

#define glVertex2f(_x,_y) \
    (*sunOglCurPrimTablePtr->oglVertex2f)(sunOglCurrentContext, _x,_y)

#define glVertex2fv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex2fv)(sunOglCurrentContext, _v)


#define glVertex2d(_x,_y) \
    (*sunOglCurPrimTablePtr->oglVertex2d)(sunOglCurrentContext, _x,_y)

#define glVertex2dv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex2dv)(sunOglCurrentContext, _v)


#define glVertex2i(_x,_y) \
    (*sunOglCurPrimTablePtr->oglVertex2i)(sunOglCurrentContext, _x,_y)

#define glVertex2iv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex2iv)(sunOglCurrentContext, _v)


#define glVertex2s(_x,_y) \
    (*sunOglCurPrimTablePtr->oglVertex2s)(sunOglCurrentContext, _x,_y)

#define glVertex2sv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex2sv)(sunOglCurrentContext, _v)


#define glVertex3f(_x,_y,_z) \
    (*sunOglCurPrimTablePtr->oglVertex3f)(sunOglCurrentContext, _x,_y,_z)
 
#define glVertex3fv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex3fv)(sunOglCurrentContext, _v)

 
#define glVertex3d(_x,_y,_z) \
    (*sunOglCurPrimTablePtr->oglVertex3d)(sunOglCurrentContext, _x,_y,_z)
 
#define glVertex3dv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex3dv)(sunOglCurrentContext, _v)

 
#define glVertex3i(_x,_y,_z) \
    (*sunOglCurPrimTablePtr->oglVertex3i)(sunOglCurrentContext, _x,_y,_z)
 
#define glVertex3iv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex3iv)(sunOglCurrentContext, _v)

 
#define glVertex3s(_x,_y,_z) \
    (*sunOglCurPrimTablePtr->oglVertex3s)(sunOglCurrentContext, _x,_y,_z)
 
#define glVertex3sv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex3sv)(sunOglCurrentContext, _v)


#define glVertex4f(_x,_y,_z,_w) \
    (*sunOglCurPrimTablePtr->oglVertex4f)(sunOglCurrentContext, _x,_y,_z,_w)

#define glVertex4fv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex4fv)(sunOglCurrentContext, _v)


#define glVertex4d(_x,_y,_z,_w) \
    (*sunOglCurPrimTablePtr->oglVertex4d)(sunOglCurrentContext, _x,_y,_z,_w)

#define glVertex4dv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex4dv)(sunOglCurrentContext, _v)


#define glVertex4i(_x,_y,_z,_w) \
    (*sunOglCurPrimTablePtr->oglVertex4i)(sunOglCurrentContext, _x,_y,_z,_w)

#define glVertex4iv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex4iv)(sunOglCurrentContext, _v)


#define glVertex4s(_x,_y,_z,_w) \
    (*sunOglCurPrimTablePtr->oglVertex4s)(sunOglCurrentContext, _x,_y,_z,_w)

#define glVertex4sv(_v) \
    (*sunOglCurPrimTablePtr->oglVertex4sv)(sunOglCurrentContext, _v)


#define glNormal3f(_nx,_ny,_nz) \
    (*sunOglCurPrimTablePtr->oglNormal3f)(sunOglCurrentContext, _nx,_ny,_nz)
 
#define glNormal3fv(_v) \
    (*sunOglCurPrimTablePtr->oglNormal3fv)(sunOglCurrentContext, _v)


#define glNormal3d(_nx,_ny,_nz) \
    (*sunOglCurPrimTablePtr->oglNormal3d)(sunOglCurrentContext, _nx,_ny,_nz)

#define glNormal3dv(_v) \
    (*sunOglCurPrimTablePtr->oglNormal3dv)(sunOglCurrentContext, _v)


#define glNormal3i(_nx,_ny,_nz) \
    (*sunOglCurPrimTablePtr->oglNormal3i)(sunOglCurrentContext, _nx,_ny,_nz)

#define glNormal3iv(_v) \
    (*sunOglCurPrimTablePtr->oglNormal3iv)(sunOglCurrentContext, _v)


#define glNormal3s(_nx,_ny,_nz) \
    (*sunOglCurPrimTablePtr->oglNormal3s)(sunOglCurrentContext, _nx,_ny,_nz)

#define glNormal3sv(_v) \
    (*sunOglCurPrimTablePtr->oglNormal3sv)(sunOglCurrentContext, _v)


#define glNormal3b(_nx,_ny,_nz) \
    (*sunOglCurPrimTablePtr->oglNormal3b)(sunOglCurrentContext, _nx,_ny,_nz)

#define glNormal3bv(_v) \
    (*sunOglCurPrimTablePtr->oglNormal3bv)(sunOglCurrentContext, _v)


#define glColor3f(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3f)(sunOglCurrentContext, _r,_g,_b)

#define glColor3fv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3fv)(sunOglCurrentContext, _v)


#define glColor3d(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3d)(sunOglCurrentContext, _r,_g,_b)

#define glColor3dv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3dv)(sunOglCurrentContext, _v)


#define glColor3i(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3i)(sunOglCurrentContext, _r,_g,_b)

#define glColor3iv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3iv)(sunOglCurrentContext, _v)


#define glColor3s(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3s)(sunOglCurrentContext, _r,_g,_b)

#define glColor3sv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3sv)(sunOglCurrentContext, _v)
 
 
#define glColor3b(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3b)(sunOglCurrentContext, _r,_g,_b)
 
#define glColor3bv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3bv)(sunOglCurrentContext, _v)
 
 
#define glColor3ub(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3ub)(sunOglCurrentContext, _r,_g,_b)
 
#define glColor3ubv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3ubv)(sunOglCurrentContext, _v)
 
 
#define glColor3ui(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3ui)(sunOglCurrentContext, _r,_g,_b)
 
#define glColor3uiv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3uiv)(sunOglCurrentContext, _v)
 
 
#define glColor3us(_r,_g,_b) \
    (*sunOglCurPrimTablePtr->oglColor3us)(sunOglCurrentContext, _r,_g,_b)
 
#define glColor3usv(_v) \
    (*sunOglCurPrimTablePtr->oglColor3usv)(sunOglCurrentContext, _v)
 
 
#define glColor4f(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4f)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4fv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4fv)(sunOglCurrentContext, _v)
 
 
#define glColor4d(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4d)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4dv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4dv)(sunOglCurrentContext, _v)
 
 
#define glColor4i(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4i)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4iv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4iv)(sunOglCurrentContext, _v)
 
 
#define glColor4s(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4s)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4sv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4sv)(sunOglCurrentContext, _v)
 
 
#define glColor4b(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4b)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4bv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4bv)(sunOglCurrentContext, _v)
 
 
#define glColor4ub(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4ub)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4ubv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4ubv)(sunOglCurrentContext, _v)
 
 
#define glColor4ui(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4ui)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4uiv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4uiv)(sunOglCurrentContext, _v)
 
 
#define glColor4us(_r,_g,_b,_a) \
    (*sunOglCurPrimTablePtr->oglColor4us)(sunOglCurrentContext, _r,_g,_b,_a)
 
#define glColor4usv(_v) \
    (*sunOglCurPrimTablePtr->oglColor4usv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord1f(_s) \
    (*sunOglCurPrimTablePtr->oglTexCoord1f)(sunOglCurrentContext, _s)
 
#define glTexCoord1fv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord1fv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord1d(_s) \
    (*sunOglCurPrimTablePtr->oglTexCoord1d)(sunOglCurrentContext, _s)
 
#define glTexCoord1dv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord1dv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord1s(_s) \
    (*sunOglCurPrimTablePtr->oglTexCoord1s)(sunOglCurrentContext, _s)
 
#define glTexCoord1sv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord1sv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord1i(_s) \
    (*sunOglCurPrimTablePtr->oglTexCoord1i)(sunOglCurrentContext, _s)
 
#define glTexCoord1iv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord1iv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord2f(_s,_t) \
    (*sunOglCurPrimTablePtr->oglTexCoord2f)(sunOglCurrentContext, _s,_t)
 
#define glTexCoord2fv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord2fv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord2d(_s,_t) \
    (*sunOglCurPrimTablePtr->oglTexCoord2d)(sunOglCurrentContext, _s,_t)
 
#define glTexCoord2dv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord2dv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord2s(_s,_t) \
    (*sunOglCurPrimTablePtr->oglTexCoord2s)(sunOglCurrentContext, _s,_t)
 
#define glTexCoord2sv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord2sv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord2i(_s,_t) \
    (*sunOglCurPrimTablePtr->oglTexCoord2i)(sunOglCurrentContext, _s,_t)
 
#define glTexCoord2iv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord2iv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord3f(_s,_t,_r) \
    (*sunOglCurPrimTablePtr->oglTexCoord3f)(sunOglCurrentContext, _s,_t,_r)
 
#define glTexCoord3fv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord3fv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord3d(_s,_t,_r) \
    (*sunOglCurPrimTablePtr->oglTexCoord3d)(sunOglCurrentContext, _s,_t,_r)
 
#define glTexCoord3dv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord3dv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord3s(_s,_t,_r) \
    (*sunOglCurPrimTablePtr->oglTexCoord3s)(sunOglCurrentContext, _s,_t,_r)
 
#define glTexCoord3sv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord3sv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord3i(_s,_t,_r) \
    (*sunOglCurPrimTablePtr->oglTexCoord3i)(sunOglCurrentContext, _s,_t,_r)
 
#define glTexCoord3iv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord3iv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord4f(_s,_t,_r,_q) \
    (*sunOglCurPrimTablePtr->oglTexCoord4f)(sunOglCurrentContext, _s,_t,_r,_q)
 
#define glTexCoord4fv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord4fv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord4d(_s,_t,_r,_q) \
    (*sunOglCurPrimTablePtr->oglTexCoord4d)(sunOglCurrentContext, _s,_t,_r,_q)
 
#define glTexCoord4dv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord4dv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord4s(_s,_t,_r,_q) \
    (*sunOglCurPrimTablePtr->oglTexCoord4s)(sunOglCurrentContext, _s,_t,_r,_q)
 
#define glTexCoord4sv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord4sv)(sunOglCurrentContext, _v)
 
 
#define glTexCoord4i(_s,_t,_r,_q) \
    (*sunOglCurPrimTablePtr->oglTexCoord4i)(sunOglCurrentContext, _s,_t,_r,_q)
 
#define glTexCoord4iv(_v) \
    (*sunOglCurPrimTablePtr->oglTexCoord4iv)(sunOglCurrentContext, _v)
 
 
 
#define glIndexf(_c) \
    (*sunOglCurPrimTablePtr->oglIndexf)(sunOglCurrentContext, _c)
 
#define glIndexfv(_v) \
    (*sunOglCurPrimTablePtr->oglIndexfv)(sunOglCurrentContext, _v)
 
 
#define glIndexd(_c) \
    (*sunOglCurPrimTablePtr->oglIndexd)(sunOglCurrentContext, _c)
 
#define glIndexdv(_v) \
    (*sunOglCurPrimTablePtr->oglIndexdv)(sunOglCurrentContext, _v)
 
 
#define glIndexi(_c) \
    (*sunOglCurPrimTablePtr->oglIndexi)(sunOglCurrentContext, _c)
 
#define glIndexiv(_v) \
    (*sunOglCurPrimTablePtr->oglIndexiv)(sunOglCurrentContext, _v)
 
 
#define glIndexs(_c) \
    (*sunOglCurPrimTablePtr->oglIndexs)(sunOglCurrentContext, _c)
 
#define glIndexsv(_v) \
    (*sunOglCurPrimTablePtr->oglIndexsv)(sunOglCurrentContext, _v)
 
 
#define glIndexub(_c) \
    (*sunOglCurPrimTablePtr->oglIndexub)(sunOglCurrentContext, _c)
 
#define glIndexubv(_v) \
    (*sunOglCurPrimTablePtr->oglIndexubv)(sunOglCurrentContext, _v)
 

#endif
