#pragma ident "@(#)cgpi.h	1.11 99/04/09 SMI"

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */


/******************************************************************************
 * 
 * cgpi.h
 *
 * All internal data structures and constants.
 *
 *****************************************************************************/

#include "cgp.h"


/* function declarations */
void cgiSetError(CGenum);


/******************
 * Used to compare float values close to zero
 */
#define CGP_SMALL_FLOAT (float) 0.00001


/******************
 * values for Type CGPboolean
 */
#define CGP_TRUE	1
#define CGP_FALSE	0


/******************
 * CGPpoint
 *
 *  The point structure used by the other modules.
 */

/* Values for CGPoint.header            */
/*   Mesh buffer restart bits    */
#define CGP_POINT_HDR_RESTART_CW	0x00001
#define CGP_POINT_HDR_RESTART_CCW	0x00002
#define CGP_POINT_HDR_REPLACE_MIDDLE	0x00004
#define CGP_POINT_HDR_REPLACE_OLDEST	0x00008

/* Mesh buffer push bits         */
#define CGP_POINT_HDR_PUSH		0x00010
#define CGP_POINT_HDR_REF		0x00020

/* relative absolute bits - used by compression routine */
#define CGP_POINT_HDR_GEOMETRY_ABSOLUTE 0x01000
#define CGP_POINT_HDR_COLOR_ABSOLUTE    0x02000
#define CGP_POINT_HDR_NORMAL_ABSOLUTE   0x04000

/* used to set the compression amount */
#define CGP_POINT_HDR_QUANT_CHANGE_GEOM   0x10000
#define CGP_POINT_HDR_QUANT_CHANGE_COLOR  0x20000
#define CGP_POINT_HDR_QUANT_CHANGE_NORMAL 0x40000

/* Mesh Buffer Reference Number  */
#define CGP_GET_POINT_HDR_REF_NUMBER(_hdr) \
		((0xF0000000 & _hdr) >> 28)

#define CGP_SET_POINT_HDR_REF_NUMBER(_hdr, _ref) \
		 (_hdr |= (_ref << 28))

typedef struct {
	CGuint	header;		/* holds mesh buffer info */
	CGfloat	x;
	CGfloat	y;
	CGfloat	z;
	CGfloat	r;
	CGfloat	g;
	CGfloat	b;
	CGfloat	a;
	CGfloat	nX;
	CGfloat	nY;
	CGfloat	nZ;
	CGshort geomQuant;   /* number of bits to compress this and */
	CGshort colorQuant;  /*  subsequent data to                 */
	CGshort normalQuant;
        float   qx;          /* Debugging check for quantized positions */
        float   qy;
        float   qz;
} CGPpoint;



/*******************
 * CGPptbuffer
 *
 *  The point buffer is a singlely linked list allocated in arrays of
 *  PT_BUFFER_SIZE points at a time.  If an array fills up, another point
 *  structure is allocated.
 */

/* size of a point buffer (in points) */
#define CGP_PT_BUFFER_SIZE		14

typedef struct pt_buffer {
	CGPpoint		pts[CGP_PT_BUFFER_SIZE];
	struct pt_buffer*	nextPtBuffer;
} CGPptbuffer;


/*******************
 * CGPprimitive
 *
 *  The Primitive structure holds all the data accumulated within a
 *  cgBegin - cgEnd pair (along with any any global data).
 */

/* Values for Primitive.primFlags         */
/*   The points array will contain points of this type */
#define CGP_PT_TYPE_VTX			0x0
#define CGP_PT_TYPE_VTX_COLOR		0x0001
#define CGP_PT_TYPE_VTX_COLOR_ALPHA	0x0002
#define CGP_PT_TYPE_VTX_NORMAL		0x0004

/*   Front face direction                 */
#define CGP_FRONT_FACE_CCW		0x0	/* default value */
#define CGP_FRONT_FACE_CW		0x0010

/*    Valid bits                          */
/*     set when global color/normal       */
/*     values are valid for a primitive   */
#define CGP_GLOBAL_NORMAL_VALID		0x0100
#define CGP_GLOBAL_COLOR_VALID		0x0200
#define CGP_GLOBAL_ALPHA_VALID		0x0400

typedef struct {
	CGenum		primType;       /* values defined in cgp.h           */
	CGPptbuffer	ptBuff;
	CGuint		numPts;		/* number of points in primitive     */
	CGbitfield	primFlags;
	CGfloat		globalColorR;	/* global* fields hold the last      */
	CGfloat		globalColorG;	/*  data set outside a cgBegin/cgEnd */
	CGfloat		globalColorB;	/*  pair.                            */
	CGfloat		globalAlpha;
	CGfloat		globalNormalX;
	CGfloat		globalNormalY;
	CGfloat		globalNormalZ;
} CGPprimitive;


/*******************
 * CGPprimlist
 *
 * The primList structure holds all the data collected from
 * a cgBeginCompressedGeometryStream to a cgEndCompressedGeometryStream
 */
typedef struct prim_list {
	CGPprimitive		primitive;
	struct prim_list*	nextPrimitive;
} CGPprimlist;


/*******************
 * Values for the CurrentState bit field.
 *
 * The CurrentState bit field is a global variable that holds the
 * state the library is in as well keeping track of valid global
 * data.
 */

/* Current state of library                */
#define CGP_CS_LIB_IN_BEGIN_STREAM       0x0001
#define CGP_CS_LIB_IN_CGBEGIN            0x0002
#define CGP_CS_LIB_NO_VERTEX             0x0004

/* bits to indicate that a vertex has this information */
#define CGP_CS_VTX_HAS_COLOR		0x0010
#define CGP_CS_VTX_HAS_ALPHA		0x0020
#define CGP_CS_VTX_HAS_NORMAL		0x0040

/*   Valid bits                          */
/*    indicate if the Cur[color|normal]  */
/*    fields are valid.  This will not be*/
/*    the case only when a color/normal  */
/*    has not been issued.               */
/*                                       */
/*    Note: for alpha to be valid it     */
/*    must be something other than 1.0   */
#define CGP_CS_CURRENT_NORMAL_VALID	0x0100
#define CGP_CS_CURRENT_COLOR_VALID	0x0200
#define CGP_CS_CURRENT_ALPHA_VALID	0x0400

/* Primitive classes.                         		*/
/*  All primitives within a compressed geometry buffer 	*/
/*  must belong to the same class of primitive.		*/
#define CGP_CLASS_POINT	0x1
#define CGP_CLASS_LINE	0x2
#define CGP_CLASS_FILL	0x4

/* point type values used by the decompression routine */
#define CG_COLOR                       0x01
#define CG_ALPHA                       0x02
#define CG_NORMAL                      0x04

/* buffer version number */
#define CG_MAJOR_VN                     1
#define CG_MINOR_VN                     0
#define CG_MINOR_MINOR_VN               1

