#pragma ident "@(#)attrib.h 1.1 97/10/31 SMI"
#ifndef _mviewer_attrib__
#define _mviewer_attrib__
#include "typedefs.h"

/* Attrib */
struct Attrib {
  int          masks;		/* This is the 32-bit change masks
				 *  for different attributes */
  SurfaceProp *frontSurf;	/* front Surface properties */
  SurfaceProp *backSurf;	/* back Surface properties */
  int          drawingMode;	/* Wiremode, Solid, etc. */
  int	       blendSrc;	/* Blend Function for Src */
  int	       blendDest;	/* Blend Function for Dest */	
  int	       antialiasMode;	/* Antialiasing mode */	
  float	       lineWidth;	/* OGL line width */
  float	       pointSize;	/* OGL point size */
};

/* This is a good bound. */
#define MAX_ATTRIB_STACK_DEPTH 100 

/* A simple Attrib stack */
struct Stack {
  int top;
  Attrib *item[MAX_ATTRIB_STACK_DEPTH];
};

/* Different Rendering Modes. */
#define SOLIDMODE 0
#define WIREFRAME 1
#define POINTMODE 2
#define STRIPMODE 3
#define BOXMODE   4
#define FACETMODE 5
#define GTMESHMODE 6
#define RENDERTEST1 7
#define RENDERTEST2 8
#define RENDERTEST3 9
#define COLORPERVERTMODE 10
#define RENDERTEST4 11
#define RENDERTEST5 12
#define RENDERTEST6 13
#define RENDERTEST7 14

/* Antialiasing Modes. */
#define ANTI_LINE_MODE 0
#define ANTI_POINT_MODE 1
#define ANTI_POLYGON_MODE 2
#define ANTI_ALL_MODE 3

/* Define masks for the different attributes */
/* These are in hex and base10 powers of 2. */
#define ATTRIB_ALL		0xffffffff
#define ATTRIB_FRONT_SURF	0x00000001
#define ATTRIB_BACK_SURF	0x00000002
#define ATTRIB_BLEND_ON		0x00000004
#define ATTRIB_ANTIALIAS	0x00000008
#define ATTRIB_DRAWING_MODE	0x00000010
#define ATTRIB_LINE_WIDTH	32
#define ATTRIB_POINT_SIZE	64
#define ATTRIB_BACKFACE_CULL	128
#define ATTRIB_SHADOW           256        /*Set bit if no shadow is needed*/ 
#define ATTRIB_SHOW_NORMALS     512        /*Set bit if draw normals. */ 
#define ATTRIB_DIFFUSE_COLOR	1024
#define ATTRIB_SPECULAR_COLOR	2048
#define ATTRIB_AMBIENT_COLOR	4096
#define ATTRIB_EMISSIVE_COLOR	8192
#define ATTRIB_EXPONENT  	16384

/* Mask accessors/modifiers */
#define ATTRIB_GET_MASK(attrib, mask) (attrib->masks & mask)
#define ATTRIB_SET_MASK(attrib, mask) attrib->masks = (attrib->masks | mask)
#define ATTRIB_UNSET_MASK(attrib, mask) attrib->masks = (attrib->masks & ~mask)
#define ATTRIB_CLEAR_MASK(attrib, mask) attrib->masks = (attrib->masks & ~mask)
#define ATTRIB_TOGGLE_MASK(attrib, mask) if (attrib->masks & mask) attrib->masks = (attrib->masks & ~mask); else attrib->masks = (attrib->masks | mask)

/* Methods */
Attrib *attribNew();
Attrib *attribCreate();
void attribCopy(Attrib *dest, Attrib *src);
void attribPush();
void attribPop();
void attribPrint(FILE *fp, int indent, Attrib *attrib);
void attribDestroy(Attrib *attrib);

#endif

 /* End of attrib.h */
  

