#pragma ident "@(#)ogl_cg_ex1.c	1.12 99/04/05   SMI"
/*
 *   ----------------------------------------------------------------- 
 *          Copyright (C) 1997  Sun Microsystems, Inc
 *                      All rights reserved. 
 *            Notice of copyright on this source code 
 *            product does not indicate publication. 
 *   
 *                    RESTRICTED RIGHTS LEGEND: 
 *   Use, duplication, or disclosure by the Government is subject 
 *   to restrictions as set forth in subparagraph (c)(1)(ii) of 
 *   the Rights in Technical Data and Computer Software clause at 
 *   DFARS 52.227-7013 and in similar clauses in the FAR and NASA 
 *   FAR Supplement. 
 *   ----------------------------------------------------------------- 
 */

/*
 * Simple example program that demonstrates the use of the
 * glDrawCompressedGeomSUNX extension.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <GL/glx.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "../libcg/cgp.h"

static Bool verbose = False;

static void createCompressedGeometryBuffer();
static void renderRegularGeometry();
static void drawGL(int);
static Window createWindow(Display *dpy, int screen, XVisualInfo *vi);
static XVisualInfo * findVisual(Display *dpy, int screen, Bool *doubleBuffered);


Bool	doDirect = True;
int width = 500;
int height = 500;

Bool hasExtension = False;

CGviewport viewport;
CGubyte*   compressedBuffer;
CGint      bufferSize;

static GLboolean
checkExtension(char *extName, const char *extString)
{
    char *p = (char*) extString;
    int  extNameLen = (int) strlen(extName);
    char *end = p + (int) strlen(p);

    while (p < end) {
	int n = strcspn(p, " ");
	if ((extNameLen == n) && (strncmp(extName, p, n) == 0)) {
	    return GL_TRUE;
	}
	p += n + 1;
    }
    return GL_FALSE;
}

int
main(int argc)
{
	Display *dpy;
	int	screen;
	Window	window;
	int	dummy;
	int	done = False;
	Bool	doubleBuffered;
	XVisualInfo *vi;
	GLXContext context;
	Window  overlay;
	GC	gc;
	char	*extstr;
        char    *hwString = NULL;
	int    toggle;

	GLfloat mat_ambient[] = { 0.2, 0.2, 0.2, 1.0 };
	GLfloat light_position[] = { 0.0, 10.0, 10.0, 0.0 };
	GLfloat light_diffuse[] = {1.0, 1.0, 1.0, 1.0 };
	GLfloat light_ambient[] = {0.1, 0.1, 0.1, 1.0 };

	if (argc > 1) 
	    doDirect = False;
	dpy = XOpenDisplay(NULL);
	if (dpy == NULL) {
	    fprintf(stderr, "can't open X display\n");
	    return (1);
	}
	screen = DefaultScreen(dpy);

	if (!glXQueryExtension(dpy, &dummy, &dummy)) {
	    fprintf(stderr, "server doesn't support GLX Extension\n");
	    return (1);
	}

	vi = findVisual(dpy, screen, &doubleBuffered);
	if (vi == NULL)
	    return 1;

	window = createWindow(dpy, screen, vi);

	context = glXCreateContext(dpy, vi, NULL, doDirect);
	doDirect = glXIsDirect(dpy, context);

	if (context == NULL) {
	    fprintf(stderr, "can't create context\n");
	    return (1);
	}

	XFree(vi);

	if (!glXMakeCurrent(dpy, window, context)) {
	    fprintf(stderr, "glXMakeCurrent failed\n");
	    return (1);
	}

       extstr = (char *) glGetString(GL_EXTENSIONS);
        if (extstr != NULL) {
            hasExtension = checkExtension("GL_SUNX_geometry_compression",
                extstr);
            if (!hasExtension) {
                fprintf(stderr, "GL_SUNX_geometry_compression extension not supported\n");
                (void) exit(1);
            }

            hwString = (char*)glGetString(GL_COMPRESSED_GEOM_ACCELERATED_SUNX);
            if (strcmp(hwString, " ") == 0)
                hwString = "not available";

            fprintf(stderr,
                    "GL_SUNX_geometry_compression extension supported:\n");
            fprintf(stderr,
		    "\tSoftware Version Supported: %s\n\tHardware Version Supported: %s\n",
		    glGetString(GL_COMPRESSED_GEOM_VERSION_SUNX), hwString);

            hasExtension = checkExtension("GL_EXT_rescale_normal", extstr);
            if (!hasExtension) {
                fprintf(stderr, "GL_EXT_rescale_normal extension no supported using GL_NORMALIZE\n");
                glEnable(GL_NORMALIZE);
            }
            else
            {
                fprintf(stderr, "GL_EXT_rescale_normal supported\n");
               glEnable(GL_RESCALE_NORMAL_EXT);
            }
        }
        if (verbose) {

            printf("GLX Client Strings\n");
            printf("\tVendor: %s\n\tVersion: %s\n\tExtensions: %s\n\n",
                    glXGetClientString(dpy, GLX_VENDOR),
                    glXGetClientString(dpy, GLX_VERSION),
                    glXGetClientString(dpy, GLX_EXTENSIONS));

            printf("GLX Server Strings\n");
            printf("\tVendor: %s\n\tVersion: %s\n\tExtensions: %s\n\n",
                    glXQueryServerString(dpy, screen, GLX_VENDOR),
                    glXQueryServerString(dpy, screen, GLX_VERSION),
                    glXQueryServerString(dpy, screen, GLX_EXTENSIONS));

            if (extstr == NULL)
                extstr = "None";

            printf("GL Extension String: %s\n\n",  extstr);
        }

	if (verbose) {
	    printf("\nGL Strings:\n");
	    printf("\tVendor: %s\n\tRenderer: %s\n\tVersion: %s\n\tExtensions: %s\n\n",
			glGetString(GL_VENDOR),
			glGetString(GL_RENDERER),
			glGetString(GL_VERSION),
			glGetString(GL_EXTENSIONS));
	}

	glClearColor(0.0, 0, 0, 0);
	glMatrixMode(GL_PROJECTION);
	gluPerspective( /* field of view in degree */ 40.0,  /* aspect 
			   ratio 
			   */ 1.0,
			/* Z near */ 1.0, /* Z far */ 40.0);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();

	glTranslatef(0.0, 0.0, -5.0);
	/*        glRotatef(5.0, -1.0, 1.0, 0.0);
	 */

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, mat_ambient);

        /* just have one simple light */
	glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
	glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);

	glEnable(GL_DEPTH_TEST);

        glFrontFace(GL_CCW);
        glCullFace(GL_BACK); 
        glEnable(GL_CULL_FACE); 

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0); 

        
	if (argc > 1) {
	    glDrawBuffer(GL_FRONT);
	    doubleBuffered = False;
	}

        /* rotate to an interesting angle */
	/*        glRotatef(50.0, -1.0, 1.0, 0.0);
	 */

        /* go create the compressed geometry buffer */
	createCompressedGeometryBuffer();

	toggle = 1;
        fprintf(stderr, "Drawing Regular Geometry\n");

	while(!done) {
	    XEvent	report;
	    glXWaitGL();

            if (XPending(dpy)){
	        XNextEvent(dpy, &report);
	        switch (report.type) {
	        case ConfigureNotify:
		    width = report.xconfigure.width;
		    height = report.xconfigure.height;
		    glViewport(0, 0, width, height);
		    break;
                case ButtonRelease:
                    toggle = -toggle;
                    if (toggle == 1)
                        fprintf(stderr, "Drawing Regular Geometry\n");
                    else
                       fprintf(stderr, "Drawing Compressed Geometry\n");
                    drawGL(toggle);
                    if (doubleBuffered)
                        glXSwapBuffers(dpy, window);
                    else
                        glFlush();
                    break;
	        case Expose:
                    drawGL(toggle);
                    if (doubleBuffered)
                        glXSwapBuffers(dpy, window);
                    else
                        glFlush();
		    break;
	        case ClientMessage:
		    done = True;
		    break;
	        default:
		    break;
	        }
            }
            else {
                drawGL(toggle);
                if (doubleBuffered)
                    glXSwapBuffers(dpy, window);
                else
                    glFlush();
            }
	}

	glXDestroyContext(dpy, context);
	XSync(dpy, 0);
	return (0);
}

static void
drawGL(int toggle)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        glRotatef(5.0, -1.0, 1.0, 0.0);

	if (toggle == 1)
        {
	  renderRegularGeometry();
        }
        else
	{
	  glPushMatrix();
	  glTranslatef(viewport.xo, viewport.yo, viewport.zo);
	  glScalef(viewport.scale, viewport.scale, viewport.scale); 
	  glDrawCompressedGeomSUNX(bufferSize, compressedBuffer);
	  glPopMatrix(); 
	}

	glFlush();
}

static XVisualInfo *
findVisual(Display *dpy, int screen, Bool *doubleBuffered)
{
	/*
	 * Find a GLX Visual to use.
	 *   Order of preference
	 *       24 bit mono double buffered
	 *       24 bit stereo double buffered
	 *       24 bit single buffered
	 *       any depth double buffered
	 *       any depth single buffered
	 */
    int dblBuf24[] = { GLX_RGBA, GLX_DOUBLEBUFFER,
		    GLX_RED_SIZE, 8, GLX_GREEN_SIZE, 8, GLX_BLUE_SIZE, 8, None };
    int dblStereo24[] = { GLX_RGBA, GLX_DOUBLEBUFFER, GLX_STEREO, 
		    GLX_RED_SIZE, 8, GLX_GREEN_SIZE, 8, GLX_BLUE_SIZE, 8, None };
    int snglBuf24[] = { GLX_RGBA, 
		    GLX_RED_SIZE, 8, GLX_GREEN_SIZE, 8, GLX_BLUE_SIZE, 8, None };
    int dblBuf[] = { GLX_RGBA, GLX_DOUBLEBUFFER, None };
    int snglBuf[] = { GLX_RGBA, None };

    XVisualInfo *vi = NULL;
    int stereo = False;

    vi = glXChooseVisual(dpy, screen, dblBuf24);
    if (vi != NULL) {
	*doubleBuffered = True;
    } else {
      vi = glXChooseVisual(dpy, screen, dblStereo24);
      if (vi !=NULL) {
	  *doubleBuffered = True;
	  stereo = True;
      } else {
	vi = glXChooseVisual(dpy, screen, snglBuf24);
	if (vi !=NULL) {
	    *doubleBuffered = False;
	} else {
	    vi = glXChooseVisual(dpy, screen, dblBuf);
	    if (vi != NULL) {
		*doubleBuffered = True;
	    } else {
		vi = glXChooseVisual(dpy, screen, snglBuf);
		if (vi ==NULL) {
		    fprintf(stderr, "can't find visual\n");
		} else {
		    *doubleBuffered = False;
		}
	    }
	}
      }
    }

    if ((vi != NULL) && verbose) {
	int buffer_size;
	Bool db;
	int zbs;
	double gamma;

	(void) XSolarisGetVisualGamma(dpy, screen, vi->visual, &gamma);
	
	glXGetConfig(dpy, vi, GLX_BUFFER_SIZE, &buffer_size);
	glXGetConfig(dpy, vi, GLX_DOUBLEBUFFER, &db);
	glXGetConfig(dpy, vi, GLX_DEPTH_SIZE, &zbs);
	fprintf(stderr, 
	    "Using Visual %d, Buffer Size=%d, %sbuffered, Depth Buffer Size=%d\n\tGamma=%f\n",
	    vi->visualid, 
	    buffer_size, 
	    db ? "Double-" : "Single-",
	    zbs,
	    gamma);

    }	

    return vi;
}


static Window
createWindow(Display *dpy, int screen, XVisualInfo *vi)
{
	XSetWindowAttributes attributes;
	unsigned long valuemask = 0;
	Window root = RootWindow(dpy, screen);
	Atom	delete_window_atom=XInternAtom(dpy, "WM_DELETE_WINDOW", 0);
	Window  window;

	if (vi->visual != DefaultVisual(dpy, screen)) {
	    attributes.colormap = XCreateColormap(dpy, root, 
				vi->visual, AllocNone);
	    valuemask = CWColormap;
	}

	valuemask |= CWBorderPixel | CWBackPixel;
	attributes.border_pixel = 0;
	attributes.background_pixel = 0;
	window = XCreateWindow(dpy, root, 0, 0, 500, 500, 0, 
			vi->depth, CopyFromParent, vi->visual,
			valuemask, &attributes);

	XSelectInput(dpy, window,
		ExposureMask|StructureNotifyMask|ButtonReleaseMask|
		ButtonPressMask); 

	XMapWindow(dpy, window);

	XSetWMProtocols(dpy, window, &delete_window_atom, 1);
	XStoreName(dpy, window, "GL_SUNX_geometry_compression Example");

	return window;
}

static void
renderRegularGeometry()
{
glBegin(GL_QUADS);
 glNormal3f(-0.812500, 0.438965, 0.383789);
 glVertex3f(-1.299628, 0.521891, 0.019546);
 glNormal3f(-0.780273, 0.438965, -0.446289);
 glVertex3f(-1.298971, 0.521891, 0.013635);
 glNormal3f(-0.646973, 0.687500, -0.330078);
 glVertex3f(-1.298314, 0.507442, 0.013635);
 glNormal3f(-0.662598, 0.701172, 0.263184);
 glVertex3f(-1.298314, 0.507442, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.048340, 0.514160, 0.855957);
 glVertex3f(-1.292403, 0.522548, 0.024144);
 glNormal3f(-0.812500, 0.438965, 0.383789);
 glVertex3f(-1.299628, 0.521891, 0.019546);
 glNormal3f(-0.662598, 0.701172, 0.263184);
 glVertex3f(-1.298314, 0.507442, 0.019546);
 glNormal3f(-0.076172, 0.773926, 0.628418);
 glVertex3f(-1.291746, 0.509412, 0.024144);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.716309, 0.564453, 0.409668);
 glVertex3f(-1.285835, 0.522548, 0.019546);
 glNormal3f(-0.048340, 0.514160, 0.855957);
 glVertex3f(-1.292403, 0.522548, 0.024144);
 glNormal3f(-0.076172, 0.773926, 0.628418);
 glVertex3f(-1.291746, 0.509412, 0.024144);
 glNormal3f(0.525879, 0.793945, 0.303223);
 glVertex3f(-1.284521, 0.510069, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.696777, 0.569336, -0.436035);
 glVertex3f(-1.285835, 0.522548, 0.013635);
 glNormal3f(0.716309, 0.564453, 0.409668);
 glVertex3f(-1.285835, 0.522548, 0.019546);
 glNormal3f(0.525879, 0.793945, 0.303223);
 glVertex3f(-1.284521, 0.510069, 0.019546);
 glNormal3f(0.511719, 0.790527, -0.336426);
 glVertex3f(-1.284521, 0.510069, 0.013635);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.056641, 0.502930, -0.862793);
 glVertex3f(-1.292403, 0.522548, 0.009694);
 glNormal3f(0.696777, 0.569336, -0.436035);
 glVertex3f(-1.285835, 0.522548, 0.013635);
 glNormal3f(0.511719, 0.790527, -0.336426);
 glVertex3f(-1.284521, 0.510069, 0.013635);
 glNormal3f(-0.087402, 0.754395, -0.650391);
 glVertex3f(-1.291746, 0.509412, 0.009694);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.780273, 0.438965, -0.446289);
 glVertex3f(-1.298971, 0.521891, 0.013635);
 glNormal3f(-0.056641, 0.502930, -0.862793);
 glVertex3f(-1.292403, 0.522548, 0.009694);
 glNormal3f(-0.087402, 0.754395, -0.650391);
 glVertex3f(-1.291746, 0.509412, 0.009694);
 glNormal3f(-0.646973, 0.687500, -0.330078);
 glVertex3f(-1.298314, 0.507442, 0.013635);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.401367, 0.864258, 0.302734);
 glVertex3f(-1.306196, 0.507442, 0.005096);
 glNormal3f(-0.646973, 0.687500, -0.330078);
 glVertex3f(-1.298314, 0.507442, 0.013635);
 glNormal3f(-0.087402, 0.754395, -0.650391);
 glVertex3f(-1.291746, 0.509412, 0.009694);
 glNormal3f(-0.096680, 0.887695, 0.449219);
 glVertex3f(-1.291746, 0.509412, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.662598, 0.701172, 0.263184);
 glVertex3f(-1.298314, 0.507442, 0.019546);
 glNormal3f(-0.463867, 0.878418, 0.114258);
 glVertex3f(-1.315391, 0.507442, 0.028085);
 glNormal3f(-0.098145, 0.991211, -0.085938);
 glVertex3f(-1.291746, 0.509412, 0.030055);
 glNormal3f(-0.076172, 0.773926, 0.628418);
 glVertex3f(-1.291746, 0.509412, 0.024144);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.655762, 0.723633, -0.214844);
 glVertex3f(-1.267444, 0.511382, -0.015921);
 glNormal3f(0.654297, 0.726562, -0.208984);
 glVertex3f(-1.276640, 0.510069, -0.015921);
 glNormal3f(0.226562, 0.929688, 0.289551);
 glVertex3f(-1.276640, 0.510069, 0.005096);
 glNormal3f(0.288574, 0.950195, 0.112793);
 glVertex3f(-1.267444, 0.511382, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.662598, 0.701172, 0.263184);
 glVertex3f(-1.298314, 0.507442, 0.019546);
 glNormal3f(-0.646973, 0.687500, -0.330078);
 glVertex3f(-1.298314, 0.507442, 0.013635);
 glNormal3f(-0.401367, 0.864258, 0.302734);
 glVertex3f(-1.306196, 0.507442, 0.005096);
 glNormal3f(-0.463867, 0.878418, 0.114258);
 glVertex3f(-1.315391, 0.507442, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.288574, 0.950195, 0.112793);
 glVertex3f(-1.267444, 0.511382, 0.028741);
 glNormal3f(0.525879, 0.793945, 0.303223);
 glVertex3f(-1.284521, 0.510069, 0.019546);
 glNormal3f(-0.076172, 0.773926, 0.628418);
 glVertex3f(-1.291746, 0.509412, 0.024144);
 glNormal3f(-0.098145, 0.991211, -0.085938);
 glVertex3f(-1.291746, 0.509412, 0.030055);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.716309, 0.564453, 0.409668);
 glVertex3f(-1.285835, 0.522548, 0.019546);
 glNormal3f(0.696777, 0.569336, -0.436035);
 glVertex3f(-1.285835, 0.522548, 0.013635);
 glNormal3f(-0.056641, 0.502930, -0.862793);
 glVertex3f(-1.292403, 0.522548, 0.009694);
 glNormal3f(-0.780273, 0.438965, -0.446289);
 glVertex3f(-1.298971, 0.521891, 0.013635);
 glNormal3f(-0.812500, 0.438965, 0.383789);
 glVertex3f(-1.299628, 0.521891, 0.019546);
 glNormal3f(-0.048340, 0.514160, 0.855957);
 glVertex3f(-1.292403, 0.522548, 0.024144);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.520996, 0.630859, 0.574219);
 glVertex3f(-1.277296, 0.517294, 0.005096);
 glNormal3f(0.226562, 0.929688, 0.289551);
 glVertex3f(-1.276640, 0.510069, 0.005096);
 glNormal3f(0.654297, 0.726562, -0.208984);
 glVertex3f(-1.276640, 0.510069, -0.015921);
 glNormal3f(0.641602, 0.753418, -0.140137);
 glVertex3f(-1.277296, 0.517294, -0.029714);
 glNormal3f(0.636719, 0.770996, -0.008789);
 glVertex3f(-1.277296, 0.517294, -0.015921);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.379883, 0.434082, 0.816406);
 glVertex3f(-1.306196, 0.502844, 0.051073);
 glNormal3f(-0.133301, 0.455078, 0.879883);
 glVertex3f(-1.296344, 0.503501, 0.053700);
 glNormal3f(-0.043457, 0.728516, 0.683105);
 glVertex3f(-1.291089, 0.503501, 0.053700);
 glNormal3f(0.095215, 0.183105, 0.978027);
 glVertex3f(-1.291089, 0.503501, 0.030055);
 glNormal3f(-0.794434, 0.478027, 0.374512);
 glVertex3f(-1.315391, 0.501530, 0.028085);
 glNormal3f(-0.344238, 0.708984, 0.615234);
 glVertex3f(-1.323273, 0.501530, 0.039250);
 glNormal3f(-0.542969, 0.414062, 0.730469);
 glVertex3f(-1.314734, 0.501530, 0.045818);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.198242, 0.474609, -0.857422);
 glVertex3f(-1.281894, 0.499560, -0.074377);
 glNormal3f(0.615723, 0.515625, -0.595703);
 glVertex3f(-1.272042, 0.499560, -0.068465);
 glNormal3f(0.699219, -0.402832, -0.590820);
 glVertex3f(-1.271385, 0.491678, -0.068465);
 glNormal3f(0.278809, -0.438477, -0.854492);
 glVertex3f(-1.281237, 0.491678, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.035156, 0.441895, -0.896484);
 glVertex3f(-1.290432, 0.498246, -0.074377);
 glNormal3f(0.198242, 0.474609, -0.857422);
 glVertex3f(-1.281894, 0.499560, -0.074377);
 glNormal3f(0.278809, -0.438477, -0.854492);
 glVertex3f(-1.281237, 0.491678, -0.074377);
 glNormal3f(0.041016, -0.445312, -0.894531);
 glVertex3f(-1.289776, 0.491022, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.050293, 0.461914, 0.885254);
 glVertex3f(-1.285835, 0.504814, 0.053700);
 glNormal3f(-0.043457, 0.728516, 0.683105);
 glVertex3f(-1.291089, 0.503501, 0.053700);
 glNormal3f(0.028320, -0.425781, 0.904297);
 glVertex3f(-1.289776, 0.491022, 0.053700);
 glNormal3f(0.115723, -0.421387, 0.899414);
 glVertex3f(-1.284521, 0.491678, 0.053700);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.314941, 0.482422, 0.816895);
 glVertex3f(-1.275983, 0.505471, 0.051729);
 glNormal3f(0.050293, 0.461914, 0.885254);
 glVertex3f(-1.285835, 0.504814, 0.053700);
 glNormal3f(0.115723, -0.421387, 0.899414);
 glVertex3f(-1.284521, 0.491678, 0.053700);
 glNormal3f(0.364746, -0.414062, 0.833496);
 glVertex3f(-1.275326, 0.491678, 0.051729);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.469727, 0.486328, 0.736328);
 glVertex3f(-1.267444, 0.505471, 0.045818);
 glNormal3f(0.314941, 0.482422, 0.816895);
 glVertex3f(-1.275983, 0.505471, 0.051729);
 glNormal3f(0.364746, -0.414062, 0.833496);
 glVertex3f(-1.275326, 0.491678, 0.051729);
 glNormal3f(0.511719, -0.398438, 0.760742);
 glVertex3f(-1.266788, 0.492992, 0.045818);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.199219, 0.740723, 0.641113);
 glVertex3f(-1.258906, 0.506785, 0.039907);
 glNormal3f(0.469727, 0.486328, 0.736328);
 glVertex3f(-1.267444, 0.505471, 0.045818);
 glNormal3f(0.511719, -0.398438, 0.760742);
 glVertex3f(-1.266788, 0.492992, 0.045818);
 glNormal3f(0.320312, -0.669434, 0.670410);
 glVertex3f(-1.257592, 0.492992, 0.039907);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.141113, 0.462891, 0.874512);
 glVertex3f(-1.246427, 0.507442, 0.037280);
 glNormal3f(0.199219, 0.740723, 0.641113);
 glVertex3f(-1.258906, 0.506785, 0.039907);
 glNormal3f(0.320312, -0.669434, 0.670410);
 glVertex3f(-1.257592, 0.492992, 0.039907);
 glNormal3f(0.235352, -0.423828, 0.874512);
 glVertex3f(-1.245113, 0.494962, 0.037280);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.355957, 0.497070, 0.791016);
 glVertex3f(-1.237888, 0.507442, 0.035309);
 glNormal3f(0.141113, 0.462891, 0.874512);
 glVertex3f(-1.246427, 0.507442, 0.037280);
 glNormal3f(0.235352, -0.423828, 0.874512);
 glVertex3f(-1.245113, 0.494962, 0.037280);
 glNormal3f(0.452148, -0.414062, 0.790039);
 glVertex3f(-1.236575, 0.494962, 0.035309);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.745605, 0.559082, 0.361816);
 glVertex3f(-1.230663, 0.509412, 0.028741);
 glNormal3f(0.355957, 0.497070, 0.791016);
 glVertex3f(-1.237888, 0.507442, 0.035309);
 glNormal3f(0.452148, -0.414062, 0.790039);
 glVertex3f(-1.236575, 0.494962, 0.035309);
 glNormal3f(0.843262, -0.397461, 0.361328);
 glVertex3f(-1.229350, 0.496276, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.810059, 0.542969, -0.220215);
 glVertex3f(-1.230663, 0.509412, 0.019546);
 glNormal3f(0.745605, 0.559082, 0.361816);
 glVertex3f(-1.230663, 0.509412, 0.028741);
 glNormal3f(0.843262, -0.397461, 0.361328);
 glVertex3f(-1.229350, 0.496276, 0.028741);
 glNormal3f(0.901855, -0.373047, -0.217285);
 glVertex3f(-1.229350, 0.496276, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.607910, 0.521484, -0.598633);
 glVertex3f(-1.234604, 0.509412, 0.012321);
 glNormal3f(0.810059, 0.542969, -0.220215);
 glVertex3f(-1.230663, 0.509412, 0.019546);
 glNormal3f(0.901855, -0.373047, -0.217285);
 glVertex3f(-1.229350, 0.496276, 0.019546);
 glNormal3f(0.702637, -0.391602, -0.594238);
 glVertex3f(-1.233291, 0.494962, 0.012321);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.209473, 0.489258, -0.846680);
 glVertex3f(-1.243143, 0.507442, 0.006410);
 glNormal3f(0.607910, 0.521484, -0.598633);
 glVertex3f(-1.234604, 0.509412, 0.012321);
 glNormal3f(0.702637, -0.391602, -0.594238);
 glVertex3f(-1.233291, 0.494962, 0.012321);
 glNormal3f(0.349121, -0.933105, 0.085938);
 glVertex3f(-1.241829, 0.494962, 0.006410);
 glNormal3f(0.466797, 0.698730, -0.541992);
 glVertex3f(-1.242486, 0.502844, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.430664, 0.500488, 0.750488);
 glVertex3f(-1.237231, 0.503501, 0.005096);
 glNormal3f(0.466797, 0.698730, -0.541992);
 glVertex3f(-1.242486, 0.502844, 0.006410);
 glNormal3f(0.349121, -0.933105, 0.085938);
 glVertex3f(-1.241829, 0.494962, 0.006410);
 glNormal3f(0.524414, -0.420410, 0.740234);
 glVertex3f(-1.236575, 0.494962, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.779297, 0.533203, 0.328125);
 glVertex3f(-1.231977, 0.503501, -0.001472);
 glNormal3f(0.430664, 0.500488, 0.750488);
 glVertex3f(-1.237231, 0.503501, 0.005096);
 glNormal3f(0.524414, -0.420410, 0.740234);
 glVertex3f(-1.236575, 0.494962, 0.005096);
 glNormal3f(0.866699, -0.385254, 0.316406);
 glVertex3f(-1.231320, 0.496276, -0.001472);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.820801, 0.537109, -0.193848);
 glVertex3f(-1.231320, 0.503501, -0.012637);
 glNormal3f(0.779297, 0.533203, 0.328125);
 glVertex3f(-1.231977, 0.503501, -0.001472);
 glNormal3f(0.866699, -0.385254, 0.316406);
 glVertex3f(-1.231320, 0.496276, -0.001472);
 glNormal3f(0.902832, -0.379883, -0.200195);
 glVertex3f(-1.230663, 0.496276, -0.012637);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.622559, 0.512207, -0.591309);
 glVertex3f(-1.236575, 0.503501, -0.021832);
 glNormal3f(0.820801, 0.537109, -0.193848);
 glVertex3f(-1.231320, 0.503501, -0.012637);
 glNormal3f(0.902832, -0.379883, -0.200195);
 glVertex3f(-1.230663, 0.496276, -0.012637);
 glNormal3f(0.704590, -0.393555, -0.590332);
 glVertex3f(-1.235918, 0.494962, -0.021832);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.450195, 0.497559, -0.741699);
 glVertex3f(-1.248397, 0.501530, -0.030371);
 glNormal3f(0.622559, 0.512207, -0.591309);
 glVertex3f(-1.236575, 0.503501, -0.021832);
 glNormal3f(0.704590, -0.393555, -0.590332);
 glVertex3f(-1.235918, 0.494962, -0.021832);
 glNormal3f(0.538086, -0.394043, -0.745117);
 glVertex3f(-1.247740, 0.494306, -0.030371);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.394531, 0.770508, -0.500000);
 glVertex3f(-1.260876, 0.501530, -0.037596);
 glNormal3f(0.450195, 0.497559, -0.741699);
 glVertex3f(-1.248397, 0.501530, -0.030371);
 glNormal3f(0.538086, -0.394043, -0.745117);
 glVertex3f(-1.247740, 0.494306, -0.030371);
 glNormal3f(0.444824, -0.809570, -0.383301);
 glVertex3f(-1.259563, 0.492992, -0.037596);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.557617, 0.782227, -0.276855);
 glVertex3f(-1.266788, 0.500874, -0.046791);
 glNormal3f(0.394531, 0.770508, -0.500000);
 glVertex3f(-1.260876, 0.501530, -0.037596);
 glNormal3f(0.444824, -0.809570, -0.383301);
 glVertex3f(-1.259563, 0.492992, -0.037596);
 glNormal3f(0.705566, -0.657227, -0.265137);
 glVertex3f(-1.266131, 0.492992, -0.046791);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.600098, 0.765625, -0.230957);
 glVertex3f(-1.268758, 0.499560, -0.061241);
 glNormal3f(0.557617, 0.782227, -0.276855);
 glVertex3f(-1.266788, 0.500874, -0.046791);
 glNormal3f(0.705566, -0.657227, -0.265137);
 glVertex3f(-1.266131, 0.492992, -0.046791);
 glNormal3f(0.894043, -0.371094, -0.251465);
 glVertex3f(-1.268101, 0.492992, -0.061241);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.615723, 0.515625, -0.595703);
 glVertex3f(-1.272042, 0.499560, -0.068465);
 glNormal3f(0.600098, 0.765625, -0.230957);
 glVertex3f(-1.268758, 0.499560, -0.061241);
 glNormal3f(0.894043, -0.371094, -0.251465);
 glVertex3f(-1.268101, 0.492992, -0.061241);
 glNormal3f(0.699219, -0.402832, -0.590820);
 glVertex3f(-1.271385, 0.491678, -0.068465);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.394531, 0.770508, -0.500000);
 glVertex3f(-1.260876, 0.501530, -0.037596);
 glNormal3f(0.258789, 0.930664, -0.257812);
 glVertex3f(-1.266131, 0.500874, -0.027087);
 glNormal3f(0.532227, 0.624512, -0.571289);
 glVertex3f(-1.266788, 0.500874, 0.006410);
 glNormal3f(0.466797, 0.698730, -0.541992);
 glVertex3f(-1.242486, 0.502844, 0.006410);
 glNormal3f(0.430664, 0.500488, 0.750488);
 glVertex3f(-1.237231, 0.503501, 0.005096);
 glNormal3f(0.779297, 0.533203, 0.328125);
 glVertex3f(-1.231977, 0.503501, -0.001472);
 glNormal3f(0.820801, 0.537109, -0.193848);
 glVertex3f(-1.231320, 0.503501, -0.012637);
 glNormal3f(0.622559, 0.512207, -0.591309);
 glVertex3f(-1.236575, 0.503501, -0.021832);
 glNormal3f(0.450195, 0.497559, -0.741699);
 glVertex3f(-1.248397, 0.501530, -0.030371);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.557617, 0.782227, -0.276855);
 glVertex3f(-1.266788, 0.500874, -0.046791);
 glNormal3f(0.161133, 0.955078, -0.248535);
 glVertex3f(-1.275326, 0.499560, -0.050732);
 glNormal3f(0.404297, 0.835449, -0.372070);
 glVertex3f(-1.275326, 0.499560, -0.027744);
 glNormal3f(0.258789, 0.930664, -0.257812);
 glVertex3f(-1.266131, 0.500874, -0.027087);
 glNormal3f(0.394531, 0.770508, -0.500000);
 glVertex3f(-1.260876, 0.501530, -0.037596);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.600098, 0.765625, -0.230957);
 glVertex3f(-1.268758, 0.499560, -0.061241);
 glNormal3f(0.161133, 0.955078, -0.248535);
 glVertex3f(-1.275326, 0.499560, -0.050732);
 glNormal3f(0.557617, 0.782227, -0.276855);
 glVertex3f(-1.266788, 0.500874, -0.046791);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.355957, 0.497070, 0.791016);
 glVertex3f(-1.237888, 0.507442, 0.035309);
 glNormal3f(0.745605, 0.559082, 0.361816);
 glVertex3f(-1.230663, 0.509412, 0.028741);
 glNormal3f(0.810059, 0.542969, -0.220215);
 glVertex3f(-1.230663, 0.509412, 0.019546);
 glNormal3f(0.607910, 0.521484, -0.598633);
 glVertex3f(-1.234604, 0.509412, 0.012321);
 glNormal3f(0.209473, 0.489258, -0.846680);
 glVertex3f(-1.243143, 0.507442, 0.006410);
 glNormal3f(0.773438, 0.483887, -0.408691);
 glVertex3f(-1.266788, 0.505471, 0.006410);
 glNormal3f(0.683594, 0.582031, 0.439453);
 glVertex3f(-1.266788, 0.505471, 0.028741);
 glNormal3f(0.199219, 0.740723, 0.641113);
 glVertex3f(-1.258906, 0.506785, 0.039907);
 glNormal3f(0.141113, 0.462891, 0.874512);
 glVertex3f(-1.246427, 0.507442, 0.037280);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.209473, 0.489258, -0.846680);
 glVertex3f(-1.243143, 0.507442, 0.006410);
 glNormal3f(0.466797, 0.698730, -0.541992);
 glVertex3f(-1.242486, 0.502844, 0.006410);
 glNormal3f(0.532227, 0.624512, -0.571289);
 glVertex3f(-1.266788, 0.500874, 0.006410);
 glNormal3f(0.773438, 0.483887, -0.408691);
 glVertex3f(-1.266788, 0.505471, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.288574, 0.950195, 0.112793);
 glVertex3f(-1.267444, 0.511382, 0.028741);
 glNormal3f(0.226562, 0.929688, 0.289551);
 glVertex3f(-1.276640, 0.510069, 0.005096);
 glNormal3f(0.511719, 0.790527, -0.336426);
 glVertex3f(-1.284521, 0.510069, 0.013635);
 glNormal3f(0.525879, 0.793945, 0.303223);
 glVertex3f(-1.284521, 0.510069, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.288574, 0.950195, 0.112793);
 glVertex3f(-1.267444, 0.511382, 0.028741);
 glNormal3f(0.683594, 0.582031, 0.439453);
 glVertex3f(-1.266788, 0.505471, 0.028741);
 glNormal3f(0.773438, 0.483887, -0.408691);
 glVertex3f(-1.266788, 0.505471, 0.006410);
 glNormal3f(0.655762, 0.723633, -0.214844);
 glVertex3f(-1.267444, 0.511382, -0.015921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.669434, 0.574219, -0.470215);
 glVertex3f(-1.275983, 0.505471, -0.023146);
 glNormal3f(0.413086, 0.675781, -0.610352);
 glVertex3f(-1.266788, 0.505471, -0.023146);
 glNormal3f(0.258789, 0.930664, -0.257812);
 glVertex3f(-1.266131, 0.500874, -0.027087);
 glNormal3f(0.404297, 0.835449, -0.372070);
 glVertex3f(-1.275326, 0.499560, -0.027744);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.666992, 0.534668, -0.518555);
 glVertex3f(-1.275983, 0.507442, -0.045477);
 glNormal3f(0.669434, 0.574219, -0.470215);
 glVertex3f(-1.275983, 0.505471, -0.023146);
 glNormal3f(0.404297, 0.835449, -0.372070);
 glVertex3f(-1.275326, 0.499560, -0.027744);
 glNormal3f(0.161133, 0.955078, -0.248535);
 glVertex3f(-1.275326, 0.499560, -0.050732);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.011719, -0.285645, 0.958008);
 glVertex3f(-1.291746, 0.507442, 0.041877);
 glNormal3f(0.291016, 0.025879, 0.956055);
 glVertex3f(-1.283208, 0.509412, 0.041221);
 glNormal3f(0.143555, 0.833008, 0.533691);
 glVertex3f(-1.283864, 0.513353, 0.038593);
 glNormal3f(-0.114258, 0.959473, 0.255859);
 glVertex3f(-1.291746, 0.512039, 0.039250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.654297, 0.726562, -0.208984);
 glVertex3f(-1.276640, 0.510069, -0.015921);
 glNormal3f(0.655762, 0.723633, -0.214844);
 glVertex3f(-1.267444, 0.511382, -0.015921);
 glNormal3f(0.413086, 0.675781, -0.610352);
 glVertex3f(-1.266788, 0.505471, -0.023146);
 glNormal3f(0.669434, 0.574219, -0.470215);
 glVertex3f(-1.275983, 0.505471, -0.023146);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.532227, 0.624512, -0.571289);
 glVertex3f(-1.266788, 0.500874, 0.006410);
 glNormal3f(0.258789, 0.930664, -0.257812);
 glVertex3f(-1.266131, 0.500874, -0.027087);
 glNormal3f(0.413086, 0.675781, -0.610352);
 glVertex3f(-1.266788, 0.505471, -0.023146);
 glNormal3f(0.655762, 0.723633, -0.214844);
 glVertex3f(-1.267444, 0.511382, -0.015921);
 glNormal3f(0.773438, 0.483887, -0.408691);
 glVertex3f(-1.266788, 0.505471, 0.006410);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.669434, 0.574219, -0.470215);
 glVertex3f(-1.275983, 0.505471, -0.023146);
 glNormal3f(0.666992, 0.534668, -0.518555);
 glVertex3f(-1.275983, 0.507442, -0.045477);
 glNormal3f(0.373047, 0.809570, -0.452637);
 glVertex3f(-1.276640, 0.513353, -0.038909);
 glNormal3f(0.641602, 0.753418, -0.140137);
 glVertex3f(-1.277296, 0.517294, -0.029714);
 glNormal3f(0.654297, 0.726562, -0.208984);
 glVertex3f(-1.276640, 0.510069, -0.015921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.484375, -0.423828, 0.765137);
 glVertex3f(-1.272699, 0.506785, 0.034653);
 glNormal3f(0.085449, -0.927734, 0.363770);
 glVertex3f(-1.291089, 0.505471, 0.035966);
 glNormal3f(0.095215, 0.183105, 0.978027);
 glVertex3f(-1.291089, 0.503501, 0.030055);
 glNormal3f(0.683594, 0.582031, 0.439453);
 glVertex3f(-1.266788, 0.505471, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.334961, 0.891602, 0.302734);
 glVertex3f(-1.273356, 0.512039, 0.033339);
 glNormal3f(0.484375, -0.423828, 0.765137);
 glVertex3f(-1.272699, 0.506785, 0.034653);
 glNormal3f(0.683594, 0.582031, 0.439453);
 glVertex3f(-1.266788, 0.505471, 0.028741);
 glNormal3f(0.288574, 0.950195, 0.112793);
 glVertex3f(-1.267444, 0.511382, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.094238, 0.940430, -0.325684);
 glVertex3f(-1.291746, 0.510069, 0.034653);
 glNormal3f(0.334961, 0.891602, 0.302734);
 glVertex3f(-1.273356, 0.512039, 0.033339);
 glNormal3f(0.288574, 0.950195, 0.112793);
 glVertex3f(-1.267444, 0.511382, 0.028741);
 glNormal3f(-0.098145, 0.991211, -0.085938);
 glVertex3f(-1.291746, 0.509412, 0.030055);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.291016, 0.025879, 0.956055);
 glVertex3f(-1.283208, 0.509412, 0.041221);
 glNormal3f(0.011719, -0.285645, 0.958008);
 glVertex3f(-1.291746, 0.507442, 0.041877);
 glNormal3f(0.085449, -0.927734, 0.363770);
 glVertex3f(-1.291089, 0.505471, 0.035966);
 glNormal3f(0.484375, -0.423828, 0.765137);
 glVertex3f(-1.272699, 0.506785, 0.034653);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.143555, 0.833008, 0.533691);
 glVertex3f(-1.283864, 0.513353, 0.038593);
 glNormal3f(0.291016, 0.025879, 0.956055);
 glVertex3f(-1.283208, 0.509412, 0.041221);
 glNormal3f(0.484375, -0.423828, 0.765137);
 glVertex3f(-1.272699, 0.506785, 0.034653);
 glNormal3f(0.334961, 0.891602, 0.302734);
 glVertex3f(-1.273356, 0.512039, 0.033339);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.114258, 0.959473, 0.255859);
 glVertex3f(-1.291746, 0.512039, 0.039250);
 glNormal3f(0.143555, 0.833008, 0.533691);
 glVertex3f(-1.283864, 0.513353, 0.038593);
 glNormal3f(0.334961, 0.891602, 0.302734);
 glVertex3f(-1.273356, 0.512039, 0.033339);
 glNormal3f(-0.094238, 0.940430, -0.325684);
 glVertex3f(-1.291746, 0.510069, 0.034653);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.320312, -0.669434, 0.670410);
 glVertex3f(-1.257592, 0.492992, 0.039907);
 glNormal3f(0.349121, -0.933105, 0.085938);
 glVertex3f(-1.241829, 0.494962, 0.006410);
 glNormal3f(0.702637, -0.391602, -0.594238);
 glVertex3f(-1.233291, 0.494962, 0.012321);
 glNormal3f(0.901855, -0.373047, -0.217285);
 glVertex3f(-1.229350, 0.496276, 0.019546);
 glNormal3f(0.843262, -0.397461, 0.361328);
 glVertex3f(-1.229350, 0.496276, 0.028741);
 glNormal3f(0.452148, -0.414062, 0.790039);
 glVertex3f(-1.236575, 0.494962, 0.035309);
 glNormal3f(0.235352, -0.423828, 0.874512);
 glVertex3f(-1.245113, 0.494962, 0.037280);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.538086, -0.394043, -0.745117);
 glVertex3f(-1.247740, 0.494306, -0.030371);
 glNormal3f(0.704590, -0.393555, -0.590332);
 glVertex3f(-1.235918, 0.494962, -0.021832);
 glNormal3f(0.902832, -0.379883, -0.200195);
 glVertex3f(-1.230663, 0.496276, -0.012637);
 glNormal3f(0.866699, -0.385254, 0.316406);
 glVertex3f(-1.231320, 0.496276, -0.001472);
 glNormal3f(0.524414, -0.420410, 0.740234);
 glVertex3f(-1.236575, 0.494962, 0.005096);
 glNormal3f(0.349121, -0.933105, 0.085938);
 glVertex3f(-1.241829, 0.494962, 0.006410);
 glNormal3f(0.444824, -0.809570, -0.383301);
 glVertex3f(-1.259563, 0.492992, -0.037596);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.444824, -0.809570, -0.383301);
 glVertex3f(-1.259563, 0.492992, -0.037596);
 glNormal3f(0.085938, -0.996582, 0.009766);
 glVertex3f(-1.289776, 0.491022, -0.010010);
 glNormal3f(0.705566, -0.657227, -0.265137);
 glVertex3f(-1.266131, 0.492992, -0.046791);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.305176, -0.869629, -0.389160);
 glVertex3f(-1.319988, 0.487738, -0.038253);
 glNormal3f(-0.555664, -0.774902, -0.302246);
 glVertex3f(-1.313421, 0.489051, -0.046791);
 glNormal3f(0.085938, -0.996582, 0.009766);
 glVertex3f(-1.289776, 0.491022, -0.010010);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.364746, -0.414062, 0.833496);
 glVertex3f(-1.275326, 0.491678, 0.051729);
 glNormal3f(0.115723, -0.421387, 0.899414);
 glVertex3f(-1.284521, 0.491678, 0.053700);
 glNormal3f(0.028320, -0.425781, 0.904297);
 glVertex3f(-1.289776, 0.491022, 0.053700);
 glNormal3f(-0.082031, -0.438965, 0.894531);
 glVertex3f(-1.295030, 0.489708, 0.053700);
 glNormal3f(-0.307129, -0.461914, 0.832031);
 glVertex3f(-1.304882, 0.489708, 0.051073);
 glNormal3f(-0.455566, -0.475098, 0.752441);
 glVertex3f(-1.313421, 0.489051, 0.045818);
 glNormal3f(-0.233887, -0.713867, 0.660156);
 glVertex3f(-1.321959, 0.487738, 0.039250);
 glNormal3f(-0.207031, -0.974121, 0.095215);
 glVertex3f(-1.338379, 0.486424, 0.006410);
 glNormal3f(-0.305176, -0.869629, -0.389160);
 glVertex3f(-1.319988, 0.487738, -0.038253);
 glNormal3f(0.085938, -0.996582, 0.009766);
 glVertex3f(-1.289776, 0.491022, -0.010010);
 glNormal3f(0.444824, -0.809570, -0.383301);
 glVertex3f(-1.259563, 0.492992, -0.037596);
 glNormal3f(0.349121, -0.933105, 0.085938);
 glVertex3f(-1.241829, 0.494962, 0.006410);
 glNormal3f(0.320312, -0.669434, 0.670410);
 glVertex3f(-1.257592, 0.492992, 0.039907);
 glNormal3f(0.511719, -0.398438, 0.760742);
 glVertex3f(-1.266788, 0.492992, 0.045818);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.305176, -0.869629, -0.389160);
 glVertex3f(-1.319988, 0.487738, -0.038253);
 glNormal3f(-0.207031, -0.974121, 0.095215);
 glVertex3f(-1.338379, 0.486424, 0.006410);
 glNormal3f(-0.468262, -0.509277, 0.722168);
 glVertex3f(-1.343633, 0.486424, 0.005096);
 glNormal3f(-0.805664, -0.530762, 0.264648);
 glVertex3f(-1.348888, 0.485767, -0.002128);
 glNormal3f(-0.815430, -0.526855, -0.242188);
 glVertex3f(-1.348888, 0.485767, -0.013294);
 glNormal3f(-0.619629, -0.505371, -0.601562);
 glVertex3f(-1.343633, 0.486424, -0.021832);
 glNormal3f(-0.481445, -0.484863, -0.730469);
 glVertex3f(-1.331811, 0.486424, -0.030371);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.366211, -0.481934, 0.795898);
 glVertex3f(-1.342977, 0.486424, 0.034653);
 glNormal3f(-0.761230, -0.526855, 0.378906);
 glVertex3f(-1.350858, 0.485767, 0.028085);
 glNormal3f(-0.828613, -0.515137, -0.220703);
 glVertex3f(-1.350858, 0.485767, 0.019546);
 glNormal3f(-0.629883, -0.505371, -0.590332);
 glVertex3f(-1.346261, 0.485767, 0.012321);
 glNormal3f(-0.207031, -0.974121, 0.095215);
 glVertex3f(-1.338379, 0.486424, 0.006410);
 glNormal3f(-0.233887, -0.713867, 0.660156);
 glVertex3f(-1.321959, 0.487738, 0.039250);
 glNormal3f(-0.159668, -0.457520, 0.874512);
 glVertex3f(-1.334438, 0.486424, 0.036623);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.336426, 0.780762, 0.525879);
 glVertex3f(-1.299628, 0.512039, 0.038593);
 glNormal3f(-0.114258, 0.959473, 0.255859);
 glVertex3f(-1.291746, 0.512039, 0.039250);
 glNormal3f(-0.094238, 0.940430, -0.325684);
 glVertex3f(-1.291746, 0.510069, 0.034653);
 glNormal3f(-0.517578, 0.798340, 0.306641);
 glVertex3f(-1.310137, 0.507442, 0.033339);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.309082, -0.057129, 0.949219);
 glVertex3f(-1.299628, 0.507442, 0.041221);
 glNormal3f(-0.336426, 0.780762, 0.525879);
 glVertex3f(-1.299628, 0.512039, 0.038593);
 glNormal3f(-0.517578, 0.798340, 0.306641);
 glVertex3f(-1.310137, 0.507442, 0.033339);
 glNormal3f(-0.418945, -0.531250, 0.736816);
 glVertex3f(-1.309480, 0.503501, 0.034653);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.011719, -0.285645, 0.958008);
 glVertex3f(-1.291746, 0.507442, 0.041877);
 glNormal3f(-0.309082, -0.057129, 0.949219);
 glVertex3f(-1.299628, 0.507442, 0.041221);
 glNormal3f(-0.418945, -0.531250, 0.736816);
 glVertex3f(-1.309480, 0.503501, 0.034653);
 glNormal3f(0.085449, -0.927734, 0.363770);
 glVertex3f(-1.291089, 0.505471, 0.035966);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.517578, 0.798340, 0.306641);
 glVertex3f(-1.310137, 0.507442, 0.033339);
 glNormal3f(-0.094238, 0.940430, -0.325684);
 glVertex3f(-1.291746, 0.510069, 0.034653);
 glNormal3f(-0.098145, 0.991211, -0.085938);
 glVertex3f(-1.291746, 0.509412, 0.030055);
 glNormal3f(-0.463867, 0.878418, 0.114258);
 glVertex3f(-1.315391, 0.507442, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.418945, -0.531250, 0.736816);
 glVertex3f(-1.309480, 0.503501, 0.034653);
 glNormal3f(-0.517578, 0.798340, 0.306641);
 glVertex3f(-1.310137, 0.507442, 0.033339);
 glNormal3f(-0.463867, 0.878418, 0.114258);
 glVertex3f(-1.315391, 0.507442, 0.028085);
 glNormal3f(-0.794434, 0.478027, 0.374512);
 glVertex3f(-1.315391, 0.501530, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.085449, -0.927734, 0.363770);
 glVertex3f(-1.291089, 0.505471, 0.035966);
 glNormal3f(-0.418945, -0.531250, 0.736816);
 glVertex3f(-1.309480, 0.503501, 0.034653);
 glNormal3f(-0.794434, 0.478027, 0.374512);
 glVertex3f(-1.315391, 0.501530, 0.028085);
 glNormal3f(0.095215, 0.183105, 0.978027);
 glVertex3f(-1.291089, 0.503501, 0.030055);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.087402, 0.754395, -0.650391);
 glVertex3f(-1.291746, 0.509412, 0.009694);
 glNormal3f(0.511719, 0.790527, -0.336426);
 glVertex3f(-1.284521, 0.510069, 0.013635);
 glNormal3f(0.226562, 0.929688, 0.289551);
 glVertex3f(-1.276640, 0.510069, 0.005096);
 glNormal3f(-0.096680, 0.887695, 0.449219);
 glVertex3f(-1.291746, 0.509412, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.780273, 0.610840, -0.134766);
 glVertex3f(-1.306852, 0.514010, -0.029714);
 glNormal3f(0.641602, 0.753418, -0.140137);
 glVertex3f(-1.277296, 0.517294, -0.029714);
 glNormal3f(0.373047, 0.809570, -0.452637);
 glVertex3f(-1.276640, 0.513353, -0.038909);
 glNormal3f(-0.526367, 0.722656, -0.448242);
 glVertex3f(-1.306852, 0.510069, -0.038909);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.780273, 0.610840, -0.134766);
 glVertex3f(-1.306852, 0.514010, -0.029714);
 glNormal3f(-0.778809, 0.593262, -0.204590);
 glVertex3f(-1.306196, 0.507442, -0.015921);
 glNormal3f(-0.401367, 0.864258, 0.302734);
 glVertex3f(-1.306196, 0.507442, 0.005096);
 glNormal3f(-0.634766, 0.519043, 0.572754);
 glVertex3f(-1.306852, 0.514010, 0.005096);
 glNormal3f(-0.773926, 0.632812, -0.008789);
 glVertex3f(-1.306852, 0.514010, -0.015921);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.226562, 0.929688, 0.289551);
 glVertex3f(-1.276640, 0.510069, 0.005096);
 glNormal3f(0.520996, 0.630859, 0.574219);
 glVertex3f(-1.277296, 0.517294, 0.005096);
 glNormal3f(-0.634766, 0.519043, 0.572754);
 glVertex3f(-1.306852, 0.514010, 0.005096);
 glNormal3f(-0.401367, 0.864258, 0.302734);
 glVertex3f(-1.306196, 0.507442, 0.005096);
 glNormal3f(-0.096680, 0.887695, 0.449219);
 glVertex3f(-1.291746, 0.509412, 0.005096);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.641602, 0.753418, -0.140137);
 glVertex3f(-1.277296, 0.517294, -0.029714);
 glNormal3f(-0.780273, 0.610840, -0.134766);
 glVertex3f(-1.306852, 0.514010, -0.029714);
 glNormal3f(-0.773926, 0.632812, -0.008789);
 glVertex3f(-1.306852, 0.514010, -0.015921);
 glNormal3f(-0.634766, 0.519043, 0.572754);
 glVertex3f(-1.306852, 0.514010, 0.005096);
 glNormal3f(0.520996, 0.630859, 0.574219);
 glVertex3f(-1.277296, 0.517294, 0.005096);
 glNormal3f(0.636719, 0.770996, -0.008789);
 glVertex3f(-1.277296, 0.517294, -0.015921);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.427246, 0.860840, -0.275391);
 glVertex3f(-1.314734, 0.496276, -0.027744);
 glNormal3f(-0.634277, 0.518555, -0.573730);
 glVertex3f(-1.314734, 0.496276, 0.006410);
 glNormal3f(-0.835449, 0.361328, -0.414062);
 glVertex3f(-1.315391, 0.501530, 0.006410);
 glNormal3f(-0.760742, 0.613281, -0.212891);
 glVertex3f(-1.315391, 0.507442, -0.015921);
 glNormal3f(-0.497070, 0.600098, -0.626953);
 glVertex3f(-1.315391, 0.501530, -0.023146);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.526367, 0.722656, -0.448242);
 glVertex3f(-1.306852, 0.510069, -0.038909);
 glNormal3f(0.373047, 0.809570, -0.452637);
 glVertex3f(-1.276640, 0.513353, -0.038909);
 glNormal3f(0.666992, 0.534668, -0.518555);
 glVertex3f(-1.275983, 0.507442, -0.045477);
 glNormal3f(-0.754395, 0.399902, -0.520996);
 glVertex3f(-1.306196, 0.505471, -0.045477);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.778809, 0.593262, -0.204590);
 glVertex3f(-1.306196, 0.507442, -0.015921);
 glNormal3f(-0.780273, 0.610840, -0.134766);
 glVertex3f(-1.306852, 0.514010, -0.029714);
 glNormal3f(-0.526367, 0.722656, -0.448242);
 glVertex3f(-1.306852, 0.510069, -0.038909);
 glNormal3f(-0.754395, 0.399902, -0.520996);
 glVertex3f(-1.306196, 0.505471, -0.045477);
 glNormal3f(-0.752441, 0.444336, -0.486328);
 glVertex3f(-1.306196, 0.502844, -0.023146);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.760742, 0.613281, -0.212891);
 glVertex3f(-1.315391, 0.507442, -0.015921);
 glNormal3f(-0.778809, 0.593262, -0.204590);
 glVertex3f(-1.306196, 0.507442, -0.015921);
 glNormal3f(-0.752441, 0.444336, -0.486328);
 glVertex3f(-1.306196, 0.502844, -0.023146);
 glNormal3f(-0.497070, 0.600098, -0.626953);
 glVertex3f(-1.315391, 0.501530, -0.023146);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.309082, -0.057129, 0.949219);
 glVertex3f(-1.299628, 0.507442, 0.041221);
 glNormal3f(0.011719, -0.285645, 0.958008);
 glVertex3f(-1.291746, 0.507442, 0.041877);
 glNormal3f(-0.114258, 0.959473, 0.255859);
 glVertex3f(-1.291746, 0.512039, 0.039250);
 glNormal3f(-0.336426, 0.780762, 0.525879);
 glVertex3f(-1.299628, 0.512039, 0.038593);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.752441, 0.444336, -0.486328);
 glVertex3f(-1.306196, 0.502844, -0.023146);
 glNormal3f(-0.754395, 0.399902, -0.520996);
 glVertex3f(-1.306196, 0.505471, -0.045477);
 glNormal3f(-0.341309, 0.911621, -0.228516);
 glVertex3f(-1.305539, 0.496933, -0.050732);
 glNormal3f(-0.552246, 0.735352, -0.393066);
 glVertex3f(-1.305539, 0.496933, -0.027744);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.497070, 0.600098, -0.626953);
 glVertex3f(-1.315391, 0.501530, -0.023146);
 glNormal3f(-0.752441, 0.444336, -0.486328);
 glVertex3f(-1.306196, 0.502844, -0.023146);
 glNormal3f(-0.552246, 0.735352, -0.393066);
 glVertex3f(-1.305539, 0.496933, -0.027744);
 glNormal3f(-0.427246, 0.860840, -0.275391);
 glVertex3f(-1.314734, 0.496276, -0.027744);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.794434, 0.478027, 0.374512);
 glVertex3f(-1.315391, 0.501530, 0.028085);
 glNormal3f(-0.463867, 0.878418, 0.114258);
 glVertex3f(-1.315391, 0.507442, 0.028085);
 glNormal3f(-0.760742, 0.613281, -0.212891);
 glVertex3f(-1.315391, 0.507442, -0.015921);
 glNormal3f(-0.835449, 0.361328, -0.414062);
 glVertex3f(-1.315391, 0.501530, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.161133, 0.955078, -0.248535);
 glVertex3f(-1.275326, 0.499560, -0.050732);
 glNormal3f(-0.341309, 0.911621, -0.228516);
 glVertex3f(-1.305539, 0.496933, -0.050732);
 glNormal3f(-0.754395, 0.399902, -0.520996);
 glVertex3f(-1.306196, 0.505471, -0.045477);
 glNormal3f(0.666992, 0.534668, -0.518555);
 glVertex3f(-1.275983, 0.507442, -0.045477);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.778809, 0.593262, -0.204590);
 glVertex3f(-1.306196, 0.507442, -0.015921);
 glNormal3f(-0.760742, 0.613281, -0.212891);
 glVertex3f(-1.315391, 0.507442, -0.015921);
 glNormal3f(-0.463867, 0.878418, 0.114258);
 glVertex3f(-1.315391, 0.507442, 0.028085);
 glNormal3f(-0.401367, 0.864258, 0.302734);
 glVertex3f(-1.306196, 0.507442, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.597168, 0.599121, -0.533691);
 glVertex3f(-1.339036, 0.494306, 0.006410);
 glNormal3f(-0.308594, 0.438965, -0.844238);
 glVertex3f(-1.339036, 0.499560, 0.006410);
 glNormal3f(-0.835449, 0.361328, -0.414062);
 glVertex3f(-1.315391, 0.501530, 0.006410);
 glNormal3f(-0.634277, 0.518555, -0.573730);
 glVertex3f(-1.314734, 0.496276, 0.006410);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.344238, 0.708984, 0.615234);
 glVertex3f(-1.323273, 0.501530, 0.039250);
 glNormal3f(-0.794434, 0.478027, 0.374512);
 glVertex3f(-1.315391, 0.501530, 0.028085);
 glNormal3f(-0.835449, 0.361328, -0.414062);
 glVertex3f(-1.315391, 0.501530, 0.006410);
 glNormal3f(-0.308594, 0.438965, -0.844238);
 glVertex3f(-1.339036, 0.499560, 0.006410);
 glNormal3f(-0.687012, 0.400879, -0.605957);
 glVertex3f(-1.347574, 0.499560, 0.012321);
 glNormal3f(-0.883301, 0.399902, -0.244141);
 glVertex3f(-1.351515, 0.498246, 0.019546);
 glNormal3f(-0.833496, 0.428223, 0.349121);
 glVertex3f(-1.351515, 0.498246, 0.028085);
 glNormal3f(-0.446289, 0.426270, 0.786621);
 glVertex3f(-1.344290, 0.499560, 0.034653);
 glNormal3f(-0.234375, 0.430664, 0.871582);
 glVertex3f(-1.335752, 0.499560, 0.036623);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.734863, 0.653809, -0.181152);
 glVertex3f(-1.311450, 0.496933, -0.061241);
 glNormal3f(-0.694824, 0.663086, -0.278320);
 glVertex3f(-1.314077, 0.496276, -0.046791);
 glNormal3f(-0.341309, 0.911621, -0.228516);
 glVertex3f(-1.305539, 0.496933, -0.050732);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.552246, 0.735352, -0.393066);
 glVertex3f(-1.305539, 0.496933, -0.027744);
 glNormal3f(-0.341309, 0.911621, -0.228516);
 glVertex3f(-1.305539, 0.496933, -0.050732);
 glNormal3f(-0.694824, 0.663086, -0.278320);
 glVertex3f(-1.314077, 0.496276, -0.046791);
 glNormal3f(-0.545410, 0.664062, -0.511719);
 glVertex3f(-1.320645, 0.496276, -0.038253);
 glNormal3f(-0.427246, 0.860840, -0.275391);
 glVertex3f(-1.314734, 0.496276, -0.027744);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.695801, 0.391602, -0.602539);
 glVertex3f(-1.344290, 0.492992, -0.021832);
 glNormal3f(-0.893555, 0.380859, -0.237793);
 glVertex3f(-1.349545, 0.492992, -0.013294);
 glNormal3f(-0.881348, 0.384766, 0.274414);
 glVertex3f(-1.349545, 0.492992, -0.002128);
 glNormal3f(-0.538086, 0.418945, 0.730957);
 glVertex3f(-1.344290, 0.492992, 0.005096);
 glNormal3f(-0.597168, 0.599121, -0.533691);
 glVertex3f(-1.339036, 0.494306, 0.006410);
 glNormal3f(-0.634277, 0.518555, -0.573730);
 glVertex3f(-1.314734, 0.496276, 0.006410);
 glNormal3f(-0.427246, 0.860840, -0.275391);
 glVertex3f(-1.314734, 0.496276, -0.027744);
 glNormal3f(-0.545410, 0.664062, -0.511719);
 glVertex3f(-1.320645, 0.496276, -0.038253);
 glNormal3f(-0.552734, 0.400879, -0.730957);
 glVertex3f(-1.332468, 0.494962, -0.030371);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.270508, 0.436035, -0.858398);
 glVertex3f(-1.298971, 0.496933, -0.074377);
 glNormal3f(-0.713867, 0.408691, -0.568848);
 glVertex3f(-1.308823, 0.496933, -0.068465);
 glNormal3f(-0.734863, 0.653809, -0.181152);
 glVertex3f(-1.311450, 0.496933, -0.061241);
 glNormal3f(-0.341309, 0.911621, -0.228516);
 glVertex3f(-1.305539, 0.496933, -0.050732);
 glNormal3f(0.161133, 0.955078, -0.248535);
 glVertex3f(-1.275326, 0.499560, -0.050732);
 glNormal3f(0.600098, 0.765625, -0.230957);
 glVertex3f(-1.268758, 0.499560, -0.061241);
 glNormal3f(0.615723, 0.515625, -0.595703);
 glVertex3f(-1.272042, 0.499560, -0.068465);
 glNormal3f(0.198242, 0.474609, -0.857422);
 glVertex3f(-1.281894, 0.499560, -0.074377);
 glNormal3f(-0.035156, 0.441895, -0.896484);
 glVertex3f(-1.290432, 0.498246, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.734863, 0.653809, -0.181152);
 glVertex3f(-1.311450, 0.496933, -0.061241);
 glNormal3f(-0.713867, 0.408691, -0.568848);
 glVertex3f(-1.308823, 0.496933, -0.068465);
 glNormal3f(-0.638184, -0.524902, -0.563965);
 glVertex3f(-1.308166, 0.489051, -0.068465);
 glNormal3f(-0.820801, -0.521484, -0.234375);
 glVertex3f(-1.310793, 0.489051, -0.061241);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.694824, 0.663086, -0.278320);
 glVertex3f(-1.314077, 0.496276, -0.046791);
 glNormal3f(-0.734863, 0.653809, -0.181152);
 glVertex3f(-1.311450, 0.496933, -0.061241);
 glNormal3f(-0.820801, -0.521484, -0.234375);
 glVertex3f(-1.310793, 0.489051, -0.061241);
 glNormal3f(-0.555664, -0.774902, -0.302246);
 glVertex3f(-1.313421, 0.489051, -0.046791);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.545410, 0.664062, -0.511719);
 glVertex3f(-1.320645, 0.496276, -0.038253);
 glNormal3f(-0.694824, 0.663086, -0.278320);
 glVertex3f(-1.314077, 0.496276, -0.046791);
 glNormal3f(-0.555664, -0.774902, -0.302246);
 glVertex3f(-1.313421, 0.489051, -0.046791);
 glNormal3f(-0.305176, -0.869629, -0.389160);
 glVertex3f(-1.319988, 0.487738, -0.038253);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.552734, 0.400879, -0.730957);
 glVertex3f(-1.332468, 0.494962, -0.030371);
 glNormal3f(-0.545410, 0.664062, -0.511719);
 glVertex3f(-1.320645, 0.496276, -0.038253);
 glNormal3f(-0.305176, -0.869629, -0.389160);
 glVertex3f(-1.319988, 0.487738, -0.038253);
 glNormal3f(-0.481445, -0.484863, -0.730469);
 glVertex3f(-1.331811, 0.486424, -0.030371);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.695801, 0.391602, -0.602539);
 glVertex3f(-1.344290, 0.492992, -0.021832);
 glNormal3f(-0.552734, 0.400879, -0.730957);
 glVertex3f(-1.332468, 0.494962, -0.030371);
 glNormal3f(-0.481445, -0.484863, -0.730469);
 glVertex3f(-1.331811, 0.486424, -0.030371);
 glNormal3f(-0.619629, -0.505371, -0.601562);
 glVertex3f(-1.343633, 0.486424, -0.021832);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.893555, 0.380859, -0.237793);
 glVertex3f(-1.349545, 0.492992, -0.013294);
 glNormal3f(-0.695801, 0.391602, -0.602539);
 glVertex3f(-1.344290, 0.492992, -0.021832);
 glNormal3f(-0.619629, -0.505371, -0.601562);
 glVertex3f(-1.343633, 0.486424, -0.021832);
 glNormal3f(-0.815430, -0.526855, -0.242188);
 glVertex3f(-1.348888, 0.485767, -0.013294);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.881348, 0.384766, 0.274414);
 glVertex3f(-1.349545, 0.492992, -0.002128);
 glNormal3f(-0.893555, 0.380859, -0.237793);
 glVertex3f(-1.349545, 0.492992, -0.013294);
 glNormal3f(-0.815430, -0.526855, -0.242188);
 glVertex3f(-1.348888, 0.485767, -0.013294);
 glNormal3f(-0.805664, -0.530762, 0.264648);
 glVertex3f(-1.348888, 0.485767, -0.002128);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.538086, 0.418945, 0.730957);
 glVertex3f(-1.344290, 0.492992, 0.005096);
 glNormal3f(-0.881348, 0.384766, 0.274414);
 glVertex3f(-1.349545, 0.492992, -0.002128);
 glNormal3f(-0.805664, -0.530762, 0.264648);
 glVertex3f(-1.348888, 0.485767, -0.002128);
 glNormal3f(-0.468262, -0.509277, 0.722168);
 glVertex3f(-1.343633, 0.486424, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.597168, 0.599121, -0.533691);
 glVertex3f(-1.339036, 0.494306, 0.006410);
 glNormal3f(-0.538086, 0.418945, 0.730957);
 glVertex3f(-1.344290, 0.492992, 0.005096);
 glNormal3f(-0.468262, -0.509277, 0.722168);
 glVertex3f(-1.343633, 0.486424, 0.005096);
 glNormal3f(-0.207031, -0.974121, 0.095215);
 glVertex3f(-1.338379, 0.486424, 0.006410);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.207031, -0.974121, 0.095215);
 glVertex3f(-1.338379, 0.486424, 0.006410);
 glNormal3f(-0.629883, -0.505371, -0.590332);
 glVertex3f(-1.346261, 0.485767, 0.012321);
 glNormal3f(-0.687012, 0.400879, -0.605957);
 glVertex3f(-1.347574, 0.499560, 0.012321);
 glNormal3f(-0.308594, 0.438965, -0.844238);
 glVertex3f(-1.339036, 0.499560, 0.006410);
 glNormal3f(-0.597168, 0.599121, -0.533691);
 glVertex3f(-1.339036, 0.494306, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.883301, 0.399902, -0.244141);
 glVertex3f(-1.351515, 0.498246, 0.019546);
 glNormal3f(-0.687012, 0.400879, -0.605957);
 glVertex3f(-1.347574, 0.499560, 0.012321);
 glNormal3f(-0.629883, -0.505371, -0.590332);
 glVertex3f(-1.346261, 0.485767, 0.012321);
 glNormal3f(-0.828613, -0.515137, -0.220703);
 glVertex3f(-1.350858, 0.485767, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.833496, 0.428223, 0.349121);
 glVertex3f(-1.351515, 0.498246, 0.028085);
 glNormal3f(-0.883301, 0.399902, -0.244141);
 glVertex3f(-1.351515, 0.498246, 0.019546);
 glNormal3f(-0.828613, -0.515137, -0.220703);
 glVertex3f(-1.350858, 0.485767, 0.019546);
 glNormal3f(-0.761230, -0.526855, 0.378906);
 glVertex3f(-1.350858, 0.485767, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.446289, 0.426270, 0.786621);
 glVertex3f(-1.344290, 0.499560, 0.034653);
 glNormal3f(-0.833496, 0.428223, 0.349121);
 glVertex3f(-1.351515, 0.498246, 0.028085);
 glNormal3f(-0.761230, -0.526855, 0.378906);
 glVertex3f(-1.350858, 0.485767, 0.028085);
 glNormal3f(-0.366211, -0.481934, 0.795898);
 glVertex3f(-1.342977, 0.486424, 0.034653);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.234375, 0.430664, 0.871582);
 glVertex3f(-1.335752, 0.499560, 0.036623);
 glNormal3f(-0.446289, 0.426270, 0.786621);
 glVertex3f(-1.344290, 0.499560, 0.034653);
 glNormal3f(-0.366211, -0.481934, 0.795898);
 glVertex3f(-1.342977, 0.486424, 0.034653);
 glNormal3f(-0.159668, -0.457520, 0.874512);
 glVertex3f(-1.334438, 0.486424, 0.036623);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.344238, 0.708984, 0.615234);
 glVertex3f(-1.323273, 0.501530, 0.039250);
 glNormal3f(-0.234375, 0.430664, 0.871582);
 glVertex3f(-1.335752, 0.499560, 0.036623);
 glNormal3f(-0.159668, -0.457520, 0.874512);
 glVertex3f(-1.334438, 0.486424, 0.036623);
 glNormal3f(-0.233887, -0.713867, 0.660156);
 glVertex3f(-1.321959, 0.487738, 0.039250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.542969, 0.414062, 0.730469);
 glVertex3f(-1.314734, 0.501530, 0.045818);
 glNormal3f(-0.344238, 0.708984, 0.615234);
 glVertex3f(-1.323273, 0.501530, 0.039250);
 glNormal3f(-0.233887, -0.713867, 0.660156);
 glVertex3f(-1.321959, 0.487738, 0.039250);
 glNormal3f(-0.455566, -0.475098, 0.752441);
 glVertex3f(-1.313421, 0.489051, 0.045818);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.379883, 0.434082, 0.816406);
 glVertex3f(-1.306196, 0.502844, 0.051073);
 glNormal3f(-0.542969, 0.414062, 0.730469);
 glVertex3f(-1.314734, 0.501530, 0.045818);
 glNormal3f(-0.455566, -0.475098, 0.752441);
 glVertex3f(-1.313421, 0.489051, 0.045818);
 glNormal3f(-0.307129, -0.461914, 0.832031);
 glVertex3f(-1.304882, 0.489708, 0.051073);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.133301, 0.455078, 0.879883);
 glVertex3f(-1.296344, 0.503501, 0.053700);
 glNormal3f(-0.379883, 0.434082, 0.816406);
 glVertex3f(-1.306196, 0.502844, 0.051073);
 glNormal3f(-0.307129, -0.461914, 0.832031);
 glVertex3f(-1.304882, 0.489708, 0.051073);
 glNormal3f(-0.082031, -0.438965, 0.894531);
 glVertex3f(-1.295030, 0.489708, 0.053700);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.043457, 0.728516, 0.683105);
 glVertex3f(-1.291089, 0.503501, 0.053700);
 glNormal3f(-0.133301, 0.455078, 0.879883);
 glVertex3f(-1.296344, 0.503501, 0.053700);
 glNormal3f(-0.082031, -0.438965, 0.894531);
 glVertex3f(-1.295030, 0.489708, 0.053700);
 glNormal3f(0.028320, -0.425781, 0.904297);
 glVertex3f(-1.289776, 0.491022, 0.053700);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.270508, 0.436035, -0.858398);
 glVertex3f(-1.298971, 0.496933, -0.074377);
 glNormal3f(-0.035156, 0.441895, -0.896484);
 glVertex3f(-1.290432, 0.498246, -0.074377);
 glNormal3f(0.041016, -0.445312, -0.894531);
 glVertex3f(-1.289776, 0.491022, -0.074377);
 glNormal3f(-0.193359, -0.479004, -0.856445);
 glVertex3f(-1.298314, 0.489708, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.713867, 0.408691, -0.568848);
 glVertex3f(-1.308823, 0.496933, -0.068465);
 glNormal3f(-0.270508, 0.436035, -0.858398);
 glVertex3f(-1.298971, 0.496933, -0.074377);
 glNormal3f(-0.193359, -0.479004, -0.856445);
 glVertex3f(-1.298314, 0.489708, -0.074377);
 glNormal3f(-0.638184, -0.524902, -0.563965);
 glVertex3f(-1.308166, 0.489051, -0.068465);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.199219, 0.740723, 0.641113);
 glVertex3f(-1.258906, 0.506785, 0.039907);
 glNormal3f(0.683594, 0.582031, 0.439453);
 glVertex3f(-1.266788, 0.505471, 0.028741);
 glNormal3f(0.095215, 0.183105, 0.978027);
 glVertex3f(-1.291089, 0.503501, 0.030055);
 glNormal3f(-0.043457, 0.728516, 0.683105);
 glVertex3f(-1.291089, 0.503501, 0.053700);
 glNormal3f(0.050293, 0.461914, 0.885254);
 glVertex3f(-1.285835, 0.504814, 0.053700);
 glNormal3f(0.314941, 0.482422, 0.816895);
 glVertex3f(-1.275983, 0.505471, 0.051729);
 glNormal3f(0.469727, 0.486328, 0.736328);
 glVertex3f(-1.267444, 0.505471, 0.045818);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.278809, -0.438477, -0.854492);
 glVertex3f(-1.281237, 0.491678, -0.074377);
 glNormal3f(0.699219, -0.402832, -0.590820);
 glVertex3f(-1.271385, 0.491678, -0.068465);
 glNormal3f(0.894043, -0.371094, -0.251465);
 glVertex3f(-1.268101, 0.492992, -0.061241);
 glNormal3f(0.705566, -0.657227, -0.265137);
 glVertex3f(-1.266131, 0.492992, -0.046791);
 glNormal3f(0.085938, -0.996582, 0.009766);
 glVertex3f(-1.289776, 0.491022, -0.010010);
 glNormal3f(-0.555664, -0.774902, -0.302246);
 glVertex3f(-1.313421, 0.489051, -0.046791);
 glNormal3f(-0.820801, -0.521484, -0.234375);
 glVertex3f(-1.310793, 0.489051, -0.061241);
 glNormal3f(-0.638184, -0.524902, -0.563965);
 glVertex3f(-1.308166, 0.489051, -0.068465);
 glNormal3f(-0.193359, -0.479004, -0.856445);
 glVertex3f(-1.298314, 0.489708, -0.074377);
 glNormal3f(0.041016, -0.445312, -0.894531);
 glVertex3f(-1.289776, 0.491022, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.728516, 0.543457, 0.416504);
 glVertex3f(1.272410, 0.273620, 0.019546);
 glNormal3f(-0.709961, 0.549316, -0.441406);
 glVertex3f(1.272410, 0.273620, 0.013635);
 glNormal3f(-0.508301, 0.793457, -0.334961);
 glVertex3f(1.271753, 0.260484, 0.013635);
 glNormal3f(-0.526855, 0.788086, 0.317871);
 glVertex3f(1.271753, 0.260484, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.068848, 0.516602, 0.853027);
 glVertex3f(1.279635, 0.272963, 0.024144);
 glNormal3f(-0.728516, 0.543457, 0.416504);
 glVertex3f(1.272410, 0.273620, 0.019546);
 glNormal3f(-0.526855, 0.788086, 0.317871);
 glVertex3f(1.271753, 0.260484, 0.019546);
 glNormal3f(0.082031, 0.768555, 0.633789);
 glVertex3f(1.278321, 0.259827, 0.024144);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.812012, 0.434570, 0.388672);
 glVertex3f(1.285546, 0.272306, 0.019546);
 glNormal3f(0.068848, 0.516602, 0.853027);
 glVertex3f(1.279635, 0.272963, 0.024144);
 glNormal3f(0.082031, 0.768555, 0.633789);
 glVertex3f(1.278321, 0.259827, 0.024144);
 glNormal3f(0.647949, 0.701660, 0.294922);
 glVertex3f(1.284889, 0.259170, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.794922, 0.442871, -0.414062);
 glVertex3f(1.285546, 0.272306, 0.013635);
 glNormal3f(0.812012, 0.434570, 0.388672);
 glVertex3f(1.285546, 0.272306, 0.019546);
 glNormal3f(0.647949, 0.701660, 0.294922);
 glVertex3f(1.284889, 0.259170, 0.019546);
 glNormal3f(0.631836, 0.708496, -0.312988);
 glVertex3f(1.284889, 0.259170, 0.013635);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.066406, 0.499512, -0.863770);
 glVertex3f(1.279635, 0.272963, 0.009694);
 glNormal3f(0.794922, 0.442871, -0.414062);
 glVertex3f(1.285546, 0.272306, 0.013635);
 glNormal3f(0.631836, 0.708496, -0.312988);
 glVertex3f(1.284889, 0.259170, 0.013635);
 glNormal3f(0.082031, 0.754395, -0.651367);
 glVertex3f(1.278321, 0.259827, 0.009694);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.709961, 0.549316, -0.441406);
 glVertex3f(1.272410, 0.273620, 0.013635);
 glNormal3f(0.066406, 0.499512, -0.863770);
 glVertex3f(1.279635, 0.272963, 0.009694);
 glNormal3f(0.082031, 0.754395, -0.651367);
 glVertex3f(1.278321, 0.259827, 0.009694);
 glNormal3f(-0.508301, 0.793457, -0.334961);
 glVertex3f(1.271753, 0.260484, 0.013635);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.218750, 0.931641, 0.289551);
 glVertex3f(1.262558, 0.261141, 0.005096);
 glNormal3f(-0.508301, 0.793457, -0.334961);
 glVertex3f(1.271753, 0.260484, 0.013635);
 glNormal3f(0.082031, 0.754395, -0.651367);
 glVertex3f(1.278321, 0.259827, 0.009694);
 glNormal3f(0.080078, 0.891113, 0.446289);
 glVertex3f(1.278321, 0.259827, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.526855, 0.788086, 0.317871);
 glVertex3f(1.271753, 0.260484, 0.019546);
 glNormal3f(-0.302246, 0.946289, 0.111816);
 glVertex3f(1.254019, 0.261798, 0.028085);
 glNormal3f(0.086426, 0.991699, -0.091797);
 glVertex3f(1.278321, 0.259827, 0.030055);
 glNormal3f(0.082031, 0.768555, 0.633789);
 glVertex3f(1.278321, 0.259827, 0.024144);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.771973, 0.598145, -0.213379);
 glVertex3f(1.302623, 0.257857, -0.015921);
 glNormal3f(0.764648, 0.608887, -0.208984);
 glVertex3f(1.293428, 0.258514, -0.015921);
 glNormal3f(0.365723, 0.881836, 0.296875);
 glVertex3f(1.293428, 0.258514, 0.005096);
 glNormal3f(0.444336, 0.887207, 0.122559);
 glVertex3f(1.301966, 0.257857, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.526855, 0.788086, 0.317871);
 glVertex3f(1.271753, 0.260484, 0.019546);
 glNormal3f(-0.508301, 0.793457, -0.334961);
 glVertex3f(1.271753, 0.260484, 0.013635);
 glNormal3f(-0.218750, 0.931641, 0.289551);
 glVertex3f(1.262558, 0.261141, 0.005096);
 glNormal3f(-0.302246, 0.946289, 0.111816);
 glVertex3f(1.254019, 0.261798, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.444336, 0.887207, 0.122559);
 glVertex3f(1.301966, 0.257857, 0.028741);
 glNormal3f(0.647949, 0.701660, 0.294922);
 glVertex3f(1.284889, 0.259170, 0.019546);
 glNormal3f(0.082031, 0.768555, 0.633789);
 glVertex3f(1.278321, 0.259827, 0.024144);
 glNormal3f(0.086426, 0.991699, -0.091797);
 glVertex3f(1.278321, 0.259827, 0.030055);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.812012, 0.434570, 0.388672);
 glVertex3f(1.285546, 0.272306, 0.019546);
 glNormal3f(0.794922, 0.442871, -0.414062);
 glVertex3f(1.285546, 0.272306, 0.013635);
 glNormal3f(0.066406, 0.499512, -0.863770);
 glVertex3f(1.279635, 0.272963, 0.009694);
 glNormal3f(-0.709961, 0.549316, -0.441406);
 glVertex3f(1.272410, 0.273620, 0.013635);
 glNormal3f(-0.728516, 0.543457, 0.416504);
 glVertex3f(1.272410, 0.273620, 0.019546);
 glNormal3f(0.068848, 0.516602, 0.853027);
 glVertex3f(1.279635, 0.272963, 0.024144);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.603516, 0.562500, 0.564453);
 glVertex3f(1.293428, 0.265082, 0.005096);
 glNormal3f(0.365723, 0.881836, 0.296875);
 glVertex3f(1.293428, 0.258514, 0.005096);
 glNormal3f(0.764648, 0.608887, -0.208984);
 glVertex3f(1.293428, 0.258514, -0.015921);
 glNormal3f(0.758301, 0.637207, -0.137207);
 glVertex3f(1.293428, 0.265082, -0.029714);
 glNormal3f(0.731445, 0.681641, 0.000000);
 glVertex3f(1.293428, 0.265082, -0.015921);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.716309, 0.584473, 0.381348);
 glVertex3f(1.253363, 0.256543, 0.028085);
 glNormal3f(-0.228027, 0.739746, 0.632812);
 glVertex3f(1.245481, 0.257200, 0.039250);
 glNormal3f(-0.475098, 0.479492, 0.737793);
 glVertex3f(1.254019, 0.256543, 0.045818);
 glNormal3f(-0.322754, 0.478516, 0.816406);
 glVertex3f(1.262558, 0.255886, 0.051073);
 glNormal3f(-0.083984, 0.465332, 0.880859);
 glVertex3f(1.272410, 0.255230, 0.053700);
 glNormal3f(0.070312, 0.694824, 0.715332);
 glVertex3f(1.277664, 0.254573, 0.053700);
 glNormal3f(0.073242, 0.069336, 0.994629);
 glVertex3f(1.277664, 0.254573, 0.030055);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.280273, 0.447266, -0.849121);
 glVertex3f(1.285546, 0.248005, -0.074377);
 glNormal3f(0.699707, 0.414062, -0.581543);
 glVertex3f(1.295398, 0.247348, -0.068465);
 glNormal3f(0.633789, -0.507812, -0.583496);
 glVertex3f(1.294741, 0.239466, -0.068465);
 glNormal3f(0.213379, -0.472168, -0.855469);
 glVertex3f(1.285546, 0.240780, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.038086, 0.445801, -0.894531);
 glVertex3f(1.277664, 0.248662, -0.074377);
 glNormal3f(0.280273, 0.447266, -0.849121);
 glVertex3f(1.285546, 0.248005, -0.074377);
 glNormal3f(0.213379, -0.472168, -0.855469);
 glVertex3f(1.285546, 0.240780, -0.074377);
 glNormal3f(-0.029297, -0.447266, -0.894531);
 glVertex3f(1.277008, 0.241437, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.133789, 0.423828, 0.895508);
 glVertex3f(1.282919, 0.253916, 0.053700);
 glNormal3f(0.070312, 0.694824, 0.715332);
 glVertex3f(1.277664, 0.254573, 0.053700);
 glNormal3f(-0.040527, -0.452637, 0.890625);
 glVertex3f(1.276351, 0.241437, 0.053700);
 glNormal3f(0.048340, -0.463379, 0.884766);
 glVertex3f(1.281605, 0.240780, 0.053700);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.385742, 0.404297, 0.828613);
 glVertex3f(1.292771, 0.253259, 0.051729);
 glNormal3f(0.133789, 0.423828, 0.895508);
 glVertex3f(1.282919, 0.253916, 0.053700);
 glNormal3f(0.048340, -0.463379, 0.884766);
 glVertex3f(1.281605, 0.240780, 0.053700);
 glNormal3f(0.309570, -0.494141, 0.812500);
 glVertex3f(1.291457, 0.240123, 0.051729);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.541504, 0.382324, 0.748047);
 glVertex3f(1.301309, 0.252602, 0.045818);
 glNormal3f(0.385742, 0.404297, 0.828613);
 glVertex3f(1.292771, 0.253259, 0.051729);
 glNormal3f(0.309570, -0.494141, 0.812500);
 glVertex3f(1.291457, 0.240123, 0.051729);
 glNormal3f(0.471191, -0.501465, 0.725586);
 glVertex3f(1.299996, 0.239466, 0.045818);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.338867, 0.670410, 0.659668);
 glVertex3f(1.309848, 0.251946, 0.039907);
 glNormal3f(0.541504, 0.382324, 0.748047);
 glVertex3f(1.301309, 0.252602, 0.045818);
 glNormal3f(0.471191, -0.501465, 0.725586);
 glVertex3f(1.299996, 0.239466, 0.045818);
 glNormal3f(0.201660, -0.740234, 0.641113);
 glVertex3f(1.308534, 0.238809, 0.039907);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.228027, 0.425781, 0.875488);
 glVertex3f(1.322327, 0.250632, 0.037280);
 glNormal3f(0.338867, 0.670410, 0.659668);
 glVertex3f(1.309848, 0.251946, 0.039907);
 glNormal3f(0.201660, -0.740234, 0.641113);
 glVertex3f(1.308534, 0.238809, 0.039907);
 glNormal3f(0.136719, -0.458984, 0.877930);
 glVertex3f(1.321013, 0.237496, 0.037280);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.446289, 0.428711, 0.784668);
 glVertex3f(1.330865, 0.249975, 0.035309);
 glNormal3f(0.228027, 0.425781, 0.875488);
 glVertex3f(1.322327, 0.250632, 0.037280);
 glNormal3f(0.136719, -0.458984, 0.877930);
 glVertex3f(1.321013, 0.237496, 0.037280);
 glNormal3f(0.356934, -0.481445, 0.800293);
 glVertex3f(1.329552, 0.236839, 0.035309);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.819336, 0.426758, 0.381836);
 glVertex3f(1.337433, 0.249318, 0.028741);
 glNormal3f(0.446289, 0.428711, 0.784668);
 glVertex3f(1.330865, 0.249975, 0.035309);
 glNormal3f(0.356934, -0.481445, 0.800293);
 glVertex3f(1.329552, 0.236839, 0.035309);
 glNormal3f(0.750488, -0.520996, 0.406250);
 glVertex3f(1.337433, 0.236182, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.883301, 0.410645, -0.225586);
 glVertex3f(1.338747, 0.249318, 0.019546);
 glNormal3f(0.819336, 0.426758, 0.381836);
 glVertex3f(1.337433, 0.249318, 0.028741);
 glNormal3f(0.750488, -0.520996, 0.406250);
 glVertex3f(1.337433, 0.236182, 0.028741);
 glNormal3f(0.817871, -0.530273, -0.223145);
 glVertex3f(1.337433, 0.236182, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.685547, 0.401367, -0.606934);
 glVertex3f(1.333493, 0.249975, 0.012321);
 glNormal3f(0.883301, 0.410645, -0.225586);
 glVertex3f(1.338747, 0.249318, 0.019546);
 glNormal3f(0.817871, -0.530273, -0.223145);
 glVertex3f(1.337433, 0.236182, 0.019546);
 glNormal3f(0.607910, -0.507324, -0.610840);
 glVertex3f(1.332836, 0.236182, 0.012321);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.325684, 0.444824, -0.834473);
 glVertex3f(1.326268, 0.250632, 0.006410);
 glNormal3f(0.685547, 0.401367, -0.606934);
 glVertex3f(1.333493, 0.249975, 0.012321);
 glNormal3f(0.607910, -0.507324, -0.610840);
 glVertex3f(1.332836, 0.236182, 0.012321);
 glNormal3f(0.179199, -0.982422, 0.051270);
 glVertex3f(1.324954, 0.237496, 0.006410);
 glNormal3f(0.610352, 0.588379, -0.529785);
 glVertex3f(1.325611, 0.244721, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.521973, 0.419922, 0.741699);
 glVertex3f(1.330865, 0.244721, 0.005096);
 glNormal3f(0.610352, 0.588379, -0.529785);
 glVertex3f(1.325611, 0.244721, 0.006410);
 glNormal3f(0.179199, -0.982422, 0.051270);
 glVertex3f(1.324954, 0.237496, 0.006410);
 glNormal3f(0.434570, -0.510742, 0.741699);
 glVertex3f(1.329552, 0.236839, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.856445, 0.428711, 0.286133);
 glVertex3f(1.335463, 0.244064, -0.001472);
 glNormal3f(0.521973, 0.419922, 0.741699);
 glVertex3f(1.330865, 0.244721, 0.005096);
 glNormal3f(0.434570, -0.510742, 0.741699);
 glVertex3f(1.329552, 0.236839, 0.005096);
 glNormal3f(0.806152, -0.510254, 0.298828);
 glVertex3f(1.335463, 0.236182, -0.001472);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.879883, 0.417480, -0.226074);
 glVertex3f(1.335463, 0.244064, -0.012637);
 glNormal3f(0.856445, 0.428711, 0.286133);
 glVertex3f(1.335463, 0.244064, -0.001472);
 glNormal3f(0.806152, -0.510254, 0.298828);
 glVertex3f(1.335463, 0.236182, -0.001472);
 glNormal3f(0.831055, -0.503418, -0.236816);
 glVertex3f(1.335463, 0.236182, -0.012637);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.703125, 0.388672, -0.595215);
 glVertex3f(1.330865, 0.244721, -0.021832);
 glNormal3f(0.879883, 0.417480, -0.226074);
 glVertex3f(1.335463, 0.244064, -0.012637);
 glNormal3f(0.831055, -0.503418, -0.236816);
 glVertex3f(1.335463, 0.236182, -0.012637);
 glNormal3f(0.615234, -0.519043, -0.593262);
 glVertex3f(1.329552, 0.236839, -0.021832);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.530273, 0.403320, -0.745605);
 glVertex3f(1.319043, 0.245378, -0.030371);
 glNormal3f(0.703125, 0.388672, -0.595215);
 glVertex3f(1.330865, 0.244721, -0.021832);
 glNormal3f(0.615234, -0.519043, -0.593262);
 glVertex3f(1.329552, 0.236839, -0.021832);
 glNormal3f(0.447754, -0.489258, -0.748535);
 glVertex3f(1.318386, 0.237496, -0.030371);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.523438, 0.684570, -0.506836);
 glVertex3f(1.306564, 0.246691, -0.037596);
 glNormal3f(0.530273, 0.403320, -0.745605);
 glVertex3f(1.319043, 0.245378, -0.030371);
 glNormal3f(0.447754, -0.489258, -0.748535);
 glVertex3f(1.318386, 0.237496, -0.030371);
 glNormal3f(0.296875, -0.859863, -0.416016);
 glVertex3f(1.306564, 0.238809, -0.037596);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.696289, 0.675781, -0.241211);
 glVertex3f(1.300653, 0.246691, -0.046791);
 glNormal3f(0.523438, 0.684570, -0.506836);
 glVertex3f(1.306564, 0.246691, -0.037596);
 glNormal3f(0.296875, -0.859863, -0.416016);
 glVertex3f(1.306564, 0.238809, -0.037596);
 glNormal3f(0.596191, -0.762207, -0.252441);
 glVertex3f(1.299996, 0.239466, -0.046791);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.730469, 0.657715, -0.183105);
 glVertex3f(1.298682, 0.247348, -0.061241);
 glNormal3f(0.696289, 0.675781, -0.241211);
 glVertex3f(1.300653, 0.246691, -0.046791);
 glNormal3f(0.596191, -0.762207, -0.252441);
 glVertex3f(1.299996, 0.239466, -0.046791);
 glNormal3f(0.818848, -0.519043, -0.244629);
 glVertex3f(1.298025, 0.239466, -0.061241);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.699707, 0.414062, -0.581543);
 glVertex3f(1.295398, 0.247348, -0.068465);
 glNormal3f(0.730469, 0.657715, -0.183105);
 glVertex3f(1.298682, 0.247348, -0.061241);
 glNormal3f(0.818848, -0.519043, -0.244629);
 glVertex3f(1.298025, 0.239466, -0.061241);
 glNormal3f(0.633789, -0.507812, -0.583496);
 glVertex3f(1.294741, 0.239466, -0.068465);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.626465, 0.514648, -0.584961);
 glVertex3f(1.301309, 0.246691, 0.006410);
 glNormal3f(0.610352, 0.588379, -0.529785);
 glVertex3f(1.325611, 0.244721, 0.006410);
 glNormal3f(0.521973, 0.419922, 0.741699);
 glVertex3f(1.330865, 0.244721, 0.005096);
 glNormal3f(0.856445, 0.428711, 0.286133);
 glVertex3f(1.335463, 0.244064, -0.001472);
 glNormal3f(0.879883, 0.417480, -0.226074);
 glVertex3f(1.335463, 0.244064, -0.012637);
 glNormal3f(0.703125, 0.388672, -0.595215);
 glVertex3f(1.330865, 0.244721, -0.021832);
 glNormal3f(0.530273, 0.403320, -0.745605);
 glVertex3f(1.319043, 0.245378, -0.030371);
 glNormal3f(0.523438, 0.684570, -0.506836);
 glVertex3f(1.306564, 0.246691, -0.037596);
 glNormal3f(0.420898, 0.859375, -0.289551);
 glVertex3f(1.301309, 0.246691, -0.027087);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.696289, 0.675781, -0.241211);
 glVertex3f(1.300653, 0.246691, -0.046791);
 glNormal3f(0.333984, 0.914551, -0.227051);
 glVertex3f(1.291457, 0.247348, -0.050732);
 glNormal3f(0.553711, 0.720215, -0.416992);
 glVertex3f(1.291457, 0.247348, -0.027744);
 glNormal3f(0.420898, 0.859375, -0.289551);
 glVertex3f(1.301309, 0.246691, -0.027087);
 glNormal3f(0.523438, 0.684570, -0.506836);
 glVertex3f(1.306564, 0.246691, -0.037596);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.730469, 0.657715, -0.183105);
 glVertex3f(1.298682, 0.247348, -0.061241);
 glNormal3f(0.333984, 0.914551, -0.227051);
 glVertex3f(1.291457, 0.247348, -0.050732);
 glNormal3f(0.696289, 0.675781, -0.241211);
 glVertex3f(1.300653, 0.246691, -0.046791);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.446289, 0.428711, 0.784668);
 glVertex3f(1.330865, 0.249975, 0.035309);
 glNormal3f(0.819336, 0.426758, 0.381836);
 glVertex3f(1.337433, 0.249318, 0.028741);
 glNormal3f(0.883301, 0.410645, -0.225586);
 glVertex3f(1.338747, 0.249318, 0.019546);
 glNormal3f(0.685547, 0.401367, -0.606934);
 glVertex3f(1.333493, 0.249975, 0.012321);
 glNormal3f(0.325684, 0.444824, -0.834473);
 glVertex3f(1.326268, 0.250632, 0.006410);
 glNormal3f(0.848145, 0.342285, -0.403809);
 glVertex3f(1.301966, 0.252602, 0.006410);
 glNormal3f(0.787598, 0.439453, 0.430664);
 glVertex3f(1.301966, 0.252602, 0.028741);
 glNormal3f(0.338867, 0.670410, 0.659668);
 glVertex3f(1.309848, 0.251946, 0.039907);
 glNormal3f(0.228027, 0.425781, 0.875488);
 glVertex3f(1.322327, 0.250632, 0.037280);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.325684, 0.444824, -0.834473);
 glVertex3f(1.326268, 0.250632, 0.006410);
 glNormal3f(0.610352, 0.588379, -0.529785);
 glVertex3f(1.325611, 0.244721, 0.006410);
 glNormal3f(0.626465, 0.514648, -0.584961);
 glVertex3f(1.301309, 0.246691, 0.006410);
 glNormal3f(0.848145, 0.342285, -0.403809);
 glVertex3f(1.301966, 0.252602, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.444336, 0.887207, 0.122559);
 glVertex3f(1.301966, 0.257857, 0.028741);
 glNormal3f(0.365723, 0.881836, 0.296875);
 glVertex3f(1.293428, 0.258514, 0.005096);
 glNormal3f(0.631836, 0.708496, -0.312988);
 glVertex3f(1.284889, 0.259170, 0.013635);
 glNormal3f(0.647949, 0.701660, 0.294922);
 glVertex3f(1.284889, 0.259170, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.444336, 0.887207, 0.122559);
 glVertex3f(1.301966, 0.257857, 0.028741);
 glNormal3f(0.787598, 0.439453, 0.430664);
 glVertex3f(1.301966, 0.252602, 0.028741);
 glNormal3f(0.848145, 0.342285, -0.403809);
 glVertex3f(1.301966, 0.252602, 0.006410);
 glNormal3f(0.771973, 0.598145, -0.213379);
 glVertex3f(1.302623, 0.257857, -0.015921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.755859, 0.413086, -0.507812);
 glVertex3f(1.292771, 0.253259, -0.023146);
 glNormal3f(0.507812, 0.576660, -0.640137);
 glVertex3f(1.301966, 0.252602, -0.023146);
 glNormal3f(0.420898, 0.859375, -0.289551);
 glVertex3f(1.301309, 0.246691, -0.027087);
 glNormal3f(0.553711, 0.720215, -0.416992);
 glVertex3f(1.291457, 0.247348, -0.027744);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.752930, 0.383301, -0.534668);
 glVertex3f(1.292771, 0.255886, -0.045477);
 glNormal3f(0.755859, 0.413086, -0.507812);
 glVertex3f(1.292771, 0.253259, -0.023146);
 glNormal3f(0.553711, 0.720215, -0.416992);
 glVertex3f(1.291457, 0.247348, -0.027744);
 glNormal3f(0.333984, 0.914551, -0.227051);
 glVertex3f(1.291457, 0.247348, -0.050732);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.021973, -0.300781, 0.953125);
 glVertex3f(1.278321, 0.258514, 0.041877);
 glNormal3f(0.284180, -0.043945, 0.957520);
 glVertex3f(1.285546, 0.257857, 0.041221);
 glNormal3f(0.324707, 0.780273, 0.534180);
 glVertex3f(1.285546, 0.262454, 0.038593);
 glNormal3f(0.084961, 0.959473, 0.267578);
 glVertex3f(1.278321, 0.263111, 0.039250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.764648, 0.608887, -0.208984);
 glVertex3f(1.293428, 0.258514, -0.015921);
 glNormal3f(0.771973, 0.598145, -0.213379);
 glVertex3f(1.302623, 0.257857, -0.015921);
 glNormal3f(0.507812, 0.576660, -0.640137);
 glVertex3f(1.301966, 0.252602, -0.023146);
 glNormal3f(0.755859, 0.413086, -0.507812);
 glVertex3f(1.292771, 0.253259, -0.023146);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.626465, 0.514648, -0.584961);
 glVertex3f(1.301309, 0.246691, 0.006410);
 glNormal3f(0.420898, 0.859375, -0.289551);
 glVertex3f(1.301309, 0.246691, -0.027087);
 glNormal3f(0.507812, 0.576660, -0.640137);
 glVertex3f(1.301966, 0.252602, -0.023146);
 glNormal3f(0.771973, 0.598145, -0.213379);
 glVertex3f(1.302623, 0.257857, -0.015921);
 glNormal3f(0.848145, 0.342285, -0.403809);
 glVertex3f(1.301966, 0.252602, 0.006410);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.755859, 0.413086, -0.507812);
 glVertex3f(1.292771, 0.253259, -0.023146);
 glNormal3f(0.752930, 0.383301, -0.534668);
 glVertex3f(1.292771, 0.255886, -0.045477);
 glNormal3f(0.518555, 0.719727, -0.461426);
 glVertex3f(1.293428, 0.261141, -0.038909);
 glNormal3f(0.758301, 0.637207, -0.137207);
 glVertex3f(1.293428, 0.265082, -0.029714);
 glNormal3f(0.764648, 0.608887, -0.208984);
 glVertex3f(1.293428, 0.258514, -0.015921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.389160, -0.539551, 0.746582);
 glVertex3f(1.296055, 0.253916, 0.034653);
 glNormal3f(-0.081543, -0.947754, 0.308105);
 glVertex3f(1.277664, 0.255886, 0.035966);
 glNormal3f(0.073242, 0.069336, 0.994629);
 glVertex3f(1.277664, 0.254573, 0.030055);
 glNormal3f(0.787598, 0.439453, 0.430664);
 glVertex3f(1.301966, 0.252602, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.489258, 0.815430, 0.307617);
 glVertex3f(1.296712, 0.259170, 0.033339);
 glNormal3f(0.389160, -0.539551, 0.746582);
 glVertex3f(1.296055, 0.253916, 0.034653);
 glNormal3f(0.787598, 0.439453, 0.430664);
 glVertex3f(1.301966, 0.252602, 0.028741);
 glNormal3f(0.444336, 0.887207, 0.122559);
 glVertex3f(1.301966, 0.257857, 0.028741);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.081055, 0.937500, -0.337891);
 glVertex3f(1.278321, 0.260484, 0.034653);
 glNormal3f(0.489258, 0.815430, 0.307617);
 glVertex3f(1.296712, 0.259170, 0.033339);
 glNormal3f(0.444336, 0.887207, 0.122559);
 glVertex3f(1.301966, 0.257857, 0.028741);
 glNormal3f(0.086426, 0.991699, -0.091797);
 glVertex3f(1.278321, 0.259827, 0.030055);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.284180, -0.043945, 0.957520);
 glVertex3f(1.285546, 0.257857, 0.041221);
 glNormal3f(-0.021973, -0.300781, 0.953125);
 glVertex3f(1.278321, 0.258514, 0.041877);
 glNormal3f(-0.081543, -0.947754, 0.308105);
 glVertex3f(1.277664, 0.255886, 0.035966);
 glNormal3f(0.389160, -0.539551, 0.746582);
 glVertex3f(1.296055, 0.253916, 0.034653);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.324707, 0.780273, 0.534180);
 glVertex3f(1.285546, 0.262454, 0.038593);
 glNormal3f(0.284180, -0.043945, 0.957520);
 glVertex3f(1.285546, 0.257857, 0.041221);
 glNormal3f(0.389160, -0.539551, 0.746582);
 glVertex3f(1.296055, 0.253916, 0.034653);
 glNormal3f(0.489258, 0.815430, 0.307617);
 glVertex3f(1.296712, 0.259170, 0.033339);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.084961, 0.959473, 0.267578);
 glVertex3f(1.278321, 0.263111, 0.039250);
 glNormal3f(0.324707, 0.780273, 0.534180);
 glVertex3f(1.285546, 0.262454, 0.038593);
 glNormal3f(0.489258, 0.815430, 0.307617);
 glVertex3f(1.296712, 0.259170, 0.033339);
 glNormal3f(0.081055, 0.937500, -0.337891);
 glVertex3f(1.278321, 0.260484, 0.034653);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.201660, -0.740234, 0.641113);
 glVertex3f(1.308534, 0.238809, 0.039907);
 glNormal3f(0.179199, -0.982422, 0.051270);
 glVertex3f(1.324954, 0.237496, 0.006410);
 glNormal3f(0.607910, -0.507324, -0.610840);
 glVertex3f(1.332836, 0.236182, 0.012321);
 glNormal3f(0.817871, -0.530273, -0.223145);
 glVertex3f(1.337433, 0.236182, 0.019546);
 glNormal3f(0.750488, -0.520996, 0.406250);
 glVertex3f(1.337433, 0.236182, 0.028741);
 glNormal3f(0.356934, -0.481445, 0.800293);
 glVertex3f(1.329552, 0.236839, 0.035309);
 glNormal3f(0.136719, -0.458984, 0.877930);
 glVertex3f(1.321013, 0.237496, 0.037280);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.615234, -0.519043, -0.593262);
 glVertex3f(1.329552, 0.236839, -0.021832);
 glNormal3f(0.831055, -0.503418, -0.236816);
 glVertex3f(1.335463, 0.236182, -0.012637);
 glNormal3f(0.806152, -0.510254, 0.298828);
 glVertex3f(1.335463, 0.236182, -0.001472);
 glNormal3f(0.434570, -0.510742, 0.741699);
 glVertex3f(1.329552, 0.236839, 0.005096);
 glNormal3f(0.179199, -0.982422, 0.051270);
 glVertex3f(1.324954, 0.237496, 0.006410);
 glNormal3f(0.296875, -0.859863, -0.416016);
 glVertex3f(1.306564, 0.238809, -0.037596);
 glNormal3f(0.447754, -0.489258, -0.748535);
 glVertex3f(1.318386, 0.237496, -0.030371);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.296875, -0.859863, -0.416016);
 glVertex3f(1.306564, 0.238809, -0.037596);
 glNormal3f(-0.071289, -0.997559, -0.018555);
 glVertex3f(1.276351, 0.241437, -0.010010);
 glNormal3f(0.596191, -0.762207, -0.252441);
 glVertex3f(1.299996, 0.239466, -0.046791);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.431641, -0.801270, -0.415039);
 glVertex3f(1.246795, 0.243407, -0.038253);
 glNormal3f(-0.685547, -0.671875, -0.281738);
 glVertex3f(1.253363, 0.243407, -0.046791);
 glNormal3f(-0.071289, -0.997559, -0.018555);
 glVertex3f(1.276351, 0.241437, -0.010010);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.309570, -0.494141, 0.812500);
 glVertex3f(1.291457, 0.240123, 0.051729);
 glNormal3f(0.048340, -0.463379, 0.884766);
 glVertex3f(1.281605, 0.240780, 0.053700);
 glNormal3f(-0.040527, -0.452637, 0.890625);
 glVertex3f(1.276351, 0.241437, 0.053700);
 glNormal3f(-0.166016, -0.444336, 0.880371);
 glVertex3f(1.270440, 0.241437, 0.053700);
 glNormal3f(-0.402832, -0.430176, 0.808105);
 glVertex3f(1.261901, 0.242750, 0.051073);
 glNormal3f(-0.548340, -0.422363, 0.721680);
 glVertex3f(1.253363, 0.243407, 0.045818);
 glNormal3f(-0.349121, -0.698730, 0.624512);
 glVertex3f(1.244824, 0.244064, 0.039250);
 glNormal3f(-0.338379, -0.939941, 0.045410);
 glVertex3f(1.228404, 0.245378, 0.006410);
 glNormal3f(-0.431641, -0.801270, -0.415039);
 glVertex3f(1.246795, 0.243407, -0.038253);
 glNormal3f(-0.071289, -0.997559, -0.018555);
 glVertex3f(1.276351, 0.241437, -0.010010);
 glNormal3f(0.296875, -0.859863, -0.416016);
 glVertex3f(1.306564, 0.238809, -0.037596);
 glNormal3f(0.179199, -0.982422, 0.051270);
 glVertex3f(1.324954, 0.237496, 0.006410);
 glNormal3f(0.201660, -0.740234, 0.641113);
 glVertex3f(1.308534, 0.238809, 0.039907);
 glNormal3f(0.471191, -0.501465, 0.725586);
 glVertex3f(1.299996, 0.239466, 0.045818);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.431641, -0.801270, -0.415039);
 glVertex3f(1.246795, 0.243407, -0.038253);
 glNormal3f(-0.338379, -0.939941, 0.045410);
 glVertex3f(1.228404, 0.245378, 0.006410);
 glNormal3f(-0.539551, -0.409668, 0.735352);
 glVertex3f(1.222493, 0.246034, 0.005096);
 glNormal3f(-0.885742, -0.375488, 0.274414);
 glVertex3f(1.217895, 0.246034, -0.002128);
 glNormal3f(-0.891602, -0.390137, -0.231934);
 glVertex3f(1.217895, 0.246034, -0.013294);
 glNormal3f(-0.690918, -0.393555, -0.607422);
 glVertex3f(1.222493, 0.245378, -0.021832);
 glNormal3f(-0.545898, -0.398926, -0.737305);
 glVertex3f(1.234972, 0.244721, -0.030371);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.455566, -0.412109, 0.789062);
 glVertex3f(1.222493, 0.246034, 0.034653);
 glNormal3f(-0.848145, -0.394531, 0.353516);
 glVertex3f(1.215925, 0.246034, 0.028085);
 glNormal3f(-0.892578, -0.388184, -0.230957);
 glVertex3f(1.215925, 0.246034, 0.019546);
 glNormal3f(-0.685059, -0.412109, -0.601562);
 glVertex3f(1.220523, 0.246034, 0.012321);
 glNormal3f(-0.338379, -0.939941, 0.045410);
 glVertex3f(1.228404, 0.245378, 0.006410);
 glNormal3f(-0.349121, -0.698730, 0.624512);
 glVertex3f(1.244824, 0.244064, 0.039250);
 glNormal3f(-0.223145, -0.428711, 0.875488);
 glVertex3f(1.231688, 0.244721, 0.036623);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.189941, 0.815430, 0.546387);
 glVertex3f(1.270440, 0.263768, 0.038593);
 glNormal3f(0.084961, 0.959473, 0.267578);
 glVertex3f(1.278321, 0.263111, 0.039250);
 glNormal3f(0.081055, 0.937500, -0.337891);
 glVertex3f(1.278321, 0.260484, 0.034653);
 glNormal3f(-0.359863, 0.884766, 0.295410);
 glVertex3f(1.259931, 0.262454, 0.033339);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.289062, -0.011719, 0.957031);
 glVertex3f(1.269783, 0.259170, 0.041221);
 glNormal3f(-0.189941, 0.815430, 0.546387);
 glVertex3f(1.270440, 0.263768, 0.038593);
 glNormal3f(-0.359863, 0.884766, 0.295410);
 glVertex3f(1.259931, 0.262454, 0.033339);
 glNormal3f(-0.489746, -0.468262, 0.735840);
 glVertex3f(1.259274, 0.257200, 0.034653);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.021973, -0.300781, 0.953125);
 glVertex3f(1.278321, 0.258514, 0.041877);
 glNormal3f(-0.289062, -0.011719, 0.957031);
 glVertex3f(1.269783, 0.259170, 0.041221);
 glNormal3f(-0.489746, -0.468262, 0.735840);
 glVertex3f(1.259274, 0.257200, 0.034653);
 glNormal3f(-0.081543, -0.947754, 0.308105);
 glVertex3f(1.277664, 0.255886, 0.035966);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.359863, 0.884766, 0.295410);
 glVertex3f(1.259931, 0.262454, 0.033339);
 glNormal3f(0.081055, 0.937500, -0.337891);
 glVertex3f(1.278321, 0.260484, 0.034653);
 glNormal3f(0.086426, 0.991699, -0.091797);
 glVertex3f(1.278321, 0.259827, 0.030055);
 glNormal3f(-0.302246, 0.946289, 0.111816);
 glVertex3f(1.254019, 0.261798, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.489746, -0.468262, 0.735840);
 glVertex3f(1.259274, 0.257200, 0.034653);
 glNormal3f(-0.359863, 0.884766, 0.295410);
 glVertex3f(1.259931, 0.262454, 0.033339);
 glNormal3f(-0.302246, 0.946289, 0.111816);
 glVertex3f(1.254019, 0.261798, 0.028085);
 glNormal3f(-0.716309, 0.584473, 0.381348);
 glVertex3f(1.253363, 0.256543, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.081543, -0.947754, 0.308105);
 glVertex3f(1.277664, 0.255886, 0.035966);
 glNormal3f(-0.489746, -0.468262, 0.735840);
 glVertex3f(1.259274, 0.257200, 0.034653);
 glNormal3f(-0.716309, 0.584473, 0.381348);
 glVertex3f(1.253363, 0.256543, 0.028085);
 glNormal3f(0.073242, 0.069336, 0.994629);
 glVertex3f(1.277664, 0.254573, 0.030055);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.082031, 0.754395, -0.651367);
 glVertex3f(1.278321, 0.259827, 0.009694);
 glNormal3f(0.631836, 0.708496, -0.312988);
 glVertex3f(1.284889, 0.259170, 0.013635);
 glNormal3f(0.365723, 0.881836, 0.296875);
 glVertex3f(1.293428, 0.258514, 0.005096);
 glNormal3f(0.080078, 0.891113, 0.446289);
 glVertex3f(1.278321, 0.259827, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.633301, 0.761230, -0.138672);
 glVertex3f(1.263872, 0.267709, -0.029714);
 glNormal3f(0.758301, 0.637207, -0.137207);
 glVertex3f(1.293428, 0.265082, -0.029714);
 glNormal3f(0.518555, 0.719727, -0.461426);
 glVertex3f(1.293428, 0.261141, -0.038909);
 glNormal3f(-0.382324, 0.800781, -0.461426);
 glVertex3f(1.262558, 0.263768, -0.038909);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.633301, 0.761230, -0.138672);
 glVertex3f(1.263872, 0.267709, -0.029714);
 glNormal3f(-0.647461, 0.733398, -0.207031);
 glVertex3f(1.262558, 0.261141, -0.015921);
 glNormal3f(-0.218750, 0.931641, 0.289551);
 glVertex3f(1.262558, 0.261141, 0.005096);
 glNormal3f(-0.504883, 0.661621, 0.554199);
 glVertex3f(1.263872, 0.267709, 0.005096);
 glNormal3f(-0.606445, 0.794922, 0.000000);
 glVertex3f(1.263872, 0.267709, -0.015921);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.365723, 0.881836, 0.296875);
 glVertex3f(1.293428, 0.258514, 0.005096);
 glNormal3f(0.603516, 0.562500, 0.564453);
 glVertex3f(1.293428, 0.265082, 0.005096);
 glNormal3f(-0.504883, 0.661621, 0.554199);
 glVertex3f(1.263872, 0.267709, 0.005096);
 glNormal3f(-0.218750, 0.931641, 0.289551);
 glVertex3f(1.262558, 0.261141, 0.005096);
 glNormal3f(0.080078, 0.891113, 0.446289);
 glVertex3f(1.278321, 0.259827, 0.005096);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.504883, 0.661621, 0.554199);
 glVertex3f(1.263872, 0.267709, 0.005096);
 glNormal3f(0.603516, 0.562500, 0.564453);
 glVertex3f(1.293428, 0.265082, 0.005096);
 glNormal3f(0.731445, 0.681641, 0.000000);
 glVertex3f(1.293428, 0.265082, -0.015921);
 glNormal3f(0.758301, 0.637207, -0.137207);
 glVertex3f(1.293428, 0.265082, -0.029714);
 glNormal3f(-0.633301, 0.761230, -0.138672);
 glVertex3f(1.263872, 0.267709, -0.029714);
 glNormal3f(-0.606445, 0.794922, 0.000000);
 glVertex3f(1.263872, 0.267709, -0.015921);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.395508, 0.665527, -0.633301);
 glVertex3f(1.254019, 0.256543, -0.023146);
 glNormal3f(-0.270020, 0.914551, -0.300781);
 glVertex3f(1.253363, 0.250632, -0.027744);
 glNormal3f(-0.512695, 0.601562, -0.612793);
 glVertex3f(1.253363, 0.250632, 0.006410);
 glNormal3f(-0.766113, 0.483398, -0.424316);
 glVertex3f(1.253363, 0.256543, 0.006410);
 glNormal3f(-0.661621, 0.714844, -0.226074);
 glVertex3f(1.254019, 0.261798, -0.015921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.382324, 0.800781, -0.461426);
 glVertex3f(1.262558, 0.263768, -0.038909);
 glNormal3f(0.518555, 0.719727, -0.461426);
 glVertex3f(1.293428, 0.261141, -0.038909);
 glNormal3f(0.752930, 0.383301, -0.534668);
 glVertex3f(1.292771, 0.255886, -0.045477);
 glNormal3f(-0.680176, 0.500488, -0.535645);
 glVertex3f(1.262558, 0.258514, -0.045477);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.647461, 0.733398, -0.207031);
 glVertex3f(1.262558, 0.261141, -0.015921);
 glNormal3f(-0.633301, 0.761230, -0.138672);
 glVertex3f(1.263872, 0.267709, -0.029714);
 glNormal3f(-0.382324, 0.800781, -0.461426);
 glVertex3f(1.262558, 0.263768, -0.038909);
 glNormal3f(-0.680176, 0.500488, -0.535645);
 glVertex3f(1.262558, 0.258514, -0.045477);
 glNormal3f(-0.678711, 0.541504, -0.496094);
 glVertex3f(1.262558, 0.255886, -0.023146);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.661621, 0.714844, -0.226074);
 glVertex3f(1.254019, 0.261798, -0.015921);
 glNormal3f(-0.647461, 0.733398, -0.207031);
 glVertex3f(1.262558, 0.261141, -0.015921);
 glNormal3f(-0.678711, 0.541504, -0.496094);
 glVertex3f(1.262558, 0.255886, -0.023146);
 glNormal3f(-0.395508, 0.665527, -0.633301);
 glVertex3f(1.254019, 0.256543, -0.023146);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.289062, -0.011719, 0.957031);
 glVertex3f(1.269783, 0.259170, 0.041221);
 glNormal3f(-0.021973, -0.300781, 0.953125);
 glVertex3f(1.278321, 0.258514, 0.041877);
 glNormal3f(0.084961, 0.959473, 0.267578);
 glVertex3f(1.278321, 0.263111, 0.039250);
 glNormal3f(-0.189941, 0.815430, 0.546387);
 glVertex3f(1.270440, 0.263768, 0.038593);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.678711, 0.541504, -0.496094);
 glVertex3f(1.262558, 0.255886, -0.023146);
 glNormal3f(-0.680176, 0.500488, -0.535645);
 glVertex3f(1.262558, 0.258514, -0.045477);
 glNormal3f(-0.192871, 0.954102, -0.229004);
 glVertex3f(1.262558, 0.249975, -0.050732);
 glNormal3f(-0.439941, 0.806152, -0.395996);
 glVertex3f(1.262558, 0.249975, -0.027744);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.395508, 0.665527, -0.633301);
 glVertex3f(1.254019, 0.256543, -0.023146);
 glNormal3f(-0.678711, 0.541504, -0.496094);
 glVertex3f(1.262558, 0.255886, -0.023146);
 glNormal3f(-0.439941, 0.806152, -0.395996);
 glVertex3f(1.262558, 0.249975, -0.027744);
 glNormal3f(-0.270020, 0.914551, -0.300781);
 glVertex3f(1.253363, 0.250632, -0.027744);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.716309, 0.584473, 0.381348);
 glVertex3f(1.253363, 0.256543, 0.028085);
 glNormal3f(-0.302246, 0.946289, 0.111816);
 glVertex3f(1.254019, 0.261798, 0.028085);
 glNormal3f(-0.661621, 0.714844, -0.226074);
 glVertex3f(1.254019, 0.261798, -0.015921);
 glNormal3f(-0.766113, 0.483398, -0.424316);
 glVertex3f(1.253363, 0.256543, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.333984, 0.914551, -0.227051);
 glVertex3f(1.291457, 0.247348, -0.050732);
 glNormal3f(-0.192871, 0.954102, -0.229004);
 glVertex3f(1.262558, 0.249975, -0.050732);
 glNormal3f(-0.680176, 0.500488, -0.535645);
 glVertex3f(1.262558, 0.258514, -0.045477);
 glNormal3f(0.752930, 0.383301, -0.534668);
 glVertex3f(1.292771, 0.255886, -0.045477);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.647461, 0.733398, -0.207031);
 glVertex3f(1.262558, 0.261141, -0.015921);
 glNormal3f(-0.661621, 0.714844, -0.226074);
 glVertex3f(1.254019, 0.261798, -0.015921);
 glNormal3f(-0.302246, 0.946289, 0.111816);
 glVertex3f(1.254019, 0.261798, 0.028085);
 glNormal3f(-0.218750, 0.931641, 0.289551);
 glVertex3f(1.262558, 0.261141, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.467285, 0.670898, -0.575684);
 glVertex3f(1.229061, 0.253259, 0.006410);
 glNormal3f(-0.222656, 0.477051, -0.850098);
 glVertex3f(1.229718, 0.258514, 0.006410);
 glNormal3f(-0.766113, 0.483398, -0.424316);
 glVertex3f(1.253363, 0.256543, 0.006410);
 glNormal3f(-0.512695, 0.601562, -0.612793);
 glVertex3f(1.253363, 0.250632, 0.006410);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.228027, 0.739746, 0.632812);
 glVertex3f(1.245481, 0.257200, 0.039250);
 glNormal3f(-0.716309, 0.584473, 0.381348);
 glVertex3f(1.253363, 0.256543, 0.028085);
 glNormal3f(-0.766113, 0.483398, -0.424316);
 glVertex3f(1.253363, 0.256543, 0.006410);
 glNormal3f(-0.222656, 0.477051, -0.850098);
 glVertex3f(1.229718, 0.258514, 0.006410);
 glNormal3f(-0.613281, 0.498535, -0.612793);
 glVertex3f(1.220523, 0.259170, 0.012321);
 glNormal3f(-0.813477, 0.531738, -0.236816);
 glVertex3f(1.217239, 0.259827, 0.019546);
 glNormal3f(-0.755859, 0.558105, 0.341797);
 glVertex3f(1.217239, 0.259827, 0.028085);
 glNormal3f(-0.375000, 0.505371, 0.776855);
 glVertex3f(1.224463, 0.259170, 0.034653);
 glNormal3f(-0.148438, 0.462402, 0.874023);
 glVertex3f(1.233002, 0.258514, 0.036623);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.614258, 0.765625, -0.190918);
 glVertex3f(1.255990, 0.250632, -0.061241);
 glNormal3f(-0.580078, 0.770508, -0.264160);
 glVertex3f(1.254019, 0.250632, -0.046791);
 glNormal3f(-0.192871, 0.954102, -0.229004);
 glVertex3f(1.262558, 0.249975, -0.050732);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.439941, 0.806152, -0.395996);
 glVertex3f(1.262558, 0.249975, -0.027744);
 glNormal3f(-0.192871, 0.954102, -0.229004);
 glVertex3f(1.262558, 0.249975, -0.050732);
 glNormal3f(-0.580078, 0.770508, -0.264160);
 glVertex3f(1.254019, 0.250632, -0.046791);
 glNormal3f(-0.416504, 0.742188, -0.524902);
 glVertex3f(1.247452, 0.251289, -0.038253);
 glNormal3f(-0.270020, 0.914551, -0.300781);
 glVertex3f(1.253363, 0.250632, -0.027744);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.597168, 0.507812, -0.621094);
 glVertex3f(1.223807, 0.253259, -0.021832);
 glNormal3f(-0.808594, 0.526855, -0.262695);
 glVertex3f(1.218552, 0.253916, -0.013294);
 glNormal3f(-0.801270, 0.548340, 0.238770);
 glVertex3f(1.218552, 0.253916, -0.002128);
 glNormal3f(-0.464844, 0.533691, 0.706055);
 glVertex3f(1.223807, 0.253259, 0.005096);
 glNormal3f(-0.467285, 0.670898, -0.575684);
 glVertex3f(1.229061, 0.253259, 0.006410);
 glNormal3f(-0.512695, 0.601562, -0.612793);
 glVertex3f(1.253363, 0.250632, 0.006410);
 glNormal3f(-0.270020, 0.914551, -0.300781);
 glVertex3f(1.253363, 0.250632, -0.027744);
 glNormal3f(-0.416504, 0.742188, -0.524902);
 glVertex3f(1.247452, 0.251289, -0.038253);
 glNormal3f(-0.456055, 0.487793, -0.744629);
 glVertex3f(1.235629, 0.252602, -0.030371);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.196289, 0.479004, -0.855469);
 glVertex3f(1.268469, 0.249318, -0.074377);
 glNormal3f(-0.619629, 0.518555, -0.589844);
 glVertex3f(1.259274, 0.250632, -0.068465);
 glNormal3f(-0.614258, 0.765625, -0.190918);
 glVertex3f(1.255990, 0.250632, -0.061241);
 glNormal3f(-0.192871, 0.954102, -0.229004);
 glVertex3f(1.262558, 0.249975, -0.050732);
 glNormal3f(0.333984, 0.914551, -0.227051);
 glVertex3f(1.291457, 0.247348, -0.050732);
 glNormal3f(0.730469, 0.657715, -0.183105);
 glVertex3f(1.298682, 0.247348, -0.061241);
 glNormal3f(0.699707, 0.414062, -0.581543);
 glVertex3f(1.295398, 0.247348, -0.068465);
 glNormal3f(0.280273, 0.447266, -0.849121);
 glVertex3f(1.285546, 0.248005, -0.074377);
 glNormal3f(0.038086, 0.445801, -0.894531);
 glVertex3f(1.277664, 0.248662, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.614258, 0.765625, -0.190918);
 glVertex3f(1.255990, 0.250632, -0.061241);
 glNormal3f(-0.619629, 0.518555, -0.589844);
 glVertex3f(1.259274, 0.250632, -0.068465);
 glNormal3f(-0.693359, -0.410645, -0.592773);
 glVertex3f(1.258617, 0.242750, -0.068465);
 glNormal3f(-0.891113, -0.380371, -0.248535);
 glVertex3f(1.255333, 0.242750, -0.061241);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.580078, 0.770508, -0.264160);
 glVertex3f(1.254019, 0.250632, -0.046791);
 glNormal3f(-0.614258, 0.765625, -0.190918);
 glVertex3f(1.255990, 0.250632, -0.061241);
 glNormal3f(-0.891113, -0.380371, -0.248535);
 glVertex3f(1.255333, 0.242750, -0.061241);
 glNormal3f(-0.685547, -0.671875, -0.281738);
 glVertex3f(1.253363, 0.243407, -0.046791);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.416504, 0.742188, -0.524902);
 glVertex3f(1.247452, 0.251289, -0.038253);
 glNormal3f(-0.580078, 0.770508, -0.264160);
 glVertex3f(1.254019, 0.250632, -0.046791);
 glNormal3f(-0.685547, -0.671875, -0.281738);
 glVertex3f(1.253363, 0.243407, -0.046791);
 glNormal3f(-0.431641, -0.801270, -0.415039);
 glVertex3f(1.246795, 0.243407, -0.038253);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.456055, 0.487793, -0.744629);
 glVertex3f(1.235629, 0.252602, -0.030371);
 glNormal3f(-0.416504, 0.742188, -0.524902);
 glVertex3f(1.247452, 0.251289, -0.038253);
 glNormal3f(-0.431641, -0.801270, -0.415039);
 glVertex3f(1.246795, 0.243407, -0.038253);
 glNormal3f(-0.545898, -0.398926, -0.737305);
 glVertex3f(1.234972, 0.244721, -0.030371);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.597168, 0.507812, -0.621094);
 glVertex3f(1.223807, 0.253259, -0.021832);
 glNormal3f(-0.456055, 0.487793, -0.744629);
 glVertex3f(1.235629, 0.252602, -0.030371);
 glNormal3f(-0.545898, -0.398926, -0.737305);
 glVertex3f(1.234972, 0.244721, -0.030371);
 glNormal3f(-0.690918, -0.393555, -0.607422);
 glVertex3f(1.222493, 0.245378, -0.021832);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.808594, 0.526855, -0.262695);
 glVertex3f(1.218552, 0.253916, -0.013294);
 glNormal3f(-0.597168, 0.507812, -0.621094);
 glVertex3f(1.223807, 0.253259, -0.021832);
 glNormal3f(-0.690918, -0.393555, -0.607422);
 glVertex3f(1.222493, 0.245378, -0.021832);
 glNormal3f(-0.891602, -0.390137, -0.231934);
 glVertex3f(1.217895, 0.246034, -0.013294);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.801270, 0.548340, 0.238770);
 glVertex3f(1.218552, 0.253916, -0.002128);
 glNormal3f(-0.808594, 0.526855, -0.262695);
 glVertex3f(1.218552, 0.253916, -0.013294);
 glNormal3f(-0.891602, -0.390137, -0.231934);
 glVertex3f(1.217895, 0.246034, -0.013294);
 glNormal3f(-0.885742, -0.375488, 0.274414);
 glVertex3f(1.217895, 0.246034, -0.002128);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.464844, 0.533691, 0.706055);
 glVertex3f(1.223807, 0.253259, 0.005096);
 glNormal3f(-0.801270, 0.548340, 0.238770);
 glVertex3f(1.218552, 0.253916, -0.002128);
 glNormal3f(-0.885742, -0.375488, 0.274414);
 glVertex3f(1.217895, 0.246034, -0.002128);
 glNormal3f(-0.539551, -0.409668, 0.735352);
 glVertex3f(1.222493, 0.246034, 0.005096);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.467285, 0.670898, -0.575684);
 glVertex3f(1.229061, 0.253259, 0.006410);
 glNormal3f(-0.464844, 0.533691, 0.706055);
 glVertex3f(1.223807, 0.253259, 0.005096);
 glNormal3f(-0.539551, -0.409668, 0.735352);
 glVertex3f(1.222493, 0.246034, 0.005096);
 glNormal3f(-0.338379, -0.939941, 0.045410);
 glVertex3f(1.228404, 0.245378, 0.006410);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.338379, -0.939941, 0.045410);
 glVertex3f(1.228404, 0.245378, 0.006410);
 glNormal3f(-0.685059, -0.412109, -0.601562);
 glVertex3f(1.220523, 0.246034, 0.012321);
 glNormal3f(-0.613281, 0.498535, -0.612793);
 glVertex3f(1.220523, 0.259170, 0.012321);
 glNormal3f(-0.222656, 0.477051, -0.850098);
 glVertex3f(1.229718, 0.258514, 0.006410);
 glNormal3f(-0.467285, 0.670898, -0.575684);
 glVertex3f(1.229061, 0.253259, 0.006410);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.813477, 0.531738, -0.236816);
 glVertex3f(1.217239, 0.259827, 0.019546);
 glNormal3f(-0.613281, 0.498535, -0.612793);
 glVertex3f(1.220523, 0.259170, 0.012321);
 glNormal3f(-0.685059, -0.412109, -0.601562);
 glVertex3f(1.220523, 0.246034, 0.012321);
 glNormal3f(-0.892578, -0.388184, -0.230957);
 glVertex3f(1.215925, 0.246034, 0.019546);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.755859, 0.558105, 0.341797);
 glVertex3f(1.217239, 0.259827, 0.028085);
 glNormal3f(-0.813477, 0.531738, -0.236816);
 glVertex3f(1.217239, 0.259827, 0.019546);
 glNormal3f(-0.892578, -0.388184, -0.230957);
 glVertex3f(1.215925, 0.246034, 0.019546);
 glNormal3f(-0.848145, -0.394531, 0.353516);
 glVertex3f(1.215925, 0.246034, 0.028085);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.375000, 0.505371, 0.776855);
 glVertex3f(1.224463, 0.259170, 0.034653);
 glNormal3f(-0.755859, 0.558105, 0.341797);
 glVertex3f(1.217239, 0.259827, 0.028085);
 glNormal3f(-0.848145, -0.394531, 0.353516);
 glVertex3f(1.215925, 0.246034, 0.028085);
 glNormal3f(-0.455566, -0.412109, 0.789062);
 glVertex3f(1.222493, 0.246034, 0.034653);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.148438, 0.462402, 0.874023);
 glVertex3f(1.233002, 0.258514, 0.036623);
 glNormal3f(-0.375000, 0.505371, 0.776855);
 glVertex3f(1.224463, 0.259170, 0.034653);
 glNormal3f(-0.455566, -0.412109, 0.789062);
 glVertex3f(1.222493, 0.246034, 0.034653);
 glNormal3f(-0.223145, -0.428711, 0.875488);
 glVertex3f(1.231688, 0.244721, 0.036623);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.228027, 0.739746, 0.632812);
 glVertex3f(1.245481, 0.257200, 0.039250);
 glNormal3f(-0.148438, 0.462402, 0.874023);
 glVertex3f(1.233002, 0.258514, 0.036623);
 glNormal3f(-0.223145, -0.428711, 0.875488);
 glVertex3f(1.231688, 0.244721, 0.036623);
 glNormal3f(-0.349121, -0.698730, 0.624512);
 glVertex3f(1.244824, 0.244064, 0.039250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.475098, 0.479492, 0.737793);
 glVertex3f(1.254019, 0.256543, 0.045818);
 glNormal3f(-0.228027, 0.739746, 0.632812);
 glVertex3f(1.245481, 0.257200, 0.039250);
 glNormal3f(-0.349121, -0.698730, 0.624512);
 glVertex3f(1.244824, 0.244064, 0.039250);
 glNormal3f(-0.548340, -0.422363, 0.721680);
 glVertex3f(1.253363, 0.243407, 0.045818);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.322754, 0.478516, 0.816406);
 glVertex3f(1.262558, 0.255886, 0.051073);
 glNormal3f(-0.475098, 0.479492, 0.737793);
 glVertex3f(1.254019, 0.256543, 0.045818);
 glNormal3f(-0.548340, -0.422363, 0.721680);
 glVertex3f(1.253363, 0.243407, 0.045818);
 glNormal3f(-0.402832, -0.430176, 0.808105);
 glVertex3f(1.261901, 0.242750, 0.051073);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.083984, 0.465332, 0.880859);
 glVertex3f(1.272410, 0.255230, 0.053700);
 glNormal3f(-0.322754, 0.478516, 0.816406);
 glVertex3f(1.262558, 0.255886, 0.051073);
 glNormal3f(-0.402832, -0.430176, 0.808105);
 glVertex3f(1.261901, 0.242750, 0.051073);
 glNormal3f(-0.166016, -0.444336, 0.880371);
 glVertex3f(1.270440, 0.241437, 0.053700);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.070312, 0.694824, 0.715332);
 glVertex3f(1.277664, 0.254573, 0.053700);
 glNormal3f(-0.083984, 0.465332, 0.880859);
 glVertex3f(1.272410, 0.255230, 0.053700);
 glNormal3f(-0.166016, -0.444336, 0.880371);
 glVertex3f(1.270440, 0.241437, 0.053700);
 glNormal3f(-0.040527, -0.452637, 0.890625);
 glVertex3f(1.276351, 0.241437, 0.053700);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.196289, 0.479004, -0.855469);
 glVertex3f(1.268469, 0.249318, -0.074377);
 glNormal3f(0.038086, 0.445801, -0.894531);
 glVertex3f(1.277664, 0.248662, -0.074377);
 glNormal3f(-0.029297, -0.447266, -0.894531);
 glVertex3f(1.277008, 0.241437, -0.074377);
 glNormal3f(-0.266113, -0.440918, -0.857422);
 glVertex3f(1.268469, 0.242094, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.619629, 0.518555, -0.589844);
 glVertex3f(1.259274, 0.250632, -0.068465);
 glNormal3f(-0.196289, 0.479004, -0.855469);
 glVertex3f(1.268469, 0.249318, -0.074377);
 glNormal3f(-0.266113, -0.440918, -0.857422);
 glVertex3f(1.268469, 0.242094, -0.074377);
 glNormal3f(-0.693359, -0.410645, -0.592773);
 glVertex3f(1.258617, 0.242750, -0.068465);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.133789, 0.423828, 0.895508);
 glVertex3f(1.282919, 0.253916, 0.053700);
 glNormal3f(0.385742, 0.404297, 0.828613);
 glVertex3f(1.292771, 0.253259, 0.051729);
 glNormal3f(0.541504, 0.382324, 0.748047);
 glVertex3f(1.301309, 0.252602, 0.045818);
 glNormal3f(0.338867, 0.670410, 0.659668);
 glVertex3f(1.309848, 0.251946, 0.039907);
 glNormal3f(0.787598, 0.439453, 0.430664);
 glVertex3f(1.301966, 0.252602, 0.028741);
 glNormal3f(0.073242, 0.069336, 0.994629);
 glVertex3f(1.277664, 0.254573, 0.030055);
 glNormal3f(0.070312, 0.694824, 0.715332);
 glVertex3f(1.277664, 0.254573, 0.053700);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.213379, -0.472168, -0.855469);
 glVertex3f(1.285546, 0.240780, -0.074377);
 glNormal3f(0.633789, -0.507812, -0.583496);
 glVertex3f(1.294741, 0.239466, -0.068465);
 glNormal3f(0.818848, -0.519043, -0.244629);
 glVertex3f(1.298025, 0.239466, -0.061241);
 glNormal3f(0.596191, -0.762207, -0.252441);
 glVertex3f(1.299996, 0.239466, -0.046791);
 glNormal3f(-0.071289, -0.997559, -0.018555);
 glVertex3f(1.276351, 0.241437, -0.010010);
 glNormal3f(-0.685547, -0.671875, -0.281738);
 glVertex3f(1.253363, 0.243407, -0.046791);
 glNormal3f(-0.891113, -0.380371, -0.248535);
 glVertex3f(1.255333, 0.242750, -0.061241);
 glNormal3f(-0.693359, -0.410645, -0.592773);
 glVertex3f(1.258617, 0.242750, -0.068465);
 glNormal3f(-0.266113, -0.440918, -0.857422);
 glVertex3f(1.268469, 0.242094, -0.074377);
 glNormal3f(-0.029297, -0.447266, -0.894531);
 glVertex3f(1.277008, 0.241437, -0.074377);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.471680, 0.263184, 0.841309);
 glVertex3f(1.695147, 0.069030, 0.093081);
 glNormal3f(0.521973, 0.001465, 0.852539);
 glVertex3f(1.711583, 0.000000, 0.093081);
 glNormal3f(0.683594, 0.002441, 0.729492);
 glVertex3f(1.728019, 0.000000, 0.093081);
 glNormal3f(0.598633, 0.316895, 0.734863);
 glVertex3f(1.711583, 0.078892, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.037598, 0.003418, 0.999023);
 glVertex3f(0.298109, 0.000000, 0.227854);
 glNormal3f(0.041016, 0.278320, 0.959473);
 glVertex3f(0.307970, 0.095327, 0.208131);
 glNormal3f(0.056641, 0.255859, 0.964844);
 glVertex3f(0.133751, 0.092040, 0.217993);
 glNormal3f(0.047852, 0.002441, 0.998535);
 glVertex3f(0.130464, 0.000000, 0.234428);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.062500, 0.003418, 0.997559);
 glVertex3f(1.254669, 0.000000, 0.201557);
 glNormal3f(0.048340, 0.245605, 0.967773);
 glVertex3f(1.254669, 0.078892, 0.181834);
 glNormal3f(0.041016, 0.278320, 0.959473);
 glVertex3f(0.307970, 0.095327, 0.208131);
 glNormal3f(0.037598, 0.003418, 0.999023);
 glVertex3f(0.298109, 0.000000, 0.227854);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.288574, 0.005859, 0.957031);
 glVertex3f(1.662276, 0.000000, 0.158824);
 glNormal3f(0.235840, 0.208008, 0.948730);
 glVertex3f(1.632692, 0.069030, 0.155537);
 glNormal3f(0.070312, 0.176758, 0.981445);
 glVertex3f(1.445324, 0.075604, 0.168685);
 glNormal3f(0.088379, 0.003418, 0.995605);
 glVertex3f(1.445324, 0.000000, 0.178547);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.056641, 0.255859, 0.964844);
 glVertex3f(0.133751, 0.092040, 0.217993);
 glNormal3f(0.079102, 0.385742, 0.918945);
 glVertex3f(0.133751, 0.193942, 0.181834);
 glNormal3f(0.066406, 0.335938, 0.938965);
 glVertex3f(-0.066765, 0.207090, 0.191695);
 glNormal3f(0.050293, 0.224121, 0.973145);
 glVertex3f(-0.066765, 0.095327, 0.231141);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.041016, 0.278320, 0.959473);
 glVertex3f(0.307970, 0.095327, 0.208131);
 glNormal3f(0.054199, 0.439453, 0.895996);
 glVertex3f(0.307970, 0.187368, 0.168685);
 glNormal3f(0.079102, 0.385742, 0.918945);
 glVertex3f(0.133751, 0.193942, 0.181834);
 glNormal3f(0.056641, 0.255859, 0.964844);
 glVertex3f(0.133751, 0.092040, 0.217993);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.048340, 0.245605, 0.967773);
 glVertex3f(1.254669, 0.078892, 0.181834);
 glNormal3f(0.026367, 0.422363, 0.905762);
 glVertex3f(1.248095, 0.167645, 0.155537);
 glNormal3f(0.054199, 0.439453, 0.895996);
 glVertex3f(0.307970, 0.187368, 0.168685);
 glNormal3f(0.041016, 0.278320, 0.959473);
 glVertex3f(0.307970, 0.095327, 0.208131);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.070312, 0.176758, 0.981445);
 glVertex3f(1.445324, 0.075604, 0.168685);
 glNormal3f(0.168945, 0.421387, 0.890625);
 glVertex3f(1.547226, 0.157783, 0.145675);
 glNormal3f(0.052734, 0.305176, 0.950684);
 glVertex3f(1.445324, 0.164357, 0.152250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.079102, 0.385742, 0.918945);
 glVertex3f(0.133751, 0.193942, 0.181834);
 glNormal3f(0.146973, 0.611816, 0.776855);
 glVertex3f(0.140326, 0.236675, 0.162111);
 glNormal3f(0.129395, 0.499512, 0.855957);
 glVertex3f(-0.063478, 0.305705, 0.155537);
 glNormal3f(0.066406, 0.335938, 0.938965);
 glVertex3f(-0.066765, 0.207090, 0.191695);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.054199, 0.439453, 0.895996);
 glVertex3f(0.307970, 0.187368, 0.168685);
 glNormal3f(0.081543, 0.729980, 0.677734);
 glVertex3f(0.314545, 0.216952, 0.148962);
 glNormal3f(0.146973, 0.611816, 0.776855);
 glVertex3f(0.140326, 0.236675, 0.162111);
 glNormal3f(0.079102, 0.385742, 0.918945);
 glVertex3f(0.133751, 0.193942, 0.181834);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.026367, 0.422363, 0.905762);
 glVertex3f(1.248095, 0.167645, 0.155537);
 glNormal3f(0.018555, 0.755371, 0.654297);
 glVertex3f(1.254669, 0.193942, 0.135814);
 glNormal3f(0.081543, 0.729980, 0.677734);
 glVertex3f(0.314545, 0.216952, 0.148962);
 glNormal3f(0.054199, 0.439453, 0.895996);
 glVertex3f(0.307970, 0.187368, 0.168685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.168945, 0.421387, 0.890625);
 glVertex3f(1.547226, 0.157783, 0.145675);
 glNormal3f(0.372559, 0.798828, 0.471680);
 glVertex3f(1.570236, 0.167645, 0.129239);
 glNormal3f(0.145020, 0.931641, 0.332520);
 glVertex3f(1.474908, 0.193942, 0.122665);
 glNormal3f(0.099609, 0.680664, 0.725098);
 glVertex3f(1.474908, 0.190655, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.032715, 0.213867, 0.976074);
 glVertex3f(-0.540114, 0.105189, 0.247577);
 glNormal3f(-0.009277, 0.211426, 0.977051);
 glVertex3f(-0.796512, 0.111763, 0.254151);
 glNormal3f(-0.020996, 0.000488, 0.999512);
 glVertex3f(-0.809661, 0.000000, 0.267300);
 glNormal3f(0.034180, 0.000977, 0.999023);
 glVertex3f(-0.546689, 0.000000, 0.257438);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.020996, 0.000488, 0.999512);
 glVertex3f(-0.809661, 0.000000, 0.267300);
 glNormal3f(-0.009277, 0.211426, 0.977051);
 glVertex3f(-0.796512, 0.111763, 0.254151);
 glNormal3f(-0.057129, 0.176270, 0.982422);
 glVertex3f(-0.951008, 0.115050, 0.244290);
 glNormal3f(-0.080566, 0.000488, 0.996582);
 glVertex3f(-0.957582, 0.000000, 0.254151);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.124512, 0.000977, 0.992188);
 glVertex3f(-1.105504, 0.000000, 0.241003);
 glNormal3f(-0.104492, 0.124023, 0.986328);
 glVertex3f(-1.102217, 0.118337, 0.231141);
 glNormal3f(-0.166992, 0.074707, 0.982910);
 glVertex3f(-1.355327, 0.108476, 0.191695);
 glNormal3f(-0.177734, 0.000488, 0.983887);
 glVertex3f(-1.358615, 0.000000, 0.198270);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.177734, 0.000488, 0.983887);
 glVertex3f(-1.358615, 0.000000, 0.198270);
 glNormal3f(-0.166992, 0.074707, 0.982910);
 glVertex3f(-1.355327, 0.108476, 0.191695);
 glNormal3f(-0.365723, 0.061035, 0.928711);
 glVertex3f(-1.542695, 0.105189, 0.158824);
 glNormal3f(-0.354980, 0.000000, 0.934570);
 glVertex3f(-1.539408, 0.000000, 0.158824);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.354980, 0.000000, 0.934570);
 glVertex3f(-1.539408, 0.000000, 0.158824);
 glNormal3f(-0.365723, 0.061035, 0.928711);
 glVertex3f(-1.542695, 0.105189, 0.158824);
 glNormal3f(-0.746094, 0.092285, 0.659668);
 glVertex3f(-1.578854, 0.105189, 0.132527);
 glNormal3f(-0.729980, 0.000488, 0.683594);
 glVertex3f(-1.582141, 0.000000, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.729980, 0.000488, 0.683594);
 glVertex3f(-1.582141, 0.000000, 0.139101);
 glNormal3f(-0.746094, 0.092285, 0.659668);
 glVertex3f(-1.578854, 0.105189, 0.132527);
 glNormal3f(-0.533203, 0.062988, 0.843262);
 glVertex3f(-1.598577, 0.108476, 0.093081);
 glNormal3f(-0.524902, 0.000000, 0.851074);
 glVertex3f(-1.605151, 0.000000, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.668457, 0.001953, 0.743652);
 glVertex3f(-1.618299, 0.000000, 0.093081);
 glNormal3f(-0.668457, 0.093750, 0.737793);
 glVertex3f(-1.611725, 0.095327, 0.093081);
 glNormal3f(-0.990723, 0.138184, -0.000488);
 glVertex3f(-1.618299, 0.095327, -0.002246);
 glNormal3f(-1.000000, 0.002441, -0.000488);
 glVertex3f(-1.631448, 0.000000, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.066406, 0.335938, 0.938965);
 glVertex3f(-0.066765, 0.207090, 0.191695);
 glNormal3f(0.034180, 0.325684, 0.944336);
 glVertex3f(-0.313301, 0.213665, 0.204844);
 glNormal3f(0.037598, 0.210938, 0.976562);
 glVertex3f(-0.313301, 0.105189, 0.237715);
 glNormal3f(0.050293, 0.224121, 0.973145);
 glVertex3f(-0.066765, 0.095327, 0.231141);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.034180, 0.325684, 0.944336);
 glVertex3f(-0.313301, 0.213665, 0.204844);
 glNormal3f(0.026855, 0.337891, 0.940430);
 glVertex3f(-0.536827, 0.216952, 0.208131);
 glNormal3f(0.032715, 0.213867, 0.976074);
 glVertex3f(-0.540114, 0.105189, 0.247577);
 glNormal3f(0.037598, 0.210938, 0.976562);
 glVertex3f(-0.313301, 0.105189, 0.237715);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.025391, 0.320312, 0.946777);
 glVertex3f(-0.789938, 0.223526, 0.214705);
 glNormal3f(-0.009277, 0.211426, 0.977051);
 glVertex3f(-0.796512, 0.111763, 0.254151);
 glNormal3f(0.032715, 0.213867, 0.976074);
 glVertex3f(-0.540114, 0.105189, 0.247577);
 glNormal3f(0.026855, 0.337891, 0.940430);
 glVertex3f(-0.536827, 0.216952, 0.208131);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.661133, 0.174805, 0.729492);
 glVertex3f(-1.588715, 0.220239, 0.093081);
 glNormal3f(-0.966797, 0.255371, 0.000000);
 glVertex3f(-1.598577, 0.210378, -0.002246);
 glNormal3f(-0.990723, 0.138184, -0.000488);
 glVertex3f(-1.618299, 0.095327, -0.002246);
 glNormal3f(-0.668457, 0.093750, 0.737793);
 glVertex3f(-1.611725, 0.095327, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.534668, 0.151855, 0.831055);
 glVertex3f(-1.575567, 0.223526, 0.093081);
 glNormal3f(-0.661133, 0.174805, 0.729492);
 glVertex3f(-1.588715, 0.220239, 0.093081);
 glNormal3f(-0.668457, 0.093750, 0.737793);
 glVertex3f(-1.611725, 0.095327, 0.093081);
 glNormal3f(-0.533203, 0.062988, 0.843262);
 glVertex3f(-1.598577, 0.108476, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.750488, 0.224121, 0.621582);
 glVertex3f(-1.562418, 0.223526, 0.129239);
 glNormal3f(-0.534668, 0.151855, 0.831055);
 glVertex3f(-1.575567, 0.223526, 0.093081);
 glNormal3f(-0.533203, 0.062988, 0.843262);
 glVertex3f(-1.598577, 0.108476, 0.093081);
 glNormal3f(-0.746094, 0.092285, 0.659668);
 glVertex3f(-1.578854, 0.105189, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.746094, 0.092285, 0.659668);
 glVertex3f(-1.578854, 0.105189, 0.132527);
 glNormal3f(-0.365723, 0.061035, 0.928711);
 glVertex3f(-1.542695, 0.105189, 0.158824);
 glNormal3f(-0.375488, 0.134766, 0.916504);
 glVertex3f(-1.526259, 0.220239, 0.152250);
 glNormal3f(-0.750488, 0.224121, 0.621582);
 glVertex3f(-1.562418, 0.223526, 0.129239);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.166992, 0.074707, 0.982910);
 glVertex3f(-1.355327, 0.108476, 0.191695);
 glNormal3f(-0.142578, 0.128418, 0.980957);
 glVertex3f(-1.355327, 0.216952, 0.185121);
 glNormal3f(-0.375488, 0.134766, 0.916504);
 glVertex3f(-1.526259, 0.220239, 0.152250);
 glNormal3f(-0.365723, 0.061035, 0.928711);
 glVertex3f(-1.542695, 0.105189, 0.158824);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.104492, 0.124023, 0.986328);
 glVertex3f(-1.102217, 0.118337, 0.231141);
 glNormal3f(-0.061035, 0.197754, 0.978027);
 glVertex3f(-1.095643, 0.226813, 0.214705);
 glNormal3f(-0.142578, 0.128418, 0.980957);
 glVertex3f(-1.355327, 0.216952, 0.185121);
 glNormal3f(-0.166992, 0.074707, 0.982910);
 glVertex3f(-1.355327, 0.108476, 0.191695);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.009277, 0.211426, 0.977051);
 glVertex3f(-0.796512, 0.111763, 0.254151);
 glNormal3f(0.025391, 0.320312, 0.946777);
 glVertex3f(-0.789938, 0.223526, 0.214705);
 glNormal3f(0.001465, 0.261719, 0.964844);
 glVertex3f(-0.941147, 0.223526, 0.214705);
 glNormal3f(-0.057129, 0.176270, 0.982422);
 glVertex3f(-0.951008, 0.115050, 0.244290);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.506836, 0.248535, 0.825195);
 glVertex3f(-1.532834, 0.335289, 0.093081);
 glNormal3f(-0.620117, 0.319336, 0.716309);
 glVertex3f(-1.545982, 0.345151, 0.093081);
 glNormal3f(-0.661133, 0.174805, 0.729492);
 glVertex3f(-1.588715, 0.220239, 0.093081);
 glNormal3f(-0.534668, 0.151855, 0.831055);
 glVertex3f(-1.575567, 0.223526, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.889160, 0.458008, 0.000000);
 glVertex3f(-1.552556, 0.335289, -0.002246);
 glNormal3f(-0.966797, 0.255371, 0.000000);
 glVertex3f(-1.598577, 0.210378, -0.002246);
 glNormal3f(-0.661133, 0.174805, 0.729492);
 glVertex3f(-1.588715, 0.220239, 0.093081);
 glNormal3f(-0.620117, 0.319336, 0.716309);
 glVertex3f(-1.545982, 0.345151, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.421387, 0.363281, 0.830566);
 glVertex3f(-1.493388, 0.397745, 0.093081);
 glNormal3f(-0.497070, 0.498047, 0.710449);
 glVertex3f(-1.503249, 0.407607, 0.093081);
 glNormal3f(-0.620117, 0.319336, 0.716309);
 glVertex3f(-1.545982, 0.345151, 0.093081);
 glNormal3f(-0.506836, 0.248535, 0.825195);
 glVertex3f(-1.532834, 0.335289, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.506836, 0.248535, 0.825195);
 glVertex3f(-1.532834, 0.335289, 0.093081);
 glNormal3f(-0.732422, 0.351074, 0.583496);
 glVertex3f(-1.522972, 0.325428, 0.122665);
 glNormal3f(-0.623047, 0.528809, 0.575684);
 glVertex3f(-1.490101, 0.384596, 0.122665);
 glNormal3f(-0.421387, 0.363281, 0.830566);
 glVertex3f(-1.493388, 0.397745, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.534668, 0.151855, 0.831055);
 glVertex3f(-1.575567, 0.223526, 0.093081);
 glNormal3f(-0.750488, 0.224121, 0.621582);
 glVertex3f(-1.562418, 0.223526, 0.129239);
 glNormal3f(-0.732422, 0.351074, 0.583496);
 glVertex3f(-1.522972, 0.325428, 0.122665);
 glNormal3f(-0.506836, 0.248535, 0.825195);
 glVertex3f(-1.532834, 0.335289, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.375488, 0.134766, 0.916504);
 glVertex3f(-1.526259, 0.220239, 0.152250);
 glNormal3f(-0.397949, 0.185059, 0.898438);
 glVertex3f(-1.496675, 0.305705, 0.148962);
 glNormal3f(-0.732422, 0.351074, 0.583496);
 glVertex3f(-1.522972, 0.325428, 0.122665);
 glNormal3f(-0.750488, 0.224121, 0.621582);
 glVertex3f(-1.562418, 0.223526, 0.129239);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.329590, 0.286133, 0.899414);
 glVertex3f(-1.473665, 0.361586, 0.148962);
 glNormal3f(-0.623047, 0.528809, 0.575684);
 glVertex3f(-1.490101, 0.384596, 0.122665);
 glNormal3f(-0.732422, 0.351074, 0.583496);
 glVertex3f(-1.522972, 0.325428, 0.122665);
 glNormal3f(-0.397949, 0.185059, 0.898438);
 glVertex3f(-1.496675, 0.305705, 0.148962);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.142578, 0.128418, 0.980957);
 glVertex3f(-1.355327, 0.216952, 0.185121);
 glNormal3f(-0.329590, 0.286133, 0.899414);
 glVertex3f(-1.473665, 0.361586, 0.148962);
 glNormal3f(-0.397949, 0.185059, 0.898438);
 glVertex3f(-1.496675, 0.305705, 0.148962);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.375488, 0.134766, 0.916504);
 glVertex3f(-1.526259, 0.220239, 0.152250);
 glNormal3f(-0.142578, 0.128418, 0.980957);
 glVertex3f(-1.355327, 0.216952, 0.185121);
 glNormal3f(-0.397949, 0.185059, 0.898438);
 glVertex3f(-1.496675, 0.305705, 0.148962);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.112793, 0.374023, 0.920410);
 glVertex3f(-1.355327, 0.414181, 0.145675);
 glNormal3f(-0.168945, 0.733887, 0.657227);
 glVertex3f(-1.361902, 0.447052, 0.122665);
 glNormal3f(-0.368652, 0.693848, 0.618164);
 glVertex3f(-1.444080, 0.424042, 0.119378);
 glNormal3f(-0.213867, 0.441895, 0.871094);
 glVertex3f(-1.437506, 0.391171, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.015137, 0.553711, 0.832031);
 glVertex3f(-1.072633, 0.489785, 0.093081);
 glNormal3f(-0.107910, 0.517090, 0.848633);
 glVertex3f(-1.365189, 0.463488, 0.093081);
 glNormal3f(-0.168945, 0.733887, 0.657227);
 glVertex3f(-1.361902, 0.447052, 0.122665);
 glNormal3f(0.006348, 0.745117, 0.666016);
 glVertex3f(-1.072633, 0.470062, 0.148962);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.006348, 0.745117, 0.666016);
 glVertex3f(-1.072633, 0.470062, 0.148962);
 glNormal3f(-0.168945, 0.733887, 0.657227);
 glVertex3f(-1.361902, 0.447052, 0.122665);
 glNormal3f(-0.112793, 0.374023, 0.920410);
 glVertex3f(-1.355327, 0.414181, 0.145675);
 glNormal3f(-0.025391, 0.358887, 0.932617);
 glVertex3f(-1.079207, 0.437191, 0.165398);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.168945, 0.733887, 0.657227);
 glVertex3f(-1.361902, 0.447052, 0.122665);
 glNormal3f(-0.107910, 0.517090, 0.848633);
 glVertex3f(-1.365189, 0.463488, 0.093081);
 glNormal3f(-0.254883, 0.467773, 0.846191);
 glVertex3f(-1.444080, 0.437191, 0.093081);
 glNormal3f(-0.368652, 0.693848, 0.618164);
 glVertex3f(-1.444080, 0.424042, 0.119378);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.889160, 0.458008, 0.000000);
 glVertex3f(-1.552556, 0.335289, -0.002246);
 glNormal3f(-0.620117, 0.319336, 0.716309);
 glVertex3f(-1.545982, 0.345151, 0.093081);
 glNormal3f(-0.497070, 0.498047, 0.710449);
 glVertex3f(-1.503249, 0.407607, 0.093081);
 glNormal3f(-0.747070, 0.664551, 0.000000);
 glVertex3f(-1.503249, 0.404319, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.151855, 0.644531, 0.749023);
 glVertex3f(-1.371763, 0.473350, 0.093081);
 glNormal3f(0.020996, 0.643066, 0.765137);
 glVertex3f(-1.072633, 0.499647, 0.093081);
 glNormal3f(0.028320, 0.999512, 0.000000);
 glVertex3f(-1.072633, 0.519370, -0.002246);
 glNormal3f(-0.230469, 0.973145, 0.003906);
 glVertex3f(-1.352040, 0.489785, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.107910, 0.517090, 0.848633);
 glVertex3f(-1.365189, 0.463488, 0.093081);
 glNormal3f(0.015137, 0.553711, 0.832031);
 glVertex3f(-1.072633, 0.489785, 0.093081);
 glNormal3f(0.020996, 0.643066, 0.765137);
 glVertex3f(-1.072633, 0.499647, 0.093081);
 glNormal3f(-0.151855, 0.644531, 0.749023);
 glVertex3f(-1.371763, 0.473350, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.227051, 0.973633, -0.004395);
 glVertex3f(-0.921424, 0.493072, -0.002246);
 glNormal3f(0.150879, 0.638672, 0.753906);
 glVertex3f(-0.921424, 0.479924, 0.093081);
 glNormal3f(0.134277, 0.653320, 0.744629);
 glVertex3f(-0.770215, 0.433904, 0.093081);
 glNormal3f(0.201172, 0.979492, 0.000000);
 glVertex3f(-0.766928, 0.443765, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.254883, 0.467773, 0.846191);
 glVertex3f(-1.444080, 0.437191, 0.093081);
 glNormal3f(-0.107910, 0.517090, 0.848633);
 glVertex3f(-1.365189, 0.463488, 0.093081);
 glNormal3f(-0.151855, 0.644531, 0.749023);
 glVertex3f(-1.371763, 0.473350, 0.093081);
 glNormal3f(-0.325195, 0.615234, 0.717773);
 glVertex3f(-1.450655, 0.447052, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.151855, 0.644531, 0.749023);
 glVertex3f(-1.371763, 0.473350, 0.093081);
 glNormal3f(-0.230469, 0.973145, 0.003906);
 glVertex3f(-1.352040, 0.489785, -0.002246);
 glNormal3f(-0.430176, 0.902344, 0.000000);
 glVertex3f(-1.444080, 0.450339, -0.002246);
 glNormal3f(-0.325195, 0.615234, 0.717773);
 glVertex3f(-1.450655, 0.447052, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.027344, 0.673828, 0.737793);
 glVertex3f(-0.533540, 0.410894, 0.093081);
 glNormal3f(0.040527, 0.999023, 0.000000);
 glVertex3f(-0.530253, 0.417468, -0.002246);
 glNormal3f(0.201172, 0.979492, 0.000000);
 glVertex3f(-0.766928, 0.443765, -0.002246);
 glNormal3f(0.134277, 0.653320, 0.744629);
 glVertex3f(-0.770215, 0.433904, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.134277, 0.653320, 0.744629);
 glVertex3f(-0.770215, 0.433904, 0.093081);
 glNormal3f(0.112305, 0.572266, 0.812012);
 glVertex3f(-0.770215, 0.420755, 0.093081);
 glNormal3f(0.023438, 0.579102, 0.814453);
 glVertex3f(-0.533540, 0.397745, 0.093081);
 glNormal3f(0.027344, 0.673828, 0.737793);
 glVertex3f(-0.533540, 0.410894, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.150879, 0.638672, 0.753906);
 glVertex3f(-0.921424, 0.479924, 0.093081);
 glNormal3f(0.126465, 0.559570, 0.818359);
 glVertex3f(-0.921424, 0.466775, 0.093081);
 glNormal3f(0.112305, 0.572266, 0.812012);
 glVertex3f(-0.770215, 0.420755, 0.093081);
 glNormal3f(0.134277, 0.653320, 0.744629);
 glVertex3f(-0.770215, 0.433904, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.126465, 0.559570, 0.818359);
 glVertex3f(-0.921424, 0.466775, 0.093081);
 glNormal3f(0.176270, 0.743652, 0.644043);
 glVertex3f(-0.924711, 0.447052, 0.145675);
 glNormal3f(0.159180, 0.774902, 0.611328);
 glVertex3f(-0.780076, 0.407607, 0.139101);
 glNormal3f(0.112305, 0.572266, 0.812012);
 glVertex3f(-0.770215, 0.420755, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.176270, 0.743652, 0.644043);
 glVertex3f(-0.924711, 0.447052, 0.145675);
 glNormal3f(0.079590, 0.375977, 0.922852);
 glVertex3f(-0.931285, 0.417468, 0.162111);
 glNormal3f(0.083496, 0.432129, 0.897461);
 glVertex3f(-0.783363, 0.374735, 0.162111);
 glNormal3f(0.159180, 0.774902, 0.611328);
 glVertex3f(-0.780076, 0.407607, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.112793, 0.374023, 0.920410);
 glVertex3f(-1.355327, 0.414181, 0.145675);
 glNormal3f(-0.142578, 0.128418, 0.980957);
 glVertex3f(-1.355327, 0.216952, 0.185121);
 glNormal3f(-0.061035, 0.197754, 0.978027);
 glVertex3f(-1.095643, 0.226813, 0.214705);
 glNormal3f(-0.025391, 0.358887, 0.932617);
 glVertex3f(-1.079207, 0.437191, 0.165398);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.001465, 0.261719, 0.964844);
 glVertex3f(-0.941147, 0.223526, 0.214705);
 glNormal3f(0.025391, 0.320312, 0.946777);
 glVertex3f(-0.789938, 0.223526, 0.214705);
 glNormal3f(0.083496, 0.432129, 0.897461);
 glVertex3f(-0.783363, 0.374735, 0.162111);
 glNormal3f(0.079590, 0.375977, 0.922852);
 glVertex3f(-0.931285, 0.417468, 0.162111);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.026855, 0.337891, 0.940430);
 glVertex3f(-0.536827, 0.216952, 0.208131);
 glNormal3f(0.023926, 0.462891, 0.885742);
 glVertex3f(-0.533540, 0.364874, 0.145675);
 glNormal3f(0.083496, 0.432129, 0.897461);
 glVertex3f(-0.783363, 0.374735, 0.162111);
 glNormal3f(0.025391, 0.320312, 0.946777);
 glVertex3f(-0.789938, 0.223526, 0.214705);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.159180, 0.774902, 0.611328);
 glVertex3f(-0.780076, 0.407607, 0.139101);
 glNormal3f(0.083496, 0.432129, 0.897461);
 glVertex3f(-0.783363, 0.374735, 0.162111);
 glNormal3f(0.023926, 0.462891, 0.885742);
 glVertex3f(-0.533540, 0.364874, 0.145675);
 glNormal3f(0.033203, 0.794434, 0.605957);
 glVertex3f(-0.533540, 0.384596, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.033203, 0.794434, 0.605957);
 glVertex3f(-0.533540, 0.384596, 0.132527);
 glNormal3f(0.023438, 0.579102, 0.814453);
 glVertex3f(-0.533540, 0.397745, 0.093081);
 glNormal3f(0.112305, 0.572266, 0.812012);
 glVertex3f(-0.770215, 0.420755, 0.093081);
 glNormal3f(0.159180, 0.774902, 0.611328);
 glVertex3f(-0.780076, 0.407607, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.061523, 0.669922, 0.739258);
 glVertex3f(-0.310014, 0.414181, 0.093081);
 glNormal3f(0.091797, 0.995605, 0.000000);
 glVertex3f(-0.310014, 0.424042, -0.002246);
 glNormal3f(0.040527, 0.999023, 0.000000);
 glVertex3f(-0.530253, 0.417468, -0.002246);
 glNormal3f(0.027344, 0.673828, 0.737793);
 glVertex3f(-0.533540, 0.410894, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.027344, 0.673828, 0.737793);
 glVertex3f(-0.533540, 0.410894, 0.093081);
 glNormal3f(0.023438, 0.579102, 0.814453);
 glVertex3f(-0.533540, 0.397745, 0.093081);
 glNormal3f(0.055664, 0.562500, 0.824219);
 glVertex3f(-0.306727, 0.404319, 0.093081);
 glNormal3f(0.061523, 0.669922, 0.739258);
 glVertex3f(-0.310014, 0.414181, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.033203, 0.794434, 0.605957);
 glVertex3f(-0.533540, 0.384596, 0.132527);
 glNormal3f(0.077637, 0.788574, 0.609375);
 glVertex3f(-0.306727, 0.384596, 0.139101);
 glNormal3f(0.055664, 0.562500, 0.824219);
 glVertex3f(-0.306727, 0.404319, 0.093081);
 glNormal3f(0.023438, 0.579102, 0.814453);
 glVertex3f(-0.533540, 0.397745, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.023926, 0.462891, 0.885742);
 glVertex3f(-0.533540, 0.364874, 0.145675);
 glNormal3f(0.042969, 0.465332, 0.883789);
 glVertex3f(-0.306727, 0.361586, 0.155537);
 glNormal3f(0.077637, 0.788574, 0.609375);
 glVertex3f(-0.306727, 0.384596, 0.139101);
 glNormal3f(0.033203, 0.794434, 0.605957);
 glVertex3f(-0.533540, 0.384596, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.026855, 0.337891, 0.940430);
 glVertex3f(-0.536827, 0.216952, 0.208131);
 glNormal3f(0.034180, 0.325684, 0.944336);
 glVertex3f(-0.313301, 0.213665, 0.204844);
 glNormal3f(0.042969, 0.465332, 0.883789);
 glVertex3f(-0.306727, 0.361586, 0.155537);
 glNormal3f(0.023926, 0.462891, 0.885742);
 glVertex3f(-0.533540, 0.364874, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.034180, 0.325684, 0.944336);
 glVertex3f(-0.313301, 0.213665, 0.204844);
 glNormal3f(0.066406, 0.335938, 0.938965);
 glVertex3f(-0.066765, 0.207090, 0.191695);
 glNormal3f(0.129395, 0.499512, 0.855957);
 glVertex3f(-0.063478, 0.305705, 0.155537);
 glNormal3f(0.042969, 0.465332, 0.883789);
 glVertex3f(-0.306727, 0.361586, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.129395, 0.499512, 0.855957);
 glVertex3f(-0.063478, 0.305705, 0.155537);
 glNormal3f(0.229492, 0.795410, 0.560059);
 glVertex3f(-0.063478, 0.335289, 0.132527);
 glNormal3f(0.077637, 0.788574, 0.609375);
 glVertex3f(-0.306727, 0.384596, 0.139101);
 glNormal3f(0.042969, 0.465332, 0.883789);
 glVertex3f(-0.306727, 0.361586, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.229492, 0.795410, 0.560059);
 glVertex3f(-0.063478, 0.335289, 0.132527);
 glNormal3f(0.161621, 0.553711, 0.816406);
 glVertex3f(-0.076626, 0.351725, 0.093081);
 glNormal3f(0.055664, 0.562500, 0.824219);
 glVertex3f(-0.306727, 0.404319, 0.093081);
 glNormal3f(0.077637, 0.788574, 0.609375);
 glVertex3f(-0.306727, 0.384596, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.161621, 0.553711, 0.816406);
 glVertex3f(-0.076626, 0.351725, 0.093081);
 glNormal3f(0.172363, 0.646484, 0.742676);
 glVertex3f(-0.070052, 0.364874, 0.093081);
 glNormal3f(0.061523, 0.669922, 0.739258);
 glVertex3f(-0.310014, 0.414181, 0.093081);
 glNormal3f(0.055664, 0.562500, 0.824219);
 glVertex3f(-0.306727, 0.404319, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.172363, 0.646484, 0.742676);
 glVertex3f(-0.070052, 0.364874, 0.093081);
 glNormal3f(0.257324, 0.965820, 0.000000);
 glVertex3f(-0.079913, 0.374735, -0.002246);
 glNormal3f(0.091797, 0.995605, 0.000000);
 glVertex3f(-0.310014, 0.424042, -0.002246);
 glNormal3f(0.061523, 0.669922, 0.739258);
 glVertex3f(-0.310014, 0.414181, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.172363, 0.646484, 0.742676);
 glVertex3f(-0.070052, 0.364874, 0.093081);
 glNormal3f(0.166016, 0.618652, 0.767578);
 glVertex3f(0.137038, 0.292556, 0.093081);
 glNormal3f(0.258789, 0.965332, 0.000000);
 glVertex3f(0.127177, 0.312279, -0.002246);
 glNormal3f(0.257324, 0.965820, 0.000000);
 glVertex3f(-0.079913, 0.374735, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.161621, 0.553711, 0.816406);
 glVertex3f(-0.076626, 0.351725, 0.093081);
 glNormal3f(0.161621, 0.561523, 0.811035);
 glVertex3f(0.137038, 0.276121, 0.093081);
 glNormal3f(0.166016, 0.618652, 0.767578);
 glVertex3f(0.137038, 0.292556, 0.093081);
 glNormal3f(0.172363, 0.646484, 0.742676);
 glVertex3f(-0.070052, 0.364874, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.229492, 0.795410, 0.560059);
 glVertex3f(-0.063478, 0.335289, 0.132527);
 glNormal3f(0.231934, 0.852539, 0.467773);
 glVertex3f(0.140326, 0.256398, 0.139101);
 glNormal3f(0.161621, 0.561523, 0.811035);
 glVertex3f(0.137038, 0.276121, 0.093081);
 glNormal3f(0.161621, 0.553711, 0.816406);
 glVertex3f(-0.076626, 0.351725, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.129395, 0.499512, 0.855957);
 glVertex3f(-0.063478, 0.305705, 0.155537);
 glNormal3f(0.146973, 0.611816, 0.776855);
 glVertex3f(0.140326, 0.236675, 0.162111);
 glNormal3f(0.231934, 0.852539, 0.467773);
 glVertex3f(0.140326, 0.256398, 0.139101);
 glNormal3f(0.229492, 0.795410, 0.560059);
 glVertex3f(-0.063478, 0.335289, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.050293, 0.224121, 0.973145);
 glVertex3f(-0.066765, 0.095327, 0.231141);
 glNormal3f(0.037598, 0.210938, 0.976562);
 glVertex3f(-0.313301, 0.105189, 0.237715);
 glNormal3f(0.035645, 0.001465, 0.999023);
 glVertex3f(-0.316588, 0.000000, 0.250864);
 glNormal3f(0.042480, 0.001953, 0.999023);
 glVertex3f(-0.073339, 0.000000, 0.241003);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.042480, 0.001953, 0.999023);
 glVertex3f(-0.073339, 0.000000, 0.241003);
 glNormal3f(0.047852, 0.002441, 0.998535);
 glVertex3f(0.130464, 0.000000, 0.234428);
 glNormal3f(0.056641, 0.255859, 0.964844);
 glVertex3f(0.133751, 0.092040, 0.217993);
 glNormal3f(0.050293, 0.224121, 0.973145);
 glVertex3f(-0.066765, 0.095327, 0.231141);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.037598, 0.210938, 0.976562);
 glVertex3f(-0.313301, 0.105189, 0.237715);
 glNormal3f(0.032715, 0.213867, 0.976074);
 glVertex3f(-0.540114, 0.105189, 0.247577);
 glNormal3f(0.034180, 0.000977, 0.999023);
 glVertex3f(-0.546689, 0.000000, 0.257438);
 glNormal3f(0.035645, 0.001465, 0.999023);
 glVertex3f(-0.316588, 0.000000, 0.250864);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.166016, 0.618652, 0.767578);
 glVertex3f(0.137038, 0.292556, 0.093081);
 glNormal3f(0.072754, 0.609863, 0.788574);
 glVertex3f(0.324406, 0.246536, 0.093081);
 glNormal3f(0.118652, 0.992676, 0.000000);
 glVertex3f(0.311257, 0.279408, -0.002246);
 glNormal3f(0.258789, 0.965332, 0.000000);
 glVertex3f(0.127177, 0.312279, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.161621, 0.561523, 0.811035);
 glVertex3f(0.137038, 0.276121, 0.093081);
 glNormal3f(0.069824, 0.600586, 0.795898);
 glVertex3f(0.324406, 0.233388, 0.093081);
 glNormal3f(0.072754, 0.609863, 0.788574);
 glVertex3f(0.324406, 0.246536, 0.093081);
 glNormal3f(0.166016, 0.618652, 0.767578);
 glVertex3f(0.137038, 0.292556, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.231934, 0.852539, 0.467773);
 glVertex3f(0.140326, 0.256398, 0.139101);
 glNormal3f(0.103516, 0.925781, 0.362305);
 glVertex3f(0.321119, 0.226813, 0.119378);
 glNormal3f(0.069824, 0.600586, 0.795898);
 glVertex3f(0.324406, 0.233388, 0.093081);
 glNormal3f(0.161621, 0.561523, 0.811035);
 glVertex3f(0.137038, 0.276121, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.146973, 0.611816, 0.776855);
 glVertex3f(0.140326, 0.236675, 0.162111);
 glNormal3f(0.081543, 0.729980, 0.677734);
 glVertex3f(0.314545, 0.216952, 0.148962);
 glNormal3f(0.103516, 0.925781, 0.362305);
 glVertex3f(0.321119, 0.226813, 0.119378);
 glNormal3f(0.231934, 0.852539, 0.467773);
 glVertex3f(0.140326, 0.256398, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.072754, 0.609863, 0.788574);
 glVertex3f(0.324406, 0.246536, 0.093081);
 glNormal3f(0.030273, 0.632324, 0.773926);
 glVertex3f(1.261244, 0.226813, 0.093081);
 glNormal3f(0.048340, 0.998535, 0.000000);
 glVertex3f(1.248095, 0.243249, -0.002246);
 glNormal3f(0.118652, 0.992676, 0.000000);
 glVertex3f(0.311257, 0.279408, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.069824, 0.600586, 0.795898);
 glVertex3f(0.324406, 0.233388, 0.093081);
 glNormal3f(0.022461, 0.631348, 0.774414);
 glVertex3f(1.261244, 0.210378, 0.093081);
 glNormal3f(0.030273, 0.632324, 0.773926);
 glVertex3f(1.261244, 0.226813, 0.093081);
 glNormal3f(0.072754, 0.609863, 0.788574);
 glVertex3f(0.324406, 0.246536, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.103516, 0.925781, 0.362305);
 glVertex3f(0.321119, 0.226813, 0.119378);
 glNormal3f(0.027344, 0.948730, 0.313965);
 glVertex3f(1.257957, 0.207090, 0.112804);
 glNormal3f(0.022461, 0.631348, 0.774414);
 glVertex3f(1.261244, 0.210378, 0.093081);
 glNormal3f(0.069824, 0.600586, 0.795898);
 glVertex3f(0.324406, 0.233388, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.081543, 0.729980, 0.677734);
 glVertex3f(0.314545, 0.216952, 0.148962);
 glNormal3f(0.018555, 0.755371, 0.654297);
 glVertex3f(1.254669, 0.193942, 0.135814);
 glNormal3f(0.027344, 0.948730, 0.313965);
 glVertex3f(1.257957, 0.207090, 0.112804);
 glNormal3f(0.103516, 0.925781, 0.362305);
 glVertex3f(0.321119, 0.226813, 0.119378);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.312012, 0.608887, 0.729004);
 glVertex3f(1.589959, 0.180793, 0.093081);
 glNormal3f(0.456055, 0.889648, 0.000000);
 glVertex3f(1.596533, 0.180793, -0.002246);
 glNormal3f(0.192383, 0.980957, 0.000000);
 glVertex3f(1.474908, 0.226813, -0.002246);
 glNormal3f(0.127441, 0.650391, 0.748535);
 glVertex3f(1.474908, 0.213665, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.127441, 0.650391, 0.748535);
 glVertex3f(1.474908, 0.213665, 0.093081);
 glNormal3f(0.092773, 0.619629, 0.778809);
 glVertex3f(1.474908, 0.200516, 0.093081);
 glNormal3f(0.262207, 0.541016, 0.798828);
 glVertex3f(1.580097, 0.174219, 0.093081);
 glNormal3f(0.312012, 0.608887, 0.729004);
 glVertex3f(1.589959, 0.180793, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.092773, 0.619629, 0.778809);
 glVertex3f(1.474908, 0.200516, 0.093081);
 glNormal3f(0.145020, 0.931641, 0.332520);
 glVertex3f(1.474908, 0.193942, 0.122665);
 glNormal3f(0.372559, 0.798828, 0.471680);
 glVertex3f(1.570236, 0.167645, 0.129239);
 glNormal3f(0.262207, 0.541016, 0.798828);
 glVertex3f(1.580097, 0.174219, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.187988, 0.303711, 0.933594);
 glVertex3f(1.589959, 0.115050, 0.152250);
 glNormal3f(0.504883, 0.593262, 0.626465);
 glVertex3f(1.622830, 0.124912, 0.135814);
 glNormal3f(0.372559, 0.798828, 0.471680);
 glVertex3f(1.570236, 0.167645, 0.129239);
 glNormal3f(0.168945, 0.421387, 0.890625);
 glVertex3f(1.547226, 0.157783, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.288574, 0.005859, 0.957031);
 glVertex3f(1.662276, 0.000000, 0.158824);
 glNormal3f(0.724609, 0.005859, 0.688477);
 glVertex3f(1.691860, 0.000000, 0.139101);
 glNormal3f(0.625488, 0.384766, 0.677734);
 glVertex3f(1.668850, 0.069030, 0.139101);
 glNormal3f(0.235840, 0.208008, 0.948730);
 glVertex3f(1.632692, 0.069030, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.521973, 0.001465, 0.852539);
 glVertex3f(1.711583, 0.000000, 0.093081);
 glNormal3f(0.471680, 0.263184, 0.841309);
 glVertex3f(1.695147, 0.069030, 0.093081);
 glNormal3f(0.625488, 0.384766, 0.677734);
 glVertex3f(1.668850, 0.069030, 0.139101);
 glNormal3f(0.724609, 0.005859, 0.688477);
 glVertex3f(1.691860, 0.000000, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.504883, 0.593262, 0.626465);
 glVertex3f(1.622830, 0.124912, 0.135814);
 glNormal3f(0.393555, 0.425293, 0.814453);
 glVertex3f(1.639266, 0.128199, 0.093081);
 glNormal3f(0.262207, 0.541016, 0.798828);
 glVertex3f(1.580097, 0.174219, 0.093081);
 glNormal3f(0.372559, 0.798828, 0.471680);
 glVertex3f(1.570236, 0.167645, 0.129239);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.393555, 0.425293, 0.814453);
 glVertex3f(1.639266, 0.128199, 0.093081);
 glNormal3f(0.452148, 0.529785, 0.716797);
 glVertex3f(1.655702, 0.134773, 0.093081);
 glNormal3f(0.312012, 0.608887, 0.729004);
 glVertex3f(1.589959, 0.180793, 0.093081);
 glNormal3f(0.262207, 0.541016, 0.798828);
 glVertex3f(1.580097, 0.174219, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.452148, 0.529785, 0.716797);
 glVertex3f(1.655702, 0.134773, 0.093081);
 glNormal3f(0.648926, 0.760742, 0.000000);
 glVertex3f(1.662276, 0.131486, -0.002246);
 glNormal3f(0.456055, 0.889648, 0.000000);
 glVertex3f(1.596533, 0.180793, -0.002246);
 glNormal3f(0.312012, 0.608887, 0.729004);
 glVertex3f(1.589959, 0.180793, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.683594, 0.002441, 0.729492);
 glVertex3f(1.728019, 0.000000, 0.093081);
 glNormal3f(0.999512, 0.003418, 0.000000);
 glVertex3f(1.731306, 0.000000, -0.002246);
 glNormal3f(0.883301, 0.467773, 0.000000);
 glVertex3f(1.718157, 0.075604, -0.002246);
 glNormal3f(0.598633, 0.316895, 0.734863);
 glVertex3f(1.711583, 0.078892, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.088379, 0.003418, 0.995605);
 glVertex3f(1.445324, 0.000000, 0.178547);
 glNormal3f(0.070312, 0.176758, 0.981445);
 glVertex3f(1.445324, 0.075604, 0.168685);
 glNormal3f(0.048340, 0.245605, 0.967773);
 glVertex3f(1.254669, 0.078892, 0.181834);
 glNormal3f(0.062500, 0.003418, 0.997559);
 glVertex3f(1.254669, 0.000000, 0.201557);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.070312, 0.176758, 0.981445);
 glVertex3f(1.445324, 0.075604, 0.168685);
 glNormal3f(0.052734, 0.305176, 0.950684);
 glVertex3f(1.445324, 0.164357, 0.152250);
 glNormal3f(0.026367, 0.422363, 0.905762);
 glVertex3f(1.248095, 0.167645, 0.155537);
 glNormal3f(0.048340, 0.245605, 0.967773);
 glVertex3f(1.254669, 0.078892, 0.181834);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.145020, 0.931641, 0.332520);
 glVertex3f(1.474908, 0.193942, 0.122665);
 glNormal3f(0.092773, 0.619629, 0.778809);
 glVertex3f(1.474908, 0.200516, 0.093081);
 glNormal3f(0.022461, 0.631348, 0.774414);
 glVertex3f(1.261244, 0.210378, 0.093081);
 glNormal3f(0.027344, 0.948730, 0.313965);
 glVertex3f(1.257957, 0.207090, 0.112804);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.092773, 0.619629, 0.778809);
 glVertex3f(1.474908, 0.200516, 0.093081);
 glNormal3f(0.127441, 0.650391, 0.748535);
 glVertex3f(1.474908, 0.213665, 0.093081);
 glNormal3f(0.030273, 0.632324, 0.773926);
 glVertex3f(1.261244, 0.226813, 0.093081);
 glNormal3f(0.022461, 0.631348, 0.774414);
 glVertex3f(1.261244, 0.210378, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.127441, 0.650391, 0.748535);
 glVertex3f(1.474908, 0.213665, 0.093081);
 glNormal3f(0.192383, 0.980957, 0.000000);
 glVertex3f(1.474908, 0.226813, -0.002246);
 glNormal3f(0.048340, 0.998535, 0.000000);
 glVertex3f(1.248095, 0.243249, -0.002246);
 glNormal3f(0.030273, 0.632324, 0.773926);
 glVertex3f(1.261244, 0.226813, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.052734, 0.305176, 0.950684);
 glVertex3f(1.445324, 0.164357, 0.152250);
 glNormal3f(0.099609, 0.680664, 0.725098);
 glVertex3f(1.474908, 0.190655, 0.139101);
 glNormal3f(0.018555, 0.755371, 0.654297);
 glVertex3f(1.254669, 0.193942, 0.135814);
 glNormal3f(0.026367, 0.422363, 0.905762);
 glVertex3f(1.248095, 0.167645, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.099609, 0.680664, 0.725098);
 glVertex3f(1.474908, 0.190655, 0.139101);
 glNormal3f(0.145020, 0.931641, 0.332520);
 glVertex3f(1.474908, 0.193942, 0.122665);
 glNormal3f(0.027344, 0.948730, 0.313965);
 glVertex3f(1.257957, 0.207090, 0.112804);
 glNormal3f(0.018555, 0.755371, 0.654297);
 glVertex3f(1.254669, 0.193942, 0.135814);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.080566, 0.000488, 0.996582);
 glVertex3f(-0.957582, 0.000000, 0.254151);
 glNormal3f(-0.057129, 0.176270, 0.982422);
 glVertex3f(-0.951008, 0.115050, 0.244290);
 glNormal3f(-0.104492, 0.124023, 0.986328);
 glVertex3f(-1.102217, 0.118337, 0.231141);
 glNormal3f(-0.124512, 0.000977, 0.992188);
 glVertex3f(-1.105504, 0.000000, 0.241003);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.057129, 0.176270, 0.982422);
 glVertex3f(-0.951008, 0.115050, 0.244290);
 glNormal3f(0.001465, 0.261719, 0.964844);
 glVertex3f(-0.941147, 0.223526, 0.214705);
 glNormal3f(-0.061035, 0.197754, 0.978027);
 glVertex3f(-1.095643, 0.226813, 0.214705);
 glNormal3f(-0.104492, 0.124023, 0.986328);
 glVertex3f(-1.102217, 0.118337, 0.231141);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.001465, 0.261719, 0.964844);
 glVertex3f(-0.941147, 0.223526, 0.214705);
 glNormal3f(0.079590, 0.375977, 0.922852);
 glVertex3f(-0.931285, 0.417468, 0.162111);
 glNormal3f(-0.025391, 0.358887, 0.932617);
 glVertex3f(-1.079207, 0.437191, 0.165398);
 glNormal3f(-0.061035, 0.197754, 0.978027);
 glVertex3f(-1.095643, 0.226813, 0.214705);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.079590, 0.375977, 0.922852);
 glVertex3f(-0.931285, 0.417468, 0.162111);
 glNormal3f(0.176270, 0.743652, 0.644043);
 glVertex3f(-0.924711, 0.447052, 0.145675);
 glNormal3f(0.006348, 0.745117, 0.666016);
 glVertex3f(-1.072633, 0.470062, 0.148962);
 glNormal3f(-0.025391, 0.358887, 0.932617);
 glVertex3f(-1.079207, 0.437191, 0.165398);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.176270, 0.743652, 0.644043);
 glVertex3f(-0.924711, 0.447052, 0.145675);
 glNormal3f(0.126465, 0.559570, 0.818359);
 glVertex3f(-0.921424, 0.466775, 0.093081);
 glNormal3f(0.015137, 0.553711, 0.832031);
 glVertex3f(-1.072633, 0.489785, 0.093081);
 glNormal3f(0.006348, 0.745117, 0.666016);
 glVertex3f(-1.072633, 0.470062, 0.148962);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.126465, 0.559570, 0.818359);
 glVertex3f(-0.921424, 0.466775, 0.093081);
 glNormal3f(0.150879, 0.638672, 0.753906);
 glVertex3f(-0.921424, 0.479924, 0.093081);
 glNormal3f(0.020996, 0.643066, 0.765137);
 glVertex3f(-1.072633, 0.499647, 0.093081);
 glNormal3f(0.015137, 0.553711, 0.832031);
 glVertex3f(-1.072633, 0.489785, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.150879, 0.638672, 0.753906);
 glVertex3f(-0.921424, 0.479924, 0.093081);
 glNormal3f(0.227051, 0.973633, -0.004395);
 glVertex3f(-0.921424, 0.493072, -0.002246);
 glNormal3f(0.028320, 0.999512, 0.000000);
 glVertex3f(-1.072633, 0.519370, -0.002246);
 glNormal3f(0.020996, 0.643066, 0.765137);
 glVertex3f(-1.072633, 0.499647, 0.093081);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.497070, 0.498047, 0.710449);
 glVertex3f(-1.503249, 0.407607, 0.093081);
 glNormal3f(-0.325195, 0.615234, 0.717773);
 glVertex3f(-1.450655, 0.447052, 0.093081);
 glNormal3f(-0.430176, 0.902344, 0.000000);
 glVertex3f(-1.444080, 0.450339, -0.002246);
 glNormal3f(-0.462402, 0.873047, -0.154297);
 glVertex3f(-1.450655, 0.447052, -0.097574);
 glNormal3f(-0.724609, 0.688477, -0.039551);
 glVertex3f(-1.503249, 0.407607, -0.097574);
 glNormal3f(-0.747070, 0.664551, 0.000000);
 glVertex3f(-1.503249, 0.404319, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.497070, 0.498047, 0.710449);
 glVertex3f(-1.503249, 0.407607, 0.093081);
 glNormal3f(-0.421387, 0.363281, 0.830566);
 glVertex3f(-1.493388, 0.397745, 0.093081);
 glNormal3f(-0.254883, 0.467773, 0.846191);
 glVertex3f(-1.444080, 0.437191, 0.093081);
 glNormal3f(-0.325195, 0.615234, 0.717773);
 glVertex3f(-1.450655, 0.447052, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.421387, 0.363281, 0.830566);
 glVertex3f(-1.493388, 0.397745, 0.093081);
 glNormal3f(-0.623047, 0.528809, 0.575684);
 glVertex3f(-1.490101, 0.384596, 0.122665);
 glNormal3f(-0.368652, 0.693848, 0.618164);
 glVertex3f(-1.444080, 0.424042, 0.119378);
 glNormal3f(-0.254883, 0.467773, 0.846191);
 glVertex3f(-1.444080, 0.437191, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.623047, 0.528809, 0.575684);
 glVertex3f(-1.490101, 0.384596, 0.122665);
 glNormal3f(-0.329590, 0.286133, 0.899414);
 glVertex3f(-1.473665, 0.361586, 0.148962);
 glNormal3f(-0.213867, 0.441895, 0.871094);
 glVertex3f(-1.437506, 0.391171, 0.145675);
 glNormal3f(-0.368652, 0.693848, 0.618164);
 glVertex3f(-1.444080, 0.424042, 0.119378);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.329590, 0.286133, 0.899414);
 glVertex3f(-1.473665, 0.361586, 0.148962);
 glNormal3f(-0.142578, 0.128418, 0.980957);
 glVertex3f(-1.355327, 0.216952, 0.185121);
 glNormal3f(-0.112793, 0.374023, 0.920410);
 glVertex3f(-1.355327, 0.414181, 0.145675);
 glNormal3f(-0.213867, 0.441895, 0.871094);
 glVertex3f(-1.437506, 0.391171, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.648926, 0.760742, 0.000000);
 glVertex3f(1.662276, 0.131486, -0.002246);
 glNormal3f(0.452148, 0.529785, 0.716797);
 glVertex3f(1.655702, 0.134773, 0.093081);
 glNormal3f(0.598633, 0.316895, 0.734863);
 glVertex3f(1.711583, 0.078892, 0.093081);
 glNormal3f(0.883301, 0.467773, 0.000000);
 glVertex3f(1.718157, 0.075604, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.452148, 0.529785, 0.716797);
 glVertex3f(1.655702, 0.134773, 0.093081);
 glNormal3f(0.393555, 0.425293, 0.814453);
 glVertex3f(1.639266, 0.128199, 0.093081);
 glNormal3f(0.471680, 0.263184, 0.841309);
 glVertex3f(1.695147, 0.069030, 0.093081);
 glNormal3f(0.598633, 0.316895, 0.734863);
 glVertex3f(1.711583, 0.078892, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.393555, 0.425293, 0.814453);
 glVertex3f(1.639266, 0.128199, 0.093081);
 glNormal3f(0.504883, 0.593262, 0.626465);
 glVertex3f(1.622830, 0.124912, 0.135814);
 glNormal3f(0.625488, 0.384766, 0.677734);
 glVertex3f(1.668850, 0.069030, 0.139101);
 glNormal3f(0.471680, 0.263184, 0.841309);
 glVertex3f(1.695147, 0.069030, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.504883, 0.593262, 0.626465);
 glVertex3f(1.622830, 0.124912, 0.135814);
 glNormal3f(0.187988, 0.303711, 0.933594);
 glVertex3f(1.589959, 0.115050, 0.152250);
 glNormal3f(0.235840, 0.208008, 0.948730);
 glVertex3f(1.632692, 0.069030, 0.155537);
 glNormal3f(0.625488, 0.384766, 0.677734);
 glVertex3f(1.668850, 0.069030, 0.139101);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.052734, 0.305176, 0.950684);
 glVertex3f(1.445324, 0.164357, 0.152250);
 glNormal3f(0.168945, 0.421387, 0.890625);
 glVertex3f(1.547226, 0.157783, 0.145675);
 glNormal3f(0.099609, 0.680664, 0.725098);
 glVertex3f(1.474908, 0.190655, 0.139101);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.187988, 0.303711, 0.933594);
 glVertex3f(1.589959, 0.115050, 0.152250);
 glNormal3f(0.070312, 0.176758, 0.981445);
 glVertex3f(1.445324, 0.075604, 0.168685);
 glNormal3f(0.235840, 0.208008, 0.948730);
 glVertex3f(1.632692, 0.069030, 0.155537);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.168945, 0.421387, 0.890625);
 glVertex3f(1.547226, 0.157783, 0.145675);
 glNormal3f(0.070312, 0.176758, 0.981445);
 glVertex3f(1.445324, 0.075604, 0.168685);
 glNormal3f(0.187988, 0.303711, 0.933594);
 glVertex3f(1.589959, 0.115050, 0.152250);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.069824, 0.180176, -0.981445);
 glVertex3f(1.468334, 0.075604, -0.176465);
 glNormal3f(0.175781, 0.421875, -0.889648);
 glVertex3f(1.573523, 0.161070, -0.153455);
 glNormal3f(0.210938, 0.335449, -0.917969);
 glVertex3f(1.616256, 0.118337, -0.156743);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.069824, 0.180176, -0.981445);
 glVertex3f(1.468334, 0.075604, -0.176465);
 glNormal3f(0.210938, 0.335449, -0.917969);
 glVertex3f(1.616256, 0.118337, -0.156743);
 glNormal3f(0.207031, 0.225098, -0.952148);
 glVertex3f(1.658989, 0.075604, -0.163317);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.175781, 0.421875, -0.889648);
 glVertex3f(1.573523, 0.161070, -0.153455);
 glNormal3f(0.039551, 0.314941, -0.948242);
 glVertex3f(1.468334, 0.167645, -0.156743);
 glNormal3f(0.096680, 0.651855, -0.752441);
 glVertex3f(1.501206, 0.193942, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.210938, 0.335449, -0.917969);
 glVertex3f(1.616256, 0.118337, -0.156743);
 glNormal3f(0.523438, 0.647949, -0.552734);
 glVertex3f(1.649127, 0.124912, -0.140307);
 glNormal3f(0.650879, 0.433594, -0.623047);
 glVertex3f(1.698434, 0.075604, -0.150168);
 glNormal3f(0.207031, 0.225098, -0.952148);
 glVertex3f(1.658989, 0.075604, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.523438, 0.647949, -0.552734);
 glVertex3f(1.649127, 0.124912, -0.140307);
 glNormal3f(0.645996, 0.753418, -0.119629);
 glVertex3f(1.655702, 0.134773, -0.097574);
 glNormal3f(0.867188, 0.480469, -0.129883);
 glVertex3f(1.711583, 0.078892, -0.097574);
 glNormal3f(0.650879, 0.433594, -0.623047);
 glVertex3f(1.698434, 0.075604, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.645996, 0.753418, -0.119629);
 glVertex3f(1.655702, 0.134773, -0.097574);
 glNormal3f(0.648926, 0.760742, 0.000000);
 glVertex3f(1.662276, 0.131486, -0.002246);
 glNormal3f(0.883301, 0.467773, 0.000000);
 glVertex3f(1.718157, 0.075604, -0.002246);
 glNormal3f(0.867188, 0.480469, -0.129883);
 glVertex3f(1.711583, 0.078892, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.140137, 0.126465, -0.982422);
 glVertex3f(-1.378338, 0.220239, -0.189614);
 glNormal3f(-0.341309, 0.270020, -0.900879);
 glVertex3f(-1.499962, 0.364874, -0.153455);
 glNormal3f(-0.237793, 0.453613, -0.858887);
 glVertex3f(-1.463803, 0.401032, -0.153455);
 glNormal3f(-0.114746, 0.398438, -0.910156);
 glVertex3f(-1.378338, 0.424042, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.341309, 0.270020, -0.900879);
 glVertex3f(-1.499962, 0.364874, -0.153455);
 glNormal3f(-0.684082, 0.582031, -0.439941);
 glVertex3f(-1.516398, 0.391171, -0.127158);
 glNormal3f(-0.400391, 0.747559, -0.530273);
 glVertex3f(-1.467091, 0.430617, -0.123871);
 glNormal3f(-0.237793, 0.453613, -0.858887);
 glVertex3f(-1.463803, 0.401032, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.684082, 0.582031, -0.439941);
 glVertex3f(-1.516398, 0.391171, -0.127158);
 glNormal3f(-0.724609, 0.688477, -0.039551);
 glVertex3f(-1.503249, 0.407607, -0.097574);
 glNormal3f(-0.462402, 0.873047, -0.154297);
 glVertex3f(-1.450655, 0.447052, -0.097574);
 glNormal3f(-0.400391, 0.747559, -0.530273);
 glVertex3f(-1.467091, 0.430617, -0.123871);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.227051, 0.973633, -0.004395);
 glVertex3f(-0.921424, 0.493072, -0.002246);
 glNormal3f(0.208984, 0.931152, -0.297852);
 glVertex3f(-0.921424, 0.479924, -0.097574);
 glNormal3f(0.019531, 0.952637, -0.302734);
 glVertex3f(-1.072633, 0.499647, -0.097574);
 glNormal3f(0.028320, 0.999512, 0.000000);
 glVertex3f(-1.072633, 0.519370, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.208984, 0.931152, -0.297852);
 glVertex3f(-0.921424, 0.479924, -0.097574);
 glNormal3f(0.164551, 0.717773, -0.676270);
 glVertex3f(-0.941147, 0.456914, -0.150168);
 glNormal3f(0.001953, 0.753418, -0.657227);
 glVertex3f(-1.089068, 0.476637, -0.153455);
 glNormal3f(0.019531, 0.952637, -0.302734);
 glVertex3f(-1.072633, 0.499647, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.164551, 0.717773, -0.676270);
 glVertex3f(-0.941147, 0.456914, -0.150168);
 glNormal3f(0.084961, 0.390137, -0.916992);
 glVertex3f(-0.947721, 0.424042, -0.169891);
 glNormal3f(-0.026855, 0.395020, -0.918457);
 glVertex3f(-1.095643, 0.447052, -0.173178);
 glNormal3f(0.001953, 0.753418, -0.657227);
 glVertex3f(-1.089068, 0.476637, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.084961, 0.390137, -0.916992);
 glVertex3f(-0.947721, 0.424042, -0.169891);
 glNormal3f(0.005371, 0.257324, -0.966309);
 glVertex3f(-0.957582, 0.230100, -0.222486);
 glNormal3f(-0.064453, 0.197754, -0.978516);
 glVertex3f(-1.115366, 0.230100, -0.222486);
 glNormal3f(-0.026855, 0.395020, -0.918457);
 glVertex3f(-1.095643, 0.447052, -0.173178);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.005371, 0.257324, -0.966309);
 glVertex3f(-0.957582, 0.230100, -0.222486);
 glNormal3f(-0.055176, 0.171387, -0.983887);
 glVertex3f(-0.967444, 0.115050, -0.252070);
 glNormal3f(-0.103027, 0.121094, -0.987305);
 glVertex3f(-1.121940, 0.121625, -0.238921);
 glNormal3f(-0.064453, 0.197754, -0.978516);
 glVertex3f(-1.115366, 0.230100, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.055176, 0.171387, -0.983887);
 glVertex3f(-0.967444, 0.115050, -0.252070);
 glNormal3f(-0.079102, 0.000977, -0.997070);
 glVertex3f(-0.974018, 0.000000, -0.261931);
 glNormal3f(-0.118652, 0.000977, -0.993164);
 glVertex3f(-1.125227, 0.000000, -0.248783);
 glNormal3f(-0.103027, 0.121094, -0.987305);
 glVertex3f(-1.121940, 0.121625, -0.238921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.167480, 0.914551, -0.367676);
 glVertex3f(1.501206, 0.200516, -0.127158);
 glNormal3f(0.096680, 0.651855, -0.752441);
 glVertex3f(1.501206, 0.193942, -0.146881);
 glNormal3f(0.021484, 0.664551, -0.747070);
 glVertex3f(1.277679, 0.193942, -0.143594);
 glNormal3f(0.038574, 0.908203, -0.416016);
 glVertex3f(1.280967, 0.223526, -0.117297);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.096680, 0.651855, -0.752441);
 glVertex3f(1.501206, 0.193942, -0.146881);
 glNormal3f(0.039551, 0.314941, -0.948242);
 glVertex3f(1.468334, 0.167645, -0.156743);
 glNormal3f(0.027344, 0.416016, -0.909180);
 glVertex3f(1.271105, 0.170932, -0.163317);
 glNormal3f(0.021484, 0.664551, -0.747070);
 glVertex3f(1.277679, 0.193942, -0.143594);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.192383, 0.980957, 0.000000);
 glVertex3f(1.474908, 0.226813, -0.002246);
 glNormal3f(0.183594, 0.969727, -0.160645);
 glVertex3f(1.474908, 0.213665, -0.097574);
 glNormal3f(0.047852, 0.981445, -0.185547);
 glVertex3f(1.261244, 0.226813, -0.097574);
 glNormal3f(0.048340, 0.998535, 0.000000);
 glVertex3f(1.248095, 0.243249, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.183594, 0.969727, -0.160645);
 glVertex3f(1.474908, 0.213665, -0.097574);
 glNormal3f(0.167480, 0.914551, -0.367676);
 glVertex3f(1.501206, 0.200516, -0.127158);
 glNormal3f(0.038574, 0.908203, -0.416016);
 glVertex3f(1.280967, 0.223526, -0.117297);
 glNormal3f(0.047852, 0.981445, -0.185547);
 glVertex3f(1.261244, 0.226813, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.039551, 0.314941, -0.948242);
 glVertex3f(1.468334, 0.167645, -0.156743);
 glNormal3f(0.069824, 0.180176, -0.981445);
 glVertex3f(1.468334, 0.075604, -0.176465);
 glNormal3f(0.047363, 0.239746, -0.969727);
 glVertex3f(1.274392, 0.078892, -0.189614);
 glNormal3f(0.027344, 0.416016, -0.909180);
 glVertex3f(1.271105, 0.170932, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.069824, 0.180176, -0.981445);
 glVertex3f(1.468334, 0.075604, -0.176465);
 glNormal3f(0.085938, 0.002441, -0.996582);
 glVertex3f(1.468334, 0.000000, -0.186327);
 glNormal3f(0.057617, 0.004395, -0.998535);
 glVertex3f(1.277679, 0.000000, -0.206050);
 glNormal3f(0.047363, 0.239746, -0.969727);
 glVertex3f(1.274392, 0.078892, -0.189614);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.999512, 0.003418, 0.000000);
 glVertex3f(1.731306, 0.000000, -0.002246);
 glNormal3f(0.992676, 0.003906, -0.119629);
 glVertex3f(1.728019, 0.000000, -0.097574);
 glNormal3f(0.867188, 0.480469, -0.129883);
 glVertex3f(1.711583, 0.078892, -0.097574);
 glNormal3f(0.883301, 0.467773, 0.000000);
 glVertex3f(1.718157, 0.075604, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.648926, 0.760742, 0.000000);
 glVertex3f(1.662276, 0.131486, -0.002246);
 glNormal3f(0.645996, 0.753418, -0.119629);
 glVertex3f(1.655702, 0.134773, -0.097574);
 glNormal3f(0.450684, 0.883789, -0.122070);
 glVertex3f(1.589959, 0.180793, -0.097574);
 glNormal3f(0.456055, 0.889648, 0.000000);
 glVertex3f(1.596533, 0.180793, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.450684, 0.883789, -0.122070);
 glVertex3f(1.589959, 0.180793, -0.097574);
 glNormal3f(0.645996, 0.753418, -0.119629);
 glVertex3f(1.655702, 0.134773, -0.097574);
 glNormal3f(0.523438, 0.647949, -0.552734);
 glVertex3f(1.649127, 0.124912, -0.140307);
 glNormal3f(0.403809, 0.804199, -0.435547);
 glVertex3f(1.596533, 0.170932, -0.133732);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.763184, 0.003906, -0.645996);
 glVertex3f(1.721445, 0.000000, -0.150168);
 glNormal3f(0.650879, 0.433594, -0.623047);
 glVertex3f(1.698434, 0.075604, -0.150168);
 glNormal3f(0.867188, 0.480469, -0.129883);
 glVertex3f(1.711583, 0.078892, -0.097574);
 glNormal3f(0.992676, 0.003906, -0.119629);
 glVertex3f(1.728019, 0.000000, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.763184, 0.003906, -0.645996);
 glVertex3f(1.721445, 0.000000, -0.150168);
 glNormal3f(0.225098, 0.001953, -0.974609);
 glVertex3f(1.691860, 0.000000, -0.163317);
 glNormal3f(0.207031, 0.225098, -0.952148);
 glVertex3f(1.658989, 0.075604, -0.163317);
 glNormal3f(0.650879, 0.433594, -0.623047);
 glVertex3f(1.698434, 0.075604, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.523438, 0.647949, -0.552734);
 glVertex3f(1.649127, 0.124912, -0.140307);
 glNormal3f(0.210938, 0.335449, -0.917969);
 glVertex3f(1.616256, 0.118337, -0.156743);
 glNormal3f(0.175781, 0.421875, -0.889648);
 glVertex3f(1.573523, 0.161070, -0.153455);
 glNormal3f(0.403809, 0.804199, -0.435547);
 glVertex3f(1.596533, 0.170932, -0.133732);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.403809, 0.804199, -0.435547);
 glVertex3f(1.596533, 0.170932, -0.133732);
 glNormal3f(0.167480, 0.914551, -0.367676);
 glVertex3f(1.501206, 0.200516, -0.127158);
 glNormal3f(0.183594, 0.969727, -0.160645);
 glVertex3f(1.474908, 0.213665, -0.097574);
 glNormal3f(0.450684, 0.883789, -0.122070);
 glVertex3f(1.589959, 0.180793, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.456055, 0.889648, 0.000000);
 glVertex3f(1.596533, 0.180793, -0.002246);
 glNormal3f(0.450684, 0.883789, -0.122070);
 glVertex3f(1.589959, 0.180793, -0.097574);
 glNormal3f(0.183594, 0.969727, -0.160645);
 glVertex3f(1.474908, 0.213665, -0.097574);
 glNormal3f(0.192383, 0.980957, 0.000000);
 glVertex3f(1.474908, 0.226813, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.021484, 0.664551, -0.747070);
 glVertex3f(1.277679, 0.193942, -0.143594);
 glNormal3f(0.067871, 0.620605, -0.781250);
 glVertex3f(0.321119, 0.220239, -0.153455);
 glNormal3f(0.092285, 0.873047, -0.478516);
 glVertex3f(0.327693, 0.243249, -0.127158);
 glNormal3f(0.038574, 0.908203, -0.416016);
 glVertex3f(1.280967, 0.223526, -0.117297);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.038574, 0.908203, -0.416016);
 glVertex3f(1.280967, 0.223526, -0.117297);
 glNormal3f(0.092285, 0.873047, -0.478516);
 glVertex3f(0.327693, 0.243249, -0.127158);
 glNormal3f(0.107422, 0.966309, -0.232422);
 glVertex3f(0.324406, 0.246536, -0.097574);
 glNormal3f(0.047852, 0.981445, -0.185547);
 glVertex3f(1.261244, 0.226813, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047852, 0.981445, -0.185547);
 glVertex3f(1.261244, 0.226813, -0.097574);
 glNormal3f(0.107422, 0.966309, -0.232422);
 glVertex3f(0.324406, 0.246536, -0.097574);
 glNormal3f(0.118652, 0.992676, 0.000000);
 glVertex3f(0.311257, 0.279408, -0.002246);
 glNormal3f(0.048340, 0.998535, 0.000000);
 glVertex3f(1.248095, 0.243249, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.067871, 0.620605, -0.781250);
 glVertex3f(0.321119, 0.220239, -0.153455);
 glNormal3f(0.134277, 0.553223, -0.822266);
 glVertex3f(0.140326, 0.239962, -0.166604);
 glNormal3f(0.207520, 0.795410, -0.569336);
 glVertex3f(0.140326, 0.262972, -0.143594);
 glNormal3f(0.092285, 0.873047, -0.478516);
 glVertex3f(0.327693, 0.243249, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.092285, 0.873047, -0.478516);
 glVertex3f(0.327693, 0.243249, -0.127158);
 glNormal3f(0.207520, 0.795410, -0.569336);
 glVertex3f(0.140326, 0.262972, -0.143594);
 glNormal3f(0.247070, 0.924316, -0.289551);
 glVertex3f(0.137038, 0.292556, -0.097574);
 glNormal3f(0.107422, 0.966309, -0.232422);
 glVertex3f(0.324406, 0.246536, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.107422, 0.966309, -0.232422);
 glVertex3f(0.324406, 0.246536, -0.097574);
 glNormal3f(0.247070, 0.924316, -0.289551);
 glVertex3f(0.137038, 0.292556, -0.097574);
 glNormal3f(0.258789, 0.965332, 0.000000);
 glVertex3f(0.127177, 0.312279, -0.002246);
 glNormal3f(0.118652, 0.992676, 0.000000);
 glVertex3f(0.311257, 0.279408, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.031250, 0.218262, -0.975586);
 glVertex3f(-0.549976, 0.108476, -0.255357);
 glNormal3f(0.035645, 0.211914, -0.977051);
 glVertex3f(-0.319875, 0.108476, -0.245496);
 glNormal3f(0.035156, 0.001953, -0.999512);
 glVertex3f(-0.323162, 0.000000, -0.258644);
 glNormal3f(0.033203, 0.001465, -0.999512);
 glVertex3f(-0.556550, 0.000000, -0.265218);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.051270, 0.002930, -0.999023);
 glVertex3f(0.130464, 0.000000, -0.242208);
 glNormal3f(0.041504, 0.002441, -0.999512);
 glVertex3f(-0.076626, 0.000000, -0.248783);
 glNormal3f(0.051758, 0.225098, -0.973145);
 glVertex3f(-0.070052, 0.095327, -0.238921);
 glNormal3f(0.062012, 0.263672, -0.962891);
 glVertex3f(0.137038, 0.095327, -0.225773);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.035645, 0.211914, -0.977051);
 glVertex3f(-0.319875, 0.108476, -0.245496);
 glNormal3f(0.051758, 0.225098, -0.973145);
 glVertex3f(-0.070052, 0.095327, -0.238921);
 glNormal3f(0.041504, 0.002441, -0.999512);
 glVertex3f(-0.076626, 0.000000, -0.248783);
 glNormal3f(0.035156, 0.001953, -0.999512);
 glVertex3f(-0.323162, 0.000000, -0.258644);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.134277, 0.553223, -0.822266);
 glVertex3f(0.140326, 0.239962, -0.166604);
 glNormal3f(0.129395, 0.480469, -0.867188);
 glVertex3f(-0.066765, 0.312279, -0.160030);
 glNormal3f(0.210449, 0.738770, -0.639648);
 glVertex3f(-0.063478, 0.338576, -0.140307);
 glNormal3f(0.207520, 0.795410, -0.569336);
 glVertex3f(0.140326, 0.262972, -0.143594);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207520, 0.795410, -0.569336);
 glVertex3f(0.140326, 0.262972, -0.143594);
 glNormal3f(0.210449, 0.738770, -0.639648);
 glVertex3f(-0.063478, 0.338576, -0.140307);
 glNormal3f(0.252441, 0.922363, -0.291992);
 glVertex3f(-0.070052, 0.364874, -0.097574);
 glNormal3f(0.247070, 0.924316, -0.289551);
 glVertex3f(0.137038, 0.292556, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.247070, 0.924316, -0.289551);
 glVertex3f(0.137038, 0.292556, -0.097574);
 glNormal3f(0.252441, 0.922363, -0.291992);
 glVertex3f(-0.070052, 0.364874, -0.097574);
 glNormal3f(0.257324, 0.965820, 0.000000);
 glVertex3f(-0.079913, 0.374735, -0.002246);
 glNormal3f(0.258789, 0.965332, 0.000000);
 glVertex3f(0.127177, 0.312279, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.257324, 0.965820, 0.000000);
 glVertex3f(-0.079913, 0.374735, -0.002246);
 glNormal3f(0.252441, 0.922363, -0.291992);
 glVertex3f(-0.070052, 0.364874, -0.097574);
 glNormal3f(0.090820, 0.958496, -0.270508);
 glVertex3f(-0.310014, 0.414181, -0.097574);
 glNormal3f(0.091797, 0.995605, 0.000000);
 glVertex3f(-0.310014, 0.424042, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.090820, 0.958496, -0.270508);
 glVertex3f(-0.310014, 0.414181, -0.097574);
 glNormal3f(0.252441, 0.922363, -0.291992);
 glVertex3f(-0.070052, 0.364874, -0.097574);
 glNormal3f(0.210449, 0.738770, -0.639648);
 glVertex3f(-0.063478, 0.338576, -0.140307);
 glNormal3f(0.073730, 0.742188, -0.666504);
 glVertex3f(-0.313301, 0.391171, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.210449, 0.738770, -0.639648);
 glVertex3f(-0.063478, 0.338576, -0.140307);
 glNormal3f(0.129395, 0.480469, -0.867188);
 glVertex3f(-0.066765, 0.312279, -0.160030);
 glNormal3f(0.041504, 0.441406, -0.896484);
 glVertex3f(-0.310014, 0.364874, -0.163317);
 glNormal3f(0.073730, 0.742188, -0.666504);
 glVertex3f(-0.313301, 0.391171, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.072266, 0.339355, -0.937988);
 glVertex3f(-0.066765, 0.210378, -0.199475);
 glNormal3f(0.031738, 0.327637, -0.944336);
 glVertex3f(-0.319875, 0.216952, -0.212624);
 glNormal3f(0.041504, 0.441406, -0.896484);
 glVertex3f(-0.310014, 0.364874, -0.163317);
 glNormal3f(0.129395, 0.480469, -0.867188);
 glVertex3f(-0.066765, 0.312279, -0.160030);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.031738, 0.327637, -0.944336);
 glVertex3f(-0.319875, 0.216952, -0.212624);
 glNormal3f(0.023926, 0.338867, -0.940430);
 glVertex3f(-0.546689, 0.220239, -0.212624);
 glNormal3f(0.020508, 0.428711, -0.903320);
 glVertex3f(-0.543402, 0.368161, -0.153455);
 glNormal3f(0.041504, 0.441406, -0.896484);
 glVertex3f(-0.310014, 0.364874, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.041504, 0.441406, -0.896484);
 glVertex3f(-0.310014, 0.364874, -0.163317);
 glNormal3f(0.020508, 0.428711, -0.903320);
 glVertex3f(-0.543402, 0.368161, -0.153455);
 glNormal3f(0.031738, 0.740234, -0.671875);
 glVertex3f(-0.543402, 0.391171, -0.140307);
 glNormal3f(0.073730, 0.742188, -0.666504);
 glVertex3f(-0.313301, 0.391171, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.073730, 0.742188, -0.666504);
 glVertex3f(-0.313301, 0.391171, -0.146881);
 glNormal3f(0.031738, 0.740234, -0.671875);
 glVertex3f(-0.543402, 0.391171, -0.140307);
 glNormal3f(0.040039, 0.965332, -0.257812);
 glVertex3f(-0.533540, 0.410894, -0.097574);
 glNormal3f(0.090820, 0.958496, -0.270508);
 glVertex3f(-0.310014, 0.414181, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.091797, 0.995605, 0.000000);
 glVertex3f(-0.310014, 0.424042, -0.002246);
 glNormal3f(0.090820, 0.958496, -0.270508);
 glVertex3f(-0.310014, 0.414181, -0.097574);
 glNormal3f(0.040039, 0.965332, -0.257812);
 glVertex3f(-0.533540, 0.410894, -0.097574);
 glNormal3f(0.040527, 0.999023, 0.000000);
 glVertex3f(-0.530253, 0.417468, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.040039, 0.965332, -0.257812);
 glVertex3f(-0.533540, 0.410894, -0.097574);
 glNormal3f(0.031738, 0.740234, -0.671875);
 glVertex3f(-0.543402, 0.391171, -0.140307);
 glNormal3f(0.150391, 0.716797, -0.680664);
 glVertex3f(-0.793225, 0.414181, -0.146881);
 glNormal3f(0.190430, 0.940918, -0.278809);
 glVertex3f(-0.770215, 0.433904, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.084473, 0.412109, -0.907227);
 glVertex3f(-0.796512, 0.381309, -0.166604);
 glNormal3f(0.150391, 0.716797, -0.680664);
 glVertex3f(-0.793225, 0.414181, -0.146881);
 glNormal3f(0.031738, 0.740234, -0.671875);
 glVertex3f(-0.543402, 0.391171, -0.140307);
 glNormal3f(0.020508, 0.428711, -0.903320);
 glVertex3f(-0.543402, 0.368161, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.020508, 0.428711, -0.903320);
 glVertex3f(-0.543402, 0.368161, -0.153455);
 glNormal3f(0.023926, 0.338867, -0.940430);
 glVertex3f(-0.546689, 0.220239, -0.212624);
 glNormal3f(0.029785, 0.318848, -0.947266);
 glVertex3f(-0.803086, 0.226813, -0.222486);
 glNormal3f(0.084473, 0.412109, -0.907227);
 glVertex3f(-0.796512, 0.381309, -0.166604);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.029785, 0.318848, -0.947266);
 glVertex3f(-0.803086, 0.226813, -0.222486);
 glNormal3f(0.005371, 0.257324, -0.966309);
 glVertex3f(-0.957582, 0.230100, -0.222486);
 glNormal3f(0.084961, 0.390137, -0.916992);
 glVertex3f(-0.947721, 0.424042, -0.169891);
 glNormal3f(0.084473, 0.412109, -0.907227);
 glVertex3f(-0.796512, 0.381309, -0.166604);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.140137, 0.126465, -0.982422);
 glVertex3f(-1.378338, 0.220239, -0.189614);
 glNormal3f(-0.114746, 0.398438, -0.910156);
 glVertex3f(-1.378338, 0.424042, -0.150168);
 glNormal3f(-0.026855, 0.395020, -0.918457);
 glVertex3f(-1.095643, 0.447052, -0.173178);
 glNormal3f(-0.064453, 0.197754, -0.978516);
 glVertex3f(-1.115366, 0.230100, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.084961, 0.390137, -0.916992);
 glVertex3f(-0.947721, 0.424042, -0.169891);
 glNormal3f(0.164551, 0.717773, -0.676270);
 glVertex3f(-0.941147, 0.456914, -0.150168);
 glNormal3f(0.150391, 0.716797, -0.680664);
 glVertex3f(-0.793225, 0.414181, -0.146881);
 glNormal3f(0.084473, 0.412109, -0.907227);
 glVertex3f(-0.796512, 0.381309, -0.166604);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.150391, 0.716797, -0.680664);
 glVertex3f(-0.793225, 0.414181, -0.146881);
 glNormal3f(0.164551, 0.717773, -0.676270);
 glVertex3f(-0.941147, 0.456914, -0.150168);
 glNormal3f(0.208984, 0.931152, -0.297852);
 glVertex3f(-0.921424, 0.479924, -0.097574);
 glNormal3f(0.190430, 0.940918, -0.278809);
 glVertex3f(-0.770215, 0.433904, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.040527, 0.999023, 0.000000);
 glVertex3f(-0.530253, 0.417468, -0.002246);
 glNormal3f(0.040039, 0.965332, -0.257812);
 glVertex3f(-0.533540, 0.410894, -0.097574);
 glNormal3f(0.190430, 0.940918, -0.278809);
 glVertex3f(-0.770215, 0.433904, -0.097574);
 glNormal3f(0.201172, 0.979492, 0.000000);
 glVertex3f(-0.766928, 0.443765, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.230469, 0.973145, 0.003906);
 glVertex3f(-1.352040, 0.489785, -0.002246);
 glNormal3f(-0.210449, 0.938965, -0.271484);
 glVertex3f(-1.371763, 0.473350, -0.097574);
 glNormal3f(-0.462402, 0.873047, -0.154297);
 glVertex3f(-1.450655, 0.447052, -0.097574);
 glNormal3f(-0.430176, 0.902344, 0.000000);
 glVertex3f(-1.444080, 0.450339, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.462402, 0.873047, -0.154297);
 glVertex3f(-1.450655, 0.447052, -0.097574);
 glNormal3f(-0.210449, 0.938965, -0.271484);
 glVertex3f(-1.371763, 0.473350, -0.097574);
 glNormal3f(-0.169434, 0.765625, -0.620605);
 glVertex3f(-1.384912, 0.453627, -0.127158);
 glNormal3f(-0.400391, 0.747559, -0.530273);
 glVertex3f(-1.467091, 0.430617, -0.123871);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.208984, 0.931152, -0.297852);
 glVertex3f(-0.921424, 0.479924, -0.097574);
 glNormal3f(0.227051, 0.973633, -0.004395);
 glVertex3f(-0.921424, 0.493072, -0.002246);
 glNormal3f(0.201172, 0.979492, 0.000000);
 glVertex3f(-0.766928, 0.443765, -0.002246);
 glNormal3f(0.190430, 0.940918, -0.278809);
 glVertex3f(-0.770215, 0.433904, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.210449, 0.938965, -0.271484);
 glVertex3f(-1.371763, 0.473350, -0.097574);
 glNormal3f(0.019531, 0.952637, -0.302734);
 glVertex3f(-1.072633, 0.499647, -0.097574);
 glNormal3f(0.001953, 0.753418, -0.657227);
 glVertex3f(-1.089068, 0.476637, -0.153455);
 glNormal3f(-0.169434, 0.765625, -0.620605);
 glVertex3f(-1.384912, 0.453627, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.019531, 0.952637, -0.302734);
 glVertex3f(-1.072633, 0.499647, -0.097574);
 glNormal3f(-0.210449, 0.938965, -0.271484);
 glVertex3f(-1.371763, 0.473350, -0.097574);
 glNormal3f(-0.230469, 0.973145, 0.003906);
 glVertex3f(-1.352040, 0.489785, -0.002246);
 glNormal3f(0.028320, 0.999512, 0.000000);
 glVertex3f(-1.072633, 0.519370, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.895020, 0.445801, -0.014648);
 glVertex3f(-1.545982, 0.345151, -0.097574);
 glNormal3f(-0.889160, 0.458008, 0.000000);
 glVertex3f(-1.552556, 0.335289, -0.002246);
 glNormal3f(-0.747070, 0.664551, 0.000000);
 glVertex3f(-1.503249, 0.404319, -0.002246);
 glNormal3f(-0.724609, 0.688477, -0.039551);
 glVertex3f(-1.503249, 0.407607, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.169434, 0.765625, -0.620605);
 glVertex3f(-1.384912, 0.453627, -0.127158);
 glNormal3f(0.001953, 0.753418, -0.657227);
 glVertex3f(-1.089068, 0.476637, -0.153455);
 glNormal3f(-0.026855, 0.395020, -0.918457);
 glVertex3f(-1.095643, 0.447052, -0.173178);
 glNormal3f(-0.114746, 0.398438, -0.910156);
 glVertex3f(-1.378338, 0.424042, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.169434, 0.765625, -0.620605);
 glVertex3f(-1.384912, 0.453627, -0.127158);
 glNormal3f(-0.114746, 0.398438, -0.910156);
 glVertex3f(-1.378338, 0.424042, -0.150168);
 glNormal3f(-0.237793, 0.453613, -0.858887);
 glVertex3f(-1.463803, 0.401032, -0.153455);
 glNormal3f(-0.400391, 0.747559, -0.530273);
 glVertex3f(-1.467091, 0.430617, -0.123871);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.140137, 0.126465, -0.982422);
 glVertex3f(-1.378338, 0.220239, -0.189614);
 glNormal3f(-0.353516, 0.144043, -0.924316);
 glVertex3f(-1.549269, 0.223526, -0.160030);
 glNormal3f(-0.380371, 0.189941, -0.905273);
 glVertex3f(-1.522972, 0.308992, -0.153455);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.341309, 0.270020, -0.900879);
 glVertex3f(-1.499962, 0.364874, -0.153455);
 glNormal3f(-0.140137, 0.126465, -0.982422);
 glVertex3f(-1.378338, 0.220239, -0.189614);
 glNormal3f(-0.380371, 0.189941, -0.905273);
 glVertex3f(-1.522972, 0.308992, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.684082, 0.582031, -0.439941);
 glVertex3f(-1.516398, 0.391171, -0.127158);
 glNormal3f(-0.341309, 0.270020, -0.900879);
 glVertex3f(-1.499962, 0.364874, -0.153455);
 glNormal3f(-0.380371, 0.189941, -0.905273);
 glVertex3f(-1.522972, 0.308992, -0.153455);
 glNormal3f(-0.809082, 0.388184, -0.441895);
 glVertex3f(-1.549269, 0.332002, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.380371, 0.189941, -0.905273);
 glVertex3f(-1.522972, 0.308992, -0.153455);
 glNormal3f(-0.353516, 0.144043, -0.924316);
 glVertex3f(-1.549269, 0.223526, -0.160030);
 glNormal3f(-0.841797, 0.240723, -0.483887);
 glVertex3f(-1.588715, 0.226813, -0.137020);
 glNormal3f(-0.809082, 0.388184, -0.441895);
 glVertex3f(-1.549269, 0.332002, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.841797, 0.240723, -0.483887);
 glVertex3f(-1.588715, 0.226813, -0.137020);
 glNormal3f(-0.966797, 0.252441, -0.039062);
 glVertex3f(-1.588715, 0.220239, -0.097574);
 glNormal3f(-0.895020, 0.445801, -0.014648);
 glVertex3f(-1.545982, 0.345151, -0.097574);
 glNormal3f(-0.809082, 0.388184, -0.441895);
 glVertex3f(-1.549269, 0.332002, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.809082, 0.388184, -0.441895);
 glVertex3f(-1.549269, 0.332002, -0.127158);
 glNormal3f(-0.895020, 0.445801, -0.014648);
 glVertex3f(-1.545982, 0.345151, -0.097574);
 glNormal3f(-0.724609, 0.688477, -0.039551);
 glVertex3f(-1.503249, 0.407607, -0.097574);
 glNormal3f(-0.684082, 0.582031, -0.439941);
 glVertex3f(-1.516398, 0.391171, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.966797, 0.255371, 0.000000);
 glVertex3f(-1.598577, 0.210378, -0.002246);
 glNormal3f(-0.889160, 0.458008, 0.000000);
 glVertex3f(-1.552556, 0.335289, -0.002246);
 glNormal3f(-0.895020, 0.445801, -0.014648);
 glVertex3f(-1.545982, 0.345151, -0.097574);
 glNormal3f(-0.966797, 0.252441, -0.039062);
 glVertex3f(-1.588715, 0.220239, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.029785, 0.318848, -0.947266);
 glVertex3f(-0.803086, 0.226813, -0.222486);
 glNormal3f(-0.007812, 0.209961, -0.978027);
 glVertex3f(-0.812948, 0.111763, -0.261931);
 glNormal3f(-0.055176, 0.171387, -0.983887);
 glVertex3f(-0.967444, 0.115050, -0.252070);
 glNormal3f(0.005371, 0.257324, -0.966309);
 glVertex3f(-0.957582, 0.230100, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.064453, 0.197754, -0.978516);
 glVertex3f(-1.115366, 0.230100, -0.222486);
 glNormal3f(-0.103027, 0.121094, -0.987305);
 glVertex3f(-1.121940, 0.121625, -0.238921);
 glNormal3f(-0.170410, 0.078613, -0.982422);
 glVertex3f(-1.378338, 0.111763, -0.202763);
 glNormal3f(-0.140137, 0.126465, -0.982422);
 glVertex3f(-1.378338, 0.220239, -0.189614);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.140137, 0.126465, -0.982422);
 glVertex3f(-1.378338, 0.220239, -0.189614);
 glNormal3f(-0.170410, 0.078613, -0.982422);
 glVertex3f(-1.378338, 0.111763, -0.202763);
 glNormal3f(-0.358398, 0.062500, -0.931641);
 glVertex3f(-1.568992, 0.108476, -0.163317);
 glNormal3f(-0.353516, 0.144043, -0.924316);
 glVertex3f(-1.549269, 0.223526, -0.160030);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.358398, 0.062500, -0.931641);
 glVertex3f(-1.568992, 0.108476, -0.163317);
 glNormal3f(-0.836914, 0.094727, -0.539551);
 glVertex3f(-1.605151, 0.108476, -0.140307);
 glNormal3f(-0.841797, 0.240723, -0.483887);
 glVertex3f(-1.588715, 0.226813, -0.137020);
 glNormal3f(-0.353516, 0.144043, -0.924316);
 glVertex3f(-1.549269, 0.223526, -0.160030);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.966797, 0.252441, -0.039062);
 glVertex3f(-1.588715, 0.220239, -0.097574);
 glNormal3f(-0.841797, 0.240723, -0.483887);
 glVertex3f(-1.588715, 0.226813, -0.137020);
 glNormal3f(-0.836914, 0.094727, -0.539551);
 glVertex3f(-1.605151, 0.108476, -0.140307);
 glNormal3f(-0.987793, 0.121094, -0.098633);
 glVertex3f(-1.611725, 0.095327, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.966797, 0.255371, 0.000000);
 glVertex3f(-1.598577, 0.210378, -0.002246);
 glNormal3f(-0.966797, 0.252441, -0.039062);
 glVertex3f(-1.588715, 0.220239, -0.097574);
 glNormal3f(-0.987793, 0.121094, -0.098633);
 glVertex3f(-1.611725, 0.095327, -0.097574);
 glNormal3f(-0.990723, 0.138184, -0.000488);
 glVertex3f(-1.618299, 0.095327, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.007812, 0.209961, -0.978027);
 glVertex3f(-0.812948, 0.111763, -0.261931);
 glNormal3f(0.029785, 0.318848, -0.947266);
 glVertex3f(-0.803086, 0.226813, -0.222486);
 glNormal3f(0.023926, 0.338867, -0.940430);
 glVertex3f(-0.546689, 0.220239, -0.212624);
 glNormal3f(0.031250, 0.218262, -0.975586);
 glVertex3f(-0.549976, 0.108476, -0.255357);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.023926, 0.338867, -0.940430);
 glVertex3f(-0.546689, 0.220239, -0.212624);
 glNormal3f(0.031738, 0.327637, -0.944336);
 glVertex3f(-0.319875, 0.216952, -0.212624);
 glNormal3f(0.035645, 0.211914, -0.977051);
 glVertex3f(-0.319875, 0.108476, -0.245496);
 glNormal3f(0.031250, 0.218262, -0.975586);
 glVertex3f(-0.549976, 0.108476, -0.255357);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.031738, 0.327637, -0.944336);
 glVertex3f(-0.319875, 0.216952, -0.212624);
 glNormal3f(0.072266, 0.339355, -0.937988);
 glVertex3f(-0.066765, 0.210378, -0.199475);
 glNormal3f(0.051758, 0.225098, -0.973145);
 glVertex3f(-0.070052, 0.095327, -0.238921);
 glNormal3f(0.035645, 0.211914, -0.977051);
 glVertex3f(-0.319875, 0.108476, -0.245496);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.987793, 0.121094, -0.098633);
 glVertex3f(-1.611725, 0.095327, -0.097574);
 glNormal3f(-0.990234, 0.000977, -0.139648);
 glVertex3f(-1.618299, 0.000000, -0.097574);
 glNormal3f(-1.000000, 0.002441, -0.000488);
 glVertex3f(-1.631448, 0.000000, -0.002246);
 glNormal3f(-0.990723, 0.138184, -0.000488);
 glVertex3f(-1.618299, 0.095327, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.990234, 0.000977, -0.139648);
 glVertex3f(-1.618299, 0.000000, -0.097574);
 glNormal3f(-0.987793, 0.121094, -0.098633);
 glVertex3f(-1.611725, 0.095327, -0.097574);
 glNormal3f(-0.836914, 0.094727, -0.539551);
 glVertex3f(-1.605151, 0.108476, -0.140307);
 glNormal3f(-0.820801, 0.000488, -0.571777);
 glVertex3f(-1.608438, 0.000000, -0.143594);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.358398, 0.062500, -0.931641);
 glVertex3f(-1.568992, 0.108476, -0.163317);
 glNormal3f(-0.360840, 0.000000, -0.933105);
 glVertex3f(-1.565705, 0.000000, -0.166604);
 glNormal3f(-0.820801, 0.000488, -0.571777);
 glVertex3f(-1.608438, 0.000000, -0.143594);
 glNormal3f(-0.836914, 0.094727, -0.539551);
 glVertex3f(-1.605151, 0.108476, -0.140307);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.170410, 0.078613, -0.982422);
 glVertex3f(-1.378338, 0.111763, -0.202763);
 glNormal3f(-0.180176, 0.000488, -0.983887);
 glVertex3f(-1.381625, 0.000000, -0.206050);
 glNormal3f(-0.360840, 0.000000, -0.933105);
 glVertex3f(-1.565705, 0.000000, -0.166604);
 glNormal3f(-0.358398, 0.062500, -0.931641);
 glVertex3f(-1.568992, 0.108476, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.103027, 0.121094, -0.987305);
 glVertex3f(-1.121940, 0.121625, -0.238921);
 glNormal3f(-0.118652, 0.000977, -0.993164);
 glVertex3f(-1.125227, 0.000000, -0.248783);
 glNormal3f(-0.180176, 0.000488, -0.983887);
 glVertex3f(-1.381625, 0.000000, -0.206050);
 glNormal3f(-0.170410, 0.078613, -0.982422);
 glVertex3f(-1.378338, 0.111763, -0.202763);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.007812, 0.209961, -0.978027);
 glVertex3f(-0.812948, 0.111763, -0.261931);
 glNormal3f(-0.021484, 0.001465, -1.000000);
 glVertex3f(-0.822809, 0.000000, -0.275080);
 glNormal3f(-0.079102, 0.000977, -0.997070);
 glVertex3f(-0.974018, 0.000000, -0.261931);
 glNormal3f(-0.055176, 0.171387, -0.983887);
 glVertex3f(-0.967444, 0.115050, -0.252070);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.007812, 0.209961, -0.978027);
 glVertex3f(-0.812948, 0.111763, -0.261931);
 glNormal3f(0.031250, 0.218262, -0.975586);
 glVertex3f(-0.549976, 0.108476, -0.255357);
 glNormal3f(0.033203, 0.001465, -0.999512);
 glVertex3f(-0.556550, 0.000000, -0.265218);
 glNormal3f(-0.021484, 0.001465, -1.000000);
 glVertex3f(-0.822809, 0.000000, -0.275080);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.403809, 0.804199, -0.435547);
 glVertex3f(1.596533, 0.170932, -0.133732);
 glNormal3f(0.175781, 0.421875, -0.889648);
 glVertex3f(1.573523, 0.161070, -0.153455);
 glNormal3f(0.096680, 0.651855, -0.752441);
 glVertex3f(1.501206, 0.193942, -0.146881);
 glNormal3f(0.167480, 0.914551, -0.367676);
 glVertex3f(1.501206, 0.200516, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.021484, 0.664551, -0.747070);
 glVertex3f(1.277679, 0.193942, -0.143594);
 glNormal3f(0.027344, 0.416016, -0.909180);
 glVertex3f(1.271105, 0.170932, -0.163317);
 glNormal3f(0.052246, 0.437500, -0.897949);
 glVertex3f(0.314545, 0.190655, -0.173178);
 glNormal3f(0.067871, 0.620605, -0.781250);
 glVertex3f(0.321119, 0.220239, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.067871, 0.620605, -0.781250);
 glVertex3f(0.321119, 0.220239, -0.153455);
 glNormal3f(0.052246, 0.437500, -0.897949);
 glVertex3f(0.314545, 0.190655, -0.173178);
 glNormal3f(0.083496, 0.388672, -0.917969);
 glVertex3f(0.133751, 0.193942, -0.186327);
 glNormal3f(0.134277, 0.553223, -0.822266);
 glVertex3f(0.140326, 0.239962, -0.166604);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.134277, 0.553223, -0.822266);
 glVertex3f(0.140326, 0.239962, -0.166604);
 glNormal3f(0.083496, 0.388672, -0.917969);
 glVertex3f(0.133751, 0.193942, -0.186327);
 glNormal3f(0.072266, 0.339355, -0.937988);
 glVertex3f(-0.066765, 0.210378, -0.199475);
 glNormal3f(0.129395, 0.480469, -0.867188);
 glVertex3f(-0.066765, 0.312279, -0.160030);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.175781, 0.421875, -0.889648);
 glVertex3f(1.573523, 0.161070, -0.153455);
 glNormal3f(0.069824, 0.180176, -0.981445);
 glVertex3f(1.468334, 0.075604, -0.176465);
 glNormal3f(0.039551, 0.314941, -0.948242);
 glVertex3f(1.468334, 0.167645, -0.156743);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.027344, 0.416016, -0.909180);
 glVertex3f(1.271105, 0.170932, -0.163317);
 glNormal3f(0.047363, 0.239746, -0.969727);
 glVertex3f(1.274392, 0.078892, -0.189614);
 glNormal3f(0.043945, 0.280273, -0.958984);
 glVertex3f(0.311257, 0.095327, -0.212624);
 glNormal3f(0.052246, 0.437500, -0.897949);
 glVertex3f(0.314545, 0.190655, -0.173178);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.052246, 0.437500, -0.897949);
 glVertex3f(0.314545, 0.190655, -0.173178);
 glNormal3f(0.043945, 0.280273, -0.958984);
 glVertex3f(0.311257, 0.095327, -0.212624);
 glNormal3f(0.062012, 0.263672, -0.962891);
 glVertex3f(0.137038, 0.095327, -0.225773);
 glNormal3f(0.083496, 0.388672, -0.917969);
 glVertex3f(0.133751, 0.193942, -0.186327);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.083496, 0.388672, -0.917969);
 glVertex3f(0.133751, 0.193942, -0.186327);
 glNormal3f(0.062012, 0.263672, -0.962891);
 glVertex3f(0.137038, 0.095327, -0.225773);
 glNormal3f(0.051758, 0.225098, -0.973145);
 glVertex3f(-0.070052, 0.095327, -0.238921);
 glNormal3f(0.072266, 0.339355, -0.937988);
 glVertex3f(-0.066765, 0.210378, -0.199475);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207031, 0.225098, -0.952148);
 glVertex3f(1.658989, 0.075604, -0.163317);
 glNormal3f(0.225098, 0.001953, -0.974609);
 glVertex3f(1.691860, 0.000000, -0.163317);
 glNormal3f(0.085938, 0.002441, -0.996582);
 glVertex3f(1.468334, 0.000000, -0.186327);
 glNormal3f(0.069824, 0.180176, -0.981445);
 glVertex3f(1.468334, 0.075604, -0.176465);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047363, 0.239746, -0.969727);
 glVertex3f(1.274392, 0.078892, -0.189614);
 glNormal3f(0.057617, 0.004395, -0.998535);
 glVertex3f(1.277679, 0.000000, -0.206050);
 glNormal3f(0.041504, 0.004395, -0.999512);
 glVertex3f(0.304683, 0.000000, -0.235634);
 glNormal3f(0.043945, 0.280273, -0.958984);
 glVertex3f(0.311257, 0.095327, -0.212624);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.043945, 0.280273, -0.958984);
 glVertex3f(0.311257, 0.095327, -0.212624);
 glNormal3f(0.041504, 0.004395, -0.999512);
 glVertex3f(0.304683, 0.000000, -0.235634);
 glNormal3f(0.051270, 0.002930, -0.999023);
 glVertex3f(0.130464, 0.000000, -0.242208);
 glNormal3f(0.062012, 0.263672, -0.962891);
 glVertex3f(0.137038, 0.095327, -0.225773);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.524902, 0.000000, 0.851074);
 glVertex3f(-1.605151, 0.000000, 0.093081);
 glNormal3f(-0.533203, 0.062988, 0.843262);
 glVertex3f(-1.598577, 0.108476, 0.093081);
 glNormal3f(-0.668457, 0.093750, 0.737793);
 glVertex3f(-1.611725, 0.095327, 0.093081);
 glNormal3f(-0.668457, 0.001953, 0.743652);
 glVertex3f(-1.618299, 0.000000, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.599609, -0.314941, 0.735352);
 glVertex3f(1.711583, -0.082179, 0.093081);
 glNormal3f(0.683594, 0.002441, 0.729492);
 glVertex3f(1.728019, 0.000000, 0.093081);
 glNormal3f(0.521973, 0.001465, 0.852539);
 glVertex3f(1.711583, 0.000000, 0.093081);
 glNormal3f(0.471191, -0.270020, 0.839355);
 glVertex3f(1.695147, -0.072317, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047852, 0.002441, 0.998535);
 glVertex3f(0.130464, 0.000000, 0.234428);
 glNormal3f(0.056641, -0.253906, 0.965332);
 glVertex3f(0.133751, -0.095327, 0.217993);
 glNormal3f(0.041016, -0.275391, 0.960449);
 glVertex3f(0.307970, -0.098614, 0.208131);
 glNormal3f(0.037598, 0.003418, 0.999023);
 glVertex3f(0.298109, 0.000000, 0.227854);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.037598, 0.003418, 0.999023);
 glVertex3f(0.298109, 0.000000, 0.227854);
 glNormal3f(0.041016, -0.275391, 0.960449);
 glVertex3f(0.307970, -0.098614, 0.208131);
 glNormal3f(0.048828, -0.242188, 0.968750);
 glVertex3f(1.254669, -0.082179, 0.181834);
 glNormal3f(0.062500, 0.003418, 0.997559);
 glVertex3f(1.254669, 0.000000, 0.201557);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.088379, 0.003418, 0.995605);
 glVertex3f(1.445324, 0.000000, 0.178547);
 glNormal3f(0.070312, -0.174805, 0.981934);
 glVertex3f(1.445324, -0.078892, 0.168685);
 glNormal3f(0.241211, -0.214355, 0.946289);
 glVertex3f(1.632692, -0.075604, 0.155537);
 glNormal3f(0.288574, 0.005859, 0.957031);
 glVertex3f(1.662276, 0.000000, 0.158824);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.050293, -0.222656, 0.973633);
 glVertex3f(-0.066765, -0.098614, 0.231141);
 glNormal3f(0.066406, -0.336426, 0.938965);
 glVertex3f(-0.066765, -0.210378, 0.191695);
 glNormal3f(0.080566, -0.392090, 0.916016);
 glVertex3f(0.133751, -0.197229, 0.181834);
 glNormal3f(0.056641, -0.253906, 0.965332);
 glVertex3f(0.133751, -0.095327, 0.217993);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.056641, -0.253906, 0.965332);
 glVertex3f(0.133751, -0.095327, 0.217993);
 glNormal3f(0.080566, -0.392090, 0.916016);
 glVertex3f(0.133751, -0.197229, 0.181834);
 glNormal3f(0.055664, -0.452148, 0.890137);
 glVertex3f(0.307970, -0.190655, 0.168685);
 glNormal3f(0.041016, -0.275391, 0.960449);
 glVertex3f(0.307970, -0.098614, 0.208131);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.041016, -0.275391, 0.960449);
 glVertex3f(0.307970, -0.098614, 0.208131);
 glNormal3f(0.055664, -0.452148, 0.890137);
 glVertex3f(0.307970, -0.190655, 0.168685);
 glNormal3f(0.026367, -0.428711, 0.902832);
 glVertex3f(1.248095, -0.170932, 0.155537);
 glNormal3f(0.048828, -0.242188, 0.968750);
 glVertex3f(1.254669, -0.082179, 0.181834);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.052734, -0.305664, 0.950684);
 glVertex3f(1.445324, -0.167645, 0.152250);
 glNormal3f(0.169922, -0.408203, 0.896484);
 glVertex3f(1.547226, -0.161070, 0.145675);
 glNormal3f(0.070312, -0.174805, 0.981934);
 glVertex3f(1.445324, -0.078892, 0.168685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.066406, -0.336426, 0.938965);
 glVertex3f(-0.066765, -0.210378, 0.191695);
 glNormal3f(0.129395, -0.500000, 0.855957);
 glVertex3f(-0.063478, -0.308992, 0.155537);
 glNormal3f(0.149414, -0.607910, 0.779785);
 glVertex3f(0.140326, -0.239962, 0.162111);
 glNormal3f(0.080566, -0.392090, 0.916016);
 glVertex3f(0.133751, -0.197229, 0.181834);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.080566, -0.392090, 0.916016);
 glVertex3f(0.133751, -0.197229, 0.181834);
 glNormal3f(0.149414, -0.607910, 0.779785);
 glVertex3f(0.140326, -0.239962, 0.162111);
 glNormal3f(0.083496, -0.723145, 0.685547);
 glVertex3f(0.314545, -0.216952, 0.148962);
 glNormal3f(0.055664, -0.452148, 0.890137);
 glVertex3f(0.307970, -0.190655, 0.168685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.055664, -0.452148, 0.890137);
 glVertex3f(0.307970, -0.190655, 0.168685);
 glNormal3f(0.083496, -0.723145, 0.685547);
 glVertex3f(0.314545, -0.216952, 0.148962);
 glNormal3f(0.018066, -0.752930, 0.658203);
 glVertex3f(1.254669, -0.197229, 0.135814);
 glNormal3f(0.026367, -0.428711, 0.902832);
 glVertex3f(1.248095, -0.170932, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.096680, -0.664062, 0.741211);
 glVertex3f(1.474908, -0.193942, 0.139101);
 glNormal3f(0.147949, -0.932617, 0.329102);
 glVertex3f(1.474908, -0.200516, 0.122665);
 glNormal3f(0.382812, -0.785645, 0.485352);
 glVertex3f(1.570236, -0.170932, 0.129239);
 glNormal3f(0.169922, -0.408203, 0.896484);
 glVertex3f(1.547226, -0.161070, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.034180, 0.000977, 0.999023);
 glVertex3f(-0.546689, 0.000000, 0.257438);
 glNormal3f(-0.020996, 0.000488, 0.999512);
 glVertex3f(-0.809661, 0.000000, 0.267300);
 glNormal3f(-0.008789, -0.208984, 0.977539);
 glVertex3f(-0.796512, -0.111763, 0.254151);
 glNormal3f(0.032227, -0.212402, 0.976562);
 glVertex3f(-0.540114, -0.108476, 0.247577);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.080566, 0.000488, 0.996582);
 glVertex3f(-0.957582, 0.000000, 0.254151);
 glNormal3f(-0.055664, -0.174805, 0.982910);
 glVertex3f(-0.951008, -0.118337, 0.244290);
 glNormal3f(-0.008789, -0.208984, 0.977539);
 glVertex3f(-0.796512, -0.111763, 0.254151);
 glNormal3f(-0.020996, 0.000488, 0.999512);
 glVertex3f(-0.809661, 0.000000, 0.267300);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.177734, 0.000488, 0.983887);
 glVertex3f(-1.358615, 0.000000, 0.198270);
 glNormal3f(-0.166992, -0.074219, 0.982910);
 glVertex3f(-1.355327, -0.111763, 0.191695);
 glNormal3f(-0.104492, -0.123047, 0.986816);
 glVertex3f(-1.102217, -0.121625, 0.231141);
 glNormal3f(-0.124512, 0.000977, 0.992188);
 glVertex3f(-1.105504, 0.000000, 0.241003);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.354980, 0.000000, 0.934570);
 glVertex3f(-1.539408, 0.000000, 0.158824);
 glNormal3f(-0.365723, -0.061035, 0.928711);
 glVertex3f(-1.542695, -0.108476, 0.158824);
 glNormal3f(-0.166992, -0.074219, 0.982910);
 glVertex3f(-1.355327, -0.111763, 0.191695);
 glNormal3f(-0.177734, 0.000488, 0.983887);
 glVertex3f(-1.358615, 0.000000, 0.198270);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.729980, 0.000488, 0.683594);
 glVertex3f(-1.582141, 0.000000, 0.139101);
 glNormal3f(-0.746094, -0.091797, 0.659668);
 glVertex3f(-1.578854, -0.108476, 0.132527);
 glNormal3f(-0.365723, -0.061035, 0.928711);
 glVertex3f(-1.542695, -0.108476, 0.158824);
 glNormal3f(-0.354980, 0.000000, 0.934570);
 glVertex3f(-1.539408, 0.000000, 0.158824);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.524902, 0.000000, 0.851074);
 glVertex3f(-1.605151, 0.000000, 0.093081);
 glNormal3f(-0.533203, -0.062988, 0.843262);
 glVertex3f(-1.598577, -0.111763, 0.093081);
 glNormal3f(-0.746094, -0.091797, 0.659668);
 glVertex3f(-1.578854, -0.108476, 0.132527);
 glNormal3f(-0.729980, 0.000488, 0.683594);
 glVertex3f(-1.582141, 0.000000, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-1.000000, 0.002441, -0.000488);
 glVertex3f(-1.631448, 0.000000, -0.002246);
 glNormal3f(-0.990723, -0.138184, 0.000000);
 glVertex3f(-1.618299, -0.101902, -0.002246);
 glNormal3f(-0.668457, -0.093262, 0.737793);
 glVertex3f(-1.611725, -0.101902, 0.093081);
 glNormal3f(-0.668457, 0.001953, 0.743652);
 glVertex3f(-1.618299, 0.000000, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.050293, -0.222656, 0.973633);
 glVertex3f(-0.066765, -0.098614, 0.231141);
 glNormal3f(0.037598, -0.209961, 0.976562);
 glVertex3f(-0.313301, -0.108476, 0.237715);
 glNormal3f(0.034180, -0.326172, 0.944336);
 glVertex3f(-0.313301, -0.216952, 0.204844);
 glNormal3f(0.066406, -0.336426, 0.938965);
 glVertex3f(-0.066765, -0.210378, 0.191695);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.037598, -0.209961, 0.976562);
 glVertex3f(-0.313301, -0.108476, 0.237715);
 glNormal3f(0.032227, -0.212402, 0.976562);
 glVertex3f(-0.540114, -0.108476, 0.247577);
 glNormal3f(0.026367, -0.337402, 0.940918);
 glVertex3f(-0.536827, -0.220239, 0.208131);
 glNormal3f(0.034180, -0.326172, 0.944336);
 glVertex3f(-0.313301, -0.216952, 0.204844);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.026367, -0.337402, 0.940918);
 glVertex3f(-0.536827, -0.220239, 0.208131);
 glNormal3f(0.032227, -0.212402, 0.976562);
 glVertex3f(-0.540114, -0.108476, 0.247577);
 glNormal3f(-0.008789, -0.208984, 0.977539);
 glVertex3f(-0.796512, -0.111763, 0.254151);
 glNormal3f(0.025391, -0.318848, 0.947266);
 glVertex3f(-0.789938, -0.226813, 0.214705);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.668457, -0.093262, 0.737793);
 glVertex3f(-1.611725, -0.101902, 0.093081);
 glNormal3f(-0.990723, -0.138184, 0.000000);
 glVertex3f(-1.618299, -0.101902, -0.002246);
 glNormal3f(-0.966309, -0.258301, 0.000000);
 glVertex3f(-1.598577, -0.213665, -0.002246);
 glNormal3f(-0.661133, -0.176758, 0.729004);
 glVertex3f(-1.588715, -0.223526, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.533203, -0.062988, 0.843262);
 glVertex3f(-1.598577, -0.111763, 0.093081);
 glNormal3f(-0.668457, -0.093262, 0.737793);
 glVertex3f(-1.611725, -0.101902, 0.093081);
 glNormal3f(-0.661133, -0.176758, 0.729004);
 glVertex3f(-1.588715, -0.223526, 0.093081);
 glNormal3f(-0.534668, -0.152344, 0.831055);
 glVertex3f(-1.575567, -0.226813, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.746094, -0.091797, 0.659668);
 glVertex3f(-1.578854, -0.108476, 0.132527);
 glNormal3f(-0.533203, -0.062988, 0.843262);
 glVertex3f(-1.598577, -0.111763, 0.093081);
 glNormal3f(-0.534668, -0.152344, 0.831055);
 glVertex3f(-1.575567, -0.226813, 0.093081);
 glNormal3f(-0.750488, -0.224609, 0.621582);
 glVertex3f(-1.562418, -0.226813, 0.129239);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.750488, -0.224609, 0.621582);
 glVertex3f(-1.562418, -0.226813, 0.129239);
 glNormal3f(-0.375488, -0.135254, 0.916504);
 glVertex3f(-1.526259, -0.223526, 0.152250);
 glNormal3f(-0.365723, -0.061035, 0.928711);
 glVertex3f(-1.542695, -0.108476, 0.158824);
 glNormal3f(-0.746094, -0.091797, 0.659668);
 glVertex3f(-1.578854, -0.108476, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.365723, -0.061035, 0.928711);
 glVertex3f(-1.542695, -0.108476, 0.158824);
 glNormal3f(-0.375488, -0.135254, 0.916504);
 glVertex3f(-1.526259, -0.223526, 0.152250);
 glNormal3f(-0.142578, -0.128906, 0.980957);
 glVertex3f(-1.355327, -0.220239, 0.185121);
 glNormal3f(-0.166992, -0.074219, 0.982910);
 glVertex3f(-1.355327, -0.111763, 0.191695);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.166992, -0.074219, 0.982910);
 glVertex3f(-1.355327, -0.111763, 0.191695);
 glNormal3f(-0.142578, -0.128906, 0.980957);
 glVertex3f(-1.355327, -0.220239, 0.185121);
 glNormal3f(-0.061035, -0.198242, 0.978027);
 glVertex3f(-1.095643, -0.230100, 0.214705);
 glNormal3f(-0.104492, -0.123047, 0.986816);
 glVertex3f(-1.102217, -0.121625, 0.231141);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.055664, -0.174805, 0.982910);
 glVertex3f(-0.951008, -0.118337, 0.244290);
 glNormal3f(0.001953, -0.260742, 0.965332);
 glVertex3f(-0.941147, -0.226813, 0.214705);
 glNormal3f(0.025391, -0.318848, 0.947266);
 glVertex3f(-0.789938, -0.226813, 0.214705);
 glNormal3f(-0.008789, -0.208984, 0.977539);
 glVertex3f(-0.796512, -0.111763, 0.254151);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.534668, -0.152344, 0.831055);
 glVertex3f(-1.575567, -0.226813, 0.093081);
 glNormal3f(-0.661133, -0.176758, 0.729004);
 glVertex3f(-1.588715, -0.223526, 0.093081);
 glNormal3f(-0.620117, -0.319824, 0.716309);
 glVertex3f(-1.545982, -0.348438, 0.093081);
 glNormal3f(-0.506836, -0.249023, 0.825195);
 glVertex3f(-1.532834, -0.338576, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.620117, -0.319824, 0.716309);
 glVertex3f(-1.545982, -0.348438, 0.093081);
 glNormal3f(-0.661133, -0.176758, 0.729004);
 glVertex3f(-1.588715, -0.223526, 0.093081);
 glNormal3f(-0.966309, -0.258301, 0.000000);
 glVertex3f(-1.598577, -0.213665, -0.002246);
 glNormal3f(-0.889160, -0.458496, 0.000000);
 glVertex3f(-1.552556, -0.338576, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.506836, -0.249023, 0.825195);
 glVertex3f(-1.532834, -0.338576, 0.093081);
 glNormal3f(-0.620117, -0.319824, 0.716309);
 glVertex3f(-1.545982, -0.348438, 0.093081);
 glNormal3f(-0.497070, -0.498535, 0.710449);
 glVertex3f(-1.503249, -0.410894, 0.093081);
 glNormal3f(-0.421387, -0.363770, 0.830566);
 glVertex3f(-1.493388, -0.401032, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.421387, -0.363770, 0.830566);
 glVertex3f(-1.493388, -0.401032, 0.093081);
 glNormal3f(-0.629395, -0.528809, 0.569824);
 glVertex3f(-1.490101, -0.387884, 0.122665);
 glNormal3f(-0.732422, -0.351562, 0.583496);
 glVertex3f(-1.522972, -0.328715, 0.122665);
 glNormal3f(-0.506836, -0.249023, 0.825195);
 glVertex3f(-1.532834, -0.338576, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.506836, -0.249023, 0.825195);
 glVertex3f(-1.532834, -0.338576, 0.093081);
 glNormal3f(-0.732422, -0.351562, 0.583496);
 glVertex3f(-1.522972, -0.328715, 0.122665);
 glNormal3f(-0.750488, -0.224609, 0.621582);
 glVertex3f(-1.562418, -0.226813, 0.129239);
 glNormal3f(-0.534668, -0.152344, 0.831055);
 glVertex3f(-1.575567, -0.226813, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.750488, -0.224609, 0.621582);
 glVertex3f(-1.562418, -0.226813, 0.129239);
 glNormal3f(-0.732422, -0.351562, 0.583496);
 glVertex3f(-1.522972, -0.328715, 0.122665);
 glNormal3f(-0.397949, -0.185547, 0.898438);
 glVertex3f(-1.496675, -0.308992, 0.148962);
 glNormal3f(-0.375488, -0.135254, 0.916504);
 glVertex3f(-1.526259, -0.223526, 0.152250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.397949, -0.185547, 0.898438);
 glVertex3f(-1.496675, -0.308992, 0.148962);
 glNormal3f(-0.732422, -0.351562, 0.583496);
 glVertex3f(-1.522972, -0.328715, 0.122665);
 glNormal3f(-0.629395, -0.528809, 0.569824);
 glVertex3f(-1.490101, -0.387884, 0.122665);
 glNormal3f(-0.337891, -0.288086, 0.895996);
 glVertex3f(-1.473665, -0.364874, 0.148962);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.397949, -0.185547, 0.898438);
 glVertex3f(-1.496675, -0.308992, 0.148962);
 glNormal3f(-0.337891, -0.288086, 0.895996);
 glVertex3f(-1.473665, -0.364874, 0.148962);
 glNormal3f(-0.142578, -0.128906, 0.980957);
 glVertex3f(-1.355327, -0.220239, 0.185121);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.397949, -0.185547, 0.898438);
 glVertex3f(-1.496675, -0.308992, 0.148962);
 glNormal3f(-0.142578, -0.128906, 0.980957);
 glVertex3f(-1.355327, -0.220239, 0.185121);
 glNormal3f(-0.375488, -0.135254, 0.916504);
 glVertex3f(-1.526259, -0.223526, 0.152250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.222656, -0.452637, 0.863281);
 glVertex3f(-1.437506, -0.397745, 0.145675);
 glNormal3f(-0.374023, -0.699707, 0.608887);
 glVertex3f(-1.444080, -0.427329, 0.119378);
 glNormal3f(-0.164551, -0.738770, 0.653320);
 glVertex3f(-1.361902, -0.450339, 0.122665);
 glNormal3f(-0.111328, -0.385742, 0.915527);
 glVertex3f(-1.355327, -0.417468, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.004883, -0.744629, 0.667480);
 glVertex3f(-1.072633, -0.470062, 0.148962);
 glNormal3f(-0.164551, -0.738770, 0.653320);
 glVertex3f(-1.361902, -0.450339, 0.122665);
 glNormal3f(-0.105957, -0.512695, 0.852051);
 glVertex3f(-1.365189, -0.466775, 0.093081);
 glNormal3f(0.013184, -0.543945, 0.838867);
 glVertex3f(-1.072633, -0.493072, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.025391, -0.369629, 0.928711);
 glVertex3f(-1.079207, -0.440478, 0.165398);
 glNormal3f(-0.111328, -0.385742, 0.915527);
 glVertex3f(-1.355327, -0.417468, 0.145675);
 glNormal3f(-0.164551, -0.738770, 0.653320);
 glVertex3f(-1.361902, -0.450339, 0.122665);
 glNormal3f(0.004883, -0.744629, 0.667480);
 glVertex3f(-1.072633, -0.470062, 0.148962);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.374023, -0.699707, 0.608887);
 glVertex3f(-1.444080, -0.427329, 0.119378);
 glNormal3f(-0.254883, -0.468262, 0.846191);
 glVertex3f(-1.444080, -0.440478, 0.093081);
 glNormal3f(-0.105957, -0.512695, 0.852051);
 glVertex3f(-1.365189, -0.466775, 0.093081);
 glNormal3f(-0.164551, -0.738770, 0.653320);
 glVertex3f(-1.361902, -0.450339, 0.122665);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.747070, -0.665039, 0.000000);
 glVertex3f(-1.503249, -0.407607, -0.002246);
 glNormal3f(-0.497070, -0.498535, 0.710449);
 glVertex3f(-1.503249, -0.410894, 0.093081);
 glNormal3f(-0.620117, -0.319824, 0.716309);
 glVertex3f(-1.545982, -0.348438, 0.093081);
 glNormal3f(-0.889160, -0.458496, 0.000000);
 glVertex3f(-1.552556, -0.338576, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.231445, -0.973145, 0.000000);
 glVertex3f(-1.352040, -0.493072, -0.002246);
 glNormal3f(0.029785, -1.000000, 0.000000);
 glVertex3f(-1.072633, -0.522657, -0.002246);
 glNormal3f(0.019043, -0.646484, 0.762695);
 glVertex3f(-1.072633, -0.506221, 0.093081);
 glNormal3f(-0.154297, -0.647949, 0.745605);
 glVertex3f(-1.371763, -0.476637, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.154297, -0.647949, 0.745605);
 glVertex3f(-1.371763, -0.476637, 0.093081);
 glNormal3f(0.019043, -0.646484, 0.762695);
 glVertex3f(-1.072633, -0.506221, 0.093081);
 glNormal3f(0.013184, -0.543945, 0.838867);
 glVertex3f(-1.072633, -0.493072, 0.093081);
 glNormal3f(-0.105957, -0.512695, 0.852051);
 glVertex3f(-1.365189, -0.466775, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.201172, -0.979492, 0.000000);
 glVertex3f(-0.766928, -0.447052, -0.002246);
 glNormal3f(0.134277, -0.653809, 0.744629);
 glVertex3f(-0.770215, -0.437191, 0.093081);
 glNormal3f(0.150879, -0.639160, 0.753906);
 glVertex3f(-0.921424, -0.483211, 0.093081);
 glNormal3f(0.229492, -0.973633, 0.000000);
 glVertex3f(-0.921424, -0.496360, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.325195, -0.615723, 0.717773);
 glVertex3f(-1.450655, -0.450339, 0.093081);
 glNormal3f(-0.154297, -0.647949, 0.745605);
 glVertex3f(-1.371763, -0.476637, 0.093081);
 glNormal3f(-0.105957, -0.512695, 0.852051);
 glVertex3f(-1.365189, -0.466775, 0.093081);
 glNormal3f(-0.254883, -0.468262, 0.846191);
 glVertex3f(-1.444080, -0.440478, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.325195, -0.615723, 0.717773);
 glVertex3f(-1.450655, -0.450339, 0.093081);
 glNormal3f(-0.430176, -0.902832, 0.000000);
 glVertex3f(-1.444080, -0.453627, -0.002246);
 glNormal3f(-0.231445, -0.973145, 0.000000);
 glVertex3f(-1.352040, -0.493072, -0.002246);
 glNormal3f(-0.154297, -0.647949, 0.745605);
 glVertex3f(-1.371763, -0.476637, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.134277, -0.653809, 0.744629);
 glVertex3f(-0.770215, -0.437191, 0.093081);
 glNormal3f(0.201172, -0.979492, 0.000000);
 glVertex3f(-0.766928, -0.447052, -0.002246);
 glNormal3f(0.040527, -0.999512, 0.000000);
 glVertex3f(-0.530253, -0.420755, -0.002246);
 glNormal3f(0.027344, -0.674316, 0.737793);
 glVertex3f(-0.533540, -0.414181, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.027344, -0.674316, 0.737793);
 glVertex3f(-0.533540, -0.414181, 0.093081);
 glNormal3f(0.023438, -0.579590, 0.814453);
 glVertex3f(-0.533540, -0.401032, 0.093081);
 glNormal3f(0.112305, -0.572754, 0.812012);
 glVertex3f(-0.770215, -0.424042, 0.093081);
 glNormal3f(0.134277, -0.653809, 0.744629);
 glVertex3f(-0.770215, -0.437191, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.134277, -0.653809, 0.744629);
 glVertex3f(-0.770215, -0.437191, 0.093081);
 glNormal3f(0.112305, -0.572754, 0.812012);
 glVertex3f(-0.770215, -0.424042, 0.093081);
 glNormal3f(0.122559, -0.555664, 0.822266);
 glVertex3f(-0.921424, -0.470062, 0.093081);
 glNormal3f(0.150879, -0.639160, 0.753906);
 glVertex3f(-0.921424, -0.483211, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.112305, -0.572754, 0.812012);
 glVertex3f(-0.770215, -0.424042, 0.093081);
 glNormal3f(0.159180, -0.775391, 0.611328);
 glVertex3f(-0.780076, -0.410894, 0.139101);
 glNormal3f(0.171875, -0.744141, 0.645508);
 glVertex3f(-0.924711, -0.450339, 0.145675);
 glNormal3f(0.122559, -0.555664, 0.822266);
 glVertex3f(-0.921424, -0.470062, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.159180, -0.775391, 0.611328);
 glVertex3f(-0.780076, -0.410894, 0.139101);
 glNormal3f(0.083496, -0.432617, 0.897461);
 glVertex3f(-0.783363, -0.378022, 0.162111);
 glNormal3f(0.079102, -0.381348, 0.920898);
 glVertex3f(-0.931285, -0.420755, 0.162111);
 glNormal3f(0.171875, -0.744141, 0.645508);
 glVertex3f(-0.924711, -0.450339, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.025391, -0.369629, 0.928711);
 glVertex3f(-1.079207, -0.440478, 0.165398);
 glNormal3f(-0.061035, -0.198242, 0.978027);
 glVertex3f(-1.095643, -0.230100, 0.214705);
 glNormal3f(-0.142578, -0.128906, 0.980957);
 glVertex3f(-1.355327, -0.220239, 0.185121);
 glNormal3f(-0.111328, -0.385742, 0.915527);
 glVertex3f(-1.355327, -0.417468, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.079102, -0.381348, 0.920898);
 glVertex3f(-0.931285, -0.420755, 0.162111);
 glNormal3f(0.083496, -0.432617, 0.897461);
 glVertex3f(-0.783363, -0.378022, 0.162111);
 glNormal3f(0.025391, -0.318848, 0.947266);
 glVertex3f(-0.789938, -0.226813, 0.214705);
 glNormal3f(0.001953, -0.260742, 0.965332);
 glVertex3f(-0.941147, -0.226813, 0.214705);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.025391, -0.318848, 0.947266);
 glVertex3f(-0.789938, -0.226813, 0.214705);
 glNormal3f(0.083496, -0.432617, 0.897461);
 glVertex3f(-0.783363, -0.378022, 0.162111);
 glNormal3f(0.023926, -0.463379, 0.885742);
 glVertex3f(-0.533540, -0.368161, 0.145675);
 glNormal3f(0.026367, -0.337402, 0.940918);
 glVertex3f(-0.536827, -0.220239, 0.208131);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.033203, -0.794922, 0.605957);
 glVertex3f(-0.533540, -0.387884, 0.132527);
 glNormal3f(0.023926, -0.463379, 0.885742);
 glVertex3f(-0.533540, -0.368161, 0.145675);
 glNormal3f(0.083496, -0.432617, 0.897461);
 glVertex3f(-0.783363, -0.378022, 0.162111);
 glNormal3f(0.159180, -0.775391, 0.611328);
 glVertex3f(-0.780076, -0.410894, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.159180, -0.775391, 0.611328);
 glVertex3f(-0.780076, -0.410894, 0.139101);
 glNormal3f(0.112305, -0.572754, 0.812012);
 glVertex3f(-0.770215, -0.424042, 0.093081);
 glNormal3f(0.023438, -0.579590, 0.814453);
 glVertex3f(-0.533540, -0.401032, 0.093081);
 glNormal3f(0.033203, -0.794922, 0.605957);
 glVertex3f(-0.533540, -0.387884, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.027344, -0.674316, 0.737793);
 glVertex3f(-0.533540, -0.414181, 0.093081);
 glNormal3f(0.040527, -0.999512, 0.000000);
 glVertex3f(-0.530253, -0.420755, -0.002246);
 glNormal3f(0.091797, -0.996094, 0.000000);
 glVertex3f(-0.310014, -0.427329, -0.002246);
 glNormal3f(0.061523, -0.670410, 0.739258);
 glVertex3f(-0.310014, -0.417468, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.061523, -0.670410, 0.739258);
 glVertex3f(-0.310014, -0.417468, 0.093081);
 glNormal3f(0.055664, -0.562988, 0.824219);
 glVertex3f(-0.306727, -0.407607, 0.093081);
 glNormal3f(0.023438, -0.579590, 0.814453);
 glVertex3f(-0.533540, -0.401032, 0.093081);
 glNormal3f(0.027344, -0.674316, 0.737793);
 glVertex3f(-0.533540, -0.414181, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.023438, -0.579590, 0.814453);
 glVertex3f(-0.533540, -0.401032, 0.093081);
 glNormal3f(0.055664, -0.562988, 0.824219);
 glVertex3f(-0.306727, -0.407607, 0.093081);
 glNormal3f(0.077637, -0.789062, 0.609375);
 glVertex3f(-0.306727, -0.387884, 0.139101);
 glNormal3f(0.033203, -0.794922, 0.605957);
 glVertex3f(-0.533540, -0.387884, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.033203, -0.794922, 0.605957);
 glVertex3f(-0.533540, -0.387884, 0.132527);
 glNormal3f(0.077637, -0.789062, 0.609375);
 glVertex3f(-0.306727, -0.387884, 0.139101);
 glNormal3f(0.042969, -0.465820, 0.883789);
 glVertex3f(-0.306727, -0.364874, 0.155537);
 glNormal3f(0.023926, -0.463379, 0.885742);
 glVertex3f(-0.533540, -0.368161, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.023926, -0.463379, 0.885742);
 glVertex3f(-0.533540, -0.368161, 0.145675);
 glNormal3f(0.042969, -0.465820, 0.883789);
 glVertex3f(-0.306727, -0.364874, 0.155537);
 glNormal3f(0.034180, -0.326172, 0.944336);
 glVertex3f(-0.313301, -0.216952, 0.204844);
 glNormal3f(0.026367, -0.337402, 0.940918);
 glVertex3f(-0.536827, -0.220239, 0.208131);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.042969, -0.465820, 0.883789);
 glVertex3f(-0.306727, -0.364874, 0.155537);
 glNormal3f(0.129395, -0.500000, 0.855957);
 glVertex3f(-0.063478, -0.308992, 0.155537);
 glNormal3f(0.066406, -0.336426, 0.938965);
 glVertex3f(-0.066765, -0.210378, 0.191695);
 glNormal3f(0.034180, -0.326172, 0.944336);
 glVertex3f(-0.313301, -0.216952, 0.204844);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.042969, -0.465820, 0.883789);
 glVertex3f(-0.306727, -0.364874, 0.155537);
 glNormal3f(0.077637, -0.789062, 0.609375);
 glVertex3f(-0.306727, -0.387884, 0.139101);
 glNormal3f(0.229492, -0.795898, 0.560059);
 glVertex3f(-0.063478, -0.338576, 0.132527);
 glNormal3f(0.129395, -0.500000, 0.855957);
 glVertex3f(-0.063478, -0.308992, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.077637, -0.789062, 0.609375);
 glVertex3f(-0.306727, -0.387884, 0.139101);
 glNormal3f(0.055664, -0.562988, 0.824219);
 glVertex3f(-0.306727, -0.407607, 0.093081);
 glNormal3f(0.161621, -0.554199, 0.816406);
 glVertex3f(-0.076626, -0.355012, 0.093081);
 glNormal3f(0.229492, -0.795898, 0.560059);
 glVertex3f(-0.063478, -0.338576, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.055664, -0.562988, 0.824219);
 glVertex3f(-0.306727, -0.407607, 0.093081);
 glNormal3f(0.061523, -0.670410, 0.739258);
 glVertex3f(-0.310014, -0.417468, 0.093081);
 glNormal3f(0.172363, -0.646973, 0.742676);
 glVertex3f(-0.070052, -0.368161, 0.093081);
 glNormal3f(0.161621, -0.554199, 0.816406);
 glVertex3f(-0.076626, -0.355012, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.061523, -0.670410, 0.739258);
 glVertex3f(-0.310014, -0.417468, 0.093081);
 glNormal3f(0.091797, -0.996094, 0.000000);
 glVertex3f(-0.310014, -0.427329, -0.002246);
 glNormal3f(0.257324, -0.966309, 0.000000);
 glVertex3f(-0.079913, -0.378022, -0.002246);
 glNormal3f(0.172363, -0.646973, 0.742676);
 glVertex3f(-0.070052, -0.368161, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.257324, -0.966309, 0.000000);
 glVertex3f(-0.079913, -0.378022, -0.002246);
 glNormal3f(0.263184, -0.964844, 0.000000);
 glVertex3f(0.127177, -0.315566, -0.002246);
 glNormal3f(0.169434, -0.621582, 0.764648);
 glVertex3f(0.137038, -0.295843, 0.093081);
 glNormal3f(0.172363, -0.646973, 0.742676);
 glVertex3f(-0.070052, -0.368161, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.172363, -0.646973, 0.742676);
 glVertex3f(-0.070052, -0.368161, 0.093081);
 glNormal3f(0.169434, -0.621582, 0.764648);
 glVertex3f(0.137038, -0.295843, 0.093081);
 glNormal3f(0.161621, -0.562012, 0.811035);
 glVertex3f(0.137038, -0.279408, 0.093081);
 glNormal3f(0.161621, -0.554199, 0.816406);
 glVertex3f(-0.076626, -0.355012, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.161621, -0.554199, 0.816406);
 glVertex3f(-0.076626, -0.355012, 0.093081);
 glNormal3f(0.161621, -0.562012, 0.811035);
 glVertex3f(0.137038, -0.279408, 0.093081);
 glNormal3f(0.233887, -0.846191, 0.478516);
 glVertex3f(0.140326, -0.259685, 0.139101);
 glNormal3f(0.229492, -0.795898, 0.560059);
 glVertex3f(-0.063478, -0.338576, 0.132527);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.229492, -0.795898, 0.560059);
 glVertex3f(-0.063478, -0.338576, 0.132527);
 glNormal3f(0.233887, -0.846191, 0.478516);
 glVertex3f(0.140326, -0.259685, 0.139101);
 glNormal3f(0.149414, -0.607910, 0.779785);
 glVertex3f(0.140326, -0.239962, 0.162111);
 glNormal3f(0.129395, -0.500000, 0.855957);
 glVertex3f(-0.063478, -0.308992, 0.155537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.042480, 0.001953, 0.999023);
 glVertex3f(-0.073339, 0.000000, 0.241003);
 glNormal3f(0.035645, 0.001465, 0.999023);
 glVertex3f(-0.316588, 0.000000, 0.250864);
 glNormal3f(0.037598, -0.209961, 0.976562);
 glVertex3f(-0.313301, -0.108476, 0.237715);
 glNormal3f(0.050293, -0.222656, 0.973633);
 glVertex3f(-0.066765, -0.098614, 0.231141);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.050293, -0.222656, 0.973633);
 glVertex3f(-0.066765, -0.098614, 0.231141);
 glNormal3f(0.056641, -0.253906, 0.965332);
 glVertex3f(0.133751, -0.095327, 0.217993);
 glNormal3f(0.047852, 0.002441, 0.998535);
 glVertex3f(0.130464, 0.000000, 0.234428);
 glNormal3f(0.042480, 0.001953, 0.999023);
 glVertex3f(-0.073339, 0.000000, 0.241003);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.035645, 0.001465, 0.999023);
 glVertex3f(-0.316588, 0.000000, 0.250864);
 glNormal3f(0.034180, 0.000977, 0.999023);
 glVertex3f(-0.546689, 0.000000, 0.257438);
 glNormal3f(0.032227, -0.212402, 0.976562);
 glVertex3f(-0.540114, -0.108476, 0.247577);
 glNormal3f(0.037598, -0.209961, 0.976562);
 glVertex3f(-0.313301, -0.108476, 0.237715);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.263184, -0.964844, 0.000000);
 glVertex3f(0.127177, -0.315566, -0.002246);
 glNormal3f(0.122070, -0.992676, 0.000000);
 glVertex3f(0.311257, -0.279408, -0.002246);
 glNormal3f(0.075684, -0.616211, 0.783691);
 glVertex3f(0.324406, -0.249823, 0.093081);
 glNormal3f(0.169434, -0.621582, 0.764648);
 glVertex3f(0.137038, -0.295843, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.169434, -0.621582, 0.764648);
 glVertex3f(0.137038, -0.295843, 0.093081);
 glNormal3f(0.075684, -0.616211, 0.783691);
 glVertex3f(0.324406, -0.249823, 0.093081);
 glNormal3f(0.069824, -0.601074, 0.795898);
 glVertex3f(0.324406, -0.236675, 0.093081);
 glNormal3f(0.161621, -0.562012, 0.811035);
 glVertex3f(0.137038, -0.279408, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.161621, -0.562012, 0.811035);
 glVertex3f(0.137038, -0.279408, 0.093081);
 glNormal3f(0.069824, -0.601074, 0.795898);
 glVertex3f(0.324406, -0.236675, 0.093081);
 glNormal3f(0.105469, -0.916992, 0.384766);
 glVertex3f(0.321119, -0.230100, 0.119378);
 glNormal3f(0.233887, -0.846191, 0.478516);
 glVertex3f(0.140326, -0.259685, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.233887, -0.846191, 0.478516);
 glVertex3f(0.140326, -0.259685, 0.139101);
 glNormal3f(0.105469, -0.916992, 0.384766);
 glVertex3f(0.321119, -0.230100, 0.119378);
 glNormal3f(0.083496, -0.723145, 0.685547);
 glVertex3f(0.314545, -0.216952, 0.148962);
 glNormal3f(0.149414, -0.607910, 0.779785);
 glVertex3f(0.140326, -0.239962, 0.162111);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.122070, -0.992676, 0.000000);
 glVertex3f(0.311257, -0.279408, -0.002246);
 glNormal3f(0.047363, -0.999023, 0.000000);
 glVertex3f(1.248095, -0.246536, -0.002246);
 glNormal3f(0.030273, -0.635742, 0.770996);
 glVertex3f(1.261244, -0.230100, 0.093081);
 glNormal3f(0.075684, -0.616211, 0.783691);
 glVertex3f(0.324406, -0.249823, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.075684, -0.616211, 0.783691);
 glVertex3f(0.324406, -0.249823, 0.093081);
 glNormal3f(0.030273, -0.635742, 0.770996);
 glVertex3f(1.261244, -0.230100, 0.093081);
 glNormal3f(0.020996, -0.642578, 0.766113);
 glVertex3f(1.261244, -0.213665, 0.093081);
 glNormal3f(0.069824, -0.601074, 0.795898);
 glVertex3f(0.324406, -0.236675, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.069824, -0.601074, 0.795898);
 glVertex3f(0.324406, -0.236675, 0.093081);
 glNormal3f(0.020996, -0.642578, 0.766113);
 glVertex3f(1.261244, -0.213665, 0.093081);
 glNormal3f(0.025879, -0.949707, 0.312500);
 glVertex3f(1.257957, -0.210378, 0.112804);
 glNormal3f(0.105469, -0.916992, 0.384766);
 glVertex3f(0.321119, -0.230100, 0.119378);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.105469, -0.916992, 0.384766);
 glVertex3f(0.321119, -0.230100, 0.119378);
 glNormal3f(0.025879, -0.949707, 0.312500);
 glVertex3f(1.257957, -0.210378, 0.112804);
 glNormal3f(0.018066, -0.752930, 0.658203);
 glVertex3f(1.254669, -0.197229, 0.135814);
 glNormal3f(0.083496, -0.723145, 0.685547);
 glVertex3f(0.314545, -0.216952, 0.148962);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.127441, -0.650879, 0.748535);
 glVertex3f(1.474908, -0.216952, 0.093081);
 glNormal3f(0.192383, -0.981445, 0.000000);
 glVertex3f(1.474908, -0.230100, -0.002246);
 glNormal3f(0.456055, -0.890137, 0.000000);
 glVertex3f(1.596533, -0.184080, -0.002246);
 glNormal3f(0.312012, -0.609375, 0.729004);
 glVertex3f(1.589959, -0.184080, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.312012, -0.609375, 0.729004);
 glVertex3f(1.589959, -0.184080, 0.093081);
 glNormal3f(0.271973, -0.540527, 0.795898);
 glVertex3f(1.580097, -0.177506, 0.093081);
 glNormal3f(0.099121, -0.639160, 0.762207);
 glVertex3f(1.474908, -0.203803, 0.093081);
 glNormal3f(0.127441, -0.650879, 0.748535);
 glVertex3f(1.474908, -0.216952, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.271973, -0.540527, 0.795898);
 glVertex3f(1.580097, -0.177506, 0.093081);
 glNormal3f(0.382812, -0.785645, 0.485352);
 glVertex3f(1.570236, -0.170932, 0.129239);
 glNormal3f(0.147949, -0.932617, 0.329102);
 glVertex3f(1.474908, -0.200516, 0.122665);
 glNormal3f(0.099121, -0.639160, 0.762207);
 glVertex3f(1.474908, -0.203803, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.169922, -0.408203, 0.896484);
 glVertex3f(1.547226, -0.161070, 0.145675);
 glNormal3f(0.382812, -0.785645, 0.485352);
 glVertex3f(1.570236, -0.170932, 0.129239);
 glNormal3f(0.507324, -0.601074, 0.617676);
 glVertex3f(1.622830, -0.124912, 0.135814);
 glNormal3f(0.198242, -0.316406, 0.927246);
 glVertex3f(1.589959, -0.118337, 0.152250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.241211, -0.214355, 0.946289);
 glVertex3f(1.632692, -0.075604, 0.155537);
 glNormal3f(0.629883, -0.396973, 0.666992);
 glVertex3f(1.668850, -0.075604, 0.139101);
 glNormal3f(0.724609, 0.005859, 0.688477);
 glVertex3f(1.691860, 0.000000, 0.139101);
 glNormal3f(0.288574, 0.005859, 0.957031);
 glVertex3f(1.662276, 0.000000, 0.158824);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.724609, 0.005859, 0.688477);
 glVertex3f(1.691860, 0.000000, 0.139101);
 glNormal3f(0.629883, -0.396973, 0.666992);
 glVertex3f(1.668850, -0.075604, 0.139101);
 glNormal3f(0.471191, -0.270020, 0.839355);
 glVertex3f(1.695147, -0.072317, 0.093081);
 glNormal3f(0.521973, 0.001465, 0.852539);
 glVertex3f(1.711583, 0.000000, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.382812, -0.785645, 0.485352);
 glVertex3f(1.570236, -0.170932, 0.129239);
 glNormal3f(0.271973, -0.540527, 0.795898);
 glVertex3f(1.580097, -0.177506, 0.093081);
 glNormal3f(0.388184, -0.425293, 0.817383);
 glVertex3f(1.639266, -0.131486, 0.093081);
 glNormal3f(0.507324, -0.601074, 0.617676);
 glVertex3f(1.622830, -0.124912, 0.135814);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.271973, -0.540527, 0.795898);
 glVertex3f(1.580097, -0.177506, 0.093081);
 glNormal3f(0.312012, -0.609375, 0.729004);
 glVertex3f(1.589959, -0.184080, 0.093081);
 glNormal3f(0.452148, -0.530273, 0.716797);
 glVertex3f(1.655702, -0.138060, 0.093081);
 glNormal3f(0.388184, -0.425293, 0.817383);
 glVertex3f(1.639266, -0.131486, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.312012, -0.609375, 0.729004);
 glVertex3f(1.589959, -0.184080, 0.093081);
 glNormal3f(0.456055, -0.890137, 0.000000);
 glVertex3f(1.596533, -0.184080, -0.002246);
 glNormal3f(0.648926, -0.761230, 0.000000);
 glVertex3f(1.662276, -0.134773, -0.002246);
 glNormal3f(0.452148, -0.530273, 0.716797);
 glVertex3f(1.655702, -0.138060, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.599609, -0.314941, 0.735352);
 glVertex3f(1.711583, -0.082179, 0.093081);
 glNormal3f(0.885254, -0.464844, 0.000000);
 glVertex3f(1.718157, -0.078892, -0.002246);
 glNormal3f(0.999512, 0.003418, 0.000000);
 glVertex3f(1.731306, 0.000000, -0.002246);
 glNormal3f(0.683594, 0.002441, 0.729492);
 glVertex3f(1.728019, 0.000000, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.062500, 0.003418, 0.997559);
 glVertex3f(1.254669, 0.000000, 0.201557);
 glNormal3f(0.048828, -0.242188, 0.968750);
 glVertex3f(1.254669, -0.082179, 0.181834);
 glNormal3f(0.070312, -0.174805, 0.981934);
 glVertex3f(1.445324, -0.078892, 0.168685);
 glNormal3f(0.088379, 0.003418, 0.995605);
 glVertex3f(1.445324, 0.000000, 0.178547);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.048828, -0.242188, 0.968750);
 glVertex3f(1.254669, -0.082179, 0.181834);
 glNormal3f(0.026367, -0.428711, 0.902832);
 glVertex3f(1.248095, -0.170932, 0.155537);
 glNormal3f(0.052734, -0.305664, 0.950684);
 glVertex3f(1.445324, -0.167645, 0.152250);
 glNormal3f(0.070312, -0.174805, 0.981934);
 glVertex3f(1.445324, -0.078892, 0.168685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.025879, -0.949707, 0.312500);
 glVertex3f(1.257957, -0.210378, 0.112804);
 glNormal3f(0.020996, -0.642578, 0.766113);
 glVertex3f(1.261244, -0.213665, 0.093081);
 glNormal3f(0.099121, -0.639160, 0.762207);
 glVertex3f(1.474908, -0.203803, 0.093081);
 glNormal3f(0.147949, -0.932617, 0.329102);
 glVertex3f(1.474908, -0.200516, 0.122665);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.020996, -0.642578, 0.766113);
 glVertex3f(1.261244, -0.213665, 0.093081);
 glNormal3f(0.030273, -0.635742, 0.770996);
 glVertex3f(1.261244, -0.230100, 0.093081);
 glNormal3f(0.127441, -0.650879, 0.748535);
 glVertex3f(1.474908, -0.216952, 0.093081);
 glNormal3f(0.099121, -0.639160, 0.762207);
 glVertex3f(1.474908, -0.203803, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.030273, -0.635742, 0.770996);
 glVertex3f(1.261244, -0.230100, 0.093081);
 glNormal3f(0.047363, -0.999023, 0.000000);
 glVertex3f(1.248095, -0.246536, -0.002246);
 glNormal3f(0.192383, -0.981445, 0.000000);
 glVertex3f(1.474908, -0.230100, -0.002246);
 glNormal3f(0.127441, -0.650879, 0.748535);
 glVertex3f(1.474908, -0.216952, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.026367, -0.428711, 0.902832);
 glVertex3f(1.248095, -0.170932, 0.155537);
 glNormal3f(0.018066, -0.752930, 0.658203);
 glVertex3f(1.254669, -0.197229, 0.135814);
 glNormal3f(0.096680, -0.664062, 0.741211);
 glVertex3f(1.474908, -0.193942, 0.139101);
 glNormal3f(0.052734, -0.305664, 0.950684);
 glVertex3f(1.445324, -0.167645, 0.152250);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.018066, -0.752930, 0.658203);
 glVertex3f(1.254669, -0.197229, 0.135814);
 glNormal3f(0.025879, -0.949707, 0.312500);
 glVertex3f(1.257957, -0.210378, 0.112804);
 glNormal3f(0.147949, -0.932617, 0.329102);
 glVertex3f(1.474908, -0.200516, 0.122665);
 glNormal3f(0.096680, -0.664062, 0.741211);
 glVertex3f(1.474908, -0.193942, 0.139101);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.124512, 0.000977, 0.992188);
 glVertex3f(-1.105504, 0.000000, 0.241003);
 glNormal3f(-0.104492, -0.123047, 0.986816);
 glVertex3f(-1.102217, -0.121625, 0.231141);
 glNormal3f(-0.055664, -0.174805, 0.982910);
 glVertex3f(-0.951008, -0.118337, 0.244290);
 glNormal3f(-0.080566, 0.000488, 0.996582);
 glVertex3f(-0.957582, 0.000000, 0.254151);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.104492, -0.123047, 0.986816);
 glVertex3f(-1.102217, -0.121625, 0.231141);
 glNormal3f(-0.061035, -0.198242, 0.978027);
 glVertex3f(-1.095643, -0.230100, 0.214705);
 glNormal3f(0.001953, -0.260742, 0.965332);
 glVertex3f(-0.941147, -0.226813, 0.214705);
 glNormal3f(-0.055664, -0.174805, 0.982910);
 glVertex3f(-0.951008, -0.118337, 0.244290);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.061035, -0.198242, 0.978027);
 glVertex3f(-1.095643, -0.230100, 0.214705);
 glNormal3f(-0.025391, -0.369629, 0.928711);
 glVertex3f(-1.079207, -0.440478, 0.165398);
 glNormal3f(0.079102, -0.381348, 0.920898);
 glVertex3f(-0.931285, -0.420755, 0.162111);
 glNormal3f(0.001953, -0.260742, 0.965332);
 glVertex3f(-0.941147, -0.226813, 0.214705);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.025391, -0.369629, 0.928711);
 glVertex3f(-1.079207, -0.440478, 0.165398);
 glNormal3f(0.004883, -0.744629, 0.667480);
 glVertex3f(-1.072633, -0.470062, 0.148962);
 glNormal3f(0.171875, -0.744141, 0.645508);
 glVertex3f(-0.924711, -0.450339, 0.145675);
 glNormal3f(0.079102, -0.381348, 0.920898);
 glVertex3f(-0.931285, -0.420755, 0.162111);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.004883, -0.744629, 0.667480);
 glVertex3f(-1.072633, -0.470062, 0.148962);
 glNormal3f(0.013184, -0.543945, 0.838867);
 glVertex3f(-1.072633, -0.493072, 0.093081);
 glNormal3f(0.122559, -0.555664, 0.822266);
 glVertex3f(-0.921424, -0.470062, 0.093081);
 glNormal3f(0.171875, -0.744141, 0.645508);
 glVertex3f(-0.924711, -0.450339, 0.145675);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.013184, -0.543945, 0.838867);
 glVertex3f(-1.072633, -0.493072, 0.093081);
 glNormal3f(0.019043, -0.646484, 0.762695);
 glVertex3f(-1.072633, -0.506221, 0.093081);
 glNormal3f(0.150879, -0.639160, 0.753906);
 glVertex3f(-0.921424, -0.483211, 0.093081);
 glNormal3f(0.122559, -0.555664, 0.822266);
 glVertex3f(-0.921424, -0.470062, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.019043, -0.646484, 0.762695);
 glVertex3f(-1.072633, -0.506221, 0.093081);
 glNormal3f(0.029785, -1.000000, 0.000000);
 glVertex3f(-1.072633, -0.522657, -0.002246);
 glNormal3f(0.229492, -0.973633, 0.000000);
 glVertex3f(-0.921424, -0.496360, -0.002246);
 glNormal3f(0.150879, -0.639160, 0.753906);
 glVertex3f(-0.921424, -0.483211, 0.093081);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.724609, -0.688477, -0.039551);
 glVertex3f(-1.503249, -0.410894, -0.097574);
 glNormal3f(-0.462402, -0.873535, -0.154297);
 glVertex3f(-1.450655, -0.450339, -0.097574);
 glNormal3f(-0.430176, -0.902832, 0.000000);
 glVertex3f(-1.444080, -0.453627, -0.002246);
 glNormal3f(-0.325195, -0.615723, 0.717773);
 glVertex3f(-1.450655, -0.450339, 0.093081);
 glNormal3f(-0.497070, -0.498535, 0.710449);
 glVertex3f(-1.503249, -0.410894, 0.093081);
 glNormal3f(-0.747070, -0.665039, 0.000000);
 glVertex3f(-1.503249, -0.407607, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.325195, -0.615723, 0.717773);
 glVertex3f(-1.450655, -0.450339, 0.093081);
 glNormal3f(-0.254883, -0.468262, 0.846191);
 glVertex3f(-1.444080, -0.440478, 0.093081);
 glNormal3f(-0.421387, -0.363770, 0.830566);
 glVertex3f(-1.493388, -0.401032, 0.093081);
 glNormal3f(-0.497070, -0.498535, 0.710449);
 glVertex3f(-1.503249, -0.410894, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.254883, -0.468262, 0.846191);
 glVertex3f(-1.444080, -0.440478, 0.093081);
 glNormal3f(-0.374023, -0.699707, 0.608887);
 glVertex3f(-1.444080, -0.427329, 0.119378);
 glNormal3f(-0.629395, -0.528809, 0.569824);
 glVertex3f(-1.490101, -0.387884, 0.122665);
 glNormal3f(-0.421387, -0.363770, 0.830566);
 glVertex3f(-1.493388, -0.401032, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.374023, -0.699707, 0.608887);
 glVertex3f(-1.444080, -0.427329, 0.119378);
 glNormal3f(-0.222656, -0.452637, 0.863281);
 glVertex3f(-1.437506, -0.397745, 0.145675);
 glNormal3f(-0.337891, -0.288086, 0.895996);
 glVertex3f(-1.473665, -0.364874, 0.148962);
 glNormal3f(-0.629395, -0.528809, 0.569824);
 glVertex3f(-1.490101, -0.387884, 0.122665);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.222656, -0.452637, 0.863281);
 glVertex3f(-1.437506, -0.397745, 0.145675);
 glNormal3f(-0.111328, -0.385742, 0.915527);
 glVertex3f(-1.355327, -0.417468, 0.145675);
 glNormal3f(-0.142578, -0.128906, 0.980957);
 glVertex3f(-1.355327, -0.220239, 0.185121);
 glNormal3f(-0.337891, -0.288086, 0.895996);
 glVertex3f(-1.473665, -0.364874, 0.148962);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.885254, -0.464844, 0.000000);
 glVertex3f(1.718157, -0.078892, -0.002246);
 glNormal3f(0.599609, -0.314941, 0.735352);
 glVertex3f(1.711583, -0.082179, 0.093081);
 glNormal3f(0.452148, -0.530273, 0.716797);
 glVertex3f(1.655702, -0.138060, 0.093081);
 glNormal3f(0.648926, -0.761230, 0.000000);
 glVertex3f(1.662276, -0.134773, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.599609, -0.314941, 0.735352);
 glVertex3f(1.711583, -0.082179, 0.093081);
 glNormal3f(0.471191, -0.270020, 0.839355);
 glVertex3f(1.695147, -0.072317, 0.093081);
 glNormal3f(0.388184, -0.425293, 0.817383);
 glVertex3f(1.639266, -0.131486, 0.093081);
 glNormal3f(0.452148, -0.530273, 0.716797);
 glVertex3f(1.655702, -0.138060, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.471191, -0.270020, 0.839355);
 glVertex3f(1.695147, -0.072317, 0.093081);
 glNormal3f(0.629883, -0.396973, 0.666992);
 glVertex3f(1.668850, -0.075604, 0.139101);
 glNormal3f(0.507324, -0.601074, 0.617676);
 glVertex3f(1.622830, -0.124912, 0.135814);
 glNormal3f(0.388184, -0.425293, 0.817383);
 glVertex3f(1.639266, -0.131486, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.629883, -0.396973, 0.666992);
 glVertex3f(1.668850, -0.075604, 0.139101);
 glNormal3f(0.241211, -0.214355, 0.946289);
 glVertex3f(1.632692, -0.075604, 0.155537);
 glNormal3f(0.198242, -0.316406, 0.927246);
 glVertex3f(1.589959, -0.118337, 0.152250);
 glNormal3f(0.507324, -0.601074, 0.617676);
 glVertex3f(1.622830, -0.124912, 0.135814);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.096680, -0.664062, 0.741211);
 glVertex3f(1.474908, -0.193942, 0.139101);
 glNormal3f(0.169922, -0.408203, 0.896484);
 glVertex3f(1.547226, -0.161070, 0.145675);
 glNormal3f(0.052734, -0.305664, 0.950684);
 glVertex3f(1.445324, -0.167645, 0.152250);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.241211, -0.214355, 0.946289);
 glVertex3f(1.632692, -0.075604, 0.155537);
 glNormal3f(0.070312, -0.174805, 0.981934);
 glVertex3f(1.445324, -0.078892, 0.168685);
 glNormal3f(0.198242, -0.316406, 0.927246);
 glVertex3f(1.589959, -0.118337, 0.152250);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.198242, -0.316406, 0.927246);
 glVertex3f(1.589959, -0.118337, 0.152250);
 glNormal3f(0.070312, -0.174805, 0.981934);
 glVertex3f(1.445324, -0.078892, 0.168685);
 glNormal3f(0.169922, -0.408203, 0.896484);
 glVertex3f(1.547226, -0.161070, 0.145675);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.210938, -0.335938, -0.917969);
 glVertex3f(1.616256, -0.121625, -0.156743);
 glNormal3f(0.175781, -0.422363, -0.889648);
 glVertex3f(1.573523, -0.164357, -0.153455);
 glNormal3f(0.069824, -0.178711, -0.981445);
 glVertex3f(1.468334, -0.078892, -0.176465);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.207520, -0.223145, -0.952637);
 glVertex3f(1.658989, -0.078892, -0.163317);
 glNormal3f(0.210938, -0.335938, -0.917969);
 glVertex3f(1.616256, -0.121625, -0.156743);
 glNormal3f(0.069824, -0.178711, -0.981445);
 glVertex3f(1.468334, -0.078892, -0.176465);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.100098, -0.650879, -0.752930);
 glVertex3f(1.501206, -0.197229, -0.146881);
 glNormal3f(0.040039, -0.307129, -0.951172);
 glVertex3f(1.468334, -0.170932, -0.156743);
 glNormal3f(0.175781, -0.422363, -0.889648);
 glVertex3f(1.573523, -0.164357, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207520, -0.223145, -0.952637);
 glVertex3f(1.658989, -0.078892, -0.163317);
 glNormal3f(0.652344, -0.430664, -0.624023);
 glVertex3f(1.698434, -0.078892, -0.150168);
 glNormal3f(0.523438, -0.648438, -0.552734);
 glVertex3f(1.649127, -0.128199, -0.140307);
 glNormal3f(0.210938, -0.335938, -0.917969);
 glVertex3f(1.616256, -0.121625, -0.156743);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.652344, -0.430664, -0.624023);
 glVertex3f(1.698434, -0.078892, -0.150168);
 glNormal3f(0.869141, -0.477051, -0.130371);
 glVertex3f(1.711583, -0.082179, -0.097574);
 glNormal3f(0.645996, -0.753906, -0.119629);
 glVertex3f(1.655702, -0.138060, -0.097574);
 glNormal3f(0.523438, -0.648438, -0.552734);
 glVertex3f(1.649127, -0.128199, -0.140307);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.869141, -0.477051, -0.130371);
 glVertex3f(1.711583, -0.082179, -0.097574);
 glNormal3f(0.885254, -0.464844, 0.000000);
 glVertex3f(1.718157, -0.078892, -0.002246);
 glNormal3f(0.648926, -0.761230, 0.000000);
 glVertex3f(1.662276, -0.134773, -0.002246);
 glNormal3f(0.645996, -0.753906, -0.119629);
 glVertex3f(1.655702, -0.138060, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.114746, -0.398438, -0.910156);
 glVertex3f(-1.378338, -0.427329, -0.150168);
 glNormal3f(-0.237793, -0.454102, -0.858887);
 glVertex3f(-1.463803, -0.404319, -0.153455);
 glNormal3f(-0.341309, -0.270508, -0.900879);
 glVertex3f(-1.499962, -0.368161, -0.153455);
 glNormal3f(-0.140137, -0.126953, -0.982422);
 glVertex3f(-1.378338, -0.223526, -0.189614);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.237793, -0.454102, -0.858887);
 glVertex3f(-1.463803, -0.404319, -0.153455);
 glNormal3f(-0.400391, -0.747559, -0.530273);
 glVertex3f(-1.467091, -0.433904, -0.123871);
 glNormal3f(-0.684082, -0.582520, -0.439941);
 glVertex3f(-1.516398, -0.394458, -0.127158);
 glNormal3f(-0.341309, -0.270508, -0.900879);
 glVertex3f(-1.499962, -0.368161, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.400391, -0.747559, -0.530273);
 glVertex3f(-1.467091, -0.433904, -0.123871);
 glNormal3f(-0.462402, -0.873535, -0.154297);
 glVertex3f(-1.450655, -0.450339, -0.097574);
 glNormal3f(-0.724609, -0.688477, -0.039551);
 glVertex3f(-1.503249, -0.410894, -0.097574);
 glNormal3f(-0.684082, -0.582520, -0.439941);
 glVertex3f(-1.516398, -0.394458, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.029785, -1.000000, 0.000000);
 glVertex3f(-1.072633, -0.522657, -0.002246);
 glNormal3f(0.025391, -0.948242, -0.317383);
 glVertex3f(-1.072633, -0.506221, -0.097574);
 glNormal3f(0.213379, -0.926270, -0.311523);
 glVertex3f(-0.921424, -0.483211, -0.097574);
 glNormal3f(0.229492, -0.973633, 0.000000);
 glVertex3f(-0.921424, -0.496360, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.025391, -0.948242, -0.317383);
 glVertex3f(-1.072633, -0.506221, -0.097574);
 glNormal3f(0.007324, -0.744629, -0.667969);
 glVertex3f(-1.089068, -0.479924, -0.153455);
 glNormal3f(0.166504, -0.713379, -0.681152);
 glVertex3f(-0.941147, -0.456914, -0.150168);
 glNormal3f(0.213379, -0.926270, -0.311523);
 glVertex3f(-0.921424, -0.483211, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.007324, -0.744629, -0.667969);
 glVertex3f(-1.089068, -0.479924, -0.153455);
 glNormal3f(-0.024902, -0.400391, -0.916504);
 glVertex3f(-1.095643, -0.450339, -0.173178);
 glNormal3f(0.086914, -0.400879, -0.912109);
 glVertex3f(-0.947721, -0.427329, -0.169891);
 glNormal3f(0.166504, -0.713379, -0.681152);
 glVertex3f(-0.941147, -0.456914, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.024902, -0.400391, -0.916504);
 glVertex3f(-1.095643, -0.450339, -0.173178);
 glNormal3f(-0.064453, -0.198242, -0.978516);
 glVertex3f(-1.115366, -0.233388, -0.222486);
 glNormal3f(0.005371, -0.257812, -0.966309);
 glVertex3f(-0.957582, -0.233388, -0.222486);
 glNormal3f(0.086914, -0.400879, -0.912109);
 glVertex3f(-0.947721, -0.427329, -0.169891);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.064453, -0.198242, -0.978516);
 glVertex3f(-1.115366, -0.233388, -0.222486);
 glNormal3f(-0.103027, -0.120605, -0.987793);
 glVertex3f(-1.121940, -0.124912, -0.238921);
 glNormal3f(-0.055176, -0.170410, -0.983887);
 glVertex3f(-0.967444, -0.118337, -0.252070);
 glNormal3f(0.005371, -0.257812, -0.966309);
 glVertex3f(-0.957582, -0.233388, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.103027, -0.120605, -0.987793);
 glVertex3f(-1.121940, -0.124912, -0.238921);
 glNormal3f(-0.118652, 0.000977, -0.993164);
 glVertex3f(-1.125227, 0.000000, -0.248783);
 glNormal3f(-0.079102, 0.000977, -0.997070);
 glVertex3f(-0.974018, 0.000000, -0.261931);
 glNormal3f(-0.055176, -0.170410, -0.983887);
 glVertex3f(-0.967444, -0.118337, -0.252070);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.040039, -0.915039, -0.402832);
 glVertex3f(1.280967, -0.226813, -0.117297);
 glNormal3f(0.023926, -0.669434, -0.743164);
 glVertex3f(1.277679, -0.200516, -0.143594);
 glNormal3f(0.100098, -0.650879, -0.752930);
 glVertex3f(1.501206, -0.197229, -0.146881);
 glNormal3f(0.168945, -0.917480, -0.360840);
 glVertex3f(1.501206, -0.203803, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.023926, -0.669434, -0.743164);
 glVertex3f(1.277679, -0.200516, -0.143594);
 glNormal3f(0.028320, -0.410156, -0.912109);
 glVertex3f(1.271105, -0.174219, -0.163317);
 glNormal3f(0.040039, -0.307129, -0.951172);
 glVertex3f(1.468334, -0.170932, -0.156743);
 glNormal3f(0.100098, -0.650879, -0.752930);
 glVertex3f(1.501206, -0.197229, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047363, -0.999023, 0.000000);
 glVertex3f(1.248095, -0.246536, -0.002246);
 glNormal3f(0.047363, -0.982422, -0.181641);
 glVertex3f(1.261244, -0.230100, -0.097574);
 glNormal3f(0.183594, -0.970215, -0.160645);
 glVertex3f(1.474908, -0.216952, -0.097574);
 glNormal3f(0.192383, -0.981445, 0.000000);
 glVertex3f(1.474908, -0.230100, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047363, -0.982422, -0.181641);
 glVertex3f(1.261244, -0.230100, -0.097574);
 glNormal3f(0.040039, -0.915039, -0.402832);
 glVertex3f(1.280967, -0.226813, -0.117297);
 glNormal3f(0.168945, -0.917480, -0.360840);
 glVertex3f(1.501206, -0.203803, -0.127158);
 glNormal3f(0.183594, -0.970215, -0.160645);
 glVertex3f(1.474908, -0.216952, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.028320, -0.410156, -0.912109);
 glVertex3f(1.271105, -0.174219, -0.163317);
 glNormal3f(0.047363, -0.237305, -0.970703);
 glVertex3f(1.274392, -0.082179, -0.189614);
 glNormal3f(0.069824, -0.178711, -0.981445);
 glVertex3f(1.468334, -0.078892, -0.176465);
 glNormal3f(0.040039, -0.307129, -0.951172);
 glVertex3f(1.468334, -0.170932, -0.156743);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047363, -0.237305, -0.970703);
 glVertex3f(1.274392, -0.082179, -0.189614);
 glNormal3f(0.057617, 0.004395, -0.998535);
 glVertex3f(1.277679, 0.000000, -0.206050);
 glNormal3f(0.085938, 0.002441, -0.996582);
 glVertex3f(1.468334, 0.000000, -0.186327);
 glNormal3f(0.069824, -0.178711, -0.981445);
 glVertex3f(1.468334, -0.078892, -0.176465);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.885254, -0.464844, 0.000000);
 glVertex3f(1.718157, -0.078892, -0.002246);
 glNormal3f(0.869141, -0.477051, -0.130371);
 glVertex3f(1.711583, -0.082179, -0.097574);
 glNormal3f(0.992676, 0.003906, -0.119629);
 glVertex3f(1.728019, 0.000000, -0.097574);
 glNormal3f(0.999512, 0.003418, 0.000000);
 glVertex3f(1.731306, 0.000000, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.456055, -0.890137, 0.000000);
 glVertex3f(1.596533, -0.184080, -0.002246);
 glNormal3f(0.450684, -0.884277, -0.122070);
 glVertex3f(1.589959, -0.184080, -0.097574);
 glNormal3f(0.645996, -0.753906, -0.119629);
 glVertex3f(1.655702, -0.138060, -0.097574);
 glNormal3f(0.648926, -0.761230, 0.000000);
 glVertex3f(1.662276, -0.134773, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.403809, -0.804688, -0.435547);
 glVertex3f(1.596533, -0.174219, -0.133732);
 glNormal3f(0.523438, -0.648438, -0.552734);
 glVertex3f(1.649127, -0.128199, -0.140307);
 glNormal3f(0.645996, -0.753906, -0.119629);
 glVertex3f(1.655702, -0.138060, -0.097574);
 glNormal3f(0.450684, -0.884277, -0.122070);
 glVertex3f(1.589959, -0.184080, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.992676, 0.003906, -0.119629);
 glVertex3f(1.728019, 0.000000, -0.097574);
 glNormal3f(0.869141, -0.477051, -0.130371);
 glVertex3f(1.711583, -0.082179, -0.097574);
 glNormal3f(0.652344, -0.430664, -0.624023);
 glVertex3f(1.698434, -0.078892, -0.150168);
 glNormal3f(0.763184, 0.003906, -0.645996);
 glVertex3f(1.721445, 0.000000, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.652344, -0.430664, -0.624023);
 glVertex3f(1.698434, -0.078892, -0.150168);
 glNormal3f(0.207520, -0.223145, -0.952637);
 glVertex3f(1.658989, -0.078892, -0.163317);
 glNormal3f(0.225098, 0.001953, -0.974609);
 glVertex3f(1.691860, 0.000000, -0.163317);
 glNormal3f(0.763184, 0.003906, -0.645996);
 glVertex3f(1.721445, 0.000000, -0.150168);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.403809, -0.804688, -0.435547);
 glVertex3f(1.596533, -0.174219, -0.133732);
 glNormal3f(0.175781, -0.422363, -0.889648);
 glVertex3f(1.573523, -0.164357, -0.153455);
 glNormal3f(0.210938, -0.335938, -0.917969);
 glVertex3f(1.616256, -0.121625, -0.156743);
 glNormal3f(0.523438, -0.648438, -0.552734);
 glVertex3f(1.649127, -0.128199, -0.140307);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.450684, -0.884277, -0.122070);
 glVertex3f(1.589959, -0.184080, -0.097574);
 glNormal3f(0.183594, -0.970215, -0.160645);
 glVertex3f(1.474908, -0.216952, -0.097574);
 glNormal3f(0.168945, -0.917480, -0.360840);
 glVertex3f(1.501206, -0.203803, -0.127158);
 glNormal3f(0.403809, -0.804688, -0.435547);
 glVertex3f(1.596533, -0.174219, -0.133732);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.192383, -0.981445, 0.000000);
 glVertex3f(1.474908, -0.230100, -0.002246);
 glNormal3f(0.183594, -0.970215, -0.160645);
 glVertex3f(1.474908, -0.216952, -0.097574);
 glNormal3f(0.450684, -0.884277, -0.122070);
 glVertex3f(1.589959, -0.184080, -0.097574);
 glNormal3f(0.456055, -0.890137, 0.000000);
 glVertex3f(1.596533, -0.184080, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.040039, -0.915039, -0.402832);
 glVertex3f(1.280967, -0.226813, -0.117297);
 glNormal3f(0.091797, -0.876953, -0.472168);
 glVertex3f(0.327693, -0.246536, -0.127158);
 glNormal3f(0.068848, -0.628906, -0.774902);
 glVertex3f(0.321119, -0.223526, -0.153455);
 glNormal3f(0.023926, -0.669434, -0.743164);
 glVertex3f(1.277679, -0.200516, -0.143594);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047363, -0.982422, -0.181641);
 glVertex3f(1.261244, -0.230100, -0.097574);
 glNormal3f(0.109375, -0.968750, -0.224609);
 glVertex3f(0.324406, -0.249823, -0.097574);
 glNormal3f(0.091797, -0.876953, -0.472168);
 glVertex3f(0.327693, -0.246536, -0.127158);
 glNormal3f(0.040039, -0.915039, -0.402832);
 glVertex3f(1.280967, -0.226813, -0.117297);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.047363, -0.999023, 0.000000);
 glVertex3f(1.248095, -0.246536, -0.002246);
 glNormal3f(0.122070, -0.992676, 0.000000);
 glVertex3f(0.311257, -0.279408, -0.002246);
 glNormal3f(0.109375, -0.968750, -0.224609);
 glVertex3f(0.324406, -0.249823, -0.097574);
 glNormal3f(0.047363, -0.982422, -0.181641);
 glVertex3f(1.261244, -0.230100, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.091797, -0.876953, -0.472168);
 glVertex3f(0.327693, -0.246536, -0.127158);
 glNormal3f(0.207520, -0.795898, -0.569336);
 glVertex3f(0.140326, -0.266259, -0.143594);
 glNormal3f(0.135254, -0.558594, -0.818359);
 glVertex3f(0.140326, -0.243249, -0.166604);
 glNormal3f(0.068848, -0.628906, -0.774902);
 glVertex3f(0.321119, -0.223526, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.109375, -0.968750, -0.224609);
 glVertex3f(0.324406, -0.249823, -0.097574);
 glNormal3f(0.249512, -0.925293, -0.285645);
 glVertex3f(0.137038, -0.295843, -0.097574);
 glNormal3f(0.207520, -0.795898, -0.569336);
 glVertex3f(0.140326, -0.266259, -0.143594);
 glNormal3f(0.091797, -0.876953, -0.472168);
 glVertex3f(0.327693, -0.246536, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.122070, -0.992676, 0.000000);
 glVertex3f(0.311257, -0.279408, -0.002246);
 glNormal3f(0.263184, -0.964844, 0.000000);
 glVertex3f(0.127177, -0.315566, -0.002246);
 glNormal3f(0.249512, -0.925293, -0.285645);
 glVertex3f(0.137038, -0.295843, -0.097574);
 glNormal3f(0.109375, -0.968750, -0.224609);
 glVertex3f(0.324406, -0.249823, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.033203, 0.001465, -0.999512);
 glVertex3f(-0.556550, 0.000000, -0.265218);
 glNormal3f(0.035156, 0.001953, -0.999512);
 glVertex3f(-0.323162, 0.000000, -0.258644);
 glNormal3f(0.035156, -0.211426, -0.977051);
 glVertex3f(-0.319875, -0.111763, -0.245496);
 glNormal3f(0.031250, -0.217285, -0.976074);
 glVertex3f(-0.549976, -0.111763, -0.255357);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.062012, -0.261230, -0.963379);
 glVertex3f(0.137038, -0.098614, -0.225773);
 glNormal3f(0.051270, -0.223633, -0.973633);
 glVertex3f(-0.070052, -0.101902, -0.238921);
 glNormal3f(0.041504, 0.002441, -0.999512);
 glVertex3f(-0.076626, 0.000000, -0.248783);
 glNormal3f(0.051270, 0.002930, -0.999023);
 glVertex3f(0.130464, 0.000000, -0.242208);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.035156, 0.001953, -0.999512);
 glVertex3f(-0.323162, 0.000000, -0.258644);
 glNormal3f(0.041504, 0.002441, -0.999512);
 glVertex3f(-0.076626, 0.000000, -0.248783);
 glNormal3f(0.051270, -0.223633, -0.973633);
 glVertex3f(-0.070052, -0.101902, -0.238921);
 glNormal3f(0.035156, -0.211426, -0.977051);
 glVertex3f(-0.319875, -0.111763, -0.245496);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207520, -0.795898, -0.569336);
 glVertex3f(0.140326, -0.266259, -0.143594);
 glNormal3f(0.210449, -0.739258, -0.639648);
 glVertex3f(-0.063478, -0.341864, -0.140307);
 glNormal3f(0.129395, -0.483887, -0.865723);
 glVertex3f(-0.066765, -0.315566, -0.160030);
 glNormal3f(0.135254, -0.558594, -0.818359);
 glVertex3f(0.140326, -0.243249, -0.166604);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.249512, -0.925293, -0.285645);
 glVertex3f(0.137038, -0.295843, -0.097574);
 glNormal3f(0.252441, -0.922852, -0.291992);
 glVertex3f(-0.070052, -0.368161, -0.097574);
 glNormal3f(0.210449, -0.739258, -0.639648);
 glVertex3f(-0.063478, -0.341864, -0.140307);
 glNormal3f(0.207520, -0.795898, -0.569336);
 glVertex3f(0.140326, -0.266259, -0.143594);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.263184, -0.964844, 0.000000);
 glVertex3f(0.127177, -0.315566, -0.002246);
 glNormal3f(0.257324, -0.966309, 0.000000);
 glVertex3f(-0.079913, -0.378022, -0.002246);
 glNormal3f(0.252441, -0.922852, -0.291992);
 glVertex3f(-0.070052, -0.368161, -0.097574);
 glNormal3f(0.249512, -0.925293, -0.285645);
 glVertex3f(0.137038, -0.295843, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.091797, -0.996094, 0.000000);
 glVertex3f(-0.310014, -0.427329, -0.002246);
 glNormal3f(0.090820, -0.958496, -0.270508);
 glVertex3f(-0.310014, -0.417468, -0.097574);
 glNormal3f(0.252441, -0.922852, -0.291992);
 glVertex3f(-0.070052, -0.368161, -0.097574);
 glNormal3f(0.257324, -0.966309, 0.000000);
 glVertex3f(-0.079913, -0.378022, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.074707, -0.748047, -0.659668);
 glVertex3f(-0.313301, -0.394458, -0.146881);
 glNormal3f(0.210449, -0.739258, -0.639648);
 glVertex3f(-0.063478, -0.341864, -0.140307);
 glNormal3f(0.252441, -0.922852, -0.291992);
 glVertex3f(-0.070052, -0.368161, -0.097574);
 glNormal3f(0.090820, -0.958496, -0.270508);
 glVertex3f(-0.310014, -0.417468, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.074707, -0.748047, -0.659668);
 glVertex3f(-0.313301, -0.394458, -0.146881);
 glNormal3f(0.043457, -0.448730, -0.892578);
 glVertex3f(-0.310014, -0.368161, -0.163317);
 glNormal3f(0.129395, -0.483887, -0.865723);
 glVertex3f(-0.066765, -0.315566, -0.160030);
 glNormal3f(0.210449, -0.739258, -0.639648);
 glVertex3f(-0.063478, -0.341864, -0.140307);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.129395, -0.483887, -0.865723);
 glVertex3f(-0.066765, -0.315566, -0.160030);
 glNormal3f(0.043457, -0.448730, -0.892578);
 glVertex3f(-0.310014, -0.368161, -0.163317);
 glNormal3f(0.031738, -0.328125, -0.944336);
 glVertex3f(-0.319875, -0.220239, -0.212624);
 glNormal3f(0.071777, -0.344238, -0.936523);
 glVertex3f(-0.066765, -0.213665, -0.199475);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.043457, -0.448730, -0.892578);
 glVertex3f(-0.310014, -0.368161, -0.163317);
 glNormal3f(0.021484, -0.443848, -0.895996);
 glVertex3f(-0.543402, -0.374735, -0.153455);
 glNormal3f(0.024902, -0.338867, -0.940918);
 glVertex3f(-0.546689, -0.223526, -0.212624);
 glNormal3f(0.031738, -0.328125, -0.944336);
 glVertex3f(-0.319875, -0.220239, -0.212624);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.074707, -0.748047, -0.659668);
 glVertex3f(-0.313301, -0.394458, -0.146881);
 glNormal3f(0.032227, -0.751953, -0.658691);
 glVertex3f(-0.543402, -0.394458, -0.140307);
 glNormal3f(0.021484, -0.443848, -0.895996);
 glVertex3f(-0.543402, -0.374735, -0.153455);
 glNormal3f(0.043457, -0.448730, -0.892578);
 glVertex3f(-0.310014, -0.368161, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.090820, -0.958496, -0.270508);
 glVertex3f(-0.310014, -0.417468, -0.097574);
 glNormal3f(0.040039, -0.965332, -0.257812);
 glVertex3f(-0.533540, -0.414181, -0.097574);
 glNormal3f(0.032227, -0.751953, -0.658691);
 glVertex3f(-0.543402, -0.394458, -0.140307);
 glNormal3f(0.074707, -0.748047, -0.659668);
 glVertex3f(-0.313301, -0.394458, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.040527, -0.999512, 0.000000);
 glVertex3f(-0.530253, -0.420755, -0.002246);
 glNormal3f(0.040039, -0.965332, -0.257812);
 glVertex3f(-0.533540, -0.414181, -0.097574);
 glNormal3f(0.090820, -0.958496, -0.270508);
 glVertex3f(-0.310014, -0.417468, -0.097574);
 glNormal3f(0.091797, -0.996094, 0.000000);
 glVertex3f(-0.310014, -0.427329, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.187500, -0.940430, -0.283691);
 glVertex3f(-0.770215, -0.437191, -0.097574);
 glNormal3f(0.145996, -0.724121, -0.674316);
 glVertex3f(-0.793225, -0.417468, -0.146881);
 glNormal3f(0.032227, -0.751953, -0.658691);
 glVertex3f(-0.543402, -0.394458, -0.140307);
 glNormal3f(0.040039, -0.965332, -0.257812);
 glVertex3f(-0.533540, -0.414181, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.021484, -0.443848, -0.895996);
 glVertex3f(-0.543402, -0.374735, -0.153455);
 glNormal3f(0.032227, -0.751953, -0.658691);
 glVertex3f(-0.543402, -0.394458, -0.140307);
 glNormal3f(0.145996, -0.724121, -0.674316);
 glVertex3f(-0.793225, -0.417468, -0.146881);
 glNormal3f(0.083984, -0.425781, -0.901367);
 glVertex3f(-0.796512, -0.384596, -0.166604);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.083984, -0.425781, -0.901367);
 glVertex3f(-0.796512, -0.384596, -0.166604);
 glNormal3f(0.029785, -0.319336, -0.947266);
 glVertex3f(-0.803086, -0.230100, -0.222486);
 glNormal3f(0.024902, -0.338867, -0.940918);
 glVertex3f(-0.546689, -0.223526, -0.212624);
 glNormal3f(0.021484, -0.443848, -0.895996);
 glVertex3f(-0.543402, -0.374735, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.083984, -0.425781, -0.901367);
 glVertex3f(-0.796512, -0.384596, -0.166604);
 glNormal3f(0.086914, -0.400879, -0.912109);
 glVertex3f(-0.947721, -0.427329, -0.169891);
 glNormal3f(0.005371, -0.257812, -0.966309);
 glVertex3f(-0.957582, -0.233388, -0.222486);
 glNormal3f(0.029785, -0.319336, -0.947266);
 glVertex3f(-0.803086, -0.230100, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.064453, -0.198242, -0.978516);
 glVertex3f(-1.115366, -0.233388, -0.222486);
 glNormal3f(-0.024902, -0.400391, -0.916504);
 glVertex3f(-1.095643, -0.450339, -0.173178);
 glNormal3f(-0.114746, -0.398438, -0.910156);
 glVertex3f(-1.378338, -0.427329, -0.150168);
 glNormal3f(-0.140137, -0.126953, -0.982422);
 glVertex3f(-1.378338, -0.223526, -0.189614);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.083984, -0.425781, -0.901367);
 glVertex3f(-0.796512, -0.384596, -0.166604);
 glNormal3f(0.145996, -0.724121, -0.674316);
 glVertex3f(-0.793225, -0.417468, -0.146881);
 glNormal3f(0.166504, -0.713379, -0.681152);
 glVertex3f(-0.941147, -0.456914, -0.150168);
 glNormal3f(0.086914, -0.400879, -0.912109);
 glVertex3f(-0.947721, -0.427329, -0.169891);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.187500, -0.940430, -0.283691);
 glVertex3f(-0.770215, -0.437191, -0.097574);
 glNormal3f(0.213379, -0.926270, -0.311523);
 glVertex3f(-0.921424, -0.483211, -0.097574);
 glNormal3f(0.166504, -0.713379, -0.681152);
 glVertex3f(-0.941147, -0.456914, -0.150168);
 glNormal3f(0.145996, -0.724121, -0.674316);
 glVertex3f(-0.793225, -0.417468, -0.146881);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.201172, -0.979492, 0.000000);
 glVertex3f(-0.766928, -0.447052, -0.002246);
 glNormal3f(0.187500, -0.940430, -0.283691);
 glVertex3f(-0.770215, -0.437191, -0.097574);
 glNormal3f(0.040039, -0.965332, -0.257812);
 glVertex3f(-0.533540, -0.414181, -0.097574);
 glNormal3f(0.040527, -0.999512, 0.000000);
 glVertex3f(-0.530253, -0.420755, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.430176, -0.902832, 0.000000);
 glVertex3f(-1.444080, -0.453627, -0.002246);
 glNormal3f(-0.462402, -0.873535, -0.154297);
 glVertex3f(-1.450655, -0.450339, -0.097574);
 glNormal3f(-0.211914, -0.937500, -0.276855);
 glVertex3f(-1.371763, -0.476637, -0.097574);
 glNormal3f(-0.231445, -0.973145, 0.000000);
 glVertex3f(-1.352040, -0.493072, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.400391, -0.747559, -0.530273);
 glVertex3f(-1.467091, -0.433904, -0.123871);
 glNormal3f(-0.170410, -0.762207, -0.625000);
 glVertex3f(-1.384912, -0.456914, -0.127158);
 glNormal3f(-0.211914, -0.937500, -0.276855);
 glVertex3f(-1.371763, -0.476637, -0.097574);
 glNormal3f(-0.462402, -0.873535, -0.154297);
 glVertex3f(-1.450655, -0.450339, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.187500, -0.940430, -0.283691);
 glVertex3f(-0.770215, -0.437191, -0.097574);
 glNormal3f(0.201172, -0.979492, 0.000000);
 glVertex3f(-0.766928, -0.447052, -0.002246);
 glNormal3f(0.229492, -0.973633, 0.000000);
 glVertex3f(-0.921424, -0.496360, -0.002246);
 glNormal3f(0.213379, -0.926270, -0.311523);
 glVertex3f(-0.921424, -0.483211, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.170410, -0.762207, -0.625000);
 glVertex3f(-1.384912, -0.456914, -0.127158);
 glNormal3f(0.007324, -0.744629, -0.667969);
 glVertex3f(-1.089068, -0.479924, -0.153455);
 glNormal3f(0.025391, -0.948242, -0.317383);
 glVertex3f(-1.072633, -0.506221, -0.097574);
 glNormal3f(-0.211914, -0.937500, -0.276855);
 glVertex3f(-1.371763, -0.476637, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.029785, -1.000000, 0.000000);
 glVertex3f(-1.072633, -0.522657, -0.002246);
 glNormal3f(-0.231445, -0.973145, 0.000000);
 glVertex3f(-1.352040, -0.493072, -0.002246);
 glNormal3f(-0.211914, -0.937500, -0.276855);
 glVertex3f(-1.371763, -0.476637, -0.097574);
 glNormal3f(0.025391, -0.948242, -0.317383);
 glVertex3f(-1.072633, -0.506221, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.724609, -0.688477, -0.039551);
 glVertex3f(-1.503249, -0.410894, -0.097574);
 glNormal3f(-0.747070, -0.665039, 0.000000);
 glVertex3f(-1.503249, -0.407607, -0.002246);
 glNormal3f(-0.889160, -0.458496, 0.000000);
 glVertex3f(-1.552556, -0.338576, -0.002246);
 glNormal3f(-0.895020, -0.446289, -0.014648);
 glVertex3f(-1.545982, -0.348438, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.114746, -0.398438, -0.910156);
 glVertex3f(-1.378338, -0.427329, -0.150168);
 glNormal3f(-0.024902, -0.400391, -0.916504);
 glVertex3f(-1.095643, -0.450339, -0.173178);
 glNormal3f(0.007324, -0.744629, -0.667969);
 glVertex3f(-1.089068, -0.479924, -0.153455);
 glNormal3f(-0.170410, -0.762207, -0.625000);
 glVertex3f(-1.384912, -0.456914, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.400391, -0.747559, -0.530273);
 glVertex3f(-1.467091, -0.433904, -0.123871);
 glNormal3f(-0.237793, -0.454102, -0.858887);
 glVertex3f(-1.463803, -0.404319, -0.153455);
 glNormal3f(-0.114746, -0.398438, -0.910156);
 glVertex3f(-1.378338, -0.427329, -0.150168);
 glNormal3f(-0.170410, -0.762207, -0.625000);
 glVertex3f(-1.384912, -0.456914, -0.127158);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.380371, -0.190430, -0.905273);
 glVertex3f(-1.522972, -0.312279, -0.153455);
 glNormal3f(-0.353516, -0.144531, -0.924316);
 glVertex3f(-1.549269, -0.226813, -0.160030);
 glNormal3f(-0.140137, -0.126953, -0.982422);
 glVertex3f(-1.378338, -0.223526, -0.189614);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.380371, -0.190430, -0.905273);
 glVertex3f(-1.522972, -0.312279, -0.153455);
 glNormal3f(-0.140137, -0.126953, -0.982422);
 glVertex3f(-1.378338, -0.223526, -0.189614);
 glNormal3f(-0.341309, -0.270508, -0.900879);
 glVertex3f(-1.499962, -0.368161, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.809082, -0.388672, -0.441895);
 glVertex3f(-1.549269, -0.335289, -0.127158);
 glNormal3f(-0.380371, -0.190430, -0.905273);
 glVertex3f(-1.522972, -0.312279, -0.153455);
 glNormal3f(-0.341309, -0.270508, -0.900879);
 glVertex3f(-1.499962, -0.368161, -0.153455);
 glNormal3f(-0.684082, -0.582520, -0.439941);
 glVertex3f(-1.516398, -0.394458, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.809082, -0.388672, -0.441895);
 glVertex3f(-1.549269, -0.335289, -0.127158);
 glNormal3f(-0.840820, -0.241699, -0.485352);
 glVertex3f(-1.588715, -0.230100, -0.137020);
 glNormal3f(-0.353516, -0.144531, -0.924316);
 glVertex3f(-1.549269, -0.226813, -0.160030);
 glNormal3f(-0.380371, -0.190430, -0.905273);
 glVertex3f(-1.522972, -0.312279, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.809082, -0.388672, -0.441895);
 glVertex3f(-1.549269, -0.335289, -0.127158);
 glNormal3f(-0.895020, -0.446289, -0.014648);
 glVertex3f(-1.545982, -0.348438, -0.097574);
 glNormal3f(-0.966309, -0.254395, -0.040527);
 glVertex3f(-1.588715, -0.223526, -0.097574);
 glNormal3f(-0.840820, -0.241699, -0.485352);
 glVertex3f(-1.588715, -0.230100, -0.137020);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.684082, -0.582520, -0.439941);
 glVertex3f(-1.516398, -0.394458, -0.127158);
 glNormal3f(-0.724609, -0.688477, -0.039551);
 glVertex3f(-1.503249, -0.410894, -0.097574);
 glNormal3f(-0.895020, -0.446289, -0.014648);
 glVertex3f(-1.545982, -0.348438, -0.097574);
 glNormal3f(-0.809082, -0.388672, -0.441895);
 glVertex3f(-1.549269, -0.335289, -0.127158);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.966309, -0.254395, -0.040527);
 glVertex3f(-1.588715, -0.223526, -0.097574);
 glNormal3f(-0.895020, -0.446289, -0.014648);
 glVertex3f(-1.545982, -0.348438, -0.097574);
 glNormal3f(-0.889160, -0.458496, 0.000000);
 glVertex3f(-1.552556, -0.338576, -0.002246);
 glNormal3f(-0.966309, -0.258301, 0.000000);
 glVertex3f(-1.598577, -0.213665, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.005371, -0.257812, -0.966309);
 glVertex3f(-0.957582, -0.233388, -0.222486);
 glNormal3f(-0.055176, -0.170410, -0.983887);
 glVertex3f(-0.967444, -0.118337, -0.252070);
 glNormal3f(-0.007812, -0.208984, -0.978027);
 glVertex3f(-0.812948, -0.115050, -0.261931);
 glNormal3f(0.029785, -0.319336, -0.947266);
 glVertex3f(-0.803086, -0.230100, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.140137, -0.126953, -0.982422);
 glVertex3f(-1.378338, -0.223526, -0.189614);
 glNormal3f(-0.170410, -0.078613, -0.982422);
 glVertex3f(-1.378338, -0.115050, -0.202763);
 glNormal3f(-0.103027, -0.120605, -0.987793);
 glVertex3f(-1.121940, -0.124912, -0.238921);
 glNormal3f(-0.064453, -0.198242, -0.978516);
 glVertex3f(-1.115366, -0.233388, -0.222486);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.353516, -0.144531, -0.924316);
 glVertex3f(-1.549269, -0.226813, -0.160030);
 glNormal3f(-0.358398, -0.062988, -0.931641);
 glVertex3f(-1.568992, -0.111763, -0.163317);
 glNormal3f(-0.170410, -0.078613, -0.982422);
 glVertex3f(-1.378338, -0.115050, -0.202763);
 glNormal3f(-0.140137, -0.126953, -0.982422);
 glVertex3f(-1.378338, -0.223526, -0.189614);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.353516, -0.144531, -0.924316);
 glVertex3f(-1.549269, -0.226813, -0.160030);
 glNormal3f(-0.840820, -0.241699, -0.485352);
 glVertex3f(-1.588715, -0.230100, -0.137020);
 glNormal3f(-0.836426, -0.095215, -0.540527);
 glVertex3f(-1.605151, -0.111763, -0.140307);
 glNormal3f(-0.358398, -0.062988, -0.931641);
 glVertex3f(-1.568992, -0.111763, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.987793, -0.122070, -0.099609);
 glVertex3f(-1.611725, -0.101902, -0.097574);
 glNormal3f(-0.836426, -0.095215, -0.540527);
 glVertex3f(-1.605151, -0.111763, -0.140307);
 glNormal3f(-0.840820, -0.241699, -0.485352);
 glVertex3f(-1.588715, -0.230100, -0.137020);
 glNormal3f(-0.966309, -0.254395, -0.040527);
 glVertex3f(-1.588715, -0.223526, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.990723, -0.138184, 0.000000);
 glVertex3f(-1.618299, -0.101902, -0.002246);
 glNormal3f(-0.987793, -0.122070, -0.099609);
 glVertex3f(-1.611725, -0.101902, -0.097574);
 glNormal3f(-0.966309, -0.254395, -0.040527);
 glVertex3f(-1.588715, -0.223526, -0.097574);
 glNormal3f(-0.966309, -0.258301, 0.000000);
 glVertex3f(-1.598577, -0.213665, -0.002246);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.031250, -0.217285, -0.976074);
 glVertex3f(-0.549976, -0.111763, -0.255357);
 glNormal3f(0.024902, -0.338867, -0.940918);
 glVertex3f(-0.546689, -0.223526, -0.212624);
 glNormal3f(0.029785, -0.319336, -0.947266);
 glVertex3f(-0.803086, -0.230100, -0.222486);
 glNormal3f(-0.007812, -0.208984, -0.978027);
 glVertex3f(-0.812948, -0.115050, -0.261931);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.031250, -0.217285, -0.976074);
 glVertex3f(-0.549976, -0.111763, -0.255357);
 glNormal3f(0.035156, -0.211426, -0.977051);
 glVertex3f(-0.319875, -0.111763, -0.245496);
 glNormal3f(0.031738, -0.328125, -0.944336);
 glVertex3f(-0.319875, -0.220239, -0.212624);
 glNormal3f(0.024902, -0.338867, -0.940918);
 glVertex3f(-0.546689, -0.223526, -0.212624);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.035156, -0.211426, -0.977051);
 glVertex3f(-0.319875, -0.111763, -0.245496);
 glNormal3f(0.051270, -0.223633, -0.973633);
 glVertex3f(-0.070052, -0.101902, -0.238921);
 glNormal3f(0.071777, -0.344238, -0.936523);
 glVertex3f(-0.066765, -0.213665, -0.199475);
 glNormal3f(0.031738, -0.328125, -0.944336);
 glVertex3f(-0.319875, -0.220239, -0.212624);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.990723, -0.138184, 0.000000);
 glVertex3f(-1.618299, -0.101902, -0.002246);
 glNormal3f(-1.000000, 0.002441, -0.000488);
 glVertex3f(-1.631448, 0.000000, -0.002246);
 glNormal3f(-0.990234, 0.000977, -0.139648);
 glVertex3f(-1.618299, 0.000000, -0.097574);
 glNormal3f(-0.987793, -0.122070, -0.099609);
 glVertex3f(-1.611725, -0.101902, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.820801, 0.000488, -0.571777);
 glVertex3f(-1.608438, 0.000000, -0.143594);
 glNormal3f(-0.836426, -0.095215, -0.540527);
 glVertex3f(-1.605151, -0.111763, -0.140307);
 glNormal3f(-0.987793, -0.122070, -0.099609);
 glVertex3f(-1.611725, -0.101902, -0.097574);
 glNormal3f(-0.990234, 0.000977, -0.139648);
 glVertex3f(-1.618299, 0.000000, -0.097574);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.836426, -0.095215, -0.540527);
 glVertex3f(-1.605151, -0.111763, -0.140307);
 glNormal3f(-0.820801, 0.000488, -0.571777);
 glVertex3f(-1.608438, 0.000000, -0.143594);
 glNormal3f(-0.360840, 0.000000, -0.933105);
 glVertex3f(-1.565705, 0.000000, -0.166604);
 glNormal3f(-0.358398, -0.062988, -0.931641);
 glVertex3f(-1.568992, -0.111763, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.358398, -0.062988, -0.931641);
 glVertex3f(-1.568992, -0.111763, -0.163317);
 glNormal3f(-0.360840, 0.000000, -0.933105);
 glVertex3f(-1.565705, 0.000000, -0.166604);
 glNormal3f(-0.180176, 0.000488, -0.983887);
 glVertex3f(-1.381625, 0.000000, -0.206050);
 glNormal3f(-0.170410, -0.078613, -0.982422);
 glVertex3f(-1.378338, -0.115050, -0.202763);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.170410, -0.078613, -0.982422);
 glVertex3f(-1.378338, -0.115050, -0.202763);
 glNormal3f(-0.180176, 0.000488, -0.983887);
 glVertex3f(-1.381625, 0.000000, -0.206050);
 glNormal3f(-0.118652, 0.000977, -0.993164);
 glVertex3f(-1.125227, 0.000000, -0.248783);
 glNormal3f(-0.103027, -0.120605, -0.987793);
 glVertex3f(-1.121940, -0.124912, -0.238921);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.055176, -0.170410, -0.983887);
 glVertex3f(-0.967444, -0.118337, -0.252070);
 glNormal3f(-0.079102, 0.000977, -0.997070);
 glVertex3f(-0.974018, 0.000000, -0.261931);
 glNormal3f(-0.021484, 0.001465, -1.000000);
 glVertex3f(-0.822809, 0.000000, -0.275080);
 glNormal3f(-0.007812, -0.208984, -0.978027);
 glVertex3f(-0.812948, -0.115050, -0.261931);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.021484, 0.001465, -1.000000);
 glVertex3f(-0.822809, 0.000000, -0.275080);
 glNormal3f(0.033203, 0.001465, -0.999512);
 glVertex3f(-0.556550, 0.000000, -0.265218);
 glNormal3f(0.031250, -0.217285, -0.976074);
 glVertex3f(-0.549976, -0.111763, -0.255357);
 glNormal3f(-0.007812, -0.208984, -0.978027);
 glVertex3f(-0.812948, -0.115050, -0.261931);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.168945, -0.917480, -0.360840);
 glVertex3f(1.501206, -0.203803, -0.127158);
 glNormal3f(0.100098, -0.650879, -0.752930);
 glVertex3f(1.501206, -0.197229, -0.146881);
 glNormal3f(0.175781, -0.422363, -0.889648);
 glVertex3f(1.573523, -0.164357, -0.153455);
 glNormal3f(0.403809, -0.804688, -0.435547);
 glVertex3f(1.596533, -0.174219, -0.133732);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.068848, -0.628906, -0.774902);
 glVertex3f(0.321119, -0.223526, -0.153455);
 glNormal3f(0.053711, -0.442383, -0.895508);
 glVertex3f(0.314545, -0.193942, -0.173178);
 glNormal3f(0.028320, -0.410156, -0.912109);
 glVertex3f(1.271105, -0.174219, -0.163317);
 glNormal3f(0.023926, -0.669434, -0.743164);
 glVertex3f(1.277679, -0.200516, -0.143594);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.135254, -0.558594, -0.818359);
 glVertex3f(0.140326, -0.243249, -0.166604);
 glNormal3f(0.084473, -0.395020, -0.915039);
 glVertex3f(0.133751, -0.200516, -0.186327);
 glNormal3f(0.053711, -0.442383, -0.895508);
 glVertex3f(0.314545, -0.193942, -0.173178);
 glNormal3f(0.068848, -0.628906, -0.774902);
 glVertex3f(0.321119, -0.223526, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.129395, -0.483887, -0.865723);
 glVertex3f(-0.066765, -0.315566, -0.160030);
 glNormal3f(0.071777, -0.344238, -0.936523);
 glVertex3f(-0.066765, -0.213665, -0.199475);
 glNormal3f(0.084473, -0.395020, -0.915039);
 glVertex3f(0.133751, -0.200516, -0.186327);
 glNormal3f(0.135254, -0.558594, -0.818359);
 glVertex3f(0.140326, -0.243249, -0.166604);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.040039, -0.307129, -0.951172);
 glVertex3f(1.468334, -0.170932, -0.156743);
 glNormal3f(0.069824, -0.178711, -0.981445);
 glVertex3f(1.468334, -0.078892, -0.176465);
 glNormal3f(0.175781, -0.422363, -0.889648);
 glVertex3f(1.573523, -0.164357, -0.153455);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.053711, -0.442383, -0.895508);
 glVertex3f(0.314545, -0.193942, -0.173178);
 glNormal3f(0.044434, -0.278320, -0.959961);
 glVertex3f(0.311257, -0.101902, -0.212624);
 glNormal3f(0.047363, -0.237305, -0.970703);
 glVertex3f(1.274392, -0.082179, -0.189614);
 glNormal3f(0.028320, -0.410156, -0.912109);
 glVertex3f(1.271105, -0.174219, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.084473, -0.395020, -0.915039);
 glVertex3f(0.133751, -0.200516, -0.186327);
 glNormal3f(0.062012, -0.261230, -0.963379);
 glVertex3f(0.137038, -0.098614, -0.225773);
 glNormal3f(0.044434, -0.278320, -0.959961);
 glVertex3f(0.311257, -0.101902, -0.212624);
 glNormal3f(0.053711, -0.442383, -0.895508);
 glVertex3f(0.314545, -0.193942, -0.173178);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.071777, -0.344238, -0.936523);
 glVertex3f(-0.066765, -0.213665, -0.199475);
 glNormal3f(0.051270, -0.223633, -0.973633);
 glVertex3f(-0.070052, -0.101902, -0.238921);
 glNormal3f(0.062012, -0.261230, -0.963379);
 glVertex3f(0.137038, -0.098614, -0.225773);
 glNormal3f(0.084473, -0.395020, -0.915039);
 glVertex3f(0.133751, -0.200516, -0.186327);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.069824, -0.178711, -0.981445);
 glVertex3f(1.468334, -0.078892, -0.176465);
 glNormal3f(0.085938, 0.002441, -0.996582);
 glVertex3f(1.468334, 0.000000, -0.186327);
 glNormal3f(0.225098, 0.001953, -0.974609);
 glVertex3f(1.691860, 0.000000, -0.163317);
 glNormal3f(0.207520, -0.223145, -0.952637);
 glVertex3f(1.658989, -0.078892, -0.163317);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.044434, -0.278320, -0.959961);
 glVertex3f(0.311257, -0.101902, -0.212624);
 glNormal3f(0.041504, 0.004395, -0.999512);
 glVertex3f(0.304683, 0.000000, -0.235634);
 glNormal3f(0.057617, 0.004395, -0.998535);
 glVertex3f(1.277679, 0.000000, -0.206050);
 glNormal3f(0.047363, -0.237305, -0.970703);
 glVertex3f(1.274392, -0.082179, -0.189614);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.062012, -0.261230, -0.963379);
 glVertex3f(0.137038, -0.098614, -0.225773);
 glNormal3f(0.051270, 0.002930, -0.999023);
 glVertex3f(0.130464, 0.000000, -0.242208);
 glNormal3f(0.041504, 0.004395, -0.999512);
 glVertex3f(0.304683, 0.000000, -0.235634);
 glNormal3f(0.044434, -0.278320, -0.959961);
 glVertex3f(0.311257, -0.101902, -0.212624);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.668457, 0.001953, 0.743652);
 glVertex3f(-1.618299, 0.000000, 0.093081);
 glNormal3f(-0.668457, -0.093262, 0.737793);
 glVertex3f(-1.611725, -0.101902, 0.093081);
 glNormal3f(-0.533203, -0.062988, 0.843262);
 glVertex3f(-1.598577, -0.111763, 0.093081);
 glNormal3f(-0.524902, 0.000000, 0.851074);
 glVertex3f(-1.605151, 0.000000, 0.093081);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.596680, 0.264160, -0.757812);
 glVertex3f(0.047108, 0.398612, -0.010998);
 glNormal3f(-0.351562, 0.553223, -0.755371);
 glVertex3f(-0.046374, 0.425419, -0.010998);
 glNormal3f(-0.234863, 0.971680, 0.003418);
 glVertex3f(-0.044312, 0.432980, 0.000000);
 glNormal3f(0.732910, 0.680176, 0.003906);
 glVertex3f(0.049170, 0.404111, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.353027, -0.555664, -0.752930);
 glVertex3f(0.043671, 0.386927, -0.010998);
 glNormal3f(-0.604492, -0.261230, -0.753418);
 glVertex3f(-0.049811, 0.415796, -0.010998);
 glNormal3f(-0.351562, 0.553223, -0.755371);
 glVertex3f(-0.046374, 0.425419, -0.010998);
 glNormal3f(0.596680, 0.264160, -0.757812);
 glVertex3f(0.047108, 0.398612, -0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.230469, -0.973145, 0.012695);
 glVertex3f(0.042296, 0.380740, 0.000000);
 glNormal3f(-0.737793, -0.675293, 0.012207);
 glVertex3f(-0.051873, 0.409610, 0.000000);
 glNormal3f(-0.604492, -0.261230, -0.753418);
 glVertex3f(-0.049811, 0.415796, -0.010998);
 glNormal3f(0.353027, -0.555664, -0.752930);
 glVertex3f(0.043671, 0.386927, -0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.352539, -0.544922, 0.760742);
 glVertex3f(0.043671, 0.386927, 0.010310);
 glNormal3f(-0.598633, -0.252441, 0.760254);
 glVertex3f(-0.049811, 0.415796, 0.010310);
 glNormal3f(-0.737793, -0.675293, 0.012207);
 glVertex3f(-0.051873, 0.409610, 0.000000);
 glNormal3f(0.230469, -0.973145, 0.012695);
 glVertex3f(0.042296, 0.380740, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.595703, 0.260742, 0.759277);
 glVertex3f(0.047108, 0.398612, 0.010310);
 glNormal3f(-0.350098, 0.550293, 0.757324);
 glVertex3f(-0.046374, 0.425419, 0.010310);
 glNormal3f(-0.598633, -0.252441, 0.760254);
 glVertex3f(-0.049811, 0.415796, 0.010310);
 glNormal3f(0.352539, -0.544922, 0.760742);
 glVertex3f(0.043671, 0.386927, 0.010310);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.732910, 0.680176, 0.003906);
 glVertex3f(0.049170, 0.404111, 0.000000);
 glNormal3f(-0.234863, 0.971680, 0.003418);
 glVertex3f(-0.044312, 0.432980, 0.000000);
 glNormal3f(-0.350098, 0.550293, 0.757324);
 glVertex3f(-0.046374, 0.425419, 0.010310);
 glNormal3f(0.595703, 0.260742, 0.759277);
 glVertex3f(0.047108, 0.398612, 0.010310);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.351562, 0.553223, -0.755371);
 glVertex3f(-0.046374, 0.425419, -0.010998);
 glNormal3f(-0.604492, -0.261230, -0.753418);
 glVertex3f(-0.049811, 0.415796, -0.010998);
 glNormal3f(-0.737793, -0.675293, 0.012207);
 glVertex3f(-0.051873, 0.409610, 0.000000);
 glNormal3f(-0.598633, -0.252441, 0.760254);
 glVertex3f(-0.049811, 0.415796, 0.010310);
 glNormal3f(-0.350098, 0.550293, 0.757324);
 glVertex3f(-0.046374, 0.425419, 0.010310);
 glNormal3f(-0.234863, 0.971680, 0.003418);
 glVertex3f(-0.044312, 0.432980, 0.000000);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.732910, 0.680176, 0.003906);
 glVertex3f(0.049170, 0.404111, 0.000000);
 glNormal3f(0.595703, 0.260742, 0.759277);
 glVertex3f(0.047108, 0.398612, 0.010310);
 glNormal3f(0.352539, -0.544922, 0.760742);
 glVertex3f(0.043671, 0.386927, 0.010310);
 glNormal3f(0.230469, -0.973145, 0.012695);
 glVertex3f(0.042296, 0.380740, 0.000000);
 glNormal3f(0.353027, -0.555664, -0.752930);
 glVertex3f(0.043671, 0.386927, -0.010998);
 glNormal3f(0.596680, 0.264160, -0.757812);
 glVertex3f(0.047108, 0.398612, -0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.341797, 0.453125, 0.823242);
 glVertex3f(-0.039500, 0.432980, 0.020621);
 glNormal3f(0.561035, 0.166992, 0.810059);
 glVertex3f(-0.034001, 0.430231, 0.020621);
 glNormal3f(0.688965, 0.635254, 0.348145);
 glVertex3f(-0.030565, 0.442603, 0.008936);
 glNormal3f(-0.224609, 0.912109, 0.342285);
 glVertex3f(-0.036064, 0.443978, 0.008936);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.324707, 0.479492, 0.814941);
 glVertex3f(0.039547, 0.408922, 0.020621);
 glNormal3f(0.587891, 0.179688, 0.788086);
 glVertex3f(0.045046, 0.407548, 0.020621);
 glNormal3f(0.774902, 0.560059, 0.291504);
 glVertex3f(0.048482, 0.416483, 0.008936);
 glNormal3f(-0.088379, 0.939453, 0.330078);
 glVertex3f(0.042983, 0.419920, 0.008936);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.224609, 0.912109, 0.342285);
 glVertex3f(-0.036064, 0.443978, 0.008936);
 glNormal3f(0.688965, 0.635254, 0.348145);
 glVertex3f(-0.030565, 0.442603, 0.008936);
 glNormal3f(0.666992, 0.657715, -0.349609);
 glVertex3f(-0.030565, 0.442603, -0.010310);
 glNormal3f(-0.254883, 0.905762, -0.338379);
 glVertex3f(-0.036064, 0.443978, -0.010310);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.088379, 0.939453, 0.330078);
 glVertex3f(0.042983, 0.419920, 0.008936);
 glNormal3f(0.774902, 0.560059, 0.291504);
 glVertex3f(0.048482, 0.416483, 0.008936);
 glNormal3f(0.754395, 0.565430, -0.333008);
 glVertex3f(0.048482, 0.416483, -0.010310);
 glNormal3f(-0.129395, 0.921387, -0.365723);
 glVertex3f(0.042983, 0.419920, -0.010310);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.341797, 0.453125, 0.823242);
 glVertex3f(-0.039500, 0.432980, 0.020621);
 glNormal3f(-0.224609, 0.912109, 0.342285);
 glVertex3f(-0.036064, 0.443978, 0.008936);
 glNormal3f(-0.254883, 0.905762, -0.338379);
 glVertex3f(-0.036064, 0.443978, -0.010310);
 glNormal3f(-0.370605, 0.454590, -0.810059);
 glVertex3f(-0.039500, 0.432980, -0.021308);
 glNormal3f(-0.152344, 0.825684, -0.542969);
 glVertex3f(-0.057372, 0.375242, -0.021308);
 glNormal3f(-0.152344, 0.825684, 0.542480);
 glVertex3f(-0.057372, 0.375242, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.561035, 0.166992, 0.810059);
 glVertex3f(-0.034001, 0.430231, 0.020621);
 glNormal3f(-0.341797, 0.453125, 0.823242);
 glVertex3f(-0.039500, 0.432980, 0.020621);
 glNormal3f(-0.152344, 0.825684, 0.542480);
 glVertex3f(-0.057372, 0.375242, 0.020621);
 glNormal3f(0.589355, 0.596191, 0.544434);
 glVertex3f(-0.051873, 0.373867, 0.020621);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.538574, 0.180664, -0.822754);
 glVertex3f(-0.034001, 0.430231, -0.021308);
 glNormal3f(0.666992, 0.657715, -0.349609);
 glVertex3f(-0.030565, 0.442603, -0.010310);
 glNormal3f(0.688965, 0.635254, 0.348145);
 glVertex3f(-0.030565, 0.442603, 0.008936);
 glNormal3f(0.561035, 0.166992, 0.810059);
 glVertex3f(-0.034001, 0.430231, 0.020621);
 glNormal3f(0.589355, 0.596191, 0.544434);
 glVertex3f(-0.051873, 0.373867, 0.020621);
 glNormal3f(0.591309, 0.597656, -0.541016);
 glVertex3f(-0.051873, 0.373867, -0.021308);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.370605, 0.454590, -0.810059);
 glVertex3f(-0.039500, 0.432980, -0.021308);
 glNormal3f(0.538574, 0.180664, -0.822754);
 glVertex3f(-0.034001, 0.430231, -0.021308);
 glNormal3f(0.591309, 0.597656, -0.541016);
 glVertex3f(-0.051873, 0.373867, -0.021308);
 glNormal3f(-0.152344, 0.825684, -0.542969);
 glVertex3f(-0.057372, 0.375242, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.552246, 0.173340, -0.815430);
 glVertex3f(0.045046, 0.407548, -0.021308);
 glNormal3f(0.754395, 0.565430, -0.333008);
 glVertex3f(0.048482, 0.416483, -0.010310);
 glNormal3f(0.774902, 0.560059, 0.291504);
 glVertex3f(0.048482, 0.416483, 0.008936);
 glNormal3f(0.587891, 0.179688, 0.788086);
 glVertex3f(0.045046, 0.407548, 0.020621);
 glNormal3f(0.590332, 0.594727, 0.544434);
 glVertex3f(0.027174, 0.349122, 0.020621);
 glNormal3f(0.590332, 0.595215, -0.544922);
 glVertex3f(0.027174, 0.349122, -0.021308);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.354980, 0.458984, -0.814453);
 glVertex3f(0.039547, 0.408922, -0.021308);
 glNormal3f(0.552246, 0.173340, -0.815430);
 glVertex3f(0.045046, 0.407548, -0.021308);
 glNormal3f(0.590332, 0.595215, -0.544922);
 glVertex3f(0.027174, 0.349122, -0.021308);
 glNormal3f(-0.151367, 0.825684, -0.542969);
 glVertex3f(0.021675, 0.351184, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.324707, 0.479492, 0.814941);
 glVertex3f(0.039547, 0.408922, 0.020621);
 glNormal3f(-0.088379, 0.939453, 0.330078);
 glVertex3f(0.042983, 0.419920, 0.008936);
 glNormal3f(-0.129395, 0.921387, -0.365723);
 glVertex3f(0.042983, 0.419920, -0.010310);
 glNormal3f(-0.354980, 0.458984, -0.814453);
 glVertex3f(0.039547, 0.408922, -0.021308);
 glNormal3f(-0.151367, 0.825684, -0.542969);
 glVertex3f(0.021675, 0.351184, -0.021308);
 glNormal3f(-0.151367, 0.825684, 0.542480);
 glVertex3f(0.021675, 0.351184, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.587891, 0.179688, 0.788086);
 glVertex3f(0.045046, 0.407548, 0.020621);
 glNormal3f(-0.324707, 0.479492, 0.814941);
 glVertex3f(0.039547, 0.408922, 0.020621);
 glNormal3f(-0.151367, 0.825684, 0.542480);
 glVertex3f(0.021675, 0.351184, 0.020621);
 glNormal3f(0.590332, 0.594727, 0.544434);
 glVertex3f(0.027174, 0.349122, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.151367, 0.825684, 0.542480);
 glVertex3f(0.021675, 0.351184, 0.020621);
 glNormal3f(-0.151367, 0.825684, -0.542969);
 glVertex3f(0.021675, 0.351184, -0.021308);
 glNormal3f(0.591309, 0.597656, -0.541016);
 glVertex3f(-0.051873, 0.373867, -0.021308);
 glNormal3f(0.589355, 0.596191, 0.544434);
 glVertex3f(-0.051873, 0.373867, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.129395, 0.921387, -0.365723);
 glVertex3f(0.042983, 0.419920, -0.010310);
 glNormal3f(0.754395, 0.565430, -0.333008);
 glVertex3f(0.048482, 0.416483, -0.010310);
 glNormal3f(0.552246, 0.173340, -0.815430);
 glVertex3f(0.045046, 0.407548, -0.021308);
 glNormal3f(-0.354980, 0.458984, -0.814453);
 glVertex3f(0.039547, 0.408922, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.590332, 0.594727, 0.544434);
 glVertex3f(0.027174, 0.349122, 0.020621);
 glNormal3f(-0.151367, 0.825684, 0.542480);
 glVertex3f(0.021675, 0.351184, 0.020621);
 glNormal3f(0.589355, 0.596191, 0.544434);
 glVertex3f(-0.051873, 0.373867, 0.020621);
 glNormal3f(-0.152344, 0.825684, 0.542480);
 glVertex3f(-0.057372, 0.375242, 0.020621);
 glNormal3f(-0.057129, 0.707520, 0.704102);
 glVertex3f(-0.082117, 0.382803, 0.032994);
 glNormal3f(0.446777, 0.559082, 0.697754);
 glVertex3f(0.052607, 0.341561, 0.032994);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.590332, 0.595215, -0.544922);
 glVertex3f(0.027174, 0.349122, -0.021308);
 glNormal3f(0.590332, 0.594727, 0.544434);
 glVertex3f(0.027174, 0.349122, 0.020621);
 glNormal3f(0.446777, 0.559082, 0.697754);
 glVertex3f(0.052607, 0.341561, 0.032994);
 glNormal3f(0.923828, 0.244141, 0.294434);
 glVertex3f(0.069791, 0.336062, 0.010998);
 glNormal3f(0.923828, 0.244141, -0.294922);
 glVertex3f(0.069791, 0.336062, -0.011685);
 glNormal3f(0.446777, 0.559082, -0.698242);
 glVertex3f(0.052607, 0.341561, -0.033681);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.152344, 0.825684, -0.542969);
 glVertex3f(-0.057372, 0.375242, -0.021308);
 glNormal3f(0.591309, 0.597656, -0.541016);
 glVertex3f(-0.051873, 0.373867, -0.021308);
 glNormal3f(-0.151367, 0.825684, -0.542969);
 glVertex3f(0.021675, 0.351184, -0.021308);
 glNormal3f(0.590332, 0.595215, -0.544922);
 glVertex3f(0.027174, 0.349122, -0.021308);
 glNormal3f(0.446777, 0.559082, -0.698242);
 glVertex3f(0.052607, 0.341561, -0.033681);
 glNormal3f(-0.057129, 0.707520, -0.704590);
 glVertex3f(-0.082117, 0.382803, -0.033681);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.152344, 0.825684, 0.542480);
 glVertex3f(-0.057372, 0.375242, 0.020621);
 glNormal3f(-0.152344, 0.825684, -0.542969);
 glVertex3f(-0.057372, 0.375242, -0.021308);
 glNormal3f(-0.057129, 0.707520, -0.704590);
 glVertex3f(-0.082117, 0.382803, -0.033681);
 glNormal3f(-0.653809, 0.692383, -0.304688);
 glVertex3f(-0.099989, 0.388302, -0.011685);
 glNormal3f(-0.653809, 0.692383, 0.304199);
 glVertex3f(-0.099989, 0.388302, 0.010998);
 glNormal3f(-0.057129, 0.707520, 0.704102);
 glVertex3f(-0.082117, 0.382803, 0.032994);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.493164, -0.353516, 0.794922);
 glVertex3f(-0.084867, 0.373867, 0.032994);
 glNormal3f(-0.057129, 0.707520, 0.704102);
 glVertex3f(-0.082117, 0.382803, 0.032994);
 glNormal3f(-0.653809, 0.692383, 0.304199);
 glVertex3f(-0.099989, 0.388302, 0.010998);
 glNormal3f(-0.930176, -0.206055, 0.304199);
 glVertex3f(-0.102738, 0.379366, 0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.057129, 0.707520, -0.704590);
 glVertex3f(-0.082117, 0.382803, -0.033681);
 glNormal3f(-0.493164, -0.353516, -0.795410);
 glVertex3f(-0.084867, 0.373867, -0.033681);
 glNormal3f(-0.930176, -0.206055, -0.304688);
 glVertex3f(-0.102738, 0.379366, -0.011685);
 glNormal3f(-0.653809, 0.692383, -0.304688);
 glVertex3f(-0.099989, 0.388302, -0.011685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.682617, -0.662598, -0.307617);
 glVertex3f(0.067729, 0.327126, -0.011685);
 glNormal3f(0.923828, 0.244141, -0.294922);
 glVertex3f(0.069791, 0.336062, -0.011685);
 glNormal3f(0.923828, 0.244141, 0.294434);
 glVertex3f(0.069791, 0.336062, 0.010998);
 glNormal3f(0.682617, -0.662598, 0.307129);
 glVertex3f(0.067729, 0.327126, 0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.446777, 0.559082, 0.697754);
 glVertex3f(0.052607, 0.341561, 0.032994);
 glNormal3f(0.217773, -0.562012, 0.797852);
 glVertex3f(0.049857, 0.332625, 0.032994);
 glNormal3f(0.682617, -0.662598, 0.307129);
 glVertex3f(0.067729, 0.327126, 0.010998);
 glNormal3f(0.923828, 0.244141, 0.294434);
 glVertex3f(0.069791, 0.336062, 0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.930176, -0.206055, 0.304199);
 glVertex3f(-0.102738, 0.379366, 0.010998);
 glNormal3f(-0.653809, 0.692383, 0.304199);
 glVertex3f(-0.099989, 0.388302, 0.010998);
 glNormal3f(-0.653809, 0.692383, -0.304688);
 glVertex3f(-0.099989, 0.388302, -0.011685);
 glNormal3f(-0.930176, -0.206055, -0.304688);
 glVertex3f(-0.102738, 0.379366, -0.011685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.217773, -0.562012, -0.798340);
 glVertex3f(0.049857, 0.332625, -0.033681);
 glNormal3f(0.446777, 0.559082, -0.698242);
 glVertex3f(0.052607, 0.341561, -0.033681);
 glNormal3f(0.923828, 0.244141, -0.294922);
 glVertex3f(0.069791, 0.336062, -0.011685);
 glNormal3f(0.682617, -0.662598, -0.307617);
 glVertex3f(0.067729, 0.327126, -0.011685);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.493164, -0.353516, -0.795410);
 glVertex3f(-0.084867, 0.373867, -0.033681);
 glNormal3f(0.217773, -0.562012, -0.798340);
 glVertex3f(0.049857, 0.332625, -0.033681);
 glNormal3f(0.682617, -0.662598, -0.307617);
 glVertex3f(0.067729, 0.327126, -0.011685);
 glNormal3f(0.682617, -0.662598, 0.307129);
 glVertex3f(0.067729, 0.327126, 0.010998);
 glNormal3f(0.217773, -0.562012, 0.797852);
 glVertex3f(0.049857, 0.332625, 0.032994);
 glNormal3f(-0.493164, -0.353516, 0.794922);
 glVertex3f(-0.084867, 0.373867, 0.032994);
 glNormal3f(-0.930176, -0.206055, 0.304199);
 glVertex3f(-0.102738, 0.379366, 0.010998);
 glNormal3f(-0.930176, -0.206055, -0.304688);
 glVertex3f(-0.102738, 0.379366, -0.011685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.538574, 0.180664, -0.822754);
 glVertex3f(-0.034001, 0.430231, -0.021308);
 glNormal3f(-0.370605, 0.454590, -0.810059);
 glVertex3f(-0.039500, 0.432980, -0.021308);
 glNormal3f(-0.254883, 0.905762, -0.338379);
 glVertex3f(-0.036064, 0.443978, -0.010310);
 glNormal3f(0.666992, 0.657715, -0.349609);
 glVertex3f(-0.030565, 0.442603, -0.010310);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.493164, -0.353516, -0.795410);
 glVertex3f(-0.084867, 0.373867, -0.033681);
 glNormal3f(-0.057129, 0.707520, -0.704590);
 glVertex3f(-0.082117, 0.382803, -0.033681);
 glNormal3f(0.446777, 0.559082, -0.698242);
 glVertex3f(0.052607, 0.341561, -0.033681);
 glNormal3f(0.217773, -0.562012, -0.798340);
 glVertex3f(0.049857, 0.332625, -0.033681);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.217773, -0.562012, 0.797852);
 glVertex3f(0.049857, 0.332625, 0.032994);
 glNormal3f(0.446777, 0.559082, 0.697754);
 glVertex3f(0.052607, 0.341561, 0.032994);
 glNormal3f(-0.057129, 0.707520, 0.704102);
 glVertex3f(-0.082117, 0.382803, 0.032994);
 glNormal3f(-0.493164, -0.353516, 0.794922);
 glVertex3f(-0.084867, 0.373867, 0.032994);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.496094, 0.420410, -0.759766);
 glVertex3f(-0.495911, 0.485220, -0.010998);
 glNormal3f(-0.496582, 0.420410, -0.759766);
 glVertex3f(-0.593517, 0.485220, -0.010998);
 glNormal3f(-0.511719, 0.858887, 0.012207);
 glVertex3f(-0.593517, 0.492094, 0.000000);
 glNormal3f(0.511230, 0.858887, 0.012207);
 glVertex3f(-0.495911, 0.492094, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.500977, -0.437012, -0.747070);
 glVertex3f(-0.495911, 0.472160, -0.010998);
 glNormal3f(-0.501465, -0.437012, -0.747070);
 glVertex3f(-0.593517, 0.472160, -0.010998);
 glNormal3f(-0.496582, 0.420410, -0.759766);
 glVertex3f(-0.593517, 0.485220, -0.010998);
 glNormal3f(0.496094, 0.420410, -0.759766);
 glVertex3f(-0.495911, 0.485220, -0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.495117, -0.868652, -0.009766);
 glVertex3f(-0.495911, 0.466661, 0.000000);
 glNormal3f(-0.495605, -0.868652, -0.009766);
 glVertex3f(-0.593517, 0.466661, 0.000000);
 glNormal3f(-0.501465, -0.437012, -0.747070);
 glVertex3f(-0.593517, 0.472160, -0.010998);
 glNormal3f(0.500977, -0.437012, -0.747070);
 glVertex3f(-0.495911, 0.472160, -0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.503418, -0.444824, 0.740723);
 glVertex3f(-0.495911, 0.472160, 0.010310);
 glNormal3f(-0.503906, -0.444824, 0.740723);
 glVertex3f(-0.593517, 0.472160, 0.010310);
 glNormal3f(-0.495605, -0.868652, -0.009766);
 glVertex3f(-0.593517, 0.466661, 0.000000);
 glNormal3f(0.495117, -0.868652, -0.009766);
 glVertex3f(-0.495911, 0.466661, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.493164, 0.410156, 0.766602);
 glVertex3f(-0.495911, 0.485220, 0.010310);
 glNormal3f(-0.493652, 0.410156, 0.766602);
 glVertex3f(-0.593517, 0.485220, 0.010310);
 glNormal3f(-0.503906, -0.444824, 0.740723);
 glVertex3f(-0.593517, 0.472160, 0.010310);
 glNormal3f(0.503418, -0.444824, 0.740723);
 glVertex3f(-0.495911, 0.472160, 0.010310);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.511230, 0.858887, 0.012207);
 glVertex3f(-0.495911, 0.492094, 0.000000);
 glNormal3f(-0.511719, 0.858887, 0.012207);
 glVertex3f(-0.593517, 0.492094, 0.000000);
 glNormal3f(-0.493652, 0.410156, 0.766602);
 glVertex3f(-0.593517, 0.485220, 0.010310);
 glNormal3f(0.493164, 0.410156, 0.766602);
 glVertex3f(-0.495911, 0.485220, 0.010310);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.496582, 0.420410, -0.759766);
 glVertex3f(-0.593517, 0.485220, -0.010998);
 glNormal3f(-0.501465, -0.437012, -0.747070);
 glVertex3f(-0.593517, 0.472160, -0.010998);
 glNormal3f(-0.495605, -0.868652, -0.009766);
 glVertex3f(-0.593517, 0.466661, 0.000000);
 glNormal3f(-0.503906, -0.444824, 0.740723);
 glVertex3f(-0.593517, 0.472160, 0.010310);
 glNormal3f(-0.493652, 0.410156, 0.766602);
 glVertex3f(-0.593517, 0.485220, 0.010310);
 glNormal3f(-0.511719, 0.858887, 0.012207);
 glVertex3f(-0.593517, 0.492094, 0.000000);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.511230, 0.858887, 0.012207);
 glVertex3f(-0.495911, 0.492094, 0.000000);
 glNormal3f(0.493164, 0.410156, 0.766602);
 glVertex3f(-0.495911, 0.485220, 0.010310);
 glNormal3f(0.503418, -0.444824, 0.740723);
 glVertex3f(-0.495911, 0.472160, 0.010310);
 glNormal3f(0.495117, -0.868652, -0.009766);
 glVertex3f(-0.495911, 0.466661, 0.000000);
 glNormal3f(0.500977, -0.437012, -0.747070);
 glVertex3f(-0.495911, 0.472160, -0.010998);
 glNormal3f(0.496094, 0.420410, -0.759766);
 glVertex3f(-0.495911, 0.485220, -0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.480957, 0.360352, 0.798828);
 glVertex3f(-0.588705, 0.493468, 0.020621);
 glNormal3f(0.480469, 0.360352, 0.798828);
 glVertex3f(-0.583206, 0.493468, 0.020621);
 glNormal3f(0.473633, 0.828613, 0.296387);
 glVertex3f(-0.583206, 0.503779, 0.008936);
 glNormal3f(-0.474121, 0.828613, 0.296387);
 glVertex3f(-0.588705, 0.503779, 0.008936);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.480957, 0.360352, 0.798828);
 glVertex3f(-0.506221, 0.493468, 0.020621);
 glNormal3f(0.480469, 0.360352, 0.798828);
 glVertex3f(-0.500722, 0.493468, 0.020621);
 glNormal3f(0.473633, 0.828613, 0.296387);
 glVertex3f(-0.500722, 0.503779, 0.008936);
 glNormal3f(-0.474121, 0.828613, 0.296387);
 glVertex3f(-0.506221, 0.503779, 0.008936);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.474121, 0.828613, 0.296387);
 glVertex3f(-0.588705, 0.503779, 0.008936);
 glNormal3f(0.473633, 0.828613, 0.296387);
 glVertex3f(-0.583206, 0.503779, 0.008936);
 glNormal3f(0.475098, 0.800781, -0.363281);
 glVertex3f(-0.583206, 0.503779, -0.010310);
 glNormal3f(-0.475586, 0.800781, -0.363281);
 glVertex3f(-0.588705, 0.503779, -0.010310);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.474121, 0.828613, 0.296387);
 glVertex3f(-0.506221, 0.503779, 0.008936);
 glNormal3f(0.473633, 0.828613, 0.296387);
 glVertex3f(-0.500722, 0.503779, 0.008936);
 glNormal3f(0.475098, 0.800781, -0.363281);
 glVertex3f(-0.500722, 0.503779, -0.010310);
 glNormal3f(-0.475586, 0.800781, -0.363281);
 glVertex3f(-0.506221, 0.503779, -0.010310);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.480957, 0.360352, 0.798828);
 glVertex3f(-0.588705, 0.493468, 0.020621);
 glNormal3f(-0.474121, 0.828613, 0.296387);
 glVertex3f(-0.588705, 0.503779, 0.008936);
 glNormal3f(-0.475586, 0.800781, -0.363281);
 glVertex3f(-0.588705, 0.503779, -0.010310);
 glNormal3f(-0.474121, 0.324219, -0.818848);
 glVertex3f(-0.588705, 0.493468, -0.021308);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.588705, 0.432980, -0.021308);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.588705, 0.432980, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.480469, 0.360352, 0.798828);
 glVertex3f(-0.583206, 0.493468, 0.020621);
 glNormal3f(-0.480957, 0.360352, 0.798828);
 glVertex3f(-0.588705, 0.493468, 0.020621);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.588705, 0.432980, 0.020621);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.583206, 0.432980, 0.020621);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.473633, 0.324219, -0.818848);
 glVertex3f(-0.583206, 0.493468, -0.021308);
 glNormal3f(0.475098, 0.800781, -0.363281);
 glVertex3f(-0.583206, 0.503779, -0.010310);
 glNormal3f(0.473633, 0.828613, 0.296387);
 glVertex3f(-0.583206, 0.503779, 0.008936);
 glNormal3f(0.480469, 0.360352, 0.798828);
 glVertex3f(-0.583206, 0.493468, 0.020621);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.583206, 0.432980, 0.020621);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.583206, 0.432980, -0.021308);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.474121, 0.324219, -0.818848);
 glVertex3f(-0.588705, 0.493468, -0.021308);
 glNormal3f(0.473633, 0.324219, -0.818848);
 glVertex3f(-0.583206, 0.493468, -0.021308);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.583206, 0.432980, -0.021308);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.588705, 0.432980, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.473633, 0.324219, -0.818848);
 glVertex3f(-0.500722, 0.493468, -0.021308);
 glNormal3f(0.475098, 0.800781, -0.363281);
 glVertex3f(-0.500722, 0.503779, -0.010310);
 glNormal3f(0.473633, 0.828613, 0.296387);
 glVertex3f(-0.500722, 0.503779, 0.008936);
 glNormal3f(0.480469, 0.360352, 0.798828);
 glVertex3f(-0.500722, 0.493468, 0.020621);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.500722, 0.432980, 0.020621);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.500722, 0.432980, -0.021308);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.474121, 0.324219, -0.818848);
 glVertex3f(-0.506221, 0.493468, -0.021308);
 glNormal3f(0.473633, 0.324219, -0.818848);
 glVertex3f(-0.500722, 0.493468, -0.021308);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.500722, 0.432980, -0.021308);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.506221, 0.432980, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.480957, 0.360352, 0.798828);
 glVertex3f(-0.506221, 0.493468, 0.020621);
 glNormal3f(-0.474121, 0.828613, 0.296387);
 glVertex3f(-0.506221, 0.503779, 0.008936);
 glNormal3f(-0.475586, 0.800781, -0.363281);
 glVertex3f(-0.506221, 0.503779, -0.010310);
 glNormal3f(-0.474121, 0.324219, -0.818848);
 glVertex3f(-0.506221, 0.493468, -0.021308);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.506221, 0.432980, -0.021308);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.506221, 0.432980, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.480469, 0.360352, 0.798828);
 glVertex3f(-0.500722, 0.493468, 0.020621);
 glNormal3f(-0.480957, 0.360352, 0.798828);
 glVertex3f(-0.506221, 0.493468, 0.020621);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.506221, 0.432980, 0.020621);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.500722, 0.432980, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.506221, 0.432980, 0.020621);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.506221, 0.432980, -0.021308);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.583206, 0.432980, -0.021308);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.583206, 0.432980, 0.020621);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.475586, 0.800781, -0.363281);
 glVertex3f(-0.506221, 0.503779, -0.010310);
 glNormal3f(0.475098, 0.800781, -0.363281);
 glVertex3f(-0.500722, 0.503779, -0.010310);
 glNormal3f(0.473633, 0.324219, -0.818848);
 glVertex3f(-0.500722, 0.493468, -0.021308);
 glNormal3f(-0.474121, 0.324219, -0.818848);
 glVertex3f(-0.506221, 0.493468, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.588705, 0.432980, 0.020621);
 glNormal3f(-0.288086, 0.742188, 0.604980);
 glVertex3f(-0.615512, 0.432980, 0.032994);
 glNormal3f(0.287598, 0.742188, 0.604980);
 glVertex3f(-0.473915, 0.432980, 0.032994);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.500722, 0.432980, 0.020621);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.506221, 0.432980, 0.020621);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.583206, 0.432980, 0.020621);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.500722, 0.432980, -0.021308);
 glNormal3f(0.408203, 0.816406, 0.408203);
 glVertex3f(-0.500722, 0.432980, 0.020621);
 glNormal3f(0.287598, 0.742188, 0.604980);
 glVertex3f(-0.473915, 0.432980, 0.032994);
 glNormal3f(0.832031, 0.468262, 0.295410);
 glVertex3f(-0.456044, 0.432980, 0.010998);
 glNormal3f(0.832031, 0.468262, -0.295898);
 glVertex3f(-0.456044, 0.432980, -0.011685);
 glNormal3f(0.287598, 0.742188, -0.605469);
 glVertex3f(-0.473915, 0.432980, -0.033681);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.500722, 0.432980, -0.021308);
 glNormal3f(0.287598, 0.742188, -0.605469);
 glVertex3f(-0.473915, 0.432980, -0.033681);
 glNormal3f(-0.288086, 0.742188, -0.605469);
 glVertex3f(-0.615512, 0.432980, -0.033681);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.588705, 0.432980, -0.021308);
 glNormal3f(0.408203, 0.816406, -0.408691);
 glVertex3f(-0.583206, 0.432980, -0.021308);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.506221, 0.432980, -0.021308);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(-0.588705, 0.432980, 0.020621);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(-0.588705, 0.432980, -0.021308);
 glNormal3f(-0.288086, 0.742188, -0.605469);
 glVertex3f(-0.615512, 0.432980, -0.033681);
 glNormal3f(-0.832520, 0.468262, -0.295898);
 glVertex3f(-0.633384, 0.432980, -0.011685);
 glNormal3f(-0.832520, 0.468262, 0.295410);
 glVertex3f(-0.633384, 0.432980, 0.010998);
 glNormal3f(-0.288086, 0.742188, 0.604980);
 glVertex3f(-0.615512, 0.432980, 0.032994);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.375977, -0.484863, 0.789551);
 glVertex3f(-0.615512, 0.424045, 0.032994);
 glNormal3f(-0.288086, 0.742188, 0.604980);
 glVertex3f(-0.615512, 0.432980, 0.032994);
 glNormal3f(-0.832520, 0.468262, 0.295410);
 glVertex3f(-0.633384, 0.432980, 0.010998);
 glNormal3f(-0.832520, -0.468750, 0.295410);
 glVertex3f(-0.633384, 0.424045, 0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.288086, 0.742188, -0.605469);
 glVertex3f(-0.615512, 0.432980, -0.033681);
 glNormal3f(-0.375977, -0.484863, -0.790039);
 glVertex3f(-0.615512, 0.424045, -0.033681);
 glNormal3f(-0.832520, -0.468750, -0.295898);
 glVertex3f(-0.633384, 0.424045, -0.011685);
 glNormal3f(-0.832520, 0.468262, -0.295898);
 glVertex3f(-0.633384, 0.432980, -0.011685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.832031, -0.468750, -0.295898);
 glVertex3f(-0.456044, 0.424045, -0.011685);
 glNormal3f(0.832031, 0.468262, -0.295898);
 glVertex3f(-0.456044, 0.432980, -0.011685);
 glNormal3f(0.832031, 0.468262, 0.295410);
 glVertex3f(-0.456044, 0.432980, 0.010998);
 glNormal3f(0.832031, -0.468750, 0.295410);
 glVertex3f(-0.456044, 0.424045, 0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.287598, 0.742188, 0.604980);
 glVertex3f(-0.473915, 0.432980, 0.032994);
 glNormal3f(0.375488, -0.484863, 0.789551);
 glVertex3f(-0.473915, 0.424045, 0.032994);
 glNormal3f(0.832031, -0.468750, 0.295410);
 glVertex3f(-0.456044, 0.424045, 0.010998);
 glNormal3f(0.832031, 0.468262, 0.295410);
 glVertex3f(-0.456044, 0.432980, 0.010998);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.832520, -0.468750, 0.295410);
 glVertex3f(-0.633384, 0.424045, 0.010998);
 glNormal3f(-0.832520, 0.468262, 0.295410);
 glVertex3f(-0.633384, 0.432980, 0.010998);
 glNormal3f(-0.832520, 0.468262, -0.295898);
 glVertex3f(-0.633384, 0.432980, -0.011685);
 glNormal3f(-0.832520, -0.468750, -0.295898);
 glVertex3f(-0.633384, 0.424045, -0.011685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.375488, -0.484863, -0.790039);
 glVertex3f(-0.473915, 0.424045, -0.033681);
 glNormal3f(0.287598, 0.742188, -0.605469);
 glVertex3f(-0.473915, 0.432980, -0.033681);
 glNormal3f(0.832031, 0.468262, -0.295898);
 glVertex3f(-0.456044, 0.432980, -0.011685);
 glNormal3f(0.832031, -0.468750, -0.295898);
 glVertex3f(-0.456044, 0.424045, -0.011685);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.375977, -0.484863, -0.790039);
 glVertex3f(-0.615512, 0.424045, -0.033681);
 glNormal3f(0.375488, -0.484863, -0.790039);
 glVertex3f(-0.473915, 0.424045, -0.033681);
 glNormal3f(0.832031, -0.468750, -0.295898);
 glVertex3f(-0.456044, 0.424045, -0.011685);
 glNormal3f(0.832031, -0.468750, 0.295410);
 glVertex3f(-0.456044, 0.424045, 0.010998);
 glNormal3f(0.375488, -0.484863, 0.789551);
 glVertex3f(-0.473915, 0.424045, 0.032994);
 glNormal3f(-0.375977, -0.484863, 0.789551);
 glVertex3f(-0.615512, 0.424045, 0.032994);
 glNormal3f(-0.832520, -0.468750, 0.295410);
 glVertex3f(-0.633384, 0.424045, 0.010998);
 glNormal3f(-0.832520, -0.468750, -0.295898);
 glVertex3f(-0.633384, 0.424045, -0.011685);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.473633, 0.324219, -0.818848);
 glVertex3f(-0.583206, 0.493468, -0.021308);
 glNormal3f(-0.474121, 0.324219, -0.818848);
 glVertex3f(-0.588705, 0.493468, -0.021308);
 glNormal3f(-0.475586, 0.800781, -0.363281);
 glVertex3f(-0.588705, 0.503779, -0.010310);
 glNormal3f(0.475098, 0.800781, -0.363281);
 glVertex3f(-0.583206, 0.503779, -0.010310);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.375977, -0.484863, -0.790039);
 glVertex3f(-0.615512, 0.424045, -0.033681);
 glNormal3f(-0.288086, 0.742188, -0.605469);
 glVertex3f(-0.615512, 0.432980, -0.033681);
 glNormal3f(0.287598, 0.742188, -0.605469);
 glVertex3f(-0.473915, 0.432980, -0.033681);
 glNormal3f(0.375488, -0.484863, -0.790039);
 glVertex3f(-0.473915, 0.424045, -0.033681);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.375488, -0.484863, 0.789551);
 glVertex3f(-0.473915, 0.424045, 0.032994);
 glNormal3f(0.287598, 0.742188, 0.604980);
 glVertex3f(-0.473915, 0.432980, 0.032994);
 glNormal3f(-0.288086, 0.742188, 0.604980);
 glVertex3f(-0.615512, 0.432980, 0.032994);
 glNormal3f(-0.375977, -0.484863, 0.789551);
 glVertex3f(-0.615512, 0.424045, 0.032994);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.370117, -0.423828, 0.826660);
 glVertex3f(-0.556009, 0.456082, 0.035537);
 glNormal3f(0.302734, -0.540039, 0.784668);
 glVertex3f(-0.525211, 0.452528, 0.035537);
 glNormal3f(0.401855, -0.217773, 0.889160);
 glVertex3f(-0.508627, 0.548478, 0.035537);
 glNormal3f(-0.320801, 0.099121, 0.941895);
 glVertex3f(-0.542979, 0.552031, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.514160, 0.500000, 0.696777);
 glVertex3f(-0.539425, 0.604152, 0.004738);
 glNormal3f(-0.477051, 0.463867, -0.746582);
 glVertex3f(-0.539425, 0.604152, -0.005923);
 glNormal3f(-0.666016, 0.222168, -0.712402);
 glVertex3f(-0.558378, 0.568615, -0.005923);
 glNormal3f(-0.666016, 0.222168, 0.711914);
 glVertex3f(-0.558378, 0.568615, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.959961, -0.281738, 0.000000);
 glVertex3f(-0.570224, 0.458451, 0.000000);
 glNormal3f(-0.956055, -0.293945, 0.000000);
 glVertex3f(-0.570224, 0.458451, 0.004738);
 glNormal3f(-0.911621, -0.187500, 0.366699);
 glVertex3f(-0.564301, 0.489250, 0.004738);
 glNormal3f(-0.913086, -0.408203, 0.000000);
 glVertex3f(-0.564301, 0.489250, 0.000000);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.956055, -0.293945, 0.000000);
 glVertex3f(-0.570224, 0.458451, -0.005923);
 glNormal3f(-0.859375, -0.358887, -0.364746);
 glVertex3f(-0.570224, 0.458451, -0.024876);
 glNormal3f(-0.370117, -0.423828, -0.827148);
 glVertex3f(-0.556009, 0.456082, -0.036721);
 glNormal3f(0.304688, -0.540527, -0.784180);
 glVertex3f(-0.525211, 0.452528, -0.036721);
 glNormal3f(0.746094, -0.598633, -0.291016);
 glVertex3f(-0.515734, 0.451344, -0.024876);
 glNormal3f(0.745117, -0.599121, 0.292480);
 glVertex3f(-0.515734, 0.451344, 0.023691);
 glNormal3f(0.302734, -0.540039, 0.784668);
 glVertex3f(-0.525211, 0.452528, 0.035537);
 glNormal3f(-0.370117, -0.423828, 0.826660);
 glVertex3f(-0.556009, 0.456082, 0.035537);
 glNormal3f(-0.859375, -0.358887, 0.364258);
 glVertex3f(-0.570224, 0.458451, 0.023691);
 glNormal3f(-0.956055, -0.293945, 0.000000);
 glVertex3f(-0.570224, 0.458451, 0.004738);
 glNormal3f(-0.959961, -0.281738, 0.000000);
 glVertex3f(-0.570224, 0.458451, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.746094, -0.598633, -0.291016);
 glVertex3f(-0.515734, 0.451344, -0.024876);
 glNormal3f(0.850098, -0.416504, -0.321777);
 glVertex3f(-0.499150, 0.544924, -0.024876);
 glNormal3f(0.856934, -0.421875, 0.295410);
 glVertex3f(-0.499150, 0.544924, 0.023691);
 glNormal3f(0.745117, -0.599121, 0.292480);
 glVertex3f(-0.515734, 0.451344, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.850098, -0.416504, -0.321777);
 glVertex3f(-0.499150, 0.544924, -0.024876);
 glNormal3f(0.458496, -0.812988, -0.359863);
 glVertex3f(-0.484935, 0.562693, -0.024876);
 glNormal3f(0.463379, -0.819824, 0.336426);
 glVertex3f(-0.484935, 0.562693, 0.023691);
 glNormal3f(0.856934, -0.421875, 0.295410);
 glVertex3f(-0.499150, 0.544924, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.458496, -0.812988, -0.359863);
 glVertex3f(-0.484935, 0.562693, -0.024876);
 glNormal3f(0.005859, -0.909180, -0.416992);
 glVertex3f(-0.458875, 0.566246, -0.024876);
 glNormal3f(-0.007324, -0.907227, 0.421387);
 glVertex3f(-0.458875, 0.566246, 0.023691);
 glNormal3f(0.463379, -0.819824, 0.336426);
 glVertex3f(-0.484935, 0.562693, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.005859, -0.909180, -0.416992);
 glVertex3f(-0.458875, 0.566246, -0.024876);
 glNormal3f(-0.248535, -0.861328, -0.443848);
 glVertex3f(-0.412677, 0.559139, -0.024876);
 glNormal3f(-0.255371, -0.860840, 0.440918);
 glVertex3f(-0.412677, 0.559139, 0.023691);
 glNormal3f(-0.007324, -0.907227, 0.421387);
 glVertex3f(-0.458875, 0.566246, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.248535, -0.861328, -0.443848);
 glVertex3f(-0.412677, 0.559139, -0.024876);
 glNormal3f(-0.124023, -0.890625, -0.437988);
 glVertex3f(-0.372402, 0.541370, -0.024876);
 glNormal3f(-0.127441, -0.892090, 0.434082);
 glVertex3f(-0.372402, 0.541370, 0.023691);
 glNormal3f(-0.255371, -0.860840, 0.440918);
 glVertex3f(-0.412677, 0.559139, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.124023, -0.890625, -0.437988);
 glVertex3f(-0.372402, 0.541370, -0.024876);
 glNormal3f(-0.099121, -0.904297, -0.416016);
 glVertex3f(-0.317912, 0.548478, -0.024876);
 glNormal3f(-0.099121, -0.904297, 0.415527);
 glVertex3f(-0.317912, 0.548478, 0.023691);
 glNormal3f(-0.127441, -0.892090, 0.434082);
 glVertex3f(-0.372402, 0.541370, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.099121, -0.904297, -0.416016);
 glVertex3f(-0.317912, 0.548478, -0.024876);
 glNormal3f(-0.136719, -0.896484, -0.421875);
 glVertex3f(-0.261053, 0.528340, -0.024876);
 glNormal3f(-0.137695, -0.892090, 0.430176);
 glVertex3f(-0.261053, 0.528340, 0.023691);
 glNormal3f(-0.099121, -0.904297, 0.415527);
 glVertex3f(-0.317912, 0.548478, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.023438, 0.714844, 0.698730);
 glVertex3f(-0.443476, 0.632582, 0.004738);
 glNormal3f(-0.022949, 0.695312, -0.718262);
 glVertex3f(-0.443476, 0.632582, -0.005923);
 glNormal3f(-0.208984, 0.639648, -0.739746);
 glVertex3f(-0.502704, 0.625474, -0.005923);
 glNormal3f(-0.225098, 0.688477, 0.688965);
 glVertex3f(-0.502704, 0.625474, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.485840, 0.490234, 0.723145);
 glVertex3f(-0.533503, 0.604152, 0.004738);
 glNormal3f(-0.206543, 0.669922, 0.712402);
 glVertex3f(-0.501519, 0.620736, 0.004738);
 glNormal3f(-0.225098, 0.688477, 0.688965);
 glVertex3f(-0.502704, 0.625474, 0.004738);
 glNormal3f(-0.514160, 0.500000, 0.696777);
 glVertex3f(-0.539425, 0.604152, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.008301, 0.368164, 0.929199);
 glVertex3f(-0.432815, 0.614813, 0.035537);
 glNormal3f(0.032715, 0.317871, 0.947266);
 glVertex3f(-0.358187, 0.611260, 0.035537);
 glNormal3f(0.098145, 0.923340, 0.370605);
 glVertex3f(-0.368848, 0.621921, 0.023691);
 glNormal3f(-0.019043, 0.917480, 0.395996);
 glVertex3f(-0.442291, 0.627843, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.093262, 0.310059, 0.945801);
 glVertex3f(-0.492043, 0.607706, 0.035537);
 glNormal3f(-0.008301, 0.368164, 0.929199);
 glVertex3f(-0.432815, 0.614813, 0.035537);
 glNormal3f(-0.019043, 0.917480, 0.395996);
 glVertex3f(-0.442291, 0.627843, 0.023691);
 glNormal3f(-0.262207, 0.857910, 0.440918);
 glVertex3f(-0.501519, 0.620736, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.291016, 0.285156, 0.913086);
 glVertex3f(-0.524026, 0.591122, 0.035537);
 glNormal3f(-0.093262, 0.310059, 0.945801);
 glVertex3f(-0.492043, 0.607706, 0.035537);
 glNormal3f(-0.262207, 0.857910, 0.440918);
 glVertex3f(-0.501519, 0.620736, 0.023691);
 glNormal3f(-0.628418, 0.626953, 0.460449);
 glVertex3f(-0.533503, 0.604152, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.320801, 0.099121, 0.941895);
 glVertex3f(-0.542979, 0.552031, 0.035537);
 glNormal3f(-0.291016, 0.285156, 0.913086);
 glVertex3f(-0.524026, 0.591122, 0.035537);
 glNormal3f(-0.628418, 0.626953, 0.460449);
 glVertex3f(-0.533503, 0.604152, 0.023691);
 glNormal3f(-0.858887, 0.279297, 0.429199);
 glVertex3f(-0.553640, 0.566246, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.370117, -0.423828, 0.826660);
 glVertex3f(-0.556009, 0.456082, 0.035537);
 glNormal3f(-0.320801, 0.099121, 0.941895);
 glVertex3f(-0.542979, 0.552031, 0.035537);
 glNormal3f(-0.858887, 0.279297, 0.429199);
 glVertex3f(-0.553640, 0.566246, 0.023691);
 glNormal3f(-0.859375, -0.358887, 0.364258);
 glVertex3f(-0.570224, 0.458451, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.401855, -0.217773, 0.889160);
 glVertex3f(-0.508627, 0.548478, 0.035537);
 glNormal3f(0.302734, -0.540039, 0.784668);
 glVertex3f(-0.525211, 0.452528, 0.035537);
 glNormal3f(0.745117, -0.599121, 0.292480);
 glVertex3f(-0.515734, 0.451344, 0.023691);
 glNormal3f(0.856934, -0.421875, 0.295410);
 glVertex3f(-0.499150, 0.544924, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.206543, -0.366699, 0.906738);
 glVertex3f(-0.476644, 0.576907, 0.035537);
 glNormal3f(0.401855, -0.217773, 0.889160);
 glVertex3f(-0.508627, 0.548478, 0.035537);
 glNormal3f(0.856934, -0.421875, 0.295410);
 glVertex3f(-0.499150, 0.544924, 0.023691);
 glNormal3f(0.463379, -0.819824, 0.336426);
 glVertex3f(-0.484935, 0.562693, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.002441, -0.343750, 0.938965);
 glVertex3f(-0.451768, 0.580461, 0.035537);
 glNormal3f(0.206543, -0.366699, 0.906738);
 glVertex3f(-0.476644, 0.576907, 0.035537);
 glNormal3f(0.463379, -0.819824, 0.336426);
 glVertex3f(-0.484935, 0.562693, 0.023691);
 glNormal3f(-0.007324, -0.907227, 0.421387);
 glVertex3f(-0.458875, 0.566246, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.094238, -0.309570, 0.945801);
 glVertex3f(-0.404385, 0.573354, 0.035537);
 glNormal3f(-0.002441, -0.343750, 0.938965);
 glVertex3f(-0.451768, 0.580461, 0.035537);
 glNormal3f(-0.007324, -0.907227, 0.421387);
 glVertex3f(-0.458875, 0.566246, 0.023691);
 glNormal3f(-0.255371, -0.860840, 0.440918);
 glVertex3f(-0.412677, 0.559139, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.061523, -0.436523, 0.897461);
 glVertex3f(-0.365295, 0.555585, 0.035537);
 glNormal3f(-0.094238, -0.309570, 0.945801);
 glVertex3f(-0.404385, 0.573354, 0.035537);
 glNormal3f(-0.255371, -0.860840, 0.440918);
 glVertex3f(-0.412677, 0.559139, 0.023691);
 glNormal3f(-0.127441, -0.892090, 0.434082);
 glVertex3f(-0.372402, 0.541370, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.040527, -0.347656, 0.936523);
 glVertex3f(-0.310805, 0.561508, 0.035537);
 glNormal3f(-0.061523, -0.436523, 0.897461);
 glVertex3f(-0.365295, 0.555585, 0.035537);
 glNormal3f(-0.127441, -0.892090, 0.434082);
 glVertex3f(-0.372402, 0.541370, 0.023691);
 glNormal3f(-0.099121, -0.904297, 0.415527);
 glVertex3f(-0.317912, 0.548478, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.069824, -0.437988, 0.895996);
 glVertex3f(-0.259869, 0.541370, 0.035537);
 glNormal3f(-0.040527, -0.347656, 0.936523);
 glVertex3f(-0.310805, 0.561508, 0.035537);
 glNormal3f(-0.099121, -0.904297, 0.415527);
 glVertex3f(-0.317912, 0.548478, 0.023691);
 glNormal3f(-0.137695, -0.892090, 0.430176);
 glVertex3f(-0.261053, 0.528340, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.061523, -0.436523, 0.897461);
 glVertex3f(-0.365295, 0.555585, 0.035537);
 glNormal3f(-0.040527, -0.347656, 0.936523);
 glVertex3f(-0.310805, 0.561508, 0.035537);
 glNormal3f(0.032715, 0.317871, 0.947266);
 glVertex3f(-0.358187, 0.611260, 0.035537);
 glNormal3f(-0.094238, -0.309570, 0.945801);
 glVertex3f(-0.404385, 0.573354, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.094238, -0.309570, 0.945801);
 glVertex3f(-0.404385, 0.573354, 0.035537);
 glNormal3f(0.032715, 0.317871, 0.947266);
 glVertex3f(-0.358187, 0.611260, 0.035537);
 glNormal3f(-0.008301, 0.368164, 0.929199);
 glVertex3f(-0.432815, 0.614813, 0.035537);
 glNormal3f(-0.002441, -0.343750, 0.938965);
 glVertex3f(-0.451768, 0.580461, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.002441, -0.343750, 0.938965);
 glVertex3f(-0.451768, 0.580461, 0.035537);
 glNormal3f(-0.008301, 0.368164, 0.929199);
 glVertex3f(-0.432815, 0.614813, 0.035537);
 glNormal3f(-0.093262, 0.310059, 0.945801);
 glVertex3f(-0.492043, 0.607706, 0.035537);
 glNormal3f(0.206543, -0.366699, 0.906738);
 glVertex3f(-0.476644, 0.576907, 0.035537);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.206543, -0.366699, 0.906738);
 glVertex3f(-0.476644, 0.576907, 0.035537);
 glNormal3f(-0.093262, 0.310059, 0.945801);
 glVertex3f(-0.492043, 0.607706, 0.035537);
 glNormal3f(-0.291016, 0.285156, 0.913086);
 glVertex3f(-0.524026, 0.591122, 0.035537);
 glNormal3f(-0.320801, 0.099121, 0.941895);
 glVertex3f(-0.542979, 0.552031, 0.035537);
 glNormal3f(0.401855, -0.217773, 0.889160);
 glVertex3f(-0.508627, 0.548478, 0.035537);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.956055, -0.293945, 0.000000);
 glVertex3f(-0.570224, 0.458451, 0.004738);
 glNormal3f(-0.859375, -0.358887, 0.364258);
 glVertex3f(-0.570224, 0.458451, 0.023691);
 glNormal3f(-0.858887, 0.279297, 0.429199);
 glVertex3f(-0.553640, 0.566246, 0.023691);
 glNormal3f(-0.666016, 0.222656, 0.711914);
 glVertex3f(-0.553640, 0.566246, 0.004738);
 glNormal3f(-0.911621, -0.187500, 0.366699);
 glVertex3f(-0.564301, 0.489250, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.858887, 0.279297, 0.429199);
 glVertex3f(-0.553640, 0.566246, 0.023691);
 glNormal3f(-0.628418, 0.626953, 0.460449);
 glVertex3f(-0.533503, 0.604152, 0.023691);
 glNormal3f(-0.485840, 0.490234, 0.723145);
 glVertex3f(-0.533503, 0.604152, 0.004738);
 glNormal3f(-0.666016, 0.222656, 0.711914);
 glVertex3f(-0.553640, 0.566246, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.628418, 0.626953, 0.460449);
 glVertex3f(-0.533503, 0.604152, 0.023691);
 glNormal3f(-0.262207, 0.857910, 0.440918);
 glVertex3f(-0.501519, 0.620736, 0.023691);
 glNormal3f(-0.206543, 0.669922, 0.712402);
 glVertex3f(-0.501519, 0.620736, 0.004738);
 glNormal3f(-0.485840, 0.490234, 0.723145);
 glVertex3f(-0.533503, 0.604152, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.262207, 0.857910, 0.440918);
 glVertex3f(-0.501519, 0.620736, 0.023691);
 glNormal3f(-0.019043, 0.917480, 0.395996);
 glVertex3f(-0.442291, 0.627843, 0.023691);
 glNormal3f(-0.014160, 0.705078, 0.708496);
 glVertex3f(-0.442291, 0.627843, 0.004738);
 glNormal3f(-0.206543, 0.669922, 0.712402);
 glVertex3f(-0.501519, 0.620736, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.019043, 0.917480, 0.395996);
 glVertex3f(-0.442291, 0.627843, 0.023691);
 glNormal3f(0.098145, 0.923340, 0.370605);
 glVertex3f(-0.368848, 0.621921, 0.023691);
 glNormal3f(0.075684, 0.697266, 0.712402);
 glVertex3f(-0.368848, 0.621921, 0.004738);
 glNormal3f(-0.014160, 0.705078, 0.708496);
 glVertex3f(-0.442291, 0.627843, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.023438, 0.714844, 0.698730);
 glVertex3f(-0.443476, 0.632582, 0.004738);
 glNormal3f(-0.225098, 0.688477, 0.688965);
 glVertex3f(-0.502704, 0.625474, 0.004738);
 glNormal3f(-0.206543, 0.669922, 0.712402);
 glVertex3f(-0.501519, 0.620736, 0.004738);
 glNormal3f(-0.014160, 0.705078, 0.708496);
 glVertex3f(-0.442291, 0.627843, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.514160, 0.500000, 0.696777);
 glVertex3f(-0.539425, 0.604152, 0.004738);
 glNormal3f(-0.666016, 0.222168, 0.711914);
 glVertex3f(-0.558378, 0.568615, 0.004738);
 glNormal3f(-0.666016, 0.222656, 0.711914);
 glVertex3f(-0.553640, 0.566246, 0.004738);
 glNormal3f(-0.485840, 0.490234, 0.723145);
 glVertex3f(-0.533503, 0.604152, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.014160, 0.705078, 0.708496);
 glVertex3f(-0.442291, 0.627843, 0.004738);
 glNormal3f(0.075684, 0.697266, 0.712402);
 glVertex3f(-0.368848, 0.621921, 0.004738);
 glNormal3f(0.069336, 0.712891, 0.697266);
 glVertex3f(-0.367664, 0.629028, 0.004738);
 glNormal3f(-0.023438, 0.714844, 0.698730);
 glVertex3f(-0.443476, 0.632582, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.067383, 0.693359, -0.717285);
 glVertex3f(-0.367664, 0.629028, -0.005923);
 glNormal3f(-0.022949, 0.695312, -0.718262);
 glVertex3f(-0.443476, 0.632582, -0.005923);
 glNormal3f(-0.023438, 0.714844, 0.698730);
 glVertex3f(-0.443476, 0.632582, 0.004738);
 glNormal3f(0.069336, 0.712891, 0.697266);
 glVertex3f(-0.367664, 0.629028, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.208984, 0.639648, -0.739746);
 glVertex3f(-0.502704, 0.625474, -0.005923);
 glNormal3f(-0.477051, 0.463867, -0.746582);
 glVertex3f(-0.539425, 0.604152, -0.005923);
 glNormal3f(-0.514160, 0.500000, 0.696777);
 glVertex3f(-0.539425, 0.604152, 0.004738);
 glNormal3f(-0.225098, 0.688477, 0.688965);
 glVertex3f(-0.502704, 0.625474, 0.004738);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.775879, -0.363281, 0.516113);
 glVertex3f(-0.570224, 0.492803, 0.004738);
 glNormal3f(-0.666016, 0.222168, 0.711914);
 glVertex3f(-0.558378, 0.568615, 0.004738);
 glNormal3f(-0.666016, 0.222168, -0.712402);
 glVertex3f(-0.558378, 0.568615, -0.005923);
 glNormal3f(-0.775879, -0.363281, -0.516602);
 glVertex3f(-0.570224, 0.492803, -0.005923);
 glNormal3f(-0.791016, -0.612305, 0.000000);
 glVertex3f(-0.570224, 0.492803, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.666016, 0.222656, 0.711914);
 glVertex3f(-0.553640, 0.566246, 0.004738);
 glNormal3f(-0.666016, 0.222168, 0.711914);
 glVertex3f(-0.558378, 0.568615, 0.004738);
 glNormal3f(-0.775879, -0.363281, 0.516113);
 glVertex3f(-0.570224, 0.492803, 0.004738);
 glNormal3f(-0.911621, -0.187500, 0.366699);
 glVertex3f(-0.564301, 0.489250, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.775879, -0.363281, 0.516113);
 glVertex3f(-0.570224, 0.492803, 0.004738);
 glNormal3f(-0.791016, -0.612305, 0.000000);
 glVertex3f(-0.570224, 0.492803, 0.000000);
 glNormal3f(-0.913086, -0.408203, 0.000000);
 glVertex3f(-0.564301, 0.489250, 0.000000);
 glNormal3f(-0.911621, -0.187500, 0.366699);
 glVertex3f(-0.564301, 0.489250, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.791016, -0.612305, 0.000000);
 glVertex3f(-0.570224, 0.492803, 0.000000);
 glNormal3f(-0.775879, -0.363281, -0.516602);
 glVertex3f(-0.570224, 0.492803, -0.005923);
 glNormal3f(-0.911621, -0.187500, -0.367188);
 glVertex3f(-0.564301, 0.489250, -0.005923);
 glNormal3f(-0.913086, -0.408203, 0.000000);
 glVertex3f(-0.564301, 0.489250, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.666016, 0.222168, -0.712402);
 glVertex3f(-0.558378, 0.568615, -0.005923);
 glNormal3f(-0.666016, 0.222656, -0.711914);
 glVertex3f(-0.553640, 0.566246, -0.005923);
 glNormal3f(-0.911621, -0.187500, -0.367188);
 glVertex3f(-0.564301, 0.489250, -0.005923);
 glNormal3f(-0.775879, -0.363281, -0.516602);
 glVertex3f(-0.570224, 0.492803, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.077148, 0.708008, -0.702148);
 glVertex3f(-0.368848, 0.621921, -0.005923);
 glNormal3f(-0.014160, 0.705078, -0.708984);
 glVertex3f(-0.442291, 0.627843, -0.005923);
 glNormal3f(-0.022949, 0.695312, -0.718262);
 glVertex3f(-0.443476, 0.632582, -0.005923);
 glNormal3f(0.067383, 0.693359, -0.717285);
 glVertex3f(-0.367664, 0.629028, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.666016, 0.222168, -0.712402);
 glVertex3f(-0.558378, 0.568615, -0.005923);
 glNormal3f(-0.477051, 0.463867, -0.746582);
 glVertex3f(-0.539425, 0.604152, -0.005923);
 glNormal3f(-0.485840, 0.490234, -0.723633);
 glVertex3f(-0.533503, 0.604152, -0.005923);
 glNormal3f(-0.666016, 0.222656, -0.711914);
 glVertex3f(-0.553640, 0.566246, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.208984, 0.639648, -0.739746);
 glVertex3f(-0.502704, 0.625474, -0.005923);
 glNormal3f(-0.022949, 0.695312, -0.718262);
 glVertex3f(-0.443476, 0.632582, -0.005923);
 glNormal3f(-0.014160, 0.705078, -0.708984);
 glVertex3f(-0.442291, 0.627843, -0.005923);
 glNormal3f(-0.206543, 0.669922, -0.712891);
 glVertex3f(-0.501519, 0.620736, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.100586, 0.933594, -0.343262);
 glVertex3f(-0.368848, 0.621921, -0.024876);
 glNormal3f(-0.015625, 0.922852, -0.384277);
 glVertex3f(-0.442291, 0.627843, -0.024876);
 glNormal3f(-0.014160, 0.705078, -0.708984);
 glVertex3f(-0.442291, 0.627843, -0.005923);
 glNormal3f(0.077148, 0.708008, -0.702148);
 glVertex3f(-0.368848, 0.621921, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.015625, 0.922852, -0.384277);
 glVertex3f(-0.442291, 0.627843, -0.024876);
 glNormal3f(-0.259277, 0.863770, -0.431641);
 glVertex3f(-0.501519, 0.620736, -0.024876);
 glNormal3f(-0.206543, 0.669922, -0.712891);
 glVertex3f(-0.501519, 0.620736, -0.005923);
 glNormal3f(-0.014160, 0.705078, -0.708984);
 glVertex3f(-0.442291, 0.627843, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.259277, 0.863770, -0.431641);
 glVertex3f(-0.501519, 0.620736, -0.024876);
 glNormal3f(-0.626953, 0.631348, -0.457031);
 glVertex3f(-0.533503, 0.604152, -0.024876);
 glNormal3f(-0.485840, 0.490234, -0.723633);
 glVertex3f(-0.533503, 0.604152, -0.005923);
 glNormal3f(-0.206543, 0.669922, -0.712891);
 glVertex3f(-0.501519, 0.620736, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.626953, 0.631348, -0.457031);
 glVertex3f(-0.533503, 0.604152, -0.024876);
 glNormal3f(-0.858887, 0.279297, -0.429688);
 glVertex3f(-0.553640, 0.566246, -0.024876);
 glNormal3f(-0.666016, 0.222656, -0.711914);
 glVertex3f(-0.553640, 0.566246, -0.005923);
 glNormal3f(-0.485840, 0.490234, -0.723633);
 glVertex3f(-0.533503, 0.604152, -0.005923);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.666016, 0.222656, -0.711914);
 glVertex3f(-0.553640, 0.566246, -0.005923);
 glNormal3f(-0.858887, 0.279297, -0.429688);
 glVertex3f(-0.553640, 0.566246, -0.024876);
 glNormal3f(-0.859375, -0.358887, -0.364746);
 glVertex3f(-0.570224, 0.458451, -0.024876);
 glNormal3f(-0.956055, -0.293945, 0.000000);
 glVertex3f(-0.570224, 0.458451, -0.005923);
 glNormal3f(-0.911621, -0.187500, -0.367188);
 glVertex3f(-0.564301, 0.489250, -0.005923);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.291016, 0.291504, -0.911621);
 glVertex3f(-0.524026, 0.591122, -0.036721);
 glNormal3f(-0.092285, 0.320801, -0.942871);
 glVertex3f(-0.492043, 0.607706, -0.036721);
 glNormal3f(0.198730, -0.354004, -0.914062);
 glVertex3f(-0.476644, 0.576907, -0.036721);
 glNormal3f(0.382812, -0.206543, -0.900879);
 glVertex3f(-0.508627, 0.548478, -0.036721);
 glNormal3f(-0.320801, 0.099121, -0.942383);
 glVertex3f(-0.542979, 0.552031, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.005371, 0.380859, -0.924805);
 glVertex3f(-0.432815, 0.614813, -0.036721);
 glNormal3f(0.010254, -0.348145, -0.937500);
 glVertex3f(-0.451768, 0.580461, -0.036721);
 glNormal3f(0.198730, -0.354004, -0.914062);
 glVertex3f(-0.476644, 0.576907, -0.036721);
 glNormal3f(-0.092285, 0.320801, -0.942871);
 glVertex3f(-0.492043, 0.607706, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.034668, 0.328125, -0.943848);
 glVertex3f(-0.358187, 0.611260, -0.036721);
 glNormal3f(-0.087402, -0.308594, -0.947266);
 glVertex3f(-0.404385, 0.573354, -0.036721);
 glNormal3f(0.010254, -0.348145, -0.937500);
 glVertex3f(-0.451768, 0.580461, -0.036721);
 glNormal3f(-0.005371, 0.380859, -0.924805);
 glVertex3f(-0.432815, 0.614813, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.040527, -0.347656, -0.937012);
 glVertex3f(-0.310805, 0.561508, -0.036721);
 glNormal3f(-0.057129, -0.432617, -0.899902);
 glVertex3f(-0.365295, 0.555585, -0.036721);
 glNormal3f(-0.087402, -0.308594, -0.947266);
 glVertex3f(-0.404385, 0.573354, -0.036721);
 glNormal3f(0.034668, 0.328125, -0.943848);
 glVertex3f(-0.358187, 0.611260, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.040527, -0.347656, -0.937012);
 glVertex3f(-0.310805, 0.561508, -0.036721);
 glNormal3f(-0.069824, -0.450195, -0.890625);
 glVertex3f(-0.259869, 0.541370, -0.036721);
 glNormal3f(-0.136719, -0.896484, -0.421875);
 glVertex3f(-0.261053, 0.528340, -0.024876);
 glNormal3f(-0.099121, -0.904297, -0.416016);
 glVertex3f(-0.317912, 0.548478, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.057129, -0.432617, -0.899902);
 glVertex3f(-0.365295, 0.555585, -0.036721);
 glNormal3f(-0.040527, -0.347656, -0.937012);
 glVertex3f(-0.310805, 0.561508, -0.036721);
 glNormal3f(-0.099121, -0.904297, -0.416016);
 glVertex3f(-0.317912, 0.548478, -0.024876);
 glNormal3f(-0.124023, -0.890625, -0.437988);
 glVertex3f(-0.372402, 0.541370, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.087402, -0.308594, -0.947266);
 glVertex3f(-0.404385, 0.573354, -0.036721);
 glNormal3f(-0.057129, -0.432617, -0.899902);
 glVertex3f(-0.365295, 0.555585, -0.036721);
 glNormal3f(-0.124023, -0.890625, -0.437988);
 glVertex3f(-0.372402, 0.541370, -0.024876);
 glNormal3f(-0.248535, -0.861328, -0.443848);
 glVertex3f(-0.412677, 0.559139, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.010254, -0.348145, -0.937500);
 glVertex3f(-0.451768, 0.580461, -0.036721);
 glNormal3f(-0.087402, -0.308594, -0.947266);
 glVertex3f(-0.404385, 0.573354, -0.036721);
 glNormal3f(-0.248535, -0.861328, -0.443848);
 glVertex3f(-0.412677, 0.559139, -0.024876);
 glNormal3f(0.005859, -0.909180, -0.416992);
 glVertex3f(-0.458875, 0.566246, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.198730, -0.354004, -0.914062);
 glVertex3f(-0.476644, 0.576907, -0.036721);
 glNormal3f(0.010254, -0.348145, -0.937500);
 glVertex3f(-0.451768, 0.580461, -0.036721);
 glNormal3f(0.005859, -0.909180, -0.416992);
 glVertex3f(-0.458875, 0.566246, -0.024876);
 glNormal3f(0.458496, -0.812988, -0.359863);
 glVertex3f(-0.484935, 0.562693, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.850098, -0.416504, -0.321777);
 glVertex3f(-0.499150, 0.544924, -0.024876);
 glNormal3f(0.382812, -0.206543, -0.900879);
 glVertex3f(-0.508627, 0.548478, -0.036721);
 glNormal3f(0.198730, -0.354004, -0.914062);
 glVertex3f(-0.476644, 0.576907, -0.036721);
 glNormal3f(0.458496, -0.812988, -0.359863);
 glVertex3f(-0.484935, 0.562693, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.304688, -0.540527, -0.784180);
 glVertex3f(-0.525211, 0.452528, -0.036721);
 glNormal3f(0.382812, -0.206543, -0.900879);
 glVertex3f(-0.508627, 0.548478, -0.036721);
 glNormal3f(0.850098, -0.416504, -0.321777);
 glVertex3f(-0.499150, 0.544924, -0.024876);
 glNormal3f(0.746094, -0.598633, -0.291016);
 glVertex3f(-0.515734, 0.451344, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.320801, 0.099121, -0.942383);
 glVertex3f(-0.542979, 0.552031, -0.036721);
 glNormal3f(-0.370117, -0.423828, -0.827148);
 glVertex3f(-0.556009, 0.456082, -0.036721);
 glNormal3f(-0.859375, -0.358887, -0.364746);
 glVertex3f(-0.570224, 0.458451, -0.024876);
 glNormal3f(-0.858887, 0.279297, -0.429688);
 glVertex3f(-0.553640, 0.566246, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.291016, 0.291504, -0.911621);
 glVertex3f(-0.524026, 0.591122, -0.036721);
 glNormal3f(-0.320801, 0.099121, -0.942383);
 glVertex3f(-0.542979, 0.552031, -0.036721);
 glNormal3f(-0.858887, 0.279297, -0.429688);
 glVertex3f(-0.553640, 0.566246, -0.024876);
 glNormal3f(-0.626953, 0.631348, -0.457031);
 glVertex3f(-0.533503, 0.604152, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.092285, 0.320801, -0.942871);
 glVertex3f(-0.492043, 0.607706, -0.036721);
 glNormal3f(-0.291016, 0.291504, -0.911621);
 glVertex3f(-0.524026, 0.591122, -0.036721);
 glNormal3f(-0.626953, 0.631348, -0.457031);
 glVertex3f(-0.533503, 0.604152, -0.024876);
 glNormal3f(-0.259277, 0.863770, -0.431641);
 glVertex3f(-0.501519, 0.620736, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.005371, 0.380859, -0.924805);
 glVertex3f(-0.432815, 0.614813, -0.036721);
 glNormal3f(-0.092285, 0.320801, -0.942871);
 glVertex3f(-0.492043, 0.607706, -0.036721);
 glNormal3f(-0.259277, 0.863770, -0.431641);
 glVertex3f(-0.501519, 0.620736, -0.024876);
 glNormal3f(-0.015625, 0.922852, -0.384277);
 glVertex3f(-0.442291, 0.627843, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.034668, 0.328125, -0.943848);
 glVertex3f(-0.358187, 0.611260, -0.036721);
 glNormal3f(-0.005371, 0.380859, -0.924805);
 glVertex3f(-0.432815, 0.614813, -0.036721);
 glNormal3f(-0.015625, 0.922852, -0.384277);
 glVertex3f(-0.442291, 0.627843, -0.024876);
 glNormal3f(0.100586, 0.933594, -0.343262);
 glVertex3f(-0.368848, 0.621921, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.206543, 0.669922, -0.712891);
 glVertex3f(-0.501519, 0.620736, -0.005923);
 glNormal3f(-0.485840, 0.490234, -0.723633);
 glVertex3f(-0.533503, 0.604152, -0.005923);
 glNormal3f(-0.477051, 0.463867, -0.746582);
 glVertex3f(-0.539425, 0.604152, -0.005923);
 glNormal3f(-0.208984, 0.639648, -0.739746);
 glVertex3f(-0.502704, 0.625474, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.956055, -0.293945, 0.000000);
 glVertex3f(-0.570224, 0.458451, -0.005923);
 glNormal3f(-0.959961, -0.281738, 0.000000);
 glVertex3f(-0.570224, 0.458451, 0.000000);
 glNormal3f(-0.913086, -0.408203, 0.000000);
 glVertex3f(-0.564301, 0.489250, 0.000000);
 glNormal3f(-0.911621, -0.187500, -0.367188);
 glVertex3f(-0.564301, 0.489250, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.304688, -0.540527, -0.784180);
 glVertex3f(-0.525211, 0.452528, -0.036721);
 glNormal3f(-0.370117, -0.423828, -0.827148);
 glVertex3f(-0.556009, 0.456082, -0.036721);
 glNormal3f(-0.320801, 0.099121, -0.942383);
 glVertex3f(-0.542979, 0.552031, -0.036721);
 glNormal3f(0.382812, -0.206543, -0.900879);
 glVertex3f(-0.508627, 0.548478, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.256348, -0.511230, -0.820801);
 glVertex3f(0.001920, 0.377901, -0.036721);
 glNormal3f(-0.437012, -0.438477, -0.785645);
 glVertex3f(-0.028879, 0.382639, -0.036721);
 glNormal3f(-0.450684, -0.101562, -0.887207);
 glVertex3f(-0.018218, 0.479773, -0.036721);
 glNormal3f(0.342285, 0.006348, -0.939941);
 glVertex3f(0.016134, 0.475035, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.833496, -0.552246, 0.000000);
 glVertex3f(0.016134, 0.376716, 0.000000);
 glNormal3f(0.833496, -0.552734, 0.000000);
 glVertex3f(0.016134, 0.376716, -0.005923);
 glNormal3f(0.828613, -0.427734, -0.360352);
 glVertex3f(0.019688, 0.406330, -0.005923);
 glNormal3f(0.774414, -0.632324, 0.000000);
 glVertex3f(0.019688, 0.406330, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.604004, 0.341309, -0.719727);
 glVertex3f(0.022057, 0.524787, -0.005923);
 glNormal3f(0.378906, 0.606934, -0.698242);
 glVertex3f(-0.005188, 0.548478, -0.005923);
 glNormal3f(0.383301, 0.587891, -0.712402);
 glVertex3f(-0.002819, 0.555585, -0.005923);
 glNormal3f(0.600586, 0.336914, -0.724609);
 glVertex3f(0.027980, 0.527156, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.118164, 0.360840, -0.925293);
 glVertex3f(-0.072708, 0.565062, -0.036721);
 glNormal3f(0.056641, 0.316895, -0.946777);
 glVertex3f(-0.144966, 0.580461, -0.036721);
 glNormal3f(0.165039, 0.923340, -0.346680);
 glVertex3f(-0.131936, 0.589937, -0.024876);
 glNormal3f(0.285156, 0.883301, -0.371582);
 glVertex3f(-0.059678, 0.573354, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.188477, 0.296875, -0.936035);
 glVertex3f(-0.018218, 0.541370, -0.036721);
 glNormal3f(0.118164, 0.360840, -0.925293);
 glVertex3f(-0.072708, 0.565062, -0.036721);
 glNormal3f(0.285156, 0.883301, -0.371582);
 glVertex3f(-0.059678, 0.573354, -0.024876);
 glNormal3f(0.488770, 0.777344, -0.395996);
 glVertex3f(-0.005188, 0.548478, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.367188, 0.208984, -0.906738);
 glVertex3f(0.007842, 0.517679, -0.036721);
 glNormal3f(0.188477, 0.296875, -0.936035);
 glVertex3f(-0.018218, 0.541370, -0.036721);
 glNormal3f(0.488770, 0.777344, -0.395996);
 glVertex3f(-0.005188, 0.548478, -0.024876);
 glNormal3f(0.780762, 0.442871, -0.440430);
 glVertex3f(0.022057, 0.524787, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.342285, 0.006348, -0.939941);
 glVertex3f(0.016134, 0.475035, -0.036721);
 glNormal3f(0.367188, 0.208984, -0.906738);
 glVertex3f(0.007842, 0.517679, -0.036721);
 glNormal3f(0.780762, 0.442871, -0.440430);
 glVertex3f(0.022057, 0.524787, -0.024876);
 glNormal3f(0.905762, 0.021484, -0.422363);
 glVertex3f(0.029165, 0.484511, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.256348, -0.511230, -0.820801);
 glVertex3f(0.001920, 0.377901, -0.036721);
 glNormal3f(0.342285, 0.006348, -0.939941);
 glVertex3f(0.016134, 0.475035, -0.036721);
 glNormal3f(0.905762, 0.021484, -0.422363);
 glVertex3f(0.029165, 0.484511, -0.024876);
 glNormal3f(0.736816, -0.576660, -0.353516);
 glVertex3f(0.016134, 0.376716, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.450684, -0.101562, -0.887207);
 glVertex3f(-0.018218, 0.479773, -0.036721);
 glNormal3f(-0.437012, -0.438477, -0.785645);
 glVertex3f(-0.028879, 0.382639, -0.036721);
 glNormal3f(-0.882812, -0.370117, -0.291016);
 glVertex3f(-0.038355, 0.383824, -0.024876);
 glNormal3f(-0.939941, -0.181152, -0.291016);
 glVertex3f(-0.027694, 0.479773, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.312012, -0.302734, -0.900879);
 glVertex3f(-0.040725, 0.514125, -0.036721);
 glNormal3f(-0.450684, -0.101562, -0.887207);
 glVertex3f(-0.018218, 0.479773, -0.036721);
 glNormal3f(-0.939941, -0.181152, -0.291016);
 glVertex3f(-0.027694, 0.479773, -0.024876);
 glNormal3f(-0.678711, -0.660645, -0.321777);
 glVertex3f(-0.037171, 0.499911, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.105469, -0.333984, -0.937012);
 glVertex3f(-0.064416, 0.527156, -0.036721);
 glNormal3f(-0.312012, -0.302734, -0.900879);
 glVertex3f(-0.040725, 0.514125, -0.036721);
 glNormal3f(-0.678711, -0.660645, -0.321777);
 glVertex3f(-0.037171, 0.499911, -0.024876);
 glNormal3f(-0.274902, -0.867676, -0.415039);
 glVertex3f(-0.060862, 0.510572, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.005371, -0.330078, -0.944336);
 glVertex3f(-0.110614, 0.531894, -0.036721);
 glNormal3f(-0.105469, -0.333984, -0.937012);
 glVertex3f(-0.064416, 0.527156, -0.036721);
 glNormal3f(-0.274902, -0.867676, -0.415039);
 glVertex3f(-0.060862, 0.510572, -0.024876);
 glNormal3f(0.007812, -0.900391, -0.435547);
 glVertex3f(-0.107060, 0.517679, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.059570, -0.463379, -0.884277);
 glVertex3f(-0.154443, 0.524787, -0.036721);
 glNormal3f(0.005371, -0.330078, -0.944336);
 glVertex3f(-0.110614, 0.531894, -0.036721);
 glNormal3f(0.007812, -0.900391, -0.435547);
 glVertex3f(-0.107060, 0.517679, -0.024876);
 glNormal3f(-0.110840, -0.903809, -0.414062);
 glVertex3f(-0.150889, 0.510572, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.062988, -0.358398, -0.931641);
 glVertex3f(-0.206563, 0.544924, -0.036721);
 glNormal3f(-0.059570, -0.463379, -0.884277);
 glVertex3f(-0.154443, 0.524787, -0.036721);
 glNormal3f(-0.110840, -0.903809, -0.414062);
 glVertex3f(-0.150889, 0.510572, -0.024876);
 glNormal3f(-0.160645, -0.901855, -0.401855);
 glVertex3f(-0.203010, 0.531894, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.069824, -0.450195, -0.890625);
 glVertex3f(-0.259869, 0.541370, -0.036721);
 glNormal3f(-0.062988, -0.358398, -0.931641);
 glVertex3f(-0.206563, 0.544924, -0.036721);
 glNormal3f(-0.160645, -0.901855, -0.401855);
 glVertex3f(-0.203010, 0.531894, -0.024876);
 glNormal3f(-0.136719, -0.896484, -0.421875);
 glVertex3f(-0.261053, 0.528340, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.056641, 0.316895, -0.946777);
 glVertex3f(-0.144966, 0.580461, -0.036721);
 glNormal3f(0.034668, 0.328125, -0.943848);
 glVertex3f(-0.358187, 0.611260, -0.036721);
 glNormal3f(0.100586, 0.933594, -0.343262);
 glVertex3f(-0.368848, 0.621921, -0.024876);
 glNormal3f(0.165039, 0.923340, -0.346680);
 glVertex3f(-0.131936, 0.589937, -0.024876);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.059570, -0.463379, -0.884277);
 glVertex3f(-0.154443, 0.524787, -0.036721);
 glNormal3f(-0.062988, -0.358398, -0.931641);
 glVertex3f(-0.206563, 0.544924, -0.036721);
 glNormal3f(0.056641, 0.316895, -0.946777);
 glVertex3f(-0.144966, 0.580461, -0.036721);
 glNormal3f(0.005371, -0.330078, -0.944336);
 glVertex3f(-0.110614, 0.531894, -0.036721);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.069824, -0.450195, -0.890625);
 glVertex3f(-0.259869, 0.541370, -0.036721);
 glNormal3f(-0.040527, -0.347656, -0.937012);
 glVertex3f(-0.310805, 0.561508, -0.036721);
 glNormal3f(0.034668, 0.328125, -0.943848);
 glVertex3f(-0.358187, 0.611260, -0.036721);
 glNormal3f(0.056641, 0.316895, -0.946777);
 glVertex3f(-0.144966, 0.580461, -0.036721);
 glNormal3f(-0.062988, -0.358398, -0.931641);
 glVertex3f(-0.206563, 0.544924, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.005371, -0.330078, -0.944336);
 glVertex3f(-0.110614, 0.531894, -0.036721);
 glNormal3f(0.056641, 0.316895, -0.946777);
 glVertex3f(-0.144966, 0.580461, -0.036721);
 glNormal3f(0.118164, 0.360840, -0.925293);
 glVertex3f(-0.072708, 0.565062, -0.036721);
 glNormal3f(-0.105469, -0.333984, -0.937012);
 glVertex3f(-0.064416, 0.527156, -0.036721);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.105469, -0.333984, -0.937012);
 glVertex3f(-0.064416, 0.527156, -0.036721);
 glNormal3f(0.118164, 0.360840, -0.925293);
 glVertex3f(-0.072708, 0.565062, -0.036721);
 glNormal3f(0.188477, 0.296875, -0.936035);
 glVertex3f(-0.018218, 0.541370, -0.036721);
 glNormal3f(-0.312012, -0.302734, -0.900879);
 glVertex3f(-0.040725, 0.514125, -0.036721);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.312012, -0.302734, -0.900879);
 glVertex3f(-0.040725, 0.514125, -0.036721);
 glNormal3f(0.188477, 0.296875, -0.936035);
 glVertex3f(-0.018218, 0.541370, -0.036721);
 glNormal3f(0.367188, 0.208984, -0.906738);
 glVertex3f(0.007842, 0.517679, -0.036721);
 glNormal3f(0.342285, 0.006348, -0.939941);
 glVertex3f(0.016134, 0.475035, -0.036721);
 glNormal3f(-0.450684, -0.101562, -0.887207);
 glVertex3f(-0.018218, 0.479773, -0.036721);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.833496, -0.552734, 0.000000);
 glVertex3f(0.016134, 0.376716, -0.005923);
 glNormal3f(0.736816, -0.576660, -0.353516);
 glVertex3f(0.016134, 0.376716, -0.024876);
 glNormal3f(0.905762, 0.021484, -0.422363);
 glVertex3f(0.029165, 0.484511, -0.024876);
 glNormal3f(0.702637, 0.019043, -0.710938);
 glVertex3f(0.029165, 0.484511, -0.005923);
 glNormal3f(0.828613, -0.427734, -0.360352);
 glVertex3f(0.019688, 0.406330, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.905762, 0.021484, -0.422363);
 glVertex3f(0.029165, 0.484511, -0.024876);
 glNormal3f(0.780762, 0.442871, -0.440430);
 glVertex3f(0.022057, 0.524787, -0.024876);
 glNormal3f(0.604004, 0.341309, -0.719727);
 glVertex3f(0.022057, 0.524787, -0.005923);
 glNormal3f(0.702637, 0.019043, -0.710938);
 glVertex3f(0.029165, 0.484511, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.780762, 0.442871, -0.440430);
 glVertex3f(0.022057, 0.524787, -0.024876);
 glNormal3f(0.488770, 0.777344, -0.395996);
 glVertex3f(-0.005188, 0.548478, -0.024876);
 glNormal3f(0.378906, 0.606934, -0.698242);
 glVertex3f(-0.005188, 0.548478, -0.005923);
 glNormal3f(0.604004, 0.341309, -0.719727);
 glVertex3f(0.022057, 0.524787, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.488770, 0.777344, -0.395996);
 glVertex3f(-0.005188, 0.548478, -0.024876);
 glNormal3f(0.285156, 0.883301, -0.371582);
 glVertex3f(-0.059678, 0.573354, -0.024876);
 glNormal3f(0.217773, 0.681641, -0.698242);
 glVertex3f(-0.059678, 0.573354, -0.005923);
 glNormal3f(0.378906, 0.606934, -0.698242);
 glVertex3f(-0.005188, 0.548478, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.285156, 0.883301, -0.371582);
 glVertex3f(-0.059678, 0.573354, -0.024876);
 glNormal3f(0.165039, 0.923340, -0.346680);
 glVertex3f(-0.131936, 0.589937, -0.024876);
 glNormal3f(0.126465, 0.706055, -0.696777);
 glVertex3f(-0.131936, 0.589937, -0.005923);
 glNormal3f(0.217773, 0.681641, -0.698242);
 glVertex3f(-0.059678, 0.573354, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.165039, 0.923340, -0.346680);
 glVertex3f(-0.131936, 0.589937, -0.024876);
 glNormal3f(0.100586, 0.933594, -0.343262);
 glVertex3f(-0.368848, 0.621921, -0.024876);
 glNormal3f(0.077148, 0.708008, -0.702148);
 glVertex3f(-0.368848, 0.621921, -0.005923);
 glNormal3f(0.126465, 0.706055, -0.696777);
 glVertex3f(-0.131936, 0.589937, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.067383, 0.693359, -0.717285);
 glVertex3f(-0.367664, 0.629028, -0.005923);
 glNormal3f(0.115234, 0.697266, -0.707520);
 glVertex3f(-0.131936, 0.594676, -0.005923);
 glNormal3f(0.126465, 0.706055, -0.696777);
 glVertex3f(-0.131936, 0.589937, -0.005923);
 glNormal3f(0.077148, 0.708008, -0.702148);
 glVertex3f(-0.368848, 0.621921, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207520, 0.673340, -0.709473);
 glVertex3f(-0.057308, 0.580461, -0.005923);
 glNormal3f(0.383301, 0.587891, -0.712402);
 glVertex3f(-0.002819, 0.555585, -0.005923);
 glNormal3f(0.378906, 0.606934, -0.698242);
 glVertex3f(-0.005188, 0.548478, -0.005923);
 glNormal3f(0.217773, 0.681641, -0.698242);
 glVertex3f(-0.059678, 0.573354, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.600586, 0.336914, -0.724609);
 glVertex3f(0.027980, 0.527156, -0.005923);
 glNormal3f(0.701660, 0.025879, -0.711914);
 glVertex3f(0.036272, 0.485696, -0.005923);
 glNormal3f(0.702637, 0.019043, -0.710938);
 glVertex3f(0.029165, 0.484511, -0.005923);
 glNormal3f(0.604004, 0.341309, -0.719727);
 glVertex3f(0.022057, 0.524787, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.217773, 0.681641, -0.698242);
 glVertex3f(-0.059678, 0.573354, -0.005923);
 glNormal3f(0.126465, 0.706055, -0.696777);
 glVertex3f(-0.131936, 0.589937, -0.005923);
 glNormal3f(0.115234, 0.697266, -0.707520);
 glVertex3f(-0.131936, 0.594676, -0.005923);
 glNormal3f(0.207520, 0.673340, -0.709473);
 glVertex3f(-0.057308, 0.580461, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.702637, 0.019043, -0.710938);
 glVertex3f(0.029165, 0.484511, -0.005923);
 glNormal3f(0.701660, 0.025879, -0.711914);
 glVertex3f(0.036272, 0.485696, -0.005923);
 glNormal3f(0.666016, -0.545410, -0.509277);
 glVertex3f(0.026795, 0.408699, -0.005923);
 glNormal3f(0.828613, -0.427734, -0.360352);
 glVertex3f(0.019688, 0.406330, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.666016, -0.545410, -0.509277);
 glVertex3f(0.026795, 0.408699, -0.005923);
 glNormal3f(0.626465, -0.779297, 0.000000);
 glVertex3f(0.026795, 0.408699, 0.000000);
 glNormal3f(0.774414, -0.632324, 0.000000);
 glVertex3f(0.019688, 0.406330, 0.000000);
 glNormal3f(0.828613, -0.427734, -0.360352);
 glVertex3f(0.019688, 0.406330, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.626465, -0.779297, 0.000000);
 glVertex3f(0.026795, 0.408699, 0.000000);
 glNormal3f(0.666016, -0.545410, 0.508789);
 glVertex3f(0.026795, 0.408699, 0.004738);
 glNormal3f(0.828613, -0.427734, 0.359863);
 glVertex3f(0.019688, 0.406330, 0.004738);
 glNormal3f(0.774414, -0.632324, 0.000000);
 glVertex3f(0.019688, 0.406330, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.701660, 0.025879, 0.711426);
 glVertex3f(0.036272, 0.485696, 0.004738);
 glNormal3f(0.702637, 0.019043, 0.710938);
 glVertex3f(0.029165, 0.484511, 0.004738);
 glNormal3f(0.828613, -0.427734, 0.359863);
 glVertex3f(0.019688, 0.406330, 0.004738);
 glNormal3f(0.666016, -0.545410, 0.508789);
 glVertex3f(0.026795, 0.408699, 0.004738);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.666016, -0.545410, -0.509277);
 glVertex3f(0.026795, 0.408699, -0.005923);
 glNormal3f(0.701660, 0.025879, -0.711914);
 glVertex3f(0.036272, 0.485696, -0.005923);
 glNormal3f(0.701660, 0.025879, 0.711426);
 glVertex3f(0.036272, 0.485696, 0.004738);
 glNormal3f(0.666016, -0.545410, 0.508789);
 glVertex3f(0.026795, 0.408699, 0.004738);
 glNormal3f(0.626465, -0.779297, 0.000000);
 glVertex3f(0.026795, 0.408699, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.600586, 0.336914, -0.724609);
 glVertex3f(0.027980, 0.527156, -0.005923);
 glNormal3f(0.383301, 0.587891, -0.712402);
 glVertex3f(-0.002819, 0.555585, -0.005923);
 glNormal3f(0.383301, 0.587891, 0.711914);
 glVertex3f(-0.002819, 0.555585, 0.004738);
 glNormal3f(0.600586, 0.336914, 0.724121);
 glVertex3f(0.027980, 0.527156, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207520, 0.673340, -0.709473);
 glVertex3f(-0.057308, 0.580461, -0.005923);
 glNormal3f(0.115234, 0.697266, -0.707520);
 glVertex3f(-0.131936, 0.594676, -0.005923);
 glNormal3f(0.115234, 0.697266, 0.707031);
 glVertex3f(-0.131936, 0.594676, 0.004738);
 glNormal3f(0.207520, 0.673340, 0.708984);
 glVertex3f(-0.057308, 0.580461, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.125977, 0.689453, 0.712891);
 glVertex3f(-0.131936, 0.589937, 0.004738);
 glNormal3f(0.227539, 0.661621, 0.713867);
 glVertex3f(-0.059678, 0.573354, 0.004738);
 glNormal3f(0.207520, 0.673340, 0.708984);
 glVertex3f(-0.057308, 0.580461, 0.004738);
 glNormal3f(0.115234, 0.697266, 0.707031);
 glVertex3f(-0.131936, 0.594676, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.701660, 0.025879, 0.711426);
 glVertex3f(0.036272, 0.485696, 0.004738);
 glNormal3f(0.600586, 0.336914, 0.724121);
 glVertex3f(0.027980, 0.527156, 0.004738);
 glNormal3f(0.595703, 0.332031, 0.730469);
 glVertex3f(0.022057, 0.524787, 0.004738);
 glNormal3f(0.702637, 0.019043, 0.710938);
 glVertex3f(0.029165, 0.484511, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.383301, 0.587891, 0.711914);
 glVertex3f(-0.002819, 0.555585, 0.004738);
 glNormal3f(0.207520, 0.673340, 0.708984);
 glVertex3f(-0.057308, 0.580461, 0.004738);
 glNormal3f(0.227539, 0.661621, 0.713867);
 glVertex3f(-0.059678, 0.573354, 0.004738);
 glNormal3f(0.381836, 0.579590, 0.719727);
 glVertex3f(-0.005188, 0.548478, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.115234, 0.697266, 0.707031);
 glVertex3f(-0.131936, 0.594676, 0.004738);
 glNormal3f(0.069336, 0.712891, 0.697266);
 glVertex3f(-0.367664, 0.629028, 0.004738);
 glNormal3f(0.075684, 0.697266, 0.712402);
 glVertex3f(-0.368848, 0.621921, 0.004738);
 glNormal3f(0.125977, 0.689453, 0.712891);
 glVertex3f(-0.131936, 0.589937, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.098145, 0.923340, 0.370605);
 glVertex3f(-0.368848, 0.621921, 0.023691);
 glNormal3f(0.166016, 0.911621, 0.374512);
 glVertex3f(-0.131936, 0.589937, 0.023691);
 glNormal3f(0.125977, 0.689453, 0.712891);
 glVertex3f(-0.131936, 0.589937, 0.004738);
 glNormal3f(0.075684, 0.697266, 0.712402);
 glVertex3f(-0.368848, 0.621921, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.166016, 0.911621, 0.374512);
 glVertex3f(-0.131936, 0.589937, 0.023691);
 glNormal3f(0.288574, 0.872070, 0.394531);
 glVertex3f(-0.059678, 0.573354, 0.023691);
 glNormal3f(0.227539, 0.661621, 0.713867);
 glVertex3f(-0.059678, 0.573354, 0.004738);
 glNormal3f(0.125977, 0.689453, 0.712891);
 glVertex3f(-0.131936, 0.589937, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.288574, 0.872070, 0.394531);
 glVertex3f(-0.059678, 0.573354, 0.023691);
 glNormal3f(0.485840, 0.758301, 0.434082);
 glVertex3f(-0.005188, 0.548478, 0.023691);
 glNormal3f(0.381836, 0.579590, 0.719727);
 glVertex3f(-0.005188, 0.548478, 0.004738);
 glNormal3f(0.227539, 0.661621, 0.713867);
 glVertex3f(-0.059678, 0.573354, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.485840, 0.758301, 0.434082);
 glVertex3f(-0.005188, 0.548478, 0.023691);
 glNormal3f(0.773438, 0.432129, 0.462402);
 glVertex3f(0.022057, 0.524787, 0.023691);
 glNormal3f(0.595703, 0.332031, 0.730469);
 glVertex3f(0.022057, 0.524787, 0.004738);
 glNormal3f(0.381836, 0.579590, 0.719727);
 glVertex3f(-0.005188, 0.548478, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.773438, 0.432129, 0.462402);
 glVertex3f(0.022057, 0.524787, 0.023691);
 glNormal3f(0.905762, 0.021484, 0.421875);
 glVertex3f(0.029165, 0.484511, 0.023691);
 glNormal3f(0.702637, 0.019043, 0.710938);
 glVertex3f(0.029165, 0.484511, 0.004738);
 glNormal3f(0.595703, 0.332031, 0.730469);
 glVertex3f(0.022057, 0.524787, 0.004738);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.702637, 0.019043, 0.710938);
 glVertex3f(0.029165, 0.484511, 0.004738);
 glNormal3f(0.905762, 0.021484, 0.421875);
 glVertex3f(0.029165, 0.484511, 0.023691);
 glNormal3f(0.736816, -0.576660, 0.353027);
 glVertex3f(0.016134, 0.376716, 0.023691);
 glNormal3f(0.833496, -0.552734, 0.000000);
 glVertex3f(0.016134, 0.376716, 0.004738);
 glNormal3f(0.828613, -0.427734, 0.359863);
 glVertex3f(0.019688, 0.406330, 0.004738);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.360840, 0.202148, 0.910156);
 glVertex3f(0.007842, 0.517679, 0.035537);
 glNormal3f(0.178223, 0.291016, 0.939453);
 glVertex3f(-0.018218, 0.541370, 0.035537);
 glNormal3f(-0.310059, -0.298828, 0.902344);
 glVertex3f(-0.040725, 0.514125, 0.035537);
 glNormal3f(-0.447754, -0.098633, 0.888672);
 glVertex3f(-0.018218, 0.479773, 0.035537);
 glNormal3f(0.342285, 0.006348, 0.939453);
 glVertex3f(0.016134, 0.475035, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.112305, 0.360352, 0.925781);
 glVertex3f(-0.072708, 0.565062, 0.035537);
 glNormal3f(-0.106445, -0.329590, 0.937988);
 glVertex3f(-0.064416, 0.527156, 0.035537);
 glNormal3f(-0.310059, -0.298828, 0.902344);
 glVertex3f(-0.040725, 0.514125, 0.035537);
 glNormal3f(0.178223, 0.291016, 0.939453);
 glVertex3f(-0.018218, 0.541370, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.056152, 0.311523, 0.948242);
 glVertex3f(-0.144966, 0.580461, 0.035537);
 glNormal3f(0.000977, -0.321777, 0.946777);
 glVertex3f(-0.110614, 0.531894, 0.035537);
 glNormal3f(-0.106445, -0.329590, 0.937988);
 glVertex3f(-0.064416, 0.527156, 0.035537);
 glNormal3f(0.112305, 0.360352, 0.925781);
 glVertex3f(-0.072708, 0.565062, 0.035537);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.032715, 0.317871, 0.947266);
 glVertex3f(-0.358187, 0.611260, 0.035537);
 glNormal3f(-0.040527, -0.347656, 0.936523);
 glVertex3f(-0.310805, 0.561508, 0.035537);
 glNormal3f(-0.069824, -0.437988, 0.895996);
 glVertex3f(-0.259869, 0.541370, 0.035537);
 glNormal3f(-0.063477, -0.337402, 0.938965);
 glVertex3f(-0.206563, 0.544924, 0.035537);
 glNormal3f(0.056152, 0.311523, 0.948242);
 glVertex3f(-0.144966, 0.580461, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.063477, -0.337402, 0.938965);
 glVertex3f(-0.206563, 0.544924, 0.035537);
 glNormal3f(-0.063965, -0.442871, 0.894043);
 glVertex3f(-0.154443, 0.524787, 0.035537);
 glNormal3f(0.000977, -0.321777, 0.946777);
 glVertex3f(-0.110614, 0.531894, 0.035537);
 glNormal3f(0.056152, 0.311523, 0.948242);
 glVertex3f(-0.144966, 0.580461, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.098145, 0.923340, 0.370605);
 glVertex3f(-0.368848, 0.621921, 0.023691);
 glNormal3f(0.032715, 0.317871, 0.947266);
 glVertex3f(-0.358187, 0.611260, 0.035537);
 glNormal3f(0.056152, 0.311523, 0.948242);
 glVertex3f(-0.144966, 0.580461, 0.035537);
 glNormal3f(0.166016, 0.911621, 0.374512);
 glVertex3f(-0.131936, 0.589937, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.063477, -0.337402, 0.938965);
 glVertex3f(-0.206563, 0.544924, 0.035537);
 glNormal3f(-0.069824, -0.437988, 0.895996);
 glVertex3f(-0.259869, 0.541370, 0.035537);
 glNormal3f(-0.137695, -0.892090, 0.430176);
 glVertex3f(-0.261053, 0.528340, 0.023691);
 glNormal3f(-0.163574, -0.892090, 0.421875);
 glVertex3f(-0.203010, 0.531894, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.063965, -0.442871, 0.894043);
 glVertex3f(-0.154443, 0.524787, 0.035537);
 glNormal3f(-0.063477, -0.337402, 0.938965);
 glVertex3f(-0.206563, 0.544924, 0.035537);
 glNormal3f(-0.163574, -0.892090, 0.421875);
 glVertex3f(-0.203010, 0.531894, 0.023691);
 glNormal3f(-0.115234, -0.895996, 0.429199);
 glVertex3f(-0.150889, 0.510572, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.000977, -0.321777, 0.946777);
 glVertex3f(-0.110614, 0.531894, 0.035537);
 glNormal3f(-0.063965, -0.442871, 0.894043);
 glVertex3f(-0.154443, 0.524787, 0.035537);
 glNormal3f(-0.115234, -0.895996, 0.429199);
 glVertex3f(-0.150889, 0.510572, 0.023691);
 glNormal3f(0.003418, -0.896484, 0.443359);
 glVertex3f(-0.107060, 0.517679, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.106445, -0.329590, 0.937988);
 glVertex3f(-0.064416, 0.527156, 0.035537);
 glNormal3f(0.000977, -0.321777, 0.946777);
 glVertex3f(-0.110614, 0.531894, 0.035537);
 glNormal3f(0.003418, -0.896484, 0.443359);
 glVertex3f(-0.107060, 0.517679, 0.023691);
 glNormal3f(-0.277344, -0.865234, 0.418457);
 glVertex3f(-0.060862, 0.510572, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.310059, -0.298828, 0.902344);
 glVertex3f(-0.040725, 0.514125, 0.035537);
 glNormal3f(-0.106445, -0.329590, 0.937988);
 glVertex3f(-0.064416, 0.527156, 0.035537);
 glNormal3f(-0.277344, -0.865234, 0.418457);
 glVertex3f(-0.060862, 0.510572, 0.023691);
 glNormal3f(-0.678223, -0.658691, 0.326172);
 glVertex3f(-0.037171, 0.499911, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.447754, -0.098633, 0.888672);
 glVertex3f(-0.018218, 0.479773, 0.035537);
 glNormal3f(-0.310059, -0.298828, 0.902344);
 glVertex3f(-0.040725, 0.514125, 0.035537);
 glNormal3f(-0.678223, -0.658691, 0.326172);
 glVertex3f(-0.037171, 0.499911, 0.023691);
 glNormal3f(-0.938965, -0.178711, 0.294922);
 glVertex3f(-0.027694, 0.479773, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.437012, -0.438477, 0.785156);
 glVertex3f(-0.028879, 0.382639, 0.035537);
 glNormal3f(-0.447754, -0.098633, 0.888672);
 glVertex3f(-0.018218, 0.479773, 0.035537);
 glNormal3f(-0.938965, -0.178711, 0.294922);
 glVertex3f(-0.027694, 0.479773, 0.023691);
 glNormal3f(-0.882812, -0.370117, 0.290527);
 glVertex3f(-0.038355, 0.383824, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.342285, 0.006348, 0.939453);
 glVertex3f(0.016134, 0.475035, 0.035537);
 glNormal3f(0.256348, -0.511230, 0.820312);
 glVertex3f(0.001920, 0.377901, 0.035537);
 glNormal3f(0.736816, -0.576660, 0.353027);
 glVertex3f(0.016134, 0.376716, 0.023691);
 glNormal3f(0.905762, 0.021484, 0.421875);
 glVertex3f(0.029165, 0.484511, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.360840, 0.202148, 0.910156);
 glVertex3f(0.007842, 0.517679, 0.035537);
 glNormal3f(0.342285, 0.006348, 0.939453);
 glVertex3f(0.016134, 0.475035, 0.035537);
 glNormal3f(0.905762, 0.021484, 0.421875);
 glVertex3f(0.029165, 0.484511, 0.023691);
 glNormal3f(0.773438, 0.432129, 0.462402);
 glVertex3f(0.022057, 0.524787, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.178223, 0.291016, 0.939453);
 glVertex3f(-0.018218, 0.541370, 0.035537);
 glNormal3f(0.360840, 0.202148, 0.910156);
 glVertex3f(0.007842, 0.517679, 0.035537);
 glNormal3f(0.773438, 0.432129, 0.462402);
 glVertex3f(0.022057, 0.524787, 0.023691);
 glNormal3f(0.485840, 0.758301, 0.434082);
 glVertex3f(-0.005188, 0.548478, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.112305, 0.360352, 0.925781);
 glVertex3f(-0.072708, 0.565062, 0.035537);
 glNormal3f(0.178223, 0.291016, 0.939453);
 glVertex3f(-0.018218, 0.541370, 0.035537);
 glNormal3f(0.485840, 0.758301, 0.434082);
 glVertex3f(-0.005188, 0.548478, 0.023691);
 glNormal3f(0.288574, 0.872070, 0.394531);
 glVertex3f(-0.059678, 0.573354, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.056152, 0.311523, 0.948242);
 glVertex3f(-0.144966, 0.580461, 0.035537);
 glNormal3f(0.112305, 0.360352, 0.925781);
 glVertex3f(-0.072708, 0.565062, 0.035537);
 glNormal3f(0.288574, 0.872070, 0.394531);
 glVertex3f(-0.059678, 0.573354, 0.023691);
 glNormal3f(0.166016, 0.911621, 0.374512);
 glVertex3f(-0.131936, 0.589937, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.381836, 0.579590, 0.719727);
 glVertex3f(-0.005188, 0.548478, 0.004738);
 glNormal3f(0.595703, 0.332031, 0.730469);
 glVertex3f(0.022057, 0.524787, 0.004738);
 glNormal3f(0.600586, 0.336914, 0.724121);
 glVertex3f(0.027980, 0.527156, 0.004738);
 glNormal3f(0.383301, 0.587891, 0.711914);
 glVertex3f(-0.002819, 0.555585, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.207520, 0.673340, -0.709473);
 glVertex3f(-0.057308, 0.580461, -0.005923);
 glNormal3f(0.207520, 0.673340, 0.708984);
 glVertex3f(-0.057308, 0.580461, 0.004738);
 glNormal3f(0.383301, 0.587891, 0.711914);
 glVertex3f(-0.002819, 0.555585, 0.004738);
 glNormal3f(0.383301, 0.587891, -0.712402);
 glVertex3f(-0.002819, 0.555585, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.067383, 0.693359, -0.717285);
 glVertex3f(-0.367664, 0.629028, -0.005923);
 glNormal3f(0.069336, 0.712891, 0.697266);
 glVertex3f(-0.367664, 0.629028, 0.004738);
 glNormal3f(0.115234, 0.697266, 0.707031);
 glVertex3f(-0.131936, 0.594676, 0.004738);
 glNormal3f(0.115234, 0.697266, -0.707520);
 glVertex3f(-0.131936, 0.594676, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.136719, -0.896484, -0.421875);
 glVertex3f(-0.261053, 0.528340, -0.024876);
 glNormal3f(-0.160645, -0.901855, -0.401855);
 glVertex3f(-0.203010, 0.531894, -0.024876);
 glNormal3f(-0.163574, -0.892090, 0.421875);
 glVertex3f(-0.203010, 0.531894, 0.023691);
 glNormal3f(-0.137695, -0.892090, 0.430176);
 glVertex3f(-0.261053, 0.528340, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.160645, -0.901855, -0.401855);
 glVertex3f(-0.203010, 0.531894, -0.024876);
 glNormal3f(-0.110840, -0.903809, -0.414062);
 glVertex3f(-0.150889, 0.510572, -0.024876);
 glNormal3f(-0.115234, -0.895996, 0.429199);
 glVertex3f(-0.150889, 0.510572, 0.023691);
 glNormal3f(-0.163574, -0.892090, 0.421875);
 glVertex3f(-0.203010, 0.531894, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.110840, -0.903809, -0.414062);
 glVertex3f(-0.150889, 0.510572, -0.024876);
 glNormal3f(0.007812, -0.900391, -0.435547);
 glVertex3f(-0.107060, 0.517679, -0.024876);
 glNormal3f(0.003418, -0.896484, 0.443359);
 glVertex3f(-0.107060, 0.517679, 0.023691);
 glNormal3f(-0.115234, -0.895996, 0.429199);
 glVertex3f(-0.150889, 0.510572, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.007812, -0.900391, -0.435547);
 glVertex3f(-0.107060, 0.517679, -0.024876);
 glNormal3f(-0.274902, -0.867676, -0.415039);
 glVertex3f(-0.060862, 0.510572, -0.024876);
 glNormal3f(-0.277344, -0.865234, 0.418457);
 glVertex3f(-0.060862, 0.510572, 0.023691);
 glNormal3f(0.003418, -0.896484, 0.443359);
 glVertex3f(-0.107060, 0.517679, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.274902, -0.867676, -0.415039);
 glVertex3f(-0.060862, 0.510572, -0.024876);
 glNormal3f(-0.678711, -0.660645, -0.321777);
 glVertex3f(-0.037171, 0.499911, -0.024876);
 glNormal3f(-0.678223, -0.658691, 0.326172);
 glVertex3f(-0.037171, 0.499911, 0.023691);
 glNormal3f(-0.277344, -0.865234, 0.418457);
 glVertex3f(-0.060862, 0.510572, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.678711, -0.660645, -0.321777);
 glVertex3f(-0.037171, 0.499911, -0.024876);
 glNormal3f(-0.939941, -0.181152, -0.291016);
 glVertex3f(-0.027694, 0.479773, -0.024876);
 glNormal3f(-0.938965, -0.178711, 0.294922);
 glVertex3f(-0.027694, 0.479773, 0.023691);
 glNormal3f(-0.678223, -0.658691, 0.326172);
 glVertex3f(-0.037171, 0.499911, 0.023691);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.939941, -0.181152, -0.291016);
 glVertex3f(-0.027694, 0.479773, -0.024876);
 glNormal3f(-0.882812, -0.370117, -0.291016);
 glVertex3f(-0.038355, 0.383824, -0.024876);
 glNormal3f(-0.882812, -0.370117, 0.290527);
 glVertex3f(-0.038355, 0.383824, 0.023691);
 glNormal3f(-0.938965, -0.178711, 0.294922);
 glVertex3f(-0.027694, 0.479773, 0.023691);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.833496, -0.552734, 0.000000);
 glVertex3f(0.016134, 0.376716, 0.004738);
 glNormal3f(0.736816, -0.576660, 0.353027);
 glVertex3f(0.016134, 0.376716, 0.023691);
 glNormal3f(0.256348, -0.511230, 0.820312);
 glVertex3f(0.001920, 0.377901, 0.035537);
 glNormal3f(-0.437012, -0.438477, 0.785156);
 glVertex3f(-0.028879, 0.382639, 0.035537);
 glNormal3f(-0.882812, -0.370117, 0.290527);
 glVertex3f(-0.038355, 0.383824, 0.023691);
 glNormal3f(-0.882812, -0.370117, -0.291016);
 glVertex3f(-0.038355, 0.383824, -0.024876);
 glNormal3f(-0.437012, -0.438477, -0.785645);
 glVertex3f(-0.028879, 0.382639, -0.036721);
 glNormal3f(0.256348, -0.511230, -0.820801);
 glVertex3f(0.001920, 0.377901, -0.036721);
 glNormal3f(0.736816, -0.576660, -0.353516);
 glVertex3f(0.016134, 0.376716, -0.024876);
 glNormal3f(0.833496, -0.552734, 0.000000);
 glVertex3f(0.016134, 0.376716, -0.005923);
 glNormal3f(0.833496, -0.552246, 0.000000);
 glVertex3f(0.016134, 0.376716, 0.000000);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.833496, -0.552734, 0.000000);
 glVertex3f(0.016134, 0.376716, 0.004738);
 glNormal3f(0.833496, -0.552246, 0.000000);
 glVertex3f(0.016134, 0.376716, 0.000000);
 glNormal3f(0.774414, -0.632324, 0.000000);
 glVertex3f(0.019688, 0.406330, 0.000000);
 glNormal3f(0.828613, -0.427734, 0.359863);
 glVertex3f(0.019688, 0.406330, 0.004738);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.600586, 0.336914, -0.724609);
 glVertex3f(0.027980, 0.527156, -0.005923);
 glNormal3f(0.600586, 0.336914, 0.724121);
 glVertex3f(0.027980, 0.527156, 0.004738);
 glNormal3f(0.701660, 0.025879, 0.711426);
 glVertex3f(0.036272, 0.485696, 0.004738);
 glNormal3f(0.701660, 0.025879, -0.711914);
 glVertex3f(0.036272, 0.485696, -0.005923);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.437012, -0.438477, 0.785156);
 glVertex3f(-0.028879, 0.382639, 0.035537);
 glNormal3f(0.256348, -0.511230, 0.820312);
 glVertex3f(0.001920, 0.377901, 0.035537);
 glNormal3f(0.342285, 0.006348, 0.939453);
 glVertex3f(0.016134, 0.475035, 0.035537);
 glNormal3f(-0.447754, -0.098633, 0.888672);
 glVertex3f(-0.018218, 0.479773, 0.035537);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.589355, 0.569824, -0.572266);
 glVertex3f(0.396497, 0.281685, 0.034283);
 glNormal3f(0.814941, 0.406738, -0.412598);
 glVertex3f(0.380181, 0.281685, 0.033920);
 glNormal3f(0.344727, 0.894043, 0.284668);
 glVertex3f(0.380181, 0.281685, 0.047698);
 glNormal3f(0.539551, 0.763184, 0.354492);
 glVertex3f(0.396497, 0.281685, 0.055312);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.231445, 0.451172, 0.861328);
 glVertex3f(0.371117, 0.281685, 0.066551);
 glNormal3f(0.048340, 0.447266, 0.892578);
 glVertex3f(0.351176, 0.281685, 0.068727);
 glNormal3f(0.048340, -0.447754, 0.892578);
 glVertex3f(0.351176, 0.267182, 0.068727);
 glNormal3f(0.231445, -0.451660, 0.861328);
 glVertex3f(0.371117, 0.267182, 0.066551);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.539551, 0.763184, 0.354492);
 glVertex3f(0.396497, 0.281685, 0.055312);
 glNormal3f(0.231445, 0.451172, 0.861328);
 glVertex3f(0.371117, 0.281685, 0.066551);
 glNormal3f(0.231445, -0.451660, 0.861328);
 glVertex3f(0.371117, 0.267182, 0.066551);
 glNormal3f(0.715820, -0.516113, 0.470215);
 glVertex3f(0.396497, 0.267182, 0.055312);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.589355, 0.569824, -0.572266);
 glVertex3f(0.396497, 0.281685, 0.034283);
 glNormal3f(0.539551, 0.763184, 0.354492);
 glVertex3f(0.396497, 0.281685, 0.055312);
 glNormal3f(0.715820, -0.516113, 0.470215);
 glVertex3f(0.396497, 0.267182, 0.055312);
 glNormal3f(0.584473, -0.580078, -0.567383);
 glVertex3f(0.396497, 0.267182, 0.034283);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.814941, 0.406738, -0.412598);
 glVertex3f(0.380181, 0.281685, 0.033920);
 glNormal3f(0.589355, 0.569824, -0.572266);
 glVertex3f(0.396497, 0.281685, 0.034283);
 glNormal3f(0.584473, -0.580078, -0.567383);
 glVertex3f(0.396497, 0.267182, 0.034283);
 glNormal3f(0.578125, -0.566895, -0.586914);
 glVertex3f(0.380181, 0.267182, 0.033920);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.814453, -0.403809, -0.416992);
 glVertex3f(0.380181, 0.281685, 0.023768);
 glNormal3f(0.814941, 0.406738, -0.412598);
 glVertex3f(0.380181, 0.281685, 0.033920);
 glNormal3f(0.578125, -0.566895, -0.586914);
 glVertex3f(0.380181, 0.267182, 0.033920);
 glNormal3f(0.569824, -0.570801, -0.591309);
 glVertex3f(0.380181, 0.267182, 0.023768);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.814453, -0.403809, -0.416992);
 glVertex3f(0.380181, 0.281685, 0.023768);
 glNormal3f(0.685547, -0.526855, -0.502441);
 glVertex3f(0.380181, 0.281685, 0.013616);
 glNormal3f(0.681641, 0.533691, -0.499512);
 glVertex3f(0.380181, 0.295825, 0.013616);
 glNormal3f(0.486816, 0.775391, 0.401855);
 glVertex3f(0.380181, 0.295825, 0.037546);
 glNormal3f(0.344727, 0.894043, 0.284668);
 glVertex3f(0.380181, 0.281685, 0.047698);
 glNormal3f(0.814941, 0.406738, -0.412598);
 glVertex3f(0.380181, 0.281685, 0.033920);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.502930, 0.464844, -0.728516);
 glVertex3f(0.364953, 0.295825, 0.008903);
 glNormal3f(0.681641, 0.533691, -0.499512);
 glVertex3f(0.380181, 0.295825, 0.013616);
 glNormal3f(0.685547, -0.526855, -0.502441);
 glVertex3f(0.380181, 0.281685, 0.013616);
 glNormal3f(0.391602, -0.724609, -0.567383);
 glVertex3f(0.364953, 0.281685, 0.008903);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.836426, 0.466309, -0.287109);
 glVertex3f(0.361327, 0.295825, 0.004190);
 glNormal3f(0.502930, 0.464844, -0.728516);
 glVertex3f(0.364953, 0.295825, 0.008903);
 glNormal3f(0.391602, -0.724609, -0.567383);
 glVertex3f(0.364953, 0.281685, 0.008903);
 glNormal3f(0.650391, -0.726074, -0.223145);
 glVertex3f(0.361327, 0.281685, 0.004190);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.772461, 0.489746, -0.403320);
 glVertex3f(0.360965, 0.295825, -0.070137);
 glNormal3f(0.836426, 0.466309, -0.287109);
 glVertex3f(0.361327, 0.295825, 0.004190);
 glNormal3f(0.650391, -0.726074, -0.223145);
 glVertex3f(0.361327, 0.281685, 0.004190);
 glNormal3f(0.772461, -0.490234, -0.403320);
 glVertex3f(0.360965, 0.281685, -0.070137);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.378418, 0.452637, -0.807129);
 glVertex3f(0.354801, 0.295825, -0.074488);
 glNormal3f(0.772461, 0.489746, -0.403320);
 glVertex3f(0.360965, 0.295825, -0.070137);
 glNormal3f(0.772461, -0.490234, -0.403320);
 glVertex3f(0.360965, 0.281685, -0.070137);
 glNormal3f(0.378418, -0.453125, -0.807129);
 glVertex3f(0.354801, 0.281685, -0.074488);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.116699, 0.450195, -0.885254);
 glVertex3f(0.345374, 0.295825, -0.077026);
 glNormal3f(0.378418, 0.452637, -0.807129);
 glVertex3f(0.354801, 0.295825, -0.074488);
 glNormal3f(0.378418, -0.453125, -0.807129);
 glVertex3f(0.354801, 0.281685, -0.074488);
 glNormal3f(0.116699, -0.450684, -0.885254);
 glVertex3f(0.345374, 0.281685, -0.077026);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.685547, -0.526855, -0.502441);
 glVertex3f(0.380181, 0.281685, 0.013616);
 glNormal3f(0.814453, -0.403809, -0.416992);
 glVertex3f(0.380181, 0.281685, 0.023768);
 glNormal3f(0.000000, -0.980957, -0.196289);
 glVertex3f(0.339573, 0.281685, 0.023768);
 glNormal3f(0.391602, -0.724609, -0.567383);
 glVertex3f(0.364953, 0.281685, 0.008903);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(0.391602, -0.724609, -0.567383);
 glVertex3f(0.364953, 0.281685, 0.008903);
 glNormal3f(0.000000, -0.980957, -0.196289);
 glVertex3f(0.339573, 0.281685, 0.023768);
 glNormal3f(0.650391, -0.726074, -0.223145);
 glVertex3f(0.361327, 0.281685, 0.004190);
glEnd();
glBegin(GL_TRIANGLES);
 glNormal3f(-0.390137, -0.724609, -0.568359);
 glVertex3f(0.314194, 0.281685, 0.008903);
 glNormal3f(-0.650879, -0.726074, -0.223145);
 glVertex3f(0.317819, 0.281685, 0.004190);
 glNormal3f(0.000000, -0.980957, -0.196289);
 glVertex3f(0.339573, 0.281685, 0.023768);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.816895, -0.408691, -0.408691);
 glVertex3f(0.298241, 0.281685, 0.023768);
 glNormal3f(-0.679688, -0.529785, -0.507812);
 glVertex3f(0.298241, 0.281685, 0.013616);
 glNormal3f(-0.390137, -0.724609, -0.568359);
 glVertex3f(0.314194, 0.281685, 0.008903);
 glNormal3f(0.000000, -0.980957, -0.196289);
 glVertex3f(0.339573, 0.281685, 0.023768);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.814453, -0.403809, -0.416992);
 glVertex3f(0.380181, 0.281685, 0.023768);
 glNormal3f(0.569824, -0.570801, -0.591309);
 glVertex3f(0.380181, 0.267182, 0.023768);
 glNormal3f(-0.577637, -0.577637, -0.577637);
 glVertex3f(0.298241, 0.267182, 0.023768);
 glNormal3f(-0.816895, -0.408691, -0.408691);
 glVertex3f(0.298241, 0.281685, 0.023768);
 glNormal3f(0.000000, -0.980957, -0.196289);
 glVertex3f(0.339573, 0.281685, 0.023768);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.113281, 0.449707, -0.886230);
 glVertex3f(0.334135, 0.295825, -0.077026);
 glNormal3f(0.116699, 0.450195, -0.885254);
 glVertex3f(0.345374, 0.295825, -0.077026);
 glNormal3f(0.116699, -0.450684, -0.885254);
 glVertex3f(0.345374, 0.281685, -0.077026);
 glNormal3f(-0.113281, -0.450195, -0.886230);
 glVertex3f(0.334135, 0.281685, -0.077026);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.375000, 0.452637, -0.809082);
 glVertex3f(0.324345, 0.295825, -0.074488);
 glNormal3f(-0.113281, 0.449707, -0.886230);
 glVertex3f(0.334135, 0.295825, -0.077026);
 glNormal3f(-0.113281, -0.450195, -0.886230);
 glVertex3f(0.334135, 0.281685, -0.077026);
 glNormal3f(-0.375000, -0.453125, -0.809082);
 glVertex3f(0.324345, 0.281685, -0.074488);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.772949, 0.489746, -0.403320);
 glVertex3f(0.318182, 0.295825, -0.070137);
 glNormal3f(-0.375000, 0.452637, -0.809082);
 glVertex3f(0.324345, 0.295825, -0.074488);
 glNormal3f(-0.375000, -0.453125, -0.809082);
 glVertex3f(0.324345, 0.281685, -0.074488);
 glNormal3f(-0.772949, -0.490234, -0.403320);
 glVertex3f(0.318182, 0.281685, -0.070137);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.836914, 0.466309, -0.287109);
 glVertex3f(0.317819, 0.295825, 0.004190);
 glNormal3f(-0.772949, 0.489746, -0.403320);
 glVertex3f(0.318182, 0.295825, -0.070137);
 glNormal3f(-0.772949, -0.490234, -0.403320);
 glVertex3f(0.318182, 0.281685, -0.070137);
 glNormal3f(-0.650879, -0.726074, -0.223145);
 glVertex3f(0.317819, 0.281685, 0.004190);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.500977, 0.464844, -0.729980);
 glVertex3f(0.314194, 0.295825, 0.008903);
 glNormal3f(-0.836914, 0.466309, -0.287109);
 glVertex3f(0.317819, 0.295825, 0.004190);
 glNormal3f(-0.650879, -0.726074, -0.223145);
 glVertex3f(0.317819, 0.281685, 0.004190);
 glNormal3f(-0.390137, -0.724609, -0.568359);
 glVertex3f(0.314194, 0.281685, 0.008903);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.679688, 0.529297, -0.507812);
 glVertex3f(0.298241, 0.295825, 0.013616);
 glNormal3f(-0.500977, 0.464844, -0.729980);
 glVertex3f(0.314194, 0.295825, 0.008903);
 glNormal3f(-0.390137, -0.724609, -0.568359);
 glVertex3f(0.314194, 0.281685, 0.008903);
 glNormal3f(-0.679688, -0.529785, -0.507812);
 glVertex3f(0.298241, 0.281685, 0.013616);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.346680, 0.894531, 0.281250);
 glVertex3f(0.298241, 0.281685, 0.047698);
 glNormal3f(-0.490234, 0.775391, 0.397949);
 glVertex3f(0.298241, 0.295825, 0.037546);
 glNormal3f(-0.679688, 0.529297, -0.507812);
 glVertex3f(0.298241, 0.295825, 0.013616);
 glNormal3f(-0.679688, -0.529785, -0.507812);
 glVertex3f(0.298241, 0.281685, 0.013616);
 glNormal3f(-0.816895, -0.408691, -0.408691);
 glVertex3f(0.298241, 0.281685, 0.023768);
 glNormal3f(-0.819824, 0.404785, -0.405273);
 glVertex3f(0.298241, 0.281685, 0.033920);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.344727, 0.894043, 0.284668);
 glVertex3f(0.380181, 0.281685, 0.047698);
 glNormal3f(0.486816, 0.775391, 0.401855);
 glVertex3f(0.380181, 0.295825, 0.037546);
 glNormal3f(-0.490234, 0.775391, 0.397949);
 glVertex3f(0.298241, 0.295825, 0.037546);
 glNormal3f(-0.346680, 0.894531, 0.281250);
 glVertex3f(0.298241, 0.281685, 0.047698);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.577637, -0.577637, -0.577637);
 glVertex3f(0.298241, 0.267182, 0.023768);
 glNormal3f(0.569824, -0.570801, -0.591309);
 glVertex3f(0.380181, 0.267182, 0.023768);
 glNormal3f(0.578125, -0.566895, -0.586914);
 glVertex3f(0.380181, 0.267182, 0.033920);
 glNormal3f(0.584473, -0.580078, -0.567383);
 glVertex3f(0.396497, 0.267182, 0.034283);
 glNormal3f(0.715820, -0.516113, 0.470215);
 glVertex3f(0.396497, 0.267182, 0.055312);
 glNormal3f(0.231445, -0.451660, 0.861328);
 glVertex3f(0.371117, 0.267182, 0.066551);
 glNormal3f(0.048340, -0.447754, 0.892578);
 glVertex3f(0.351176, 0.267182, 0.068727);
 glNormal3f(-0.048828, -0.447754, 0.892578);
 glVertex3f(0.327971, 0.267182, 0.068727);
 glNormal3f(-0.229980, -0.451660, 0.862305);
 glVertex3f(0.308030, 0.267182, 0.066551);
 glNormal3f(-0.715332, -0.511230, 0.476562);
 glVertex3f(0.282288, 0.267182, 0.055312);
 glNormal3f(-0.589355, -0.576660, -0.566406);
 glVertex3f(0.281925, 0.267182, 0.034283);
 glNormal3f(-0.585938, -0.573242, -0.573242);
 glVertex3f(0.298241, 0.267182, 0.033920);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.229980, 0.451172, 0.862305);
 glVertex3f(0.308030, 0.281685, 0.066551);
 glNormal3f(-0.048828, 0.447266, 0.892578);
 glVertex3f(0.327971, 0.281685, 0.068727);
 glNormal3f(0.048340, 0.447266, 0.892578);
 glVertex3f(0.351176, 0.281685, 0.068727);
 glNormal3f(0.231445, 0.451172, 0.861328);
 glVertex3f(0.371117, 0.281685, 0.066551);
 glNormal3f(0.539551, 0.763184, 0.354492);
 glVertex3f(0.396497, 0.281685, 0.055312);
 glNormal3f(0.344727, 0.894043, 0.284668);
 glVertex3f(0.380181, 0.281685, 0.047698);
 glNormal3f(-0.346680, 0.894531, 0.281250);
 glVertex3f(0.298241, 0.281685, 0.047698);
 glNormal3f(-0.535645, 0.765137, 0.356934);
 glVertex3f(0.282288, 0.281685, 0.055312);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.772461, 0.489746, -0.403320);
 glVertex3f(0.360965, 0.295825, -0.070137);
 glNormal3f(0.378418, 0.452637, -0.807129);
 glVertex3f(0.354801, 0.295825, -0.074488);
 glNormal3f(0.116699, 0.450195, -0.885254);
 glVertex3f(0.345374, 0.295825, -0.077026);
 glNormal3f(-0.113281, 0.449707, -0.886230);
 glVertex3f(0.334135, 0.295825, -0.077026);
 glNormal3f(-0.375000, 0.452637, -0.809082);
 glVertex3f(0.324345, 0.295825, -0.074488);
 glNormal3f(-0.772949, 0.489746, -0.403320);
 glVertex3f(0.318182, 0.295825, -0.070137);
 glNormal3f(-0.836914, 0.466309, -0.287109);
 glVertex3f(0.317819, 0.295825, 0.004190);
 glNormal3f(-0.500977, 0.464844, -0.729980);
 glVertex3f(0.314194, 0.295825, 0.008903);
 glNormal3f(-0.679688, 0.529297, -0.507812);
 glVertex3f(0.298241, 0.295825, 0.013616);
 glNormal3f(-0.490234, 0.775391, 0.397949);
 glVertex3f(0.298241, 0.295825, 0.037546);
 glNormal3f(0.486816, 0.775391, 0.401855);
 glVertex3f(0.380181, 0.295825, 0.037546);
 glNormal3f(0.681641, 0.533691, -0.499512);
 glVertex3f(0.380181, 0.295825, 0.013616);
 glNormal3f(0.502930, 0.464844, -0.728516);
 glVertex3f(0.364953, 0.295825, 0.008903);
 glNormal3f(0.836426, 0.466309, -0.287109);
 glVertex3f(0.361327, 0.295825, 0.004190);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.819824, 0.404785, -0.405273);
 glVertex3f(0.298241, 0.281685, 0.033920);
 glNormal3f(-0.816895, -0.408691, -0.408691);
 glVertex3f(0.298241, 0.281685, 0.023768);
 glNormal3f(-0.577637, -0.577637, -0.577637);
 glVertex3f(0.298241, 0.267182, 0.023768);
 glNormal3f(-0.585938, -0.573242, -0.573242);
 glVertex3f(0.298241, 0.267182, 0.033920);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.589355, 0.576172, -0.566406);
 glVertex3f(0.281925, 0.281685, 0.034283);
 glNormal3f(-0.819824, 0.404785, -0.405273);
 glVertex3f(0.298241, 0.281685, 0.033920);
 glNormal3f(-0.585938, -0.573242, -0.573242);
 glVertex3f(0.298241, 0.267182, 0.033920);
 glNormal3f(-0.589355, -0.576660, -0.566406);
 glVertex3f(0.281925, 0.267182, 0.034283);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.535645, 0.765137, 0.356934);
 glVertex3f(0.282288, 0.281685, 0.055312);
 glNormal3f(-0.589355, 0.576172, -0.566406);
 glVertex3f(0.281925, 0.281685, 0.034283);
 glNormal3f(-0.589355, -0.576660, -0.566406);
 glVertex3f(0.281925, 0.267182, 0.034283);
 glNormal3f(-0.715332, -0.511230, 0.476562);
 glVertex3f(0.282288, 0.267182, 0.055312);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.229980, 0.451172, 0.862305);
 glVertex3f(0.308030, 0.281685, 0.066551);
 glNormal3f(-0.535645, 0.765137, 0.356934);
 glVertex3f(0.282288, 0.281685, 0.055312);
 glNormal3f(-0.715332, -0.511230, 0.476562);
 glVertex3f(0.282288, 0.267182, 0.055312);
 glNormal3f(-0.229980, -0.451660, 0.862305);
 glVertex3f(0.308030, 0.267182, 0.066551);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.048828, 0.447266, 0.892578);
 glVertex3f(0.327971, 0.281685, 0.068727);
 glNormal3f(-0.229980, 0.451172, 0.862305);
 glVertex3f(0.308030, 0.281685, 0.066551);
 glNormal3f(-0.229980, -0.451660, 0.862305);
 glVertex3f(0.308030, 0.267182, 0.066551);
 glNormal3f(-0.048828, -0.447754, 0.892578);
 glVertex3f(0.327971, 0.267182, 0.068727);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.048340, 0.447266, 0.892578);
 glVertex3f(0.351176, 0.281685, 0.068727);
 glNormal3f(-0.048828, 0.447266, 0.892578);
 glVertex3f(0.327971, 0.281685, 0.068727);
 glNormal3f(-0.048828, -0.447754, 0.892578);
 glVertex3f(0.327971, 0.267182, 0.068727);
 glNormal3f(0.048340, -0.447754, 0.892578);
 glVertex3f(0.351176, 0.267182, 0.068727);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.378418, -0.453125, -0.807129);
 glVertex3f(0.354801, 0.281685, -0.074488);
 glNormal3f(0.772461, -0.490234, -0.403320);
 glVertex3f(0.360965, 0.281685, -0.070137);
 glNormal3f(0.650391, -0.726074, -0.223145);
 glVertex3f(0.361327, 0.281685, 0.004190);
 glNormal3f(0.000000, -0.980957, -0.196289);
 glVertex3f(0.339573, 0.281685, 0.023768);
 glNormal3f(-0.650879, -0.726074, -0.223145);
 glVertex3f(0.317819, 0.281685, 0.004190);
 glNormal3f(-0.772949, -0.490234, -0.403320);
 glVertex3f(0.318182, 0.281685, -0.070137);
 glNormal3f(-0.375000, -0.453125, -0.809082);
 glVertex3f(0.324345, 0.281685, -0.074488);
 glNormal3f(-0.113281, -0.450195, -0.886230);
 glVertex3f(0.334135, 0.281685, -0.077026);
 glNormal3f(0.116699, -0.450684, -0.885254);
 glVertex3f(0.345374, 0.281685, -0.077026);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.819824, 0.404785, -0.405273);
 glVertex3f(0.298241, 0.281685, 0.033920);
 glNormal3f(-0.589355, 0.576172, -0.566406);
 glVertex3f(0.281925, 0.281685, 0.034283);
 glNormal3f(-0.535645, 0.765137, 0.356934);
 glVertex3f(0.282288, 0.281685, 0.055312);
 glNormal3f(-0.346680, 0.894531, 0.281250);
 glVertex3f(0.298241, 0.281685, 0.047698);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.552246, 0.833008, 0.002441);
 glVertex3f(0.432028, 0.300176, -0.046570);
 glNormal3f(0.280762, 0.821289, 0.496094);
 glVertex3f(0.423689, 0.300176, -0.032067);
 glNormal3f(0.476074, 0.324219, 0.817383);
 glVertex3f(0.426952, 0.294012, -0.028442);
 glNormal3f(0.939941, 0.339844, 0.003906);
 glVertex3f(0.436742, 0.294012, -0.046570);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.282227, 0.822266, -0.494141);
 glVertex3f(0.423689, 0.300176, -0.061435);
 glNormal3f(0.552246, 0.833008, 0.002441);
 glVertex3f(0.432028, 0.300176, -0.046570);
 glNormal3f(0.939941, 0.339844, 0.003906);
 glVertex3f(0.436742, 0.294012, -0.046570);
 glNormal3f(0.479492, 0.324707, -0.815430);
 glVertex3f(0.426952, 0.294012, -0.065061);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.328613, 0.874512, -0.356934);
 glVertex3f(0.394321, 0.300176, -0.061435);
 glNormal3f(0.282227, 0.822266, -0.494141);
 glVertex3f(0.423689, 0.300176, -0.061435);
 glNormal3f(0.479492, 0.324707, -0.815430);
 glVertex3f(0.426952, 0.294012, -0.065061);
 glNormal3f(-0.637695, 0.395508, -0.661621);
 glVertex3f(0.389608, 0.294012, -0.065061);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.328613, 0.874512, 0.356445);
 glVertex3f(0.394321, 0.300176, -0.032067);
 glNormal3f(-0.328613, 0.874512, -0.356934);
 glVertex3f(0.394321, 0.300176, -0.061435);
 glNormal3f(-0.637695, 0.395508, -0.661621);
 glVertex3f(0.389608, 0.294012, -0.065061);
 glNormal3f(-0.637695, 0.395508, 0.661133);
 glVertex3f(0.389608, 0.294012, -0.028442);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.280762, 0.821289, 0.496094);
 glVertex3f(0.423689, 0.300176, -0.032067);
 glNormal3f(-0.328613, 0.874512, 0.356445);
 glVertex3f(0.394321, 0.300176, -0.032067);
 glNormal3f(-0.637695, 0.395508, 0.661133);
 glVertex3f(0.389608, 0.294012, -0.028442);
 glNormal3f(0.476074, 0.324219, 0.817383);
 glVertex3f(0.426952, 0.294012, -0.028442);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.637695, 0.395508, -0.661621);
 glVertex3f(0.389608, 0.294012, -0.065061);
 glNormal3f(0.479492, 0.324707, -0.815430);
 glVertex3f(0.426952, 0.294012, -0.065061);
 glNormal3f(0.335449, 0.759277, -0.557617);
 glVertex3f(0.426952, 0.280234, -0.065061);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(0.389608, 0.280234, -0.065061);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.637695, 0.395508, 0.661133);
 glVertex3f(0.389608, 0.294012, -0.028442);
 glNormal3f(-0.637695, 0.395508, -0.661621);
 glVertex3f(0.389608, 0.294012, -0.065061);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(0.389608, 0.280234, -0.065061);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(0.389608, 0.280234, -0.028442);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.476074, 0.324219, 0.817383);
 glVertex3f(0.426952, 0.294012, -0.028442);
 glNormal3f(-0.637695, 0.395508, 0.661133);
 glVertex3f(0.389608, 0.294012, -0.028442);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(0.389608, 0.280234, -0.028442);
 glNormal3f(0.333496, 0.758301, 0.559082);
 glVertex3f(0.426952, 0.280234, -0.028442);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.939941, 0.339844, 0.003906);
 glVertex3f(0.436742, 0.294012, -0.046570);
 glNormal3f(0.476074, 0.324219, 0.817383);
 glVertex3f(0.426952, 0.294012, -0.028442);
 glNormal3f(0.333496, 0.758301, 0.559082);
 glVertex3f(0.426952, 0.280234, -0.028442);
 glNormal3f(0.661133, 0.750000, 0.002441);
 glVertex3f(0.436742, 0.280234, -0.046570);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.479492, 0.324707, -0.815430);
 glVertex3f(0.426952, 0.294012, -0.065061);
 glNormal3f(0.939941, 0.339844, 0.003906);
 glVertex3f(0.436742, 0.294012, -0.046570);
 glNormal3f(0.661133, 0.750000, 0.002441);
 glVertex3f(0.436742, 0.280234, -0.046570);
 glNormal3f(0.335449, 0.759277, -0.557617);
 glVertex3f(0.426952, 0.280234, -0.065061);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.330566, 0.756836, -0.563477);
 glVertex3f(0.449794, 0.280234, -0.093341);
 glNormal3f(0.335449, 0.759277, -0.557617);
 glVertex3f(0.426952, 0.280234, -0.065061);
 glNormal3f(0.661133, 0.750000, 0.002441);
 glVertex3f(0.436742, 0.280234, -0.046570);
 glNormal3f(0.672852, 0.718262, -0.175293);
 glVertex3f(0.467197, 0.280234, -0.062160);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.328613, 0.874512, -0.356934);
 glVertex3f(0.394321, 0.300176, -0.061435);
 glNormal3f(-0.328613, 0.874512, 0.356445);
 glVertex3f(0.394321, 0.300176, -0.032067);
 glNormal3f(0.280762, 0.821289, 0.496094);
 glVertex3f(0.423689, 0.300176, -0.032067);
 glNormal3f(0.552246, 0.833008, 0.002441);
 glVertex3f(0.432028, 0.300176, -0.046570);
 glNormal3f(0.282227, 0.822266, -0.494141);
 glVertex3f(0.423689, 0.300176, -0.061435);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(0.389608, 0.280234, -0.065061);
 glNormal3f(0.335449, 0.759277, -0.557617);
 glVertex3f(0.426952, 0.280234, -0.065061);
 glNormal3f(0.330566, 0.756836, -0.563477);
 glVertex3f(0.449794, 0.280234, -0.093341);
 glNormal3f(-0.328613, 0.756348, -0.565918);
 glVertex3f(0.314556, 0.280234, -0.093341);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(0.389608, 0.280234, -0.028442);
 glNormal3f(-0.408691, 0.816406, -0.408691);
 glVertex3f(0.389608, 0.280234, -0.065061);
 glNormal3f(-0.328613, 0.756348, -0.565918);
 glVertex3f(0.314556, 0.280234, -0.093341);
 glNormal3f(-0.858887, 0.458984, -0.227539);
 glVertex3f(0.296790, 0.280234, -0.062160);
 glNormal3f(-0.858887, 0.458984, 0.227051);
 glVertex3f(0.296790, 0.280234, -0.031342);
 glNormal3f(-0.329590, 0.755859, 0.564941);
 glVertex3f(0.314556, 0.280234, -0.000161);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.333496, 0.758301, 0.559082);
 glVertex3f(0.426952, 0.280234, -0.028442);
 glNormal3f(-0.408691, 0.816406, 0.408203);
 glVertex3f(0.389608, 0.280234, -0.028442);
 glNormal3f(-0.329590, 0.755859, 0.564941);
 glVertex3f(0.314556, 0.280234, -0.000161);
 glNormal3f(0.329590, 0.757324, 0.562988);
 glVertex3f(0.449794, 0.280234, 0.000201);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.333496, 0.758301, 0.559082);
 glVertex3f(0.426952, 0.280234, -0.028442);
 glNormal3f(0.329590, 0.757324, 0.562988);
 glVertex3f(0.449794, 0.280234, 0.000201);
 glNormal3f(0.859375, 0.458984, 0.223633);
 glVertex3f(0.467197, 0.280234, -0.030980);
 glNormal3f(0.672852, 0.718262, -0.175293);
 glVertex3f(0.467197, 0.280234, -0.062160);
 glNormal3f(0.661133, 0.750000, 0.002441);
 glVertex3f(0.436742, 0.280234, -0.046570);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.437500, -0.501953, -0.746094);
 glVertex3f(0.449794, 0.267544, -0.093341);
 glNormal3f(0.330566, 0.756836, -0.563477);
 glVertex3f(0.449794, 0.280234, -0.093341);
 glNormal3f(0.672852, 0.718262, -0.175293);
 glVertex3f(0.467197, 0.280234, -0.062160);
 glNormal3f(0.859375, -0.458984, -0.224121);
 glVertex3f(0.467197, 0.267544, -0.062160);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.329590, 0.757324, 0.562988);
 glVertex3f(0.449794, 0.280234, 0.000201);
 glNormal3f(0.436523, -0.501953, 0.746094);
 glVertex3f(0.449794, 0.267544, 0.000201);
 glNormal3f(0.859375, -0.458984, 0.223633);
 glVertex3f(0.467197, 0.267544, -0.030980);
 glNormal3f(0.859375, 0.458984, 0.223633);
 glVertex3f(0.467197, 0.280234, -0.030980);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.858887, -0.459473, 0.227051);
 glVertex3f(0.296790, 0.267544, -0.031342);
 glNormal3f(-0.858887, 0.458984, 0.227051);
 glVertex3f(0.296790, 0.280234, -0.031342);
 glNormal3f(-0.858887, 0.458984, -0.227539);
 glVertex3f(0.296790, 0.280234, -0.062160);
 glNormal3f(-0.858887, -0.459473, -0.227539);
 glVertex3f(0.296790, 0.267544, -0.062160);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.328613, 0.756348, -0.565918);
 glVertex3f(0.314556, 0.280234, -0.093341);
 glNormal3f(-0.435059, -0.500977, -0.748535);
 glVertex3f(0.314556, 0.267544, -0.093341);
 glNormal3f(-0.858887, -0.459473, -0.227539);
 glVertex3f(0.296790, 0.267544, -0.062160);
 glNormal3f(-0.858887, 0.458984, -0.227539);
 glVertex3f(0.296790, 0.280234, -0.062160);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.859375, -0.458984, -0.224121);
 glVertex3f(0.467197, 0.267544, -0.062160);
 glNormal3f(0.672852, 0.718262, -0.175293);
 glVertex3f(0.467197, 0.280234, -0.062160);
 glNormal3f(0.859375, 0.458984, 0.223633);
 glVertex3f(0.467197, 0.280234, -0.030980);
 glNormal3f(0.859375, -0.458984, 0.223633);
 glVertex3f(0.467197, 0.267544, -0.030980);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.436035, -0.500488, 0.747559);
 glVertex3f(0.314556, 0.267544, -0.000161);
 glNormal3f(-0.329590, 0.755859, 0.564941);
 glVertex3f(0.314556, 0.280234, -0.000161);
 glNormal3f(-0.858887, 0.458984, 0.227051);
 glVertex3f(0.296790, 0.280234, -0.031342);
 glNormal3f(-0.858887, -0.459473, 0.227051);
 glVertex3f(0.296790, 0.267544, -0.031342);
glEnd();
glBegin(GL_POLYGON);
 glNormal3f(0.436523, -0.501953, 0.746094);
 glVertex3f(0.449794, 0.267544, 0.000201);
 glNormal3f(-0.436035, -0.500488, 0.747559);
 glVertex3f(0.314556, 0.267544, -0.000161);
 glNormal3f(-0.858887, -0.459473, 0.227051);
 glVertex3f(0.296790, 0.267544, -0.031342);
 glNormal3f(-0.858887, -0.459473, -0.227539);
 glVertex3f(0.296790, 0.267544, -0.062160);
 glNormal3f(-0.435059, -0.500977, -0.748535);
 glVertex3f(0.314556, 0.267544, -0.093341);
 glNormal3f(0.437500, -0.501953, -0.746094);
 glVertex3f(0.449794, 0.267544, -0.093341);
 glNormal3f(0.859375, -0.458984, -0.224121);
 glVertex3f(0.467197, 0.267544, -0.062160);
 glNormal3f(0.859375, -0.458984, 0.223633);
 glVertex3f(0.467197, 0.267544, -0.030980);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(0.436523, -0.501953, 0.746094);
 glVertex3f(0.449794, 0.267544, 0.000201);
 glNormal3f(0.329590, 0.757324, 0.562988);
 glVertex3f(0.449794, 0.280234, 0.000201);
 glNormal3f(-0.329590, 0.755859, 0.564941);
 glVertex3f(0.314556, 0.280234, -0.000161);
 glNormal3f(-0.436035, -0.500488, 0.747559);
 glVertex3f(0.314556, 0.267544, -0.000161);
glEnd();
glBegin(GL_QUADS);
 glNormal3f(-0.435059, -0.500977, -0.748535);
 glVertex3f(0.314556, 0.267544, -0.093341);
 glNormal3f(-0.328613, 0.756348, -0.565918);
 glVertex3f(0.314556, 0.280234, -0.093341);
 glNormal3f(0.330566, 0.756836, -0.563477);
 glVertex3f(0.449794, 0.280234, -0.093341);
 glNormal3f(0.437500, -0.501953, -0.746094);
 glVertex3f(0.449794, 0.267544, -0.093341);
glEnd();
}

static void
createCompressedGeometryBuffer()
{
	CGint geomColorQuantLevel = 16;
	CGint normalQuantLevel = 16;

	printf("Compressing object to pos = 16 bits, normal = 16 bits.\n");
	/* let's make a violin case! */
	cgBeginCompressedGeometryStream(geomColorQuantLevel,
              normalQuantLevel, geomColorQuantLevel, CG_QUANTIZE_STRICT);

cgGeomFrontFace(CG_CCW);
cgBegin(CG_QUADS);
 cgNormal3f(-0.812500, 0.438965, 0.383789);
 cgVertex3f(-1.299628, 0.521891, 0.019546);
 cgNormal3f(-0.780273, 0.438965, -0.446289);
 cgVertex3f(-1.298971, 0.521891, 0.013635);
 cgNormal3f(-0.646973, 0.687500, -0.330078);
 cgVertex3f(-1.298314, 0.507442, 0.013635);
 cgNormal3f(-0.662598, 0.701172, 0.263184);
 cgVertex3f(-1.298314, 0.507442, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.048340, 0.514160, 0.855957);
 cgVertex3f(-1.292403, 0.522548, 0.024144);
 cgNormal3f(-0.812500, 0.438965, 0.383789);
 cgVertex3f(-1.299628, 0.521891, 0.019546);
 cgNormal3f(-0.662598, 0.701172, 0.263184);
 cgVertex3f(-1.298314, 0.507442, 0.019546);
 cgNormal3f(-0.076172, 0.773926, 0.628418);
 cgVertex3f(-1.291746, 0.509412, 0.024144);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.716309, 0.564453, 0.409668);
 cgVertex3f(-1.285835, 0.522548, 0.019546);
 cgNormal3f(-0.048340, 0.514160, 0.855957);
 cgVertex3f(-1.292403, 0.522548, 0.024144);
 cgNormal3f(-0.076172, 0.773926, 0.628418);
 cgVertex3f(-1.291746, 0.509412, 0.024144);
 cgNormal3f(0.525879, 0.793945, 0.303223);
 cgVertex3f(-1.284521, 0.510069, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.696777, 0.569336, -0.436035);
 cgVertex3f(-1.285835, 0.522548, 0.013635);
 cgNormal3f(0.716309, 0.564453, 0.409668);
 cgVertex3f(-1.285835, 0.522548, 0.019546);
 cgNormal3f(0.525879, 0.793945, 0.303223);
 cgVertex3f(-1.284521, 0.510069, 0.019546);
 cgNormal3f(0.511719, 0.790527, -0.336426);
 cgVertex3f(-1.284521, 0.510069, 0.013635);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.056641, 0.502930, -0.862793);
 cgVertex3f(-1.292403, 0.522548, 0.009694);
 cgNormal3f(0.696777, 0.569336, -0.436035);
 cgVertex3f(-1.285835, 0.522548, 0.013635);
 cgNormal3f(0.511719, 0.790527, -0.336426);
 cgVertex3f(-1.284521, 0.510069, 0.013635);
 cgNormal3f(-0.087402, 0.754395, -0.650391);
 cgVertex3f(-1.291746, 0.509412, 0.009694);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.780273, 0.438965, -0.446289);
 cgVertex3f(-1.298971, 0.521891, 0.013635);
 cgNormal3f(-0.056641, 0.502930, -0.862793);
 cgVertex3f(-1.292403, 0.522548, 0.009694);
 cgNormal3f(-0.087402, 0.754395, -0.650391);
 cgVertex3f(-1.291746, 0.509412, 0.009694);
 cgNormal3f(-0.646973, 0.687500, -0.330078);
 cgVertex3f(-1.298314, 0.507442, 0.013635);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.401367, 0.864258, 0.302734);
 cgVertex3f(-1.306196, 0.507442, 0.005096);
 cgNormal3f(-0.646973, 0.687500, -0.330078);
 cgVertex3f(-1.298314, 0.507442, 0.013635);
 cgNormal3f(-0.087402, 0.754395, -0.650391);
 cgVertex3f(-1.291746, 0.509412, 0.009694);
 cgNormal3f(-0.096680, 0.887695, 0.449219);
 cgVertex3f(-1.291746, 0.509412, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.662598, 0.701172, 0.263184);
 cgVertex3f(-1.298314, 0.507442, 0.019546);
 cgNormal3f(-0.463867, 0.878418, 0.114258);
 cgVertex3f(-1.315391, 0.507442, 0.028085);
 cgNormal3f(-0.098145, 0.991211, -0.085938);
 cgVertex3f(-1.291746, 0.509412, 0.030055);
 cgNormal3f(-0.076172, 0.773926, 0.628418);
 cgVertex3f(-1.291746, 0.509412, 0.024144);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.655762, 0.723633, -0.214844);
 cgVertex3f(-1.267444, 0.511382, -0.015921);
 cgNormal3f(0.654297, 0.726562, -0.208984);
 cgVertex3f(-1.276640, 0.510069, -0.015921);
 cgNormal3f(0.226562, 0.929688, 0.289551);
 cgVertex3f(-1.276640, 0.510069, 0.005096);
 cgNormal3f(0.288574, 0.950195, 0.112793);
 cgVertex3f(-1.267444, 0.511382, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.662598, 0.701172, 0.263184);
 cgVertex3f(-1.298314, 0.507442, 0.019546);
 cgNormal3f(-0.646973, 0.687500, -0.330078);
 cgVertex3f(-1.298314, 0.507442, 0.013635);
 cgNormal3f(-0.401367, 0.864258, 0.302734);
 cgVertex3f(-1.306196, 0.507442, 0.005096);
 cgNormal3f(-0.463867, 0.878418, 0.114258);
 cgVertex3f(-1.315391, 0.507442, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.288574, 0.950195, 0.112793);
 cgVertex3f(-1.267444, 0.511382, 0.028741);
 cgNormal3f(0.525879, 0.793945, 0.303223);
 cgVertex3f(-1.284521, 0.510069, 0.019546);
 cgNormal3f(-0.076172, 0.773926, 0.628418);
 cgVertex3f(-1.291746, 0.509412, 0.024144);
 cgNormal3f(-0.098145, 0.991211, -0.085938);
 cgVertex3f(-1.291746, 0.509412, 0.030055);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.716309, 0.564453, 0.409668);
 cgVertex3f(-1.285835, 0.522548, 0.019546);
 cgNormal3f(0.696777, 0.569336, -0.436035);
 cgVertex3f(-1.285835, 0.522548, 0.013635);
 cgNormal3f(-0.056641, 0.502930, -0.862793);
 cgVertex3f(-1.292403, 0.522548, 0.009694);
 cgNormal3f(-0.780273, 0.438965, -0.446289);
 cgVertex3f(-1.298971, 0.521891, 0.013635);
 cgNormal3f(-0.812500, 0.438965, 0.383789);
 cgVertex3f(-1.299628, 0.521891, 0.019546);
 cgNormal3f(-0.048340, 0.514160, 0.855957);
 cgVertex3f(-1.292403, 0.522548, 0.024144);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.520996, 0.630859, 0.574219);
 cgVertex3f(-1.277296, 0.517294, 0.005096);
 cgNormal3f(0.226562, 0.929688, 0.289551);
 cgVertex3f(-1.276640, 0.510069, 0.005096);
 cgNormal3f(0.654297, 0.726562, -0.208984);
 cgVertex3f(-1.276640, 0.510069, -0.015921);
 cgNormal3f(0.641602, 0.753418, -0.140137);
 cgVertex3f(-1.277296, 0.517294, -0.029714);
 cgNormal3f(0.636719, 0.770996, -0.008789);
 cgVertex3f(-1.277296, 0.517294, -0.015921);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.379883, 0.434082, 0.816406);
 cgVertex3f(-1.306196, 0.502844, 0.051073);
 cgNormal3f(-0.133301, 0.455078, 0.879883);
 cgVertex3f(-1.296344, 0.503501, 0.053700);
 cgNormal3f(-0.043457, 0.728516, 0.683105);
 cgVertex3f(-1.291089, 0.503501, 0.053700);
 cgNormal3f(0.095215, 0.183105, 0.978027);
 cgVertex3f(-1.291089, 0.503501, 0.030055);
 cgNormal3f(-0.794434, 0.478027, 0.374512);
 cgVertex3f(-1.315391, 0.501530, 0.028085);
 cgNormal3f(-0.344238, 0.708984, 0.615234);
 cgVertex3f(-1.323273, 0.501530, 0.039250);
 cgNormal3f(-0.542969, 0.414062, 0.730469);
 cgVertex3f(-1.314734, 0.501530, 0.045818);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.198242, 0.474609, -0.857422);
 cgVertex3f(-1.281894, 0.499560, -0.074377);
 cgNormal3f(0.615723, 0.515625, -0.595703);
 cgVertex3f(-1.272042, 0.499560, -0.068465);
 cgNormal3f(0.699219, -0.402832, -0.590820);
 cgVertex3f(-1.271385, 0.491678, -0.068465);
 cgNormal3f(0.278809, -0.438477, -0.854492);
 cgVertex3f(-1.281237, 0.491678, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.035156, 0.441895, -0.896484);
 cgVertex3f(-1.290432, 0.498246, -0.074377);
 cgNormal3f(0.198242, 0.474609, -0.857422);
 cgVertex3f(-1.281894, 0.499560, -0.074377);
 cgNormal3f(0.278809, -0.438477, -0.854492);
 cgVertex3f(-1.281237, 0.491678, -0.074377);
 cgNormal3f(0.041016, -0.445312, -0.894531);
 cgVertex3f(-1.289776, 0.491022, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.050293, 0.461914, 0.885254);
 cgVertex3f(-1.285835, 0.504814, 0.053700);
 cgNormal3f(-0.043457, 0.728516, 0.683105);
 cgVertex3f(-1.291089, 0.503501, 0.053700);
 cgNormal3f(0.028320, -0.425781, 0.904297);
 cgVertex3f(-1.289776, 0.491022, 0.053700);
 cgNormal3f(0.115723, -0.421387, 0.899414);
 cgVertex3f(-1.284521, 0.491678, 0.053700);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.314941, 0.482422, 0.816895);
 cgVertex3f(-1.275983, 0.505471, 0.051729);
 cgNormal3f(0.050293, 0.461914, 0.885254);
 cgVertex3f(-1.285835, 0.504814, 0.053700);
 cgNormal3f(0.115723, -0.421387, 0.899414);
 cgVertex3f(-1.284521, 0.491678, 0.053700);
 cgNormal3f(0.364746, -0.414062, 0.833496);
 cgVertex3f(-1.275326, 0.491678, 0.051729);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.469727, 0.486328, 0.736328);
 cgVertex3f(-1.267444, 0.505471, 0.045818);
 cgNormal3f(0.314941, 0.482422, 0.816895);
 cgVertex3f(-1.275983, 0.505471, 0.051729);
 cgNormal3f(0.364746, -0.414062, 0.833496);
 cgVertex3f(-1.275326, 0.491678, 0.051729);
 cgNormal3f(0.511719, -0.398438, 0.760742);
 cgVertex3f(-1.266788, 0.492992, 0.045818);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.199219, 0.740723, 0.641113);
 cgVertex3f(-1.258906, 0.506785, 0.039907);
 cgNormal3f(0.469727, 0.486328, 0.736328);
 cgVertex3f(-1.267444, 0.505471, 0.045818);
 cgNormal3f(0.511719, -0.398438, 0.760742);
 cgVertex3f(-1.266788, 0.492992, 0.045818);
 cgNormal3f(0.320312, -0.669434, 0.670410);
 cgVertex3f(-1.257592, 0.492992, 0.039907);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.141113, 0.462891, 0.874512);
 cgVertex3f(-1.246427, 0.507442, 0.037280);
 cgNormal3f(0.199219, 0.740723, 0.641113);
 cgVertex3f(-1.258906, 0.506785, 0.039907);
 cgNormal3f(0.320312, -0.669434, 0.670410);
 cgVertex3f(-1.257592, 0.492992, 0.039907);
 cgNormal3f(0.235352, -0.423828, 0.874512);
 cgVertex3f(-1.245113, 0.494962, 0.037280);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.355957, 0.497070, 0.791016);
 cgVertex3f(-1.237888, 0.507442, 0.035309);
 cgNormal3f(0.141113, 0.462891, 0.874512);
 cgVertex3f(-1.246427, 0.507442, 0.037280);
 cgNormal3f(0.235352, -0.423828, 0.874512);
 cgVertex3f(-1.245113, 0.494962, 0.037280);
 cgNormal3f(0.452148, -0.414062, 0.790039);
 cgVertex3f(-1.236575, 0.494962, 0.035309);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.745605, 0.559082, 0.361816);
 cgVertex3f(-1.230663, 0.509412, 0.028741);
 cgNormal3f(0.355957, 0.497070, 0.791016);
 cgVertex3f(-1.237888, 0.507442, 0.035309);
 cgNormal3f(0.452148, -0.414062, 0.790039);
 cgVertex3f(-1.236575, 0.494962, 0.035309);
 cgNormal3f(0.843262, -0.397461, 0.361328);
 cgVertex3f(-1.229350, 0.496276, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.810059, 0.542969, -0.220215);
 cgVertex3f(-1.230663, 0.509412, 0.019546);
 cgNormal3f(0.745605, 0.559082, 0.361816);
 cgVertex3f(-1.230663, 0.509412, 0.028741);
 cgNormal3f(0.843262, -0.397461, 0.361328);
 cgVertex3f(-1.229350, 0.496276, 0.028741);
 cgNormal3f(0.901855, -0.373047, -0.217285);
 cgVertex3f(-1.229350, 0.496276, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.607910, 0.521484, -0.598633);
 cgVertex3f(-1.234604, 0.509412, 0.012321);
 cgNormal3f(0.810059, 0.542969, -0.220215);
 cgVertex3f(-1.230663, 0.509412, 0.019546);
 cgNormal3f(0.901855, -0.373047, -0.217285);
 cgVertex3f(-1.229350, 0.496276, 0.019546);
 cgNormal3f(0.702637, -0.391602, -0.594238);
 cgVertex3f(-1.233291, 0.494962, 0.012321);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.209473, 0.489258, -0.846680);
 cgVertex3f(-1.243143, 0.507442, 0.006410);
 cgNormal3f(0.607910, 0.521484, -0.598633);
 cgVertex3f(-1.234604, 0.509412, 0.012321);
 cgNormal3f(0.702637, -0.391602, -0.594238);
 cgVertex3f(-1.233291, 0.494962, 0.012321);
 cgNormal3f(0.349121, -0.933105, 0.085938);
 cgVertex3f(-1.241829, 0.494962, 0.006410);
 cgNormal3f(0.466797, 0.698730, -0.541992);
 cgVertex3f(-1.242486, 0.502844, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.430664, 0.500488, 0.750488);
 cgVertex3f(-1.237231, 0.503501, 0.005096);
 cgNormal3f(0.466797, 0.698730, -0.541992);
 cgVertex3f(-1.242486, 0.502844, 0.006410);
 cgNormal3f(0.349121, -0.933105, 0.085938);
 cgVertex3f(-1.241829, 0.494962, 0.006410);
 cgNormal3f(0.524414, -0.420410, 0.740234);
 cgVertex3f(-1.236575, 0.494962, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.779297, 0.533203, 0.328125);
 cgVertex3f(-1.231977, 0.503501, -0.001472);
 cgNormal3f(0.430664, 0.500488, 0.750488);
 cgVertex3f(-1.237231, 0.503501, 0.005096);
 cgNormal3f(0.524414, -0.420410, 0.740234);
 cgVertex3f(-1.236575, 0.494962, 0.005096);
 cgNormal3f(0.866699, -0.385254, 0.316406);
 cgVertex3f(-1.231320, 0.496276, -0.001472);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.820801, 0.537109, -0.193848);
 cgVertex3f(-1.231320, 0.503501, -0.012637);
 cgNormal3f(0.779297, 0.533203, 0.328125);
 cgVertex3f(-1.231977, 0.503501, -0.001472);
 cgNormal3f(0.866699, -0.385254, 0.316406);
 cgVertex3f(-1.231320, 0.496276, -0.001472);
 cgNormal3f(0.902832, -0.379883, -0.200195);
 cgVertex3f(-1.230663, 0.496276, -0.012637);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.622559, 0.512207, -0.591309);
 cgVertex3f(-1.236575, 0.503501, -0.021832);
 cgNormal3f(0.820801, 0.537109, -0.193848);
 cgVertex3f(-1.231320, 0.503501, -0.012637);
 cgNormal3f(0.902832, -0.379883, -0.200195);
 cgVertex3f(-1.230663, 0.496276, -0.012637);
 cgNormal3f(0.704590, -0.393555, -0.590332);
 cgVertex3f(-1.235918, 0.494962, -0.021832);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.450195, 0.497559, -0.741699);
 cgVertex3f(-1.248397, 0.501530, -0.030371);
 cgNormal3f(0.622559, 0.512207, -0.591309);
 cgVertex3f(-1.236575, 0.503501, -0.021832);
 cgNormal3f(0.704590, -0.393555, -0.590332);
 cgVertex3f(-1.235918, 0.494962, -0.021832);
 cgNormal3f(0.538086, -0.394043, -0.745117);
 cgVertex3f(-1.247740, 0.494306, -0.030371);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.394531, 0.770508, -0.500000);
 cgVertex3f(-1.260876, 0.501530, -0.037596);
 cgNormal3f(0.450195, 0.497559, -0.741699);
 cgVertex3f(-1.248397, 0.501530, -0.030371);
 cgNormal3f(0.538086, -0.394043, -0.745117);
 cgVertex3f(-1.247740, 0.494306, -0.030371);
 cgNormal3f(0.444824, -0.809570, -0.383301);
 cgVertex3f(-1.259563, 0.492992, -0.037596);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.557617, 0.782227, -0.276855);
 cgVertex3f(-1.266788, 0.500874, -0.046791);
 cgNormal3f(0.394531, 0.770508, -0.500000);
 cgVertex3f(-1.260876, 0.501530, -0.037596);
 cgNormal3f(0.444824, -0.809570, -0.383301);
 cgVertex3f(-1.259563, 0.492992, -0.037596);
 cgNormal3f(0.705566, -0.657227, -0.265137);
 cgVertex3f(-1.266131, 0.492992, -0.046791);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.600098, 0.765625, -0.230957);
 cgVertex3f(-1.268758, 0.499560, -0.061241);
 cgNormal3f(0.557617, 0.782227, -0.276855);
 cgVertex3f(-1.266788, 0.500874, -0.046791);
 cgNormal3f(0.705566, -0.657227, -0.265137);
 cgVertex3f(-1.266131, 0.492992, -0.046791);
 cgNormal3f(0.894043, -0.371094, -0.251465);
 cgVertex3f(-1.268101, 0.492992, -0.061241);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.615723, 0.515625, -0.595703);
 cgVertex3f(-1.272042, 0.499560, -0.068465);
 cgNormal3f(0.600098, 0.765625, -0.230957);
 cgVertex3f(-1.268758, 0.499560, -0.061241);
 cgNormal3f(0.894043, -0.371094, -0.251465);
 cgVertex3f(-1.268101, 0.492992, -0.061241);
 cgNormal3f(0.699219, -0.402832, -0.590820);
 cgVertex3f(-1.271385, 0.491678, -0.068465);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.394531, 0.770508, -0.500000);
 cgVertex3f(-1.260876, 0.501530, -0.037596);
 cgNormal3f(0.258789, 0.930664, -0.257812);
 cgVertex3f(-1.266131, 0.500874, -0.027087);
 cgNormal3f(0.532227, 0.624512, -0.571289);
 cgVertex3f(-1.266788, 0.500874, 0.006410);
 cgNormal3f(0.466797, 0.698730, -0.541992);
 cgVertex3f(-1.242486, 0.502844, 0.006410);
 cgNormal3f(0.430664, 0.500488, 0.750488);
 cgVertex3f(-1.237231, 0.503501, 0.005096);
 cgNormal3f(0.779297, 0.533203, 0.328125);
 cgVertex3f(-1.231977, 0.503501, -0.001472);
 cgNormal3f(0.820801, 0.537109, -0.193848);
 cgVertex3f(-1.231320, 0.503501, -0.012637);
 cgNormal3f(0.622559, 0.512207, -0.591309);
 cgVertex3f(-1.236575, 0.503501, -0.021832);
 cgNormal3f(0.450195, 0.497559, -0.741699);
 cgVertex3f(-1.248397, 0.501530, -0.030371);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.557617, 0.782227, -0.276855);
 cgVertex3f(-1.266788, 0.500874, -0.046791);
 cgNormal3f(0.161133, 0.955078, -0.248535);
 cgVertex3f(-1.275326, 0.499560, -0.050732);
 cgNormal3f(0.404297, 0.835449, -0.372070);
 cgVertex3f(-1.275326, 0.499560, -0.027744);
 cgNormal3f(0.258789, 0.930664, -0.257812);
 cgVertex3f(-1.266131, 0.500874, -0.027087);
 cgNormal3f(0.394531, 0.770508, -0.500000);
 cgVertex3f(-1.260876, 0.501530, -0.037596);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.600098, 0.765625, -0.230957);
 cgVertex3f(-1.268758, 0.499560, -0.061241);
 cgNormal3f(0.161133, 0.955078, -0.248535);
 cgVertex3f(-1.275326, 0.499560, -0.050732);
 cgNormal3f(0.557617, 0.782227, -0.276855);
 cgVertex3f(-1.266788, 0.500874, -0.046791);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.355957, 0.497070, 0.791016);
 cgVertex3f(-1.237888, 0.507442, 0.035309);
 cgNormal3f(0.745605, 0.559082, 0.361816);
 cgVertex3f(-1.230663, 0.509412, 0.028741);
 cgNormal3f(0.810059, 0.542969, -0.220215);
 cgVertex3f(-1.230663, 0.509412, 0.019546);
 cgNormal3f(0.607910, 0.521484, -0.598633);
 cgVertex3f(-1.234604, 0.509412, 0.012321);
 cgNormal3f(0.209473, 0.489258, -0.846680);
 cgVertex3f(-1.243143, 0.507442, 0.006410);
 cgNormal3f(0.773438, 0.483887, -0.408691);
 cgVertex3f(-1.266788, 0.505471, 0.006410);
 cgNormal3f(0.683594, 0.582031, 0.439453);
 cgVertex3f(-1.266788, 0.505471, 0.028741);
 cgNormal3f(0.199219, 0.740723, 0.641113);
 cgVertex3f(-1.258906, 0.506785, 0.039907);
 cgNormal3f(0.141113, 0.462891, 0.874512);
 cgVertex3f(-1.246427, 0.507442, 0.037280);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.209473, 0.489258, -0.846680);
 cgVertex3f(-1.243143, 0.507442, 0.006410);
 cgNormal3f(0.466797, 0.698730, -0.541992);
 cgVertex3f(-1.242486, 0.502844, 0.006410);
 cgNormal3f(0.532227, 0.624512, -0.571289);
 cgVertex3f(-1.266788, 0.500874, 0.006410);
 cgNormal3f(0.773438, 0.483887, -0.408691);
 cgVertex3f(-1.266788, 0.505471, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.288574, 0.950195, 0.112793);
 cgVertex3f(-1.267444, 0.511382, 0.028741);
 cgNormal3f(0.226562, 0.929688, 0.289551);
 cgVertex3f(-1.276640, 0.510069, 0.005096);
 cgNormal3f(0.511719, 0.790527, -0.336426);
 cgVertex3f(-1.284521, 0.510069, 0.013635);
 cgNormal3f(0.525879, 0.793945, 0.303223);
 cgVertex3f(-1.284521, 0.510069, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.288574, 0.950195, 0.112793);
 cgVertex3f(-1.267444, 0.511382, 0.028741);
 cgNormal3f(0.683594, 0.582031, 0.439453);
 cgVertex3f(-1.266788, 0.505471, 0.028741);
 cgNormal3f(0.773438, 0.483887, -0.408691);
 cgVertex3f(-1.266788, 0.505471, 0.006410);
 cgNormal3f(0.655762, 0.723633, -0.214844);
 cgVertex3f(-1.267444, 0.511382, -0.015921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.669434, 0.574219, -0.470215);
 cgVertex3f(-1.275983, 0.505471, -0.023146);
 cgNormal3f(0.413086, 0.675781, -0.610352);
 cgVertex3f(-1.266788, 0.505471, -0.023146);
 cgNormal3f(0.258789, 0.930664, -0.257812);
 cgVertex3f(-1.266131, 0.500874, -0.027087);
 cgNormal3f(0.404297, 0.835449, -0.372070);
 cgVertex3f(-1.275326, 0.499560, -0.027744);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.666992, 0.534668, -0.518555);
 cgVertex3f(-1.275983, 0.507442, -0.045477);
 cgNormal3f(0.669434, 0.574219, -0.470215);
 cgVertex3f(-1.275983, 0.505471, -0.023146);
 cgNormal3f(0.404297, 0.835449, -0.372070);
 cgVertex3f(-1.275326, 0.499560, -0.027744);
 cgNormal3f(0.161133, 0.955078, -0.248535);
 cgVertex3f(-1.275326, 0.499560, -0.050732);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.011719, -0.285645, 0.958008);
 cgVertex3f(-1.291746, 0.507442, 0.041877);
 cgNormal3f(0.291016, 0.025879, 0.956055);
 cgVertex3f(-1.283208, 0.509412, 0.041221);
 cgNormal3f(0.143555, 0.833008, 0.533691);
 cgVertex3f(-1.283864, 0.513353, 0.038593);
 cgNormal3f(-0.114258, 0.959473, 0.255859);
 cgVertex3f(-1.291746, 0.512039, 0.039250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.654297, 0.726562, -0.208984);
 cgVertex3f(-1.276640, 0.510069, -0.015921);
 cgNormal3f(0.655762, 0.723633, -0.214844);
 cgVertex3f(-1.267444, 0.511382, -0.015921);
 cgNormal3f(0.413086, 0.675781, -0.610352);
 cgVertex3f(-1.266788, 0.505471, -0.023146);
 cgNormal3f(0.669434, 0.574219, -0.470215);
 cgVertex3f(-1.275983, 0.505471, -0.023146);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.532227, 0.624512, -0.571289);
 cgVertex3f(-1.266788, 0.500874, 0.006410);
 cgNormal3f(0.258789, 0.930664, -0.257812);
 cgVertex3f(-1.266131, 0.500874, -0.027087);
 cgNormal3f(0.413086, 0.675781, -0.610352);
 cgVertex3f(-1.266788, 0.505471, -0.023146);
 cgNormal3f(0.655762, 0.723633, -0.214844);
 cgVertex3f(-1.267444, 0.511382, -0.015921);
 cgNormal3f(0.773438, 0.483887, -0.408691);
 cgVertex3f(-1.266788, 0.505471, 0.006410);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.669434, 0.574219, -0.470215);
 cgVertex3f(-1.275983, 0.505471, -0.023146);
 cgNormal3f(0.666992, 0.534668, -0.518555);
 cgVertex3f(-1.275983, 0.507442, -0.045477);
 cgNormal3f(0.373047, 0.809570, -0.452637);
 cgVertex3f(-1.276640, 0.513353, -0.038909);
 cgNormal3f(0.641602, 0.753418, -0.140137);
 cgVertex3f(-1.277296, 0.517294, -0.029714);
 cgNormal3f(0.654297, 0.726562, -0.208984);
 cgVertex3f(-1.276640, 0.510069, -0.015921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.484375, -0.423828, 0.765137);
 cgVertex3f(-1.272699, 0.506785, 0.034653);
 cgNormal3f(0.085449, -0.927734, 0.363770);
 cgVertex3f(-1.291089, 0.505471, 0.035966);
 cgNormal3f(0.095215, 0.183105, 0.978027);
 cgVertex3f(-1.291089, 0.503501, 0.030055);
 cgNormal3f(0.683594, 0.582031, 0.439453);
 cgVertex3f(-1.266788, 0.505471, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.334961, 0.891602, 0.302734);
 cgVertex3f(-1.273356, 0.512039, 0.033339);
 cgNormal3f(0.484375, -0.423828, 0.765137);
 cgVertex3f(-1.272699, 0.506785, 0.034653);
 cgNormal3f(0.683594, 0.582031, 0.439453);
 cgVertex3f(-1.266788, 0.505471, 0.028741);
 cgNormal3f(0.288574, 0.950195, 0.112793);
 cgVertex3f(-1.267444, 0.511382, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.094238, 0.940430, -0.325684);
 cgVertex3f(-1.291746, 0.510069, 0.034653);
 cgNormal3f(0.334961, 0.891602, 0.302734);
 cgVertex3f(-1.273356, 0.512039, 0.033339);
 cgNormal3f(0.288574, 0.950195, 0.112793);
 cgVertex3f(-1.267444, 0.511382, 0.028741);
 cgNormal3f(-0.098145, 0.991211, -0.085938);
 cgVertex3f(-1.291746, 0.509412, 0.030055);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.291016, 0.025879, 0.956055);
 cgVertex3f(-1.283208, 0.509412, 0.041221);
 cgNormal3f(0.011719, -0.285645, 0.958008);
 cgVertex3f(-1.291746, 0.507442, 0.041877);
 cgNormal3f(0.085449, -0.927734, 0.363770);
 cgVertex3f(-1.291089, 0.505471, 0.035966);
 cgNormal3f(0.484375, -0.423828, 0.765137);
 cgVertex3f(-1.272699, 0.506785, 0.034653);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.143555, 0.833008, 0.533691);
 cgVertex3f(-1.283864, 0.513353, 0.038593);
 cgNormal3f(0.291016, 0.025879, 0.956055);
 cgVertex3f(-1.283208, 0.509412, 0.041221);
 cgNormal3f(0.484375, -0.423828, 0.765137);
 cgVertex3f(-1.272699, 0.506785, 0.034653);
 cgNormal3f(0.334961, 0.891602, 0.302734);
 cgVertex3f(-1.273356, 0.512039, 0.033339);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.114258, 0.959473, 0.255859);
 cgVertex3f(-1.291746, 0.512039, 0.039250);
 cgNormal3f(0.143555, 0.833008, 0.533691);
 cgVertex3f(-1.283864, 0.513353, 0.038593);
 cgNormal3f(0.334961, 0.891602, 0.302734);
 cgVertex3f(-1.273356, 0.512039, 0.033339);
 cgNormal3f(-0.094238, 0.940430, -0.325684);
 cgVertex3f(-1.291746, 0.510069, 0.034653);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.320312, -0.669434, 0.670410);
 cgVertex3f(-1.257592, 0.492992, 0.039907);
 cgNormal3f(0.349121, -0.933105, 0.085938);
 cgVertex3f(-1.241829, 0.494962, 0.006410);
 cgNormal3f(0.702637, -0.391602, -0.594238);
 cgVertex3f(-1.233291, 0.494962, 0.012321);
 cgNormal3f(0.901855, -0.373047, -0.217285);
 cgVertex3f(-1.229350, 0.496276, 0.019546);
 cgNormal3f(0.843262, -0.397461, 0.361328);
 cgVertex3f(-1.229350, 0.496276, 0.028741);
 cgNormal3f(0.452148, -0.414062, 0.790039);
 cgVertex3f(-1.236575, 0.494962, 0.035309);
 cgNormal3f(0.235352, -0.423828, 0.874512);
 cgVertex3f(-1.245113, 0.494962, 0.037280);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.538086, -0.394043, -0.745117);
 cgVertex3f(-1.247740, 0.494306, -0.030371);
 cgNormal3f(0.704590, -0.393555, -0.590332);
 cgVertex3f(-1.235918, 0.494962, -0.021832);
 cgNormal3f(0.902832, -0.379883, -0.200195);
 cgVertex3f(-1.230663, 0.496276, -0.012637);
 cgNormal3f(0.866699, -0.385254, 0.316406);
 cgVertex3f(-1.231320, 0.496276, -0.001472);
 cgNormal3f(0.524414, -0.420410, 0.740234);
 cgVertex3f(-1.236575, 0.494962, 0.005096);
 cgNormal3f(0.349121, -0.933105, 0.085938);
 cgVertex3f(-1.241829, 0.494962, 0.006410);
 cgNormal3f(0.444824, -0.809570, -0.383301);
 cgVertex3f(-1.259563, 0.492992, -0.037596);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.444824, -0.809570, -0.383301);
 cgVertex3f(-1.259563, 0.492992, -0.037596);
 cgNormal3f(0.085938, -0.996582, 0.009766);
 cgVertex3f(-1.289776, 0.491022, -0.010010);
 cgNormal3f(0.705566, -0.657227, -0.265137);
 cgVertex3f(-1.266131, 0.492992, -0.046791);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.305176, -0.869629, -0.389160);
 cgVertex3f(-1.319988, 0.487738, -0.038253);
 cgNormal3f(-0.555664, -0.774902, -0.302246);
 cgVertex3f(-1.313421, 0.489051, -0.046791);
 cgNormal3f(0.085938, -0.996582, 0.009766);
 cgVertex3f(-1.289776, 0.491022, -0.010010);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.364746, -0.414062, 0.833496);
 cgVertex3f(-1.275326, 0.491678, 0.051729);
 cgNormal3f(0.115723, -0.421387, 0.899414);
 cgVertex3f(-1.284521, 0.491678, 0.053700);
 cgNormal3f(0.028320, -0.425781, 0.904297);
 cgVertex3f(-1.289776, 0.491022, 0.053700);
 cgNormal3f(-0.082031, -0.438965, 0.894531);
 cgVertex3f(-1.295030, 0.489708, 0.053700);
 cgNormal3f(-0.307129, -0.461914, 0.832031);
 cgVertex3f(-1.304882, 0.489708, 0.051073);
 cgNormal3f(-0.455566, -0.475098, 0.752441);
 cgVertex3f(-1.313421, 0.489051, 0.045818);
 cgNormal3f(-0.233887, -0.713867, 0.660156);
 cgVertex3f(-1.321959, 0.487738, 0.039250);
 cgNormal3f(-0.207031, -0.974121, 0.095215);
 cgVertex3f(-1.338379, 0.486424, 0.006410);
 cgNormal3f(-0.305176, -0.869629, -0.389160);
 cgVertex3f(-1.319988, 0.487738, -0.038253);
 cgNormal3f(0.085938, -0.996582, 0.009766);
 cgVertex3f(-1.289776, 0.491022, -0.010010);
 cgNormal3f(0.444824, -0.809570, -0.383301);
 cgVertex3f(-1.259563, 0.492992, -0.037596);
 cgNormal3f(0.349121, -0.933105, 0.085938);
 cgVertex3f(-1.241829, 0.494962, 0.006410);
 cgNormal3f(0.320312, -0.669434, 0.670410);
 cgVertex3f(-1.257592, 0.492992, 0.039907);
 cgNormal3f(0.511719, -0.398438, 0.760742);
 cgVertex3f(-1.266788, 0.492992, 0.045818);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.305176, -0.869629, -0.389160);
 cgVertex3f(-1.319988, 0.487738, -0.038253);
 cgNormal3f(-0.207031, -0.974121, 0.095215);
 cgVertex3f(-1.338379, 0.486424, 0.006410);
 cgNormal3f(-0.468262, -0.509277, 0.722168);
 cgVertex3f(-1.343633, 0.486424, 0.005096);
 cgNormal3f(-0.805664, -0.530762, 0.264648);
 cgVertex3f(-1.348888, 0.485767, -0.002128);
 cgNormal3f(-0.815430, -0.526855, -0.242188);
 cgVertex3f(-1.348888, 0.485767, -0.013294);
 cgNormal3f(-0.619629, -0.505371, -0.601562);
 cgVertex3f(-1.343633, 0.486424, -0.021832);
 cgNormal3f(-0.481445, -0.484863, -0.730469);
 cgVertex3f(-1.331811, 0.486424, -0.030371);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.366211, -0.481934, 0.795898);
 cgVertex3f(-1.342977, 0.486424, 0.034653);
 cgNormal3f(-0.761230, -0.526855, 0.378906);
 cgVertex3f(-1.350858, 0.485767, 0.028085);
 cgNormal3f(-0.828613, -0.515137, -0.220703);
 cgVertex3f(-1.350858, 0.485767, 0.019546);
 cgNormal3f(-0.629883, -0.505371, -0.590332);
 cgVertex3f(-1.346261, 0.485767, 0.012321);
 cgNormal3f(-0.207031, -0.974121, 0.095215);
 cgVertex3f(-1.338379, 0.486424, 0.006410);
 cgNormal3f(-0.233887, -0.713867, 0.660156);
 cgVertex3f(-1.321959, 0.487738, 0.039250);
 cgNormal3f(-0.159668, -0.457520, 0.874512);
 cgVertex3f(-1.334438, 0.486424, 0.036623);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.336426, 0.780762, 0.525879);
 cgVertex3f(-1.299628, 0.512039, 0.038593);
 cgNormal3f(-0.114258, 0.959473, 0.255859);
 cgVertex3f(-1.291746, 0.512039, 0.039250);
 cgNormal3f(-0.094238, 0.940430, -0.325684);
 cgVertex3f(-1.291746, 0.510069, 0.034653);
 cgNormal3f(-0.517578, 0.798340, 0.306641);
 cgVertex3f(-1.310137, 0.507442, 0.033339);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.309082, -0.057129, 0.949219);
 cgVertex3f(-1.299628, 0.507442, 0.041221);
 cgNormal3f(-0.336426, 0.780762, 0.525879);
 cgVertex3f(-1.299628, 0.512039, 0.038593);
 cgNormal3f(-0.517578, 0.798340, 0.306641);
 cgVertex3f(-1.310137, 0.507442, 0.033339);
 cgNormal3f(-0.418945, -0.531250, 0.736816);
 cgVertex3f(-1.309480, 0.503501, 0.034653);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.011719, -0.285645, 0.958008);
 cgVertex3f(-1.291746, 0.507442, 0.041877);
 cgNormal3f(-0.309082, -0.057129, 0.949219);
 cgVertex3f(-1.299628, 0.507442, 0.041221);
 cgNormal3f(-0.418945, -0.531250, 0.736816);
 cgVertex3f(-1.309480, 0.503501, 0.034653);
 cgNormal3f(0.085449, -0.927734, 0.363770);
 cgVertex3f(-1.291089, 0.505471, 0.035966);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.517578, 0.798340, 0.306641);
 cgVertex3f(-1.310137, 0.507442, 0.033339);
 cgNormal3f(-0.094238, 0.940430, -0.325684);
 cgVertex3f(-1.291746, 0.510069, 0.034653);
 cgNormal3f(-0.098145, 0.991211, -0.085938);
 cgVertex3f(-1.291746, 0.509412, 0.030055);
 cgNormal3f(-0.463867, 0.878418, 0.114258);
 cgVertex3f(-1.315391, 0.507442, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.418945, -0.531250, 0.736816);
 cgVertex3f(-1.309480, 0.503501, 0.034653);
 cgNormal3f(-0.517578, 0.798340, 0.306641);
 cgVertex3f(-1.310137, 0.507442, 0.033339);
 cgNormal3f(-0.463867, 0.878418, 0.114258);
 cgVertex3f(-1.315391, 0.507442, 0.028085);
 cgNormal3f(-0.794434, 0.478027, 0.374512);
 cgVertex3f(-1.315391, 0.501530, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.085449, -0.927734, 0.363770);
 cgVertex3f(-1.291089, 0.505471, 0.035966);
 cgNormal3f(-0.418945, -0.531250, 0.736816);
 cgVertex3f(-1.309480, 0.503501, 0.034653);
 cgNormal3f(-0.794434, 0.478027, 0.374512);
 cgVertex3f(-1.315391, 0.501530, 0.028085);
 cgNormal3f(0.095215, 0.183105, 0.978027);
 cgVertex3f(-1.291089, 0.503501, 0.030055);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.087402, 0.754395, -0.650391);
 cgVertex3f(-1.291746, 0.509412, 0.009694);
 cgNormal3f(0.511719, 0.790527, -0.336426);
 cgVertex3f(-1.284521, 0.510069, 0.013635);
 cgNormal3f(0.226562, 0.929688, 0.289551);
 cgVertex3f(-1.276640, 0.510069, 0.005096);
 cgNormal3f(-0.096680, 0.887695, 0.449219);
 cgVertex3f(-1.291746, 0.509412, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.780273, 0.610840, -0.134766);
 cgVertex3f(-1.306852, 0.514010, -0.029714);
 cgNormal3f(0.641602, 0.753418, -0.140137);
 cgVertex3f(-1.277296, 0.517294, -0.029714);
 cgNormal3f(0.373047, 0.809570, -0.452637);
 cgVertex3f(-1.276640, 0.513353, -0.038909);
 cgNormal3f(-0.526367, 0.722656, -0.448242);
 cgVertex3f(-1.306852, 0.510069, -0.038909);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.780273, 0.610840, -0.134766);
 cgVertex3f(-1.306852, 0.514010, -0.029714);
 cgNormal3f(-0.778809, 0.593262, -0.204590);
 cgVertex3f(-1.306196, 0.507442, -0.015921);
 cgNormal3f(-0.401367, 0.864258, 0.302734);
 cgVertex3f(-1.306196, 0.507442, 0.005096);
 cgNormal3f(-0.634766, 0.519043, 0.572754);
 cgVertex3f(-1.306852, 0.514010, 0.005096);
 cgNormal3f(-0.773926, 0.632812, -0.008789);
 cgVertex3f(-1.306852, 0.514010, -0.015921);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.226562, 0.929688, 0.289551);
 cgVertex3f(-1.276640, 0.510069, 0.005096);
 cgNormal3f(0.520996, 0.630859, 0.574219);
 cgVertex3f(-1.277296, 0.517294, 0.005096);
 cgNormal3f(-0.634766, 0.519043, 0.572754);
 cgVertex3f(-1.306852, 0.514010, 0.005096);
 cgNormal3f(-0.401367, 0.864258, 0.302734);
 cgVertex3f(-1.306196, 0.507442, 0.005096);
 cgNormal3f(-0.096680, 0.887695, 0.449219);
 cgVertex3f(-1.291746, 0.509412, 0.005096);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.641602, 0.753418, -0.140137);
 cgVertex3f(-1.277296, 0.517294, -0.029714);
 cgNormal3f(-0.780273, 0.610840, -0.134766);
 cgVertex3f(-1.306852, 0.514010, -0.029714);
 cgNormal3f(-0.773926, 0.632812, -0.008789);
 cgVertex3f(-1.306852, 0.514010, -0.015921);
 cgNormal3f(-0.634766, 0.519043, 0.572754);
 cgVertex3f(-1.306852, 0.514010, 0.005096);
 cgNormal3f(0.520996, 0.630859, 0.574219);
 cgVertex3f(-1.277296, 0.517294, 0.005096);
 cgNormal3f(0.636719, 0.770996, -0.008789);
 cgVertex3f(-1.277296, 0.517294, -0.015921);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.427246, 0.860840, -0.275391);
 cgVertex3f(-1.314734, 0.496276, -0.027744);
 cgNormal3f(-0.634277, 0.518555, -0.573730);
 cgVertex3f(-1.314734, 0.496276, 0.006410);
 cgNormal3f(-0.835449, 0.361328, -0.414062);
 cgVertex3f(-1.315391, 0.501530, 0.006410);
 cgNormal3f(-0.760742, 0.613281, -0.212891);
 cgVertex3f(-1.315391, 0.507442, -0.015921);
 cgNormal3f(-0.497070, 0.600098, -0.626953);
 cgVertex3f(-1.315391, 0.501530, -0.023146);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.526367, 0.722656, -0.448242);
 cgVertex3f(-1.306852, 0.510069, -0.038909);
 cgNormal3f(0.373047, 0.809570, -0.452637);
 cgVertex3f(-1.276640, 0.513353, -0.038909);
 cgNormal3f(0.666992, 0.534668, -0.518555);
 cgVertex3f(-1.275983, 0.507442, -0.045477);
 cgNormal3f(-0.754395, 0.399902, -0.520996);
 cgVertex3f(-1.306196, 0.505471, -0.045477);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.778809, 0.593262, -0.204590);
 cgVertex3f(-1.306196, 0.507442, -0.015921);
 cgNormal3f(-0.780273, 0.610840, -0.134766);
 cgVertex3f(-1.306852, 0.514010, -0.029714);
 cgNormal3f(-0.526367, 0.722656, -0.448242);
 cgVertex3f(-1.306852, 0.510069, -0.038909);
 cgNormal3f(-0.754395, 0.399902, -0.520996);
 cgVertex3f(-1.306196, 0.505471, -0.045477);
 cgNormal3f(-0.752441, 0.444336, -0.486328);
 cgVertex3f(-1.306196, 0.502844, -0.023146);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.760742, 0.613281, -0.212891);
 cgVertex3f(-1.315391, 0.507442, -0.015921);
 cgNormal3f(-0.778809, 0.593262, -0.204590);
 cgVertex3f(-1.306196, 0.507442, -0.015921);
 cgNormal3f(-0.752441, 0.444336, -0.486328);
 cgVertex3f(-1.306196, 0.502844, -0.023146);
 cgNormal3f(-0.497070, 0.600098, -0.626953);
 cgVertex3f(-1.315391, 0.501530, -0.023146);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.309082, -0.057129, 0.949219);
 cgVertex3f(-1.299628, 0.507442, 0.041221);
 cgNormal3f(0.011719, -0.285645, 0.958008);
 cgVertex3f(-1.291746, 0.507442, 0.041877);
 cgNormal3f(-0.114258, 0.959473, 0.255859);
 cgVertex3f(-1.291746, 0.512039, 0.039250);
 cgNormal3f(-0.336426, 0.780762, 0.525879);
 cgVertex3f(-1.299628, 0.512039, 0.038593);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.752441, 0.444336, -0.486328);
 cgVertex3f(-1.306196, 0.502844, -0.023146);
 cgNormal3f(-0.754395, 0.399902, -0.520996);
 cgVertex3f(-1.306196, 0.505471, -0.045477);
 cgNormal3f(-0.341309, 0.911621, -0.228516);
 cgVertex3f(-1.305539, 0.496933, -0.050732);
 cgNormal3f(-0.552246, 0.735352, -0.393066);
 cgVertex3f(-1.305539, 0.496933, -0.027744);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.497070, 0.600098, -0.626953);
 cgVertex3f(-1.315391, 0.501530, -0.023146);
 cgNormal3f(-0.752441, 0.444336, -0.486328);
 cgVertex3f(-1.306196, 0.502844, -0.023146);
 cgNormal3f(-0.552246, 0.735352, -0.393066);
 cgVertex3f(-1.305539, 0.496933, -0.027744);
 cgNormal3f(-0.427246, 0.860840, -0.275391);
 cgVertex3f(-1.314734, 0.496276, -0.027744);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.794434, 0.478027, 0.374512);
 cgVertex3f(-1.315391, 0.501530, 0.028085);
 cgNormal3f(-0.463867, 0.878418, 0.114258);
 cgVertex3f(-1.315391, 0.507442, 0.028085);
 cgNormal3f(-0.760742, 0.613281, -0.212891);
 cgVertex3f(-1.315391, 0.507442, -0.015921);
 cgNormal3f(-0.835449, 0.361328, -0.414062);
 cgVertex3f(-1.315391, 0.501530, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.161133, 0.955078, -0.248535);
 cgVertex3f(-1.275326, 0.499560, -0.050732);
 cgNormal3f(-0.341309, 0.911621, -0.228516);
 cgVertex3f(-1.305539, 0.496933, -0.050732);
 cgNormal3f(-0.754395, 0.399902, -0.520996);
 cgVertex3f(-1.306196, 0.505471, -0.045477);
 cgNormal3f(0.666992, 0.534668, -0.518555);
 cgVertex3f(-1.275983, 0.507442, -0.045477);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.778809, 0.593262, -0.204590);
 cgVertex3f(-1.306196, 0.507442, -0.015921);
 cgNormal3f(-0.760742, 0.613281, -0.212891);
 cgVertex3f(-1.315391, 0.507442, -0.015921);
 cgNormal3f(-0.463867, 0.878418, 0.114258);
 cgVertex3f(-1.315391, 0.507442, 0.028085);
 cgNormal3f(-0.401367, 0.864258, 0.302734);
 cgVertex3f(-1.306196, 0.507442, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.597168, 0.599121, -0.533691);
 cgVertex3f(-1.339036, 0.494306, 0.006410);
 cgNormal3f(-0.308594, 0.438965, -0.844238);
 cgVertex3f(-1.339036, 0.499560, 0.006410);
 cgNormal3f(-0.835449, 0.361328, -0.414062);
 cgVertex3f(-1.315391, 0.501530, 0.006410);
 cgNormal3f(-0.634277, 0.518555, -0.573730);
 cgVertex3f(-1.314734, 0.496276, 0.006410);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.344238, 0.708984, 0.615234);
 cgVertex3f(-1.323273, 0.501530, 0.039250);
 cgNormal3f(-0.794434, 0.478027, 0.374512);
 cgVertex3f(-1.315391, 0.501530, 0.028085);
 cgNormal3f(-0.835449, 0.361328, -0.414062);
 cgVertex3f(-1.315391, 0.501530, 0.006410);
 cgNormal3f(-0.308594, 0.438965, -0.844238);
 cgVertex3f(-1.339036, 0.499560, 0.006410);
 cgNormal3f(-0.687012, 0.400879, -0.605957);
 cgVertex3f(-1.347574, 0.499560, 0.012321);
 cgNormal3f(-0.883301, 0.399902, -0.244141);
 cgVertex3f(-1.351515, 0.498246, 0.019546);
 cgNormal3f(-0.833496, 0.428223, 0.349121);
 cgVertex3f(-1.351515, 0.498246, 0.028085);
 cgNormal3f(-0.446289, 0.426270, 0.786621);
 cgVertex3f(-1.344290, 0.499560, 0.034653);
 cgNormal3f(-0.234375, 0.430664, 0.871582);
 cgVertex3f(-1.335752, 0.499560, 0.036623);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.734863, 0.653809, -0.181152);
 cgVertex3f(-1.311450, 0.496933, -0.061241);
 cgNormal3f(-0.694824, 0.663086, -0.278320);
 cgVertex3f(-1.314077, 0.496276, -0.046791);
 cgNormal3f(-0.341309, 0.911621, -0.228516);
 cgVertex3f(-1.305539, 0.496933, -0.050732);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.552246, 0.735352, -0.393066);
 cgVertex3f(-1.305539, 0.496933, -0.027744);
 cgNormal3f(-0.341309, 0.911621, -0.228516);
 cgVertex3f(-1.305539, 0.496933, -0.050732);
 cgNormal3f(-0.694824, 0.663086, -0.278320);
 cgVertex3f(-1.314077, 0.496276, -0.046791);
 cgNormal3f(-0.545410, 0.664062, -0.511719);
 cgVertex3f(-1.320645, 0.496276, -0.038253);
 cgNormal3f(-0.427246, 0.860840, -0.275391);
 cgVertex3f(-1.314734, 0.496276, -0.027744);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.695801, 0.391602, -0.602539);
 cgVertex3f(-1.344290, 0.492992, -0.021832);
 cgNormal3f(-0.893555, 0.380859, -0.237793);
 cgVertex3f(-1.349545, 0.492992, -0.013294);
 cgNormal3f(-0.881348, 0.384766, 0.274414);
 cgVertex3f(-1.349545, 0.492992, -0.002128);
 cgNormal3f(-0.538086, 0.418945, 0.730957);
 cgVertex3f(-1.344290, 0.492992, 0.005096);
 cgNormal3f(-0.597168, 0.599121, -0.533691);
 cgVertex3f(-1.339036, 0.494306, 0.006410);
 cgNormal3f(-0.634277, 0.518555, -0.573730);
 cgVertex3f(-1.314734, 0.496276, 0.006410);
 cgNormal3f(-0.427246, 0.860840, -0.275391);
 cgVertex3f(-1.314734, 0.496276, -0.027744);
 cgNormal3f(-0.545410, 0.664062, -0.511719);
 cgVertex3f(-1.320645, 0.496276, -0.038253);
 cgNormal3f(-0.552734, 0.400879, -0.730957);
 cgVertex3f(-1.332468, 0.494962, -0.030371);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.270508, 0.436035, -0.858398);
 cgVertex3f(-1.298971, 0.496933, -0.074377);
 cgNormal3f(-0.713867, 0.408691, -0.568848);
 cgVertex3f(-1.308823, 0.496933, -0.068465);
 cgNormal3f(-0.734863, 0.653809, -0.181152);
 cgVertex3f(-1.311450, 0.496933, -0.061241);
 cgNormal3f(-0.341309, 0.911621, -0.228516);
 cgVertex3f(-1.305539, 0.496933, -0.050732);
 cgNormal3f(0.161133, 0.955078, -0.248535);
 cgVertex3f(-1.275326, 0.499560, -0.050732);
 cgNormal3f(0.600098, 0.765625, -0.230957);
 cgVertex3f(-1.268758, 0.499560, -0.061241);
 cgNormal3f(0.615723, 0.515625, -0.595703);
 cgVertex3f(-1.272042, 0.499560, -0.068465);
 cgNormal3f(0.198242, 0.474609, -0.857422);
 cgVertex3f(-1.281894, 0.499560, -0.074377);
 cgNormal3f(-0.035156, 0.441895, -0.896484);
 cgVertex3f(-1.290432, 0.498246, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.734863, 0.653809, -0.181152);
 cgVertex3f(-1.311450, 0.496933, -0.061241);
 cgNormal3f(-0.713867, 0.408691, -0.568848);
 cgVertex3f(-1.308823, 0.496933, -0.068465);
 cgNormal3f(-0.638184, -0.524902, -0.563965);
 cgVertex3f(-1.308166, 0.489051, -0.068465);
 cgNormal3f(-0.820801, -0.521484, -0.234375);
 cgVertex3f(-1.310793, 0.489051, -0.061241);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.694824, 0.663086, -0.278320);
 cgVertex3f(-1.314077, 0.496276, -0.046791);
 cgNormal3f(-0.734863, 0.653809, -0.181152);
 cgVertex3f(-1.311450, 0.496933, -0.061241);
 cgNormal3f(-0.820801, -0.521484, -0.234375);
 cgVertex3f(-1.310793, 0.489051, -0.061241);
 cgNormal3f(-0.555664, -0.774902, -0.302246);
 cgVertex3f(-1.313421, 0.489051, -0.046791);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.545410, 0.664062, -0.511719);
 cgVertex3f(-1.320645, 0.496276, -0.038253);
 cgNormal3f(-0.694824, 0.663086, -0.278320);
 cgVertex3f(-1.314077, 0.496276, -0.046791);
 cgNormal3f(-0.555664, -0.774902, -0.302246);
 cgVertex3f(-1.313421, 0.489051, -0.046791);
 cgNormal3f(-0.305176, -0.869629, -0.389160);
 cgVertex3f(-1.319988, 0.487738, -0.038253);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.552734, 0.400879, -0.730957);
 cgVertex3f(-1.332468, 0.494962, -0.030371);
 cgNormal3f(-0.545410, 0.664062, -0.511719);
 cgVertex3f(-1.320645, 0.496276, -0.038253);
 cgNormal3f(-0.305176, -0.869629, -0.389160);
 cgVertex3f(-1.319988, 0.487738, -0.038253);
 cgNormal3f(-0.481445, -0.484863, -0.730469);
 cgVertex3f(-1.331811, 0.486424, -0.030371);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.695801, 0.391602, -0.602539);
 cgVertex3f(-1.344290, 0.492992, -0.021832);
 cgNormal3f(-0.552734, 0.400879, -0.730957);
 cgVertex3f(-1.332468, 0.494962, -0.030371);
 cgNormal3f(-0.481445, -0.484863, -0.730469);
 cgVertex3f(-1.331811, 0.486424, -0.030371);
 cgNormal3f(-0.619629, -0.505371, -0.601562);
 cgVertex3f(-1.343633, 0.486424, -0.021832);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.893555, 0.380859, -0.237793);
 cgVertex3f(-1.349545, 0.492992, -0.013294);
 cgNormal3f(-0.695801, 0.391602, -0.602539);
 cgVertex3f(-1.344290, 0.492992, -0.021832);
 cgNormal3f(-0.619629, -0.505371, -0.601562);
 cgVertex3f(-1.343633, 0.486424, -0.021832);
 cgNormal3f(-0.815430, -0.526855, -0.242188);
 cgVertex3f(-1.348888, 0.485767, -0.013294);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.881348, 0.384766, 0.274414);
 cgVertex3f(-1.349545, 0.492992, -0.002128);
 cgNormal3f(-0.893555, 0.380859, -0.237793);
 cgVertex3f(-1.349545, 0.492992, -0.013294);
 cgNormal3f(-0.815430, -0.526855, -0.242188);
 cgVertex3f(-1.348888, 0.485767, -0.013294);
 cgNormal3f(-0.805664, -0.530762, 0.264648);
 cgVertex3f(-1.348888, 0.485767, -0.002128);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.538086, 0.418945, 0.730957);
 cgVertex3f(-1.344290, 0.492992, 0.005096);
 cgNormal3f(-0.881348, 0.384766, 0.274414);
 cgVertex3f(-1.349545, 0.492992, -0.002128);
 cgNormal3f(-0.805664, -0.530762, 0.264648);
 cgVertex3f(-1.348888, 0.485767, -0.002128);
 cgNormal3f(-0.468262, -0.509277, 0.722168);
 cgVertex3f(-1.343633, 0.486424, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.597168, 0.599121, -0.533691);
 cgVertex3f(-1.339036, 0.494306, 0.006410);
 cgNormal3f(-0.538086, 0.418945, 0.730957);
 cgVertex3f(-1.344290, 0.492992, 0.005096);
 cgNormal3f(-0.468262, -0.509277, 0.722168);
 cgVertex3f(-1.343633, 0.486424, 0.005096);
 cgNormal3f(-0.207031, -0.974121, 0.095215);
 cgVertex3f(-1.338379, 0.486424, 0.006410);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.207031, -0.974121, 0.095215);
 cgVertex3f(-1.338379, 0.486424, 0.006410);
 cgNormal3f(-0.629883, -0.505371, -0.590332);
 cgVertex3f(-1.346261, 0.485767, 0.012321);
 cgNormal3f(-0.687012, 0.400879, -0.605957);
 cgVertex3f(-1.347574, 0.499560, 0.012321);
 cgNormal3f(-0.308594, 0.438965, -0.844238);
 cgVertex3f(-1.339036, 0.499560, 0.006410);
 cgNormal3f(-0.597168, 0.599121, -0.533691);
 cgVertex3f(-1.339036, 0.494306, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.883301, 0.399902, -0.244141);
 cgVertex3f(-1.351515, 0.498246, 0.019546);
 cgNormal3f(-0.687012, 0.400879, -0.605957);
 cgVertex3f(-1.347574, 0.499560, 0.012321);
 cgNormal3f(-0.629883, -0.505371, -0.590332);
 cgVertex3f(-1.346261, 0.485767, 0.012321);
 cgNormal3f(-0.828613, -0.515137, -0.220703);
 cgVertex3f(-1.350858, 0.485767, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.833496, 0.428223, 0.349121);
 cgVertex3f(-1.351515, 0.498246, 0.028085);
 cgNormal3f(-0.883301, 0.399902, -0.244141);
 cgVertex3f(-1.351515, 0.498246, 0.019546);
 cgNormal3f(-0.828613, -0.515137, -0.220703);
 cgVertex3f(-1.350858, 0.485767, 0.019546);
 cgNormal3f(-0.761230, -0.526855, 0.378906);
 cgVertex3f(-1.350858, 0.485767, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.446289, 0.426270, 0.786621);
 cgVertex3f(-1.344290, 0.499560, 0.034653);
 cgNormal3f(-0.833496, 0.428223, 0.349121);
 cgVertex3f(-1.351515, 0.498246, 0.028085);
 cgNormal3f(-0.761230, -0.526855, 0.378906);
 cgVertex3f(-1.350858, 0.485767, 0.028085);
 cgNormal3f(-0.366211, -0.481934, 0.795898);
 cgVertex3f(-1.342977, 0.486424, 0.034653);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.234375, 0.430664, 0.871582);
 cgVertex3f(-1.335752, 0.499560, 0.036623);
 cgNormal3f(-0.446289, 0.426270, 0.786621);
 cgVertex3f(-1.344290, 0.499560, 0.034653);
 cgNormal3f(-0.366211, -0.481934, 0.795898);
 cgVertex3f(-1.342977, 0.486424, 0.034653);
 cgNormal3f(-0.159668, -0.457520, 0.874512);
 cgVertex3f(-1.334438, 0.486424, 0.036623);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.344238, 0.708984, 0.615234);
 cgVertex3f(-1.323273, 0.501530, 0.039250);
 cgNormal3f(-0.234375, 0.430664, 0.871582);
 cgVertex3f(-1.335752, 0.499560, 0.036623);
 cgNormal3f(-0.159668, -0.457520, 0.874512);
 cgVertex3f(-1.334438, 0.486424, 0.036623);
 cgNormal3f(-0.233887, -0.713867, 0.660156);
 cgVertex3f(-1.321959, 0.487738, 0.039250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.542969, 0.414062, 0.730469);
 cgVertex3f(-1.314734, 0.501530, 0.045818);
 cgNormal3f(-0.344238, 0.708984, 0.615234);
 cgVertex3f(-1.323273, 0.501530, 0.039250);
 cgNormal3f(-0.233887, -0.713867, 0.660156);
 cgVertex3f(-1.321959, 0.487738, 0.039250);
 cgNormal3f(-0.455566, -0.475098, 0.752441);
 cgVertex3f(-1.313421, 0.489051, 0.045818);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.379883, 0.434082, 0.816406);
 cgVertex3f(-1.306196, 0.502844, 0.051073);
 cgNormal3f(-0.542969, 0.414062, 0.730469);
 cgVertex3f(-1.314734, 0.501530, 0.045818);
 cgNormal3f(-0.455566, -0.475098, 0.752441);
 cgVertex3f(-1.313421, 0.489051, 0.045818);
 cgNormal3f(-0.307129, -0.461914, 0.832031);
 cgVertex3f(-1.304882, 0.489708, 0.051073);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.133301, 0.455078, 0.879883);
 cgVertex3f(-1.296344, 0.503501, 0.053700);
 cgNormal3f(-0.379883, 0.434082, 0.816406);
 cgVertex3f(-1.306196, 0.502844, 0.051073);
 cgNormal3f(-0.307129, -0.461914, 0.832031);
 cgVertex3f(-1.304882, 0.489708, 0.051073);
 cgNormal3f(-0.082031, -0.438965, 0.894531);
 cgVertex3f(-1.295030, 0.489708, 0.053700);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.043457, 0.728516, 0.683105);
 cgVertex3f(-1.291089, 0.503501, 0.053700);
 cgNormal3f(-0.133301, 0.455078, 0.879883);
 cgVertex3f(-1.296344, 0.503501, 0.053700);
 cgNormal3f(-0.082031, -0.438965, 0.894531);
 cgVertex3f(-1.295030, 0.489708, 0.053700);
 cgNormal3f(0.028320, -0.425781, 0.904297);
 cgVertex3f(-1.289776, 0.491022, 0.053700);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.270508, 0.436035, -0.858398);
 cgVertex3f(-1.298971, 0.496933, -0.074377);
 cgNormal3f(-0.035156, 0.441895, -0.896484);
 cgVertex3f(-1.290432, 0.498246, -0.074377);
 cgNormal3f(0.041016, -0.445312, -0.894531);
 cgVertex3f(-1.289776, 0.491022, -0.074377);
 cgNormal3f(-0.193359, -0.479004, -0.856445);
 cgVertex3f(-1.298314, 0.489708, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.713867, 0.408691, -0.568848);
 cgVertex3f(-1.308823, 0.496933, -0.068465);
 cgNormal3f(-0.270508, 0.436035, -0.858398);
 cgVertex3f(-1.298971, 0.496933, -0.074377);
 cgNormal3f(-0.193359, -0.479004, -0.856445);
 cgVertex3f(-1.298314, 0.489708, -0.074377);
 cgNormal3f(-0.638184, -0.524902, -0.563965);
 cgVertex3f(-1.308166, 0.489051, -0.068465);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.199219, 0.740723, 0.641113);
 cgVertex3f(-1.258906, 0.506785, 0.039907);
 cgNormal3f(0.683594, 0.582031, 0.439453);
 cgVertex3f(-1.266788, 0.505471, 0.028741);
 cgNormal3f(0.095215, 0.183105, 0.978027);
 cgVertex3f(-1.291089, 0.503501, 0.030055);
 cgNormal3f(-0.043457, 0.728516, 0.683105);
 cgVertex3f(-1.291089, 0.503501, 0.053700);
 cgNormal3f(0.050293, 0.461914, 0.885254);
 cgVertex3f(-1.285835, 0.504814, 0.053700);
 cgNormal3f(0.314941, 0.482422, 0.816895);
 cgVertex3f(-1.275983, 0.505471, 0.051729);
 cgNormal3f(0.469727, 0.486328, 0.736328);
 cgVertex3f(-1.267444, 0.505471, 0.045818);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.278809, -0.438477, -0.854492);
 cgVertex3f(-1.281237, 0.491678, -0.074377);
 cgNormal3f(0.699219, -0.402832, -0.590820);
 cgVertex3f(-1.271385, 0.491678, -0.068465);
 cgNormal3f(0.894043, -0.371094, -0.251465);
 cgVertex3f(-1.268101, 0.492992, -0.061241);
 cgNormal3f(0.705566, -0.657227, -0.265137);
 cgVertex3f(-1.266131, 0.492992, -0.046791);
 cgNormal3f(0.085938, -0.996582, 0.009766);
 cgVertex3f(-1.289776, 0.491022, -0.010010);
 cgNormal3f(-0.555664, -0.774902, -0.302246);
 cgVertex3f(-1.313421, 0.489051, -0.046791);
 cgNormal3f(-0.820801, -0.521484, -0.234375);
 cgVertex3f(-1.310793, 0.489051, -0.061241);
 cgNormal3f(-0.638184, -0.524902, -0.563965);
 cgVertex3f(-1.308166, 0.489051, -0.068465);
 cgNormal3f(-0.193359, -0.479004, -0.856445);
 cgVertex3f(-1.298314, 0.489708, -0.074377);
 cgNormal3f(0.041016, -0.445312, -0.894531);
 cgVertex3f(-1.289776, 0.491022, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.728516, 0.543457, 0.416504);
 cgVertex3f(1.272410, 0.273620, 0.019546);
 cgNormal3f(-0.709961, 0.549316, -0.441406);
 cgVertex3f(1.272410, 0.273620, 0.013635);
 cgNormal3f(-0.508301, 0.793457, -0.334961);
 cgVertex3f(1.271753, 0.260484, 0.013635);
 cgNormal3f(-0.526855, 0.788086, 0.317871);
 cgVertex3f(1.271753, 0.260484, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.068848, 0.516602, 0.853027);
 cgVertex3f(1.279635, 0.272963, 0.024144);
 cgNormal3f(-0.728516, 0.543457, 0.416504);
 cgVertex3f(1.272410, 0.273620, 0.019546);
 cgNormal3f(-0.526855, 0.788086, 0.317871);
 cgVertex3f(1.271753, 0.260484, 0.019546);
 cgNormal3f(0.082031, 0.768555, 0.633789);
 cgVertex3f(1.278321, 0.259827, 0.024144);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.812012, 0.434570, 0.388672);
 cgVertex3f(1.285546, 0.272306, 0.019546);
 cgNormal3f(0.068848, 0.516602, 0.853027);
 cgVertex3f(1.279635, 0.272963, 0.024144);
 cgNormal3f(0.082031, 0.768555, 0.633789);
 cgVertex3f(1.278321, 0.259827, 0.024144);
 cgNormal3f(0.647949, 0.701660, 0.294922);
 cgVertex3f(1.284889, 0.259170, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.794922, 0.442871, -0.414062);
 cgVertex3f(1.285546, 0.272306, 0.013635);
 cgNormal3f(0.812012, 0.434570, 0.388672);
 cgVertex3f(1.285546, 0.272306, 0.019546);
 cgNormal3f(0.647949, 0.701660, 0.294922);
 cgVertex3f(1.284889, 0.259170, 0.019546);
 cgNormal3f(0.631836, 0.708496, -0.312988);
 cgVertex3f(1.284889, 0.259170, 0.013635);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.066406, 0.499512, -0.863770);
 cgVertex3f(1.279635, 0.272963, 0.009694);
 cgNormal3f(0.794922, 0.442871, -0.414062);
 cgVertex3f(1.285546, 0.272306, 0.013635);
 cgNormal3f(0.631836, 0.708496, -0.312988);
 cgVertex3f(1.284889, 0.259170, 0.013635);
 cgNormal3f(0.082031, 0.754395, -0.651367);
 cgVertex3f(1.278321, 0.259827, 0.009694);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.709961, 0.549316, -0.441406);
 cgVertex3f(1.272410, 0.273620, 0.013635);
 cgNormal3f(0.066406, 0.499512, -0.863770);
 cgVertex3f(1.279635, 0.272963, 0.009694);
 cgNormal3f(0.082031, 0.754395, -0.651367);
 cgVertex3f(1.278321, 0.259827, 0.009694);
 cgNormal3f(-0.508301, 0.793457, -0.334961);
 cgVertex3f(1.271753, 0.260484, 0.013635);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.218750, 0.931641, 0.289551);
 cgVertex3f(1.262558, 0.261141, 0.005096);
 cgNormal3f(-0.508301, 0.793457, -0.334961);
 cgVertex3f(1.271753, 0.260484, 0.013635);
 cgNormal3f(0.082031, 0.754395, -0.651367);
 cgVertex3f(1.278321, 0.259827, 0.009694);
 cgNormal3f(0.080078, 0.891113, 0.446289);
 cgVertex3f(1.278321, 0.259827, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.526855, 0.788086, 0.317871);
 cgVertex3f(1.271753, 0.260484, 0.019546);
 cgNormal3f(-0.302246, 0.946289, 0.111816);
 cgVertex3f(1.254019, 0.261798, 0.028085);
 cgNormal3f(0.086426, 0.991699, -0.091797);
 cgVertex3f(1.278321, 0.259827, 0.030055);
 cgNormal3f(0.082031, 0.768555, 0.633789);
 cgVertex3f(1.278321, 0.259827, 0.024144);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.771973, 0.598145, -0.213379);
 cgVertex3f(1.302623, 0.257857, -0.015921);
 cgNormal3f(0.764648, 0.608887, -0.208984);
 cgVertex3f(1.293428, 0.258514, -0.015921);
 cgNormal3f(0.365723, 0.881836, 0.296875);
 cgVertex3f(1.293428, 0.258514, 0.005096);
 cgNormal3f(0.444336, 0.887207, 0.122559);
 cgVertex3f(1.301966, 0.257857, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.526855, 0.788086, 0.317871);
 cgVertex3f(1.271753, 0.260484, 0.019546);
 cgNormal3f(-0.508301, 0.793457, -0.334961);
 cgVertex3f(1.271753, 0.260484, 0.013635);
 cgNormal3f(-0.218750, 0.931641, 0.289551);
 cgVertex3f(1.262558, 0.261141, 0.005096);
 cgNormal3f(-0.302246, 0.946289, 0.111816);
 cgVertex3f(1.254019, 0.261798, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.444336, 0.887207, 0.122559);
 cgVertex3f(1.301966, 0.257857, 0.028741);
 cgNormal3f(0.647949, 0.701660, 0.294922);
 cgVertex3f(1.284889, 0.259170, 0.019546);
 cgNormal3f(0.082031, 0.768555, 0.633789);
 cgVertex3f(1.278321, 0.259827, 0.024144);
 cgNormal3f(0.086426, 0.991699, -0.091797);
 cgVertex3f(1.278321, 0.259827, 0.030055);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.812012, 0.434570, 0.388672);
 cgVertex3f(1.285546, 0.272306, 0.019546);
 cgNormal3f(0.794922, 0.442871, -0.414062);
 cgVertex3f(1.285546, 0.272306, 0.013635);
 cgNormal3f(0.066406, 0.499512, -0.863770);
 cgVertex3f(1.279635, 0.272963, 0.009694);
 cgNormal3f(-0.709961, 0.549316, -0.441406);
 cgVertex3f(1.272410, 0.273620, 0.013635);
 cgNormal3f(-0.728516, 0.543457, 0.416504);
 cgVertex3f(1.272410, 0.273620, 0.019546);
 cgNormal3f(0.068848, 0.516602, 0.853027);
 cgVertex3f(1.279635, 0.272963, 0.024144);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.603516, 0.562500, 0.564453);
 cgVertex3f(1.293428, 0.265082, 0.005096);
 cgNormal3f(0.365723, 0.881836, 0.296875);
 cgVertex3f(1.293428, 0.258514, 0.005096);
 cgNormal3f(0.764648, 0.608887, -0.208984);
 cgVertex3f(1.293428, 0.258514, -0.015921);
 cgNormal3f(0.758301, 0.637207, -0.137207);
 cgVertex3f(1.293428, 0.265082, -0.029714);
 cgNormal3f(0.731445, 0.681641, 0.000000);
 cgVertex3f(1.293428, 0.265082, -0.015921);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.716309, 0.584473, 0.381348);
 cgVertex3f(1.253363, 0.256543, 0.028085);
 cgNormal3f(-0.228027, 0.739746, 0.632812);
 cgVertex3f(1.245481, 0.257200, 0.039250);
 cgNormal3f(-0.475098, 0.479492, 0.737793);
 cgVertex3f(1.254019, 0.256543, 0.045818);
 cgNormal3f(-0.322754, 0.478516, 0.816406);
 cgVertex3f(1.262558, 0.255886, 0.051073);
 cgNormal3f(-0.083984, 0.465332, 0.880859);
 cgVertex3f(1.272410, 0.255230, 0.053700);
 cgNormal3f(0.070312, 0.694824, 0.715332);
 cgVertex3f(1.277664, 0.254573, 0.053700);
 cgNormal3f(0.073242, 0.069336, 0.994629);
 cgVertex3f(1.277664, 0.254573, 0.030055);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.280273, 0.447266, -0.849121);
 cgVertex3f(1.285546, 0.248005, -0.074377);
 cgNormal3f(0.699707, 0.414062, -0.581543);
 cgVertex3f(1.295398, 0.247348, -0.068465);
 cgNormal3f(0.633789, -0.507812, -0.583496);
 cgVertex3f(1.294741, 0.239466, -0.068465);
 cgNormal3f(0.213379, -0.472168, -0.855469);
 cgVertex3f(1.285546, 0.240780, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.038086, 0.445801, -0.894531);
 cgVertex3f(1.277664, 0.248662, -0.074377);
 cgNormal3f(0.280273, 0.447266, -0.849121);
 cgVertex3f(1.285546, 0.248005, -0.074377);
 cgNormal3f(0.213379, -0.472168, -0.855469);
 cgVertex3f(1.285546, 0.240780, -0.074377);
 cgNormal3f(-0.029297, -0.447266, -0.894531);
 cgVertex3f(1.277008, 0.241437, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.133789, 0.423828, 0.895508);
 cgVertex3f(1.282919, 0.253916, 0.053700);
 cgNormal3f(0.070312, 0.694824, 0.715332);
 cgVertex3f(1.277664, 0.254573, 0.053700);
 cgNormal3f(-0.040527, -0.452637, 0.890625);
 cgVertex3f(1.276351, 0.241437, 0.053700);
 cgNormal3f(0.048340, -0.463379, 0.884766);
 cgVertex3f(1.281605, 0.240780, 0.053700);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.385742, 0.404297, 0.828613);
 cgVertex3f(1.292771, 0.253259, 0.051729);
 cgNormal3f(0.133789, 0.423828, 0.895508);
 cgVertex3f(1.282919, 0.253916, 0.053700);
 cgNormal3f(0.048340, -0.463379, 0.884766);
 cgVertex3f(1.281605, 0.240780, 0.053700);
 cgNormal3f(0.309570, -0.494141, 0.812500);
 cgVertex3f(1.291457, 0.240123, 0.051729);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.541504, 0.382324, 0.748047);
 cgVertex3f(1.301309, 0.252602, 0.045818);
 cgNormal3f(0.385742, 0.404297, 0.828613);
 cgVertex3f(1.292771, 0.253259, 0.051729);
 cgNormal3f(0.309570, -0.494141, 0.812500);
 cgVertex3f(1.291457, 0.240123, 0.051729);
 cgNormal3f(0.471191, -0.501465, 0.725586);
 cgVertex3f(1.299996, 0.239466, 0.045818);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.338867, 0.670410, 0.659668);
 cgVertex3f(1.309848, 0.251946, 0.039907);
 cgNormal3f(0.541504, 0.382324, 0.748047);
 cgVertex3f(1.301309, 0.252602, 0.045818);
 cgNormal3f(0.471191, -0.501465, 0.725586);
 cgVertex3f(1.299996, 0.239466, 0.045818);
 cgNormal3f(0.201660, -0.740234, 0.641113);
 cgVertex3f(1.308534, 0.238809, 0.039907);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.228027, 0.425781, 0.875488);
 cgVertex3f(1.322327, 0.250632, 0.037280);
 cgNormal3f(0.338867, 0.670410, 0.659668);
 cgVertex3f(1.309848, 0.251946, 0.039907);
 cgNormal3f(0.201660, -0.740234, 0.641113);
 cgVertex3f(1.308534, 0.238809, 0.039907);
 cgNormal3f(0.136719, -0.458984, 0.877930);
 cgVertex3f(1.321013, 0.237496, 0.037280);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.446289, 0.428711, 0.784668);
 cgVertex3f(1.330865, 0.249975, 0.035309);
 cgNormal3f(0.228027, 0.425781, 0.875488);
 cgVertex3f(1.322327, 0.250632, 0.037280);
 cgNormal3f(0.136719, -0.458984, 0.877930);
 cgVertex3f(1.321013, 0.237496, 0.037280);
 cgNormal3f(0.356934, -0.481445, 0.800293);
 cgVertex3f(1.329552, 0.236839, 0.035309);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.819336, 0.426758, 0.381836);
 cgVertex3f(1.337433, 0.249318, 0.028741);
 cgNormal3f(0.446289, 0.428711, 0.784668);
 cgVertex3f(1.330865, 0.249975, 0.035309);
 cgNormal3f(0.356934, -0.481445, 0.800293);
 cgVertex3f(1.329552, 0.236839, 0.035309);
 cgNormal3f(0.750488, -0.520996, 0.406250);
 cgVertex3f(1.337433, 0.236182, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.883301, 0.410645, -0.225586);
 cgVertex3f(1.338747, 0.249318, 0.019546);
 cgNormal3f(0.819336, 0.426758, 0.381836);
 cgVertex3f(1.337433, 0.249318, 0.028741);
 cgNormal3f(0.750488, -0.520996, 0.406250);
 cgVertex3f(1.337433, 0.236182, 0.028741);
 cgNormal3f(0.817871, -0.530273, -0.223145);
 cgVertex3f(1.337433, 0.236182, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.685547, 0.401367, -0.606934);
 cgVertex3f(1.333493, 0.249975, 0.012321);
 cgNormal3f(0.883301, 0.410645, -0.225586);
 cgVertex3f(1.338747, 0.249318, 0.019546);
 cgNormal3f(0.817871, -0.530273, -0.223145);
 cgVertex3f(1.337433, 0.236182, 0.019546);
 cgNormal3f(0.607910, -0.507324, -0.610840);
 cgVertex3f(1.332836, 0.236182, 0.012321);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.325684, 0.444824, -0.834473);
 cgVertex3f(1.326268, 0.250632, 0.006410);
 cgNormal3f(0.685547, 0.401367, -0.606934);
 cgVertex3f(1.333493, 0.249975, 0.012321);
 cgNormal3f(0.607910, -0.507324, -0.610840);
 cgVertex3f(1.332836, 0.236182, 0.012321);
 cgNormal3f(0.179199, -0.982422, 0.051270);
 cgVertex3f(1.324954, 0.237496, 0.006410);
 cgNormal3f(0.610352, 0.588379, -0.529785);
 cgVertex3f(1.325611, 0.244721, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.521973, 0.419922, 0.741699);
 cgVertex3f(1.330865, 0.244721, 0.005096);
 cgNormal3f(0.610352, 0.588379, -0.529785);
 cgVertex3f(1.325611, 0.244721, 0.006410);
 cgNormal3f(0.179199, -0.982422, 0.051270);
 cgVertex3f(1.324954, 0.237496, 0.006410);
 cgNormal3f(0.434570, -0.510742, 0.741699);
 cgVertex3f(1.329552, 0.236839, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.856445, 0.428711, 0.286133);
 cgVertex3f(1.335463, 0.244064, -0.001472);
 cgNormal3f(0.521973, 0.419922, 0.741699);
 cgVertex3f(1.330865, 0.244721, 0.005096);
 cgNormal3f(0.434570, -0.510742, 0.741699);
 cgVertex3f(1.329552, 0.236839, 0.005096);
 cgNormal3f(0.806152, -0.510254, 0.298828);
 cgVertex3f(1.335463, 0.236182, -0.001472);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.879883, 0.417480, -0.226074);
 cgVertex3f(1.335463, 0.244064, -0.012637);
 cgNormal3f(0.856445, 0.428711, 0.286133);
 cgVertex3f(1.335463, 0.244064, -0.001472);
 cgNormal3f(0.806152, -0.510254, 0.298828);
 cgVertex3f(1.335463, 0.236182, -0.001472);
 cgNormal3f(0.831055, -0.503418, -0.236816);
 cgVertex3f(1.335463, 0.236182, -0.012637);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.703125, 0.388672, -0.595215);
 cgVertex3f(1.330865, 0.244721, -0.021832);
 cgNormal3f(0.879883, 0.417480, -0.226074);
 cgVertex3f(1.335463, 0.244064, -0.012637);
 cgNormal3f(0.831055, -0.503418, -0.236816);
 cgVertex3f(1.335463, 0.236182, -0.012637);
 cgNormal3f(0.615234, -0.519043, -0.593262);
 cgVertex3f(1.329552, 0.236839, -0.021832);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.530273, 0.403320, -0.745605);
 cgVertex3f(1.319043, 0.245378, -0.030371);
 cgNormal3f(0.703125, 0.388672, -0.595215);
 cgVertex3f(1.330865, 0.244721, -0.021832);
 cgNormal3f(0.615234, -0.519043, -0.593262);
 cgVertex3f(1.329552, 0.236839, -0.021832);
 cgNormal3f(0.447754, -0.489258, -0.748535);
 cgVertex3f(1.318386, 0.237496, -0.030371);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.523438, 0.684570, -0.506836);
 cgVertex3f(1.306564, 0.246691, -0.037596);
 cgNormal3f(0.530273, 0.403320, -0.745605);
 cgVertex3f(1.319043, 0.245378, -0.030371);
 cgNormal3f(0.447754, -0.489258, -0.748535);
 cgVertex3f(1.318386, 0.237496, -0.030371);
 cgNormal3f(0.296875, -0.859863, -0.416016);
 cgVertex3f(1.306564, 0.238809, -0.037596);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.696289, 0.675781, -0.241211);
 cgVertex3f(1.300653, 0.246691, -0.046791);
 cgNormal3f(0.523438, 0.684570, -0.506836);
 cgVertex3f(1.306564, 0.246691, -0.037596);
 cgNormal3f(0.296875, -0.859863, -0.416016);
 cgVertex3f(1.306564, 0.238809, -0.037596);
 cgNormal3f(0.596191, -0.762207, -0.252441);
 cgVertex3f(1.299996, 0.239466, -0.046791);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.730469, 0.657715, -0.183105);
 cgVertex3f(1.298682, 0.247348, -0.061241);
 cgNormal3f(0.696289, 0.675781, -0.241211);
 cgVertex3f(1.300653, 0.246691, -0.046791);
 cgNormal3f(0.596191, -0.762207, -0.252441);
 cgVertex3f(1.299996, 0.239466, -0.046791);
 cgNormal3f(0.818848, -0.519043, -0.244629);
 cgVertex3f(1.298025, 0.239466, -0.061241);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.699707, 0.414062, -0.581543);
 cgVertex3f(1.295398, 0.247348, -0.068465);
 cgNormal3f(0.730469, 0.657715, -0.183105);
 cgVertex3f(1.298682, 0.247348, -0.061241);
 cgNormal3f(0.818848, -0.519043, -0.244629);
 cgVertex3f(1.298025, 0.239466, -0.061241);
 cgNormal3f(0.633789, -0.507812, -0.583496);
 cgVertex3f(1.294741, 0.239466, -0.068465);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.626465, 0.514648, -0.584961);
 cgVertex3f(1.301309, 0.246691, 0.006410);
 cgNormal3f(0.610352, 0.588379, -0.529785);
 cgVertex3f(1.325611, 0.244721, 0.006410);
 cgNormal3f(0.521973, 0.419922, 0.741699);
 cgVertex3f(1.330865, 0.244721, 0.005096);
 cgNormal3f(0.856445, 0.428711, 0.286133);
 cgVertex3f(1.335463, 0.244064, -0.001472);
 cgNormal3f(0.879883, 0.417480, -0.226074);
 cgVertex3f(1.335463, 0.244064, -0.012637);
 cgNormal3f(0.703125, 0.388672, -0.595215);
 cgVertex3f(1.330865, 0.244721, -0.021832);
 cgNormal3f(0.530273, 0.403320, -0.745605);
 cgVertex3f(1.319043, 0.245378, -0.030371);
 cgNormal3f(0.523438, 0.684570, -0.506836);
 cgVertex3f(1.306564, 0.246691, -0.037596);
 cgNormal3f(0.420898, 0.859375, -0.289551);
 cgVertex3f(1.301309, 0.246691, -0.027087);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.696289, 0.675781, -0.241211);
 cgVertex3f(1.300653, 0.246691, -0.046791);
 cgNormal3f(0.333984, 0.914551, -0.227051);
 cgVertex3f(1.291457, 0.247348, -0.050732);
 cgNormal3f(0.553711, 0.720215, -0.416992);
 cgVertex3f(1.291457, 0.247348, -0.027744);
 cgNormal3f(0.420898, 0.859375, -0.289551);
 cgVertex3f(1.301309, 0.246691, -0.027087);
 cgNormal3f(0.523438, 0.684570, -0.506836);
 cgVertex3f(1.306564, 0.246691, -0.037596);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.730469, 0.657715, -0.183105);
 cgVertex3f(1.298682, 0.247348, -0.061241);
 cgNormal3f(0.333984, 0.914551, -0.227051);
 cgVertex3f(1.291457, 0.247348, -0.050732);
 cgNormal3f(0.696289, 0.675781, -0.241211);
 cgVertex3f(1.300653, 0.246691, -0.046791);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.446289, 0.428711, 0.784668);
 cgVertex3f(1.330865, 0.249975, 0.035309);
 cgNormal3f(0.819336, 0.426758, 0.381836);
 cgVertex3f(1.337433, 0.249318, 0.028741);
 cgNormal3f(0.883301, 0.410645, -0.225586);
 cgVertex3f(1.338747, 0.249318, 0.019546);
 cgNormal3f(0.685547, 0.401367, -0.606934);
 cgVertex3f(1.333493, 0.249975, 0.012321);
 cgNormal3f(0.325684, 0.444824, -0.834473);
 cgVertex3f(1.326268, 0.250632, 0.006410);
 cgNormal3f(0.848145, 0.342285, -0.403809);
 cgVertex3f(1.301966, 0.252602, 0.006410);
 cgNormal3f(0.787598, 0.439453, 0.430664);
 cgVertex3f(1.301966, 0.252602, 0.028741);
 cgNormal3f(0.338867, 0.670410, 0.659668);
 cgVertex3f(1.309848, 0.251946, 0.039907);
 cgNormal3f(0.228027, 0.425781, 0.875488);
 cgVertex3f(1.322327, 0.250632, 0.037280);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.325684, 0.444824, -0.834473);
 cgVertex3f(1.326268, 0.250632, 0.006410);
 cgNormal3f(0.610352, 0.588379, -0.529785);
 cgVertex3f(1.325611, 0.244721, 0.006410);
 cgNormal3f(0.626465, 0.514648, -0.584961);
 cgVertex3f(1.301309, 0.246691, 0.006410);
 cgNormal3f(0.848145, 0.342285, -0.403809);
 cgVertex3f(1.301966, 0.252602, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.444336, 0.887207, 0.122559);
 cgVertex3f(1.301966, 0.257857, 0.028741);
 cgNormal3f(0.365723, 0.881836, 0.296875);
 cgVertex3f(1.293428, 0.258514, 0.005096);
 cgNormal3f(0.631836, 0.708496, -0.312988);
 cgVertex3f(1.284889, 0.259170, 0.013635);
 cgNormal3f(0.647949, 0.701660, 0.294922);
 cgVertex3f(1.284889, 0.259170, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.444336, 0.887207, 0.122559);
 cgVertex3f(1.301966, 0.257857, 0.028741);
 cgNormal3f(0.787598, 0.439453, 0.430664);
 cgVertex3f(1.301966, 0.252602, 0.028741);
 cgNormal3f(0.848145, 0.342285, -0.403809);
 cgVertex3f(1.301966, 0.252602, 0.006410);
 cgNormal3f(0.771973, 0.598145, -0.213379);
 cgVertex3f(1.302623, 0.257857, -0.015921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.755859, 0.413086, -0.507812);
 cgVertex3f(1.292771, 0.253259, -0.023146);
 cgNormal3f(0.507812, 0.576660, -0.640137);
 cgVertex3f(1.301966, 0.252602, -0.023146);
 cgNormal3f(0.420898, 0.859375, -0.289551);
 cgVertex3f(1.301309, 0.246691, -0.027087);
 cgNormal3f(0.553711, 0.720215, -0.416992);
 cgVertex3f(1.291457, 0.247348, -0.027744);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.752930, 0.383301, -0.534668);
 cgVertex3f(1.292771, 0.255886, -0.045477);
 cgNormal3f(0.755859, 0.413086, -0.507812);
 cgVertex3f(1.292771, 0.253259, -0.023146);
 cgNormal3f(0.553711, 0.720215, -0.416992);
 cgVertex3f(1.291457, 0.247348, -0.027744);
 cgNormal3f(0.333984, 0.914551, -0.227051);
 cgVertex3f(1.291457, 0.247348, -0.050732);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.021973, -0.300781, 0.953125);
 cgVertex3f(1.278321, 0.258514, 0.041877);
 cgNormal3f(0.284180, -0.043945, 0.957520);
 cgVertex3f(1.285546, 0.257857, 0.041221);
 cgNormal3f(0.324707, 0.780273, 0.534180);
 cgVertex3f(1.285546, 0.262454, 0.038593);
 cgNormal3f(0.084961, 0.959473, 0.267578);
 cgVertex3f(1.278321, 0.263111, 0.039250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.764648, 0.608887, -0.208984);
 cgVertex3f(1.293428, 0.258514, -0.015921);
 cgNormal3f(0.771973, 0.598145, -0.213379);
 cgVertex3f(1.302623, 0.257857, -0.015921);
 cgNormal3f(0.507812, 0.576660, -0.640137);
 cgVertex3f(1.301966, 0.252602, -0.023146);
 cgNormal3f(0.755859, 0.413086, -0.507812);
 cgVertex3f(1.292771, 0.253259, -0.023146);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.626465, 0.514648, -0.584961);
 cgVertex3f(1.301309, 0.246691, 0.006410);
 cgNormal3f(0.420898, 0.859375, -0.289551);
 cgVertex3f(1.301309, 0.246691, -0.027087);
 cgNormal3f(0.507812, 0.576660, -0.640137);
 cgVertex3f(1.301966, 0.252602, -0.023146);
 cgNormal3f(0.771973, 0.598145, -0.213379);
 cgVertex3f(1.302623, 0.257857, -0.015921);
 cgNormal3f(0.848145, 0.342285, -0.403809);
 cgVertex3f(1.301966, 0.252602, 0.006410);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.755859, 0.413086, -0.507812);
 cgVertex3f(1.292771, 0.253259, -0.023146);
 cgNormal3f(0.752930, 0.383301, -0.534668);
 cgVertex3f(1.292771, 0.255886, -0.045477);
 cgNormal3f(0.518555, 0.719727, -0.461426);
 cgVertex3f(1.293428, 0.261141, -0.038909);
 cgNormal3f(0.758301, 0.637207, -0.137207);
 cgVertex3f(1.293428, 0.265082, -0.029714);
 cgNormal3f(0.764648, 0.608887, -0.208984);
 cgVertex3f(1.293428, 0.258514, -0.015921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.389160, -0.539551, 0.746582);
 cgVertex3f(1.296055, 0.253916, 0.034653);
 cgNormal3f(-0.081543, -0.947754, 0.308105);
 cgVertex3f(1.277664, 0.255886, 0.035966);
 cgNormal3f(0.073242, 0.069336, 0.994629);
 cgVertex3f(1.277664, 0.254573, 0.030055);
 cgNormal3f(0.787598, 0.439453, 0.430664);
 cgVertex3f(1.301966, 0.252602, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.489258, 0.815430, 0.307617);
 cgVertex3f(1.296712, 0.259170, 0.033339);
 cgNormal3f(0.389160, -0.539551, 0.746582);
 cgVertex3f(1.296055, 0.253916, 0.034653);
 cgNormal3f(0.787598, 0.439453, 0.430664);
 cgVertex3f(1.301966, 0.252602, 0.028741);
 cgNormal3f(0.444336, 0.887207, 0.122559);
 cgVertex3f(1.301966, 0.257857, 0.028741);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.081055, 0.937500, -0.337891);
 cgVertex3f(1.278321, 0.260484, 0.034653);
 cgNormal3f(0.489258, 0.815430, 0.307617);
 cgVertex3f(1.296712, 0.259170, 0.033339);
 cgNormal3f(0.444336, 0.887207, 0.122559);
 cgVertex3f(1.301966, 0.257857, 0.028741);
 cgNormal3f(0.086426, 0.991699, -0.091797);
 cgVertex3f(1.278321, 0.259827, 0.030055);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.284180, -0.043945, 0.957520);
 cgVertex3f(1.285546, 0.257857, 0.041221);
 cgNormal3f(-0.021973, -0.300781, 0.953125);
 cgVertex3f(1.278321, 0.258514, 0.041877);
 cgNormal3f(-0.081543, -0.947754, 0.308105);
 cgVertex3f(1.277664, 0.255886, 0.035966);
 cgNormal3f(0.389160, -0.539551, 0.746582);
 cgVertex3f(1.296055, 0.253916, 0.034653);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.324707, 0.780273, 0.534180);
 cgVertex3f(1.285546, 0.262454, 0.038593);
 cgNormal3f(0.284180, -0.043945, 0.957520);
 cgVertex3f(1.285546, 0.257857, 0.041221);
 cgNormal3f(0.389160, -0.539551, 0.746582);
 cgVertex3f(1.296055, 0.253916, 0.034653);
 cgNormal3f(0.489258, 0.815430, 0.307617);
 cgVertex3f(1.296712, 0.259170, 0.033339);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.084961, 0.959473, 0.267578);
 cgVertex3f(1.278321, 0.263111, 0.039250);
 cgNormal3f(0.324707, 0.780273, 0.534180);
 cgVertex3f(1.285546, 0.262454, 0.038593);
 cgNormal3f(0.489258, 0.815430, 0.307617);
 cgVertex3f(1.296712, 0.259170, 0.033339);
 cgNormal3f(0.081055, 0.937500, -0.337891);
 cgVertex3f(1.278321, 0.260484, 0.034653);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.201660, -0.740234, 0.641113);
 cgVertex3f(1.308534, 0.238809, 0.039907);
 cgNormal3f(0.179199, -0.982422, 0.051270);
 cgVertex3f(1.324954, 0.237496, 0.006410);
 cgNormal3f(0.607910, -0.507324, -0.610840);
 cgVertex3f(1.332836, 0.236182, 0.012321);
 cgNormal3f(0.817871, -0.530273, -0.223145);
 cgVertex3f(1.337433, 0.236182, 0.019546);
 cgNormal3f(0.750488, -0.520996, 0.406250);
 cgVertex3f(1.337433, 0.236182, 0.028741);
 cgNormal3f(0.356934, -0.481445, 0.800293);
 cgVertex3f(1.329552, 0.236839, 0.035309);
 cgNormal3f(0.136719, -0.458984, 0.877930);
 cgVertex3f(1.321013, 0.237496, 0.037280);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.615234, -0.519043, -0.593262);
 cgVertex3f(1.329552, 0.236839, -0.021832);
 cgNormal3f(0.831055, -0.503418, -0.236816);
 cgVertex3f(1.335463, 0.236182, -0.012637);
 cgNormal3f(0.806152, -0.510254, 0.298828);
 cgVertex3f(1.335463, 0.236182, -0.001472);
 cgNormal3f(0.434570, -0.510742, 0.741699);
 cgVertex3f(1.329552, 0.236839, 0.005096);
 cgNormal3f(0.179199, -0.982422, 0.051270);
 cgVertex3f(1.324954, 0.237496, 0.006410);
 cgNormal3f(0.296875, -0.859863, -0.416016);
 cgVertex3f(1.306564, 0.238809, -0.037596);
 cgNormal3f(0.447754, -0.489258, -0.748535);
 cgVertex3f(1.318386, 0.237496, -0.030371);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.296875, -0.859863, -0.416016);
 cgVertex3f(1.306564, 0.238809, -0.037596);
 cgNormal3f(-0.071289, -0.997559, -0.018555);
 cgVertex3f(1.276351, 0.241437, -0.010010);
 cgNormal3f(0.596191, -0.762207, -0.252441);
 cgVertex3f(1.299996, 0.239466, -0.046791);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.431641, -0.801270, -0.415039);
 cgVertex3f(1.246795, 0.243407, -0.038253);
 cgNormal3f(-0.685547, -0.671875, -0.281738);
 cgVertex3f(1.253363, 0.243407, -0.046791);
 cgNormal3f(-0.071289, -0.997559, -0.018555);
 cgVertex3f(1.276351, 0.241437, -0.010010);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.309570, -0.494141, 0.812500);
 cgVertex3f(1.291457, 0.240123, 0.051729);
 cgNormal3f(0.048340, -0.463379, 0.884766);
 cgVertex3f(1.281605, 0.240780, 0.053700);
 cgNormal3f(-0.040527, -0.452637, 0.890625);
 cgVertex3f(1.276351, 0.241437, 0.053700);
 cgNormal3f(-0.166016, -0.444336, 0.880371);
 cgVertex3f(1.270440, 0.241437, 0.053700);
 cgNormal3f(-0.402832, -0.430176, 0.808105);
 cgVertex3f(1.261901, 0.242750, 0.051073);
 cgNormal3f(-0.548340, -0.422363, 0.721680);
 cgVertex3f(1.253363, 0.243407, 0.045818);
 cgNormal3f(-0.349121, -0.698730, 0.624512);
 cgVertex3f(1.244824, 0.244064, 0.039250);
 cgNormal3f(-0.338379, -0.939941, 0.045410);
 cgVertex3f(1.228404, 0.245378, 0.006410);
 cgNormal3f(-0.431641, -0.801270, -0.415039);
 cgVertex3f(1.246795, 0.243407, -0.038253);
 cgNormal3f(-0.071289, -0.997559, -0.018555);
 cgVertex3f(1.276351, 0.241437, -0.010010);
 cgNormal3f(0.296875, -0.859863, -0.416016);
 cgVertex3f(1.306564, 0.238809, -0.037596);
 cgNormal3f(0.179199, -0.982422, 0.051270);
 cgVertex3f(1.324954, 0.237496, 0.006410);
 cgNormal3f(0.201660, -0.740234, 0.641113);
 cgVertex3f(1.308534, 0.238809, 0.039907);
 cgNormal3f(0.471191, -0.501465, 0.725586);
 cgVertex3f(1.299996, 0.239466, 0.045818);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.431641, -0.801270, -0.415039);
 cgVertex3f(1.246795, 0.243407, -0.038253);
 cgNormal3f(-0.338379, -0.939941, 0.045410);
 cgVertex3f(1.228404, 0.245378, 0.006410);
 cgNormal3f(-0.539551, -0.409668, 0.735352);
 cgVertex3f(1.222493, 0.246034, 0.005096);
 cgNormal3f(-0.885742, -0.375488, 0.274414);
 cgVertex3f(1.217895, 0.246034, -0.002128);
 cgNormal3f(-0.891602, -0.390137, -0.231934);
 cgVertex3f(1.217895, 0.246034, -0.013294);
 cgNormal3f(-0.690918, -0.393555, -0.607422);
 cgVertex3f(1.222493, 0.245378, -0.021832);
 cgNormal3f(-0.545898, -0.398926, -0.737305);
 cgVertex3f(1.234972, 0.244721, -0.030371);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.455566, -0.412109, 0.789062);
 cgVertex3f(1.222493, 0.246034, 0.034653);
 cgNormal3f(-0.848145, -0.394531, 0.353516);
 cgVertex3f(1.215925, 0.246034, 0.028085);
 cgNormal3f(-0.892578, -0.388184, -0.230957);
 cgVertex3f(1.215925, 0.246034, 0.019546);
 cgNormal3f(-0.685059, -0.412109, -0.601562);
 cgVertex3f(1.220523, 0.246034, 0.012321);
 cgNormal3f(-0.338379, -0.939941, 0.045410);
 cgVertex3f(1.228404, 0.245378, 0.006410);
 cgNormal3f(-0.349121, -0.698730, 0.624512);
 cgVertex3f(1.244824, 0.244064, 0.039250);
 cgNormal3f(-0.223145, -0.428711, 0.875488);
 cgVertex3f(1.231688, 0.244721, 0.036623);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.189941, 0.815430, 0.546387);
 cgVertex3f(1.270440, 0.263768, 0.038593);
 cgNormal3f(0.084961, 0.959473, 0.267578);
 cgVertex3f(1.278321, 0.263111, 0.039250);
 cgNormal3f(0.081055, 0.937500, -0.337891);
 cgVertex3f(1.278321, 0.260484, 0.034653);
 cgNormal3f(-0.359863, 0.884766, 0.295410);
 cgVertex3f(1.259931, 0.262454, 0.033339);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.289062, -0.011719, 0.957031);
 cgVertex3f(1.269783, 0.259170, 0.041221);
 cgNormal3f(-0.189941, 0.815430, 0.546387);
 cgVertex3f(1.270440, 0.263768, 0.038593);
 cgNormal3f(-0.359863, 0.884766, 0.295410);
 cgVertex3f(1.259931, 0.262454, 0.033339);
 cgNormal3f(-0.489746, -0.468262, 0.735840);
 cgVertex3f(1.259274, 0.257200, 0.034653);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.021973, -0.300781, 0.953125);
 cgVertex3f(1.278321, 0.258514, 0.041877);
 cgNormal3f(-0.289062, -0.011719, 0.957031);
 cgVertex3f(1.269783, 0.259170, 0.041221);
 cgNormal3f(-0.489746, -0.468262, 0.735840);
 cgVertex3f(1.259274, 0.257200, 0.034653);
 cgNormal3f(-0.081543, -0.947754, 0.308105);
 cgVertex3f(1.277664, 0.255886, 0.035966);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.359863, 0.884766, 0.295410);
 cgVertex3f(1.259931, 0.262454, 0.033339);
 cgNormal3f(0.081055, 0.937500, -0.337891);
 cgVertex3f(1.278321, 0.260484, 0.034653);
 cgNormal3f(0.086426, 0.991699, -0.091797);
 cgVertex3f(1.278321, 0.259827, 0.030055);
 cgNormal3f(-0.302246, 0.946289, 0.111816);
 cgVertex3f(1.254019, 0.261798, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.489746, -0.468262, 0.735840);
 cgVertex3f(1.259274, 0.257200, 0.034653);
 cgNormal3f(-0.359863, 0.884766, 0.295410);
 cgVertex3f(1.259931, 0.262454, 0.033339);
 cgNormal3f(-0.302246, 0.946289, 0.111816);
 cgVertex3f(1.254019, 0.261798, 0.028085);
 cgNormal3f(-0.716309, 0.584473, 0.381348);
 cgVertex3f(1.253363, 0.256543, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.081543, -0.947754, 0.308105);
 cgVertex3f(1.277664, 0.255886, 0.035966);
 cgNormal3f(-0.489746, -0.468262, 0.735840);
 cgVertex3f(1.259274, 0.257200, 0.034653);
 cgNormal3f(-0.716309, 0.584473, 0.381348);
 cgVertex3f(1.253363, 0.256543, 0.028085);
 cgNormal3f(0.073242, 0.069336, 0.994629);
 cgVertex3f(1.277664, 0.254573, 0.030055);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.082031, 0.754395, -0.651367);
 cgVertex3f(1.278321, 0.259827, 0.009694);
 cgNormal3f(0.631836, 0.708496, -0.312988);
 cgVertex3f(1.284889, 0.259170, 0.013635);
 cgNormal3f(0.365723, 0.881836, 0.296875);
 cgVertex3f(1.293428, 0.258514, 0.005096);
 cgNormal3f(0.080078, 0.891113, 0.446289);
 cgVertex3f(1.278321, 0.259827, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.633301, 0.761230, -0.138672);
 cgVertex3f(1.263872, 0.267709, -0.029714);
 cgNormal3f(0.758301, 0.637207, -0.137207);
 cgVertex3f(1.293428, 0.265082, -0.029714);
 cgNormal3f(0.518555, 0.719727, -0.461426);
 cgVertex3f(1.293428, 0.261141, -0.038909);
 cgNormal3f(-0.382324, 0.800781, -0.461426);
 cgVertex3f(1.262558, 0.263768, -0.038909);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.633301, 0.761230, -0.138672);
 cgVertex3f(1.263872, 0.267709, -0.029714);
 cgNormal3f(-0.647461, 0.733398, -0.207031);
 cgVertex3f(1.262558, 0.261141, -0.015921);
 cgNormal3f(-0.218750, 0.931641, 0.289551);
 cgVertex3f(1.262558, 0.261141, 0.005096);
 cgNormal3f(-0.504883, 0.661621, 0.554199);
 cgVertex3f(1.263872, 0.267709, 0.005096);
 cgNormal3f(-0.606445, 0.794922, 0.000000);
 cgVertex3f(1.263872, 0.267709, -0.015921);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.365723, 0.881836, 0.296875);
 cgVertex3f(1.293428, 0.258514, 0.005096);
 cgNormal3f(0.603516, 0.562500, 0.564453);
 cgVertex3f(1.293428, 0.265082, 0.005096);
 cgNormal3f(-0.504883, 0.661621, 0.554199);
 cgVertex3f(1.263872, 0.267709, 0.005096);
 cgNormal3f(-0.218750, 0.931641, 0.289551);
 cgVertex3f(1.262558, 0.261141, 0.005096);
 cgNormal3f(0.080078, 0.891113, 0.446289);
 cgVertex3f(1.278321, 0.259827, 0.005096);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.504883, 0.661621, 0.554199);
 cgVertex3f(1.263872, 0.267709, 0.005096);
 cgNormal3f(0.603516, 0.562500, 0.564453);
 cgVertex3f(1.293428, 0.265082, 0.005096);
 cgNormal3f(0.731445, 0.681641, 0.000000);
 cgVertex3f(1.293428, 0.265082, -0.015921);
 cgNormal3f(0.758301, 0.637207, -0.137207);
 cgVertex3f(1.293428, 0.265082, -0.029714);
 cgNormal3f(-0.633301, 0.761230, -0.138672);
 cgVertex3f(1.263872, 0.267709, -0.029714);
 cgNormal3f(-0.606445, 0.794922, 0.000000);
 cgVertex3f(1.263872, 0.267709, -0.015921);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.395508, 0.665527, -0.633301);
 cgVertex3f(1.254019, 0.256543, -0.023146);
 cgNormal3f(-0.270020, 0.914551, -0.300781);
 cgVertex3f(1.253363, 0.250632, -0.027744);
 cgNormal3f(-0.512695, 0.601562, -0.612793);
 cgVertex3f(1.253363, 0.250632, 0.006410);
 cgNormal3f(-0.766113, 0.483398, -0.424316);
 cgVertex3f(1.253363, 0.256543, 0.006410);
 cgNormal3f(-0.661621, 0.714844, -0.226074);
 cgVertex3f(1.254019, 0.261798, -0.015921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.382324, 0.800781, -0.461426);
 cgVertex3f(1.262558, 0.263768, -0.038909);
 cgNormal3f(0.518555, 0.719727, -0.461426);
 cgVertex3f(1.293428, 0.261141, -0.038909);
 cgNormal3f(0.752930, 0.383301, -0.534668);
 cgVertex3f(1.292771, 0.255886, -0.045477);
 cgNormal3f(-0.680176, 0.500488, -0.535645);
 cgVertex3f(1.262558, 0.258514, -0.045477);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.647461, 0.733398, -0.207031);
 cgVertex3f(1.262558, 0.261141, -0.015921);
 cgNormal3f(-0.633301, 0.761230, -0.138672);
 cgVertex3f(1.263872, 0.267709, -0.029714);
 cgNormal3f(-0.382324, 0.800781, -0.461426);
 cgVertex3f(1.262558, 0.263768, -0.038909);
 cgNormal3f(-0.680176, 0.500488, -0.535645);
 cgVertex3f(1.262558, 0.258514, -0.045477);
 cgNormal3f(-0.678711, 0.541504, -0.496094);
 cgVertex3f(1.262558, 0.255886, -0.023146);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.661621, 0.714844, -0.226074);
 cgVertex3f(1.254019, 0.261798, -0.015921);
 cgNormal3f(-0.647461, 0.733398, -0.207031);
 cgVertex3f(1.262558, 0.261141, -0.015921);
 cgNormal3f(-0.678711, 0.541504, -0.496094);
 cgVertex3f(1.262558, 0.255886, -0.023146);
 cgNormal3f(-0.395508, 0.665527, -0.633301);
 cgVertex3f(1.254019, 0.256543, -0.023146);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.289062, -0.011719, 0.957031);
 cgVertex3f(1.269783, 0.259170, 0.041221);
 cgNormal3f(-0.021973, -0.300781, 0.953125);
 cgVertex3f(1.278321, 0.258514, 0.041877);
 cgNormal3f(0.084961, 0.959473, 0.267578);
 cgVertex3f(1.278321, 0.263111, 0.039250);
 cgNormal3f(-0.189941, 0.815430, 0.546387);
 cgVertex3f(1.270440, 0.263768, 0.038593);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.678711, 0.541504, -0.496094);
 cgVertex3f(1.262558, 0.255886, -0.023146);
 cgNormal3f(-0.680176, 0.500488, -0.535645);
 cgVertex3f(1.262558, 0.258514, -0.045477);
 cgNormal3f(-0.192871, 0.954102, -0.229004);
 cgVertex3f(1.262558, 0.249975, -0.050732);
 cgNormal3f(-0.439941, 0.806152, -0.395996);
 cgVertex3f(1.262558, 0.249975, -0.027744);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.395508, 0.665527, -0.633301);
 cgVertex3f(1.254019, 0.256543, -0.023146);
 cgNormal3f(-0.678711, 0.541504, -0.496094);
 cgVertex3f(1.262558, 0.255886, -0.023146);
 cgNormal3f(-0.439941, 0.806152, -0.395996);
 cgVertex3f(1.262558, 0.249975, -0.027744);
 cgNormal3f(-0.270020, 0.914551, -0.300781);
 cgVertex3f(1.253363, 0.250632, -0.027744);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.716309, 0.584473, 0.381348);
 cgVertex3f(1.253363, 0.256543, 0.028085);
 cgNormal3f(-0.302246, 0.946289, 0.111816);
 cgVertex3f(1.254019, 0.261798, 0.028085);
 cgNormal3f(-0.661621, 0.714844, -0.226074);
 cgVertex3f(1.254019, 0.261798, -0.015921);
 cgNormal3f(-0.766113, 0.483398, -0.424316);
 cgVertex3f(1.253363, 0.256543, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.333984, 0.914551, -0.227051);
 cgVertex3f(1.291457, 0.247348, -0.050732);
 cgNormal3f(-0.192871, 0.954102, -0.229004);
 cgVertex3f(1.262558, 0.249975, -0.050732);
 cgNormal3f(-0.680176, 0.500488, -0.535645);
 cgVertex3f(1.262558, 0.258514, -0.045477);
 cgNormal3f(0.752930, 0.383301, -0.534668);
 cgVertex3f(1.292771, 0.255886, -0.045477);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.647461, 0.733398, -0.207031);
 cgVertex3f(1.262558, 0.261141, -0.015921);
 cgNormal3f(-0.661621, 0.714844, -0.226074);
 cgVertex3f(1.254019, 0.261798, -0.015921);
 cgNormal3f(-0.302246, 0.946289, 0.111816);
 cgVertex3f(1.254019, 0.261798, 0.028085);
 cgNormal3f(-0.218750, 0.931641, 0.289551);
 cgVertex3f(1.262558, 0.261141, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.467285, 0.670898, -0.575684);
 cgVertex3f(1.229061, 0.253259, 0.006410);
 cgNormal3f(-0.222656, 0.477051, -0.850098);
 cgVertex3f(1.229718, 0.258514, 0.006410);
 cgNormal3f(-0.766113, 0.483398, -0.424316);
 cgVertex3f(1.253363, 0.256543, 0.006410);
 cgNormal3f(-0.512695, 0.601562, -0.612793);
 cgVertex3f(1.253363, 0.250632, 0.006410);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.228027, 0.739746, 0.632812);
 cgVertex3f(1.245481, 0.257200, 0.039250);
 cgNormal3f(-0.716309, 0.584473, 0.381348);
 cgVertex3f(1.253363, 0.256543, 0.028085);
 cgNormal3f(-0.766113, 0.483398, -0.424316);
 cgVertex3f(1.253363, 0.256543, 0.006410);
 cgNormal3f(-0.222656, 0.477051, -0.850098);
 cgVertex3f(1.229718, 0.258514, 0.006410);
 cgNormal3f(-0.613281, 0.498535, -0.612793);
 cgVertex3f(1.220523, 0.259170, 0.012321);
 cgNormal3f(-0.813477, 0.531738, -0.236816);
 cgVertex3f(1.217239, 0.259827, 0.019546);
 cgNormal3f(-0.755859, 0.558105, 0.341797);
 cgVertex3f(1.217239, 0.259827, 0.028085);
 cgNormal3f(-0.375000, 0.505371, 0.776855);
 cgVertex3f(1.224463, 0.259170, 0.034653);
 cgNormal3f(-0.148438, 0.462402, 0.874023);
 cgVertex3f(1.233002, 0.258514, 0.036623);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.614258, 0.765625, -0.190918);
 cgVertex3f(1.255990, 0.250632, -0.061241);
 cgNormal3f(-0.580078, 0.770508, -0.264160);
 cgVertex3f(1.254019, 0.250632, -0.046791);
 cgNormal3f(-0.192871, 0.954102, -0.229004);
 cgVertex3f(1.262558, 0.249975, -0.050732);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.439941, 0.806152, -0.395996);
 cgVertex3f(1.262558, 0.249975, -0.027744);
 cgNormal3f(-0.192871, 0.954102, -0.229004);
 cgVertex3f(1.262558, 0.249975, -0.050732);
 cgNormal3f(-0.580078, 0.770508, -0.264160);
 cgVertex3f(1.254019, 0.250632, -0.046791);
 cgNormal3f(-0.416504, 0.742188, -0.524902);
 cgVertex3f(1.247452, 0.251289, -0.038253);
 cgNormal3f(-0.270020, 0.914551, -0.300781);
 cgVertex3f(1.253363, 0.250632, -0.027744);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.597168, 0.507812, -0.621094);
 cgVertex3f(1.223807, 0.253259, -0.021832);
 cgNormal3f(-0.808594, 0.526855, -0.262695);
 cgVertex3f(1.218552, 0.253916, -0.013294);
 cgNormal3f(-0.801270, 0.548340, 0.238770);
 cgVertex3f(1.218552, 0.253916, -0.002128);
 cgNormal3f(-0.464844, 0.533691, 0.706055);
 cgVertex3f(1.223807, 0.253259, 0.005096);
 cgNormal3f(-0.467285, 0.670898, -0.575684);
 cgVertex3f(1.229061, 0.253259, 0.006410);
 cgNormal3f(-0.512695, 0.601562, -0.612793);
 cgVertex3f(1.253363, 0.250632, 0.006410);
 cgNormal3f(-0.270020, 0.914551, -0.300781);
 cgVertex3f(1.253363, 0.250632, -0.027744);
 cgNormal3f(-0.416504, 0.742188, -0.524902);
 cgVertex3f(1.247452, 0.251289, -0.038253);
 cgNormal3f(-0.456055, 0.487793, -0.744629);
 cgVertex3f(1.235629, 0.252602, -0.030371);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.196289, 0.479004, -0.855469);
 cgVertex3f(1.268469, 0.249318, -0.074377);
 cgNormal3f(-0.619629, 0.518555, -0.589844);
 cgVertex3f(1.259274, 0.250632, -0.068465);
 cgNormal3f(-0.614258, 0.765625, -0.190918);
 cgVertex3f(1.255990, 0.250632, -0.061241);
 cgNormal3f(-0.192871, 0.954102, -0.229004);
 cgVertex3f(1.262558, 0.249975, -0.050732);
 cgNormal3f(0.333984, 0.914551, -0.227051);
 cgVertex3f(1.291457, 0.247348, -0.050732);
 cgNormal3f(0.730469, 0.657715, -0.183105);
 cgVertex3f(1.298682, 0.247348, -0.061241);
 cgNormal3f(0.699707, 0.414062, -0.581543);
 cgVertex3f(1.295398, 0.247348, -0.068465);
 cgNormal3f(0.280273, 0.447266, -0.849121);
 cgVertex3f(1.285546, 0.248005, -0.074377);
 cgNormal3f(0.038086, 0.445801, -0.894531);
 cgVertex3f(1.277664, 0.248662, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.614258, 0.765625, -0.190918);
 cgVertex3f(1.255990, 0.250632, -0.061241);
 cgNormal3f(-0.619629, 0.518555, -0.589844);
 cgVertex3f(1.259274, 0.250632, -0.068465);
 cgNormal3f(-0.693359, -0.410645, -0.592773);
 cgVertex3f(1.258617, 0.242750, -0.068465);
 cgNormal3f(-0.891113, -0.380371, -0.248535);
 cgVertex3f(1.255333, 0.242750, -0.061241);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.580078, 0.770508, -0.264160);
 cgVertex3f(1.254019, 0.250632, -0.046791);
 cgNormal3f(-0.614258, 0.765625, -0.190918);
 cgVertex3f(1.255990, 0.250632, -0.061241);
 cgNormal3f(-0.891113, -0.380371, -0.248535);
 cgVertex3f(1.255333, 0.242750, -0.061241);
 cgNormal3f(-0.685547, -0.671875, -0.281738);
 cgVertex3f(1.253363, 0.243407, -0.046791);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.416504, 0.742188, -0.524902);
 cgVertex3f(1.247452, 0.251289, -0.038253);
 cgNormal3f(-0.580078, 0.770508, -0.264160);
 cgVertex3f(1.254019, 0.250632, -0.046791);
 cgNormal3f(-0.685547, -0.671875, -0.281738);
 cgVertex3f(1.253363, 0.243407, -0.046791);
 cgNormal3f(-0.431641, -0.801270, -0.415039);
 cgVertex3f(1.246795, 0.243407, -0.038253);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.456055, 0.487793, -0.744629);
 cgVertex3f(1.235629, 0.252602, -0.030371);
 cgNormal3f(-0.416504, 0.742188, -0.524902);
 cgVertex3f(1.247452, 0.251289, -0.038253);
 cgNormal3f(-0.431641, -0.801270, -0.415039);
 cgVertex3f(1.246795, 0.243407, -0.038253);
 cgNormal3f(-0.545898, -0.398926, -0.737305);
 cgVertex3f(1.234972, 0.244721, -0.030371);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.597168, 0.507812, -0.621094);
 cgVertex3f(1.223807, 0.253259, -0.021832);
 cgNormal3f(-0.456055, 0.487793, -0.744629);
 cgVertex3f(1.235629, 0.252602, -0.030371);
 cgNormal3f(-0.545898, -0.398926, -0.737305);
 cgVertex3f(1.234972, 0.244721, -0.030371);
 cgNormal3f(-0.690918, -0.393555, -0.607422);
 cgVertex3f(1.222493, 0.245378, -0.021832);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.808594, 0.526855, -0.262695);
 cgVertex3f(1.218552, 0.253916, -0.013294);
 cgNormal3f(-0.597168, 0.507812, -0.621094);
 cgVertex3f(1.223807, 0.253259, -0.021832);
 cgNormal3f(-0.690918, -0.393555, -0.607422);
 cgVertex3f(1.222493, 0.245378, -0.021832);
 cgNormal3f(-0.891602, -0.390137, -0.231934);
 cgVertex3f(1.217895, 0.246034, -0.013294);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.801270, 0.548340, 0.238770);
 cgVertex3f(1.218552, 0.253916, -0.002128);
 cgNormal3f(-0.808594, 0.526855, -0.262695);
 cgVertex3f(1.218552, 0.253916, -0.013294);
 cgNormal3f(-0.891602, -0.390137, -0.231934);
 cgVertex3f(1.217895, 0.246034, -0.013294);
 cgNormal3f(-0.885742, -0.375488, 0.274414);
 cgVertex3f(1.217895, 0.246034, -0.002128);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.464844, 0.533691, 0.706055);
 cgVertex3f(1.223807, 0.253259, 0.005096);
 cgNormal3f(-0.801270, 0.548340, 0.238770);
 cgVertex3f(1.218552, 0.253916, -0.002128);
 cgNormal3f(-0.885742, -0.375488, 0.274414);
 cgVertex3f(1.217895, 0.246034, -0.002128);
 cgNormal3f(-0.539551, -0.409668, 0.735352);
 cgVertex3f(1.222493, 0.246034, 0.005096);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.467285, 0.670898, -0.575684);
 cgVertex3f(1.229061, 0.253259, 0.006410);
 cgNormal3f(-0.464844, 0.533691, 0.706055);
 cgVertex3f(1.223807, 0.253259, 0.005096);
 cgNormal3f(-0.539551, -0.409668, 0.735352);
 cgVertex3f(1.222493, 0.246034, 0.005096);
 cgNormal3f(-0.338379, -0.939941, 0.045410);
 cgVertex3f(1.228404, 0.245378, 0.006410);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.338379, -0.939941, 0.045410);
 cgVertex3f(1.228404, 0.245378, 0.006410);
 cgNormal3f(-0.685059, -0.412109, -0.601562);
 cgVertex3f(1.220523, 0.246034, 0.012321);
 cgNormal3f(-0.613281, 0.498535, -0.612793);
 cgVertex3f(1.220523, 0.259170, 0.012321);
 cgNormal3f(-0.222656, 0.477051, -0.850098);
 cgVertex3f(1.229718, 0.258514, 0.006410);
 cgNormal3f(-0.467285, 0.670898, -0.575684);
 cgVertex3f(1.229061, 0.253259, 0.006410);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.813477, 0.531738, -0.236816);
 cgVertex3f(1.217239, 0.259827, 0.019546);
 cgNormal3f(-0.613281, 0.498535, -0.612793);
 cgVertex3f(1.220523, 0.259170, 0.012321);
 cgNormal3f(-0.685059, -0.412109, -0.601562);
 cgVertex3f(1.220523, 0.246034, 0.012321);
 cgNormal3f(-0.892578, -0.388184, -0.230957);
 cgVertex3f(1.215925, 0.246034, 0.019546);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.755859, 0.558105, 0.341797);
 cgVertex3f(1.217239, 0.259827, 0.028085);
 cgNormal3f(-0.813477, 0.531738, -0.236816);
 cgVertex3f(1.217239, 0.259827, 0.019546);
 cgNormal3f(-0.892578, -0.388184, -0.230957);
 cgVertex3f(1.215925, 0.246034, 0.019546);
 cgNormal3f(-0.848145, -0.394531, 0.353516);
 cgVertex3f(1.215925, 0.246034, 0.028085);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.375000, 0.505371, 0.776855);
 cgVertex3f(1.224463, 0.259170, 0.034653);
 cgNormal3f(-0.755859, 0.558105, 0.341797);
 cgVertex3f(1.217239, 0.259827, 0.028085);
 cgNormal3f(-0.848145, -0.394531, 0.353516);
 cgVertex3f(1.215925, 0.246034, 0.028085);
 cgNormal3f(-0.455566, -0.412109, 0.789062);
 cgVertex3f(1.222493, 0.246034, 0.034653);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.148438, 0.462402, 0.874023);
 cgVertex3f(1.233002, 0.258514, 0.036623);
 cgNormal3f(-0.375000, 0.505371, 0.776855);
 cgVertex3f(1.224463, 0.259170, 0.034653);
 cgNormal3f(-0.455566, -0.412109, 0.789062);
 cgVertex3f(1.222493, 0.246034, 0.034653);
 cgNormal3f(-0.223145, -0.428711, 0.875488);
 cgVertex3f(1.231688, 0.244721, 0.036623);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.228027, 0.739746, 0.632812);
 cgVertex3f(1.245481, 0.257200, 0.039250);
 cgNormal3f(-0.148438, 0.462402, 0.874023);
 cgVertex3f(1.233002, 0.258514, 0.036623);
 cgNormal3f(-0.223145, -0.428711, 0.875488);
 cgVertex3f(1.231688, 0.244721, 0.036623);
 cgNormal3f(-0.349121, -0.698730, 0.624512);
 cgVertex3f(1.244824, 0.244064, 0.039250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.475098, 0.479492, 0.737793);
 cgVertex3f(1.254019, 0.256543, 0.045818);
 cgNormal3f(-0.228027, 0.739746, 0.632812);
 cgVertex3f(1.245481, 0.257200, 0.039250);
 cgNormal3f(-0.349121, -0.698730, 0.624512);
 cgVertex3f(1.244824, 0.244064, 0.039250);
 cgNormal3f(-0.548340, -0.422363, 0.721680);
 cgVertex3f(1.253363, 0.243407, 0.045818);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.322754, 0.478516, 0.816406);
 cgVertex3f(1.262558, 0.255886, 0.051073);
 cgNormal3f(-0.475098, 0.479492, 0.737793);
 cgVertex3f(1.254019, 0.256543, 0.045818);
 cgNormal3f(-0.548340, -0.422363, 0.721680);
 cgVertex3f(1.253363, 0.243407, 0.045818);
 cgNormal3f(-0.402832, -0.430176, 0.808105);
 cgVertex3f(1.261901, 0.242750, 0.051073);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.083984, 0.465332, 0.880859);
 cgVertex3f(1.272410, 0.255230, 0.053700);
 cgNormal3f(-0.322754, 0.478516, 0.816406);
 cgVertex3f(1.262558, 0.255886, 0.051073);
 cgNormal3f(-0.402832, -0.430176, 0.808105);
 cgVertex3f(1.261901, 0.242750, 0.051073);
 cgNormal3f(-0.166016, -0.444336, 0.880371);
 cgVertex3f(1.270440, 0.241437, 0.053700);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.070312, 0.694824, 0.715332);
 cgVertex3f(1.277664, 0.254573, 0.053700);
 cgNormal3f(-0.083984, 0.465332, 0.880859);
 cgVertex3f(1.272410, 0.255230, 0.053700);
 cgNormal3f(-0.166016, -0.444336, 0.880371);
 cgVertex3f(1.270440, 0.241437, 0.053700);
 cgNormal3f(-0.040527, -0.452637, 0.890625);
 cgVertex3f(1.276351, 0.241437, 0.053700);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.196289, 0.479004, -0.855469);
 cgVertex3f(1.268469, 0.249318, -0.074377);
 cgNormal3f(0.038086, 0.445801, -0.894531);
 cgVertex3f(1.277664, 0.248662, -0.074377);
 cgNormal3f(-0.029297, -0.447266, -0.894531);
 cgVertex3f(1.277008, 0.241437, -0.074377);
 cgNormal3f(-0.266113, -0.440918, -0.857422);
 cgVertex3f(1.268469, 0.242094, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.619629, 0.518555, -0.589844);
 cgVertex3f(1.259274, 0.250632, -0.068465);
 cgNormal3f(-0.196289, 0.479004, -0.855469);
 cgVertex3f(1.268469, 0.249318, -0.074377);
 cgNormal3f(-0.266113, -0.440918, -0.857422);
 cgVertex3f(1.268469, 0.242094, -0.074377);
 cgNormal3f(-0.693359, -0.410645, -0.592773);
 cgVertex3f(1.258617, 0.242750, -0.068465);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.133789, 0.423828, 0.895508);
 cgVertex3f(1.282919, 0.253916, 0.053700);
 cgNormal3f(0.385742, 0.404297, 0.828613);
 cgVertex3f(1.292771, 0.253259, 0.051729);
 cgNormal3f(0.541504, 0.382324, 0.748047);
 cgVertex3f(1.301309, 0.252602, 0.045818);
 cgNormal3f(0.338867, 0.670410, 0.659668);
 cgVertex3f(1.309848, 0.251946, 0.039907);
 cgNormal3f(0.787598, 0.439453, 0.430664);
 cgVertex3f(1.301966, 0.252602, 0.028741);
 cgNormal3f(0.073242, 0.069336, 0.994629);
 cgVertex3f(1.277664, 0.254573, 0.030055);
 cgNormal3f(0.070312, 0.694824, 0.715332);
 cgVertex3f(1.277664, 0.254573, 0.053700);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.213379, -0.472168, -0.855469);
 cgVertex3f(1.285546, 0.240780, -0.074377);
 cgNormal3f(0.633789, -0.507812, -0.583496);
 cgVertex3f(1.294741, 0.239466, -0.068465);
 cgNormal3f(0.818848, -0.519043, -0.244629);
 cgVertex3f(1.298025, 0.239466, -0.061241);
 cgNormal3f(0.596191, -0.762207, -0.252441);
 cgVertex3f(1.299996, 0.239466, -0.046791);
 cgNormal3f(-0.071289, -0.997559, -0.018555);
 cgVertex3f(1.276351, 0.241437, -0.010010);
 cgNormal3f(-0.685547, -0.671875, -0.281738);
 cgVertex3f(1.253363, 0.243407, -0.046791);
 cgNormal3f(-0.891113, -0.380371, -0.248535);
 cgVertex3f(1.255333, 0.242750, -0.061241);
 cgNormal3f(-0.693359, -0.410645, -0.592773);
 cgVertex3f(1.258617, 0.242750, -0.068465);
 cgNormal3f(-0.266113, -0.440918, -0.857422);
 cgVertex3f(1.268469, 0.242094, -0.074377);
 cgNormal3f(-0.029297, -0.447266, -0.894531);
 cgVertex3f(1.277008, 0.241437, -0.074377);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.471680, 0.263184, 0.841309);
 cgVertex3f(1.695147, 0.069030, 0.093081);
 cgNormal3f(0.521973, 0.001465, 0.852539);
 cgVertex3f(1.711583, 0.000000, 0.093081);
 cgNormal3f(0.683594, 0.002441, 0.729492);
 cgVertex3f(1.728019, 0.000000, 0.093081);
 cgNormal3f(0.598633, 0.316895, 0.734863);
 cgVertex3f(1.711583, 0.078892, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.037598, 0.003418, 0.999023);
 cgVertex3f(0.298109, 0.000000, 0.227854);
 cgNormal3f(0.041016, 0.278320, 0.959473);
 cgVertex3f(0.307970, 0.095327, 0.208131);
 cgNormal3f(0.056641, 0.255859, 0.964844);
 cgVertex3f(0.133751, 0.092040, 0.217993);
 cgNormal3f(0.047852, 0.002441, 0.998535);
 cgVertex3f(0.130464, 0.000000, 0.234428);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.062500, 0.003418, 0.997559);
 cgVertex3f(1.254669, 0.000000, 0.201557);
 cgNormal3f(0.048340, 0.245605, 0.967773);
 cgVertex3f(1.254669, 0.078892, 0.181834);
 cgNormal3f(0.041016, 0.278320, 0.959473);
 cgVertex3f(0.307970, 0.095327, 0.208131);
 cgNormal3f(0.037598, 0.003418, 0.999023);
 cgVertex3f(0.298109, 0.000000, 0.227854);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.288574, 0.005859, 0.957031);
 cgVertex3f(1.662276, 0.000000, 0.158824);
 cgNormal3f(0.235840, 0.208008, 0.948730);
 cgVertex3f(1.632692, 0.069030, 0.155537);
 cgNormal3f(0.070312, 0.176758, 0.981445);
 cgVertex3f(1.445324, 0.075604, 0.168685);
 cgNormal3f(0.088379, 0.003418, 0.995605);
 cgVertex3f(1.445324, 0.000000, 0.178547);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.056641, 0.255859, 0.964844);
 cgVertex3f(0.133751, 0.092040, 0.217993);
 cgNormal3f(0.079102, 0.385742, 0.918945);
 cgVertex3f(0.133751, 0.193942, 0.181834);
 cgNormal3f(0.066406, 0.335938, 0.938965);
 cgVertex3f(-0.066765, 0.207090, 0.191695);
 cgNormal3f(0.050293, 0.224121, 0.973145);
 cgVertex3f(-0.066765, 0.095327, 0.231141);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.041016, 0.278320, 0.959473);
 cgVertex3f(0.307970, 0.095327, 0.208131);
 cgNormal3f(0.054199, 0.439453, 0.895996);
 cgVertex3f(0.307970, 0.187368, 0.168685);
 cgNormal3f(0.079102, 0.385742, 0.918945);
 cgVertex3f(0.133751, 0.193942, 0.181834);
 cgNormal3f(0.056641, 0.255859, 0.964844);
 cgVertex3f(0.133751, 0.092040, 0.217993);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.048340, 0.245605, 0.967773);
 cgVertex3f(1.254669, 0.078892, 0.181834);
 cgNormal3f(0.026367, 0.422363, 0.905762);
 cgVertex3f(1.248095, 0.167645, 0.155537);
 cgNormal3f(0.054199, 0.439453, 0.895996);
 cgVertex3f(0.307970, 0.187368, 0.168685);
 cgNormal3f(0.041016, 0.278320, 0.959473);
 cgVertex3f(0.307970, 0.095327, 0.208131);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.070312, 0.176758, 0.981445);
 cgVertex3f(1.445324, 0.075604, 0.168685);
 cgNormal3f(0.168945, 0.421387, 0.890625);
 cgVertex3f(1.547226, 0.157783, 0.145675);
 cgNormal3f(0.052734, 0.305176, 0.950684);
 cgVertex3f(1.445324, 0.164357, 0.152250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.079102, 0.385742, 0.918945);
 cgVertex3f(0.133751, 0.193942, 0.181834);
 cgNormal3f(0.146973, 0.611816, 0.776855);
 cgVertex3f(0.140326, 0.236675, 0.162111);
 cgNormal3f(0.129395, 0.499512, 0.855957);
 cgVertex3f(-0.063478, 0.305705, 0.155537);
 cgNormal3f(0.066406, 0.335938, 0.938965);
 cgVertex3f(-0.066765, 0.207090, 0.191695);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.054199, 0.439453, 0.895996);
 cgVertex3f(0.307970, 0.187368, 0.168685);
 cgNormal3f(0.081543, 0.729980, 0.677734);
 cgVertex3f(0.314545, 0.216952, 0.148962);
 cgNormal3f(0.146973, 0.611816, 0.776855);
 cgVertex3f(0.140326, 0.236675, 0.162111);
 cgNormal3f(0.079102, 0.385742, 0.918945);
 cgVertex3f(0.133751, 0.193942, 0.181834);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.026367, 0.422363, 0.905762);
 cgVertex3f(1.248095, 0.167645, 0.155537);
 cgNormal3f(0.018555, 0.755371, 0.654297);
 cgVertex3f(1.254669, 0.193942, 0.135814);
 cgNormal3f(0.081543, 0.729980, 0.677734);
 cgVertex3f(0.314545, 0.216952, 0.148962);
 cgNormal3f(0.054199, 0.439453, 0.895996);
 cgVertex3f(0.307970, 0.187368, 0.168685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.168945, 0.421387, 0.890625);
 cgVertex3f(1.547226, 0.157783, 0.145675);
 cgNormal3f(0.372559, 0.798828, 0.471680);
 cgVertex3f(1.570236, 0.167645, 0.129239);
 cgNormal3f(0.145020, 0.931641, 0.332520);
 cgVertex3f(1.474908, 0.193942, 0.122665);
 cgNormal3f(0.099609, 0.680664, 0.725098);
 cgVertex3f(1.474908, 0.190655, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.032715, 0.213867, 0.976074);
 cgVertex3f(-0.540114, 0.105189, 0.247577);
 cgNormal3f(-0.009277, 0.211426, 0.977051);
 cgVertex3f(-0.796512, 0.111763, 0.254151);
 cgNormal3f(-0.020996, 0.000488, 0.999512);
 cgVertex3f(-0.809661, 0.000000, 0.267300);
 cgNormal3f(0.034180, 0.000977, 0.999023);
 cgVertex3f(-0.546689, 0.000000, 0.257438);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.020996, 0.000488, 0.999512);
 cgVertex3f(-0.809661, 0.000000, 0.267300);
 cgNormal3f(-0.009277, 0.211426, 0.977051);
 cgVertex3f(-0.796512, 0.111763, 0.254151);
 cgNormal3f(-0.057129, 0.176270, 0.982422);
 cgVertex3f(-0.951008, 0.115050, 0.244290);
 cgNormal3f(-0.080566, 0.000488, 0.996582);
 cgVertex3f(-0.957582, 0.000000, 0.254151);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.124512, 0.000977, 0.992188);
 cgVertex3f(-1.105504, 0.000000, 0.241003);
 cgNormal3f(-0.104492, 0.124023, 0.986328);
 cgVertex3f(-1.102217, 0.118337, 0.231141);
 cgNormal3f(-0.166992, 0.074707, 0.982910);
 cgVertex3f(-1.355327, 0.108476, 0.191695);
 cgNormal3f(-0.177734, 0.000488, 0.983887);
 cgVertex3f(-1.358615, 0.000000, 0.198270);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.177734, 0.000488, 0.983887);
 cgVertex3f(-1.358615, 0.000000, 0.198270);
 cgNormal3f(-0.166992, 0.074707, 0.982910);
 cgVertex3f(-1.355327, 0.108476, 0.191695);
 cgNormal3f(-0.365723, 0.061035, 0.928711);
 cgVertex3f(-1.542695, 0.105189, 0.158824);
 cgNormal3f(-0.354980, 0.000000, 0.934570);
 cgVertex3f(-1.539408, 0.000000, 0.158824);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.354980, 0.000000, 0.934570);
 cgVertex3f(-1.539408, 0.000000, 0.158824);
 cgNormal3f(-0.365723, 0.061035, 0.928711);
 cgVertex3f(-1.542695, 0.105189, 0.158824);
 cgNormal3f(-0.746094, 0.092285, 0.659668);
 cgVertex3f(-1.578854, 0.105189, 0.132527);
 cgNormal3f(-0.729980, 0.000488, 0.683594);
 cgVertex3f(-1.582141, 0.000000, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.729980, 0.000488, 0.683594);
 cgVertex3f(-1.582141, 0.000000, 0.139101);
 cgNormal3f(-0.746094, 0.092285, 0.659668);
 cgVertex3f(-1.578854, 0.105189, 0.132527);
 cgNormal3f(-0.533203, 0.062988, 0.843262);
 cgVertex3f(-1.598577, 0.108476, 0.093081);
 cgNormal3f(-0.524902, 0.000000, 0.851074);
 cgVertex3f(-1.605151, 0.000000, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.668457, 0.001953, 0.743652);
 cgVertex3f(-1.618299, 0.000000, 0.093081);
 cgNormal3f(-0.668457, 0.093750, 0.737793);
 cgVertex3f(-1.611725, 0.095327, 0.093081);
 cgNormal3f(-0.990723, 0.138184, -0.000488);
 cgVertex3f(-1.618299, 0.095327, -0.002246);
 cgNormal3f(-1.000000, 0.002441, -0.000488);
 cgVertex3f(-1.631448, 0.000000, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.066406, 0.335938, 0.938965);
 cgVertex3f(-0.066765, 0.207090, 0.191695);
 cgNormal3f(0.034180, 0.325684, 0.944336);
 cgVertex3f(-0.313301, 0.213665, 0.204844);
 cgNormal3f(0.037598, 0.210938, 0.976562);
 cgVertex3f(-0.313301, 0.105189, 0.237715);
 cgNormal3f(0.050293, 0.224121, 0.973145);
 cgVertex3f(-0.066765, 0.095327, 0.231141);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.034180, 0.325684, 0.944336);
 cgVertex3f(-0.313301, 0.213665, 0.204844);
 cgNormal3f(0.026855, 0.337891, 0.940430);
 cgVertex3f(-0.536827, 0.216952, 0.208131);
 cgNormal3f(0.032715, 0.213867, 0.976074);
 cgVertex3f(-0.540114, 0.105189, 0.247577);
 cgNormal3f(0.037598, 0.210938, 0.976562);
 cgVertex3f(-0.313301, 0.105189, 0.237715);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.025391, 0.320312, 0.946777);
 cgVertex3f(-0.789938, 0.223526, 0.214705);
 cgNormal3f(-0.009277, 0.211426, 0.977051);
 cgVertex3f(-0.796512, 0.111763, 0.254151);
 cgNormal3f(0.032715, 0.213867, 0.976074);
 cgVertex3f(-0.540114, 0.105189, 0.247577);
 cgNormal3f(0.026855, 0.337891, 0.940430);
 cgVertex3f(-0.536827, 0.216952, 0.208131);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.661133, 0.174805, 0.729492);
 cgVertex3f(-1.588715, 0.220239, 0.093081);
 cgNormal3f(-0.966797, 0.255371, 0.000000);
 cgVertex3f(-1.598577, 0.210378, -0.002246);
 cgNormal3f(-0.990723, 0.138184, -0.000488);
 cgVertex3f(-1.618299, 0.095327, -0.002246);
 cgNormal3f(-0.668457, 0.093750, 0.737793);
 cgVertex3f(-1.611725, 0.095327, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.534668, 0.151855, 0.831055);
 cgVertex3f(-1.575567, 0.223526, 0.093081);
 cgNormal3f(-0.661133, 0.174805, 0.729492);
 cgVertex3f(-1.588715, 0.220239, 0.093081);
 cgNormal3f(-0.668457, 0.093750, 0.737793);
 cgVertex3f(-1.611725, 0.095327, 0.093081);
 cgNormal3f(-0.533203, 0.062988, 0.843262);
 cgVertex3f(-1.598577, 0.108476, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.750488, 0.224121, 0.621582);
 cgVertex3f(-1.562418, 0.223526, 0.129239);
 cgNormal3f(-0.534668, 0.151855, 0.831055);
 cgVertex3f(-1.575567, 0.223526, 0.093081);
 cgNormal3f(-0.533203, 0.062988, 0.843262);
 cgVertex3f(-1.598577, 0.108476, 0.093081);
 cgNormal3f(-0.746094, 0.092285, 0.659668);
 cgVertex3f(-1.578854, 0.105189, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.746094, 0.092285, 0.659668);
 cgVertex3f(-1.578854, 0.105189, 0.132527);
 cgNormal3f(-0.365723, 0.061035, 0.928711);
 cgVertex3f(-1.542695, 0.105189, 0.158824);
 cgNormal3f(-0.375488, 0.134766, 0.916504);
 cgVertex3f(-1.526259, 0.220239, 0.152250);
 cgNormal3f(-0.750488, 0.224121, 0.621582);
 cgVertex3f(-1.562418, 0.223526, 0.129239);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.166992, 0.074707, 0.982910);
 cgVertex3f(-1.355327, 0.108476, 0.191695);
 cgNormal3f(-0.142578, 0.128418, 0.980957);
 cgVertex3f(-1.355327, 0.216952, 0.185121);
 cgNormal3f(-0.375488, 0.134766, 0.916504);
 cgVertex3f(-1.526259, 0.220239, 0.152250);
 cgNormal3f(-0.365723, 0.061035, 0.928711);
 cgVertex3f(-1.542695, 0.105189, 0.158824);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.104492, 0.124023, 0.986328);
 cgVertex3f(-1.102217, 0.118337, 0.231141);
 cgNormal3f(-0.061035, 0.197754, 0.978027);
 cgVertex3f(-1.095643, 0.226813, 0.214705);
 cgNormal3f(-0.142578, 0.128418, 0.980957);
 cgVertex3f(-1.355327, 0.216952, 0.185121);
 cgNormal3f(-0.166992, 0.074707, 0.982910);
 cgVertex3f(-1.355327, 0.108476, 0.191695);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.009277, 0.211426, 0.977051);
 cgVertex3f(-0.796512, 0.111763, 0.254151);
 cgNormal3f(0.025391, 0.320312, 0.946777);
 cgVertex3f(-0.789938, 0.223526, 0.214705);
 cgNormal3f(0.001465, 0.261719, 0.964844);
 cgVertex3f(-0.941147, 0.223526, 0.214705);
 cgNormal3f(-0.057129, 0.176270, 0.982422);
 cgVertex3f(-0.951008, 0.115050, 0.244290);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.506836, 0.248535, 0.825195);
 cgVertex3f(-1.532834, 0.335289, 0.093081);
 cgNormal3f(-0.620117, 0.319336, 0.716309);
 cgVertex3f(-1.545982, 0.345151, 0.093081);
 cgNormal3f(-0.661133, 0.174805, 0.729492);
 cgVertex3f(-1.588715, 0.220239, 0.093081);
 cgNormal3f(-0.534668, 0.151855, 0.831055);
 cgVertex3f(-1.575567, 0.223526, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.889160, 0.458008, 0.000000);
 cgVertex3f(-1.552556, 0.335289, -0.002246);
 cgNormal3f(-0.966797, 0.255371, 0.000000);
 cgVertex3f(-1.598577, 0.210378, -0.002246);
 cgNormal3f(-0.661133, 0.174805, 0.729492);
 cgVertex3f(-1.588715, 0.220239, 0.093081);
 cgNormal3f(-0.620117, 0.319336, 0.716309);
 cgVertex3f(-1.545982, 0.345151, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.421387, 0.363281, 0.830566);
 cgVertex3f(-1.493388, 0.397745, 0.093081);
 cgNormal3f(-0.497070, 0.498047, 0.710449);
 cgVertex3f(-1.503249, 0.407607, 0.093081);
 cgNormal3f(-0.620117, 0.319336, 0.716309);
 cgVertex3f(-1.545982, 0.345151, 0.093081);
 cgNormal3f(-0.506836, 0.248535, 0.825195);
 cgVertex3f(-1.532834, 0.335289, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.506836, 0.248535, 0.825195);
 cgVertex3f(-1.532834, 0.335289, 0.093081);
 cgNormal3f(-0.732422, 0.351074, 0.583496);
 cgVertex3f(-1.522972, 0.325428, 0.122665);
 cgNormal3f(-0.623047, 0.528809, 0.575684);
 cgVertex3f(-1.490101, 0.384596, 0.122665);
 cgNormal3f(-0.421387, 0.363281, 0.830566);
 cgVertex3f(-1.493388, 0.397745, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.534668, 0.151855, 0.831055);
 cgVertex3f(-1.575567, 0.223526, 0.093081);
 cgNormal3f(-0.750488, 0.224121, 0.621582);
 cgVertex3f(-1.562418, 0.223526, 0.129239);
 cgNormal3f(-0.732422, 0.351074, 0.583496);
 cgVertex3f(-1.522972, 0.325428, 0.122665);
 cgNormal3f(-0.506836, 0.248535, 0.825195);
 cgVertex3f(-1.532834, 0.335289, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.375488, 0.134766, 0.916504);
 cgVertex3f(-1.526259, 0.220239, 0.152250);
 cgNormal3f(-0.397949, 0.185059, 0.898438);
 cgVertex3f(-1.496675, 0.305705, 0.148962);
 cgNormal3f(-0.732422, 0.351074, 0.583496);
 cgVertex3f(-1.522972, 0.325428, 0.122665);
 cgNormal3f(-0.750488, 0.224121, 0.621582);
 cgVertex3f(-1.562418, 0.223526, 0.129239);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.329590, 0.286133, 0.899414);
 cgVertex3f(-1.473665, 0.361586, 0.148962);
 cgNormal3f(-0.623047, 0.528809, 0.575684);
 cgVertex3f(-1.490101, 0.384596, 0.122665);
 cgNormal3f(-0.732422, 0.351074, 0.583496);
 cgVertex3f(-1.522972, 0.325428, 0.122665);
 cgNormal3f(-0.397949, 0.185059, 0.898438);
 cgVertex3f(-1.496675, 0.305705, 0.148962);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.142578, 0.128418, 0.980957);
 cgVertex3f(-1.355327, 0.216952, 0.185121);
 cgNormal3f(-0.329590, 0.286133, 0.899414);
 cgVertex3f(-1.473665, 0.361586, 0.148962);
 cgNormal3f(-0.397949, 0.185059, 0.898438);
 cgVertex3f(-1.496675, 0.305705, 0.148962);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.375488, 0.134766, 0.916504);
 cgVertex3f(-1.526259, 0.220239, 0.152250);
 cgNormal3f(-0.142578, 0.128418, 0.980957);
 cgVertex3f(-1.355327, 0.216952, 0.185121);
 cgNormal3f(-0.397949, 0.185059, 0.898438);
 cgVertex3f(-1.496675, 0.305705, 0.148962);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.112793, 0.374023, 0.920410);
 cgVertex3f(-1.355327, 0.414181, 0.145675);
 cgNormal3f(-0.168945, 0.733887, 0.657227);
 cgVertex3f(-1.361902, 0.447052, 0.122665);
 cgNormal3f(-0.368652, 0.693848, 0.618164);
 cgVertex3f(-1.444080, 0.424042, 0.119378);
 cgNormal3f(-0.213867, 0.441895, 0.871094);
 cgVertex3f(-1.437506, 0.391171, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.015137, 0.553711, 0.832031);
 cgVertex3f(-1.072633, 0.489785, 0.093081);
 cgNormal3f(-0.107910, 0.517090, 0.848633);
 cgVertex3f(-1.365189, 0.463488, 0.093081);
 cgNormal3f(-0.168945, 0.733887, 0.657227);
 cgVertex3f(-1.361902, 0.447052, 0.122665);
 cgNormal3f(0.006348, 0.745117, 0.666016);
 cgVertex3f(-1.072633, 0.470062, 0.148962);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.006348, 0.745117, 0.666016);
 cgVertex3f(-1.072633, 0.470062, 0.148962);
 cgNormal3f(-0.168945, 0.733887, 0.657227);
 cgVertex3f(-1.361902, 0.447052, 0.122665);
 cgNormal3f(-0.112793, 0.374023, 0.920410);
 cgVertex3f(-1.355327, 0.414181, 0.145675);
 cgNormal3f(-0.025391, 0.358887, 0.932617);
 cgVertex3f(-1.079207, 0.437191, 0.165398);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.168945, 0.733887, 0.657227);
 cgVertex3f(-1.361902, 0.447052, 0.122665);
 cgNormal3f(-0.107910, 0.517090, 0.848633);
 cgVertex3f(-1.365189, 0.463488, 0.093081);
 cgNormal3f(-0.254883, 0.467773, 0.846191);
 cgVertex3f(-1.444080, 0.437191, 0.093081);
 cgNormal3f(-0.368652, 0.693848, 0.618164);
 cgVertex3f(-1.444080, 0.424042, 0.119378);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.889160, 0.458008, 0.000000);
 cgVertex3f(-1.552556, 0.335289, -0.002246);
 cgNormal3f(-0.620117, 0.319336, 0.716309);
 cgVertex3f(-1.545982, 0.345151, 0.093081);
 cgNormal3f(-0.497070, 0.498047, 0.710449);
 cgVertex3f(-1.503249, 0.407607, 0.093081);
 cgNormal3f(-0.747070, 0.664551, 0.000000);
 cgVertex3f(-1.503249, 0.404319, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.151855, 0.644531, 0.749023);
 cgVertex3f(-1.371763, 0.473350, 0.093081);
 cgNormal3f(0.020996, 0.643066, 0.765137);
 cgVertex3f(-1.072633, 0.499647, 0.093081);
 cgNormal3f(0.028320, 0.999512, 0.000000);
 cgVertex3f(-1.072633, 0.519370, -0.002246);
 cgNormal3f(-0.230469, 0.973145, 0.003906);
 cgVertex3f(-1.352040, 0.489785, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.107910, 0.517090, 0.848633);
 cgVertex3f(-1.365189, 0.463488, 0.093081);
 cgNormal3f(0.015137, 0.553711, 0.832031);
 cgVertex3f(-1.072633, 0.489785, 0.093081);
 cgNormal3f(0.020996, 0.643066, 0.765137);
 cgVertex3f(-1.072633, 0.499647, 0.093081);
 cgNormal3f(-0.151855, 0.644531, 0.749023);
 cgVertex3f(-1.371763, 0.473350, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.227051, 0.973633, -0.004395);
 cgVertex3f(-0.921424, 0.493072, -0.002246);
 cgNormal3f(0.150879, 0.638672, 0.753906);
 cgVertex3f(-0.921424, 0.479924, 0.093081);
 cgNormal3f(0.134277, 0.653320, 0.744629);
 cgVertex3f(-0.770215, 0.433904, 0.093081);
 cgNormal3f(0.201172, 0.979492, 0.000000);
 cgVertex3f(-0.766928, 0.443765, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.254883, 0.467773, 0.846191);
 cgVertex3f(-1.444080, 0.437191, 0.093081);
 cgNormal3f(-0.107910, 0.517090, 0.848633);
 cgVertex3f(-1.365189, 0.463488, 0.093081);
 cgNormal3f(-0.151855, 0.644531, 0.749023);
 cgVertex3f(-1.371763, 0.473350, 0.093081);
 cgNormal3f(-0.325195, 0.615234, 0.717773);
 cgVertex3f(-1.450655, 0.447052, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.151855, 0.644531, 0.749023);
 cgVertex3f(-1.371763, 0.473350, 0.093081);
 cgNormal3f(-0.230469, 0.973145, 0.003906);
 cgVertex3f(-1.352040, 0.489785, -0.002246);
 cgNormal3f(-0.430176, 0.902344, 0.000000);
 cgVertex3f(-1.444080, 0.450339, -0.002246);
 cgNormal3f(-0.325195, 0.615234, 0.717773);
 cgVertex3f(-1.450655, 0.447052, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.027344, 0.673828, 0.737793);
 cgVertex3f(-0.533540, 0.410894, 0.093081);
 cgNormal3f(0.040527, 0.999023, 0.000000);
 cgVertex3f(-0.530253, 0.417468, -0.002246);
 cgNormal3f(0.201172, 0.979492, 0.000000);
 cgVertex3f(-0.766928, 0.443765, -0.002246);
 cgNormal3f(0.134277, 0.653320, 0.744629);
 cgVertex3f(-0.770215, 0.433904, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.134277, 0.653320, 0.744629);
 cgVertex3f(-0.770215, 0.433904, 0.093081);
 cgNormal3f(0.112305, 0.572266, 0.812012);
 cgVertex3f(-0.770215, 0.420755, 0.093081);
 cgNormal3f(0.023438, 0.579102, 0.814453);
 cgVertex3f(-0.533540, 0.397745, 0.093081);
 cgNormal3f(0.027344, 0.673828, 0.737793);
 cgVertex3f(-0.533540, 0.410894, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.150879, 0.638672, 0.753906);
 cgVertex3f(-0.921424, 0.479924, 0.093081);
 cgNormal3f(0.126465, 0.559570, 0.818359);
 cgVertex3f(-0.921424, 0.466775, 0.093081);
 cgNormal3f(0.112305, 0.572266, 0.812012);
 cgVertex3f(-0.770215, 0.420755, 0.093081);
 cgNormal3f(0.134277, 0.653320, 0.744629);
 cgVertex3f(-0.770215, 0.433904, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.126465, 0.559570, 0.818359);
 cgVertex3f(-0.921424, 0.466775, 0.093081);
 cgNormal3f(0.176270, 0.743652, 0.644043);
 cgVertex3f(-0.924711, 0.447052, 0.145675);
 cgNormal3f(0.159180, 0.774902, 0.611328);
 cgVertex3f(-0.780076, 0.407607, 0.139101);
 cgNormal3f(0.112305, 0.572266, 0.812012);
 cgVertex3f(-0.770215, 0.420755, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.176270, 0.743652, 0.644043);
 cgVertex3f(-0.924711, 0.447052, 0.145675);
 cgNormal3f(0.079590, 0.375977, 0.922852);
 cgVertex3f(-0.931285, 0.417468, 0.162111);
 cgNormal3f(0.083496, 0.432129, 0.897461);
 cgVertex3f(-0.783363, 0.374735, 0.162111);
 cgNormal3f(0.159180, 0.774902, 0.611328);
 cgVertex3f(-0.780076, 0.407607, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.112793, 0.374023, 0.920410);
 cgVertex3f(-1.355327, 0.414181, 0.145675);
 cgNormal3f(-0.142578, 0.128418, 0.980957);
 cgVertex3f(-1.355327, 0.216952, 0.185121);
 cgNormal3f(-0.061035, 0.197754, 0.978027);
 cgVertex3f(-1.095643, 0.226813, 0.214705);
 cgNormal3f(-0.025391, 0.358887, 0.932617);
 cgVertex3f(-1.079207, 0.437191, 0.165398);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.001465, 0.261719, 0.964844);
 cgVertex3f(-0.941147, 0.223526, 0.214705);
 cgNormal3f(0.025391, 0.320312, 0.946777);
 cgVertex3f(-0.789938, 0.223526, 0.214705);
 cgNormal3f(0.083496, 0.432129, 0.897461);
 cgVertex3f(-0.783363, 0.374735, 0.162111);
 cgNormal3f(0.079590, 0.375977, 0.922852);
 cgVertex3f(-0.931285, 0.417468, 0.162111);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.026855, 0.337891, 0.940430);
 cgVertex3f(-0.536827, 0.216952, 0.208131);
 cgNormal3f(0.023926, 0.462891, 0.885742);
 cgVertex3f(-0.533540, 0.364874, 0.145675);
 cgNormal3f(0.083496, 0.432129, 0.897461);
 cgVertex3f(-0.783363, 0.374735, 0.162111);
 cgNormal3f(0.025391, 0.320312, 0.946777);
 cgVertex3f(-0.789938, 0.223526, 0.214705);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.159180, 0.774902, 0.611328);
 cgVertex3f(-0.780076, 0.407607, 0.139101);
 cgNormal3f(0.083496, 0.432129, 0.897461);
 cgVertex3f(-0.783363, 0.374735, 0.162111);
 cgNormal3f(0.023926, 0.462891, 0.885742);
 cgVertex3f(-0.533540, 0.364874, 0.145675);
 cgNormal3f(0.033203, 0.794434, 0.605957);
 cgVertex3f(-0.533540, 0.384596, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.033203, 0.794434, 0.605957);
 cgVertex3f(-0.533540, 0.384596, 0.132527);
 cgNormal3f(0.023438, 0.579102, 0.814453);
 cgVertex3f(-0.533540, 0.397745, 0.093081);
 cgNormal3f(0.112305, 0.572266, 0.812012);
 cgVertex3f(-0.770215, 0.420755, 0.093081);
 cgNormal3f(0.159180, 0.774902, 0.611328);
 cgVertex3f(-0.780076, 0.407607, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.061523, 0.669922, 0.739258);
 cgVertex3f(-0.310014, 0.414181, 0.093081);
 cgNormal3f(0.091797, 0.995605, 0.000000);
 cgVertex3f(-0.310014, 0.424042, -0.002246);
 cgNormal3f(0.040527, 0.999023, 0.000000);
 cgVertex3f(-0.530253, 0.417468, -0.002246);
 cgNormal3f(0.027344, 0.673828, 0.737793);
 cgVertex3f(-0.533540, 0.410894, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.027344, 0.673828, 0.737793);
 cgVertex3f(-0.533540, 0.410894, 0.093081);
 cgNormal3f(0.023438, 0.579102, 0.814453);
 cgVertex3f(-0.533540, 0.397745, 0.093081);
 cgNormal3f(0.055664, 0.562500, 0.824219);
 cgVertex3f(-0.306727, 0.404319, 0.093081);
 cgNormal3f(0.061523, 0.669922, 0.739258);
 cgVertex3f(-0.310014, 0.414181, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.033203, 0.794434, 0.605957);
 cgVertex3f(-0.533540, 0.384596, 0.132527);
 cgNormal3f(0.077637, 0.788574, 0.609375);
 cgVertex3f(-0.306727, 0.384596, 0.139101);
 cgNormal3f(0.055664, 0.562500, 0.824219);
 cgVertex3f(-0.306727, 0.404319, 0.093081);
 cgNormal3f(0.023438, 0.579102, 0.814453);
 cgVertex3f(-0.533540, 0.397745, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.023926, 0.462891, 0.885742);
 cgVertex3f(-0.533540, 0.364874, 0.145675);
 cgNormal3f(0.042969, 0.465332, 0.883789);
 cgVertex3f(-0.306727, 0.361586, 0.155537);
 cgNormal3f(0.077637, 0.788574, 0.609375);
 cgVertex3f(-0.306727, 0.384596, 0.139101);
 cgNormal3f(0.033203, 0.794434, 0.605957);
 cgVertex3f(-0.533540, 0.384596, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.026855, 0.337891, 0.940430);
 cgVertex3f(-0.536827, 0.216952, 0.208131);
 cgNormal3f(0.034180, 0.325684, 0.944336);
 cgVertex3f(-0.313301, 0.213665, 0.204844);
 cgNormal3f(0.042969, 0.465332, 0.883789);
 cgVertex3f(-0.306727, 0.361586, 0.155537);
 cgNormal3f(0.023926, 0.462891, 0.885742);
 cgVertex3f(-0.533540, 0.364874, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.034180, 0.325684, 0.944336);
 cgVertex3f(-0.313301, 0.213665, 0.204844);
 cgNormal3f(0.066406, 0.335938, 0.938965);
 cgVertex3f(-0.066765, 0.207090, 0.191695);
 cgNormal3f(0.129395, 0.499512, 0.855957);
 cgVertex3f(-0.063478, 0.305705, 0.155537);
 cgNormal3f(0.042969, 0.465332, 0.883789);
 cgVertex3f(-0.306727, 0.361586, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.129395, 0.499512, 0.855957);
 cgVertex3f(-0.063478, 0.305705, 0.155537);
 cgNormal3f(0.229492, 0.795410, 0.560059);
 cgVertex3f(-0.063478, 0.335289, 0.132527);
 cgNormal3f(0.077637, 0.788574, 0.609375);
 cgVertex3f(-0.306727, 0.384596, 0.139101);
 cgNormal3f(0.042969, 0.465332, 0.883789);
 cgVertex3f(-0.306727, 0.361586, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.229492, 0.795410, 0.560059);
 cgVertex3f(-0.063478, 0.335289, 0.132527);
 cgNormal3f(0.161621, 0.553711, 0.816406);
 cgVertex3f(-0.076626, 0.351725, 0.093081);
 cgNormal3f(0.055664, 0.562500, 0.824219);
 cgVertex3f(-0.306727, 0.404319, 0.093081);
 cgNormal3f(0.077637, 0.788574, 0.609375);
 cgVertex3f(-0.306727, 0.384596, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.161621, 0.553711, 0.816406);
 cgVertex3f(-0.076626, 0.351725, 0.093081);
 cgNormal3f(0.172363, 0.646484, 0.742676);
 cgVertex3f(-0.070052, 0.364874, 0.093081);
 cgNormal3f(0.061523, 0.669922, 0.739258);
 cgVertex3f(-0.310014, 0.414181, 0.093081);
 cgNormal3f(0.055664, 0.562500, 0.824219);
 cgVertex3f(-0.306727, 0.404319, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.172363, 0.646484, 0.742676);
 cgVertex3f(-0.070052, 0.364874, 0.093081);
 cgNormal3f(0.257324, 0.965820, 0.000000);
 cgVertex3f(-0.079913, 0.374735, -0.002246);
 cgNormal3f(0.091797, 0.995605, 0.000000);
 cgVertex3f(-0.310014, 0.424042, -0.002246);
 cgNormal3f(0.061523, 0.669922, 0.739258);
 cgVertex3f(-0.310014, 0.414181, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.172363, 0.646484, 0.742676);
 cgVertex3f(-0.070052, 0.364874, 0.093081);
 cgNormal3f(0.166016, 0.618652, 0.767578);
 cgVertex3f(0.137038, 0.292556, 0.093081);
 cgNormal3f(0.258789, 0.965332, 0.000000);
 cgVertex3f(0.127177, 0.312279, -0.002246);
 cgNormal3f(0.257324, 0.965820, 0.000000);
 cgVertex3f(-0.079913, 0.374735, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.161621, 0.553711, 0.816406);
 cgVertex3f(-0.076626, 0.351725, 0.093081);
 cgNormal3f(0.161621, 0.561523, 0.811035);
 cgVertex3f(0.137038, 0.276121, 0.093081);
 cgNormal3f(0.166016, 0.618652, 0.767578);
 cgVertex3f(0.137038, 0.292556, 0.093081);
 cgNormal3f(0.172363, 0.646484, 0.742676);
 cgVertex3f(-0.070052, 0.364874, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.229492, 0.795410, 0.560059);
 cgVertex3f(-0.063478, 0.335289, 0.132527);
 cgNormal3f(0.231934, 0.852539, 0.467773);
 cgVertex3f(0.140326, 0.256398, 0.139101);
 cgNormal3f(0.161621, 0.561523, 0.811035);
 cgVertex3f(0.137038, 0.276121, 0.093081);
 cgNormal3f(0.161621, 0.553711, 0.816406);
 cgVertex3f(-0.076626, 0.351725, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.129395, 0.499512, 0.855957);
 cgVertex3f(-0.063478, 0.305705, 0.155537);
 cgNormal3f(0.146973, 0.611816, 0.776855);
 cgVertex3f(0.140326, 0.236675, 0.162111);
 cgNormal3f(0.231934, 0.852539, 0.467773);
 cgVertex3f(0.140326, 0.256398, 0.139101);
 cgNormal3f(0.229492, 0.795410, 0.560059);
 cgVertex3f(-0.063478, 0.335289, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.050293, 0.224121, 0.973145);
 cgVertex3f(-0.066765, 0.095327, 0.231141);
 cgNormal3f(0.037598, 0.210938, 0.976562);
 cgVertex3f(-0.313301, 0.105189, 0.237715);
 cgNormal3f(0.035645, 0.001465, 0.999023);
 cgVertex3f(-0.316588, 0.000000, 0.250864);
 cgNormal3f(0.042480, 0.001953, 0.999023);
 cgVertex3f(-0.073339, 0.000000, 0.241003);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.042480, 0.001953, 0.999023);
 cgVertex3f(-0.073339, 0.000000, 0.241003);
 cgNormal3f(0.047852, 0.002441, 0.998535);
 cgVertex3f(0.130464, 0.000000, 0.234428);
 cgNormal3f(0.056641, 0.255859, 0.964844);
 cgVertex3f(0.133751, 0.092040, 0.217993);
 cgNormal3f(0.050293, 0.224121, 0.973145);
 cgVertex3f(-0.066765, 0.095327, 0.231141);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.037598, 0.210938, 0.976562);
 cgVertex3f(-0.313301, 0.105189, 0.237715);
 cgNormal3f(0.032715, 0.213867, 0.976074);
 cgVertex3f(-0.540114, 0.105189, 0.247577);
 cgNormal3f(0.034180, 0.000977, 0.999023);
 cgVertex3f(-0.546689, 0.000000, 0.257438);
 cgNormal3f(0.035645, 0.001465, 0.999023);
 cgVertex3f(-0.316588, 0.000000, 0.250864);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.166016, 0.618652, 0.767578);
 cgVertex3f(0.137038, 0.292556, 0.093081);
 cgNormal3f(0.072754, 0.609863, 0.788574);
 cgVertex3f(0.324406, 0.246536, 0.093081);
 cgNormal3f(0.118652, 0.992676, 0.000000);
 cgVertex3f(0.311257, 0.279408, -0.002246);
 cgNormal3f(0.258789, 0.965332, 0.000000);
 cgVertex3f(0.127177, 0.312279, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.161621, 0.561523, 0.811035);
 cgVertex3f(0.137038, 0.276121, 0.093081);
 cgNormal3f(0.069824, 0.600586, 0.795898);
 cgVertex3f(0.324406, 0.233388, 0.093081);
 cgNormal3f(0.072754, 0.609863, 0.788574);
 cgVertex3f(0.324406, 0.246536, 0.093081);
 cgNormal3f(0.166016, 0.618652, 0.767578);
 cgVertex3f(0.137038, 0.292556, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.231934, 0.852539, 0.467773);
 cgVertex3f(0.140326, 0.256398, 0.139101);
 cgNormal3f(0.103516, 0.925781, 0.362305);
 cgVertex3f(0.321119, 0.226813, 0.119378);
 cgNormal3f(0.069824, 0.600586, 0.795898);
 cgVertex3f(0.324406, 0.233388, 0.093081);
 cgNormal3f(0.161621, 0.561523, 0.811035);
 cgVertex3f(0.137038, 0.276121, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.146973, 0.611816, 0.776855);
 cgVertex3f(0.140326, 0.236675, 0.162111);
 cgNormal3f(0.081543, 0.729980, 0.677734);
 cgVertex3f(0.314545, 0.216952, 0.148962);
 cgNormal3f(0.103516, 0.925781, 0.362305);
 cgVertex3f(0.321119, 0.226813, 0.119378);
 cgNormal3f(0.231934, 0.852539, 0.467773);
 cgVertex3f(0.140326, 0.256398, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.072754, 0.609863, 0.788574);
 cgVertex3f(0.324406, 0.246536, 0.093081);
 cgNormal3f(0.030273, 0.632324, 0.773926);
 cgVertex3f(1.261244, 0.226813, 0.093081);
 cgNormal3f(0.048340, 0.998535, 0.000000);
 cgVertex3f(1.248095, 0.243249, -0.002246);
 cgNormal3f(0.118652, 0.992676, 0.000000);
 cgVertex3f(0.311257, 0.279408, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.069824, 0.600586, 0.795898);
 cgVertex3f(0.324406, 0.233388, 0.093081);
 cgNormal3f(0.022461, 0.631348, 0.774414);
 cgVertex3f(1.261244, 0.210378, 0.093081);
 cgNormal3f(0.030273, 0.632324, 0.773926);
 cgVertex3f(1.261244, 0.226813, 0.093081);
 cgNormal3f(0.072754, 0.609863, 0.788574);
 cgVertex3f(0.324406, 0.246536, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.103516, 0.925781, 0.362305);
 cgVertex3f(0.321119, 0.226813, 0.119378);
 cgNormal3f(0.027344, 0.948730, 0.313965);
 cgVertex3f(1.257957, 0.207090, 0.112804);
 cgNormal3f(0.022461, 0.631348, 0.774414);
 cgVertex3f(1.261244, 0.210378, 0.093081);
 cgNormal3f(0.069824, 0.600586, 0.795898);
 cgVertex3f(0.324406, 0.233388, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.081543, 0.729980, 0.677734);
 cgVertex3f(0.314545, 0.216952, 0.148962);
 cgNormal3f(0.018555, 0.755371, 0.654297);
 cgVertex3f(1.254669, 0.193942, 0.135814);
 cgNormal3f(0.027344, 0.948730, 0.313965);
 cgVertex3f(1.257957, 0.207090, 0.112804);
 cgNormal3f(0.103516, 0.925781, 0.362305);
 cgVertex3f(0.321119, 0.226813, 0.119378);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.312012, 0.608887, 0.729004);
 cgVertex3f(1.589959, 0.180793, 0.093081);
 cgNormal3f(0.456055, 0.889648, 0.000000);
 cgVertex3f(1.596533, 0.180793, -0.002246);
 cgNormal3f(0.192383, 0.980957, 0.000000);
 cgVertex3f(1.474908, 0.226813, -0.002246);
 cgNormal3f(0.127441, 0.650391, 0.748535);
 cgVertex3f(1.474908, 0.213665, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.127441, 0.650391, 0.748535);
 cgVertex3f(1.474908, 0.213665, 0.093081);
 cgNormal3f(0.092773, 0.619629, 0.778809);
 cgVertex3f(1.474908, 0.200516, 0.093081);
 cgNormal3f(0.262207, 0.541016, 0.798828);
 cgVertex3f(1.580097, 0.174219, 0.093081);
 cgNormal3f(0.312012, 0.608887, 0.729004);
 cgVertex3f(1.589959, 0.180793, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.092773, 0.619629, 0.778809);
 cgVertex3f(1.474908, 0.200516, 0.093081);
 cgNormal3f(0.145020, 0.931641, 0.332520);
 cgVertex3f(1.474908, 0.193942, 0.122665);
 cgNormal3f(0.372559, 0.798828, 0.471680);
 cgVertex3f(1.570236, 0.167645, 0.129239);
 cgNormal3f(0.262207, 0.541016, 0.798828);
 cgVertex3f(1.580097, 0.174219, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.187988, 0.303711, 0.933594);
 cgVertex3f(1.589959, 0.115050, 0.152250);
 cgNormal3f(0.504883, 0.593262, 0.626465);
 cgVertex3f(1.622830, 0.124912, 0.135814);
 cgNormal3f(0.372559, 0.798828, 0.471680);
 cgVertex3f(1.570236, 0.167645, 0.129239);
 cgNormal3f(0.168945, 0.421387, 0.890625);
 cgVertex3f(1.547226, 0.157783, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.288574, 0.005859, 0.957031);
 cgVertex3f(1.662276, 0.000000, 0.158824);
 cgNormal3f(0.724609, 0.005859, 0.688477);
 cgVertex3f(1.691860, 0.000000, 0.139101);
 cgNormal3f(0.625488, 0.384766, 0.677734);
 cgVertex3f(1.668850, 0.069030, 0.139101);
 cgNormal3f(0.235840, 0.208008, 0.948730);
 cgVertex3f(1.632692, 0.069030, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.521973, 0.001465, 0.852539);
 cgVertex3f(1.711583, 0.000000, 0.093081);
 cgNormal3f(0.471680, 0.263184, 0.841309);
 cgVertex3f(1.695147, 0.069030, 0.093081);
 cgNormal3f(0.625488, 0.384766, 0.677734);
 cgVertex3f(1.668850, 0.069030, 0.139101);
 cgNormal3f(0.724609, 0.005859, 0.688477);
 cgVertex3f(1.691860, 0.000000, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.504883, 0.593262, 0.626465);
 cgVertex3f(1.622830, 0.124912, 0.135814);
 cgNormal3f(0.393555, 0.425293, 0.814453);
 cgVertex3f(1.639266, 0.128199, 0.093081);
 cgNormal3f(0.262207, 0.541016, 0.798828);
 cgVertex3f(1.580097, 0.174219, 0.093081);
 cgNormal3f(0.372559, 0.798828, 0.471680);
 cgVertex3f(1.570236, 0.167645, 0.129239);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.393555, 0.425293, 0.814453);
 cgVertex3f(1.639266, 0.128199, 0.093081);
 cgNormal3f(0.452148, 0.529785, 0.716797);
 cgVertex3f(1.655702, 0.134773, 0.093081);
 cgNormal3f(0.312012, 0.608887, 0.729004);
 cgVertex3f(1.589959, 0.180793, 0.093081);
 cgNormal3f(0.262207, 0.541016, 0.798828);
 cgVertex3f(1.580097, 0.174219, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.452148, 0.529785, 0.716797);
 cgVertex3f(1.655702, 0.134773, 0.093081);
 cgNormal3f(0.648926, 0.760742, 0.000000);
 cgVertex3f(1.662276, 0.131486, -0.002246);
 cgNormal3f(0.456055, 0.889648, 0.000000);
 cgVertex3f(1.596533, 0.180793, -0.002246);
 cgNormal3f(0.312012, 0.608887, 0.729004);
 cgVertex3f(1.589959, 0.180793, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.683594, 0.002441, 0.729492);
 cgVertex3f(1.728019, 0.000000, 0.093081);
 cgNormal3f(0.999512, 0.003418, 0.000000);
 cgVertex3f(1.731306, 0.000000, -0.002246);
 cgNormal3f(0.883301, 0.467773, 0.000000);
 cgVertex3f(1.718157, 0.075604, -0.002246);
 cgNormal3f(0.598633, 0.316895, 0.734863);
 cgVertex3f(1.711583, 0.078892, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.088379, 0.003418, 0.995605);
 cgVertex3f(1.445324, 0.000000, 0.178547);
 cgNormal3f(0.070312, 0.176758, 0.981445);
 cgVertex3f(1.445324, 0.075604, 0.168685);
 cgNormal3f(0.048340, 0.245605, 0.967773);
 cgVertex3f(1.254669, 0.078892, 0.181834);
 cgNormal3f(0.062500, 0.003418, 0.997559);
 cgVertex3f(1.254669, 0.000000, 0.201557);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.070312, 0.176758, 0.981445);
 cgVertex3f(1.445324, 0.075604, 0.168685);
 cgNormal3f(0.052734, 0.305176, 0.950684);
 cgVertex3f(1.445324, 0.164357, 0.152250);
 cgNormal3f(0.026367, 0.422363, 0.905762);
 cgVertex3f(1.248095, 0.167645, 0.155537);
 cgNormal3f(0.048340, 0.245605, 0.967773);
 cgVertex3f(1.254669, 0.078892, 0.181834);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.145020, 0.931641, 0.332520);
 cgVertex3f(1.474908, 0.193942, 0.122665);
 cgNormal3f(0.092773, 0.619629, 0.778809);
 cgVertex3f(1.474908, 0.200516, 0.093081);
 cgNormal3f(0.022461, 0.631348, 0.774414);
 cgVertex3f(1.261244, 0.210378, 0.093081);
 cgNormal3f(0.027344, 0.948730, 0.313965);
 cgVertex3f(1.257957, 0.207090, 0.112804);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.092773, 0.619629, 0.778809);
 cgVertex3f(1.474908, 0.200516, 0.093081);
 cgNormal3f(0.127441, 0.650391, 0.748535);
 cgVertex3f(1.474908, 0.213665, 0.093081);
 cgNormal3f(0.030273, 0.632324, 0.773926);
 cgVertex3f(1.261244, 0.226813, 0.093081);
 cgNormal3f(0.022461, 0.631348, 0.774414);
 cgVertex3f(1.261244, 0.210378, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.127441, 0.650391, 0.748535);
 cgVertex3f(1.474908, 0.213665, 0.093081);
 cgNormal3f(0.192383, 0.980957, 0.000000);
 cgVertex3f(1.474908, 0.226813, -0.002246);
 cgNormal3f(0.048340, 0.998535, 0.000000);
 cgVertex3f(1.248095, 0.243249, -0.002246);
 cgNormal3f(0.030273, 0.632324, 0.773926);
 cgVertex3f(1.261244, 0.226813, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.052734, 0.305176, 0.950684);
 cgVertex3f(1.445324, 0.164357, 0.152250);
 cgNormal3f(0.099609, 0.680664, 0.725098);
 cgVertex3f(1.474908, 0.190655, 0.139101);
 cgNormal3f(0.018555, 0.755371, 0.654297);
 cgVertex3f(1.254669, 0.193942, 0.135814);
 cgNormal3f(0.026367, 0.422363, 0.905762);
 cgVertex3f(1.248095, 0.167645, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.099609, 0.680664, 0.725098);
 cgVertex3f(1.474908, 0.190655, 0.139101);
 cgNormal3f(0.145020, 0.931641, 0.332520);
 cgVertex3f(1.474908, 0.193942, 0.122665);
 cgNormal3f(0.027344, 0.948730, 0.313965);
 cgVertex3f(1.257957, 0.207090, 0.112804);
 cgNormal3f(0.018555, 0.755371, 0.654297);
 cgVertex3f(1.254669, 0.193942, 0.135814);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.080566, 0.000488, 0.996582);
 cgVertex3f(-0.957582, 0.000000, 0.254151);
 cgNormal3f(-0.057129, 0.176270, 0.982422);
 cgVertex3f(-0.951008, 0.115050, 0.244290);
 cgNormal3f(-0.104492, 0.124023, 0.986328);
 cgVertex3f(-1.102217, 0.118337, 0.231141);
 cgNormal3f(-0.124512, 0.000977, 0.992188);
 cgVertex3f(-1.105504, 0.000000, 0.241003);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.057129, 0.176270, 0.982422);
 cgVertex3f(-0.951008, 0.115050, 0.244290);
 cgNormal3f(0.001465, 0.261719, 0.964844);
 cgVertex3f(-0.941147, 0.223526, 0.214705);
 cgNormal3f(-0.061035, 0.197754, 0.978027);
 cgVertex3f(-1.095643, 0.226813, 0.214705);
 cgNormal3f(-0.104492, 0.124023, 0.986328);
 cgVertex3f(-1.102217, 0.118337, 0.231141);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.001465, 0.261719, 0.964844);
 cgVertex3f(-0.941147, 0.223526, 0.214705);
 cgNormal3f(0.079590, 0.375977, 0.922852);
 cgVertex3f(-0.931285, 0.417468, 0.162111);
 cgNormal3f(-0.025391, 0.358887, 0.932617);
 cgVertex3f(-1.079207, 0.437191, 0.165398);
 cgNormal3f(-0.061035, 0.197754, 0.978027);
 cgVertex3f(-1.095643, 0.226813, 0.214705);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.079590, 0.375977, 0.922852);
 cgVertex3f(-0.931285, 0.417468, 0.162111);
 cgNormal3f(0.176270, 0.743652, 0.644043);
 cgVertex3f(-0.924711, 0.447052, 0.145675);
 cgNormal3f(0.006348, 0.745117, 0.666016);
 cgVertex3f(-1.072633, 0.470062, 0.148962);
 cgNormal3f(-0.025391, 0.358887, 0.932617);
 cgVertex3f(-1.079207, 0.437191, 0.165398);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.176270, 0.743652, 0.644043);
 cgVertex3f(-0.924711, 0.447052, 0.145675);
 cgNormal3f(0.126465, 0.559570, 0.818359);
 cgVertex3f(-0.921424, 0.466775, 0.093081);
 cgNormal3f(0.015137, 0.553711, 0.832031);
 cgVertex3f(-1.072633, 0.489785, 0.093081);
 cgNormal3f(0.006348, 0.745117, 0.666016);
 cgVertex3f(-1.072633, 0.470062, 0.148962);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.126465, 0.559570, 0.818359);
 cgVertex3f(-0.921424, 0.466775, 0.093081);
 cgNormal3f(0.150879, 0.638672, 0.753906);
 cgVertex3f(-0.921424, 0.479924, 0.093081);
 cgNormal3f(0.020996, 0.643066, 0.765137);
 cgVertex3f(-1.072633, 0.499647, 0.093081);
 cgNormal3f(0.015137, 0.553711, 0.832031);
 cgVertex3f(-1.072633, 0.489785, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.150879, 0.638672, 0.753906);
 cgVertex3f(-0.921424, 0.479924, 0.093081);
 cgNormal3f(0.227051, 0.973633, -0.004395);
 cgVertex3f(-0.921424, 0.493072, -0.002246);
 cgNormal3f(0.028320, 0.999512, 0.000000);
 cgVertex3f(-1.072633, 0.519370, -0.002246);
 cgNormal3f(0.020996, 0.643066, 0.765137);
 cgVertex3f(-1.072633, 0.499647, 0.093081);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.497070, 0.498047, 0.710449);
 cgVertex3f(-1.503249, 0.407607, 0.093081);
 cgNormal3f(-0.325195, 0.615234, 0.717773);
 cgVertex3f(-1.450655, 0.447052, 0.093081);
 cgNormal3f(-0.430176, 0.902344, 0.000000);
 cgVertex3f(-1.444080, 0.450339, -0.002246);
 cgNormal3f(-0.462402, 0.873047, -0.154297);
 cgVertex3f(-1.450655, 0.447052, -0.097574);
 cgNormal3f(-0.724609, 0.688477, -0.039551);
 cgVertex3f(-1.503249, 0.407607, -0.097574);
 cgNormal3f(-0.747070, 0.664551, 0.000000);
 cgVertex3f(-1.503249, 0.404319, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.497070, 0.498047, 0.710449);
 cgVertex3f(-1.503249, 0.407607, 0.093081);
 cgNormal3f(-0.421387, 0.363281, 0.830566);
 cgVertex3f(-1.493388, 0.397745, 0.093081);
 cgNormal3f(-0.254883, 0.467773, 0.846191);
 cgVertex3f(-1.444080, 0.437191, 0.093081);
 cgNormal3f(-0.325195, 0.615234, 0.717773);
 cgVertex3f(-1.450655, 0.447052, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.421387, 0.363281, 0.830566);
 cgVertex3f(-1.493388, 0.397745, 0.093081);
 cgNormal3f(-0.623047, 0.528809, 0.575684);
 cgVertex3f(-1.490101, 0.384596, 0.122665);
 cgNormal3f(-0.368652, 0.693848, 0.618164);
 cgVertex3f(-1.444080, 0.424042, 0.119378);
 cgNormal3f(-0.254883, 0.467773, 0.846191);
 cgVertex3f(-1.444080, 0.437191, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.623047, 0.528809, 0.575684);
 cgVertex3f(-1.490101, 0.384596, 0.122665);
 cgNormal3f(-0.329590, 0.286133, 0.899414);
 cgVertex3f(-1.473665, 0.361586, 0.148962);
 cgNormal3f(-0.213867, 0.441895, 0.871094);
 cgVertex3f(-1.437506, 0.391171, 0.145675);
 cgNormal3f(-0.368652, 0.693848, 0.618164);
 cgVertex3f(-1.444080, 0.424042, 0.119378);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.329590, 0.286133, 0.899414);
 cgVertex3f(-1.473665, 0.361586, 0.148962);
 cgNormal3f(-0.142578, 0.128418, 0.980957);
 cgVertex3f(-1.355327, 0.216952, 0.185121);
 cgNormal3f(-0.112793, 0.374023, 0.920410);
 cgVertex3f(-1.355327, 0.414181, 0.145675);
 cgNormal3f(-0.213867, 0.441895, 0.871094);
 cgVertex3f(-1.437506, 0.391171, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.648926, 0.760742, 0.000000);
 cgVertex3f(1.662276, 0.131486, -0.002246);
 cgNormal3f(0.452148, 0.529785, 0.716797);
 cgVertex3f(1.655702, 0.134773, 0.093081);
 cgNormal3f(0.598633, 0.316895, 0.734863);
 cgVertex3f(1.711583, 0.078892, 0.093081);
 cgNormal3f(0.883301, 0.467773, 0.000000);
 cgVertex3f(1.718157, 0.075604, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.452148, 0.529785, 0.716797);
 cgVertex3f(1.655702, 0.134773, 0.093081);
 cgNormal3f(0.393555, 0.425293, 0.814453);
 cgVertex3f(1.639266, 0.128199, 0.093081);
 cgNormal3f(0.471680, 0.263184, 0.841309);
 cgVertex3f(1.695147, 0.069030, 0.093081);
 cgNormal3f(0.598633, 0.316895, 0.734863);
 cgVertex3f(1.711583, 0.078892, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.393555, 0.425293, 0.814453);
 cgVertex3f(1.639266, 0.128199, 0.093081);
 cgNormal3f(0.504883, 0.593262, 0.626465);
 cgVertex3f(1.622830, 0.124912, 0.135814);
 cgNormal3f(0.625488, 0.384766, 0.677734);
 cgVertex3f(1.668850, 0.069030, 0.139101);
 cgNormal3f(0.471680, 0.263184, 0.841309);
 cgVertex3f(1.695147, 0.069030, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.504883, 0.593262, 0.626465);
 cgVertex3f(1.622830, 0.124912, 0.135814);
 cgNormal3f(0.187988, 0.303711, 0.933594);
 cgVertex3f(1.589959, 0.115050, 0.152250);
 cgNormal3f(0.235840, 0.208008, 0.948730);
 cgVertex3f(1.632692, 0.069030, 0.155537);
 cgNormal3f(0.625488, 0.384766, 0.677734);
 cgVertex3f(1.668850, 0.069030, 0.139101);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.052734, 0.305176, 0.950684);
 cgVertex3f(1.445324, 0.164357, 0.152250);
 cgNormal3f(0.168945, 0.421387, 0.890625);
 cgVertex3f(1.547226, 0.157783, 0.145675);
 cgNormal3f(0.099609, 0.680664, 0.725098);
 cgVertex3f(1.474908, 0.190655, 0.139101);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.187988, 0.303711, 0.933594);
 cgVertex3f(1.589959, 0.115050, 0.152250);
 cgNormal3f(0.070312, 0.176758, 0.981445);
 cgVertex3f(1.445324, 0.075604, 0.168685);
 cgNormal3f(0.235840, 0.208008, 0.948730);
 cgVertex3f(1.632692, 0.069030, 0.155537);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.168945, 0.421387, 0.890625);
 cgVertex3f(1.547226, 0.157783, 0.145675);
 cgNormal3f(0.070312, 0.176758, 0.981445);
 cgVertex3f(1.445324, 0.075604, 0.168685);
 cgNormal3f(0.187988, 0.303711, 0.933594);
 cgVertex3f(1.589959, 0.115050, 0.152250);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.069824, 0.180176, -0.981445);
 cgVertex3f(1.468334, 0.075604, -0.176465);
 cgNormal3f(0.175781, 0.421875, -0.889648);
 cgVertex3f(1.573523, 0.161070, -0.153455);
 cgNormal3f(0.210938, 0.335449, -0.917969);
 cgVertex3f(1.616256, 0.118337, -0.156743);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.069824, 0.180176, -0.981445);
 cgVertex3f(1.468334, 0.075604, -0.176465);
 cgNormal3f(0.210938, 0.335449, -0.917969);
 cgVertex3f(1.616256, 0.118337, -0.156743);
 cgNormal3f(0.207031, 0.225098, -0.952148);
 cgVertex3f(1.658989, 0.075604, -0.163317);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.175781, 0.421875, -0.889648);
 cgVertex3f(1.573523, 0.161070, -0.153455);
 cgNormal3f(0.039551, 0.314941, -0.948242);
 cgVertex3f(1.468334, 0.167645, -0.156743);
 cgNormal3f(0.096680, 0.651855, -0.752441);
 cgVertex3f(1.501206, 0.193942, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.210938, 0.335449, -0.917969);
 cgVertex3f(1.616256, 0.118337, -0.156743);
 cgNormal3f(0.523438, 0.647949, -0.552734);
 cgVertex3f(1.649127, 0.124912, -0.140307);
 cgNormal3f(0.650879, 0.433594, -0.623047);
 cgVertex3f(1.698434, 0.075604, -0.150168);
 cgNormal3f(0.207031, 0.225098, -0.952148);
 cgVertex3f(1.658989, 0.075604, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.523438, 0.647949, -0.552734);
 cgVertex3f(1.649127, 0.124912, -0.140307);
 cgNormal3f(0.645996, 0.753418, -0.119629);
 cgVertex3f(1.655702, 0.134773, -0.097574);
 cgNormal3f(0.867188, 0.480469, -0.129883);
 cgVertex3f(1.711583, 0.078892, -0.097574);
 cgNormal3f(0.650879, 0.433594, -0.623047);
 cgVertex3f(1.698434, 0.075604, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.645996, 0.753418, -0.119629);
 cgVertex3f(1.655702, 0.134773, -0.097574);
 cgNormal3f(0.648926, 0.760742, 0.000000);
 cgVertex3f(1.662276, 0.131486, -0.002246);
 cgNormal3f(0.883301, 0.467773, 0.000000);
 cgVertex3f(1.718157, 0.075604, -0.002246);
 cgNormal3f(0.867188, 0.480469, -0.129883);
 cgVertex3f(1.711583, 0.078892, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.140137, 0.126465, -0.982422);
 cgVertex3f(-1.378338, 0.220239, -0.189614);
 cgNormal3f(-0.341309, 0.270020, -0.900879);
 cgVertex3f(-1.499962, 0.364874, -0.153455);
 cgNormal3f(-0.237793, 0.453613, -0.858887);
 cgVertex3f(-1.463803, 0.401032, -0.153455);
 cgNormal3f(-0.114746, 0.398438, -0.910156);
 cgVertex3f(-1.378338, 0.424042, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.341309, 0.270020, -0.900879);
 cgVertex3f(-1.499962, 0.364874, -0.153455);
 cgNormal3f(-0.684082, 0.582031, -0.439941);
 cgVertex3f(-1.516398, 0.391171, -0.127158);
 cgNormal3f(-0.400391, 0.747559, -0.530273);
 cgVertex3f(-1.467091, 0.430617, -0.123871);
 cgNormal3f(-0.237793, 0.453613, -0.858887);
 cgVertex3f(-1.463803, 0.401032, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.684082, 0.582031, -0.439941);
 cgVertex3f(-1.516398, 0.391171, -0.127158);
 cgNormal3f(-0.724609, 0.688477, -0.039551);
 cgVertex3f(-1.503249, 0.407607, -0.097574);
 cgNormal3f(-0.462402, 0.873047, -0.154297);
 cgVertex3f(-1.450655, 0.447052, -0.097574);
 cgNormal3f(-0.400391, 0.747559, -0.530273);
 cgVertex3f(-1.467091, 0.430617, -0.123871);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.227051, 0.973633, -0.004395);
 cgVertex3f(-0.921424, 0.493072, -0.002246);
 cgNormal3f(0.208984, 0.931152, -0.297852);
 cgVertex3f(-0.921424, 0.479924, -0.097574);
 cgNormal3f(0.019531, 0.952637, -0.302734);
 cgVertex3f(-1.072633, 0.499647, -0.097574);
 cgNormal3f(0.028320, 0.999512, 0.000000);
 cgVertex3f(-1.072633, 0.519370, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.208984, 0.931152, -0.297852);
 cgVertex3f(-0.921424, 0.479924, -0.097574);
 cgNormal3f(0.164551, 0.717773, -0.676270);
 cgVertex3f(-0.941147, 0.456914, -0.150168);
 cgNormal3f(0.001953, 0.753418, -0.657227);
 cgVertex3f(-1.089068, 0.476637, -0.153455);
 cgNormal3f(0.019531, 0.952637, -0.302734);
 cgVertex3f(-1.072633, 0.499647, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.164551, 0.717773, -0.676270);
 cgVertex3f(-0.941147, 0.456914, -0.150168);
 cgNormal3f(0.084961, 0.390137, -0.916992);
 cgVertex3f(-0.947721, 0.424042, -0.169891);
 cgNormal3f(-0.026855, 0.395020, -0.918457);
 cgVertex3f(-1.095643, 0.447052, -0.173178);
 cgNormal3f(0.001953, 0.753418, -0.657227);
 cgVertex3f(-1.089068, 0.476637, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.084961, 0.390137, -0.916992);
 cgVertex3f(-0.947721, 0.424042, -0.169891);
 cgNormal3f(0.005371, 0.257324, -0.966309);
 cgVertex3f(-0.957582, 0.230100, -0.222486);
 cgNormal3f(-0.064453, 0.197754, -0.978516);
 cgVertex3f(-1.115366, 0.230100, -0.222486);
 cgNormal3f(-0.026855, 0.395020, -0.918457);
 cgVertex3f(-1.095643, 0.447052, -0.173178);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.005371, 0.257324, -0.966309);
 cgVertex3f(-0.957582, 0.230100, -0.222486);
 cgNormal3f(-0.055176, 0.171387, -0.983887);
 cgVertex3f(-0.967444, 0.115050, -0.252070);
 cgNormal3f(-0.103027, 0.121094, -0.987305);
 cgVertex3f(-1.121940, 0.121625, -0.238921);
 cgNormal3f(-0.064453, 0.197754, -0.978516);
 cgVertex3f(-1.115366, 0.230100, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.055176, 0.171387, -0.983887);
 cgVertex3f(-0.967444, 0.115050, -0.252070);
 cgNormal3f(-0.079102, 0.000977, -0.997070);
 cgVertex3f(-0.974018, 0.000000, -0.261931);
 cgNormal3f(-0.118652, 0.000977, -0.993164);
 cgVertex3f(-1.125227, 0.000000, -0.248783);
 cgNormal3f(-0.103027, 0.121094, -0.987305);
 cgVertex3f(-1.121940, 0.121625, -0.238921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.167480, 0.914551, -0.367676);
 cgVertex3f(1.501206, 0.200516, -0.127158);
 cgNormal3f(0.096680, 0.651855, -0.752441);
 cgVertex3f(1.501206, 0.193942, -0.146881);
 cgNormal3f(0.021484, 0.664551, -0.747070);
 cgVertex3f(1.277679, 0.193942, -0.143594);
 cgNormal3f(0.038574, 0.908203, -0.416016);
 cgVertex3f(1.280967, 0.223526, -0.117297);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.096680, 0.651855, -0.752441);
 cgVertex3f(1.501206, 0.193942, -0.146881);
 cgNormal3f(0.039551, 0.314941, -0.948242);
 cgVertex3f(1.468334, 0.167645, -0.156743);
 cgNormal3f(0.027344, 0.416016, -0.909180);
 cgVertex3f(1.271105, 0.170932, -0.163317);
 cgNormal3f(0.021484, 0.664551, -0.747070);
 cgVertex3f(1.277679, 0.193942, -0.143594);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.192383, 0.980957, 0.000000);
 cgVertex3f(1.474908, 0.226813, -0.002246);
 cgNormal3f(0.183594, 0.969727, -0.160645);
 cgVertex3f(1.474908, 0.213665, -0.097574);
 cgNormal3f(0.047852, 0.981445, -0.185547);
 cgVertex3f(1.261244, 0.226813, -0.097574);
 cgNormal3f(0.048340, 0.998535, 0.000000);
 cgVertex3f(1.248095, 0.243249, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.183594, 0.969727, -0.160645);
 cgVertex3f(1.474908, 0.213665, -0.097574);
 cgNormal3f(0.167480, 0.914551, -0.367676);
 cgVertex3f(1.501206, 0.200516, -0.127158);
 cgNormal3f(0.038574, 0.908203, -0.416016);
 cgVertex3f(1.280967, 0.223526, -0.117297);
 cgNormal3f(0.047852, 0.981445, -0.185547);
 cgVertex3f(1.261244, 0.226813, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.039551, 0.314941, -0.948242);
 cgVertex3f(1.468334, 0.167645, -0.156743);
 cgNormal3f(0.069824, 0.180176, -0.981445);
 cgVertex3f(1.468334, 0.075604, -0.176465);
 cgNormal3f(0.047363, 0.239746, -0.969727);
 cgVertex3f(1.274392, 0.078892, -0.189614);
 cgNormal3f(0.027344, 0.416016, -0.909180);
 cgVertex3f(1.271105, 0.170932, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.069824, 0.180176, -0.981445);
 cgVertex3f(1.468334, 0.075604, -0.176465);
 cgNormal3f(0.085938, 0.002441, -0.996582);
 cgVertex3f(1.468334, 0.000000, -0.186327);
 cgNormal3f(0.057617, 0.004395, -0.998535);
 cgVertex3f(1.277679, 0.000000, -0.206050);
 cgNormal3f(0.047363, 0.239746, -0.969727);
 cgVertex3f(1.274392, 0.078892, -0.189614);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.999512, 0.003418, 0.000000);
 cgVertex3f(1.731306, 0.000000, -0.002246);
 cgNormal3f(0.992676, 0.003906, -0.119629);
 cgVertex3f(1.728019, 0.000000, -0.097574);
 cgNormal3f(0.867188, 0.480469, -0.129883);
 cgVertex3f(1.711583, 0.078892, -0.097574);
 cgNormal3f(0.883301, 0.467773, 0.000000);
 cgVertex3f(1.718157, 0.075604, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.648926, 0.760742, 0.000000);
 cgVertex3f(1.662276, 0.131486, -0.002246);
 cgNormal3f(0.645996, 0.753418, -0.119629);
 cgVertex3f(1.655702, 0.134773, -0.097574);
 cgNormal3f(0.450684, 0.883789, -0.122070);
 cgVertex3f(1.589959, 0.180793, -0.097574);
 cgNormal3f(0.456055, 0.889648, 0.000000);
 cgVertex3f(1.596533, 0.180793, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.450684, 0.883789, -0.122070);
 cgVertex3f(1.589959, 0.180793, -0.097574);
 cgNormal3f(0.645996, 0.753418, -0.119629);
 cgVertex3f(1.655702, 0.134773, -0.097574);
 cgNormal3f(0.523438, 0.647949, -0.552734);
 cgVertex3f(1.649127, 0.124912, -0.140307);
 cgNormal3f(0.403809, 0.804199, -0.435547);
 cgVertex3f(1.596533, 0.170932, -0.133732);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.763184, 0.003906, -0.645996);
 cgVertex3f(1.721445, 0.000000, -0.150168);
 cgNormal3f(0.650879, 0.433594, -0.623047);
 cgVertex3f(1.698434, 0.075604, -0.150168);
 cgNormal3f(0.867188, 0.480469, -0.129883);
 cgVertex3f(1.711583, 0.078892, -0.097574);
 cgNormal3f(0.992676, 0.003906, -0.119629);
 cgVertex3f(1.728019, 0.000000, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.763184, 0.003906, -0.645996);
 cgVertex3f(1.721445, 0.000000, -0.150168);
 cgNormal3f(0.225098, 0.001953, -0.974609);
 cgVertex3f(1.691860, 0.000000, -0.163317);
 cgNormal3f(0.207031, 0.225098, -0.952148);
 cgVertex3f(1.658989, 0.075604, -0.163317);
 cgNormal3f(0.650879, 0.433594, -0.623047);
 cgVertex3f(1.698434, 0.075604, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.523438, 0.647949, -0.552734);
 cgVertex3f(1.649127, 0.124912, -0.140307);
 cgNormal3f(0.210938, 0.335449, -0.917969);
 cgVertex3f(1.616256, 0.118337, -0.156743);
 cgNormal3f(0.175781, 0.421875, -0.889648);
 cgVertex3f(1.573523, 0.161070, -0.153455);
 cgNormal3f(0.403809, 0.804199, -0.435547);
 cgVertex3f(1.596533, 0.170932, -0.133732);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.403809, 0.804199, -0.435547);
 cgVertex3f(1.596533, 0.170932, -0.133732);
 cgNormal3f(0.167480, 0.914551, -0.367676);
 cgVertex3f(1.501206, 0.200516, -0.127158);
 cgNormal3f(0.183594, 0.969727, -0.160645);
 cgVertex3f(1.474908, 0.213665, -0.097574);
 cgNormal3f(0.450684, 0.883789, -0.122070);
 cgVertex3f(1.589959, 0.180793, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.456055, 0.889648, 0.000000);
 cgVertex3f(1.596533, 0.180793, -0.002246);
 cgNormal3f(0.450684, 0.883789, -0.122070);
 cgVertex3f(1.589959, 0.180793, -0.097574);
 cgNormal3f(0.183594, 0.969727, -0.160645);
 cgVertex3f(1.474908, 0.213665, -0.097574);
 cgNormal3f(0.192383, 0.980957, 0.000000);
 cgVertex3f(1.474908, 0.226813, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.021484, 0.664551, -0.747070);
 cgVertex3f(1.277679, 0.193942, -0.143594);
 cgNormal3f(0.067871, 0.620605, -0.781250);
 cgVertex3f(0.321119, 0.220239, -0.153455);
 cgNormal3f(0.092285, 0.873047, -0.478516);
 cgVertex3f(0.327693, 0.243249, -0.127158);
 cgNormal3f(0.038574, 0.908203, -0.416016);
 cgVertex3f(1.280967, 0.223526, -0.117297);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.038574, 0.908203, -0.416016);
 cgVertex3f(1.280967, 0.223526, -0.117297);
 cgNormal3f(0.092285, 0.873047, -0.478516);
 cgVertex3f(0.327693, 0.243249, -0.127158);
 cgNormal3f(0.107422, 0.966309, -0.232422);
 cgVertex3f(0.324406, 0.246536, -0.097574);
 cgNormal3f(0.047852, 0.981445, -0.185547);
 cgVertex3f(1.261244, 0.226813, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047852, 0.981445, -0.185547);
 cgVertex3f(1.261244, 0.226813, -0.097574);
 cgNormal3f(0.107422, 0.966309, -0.232422);
 cgVertex3f(0.324406, 0.246536, -0.097574);
 cgNormal3f(0.118652, 0.992676, 0.000000);
 cgVertex3f(0.311257, 0.279408, -0.002246);
 cgNormal3f(0.048340, 0.998535, 0.000000);
 cgVertex3f(1.248095, 0.243249, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.067871, 0.620605, -0.781250);
 cgVertex3f(0.321119, 0.220239, -0.153455);
 cgNormal3f(0.134277, 0.553223, -0.822266);
 cgVertex3f(0.140326, 0.239962, -0.166604);
 cgNormal3f(0.207520, 0.795410, -0.569336);
 cgVertex3f(0.140326, 0.262972, -0.143594);
 cgNormal3f(0.092285, 0.873047, -0.478516);
 cgVertex3f(0.327693, 0.243249, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.092285, 0.873047, -0.478516);
 cgVertex3f(0.327693, 0.243249, -0.127158);
 cgNormal3f(0.207520, 0.795410, -0.569336);
 cgVertex3f(0.140326, 0.262972, -0.143594);
 cgNormal3f(0.247070, 0.924316, -0.289551);
 cgVertex3f(0.137038, 0.292556, -0.097574);
 cgNormal3f(0.107422, 0.966309, -0.232422);
 cgVertex3f(0.324406, 0.246536, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.107422, 0.966309, -0.232422);
 cgVertex3f(0.324406, 0.246536, -0.097574);
 cgNormal3f(0.247070, 0.924316, -0.289551);
 cgVertex3f(0.137038, 0.292556, -0.097574);
 cgNormal3f(0.258789, 0.965332, 0.000000);
 cgVertex3f(0.127177, 0.312279, -0.002246);
 cgNormal3f(0.118652, 0.992676, 0.000000);
 cgVertex3f(0.311257, 0.279408, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.031250, 0.218262, -0.975586);
 cgVertex3f(-0.549976, 0.108476, -0.255357);
 cgNormal3f(0.035645, 0.211914, -0.977051);
 cgVertex3f(-0.319875, 0.108476, -0.245496);
 cgNormal3f(0.035156, 0.001953, -0.999512);
 cgVertex3f(-0.323162, 0.000000, -0.258644);
 cgNormal3f(0.033203, 0.001465, -0.999512);
 cgVertex3f(-0.556550, 0.000000, -0.265218);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.051270, 0.002930, -0.999023);
 cgVertex3f(0.130464, 0.000000, -0.242208);
 cgNormal3f(0.041504, 0.002441, -0.999512);
 cgVertex3f(-0.076626, 0.000000, -0.248783);
 cgNormal3f(0.051758, 0.225098, -0.973145);
 cgVertex3f(-0.070052, 0.095327, -0.238921);
 cgNormal3f(0.062012, 0.263672, -0.962891);
 cgVertex3f(0.137038, 0.095327, -0.225773);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.035645, 0.211914, -0.977051);
 cgVertex3f(-0.319875, 0.108476, -0.245496);
 cgNormal3f(0.051758, 0.225098, -0.973145);
 cgVertex3f(-0.070052, 0.095327, -0.238921);
 cgNormal3f(0.041504, 0.002441, -0.999512);
 cgVertex3f(-0.076626, 0.000000, -0.248783);
 cgNormal3f(0.035156, 0.001953, -0.999512);
 cgVertex3f(-0.323162, 0.000000, -0.258644);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.134277, 0.553223, -0.822266);
 cgVertex3f(0.140326, 0.239962, -0.166604);
 cgNormal3f(0.129395, 0.480469, -0.867188);
 cgVertex3f(-0.066765, 0.312279, -0.160030);
 cgNormal3f(0.210449, 0.738770, -0.639648);
 cgVertex3f(-0.063478, 0.338576, -0.140307);
 cgNormal3f(0.207520, 0.795410, -0.569336);
 cgVertex3f(0.140326, 0.262972, -0.143594);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207520, 0.795410, -0.569336);
 cgVertex3f(0.140326, 0.262972, -0.143594);
 cgNormal3f(0.210449, 0.738770, -0.639648);
 cgVertex3f(-0.063478, 0.338576, -0.140307);
 cgNormal3f(0.252441, 0.922363, -0.291992);
 cgVertex3f(-0.070052, 0.364874, -0.097574);
 cgNormal3f(0.247070, 0.924316, -0.289551);
 cgVertex3f(0.137038, 0.292556, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.247070, 0.924316, -0.289551);
 cgVertex3f(0.137038, 0.292556, -0.097574);
 cgNormal3f(0.252441, 0.922363, -0.291992);
 cgVertex3f(-0.070052, 0.364874, -0.097574);
 cgNormal3f(0.257324, 0.965820, 0.000000);
 cgVertex3f(-0.079913, 0.374735, -0.002246);
 cgNormal3f(0.258789, 0.965332, 0.000000);
 cgVertex3f(0.127177, 0.312279, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.257324, 0.965820, 0.000000);
 cgVertex3f(-0.079913, 0.374735, -0.002246);
 cgNormal3f(0.252441, 0.922363, -0.291992);
 cgVertex3f(-0.070052, 0.364874, -0.097574);
 cgNormal3f(0.090820, 0.958496, -0.270508);
 cgVertex3f(-0.310014, 0.414181, -0.097574);
 cgNormal3f(0.091797, 0.995605, 0.000000);
 cgVertex3f(-0.310014, 0.424042, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.090820, 0.958496, -0.270508);
 cgVertex3f(-0.310014, 0.414181, -0.097574);
 cgNormal3f(0.252441, 0.922363, -0.291992);
 cgVertex3f(-0.070052, 0.364874, -0.097574);
 cgNormal3f(0.210449, 0.738770, -0.639648);
 cgVertex3f(-0.063478, 0.338576, -0.140307);
 cgNormal3f(0.073730, 0.742188, -0.666504);
 cgVertex3f(-0.313301, 0.391171, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.210449, 0.738770, -0.639648);
 cgVertex3f(-0.063478, 0.338576, -0.140307);
 cgNormal3f(0.129395, 0.480469, -0.867188);
 cgVertex3f(-0.066765, 0.312279, -0.160030);
 cgNormal3f(0.041504, 0.441406, -0.896484);
 cgVertex3f(-0.310014, 0.364874, -0.163317);
 cgNormal3f(0.073730, 0.742188, -0.666504);
 cgVertex3f(-0.313301, 0.391171, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.072266, 0.339355, -0.937988);
 cgVertex3f(-0.066765, 0.210378, -0.199475);
 cgNormal3f(0.031738, 0.327637, -0.944336);
 cgVertex3f(-0.319875, 0.216952, -0.212624);
 cgNormal3f(0.041504, 0.441406, -0.896484);
 cgVertex3f(-0.310014, 0.364874, -0.163317);
 cgNormal3f(0.129395, 0.480469, -0.867188);
 cgVertex3f(-0.066765, 0.312279, -0.160030);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.031738, 0.327637, -0.944336);
 cgVertex3f(-0.319875, 0.216952, -0.212624);
 cgNormal3f(0.023926, 0.338867, -0.940430);
 cgVertex3f(-0.546689, 0.220239, -0.212624);
 cgNormal3f(0.020508, 0.428711, -0.903320);
 cgVertex3f(-0.543402, 0.368161, -0.153455);
 cgNormal3f(0.041504, 0.441406, -0.896484);
 cgVertex3f(-0.310014, 0.364874, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.041504, 0.441406, -0.896484);
 cgVertex3f(-0.310014, 0.364874, -0.163317);
 cgNormal3f(0.020508, 0.428711, -0.903320);
 cgVertex3f(-0.543402, 0.368161, -0.153455);
 cgNormal3f(0.031738, 0.740234, -0.671875);
 cgVertex3f(-0.543402, 0.391171, -0.140307);
 cgNormal3f(0.073730, 0.742188, -0.666504);
 cgVertex3f(-0.313301, 0.391171, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.073730, 0.742188, -0.666504);
 cgVertex3f(-0.313301, 0.391171, -0.146881);
 cgNormal3f(0.031738, 0.740234, -0.671875);
 cgVertex3f(-0.543402, 0.391171, -0.140307);
 cgNormal3f(0.040039, 0.965332, -0.257812);
 cgVertex3f(-0.533540, 0.410894, -0.097574);
 cgNormal3f(0.090820, 0.958496, -0.270508);
 cgVertex3f(-0.310014, 0.414181, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.091797, 0.995605, 0.000000);
 cgVertex3f(-0.310014, 0.424042, -0.002246);
 cgNormal3f(0.090820, 0.958496, -0.270508);
 cgVertex3f(-0.310014, 0.414181, -0.097574);
 cgNormal3f(0.040039, 0.965332, -0.257812);
 cgVertex3f(-0.533540, 0.410894, -0.097574);
 cgNormal3f(0.040527, 0.999023, 0.000000);
 cgVertex3f(-0.530253, 0.417468, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.040039, 0.965332, -0.257812);
 cgVertex3f(-0.533540, 0.410894, -0.097574);
 cgNormal3f(0.031738, 0.740234, -0.671875);
 cgVertex3f(-0.543402, 0.391171, -0.140307);
 cgNormal3f(0.150391, 0.716797, -0.680664);
 cgVertex3f(-0.793225, 0.414181, -0.146881);
 cgNormal3f(0.190430, 0.940918, -0.278809);
 cgVertex3f(-0.770215, 0.433904, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.084473, 0.412109, -0.907227);
 cgVertex3f(-0.796512, 0.381309, -0.166604);
 cgNormal3f(0.150391, 0.716797, -0.680664);
 cgVertex3f(-0.793225, 0.414181, -0.146881);
 cgNormal3f(0.031738, 0.740234, -0.671875);
 cgVertex3f(-0.543402, 0.391171, -0.140307);
 cgNormal3f(0.020508, 0.428711, -0.903320);
 cgVertex3f(-0.543402, 0.368161, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.020508, 0.428711, -0.903320);
 cgVertex3f(-0.543402, 0.368161, -0.153455);
 cgNormal3f(0.023926, 0.338867, -0.940430);
 cgVertex3f(-0.546689, 0.220239, -0.212624);
 cgNormal3f(0.029785, 0.318848, -0.947266);
 cgVertex3f(-0.803086, 0.226813, -0.222486);
 cgNormal3f(0.084473, 0.412109, -0.907227);
 cgVertex3f(-0.796512, 0.381309, -0.166604);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.029785, 0.318848, -0.947266);
 cgVertex3f(-0.803086, 0.226813, -0.222486);
 cgNormal3f(0.005371, 0.257324, -0.966309);
 cgVertex3f(-0.957582, 0.230100, -0.222486);
 cgNormal3f(0.084961, 0.390137, -0.916992);
 cgVertex3f(-0.947721, 0.424042, -0.169891);
 cgNormal3f(0.084473, 0.412109, -0.907227);
 cgVertex3f(-0.796512, 0.381309, -0.166604);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.140137, 0.126465, -0.982422);
 cgVertex3f(-1.378338, 0.220239, -0.189614);
 cgNormal3f(-0.114746, 0.398438, -0.910156);
 cgVertex3f(-1.378338, 0.424042, -0.150168);
 cgNormal3f(-0.026855, 0.395020, -0.918457);
 cgVertex3f(-1.095643, 0.447052, -0.173178);
 cgNormal3f(-0.064453, 0.197754, -0.978516);
 cgVertex3f(-1.115366, 0.230100, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.084961, 0.390137, -0.916992);
 cgVertex3f(-0.947721, 0.424042, -0.169891);
 cgNormal3f(0.164551, 0.717773, -0.676270);
 cgVertex3f(-0.941147, 0.456914, -0.150168);
 cgNormal3f(0.150391, 0.716797, -0.680664);
 cgVertex3f(-0.793225, 0.414181, -0.146881);
 cgNormal3f(0.084473, 0.412109, -0.907227);
 cgVertex3f(-0.796512, 0.381309, -0.166604);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.150391, 0.716797, -0.680664);
 cgVertex3f(-0.793225, 0.414181, -0.146881);
 cgNormal3f(0.164551, 0.717773, -0.676270);
 cgVertex3f(-0.941147, 0.456914, -0.150168);
 cgNormal3f(0.208984, 0.931152, -0.297852);
 cgVertex3f(-0.921424, 0.479924, -0.097574);
 cgNormal3f(0.190430, 0.940918, -0.278809);
 cgVertex3f(-0.770215, 0.433904, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.040527, 0.999023, 0.000000);
 cgVertex3f(-0.530253, 0.417468, -0.002246);
 cgNormal3f(0.040039, 0.965332, -0.257812);
 cgVertex3f(-0.533540, 0.410894, -0.097574);
 cgNormal3f(0.190430, 0.940918, -0.278809);
 cgVertex3f(-0.770215, 0.433904, -0.097574);
 cgNormal3f(0.201172, 0.979492, 0.000000);
 cgVertex3f(-0.766928, 0.443765, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.230469, 0.973145, 0.003906);
 cgVertex3f(-1.352040, 0.489785, -0.002246);
 cgNormal3f(-0.210449, 0.938965, -0.271484);
 cgVertex3f(-1.371763, 0.473350, -0.097574);
 cgNormal3f(-0.462402, 0.873047, -0.154297);
 cgVertex3f(-1.450655, 0.447052, -0.097574);
 cgNormal3f(-0.430176, 0.902344, 0.000000);
 cgVertex3f(-1.444080, 0.450339, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.462402, 0.873047, -0.154297);
 cgVertex3f(-1.450655, 0.447052, -0.097574);
 cgNormal3f(-0.210449, 0.938965, -0.271484);
 cgVertex3f(-1.371763, 0.473350, -0.097574);
 cgNormal3f(-0.169434, 0.765625, -0.620605);
 cgVertex3f(-1.384912, 0.453627, -0.127158);
 cgNormal3f(-0.400391, 0.747559, -0.530273);
 cgVertex3f(-1.467091, 0.430617, -0.123871);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.208984, 0.931152, -0.297852);
 cgVertex3f(-0.921424, 0.479924, -0.097574);
 cgNormal3f(0.227051, 0.973633, -0.004395);
 cgVertex3f(-0.921424, 0.493072, -0.002246);
 cgNormal3f(0.201172, 0.979492, 0.000000);
 cgVertex3f(-0.766928, 0.443765, -0.002246);
 cgNormal3f(0.190430, 0.940918, -0.278809);
 cgVertex3f(-0.770215, 0.433904, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.210449, 0.938965, -0.271484);
 cgVertex3f(-1.371763, 0.473350, -0.097574);
 cgNormal3f(0.019531, 0.952637, -0.302734);
 cgVertex3f(-1.072633, 0.499647, -0.097574);
 cgNormal3f(0.001953, 0.753418, -0.657227);
 cgVertex3f(-1.089068, 0.476637, -0.153455);
 cgNormal3f(-0.169434, 0.765625, -0.620605);
 cgVertex3f(-1.384912, 0.453627, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.019531, 0.952637, -0.302734);
 cgVertex3f(-1.072633, 0.499647, -0.097574);
 cgNormal3f(-0.210449, 0.938965, -0.271484);
 cgVertex3f(-1.371763, 0.473350, -0.097574);
 cgNormal3f(-0.230469, 0.973145, 0.003906);
 cgVertex3f(-1.352040, 0.489785, -0.002246);
 cgNormal3f(0.028320, 0.999512, 0.000000);
 cgVertex3f(-1.072633, 0.519370, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.895020, 0.445801, -0.014648);
 cgVertex3f(-1.545982, 0.345151, -0.097574);
 cgNormal3f(-0.889160, 0.458008, 0.000000);
 cgVertex3f(-1.552556, 0.335289, -0.002246);
 cgNormal3f(-0.747070, 0.664551, 0.000000);
 cgVertex3f(-1.503249, 0.404319, -0.002246);
 cgNormal3f(-0.724609, 0.688477, -0.039551);
 cgVertex3f(-1.503249, 0.407607, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.169434, 0.765625, -0.620605);
 cgVertex3f(-1.384912, 0.453627, -0.127158);
 cgNormal3f(0.001953, 0.753418, -0.657227);
 cgVertex3f(-1.089068, 0.476637, -0.153455);
 cgNormal3f(-0.026855, 0.395020, -0.918457);
 cgVertex3f(-1.095643, 0.447052, -0.173178);
 cgNormal3f(-0.114746, 0.398438, -0.910156);
 cgVertex3f(-1.378338, 0.424042, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.169434, 0.765625, -0.620605);
 cgVertex3f(-1.384912, 0.453627, -0.127158);
 cgNormal3f(-0.114746, 0.398438, -0.910156);
 cgVertex3f(-1.378338, 0.424042, -0.150168);
 cgNormal3f(-0.237793, 0.453613, -0.858887);
 cgVertex3f(-1.463803, 0.401032, -0.153455);
 cgNormal3f(-0.400391, 0.747559, -0.530273);
 cgVertex3f(-1.467091, 0.430617, -0.123871);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.140137, 0.126465, -0.982422);
 cgVertex3f(-1.378338, 0.220239, -0.189614);
 cgNormal3f(-0.353516, 0.144043, -0.924316);
 cgVertex3f(-1.549269, 0.223526, -0.160030);
 cgNormal3f(-0.380371, 0.189941, -0.905273);
 cgVertex3f(-1.522972, 0.308992, -0.153455);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.341309, 0.270020, -0.900879);
 cgVertex3f(-1.499962, 0.364874, -0.153455);
 cgNormal3f(-0.140137, 0.126465, -0.982422);
 cgVertex3f(-1.378338, 0.220239, -0.189614);
 cgNormal3f(-0.380371, 0.189941, -0.905273);
 cgVertex3f(-1.522972, 0.308992, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.684082, 0.582031, -0.439941);
 cgVertex3f(-1.516398, 0.391171, -0.127158);
 cgNormal3f(-0.341309, 0.270020, -0.900879);
 cgVertex3f(-1.499962, 0.364874, -0.153455);
 cgNormal3f(-0.380371, 0.189941, -0.905273);
 cgVertex3f(-1.522972, 0.308992, -0.153455);
 cgNormal3f(-0.809082, 0.388184, -0.441895);
 cgVertex3f(-1.549269, 0.332002, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.380371, 0.189941, -0.905273);
 cgVertex3f(-1.522972, 0.308992, -0.153455);
 cgNormal3f(-0.353516, 0.144043, -0.924316);
 cgVertex3f(-1.549269, 0.223526, -0.160030);
 cgNormal3f(-0.841797, 0.240723, -0.483887);
 cgVertex3f(-1.588715, 0.226813, -0.137020);
 cgNormal3f(-0.809082, 0.388184, -0.441895);
 cgVertex3f(-1.549269, 0.332002, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.841797, 0.240723, -0.483887);
 cgVertex3f(-1.588715, 0.226813, -0.137020);
 cgNormal3f(-0.966797, 0.252441, -0.039062);
 cgVertex3f(-1.588715, 0.220239, -0.097574);
 cgNormal3f(-0.895020, 0.445801, -0.014648);
 cgVertex3f(-1.545982, 0.345151, -0.097574);
 cgNormal3f(-0.809082, 0.388184, -0.441895);
 cgVertex3f(-1.549269, 0.332002, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.809082, 0.388184, -0.441895);
 cgVertex3f(-1.549269, 0.332002, -0.127158);
 cgNormal3f(-0.895020, 0.445801, -0.014648);
 cgVertex3f(-1.545982, 0.345151, -0.097574);
 cgNormal3f(-0.724609, 0.688477, -0.039551);
 cgVertex3f(-1.503249, 0.407607, -0.097574);
 cgNormal3f(-0.684082, 0.582031, -0.439941);
 cgVertex3f(-1.516398, 0.391171, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.966797, 0.255371, 0.000000);
 cgVertex3f(-1.598577, 0.210378, -0.002246);
 cgNormal3f(-0.889160, 0.458008, 0.000000);
 cgVertex3f(-1.552556, 0.335289, -0.002246);
 cgNormal3f(-0.895020, 0.445801, -0.014648);
 cgVertex3f(-1.545982, 0.345151, -0.097574);
 cgNormal3f(-0.966797, 0.252441, -0.039062);
 cgVertex3f(-1.588715, 0.220239, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.029785, 0.318848, -0.947266);
 cgVertex3f(-0.803086, 0.226813, -0.222486);
 cgNormal3f(-0.007812, 0.209961, -0.978027);
 cgVertex3f(-0.812948, 0.111763, -0.261931);
 cgNormal3f(-0.055176, 0.171387, -0.983887);
 cgVertex3f(-0.967444, 0.115050, -0.252070);
 cgNormal3f(0.005371, 0.257324, -0.966309);
 cgVertex3f(-0.957582, 0.230100, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.064453, 0.197754, -0.978516);
 cgVertex3f(-1.115366, 0.230100, -0.222486);
 cgNormal3f(-0.103027, 0.121094, -0.987305);
 cgVertex3f(-1.121940, 0.121625, -0.238921);
 cgNormal3f(-0.170410, 0.078613, -0.982422);
 cgVertex3f(-1.378338, 0.111763, -0.202763);
 cgNormal3f(-0.140137, 0.126465, -0.982422);
 cgVertex3f(-1.378338, 0.220239, -0.189614);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.140137, 0.126465, -0.982422);
 cgVertex3f(-1.378338, 0.220239, -0.189614);
 cgNormal3f(-0.170410, 0.078613, -0.982422);
 cgVertex3f(-1.378338, 0.111763, -0.202763);
 cgNormal3f(-0.358398, 0.062500, -0.931641);
 cgVertex3f(-1.568992, 0.108476, -0.163317);
 cgNormal3f(-0.353516, 0.144043, -0.924316);
 cgVertex3f(-1.549269, 0.223526, -0.160030);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.358398, 0.062500, -0.931641);
 cgVertex3f(-1.568992, 0.108476, -0.163317);
 cgNormal3f(-0.836914, 0.094727, -0.539551);
 cgVertex3f(-1.605151, 0.108476, -0.140307);
 cgNormal3f(-0.841797, 0.240723, -0.483887);
 cgVertex3f(-1.588715, 0.226813, -0.137020);
 cgNormal3f(-0.353516, 0.144043, -0.924316);
 cgVertex3f(-1.549269, 0.223526, -0.160030);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.966797, 0.252441, -0.039062);
 cgVertex3f(-1.588715, 0.220239, -0.097574);
 cgNormal3f(-0.841797, 0.240723, -0.483887);
 cgVertex3f(-1.588715, 0.226813, -0.137020);
 cgNormal3f(-0.836914, 0.094727, -0.539551);
 cgVertex3f(-1.605151, 0.108476, -0.140307);
 cgNormal3f(-0.987793, 0.121094, -0.098633);
 cgVertex3f(-1.611725, 0.095327, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.966797, 0.255371, 0.000000);
 cgVertex3f(-1.598577, 0.210378, -0.002246);
 cgNormal3f(-0.966797, 0.252441, -0.039062);
 cgVertex3f(-1.588715, 0.220239, -0.097574);
 cgNormal3f(-0.987793, 0.121094, -0.098633);
 cgVertex3f(-1.611725, 0.095327, -0.097574);
 cgNormal3f(-0.990723, 0.138184, -0.000488);
 cgVertex3f(-1.618299, 0.095327, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.007812, 0.209961, -0.978027);
 cgVertex3f(-0.812948, 0.111763, -0.261931);
 cgNormal3f(0.029785, 0.318848, -0.947266);
 cgVertex3f(-0.803086, 0.226813, -0.222486);
 cgNormal3f(0.023926, 0.338867, -0.940430);
 cgVertex3f(-0.546689, 0.220239, -0.212624);
 cgNormal3f(0.031250, 0.218262, -0.975586);
 cgVertex3f(-0.549976, 0.108476, -0.255357);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.023926, 0.338867, -0.940430);
 cgVertex3f(-0.546689, 0.220239, -0.212624);
 cgNormal3f(0.031738, 0.327637, -0.944336);
 cgVertex3f(-0.319875, 0.216952, -0.212624);
 cgNormal3f(0.035645, 0.211914, -0.977051);
 cgVertex3f(-0.319875, 0.108476, -0.245496);
 cgNormal3f(0.031250, 0.218262, -0.975586);
 cgVertex3f(-0.549976, 0.108476, -0.255357);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.031738, 0.327637, -0.944336);
 cgVertex3f(-0.319875, 0.216952, -0.212624);
 cgNormal3f(0.072266, 0.339355, -0.937988);
 cgVertex3f(-0.066765, 0.210378, -0.199475);
 cgNormal3f(0.051758, 0.225098, -0.973145);
 cgVertex3f(-0.070052, 0.095327, -0.238921);
 cgNormal3f(0.035645, 0.211914, -0.977051);
 cgVertex3f(-0.319875, 0.108476, -0.245496);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.987793, 0.121094, -0.098633);
 cgVertex3f(-1.611725, 0.095327, -0.097574);
 cgNormal3f(-0.990234, 0.000977, -0.139648);
 cgVertex3f(-1.618299, 0.000000, -0.097574);
 cgNormal3f(-1.000000, 0.002441, -0.000488);
 cgVertex3f(-1.631448, 0.000000, -0.002246);
 cgNormal3f(-0.990723, 0.138184, -0.000488);
 cgVertex3f(-1.618299, 0.095327, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.990234, 0.000977, -0.139648);
 cgVertex3f(-1.618299, 0.000000, -0.097574);
 cgNormal3f(-0.987793, 0.121094, -0.098633);
 cgVertex3f(-1.611725, 0.095327, -0.097574);
 cgNormal3f(-0.836914, 0.094727, -0.539551);
 cgVertex3f(-1.605151, 0.108476, -0.140307);
 cgNormal3f(-0.820801, 0.000488, -0.571777);
 cgVertex3f(-1.608438, 0.000000, -0.143594);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.358398, 0.062500, -0.931641);
 cgVertex3f(-1.568992, 0.108476, -0.163317);
 cgNormal3f(-0.360840, 0.000000, -0.933105);
 cgVertex3f(-1.565705, 0.000000, -0.166604);
 cgNormal3f(-0.820801, 0.000488, -0.571777);
 cgVertex3f(-1.608438, 0.000000, -0.143594);
 cgNormal3f(-0.836914, 0.094727, -0.539551);
 cgVertex3f(-1.605151, 0.108476, -0.140307);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.170410, 0.078613, -0.982422);
 cgVertex3f(-1.378338, 0.111763, -0.202763);
 cgNormal3f(-0.180176, 0.000488, -0.983887);
 cgVertex3f(-1.381625, 0.000000, -0.206050);
 cgNormal3f(-0.360840, 0.000000, -0.933105);
 cgVertex3f(-1.565705, 0.000000, -0.166604);
 cgNormal3f(-0.358398, 0.062500, -0.931641);
 cgVertex3f(-1.568992, 0.108476, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.103027, 0.121094, -0.987305);
 cgVertex3f(-1.121940, 0.121625, -0.238921);
 cgNormal3f(-0.118652, 0.000977, -0.993164);
 cgVertex3f(-1.125227, 0.000000, -0.248783);
 cgNormal3f(-0.180176, 0.000488, -0.983887);
 cgVertex3f(-1.381625, 0.000000, -0.206050);
 cgNormal3f(-0.170410, 0.078613, -0.982422);
 cgVertex3f(-1.378338, 0.111763, -0.202763);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.007812, 0.209961, -0.978027);
 cgVertex3f(-0.812948, 0.111763, -0.261931);
 cgNormal3f(-0.021484, 0.001465, -1.000000);
 cgVertex3f(-0.822809, 0.000000, -0.275080);
 cgNormal3f(-0.079102, 0.000977, -0.997070);
 cgVertex3f(-0.974018, 0.000000, -0.261931);
 cgNormal3f(-0.055176, 0.171387, -0.983887);
 cgVertex3f(-0.967444, 0.115050, -0.252070);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.007812, 0.209961, -0.978027);
 cgVertex3f(-0.812948, 0.111763, -0.261931);
 cgNormal3f(0.031250, 0.218262, -0.975586);
 cgVertex3f(-0.549976, 0.108476, -0.255357);
 cgNormal3f(0.033203, 0.001465, -0.999512);
 cgVertex3f(-0.556550, 0.000000, -0.265218);
 cgNormal3f(-0.021484, 0.001465, -1.000000);
 cgVertex3f(-0.822809, 0.000000, -0.275080);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.403809, 0.804199, -0.435547);
 cgVertex3f(1.596533, 0.170932, -0.133732);
 cgNormal3f(0.175781, 0.421875, -0.889648);
 cgVertex3f(1.573523, 0.161070, -0.153455);
 cgNormal3f(0.096680, 0.651855, -0.752441);
 cgVertex3f(1.501206, 0.193942, -0.146881);
 cgNormal3f(0.167480, 0.914551, -0.367676);
 cgVertex3f(1.501206, 0.200516, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.021484, 0.664551, -0.747070);
 cgVertex3f(1.277679, 0.193942, -0.143594);
 cgNormal3f(0.027344, 0.416016, -0.909180);
 cgVertex3f(1.271105, 0.170932, -0.163317);
 cgNormal3f(0.052246, 0.437500, -0.897949);
 cgVertex3f(0.314545, 0.190655, -0.173178);
 cgNormal3f(0.067871, 0.620605, -0.781250);
 cgVertex3f(0.321119, 0.220239, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.067871, 0.620605, -0.781250);
 cgVertex3f(0.321119, 0.220239, -0.153455);
 cgNormal3f(0.052246, 0.437500, -0.897949);
 cgVertex3f(0.314545, 0.190655, -0.173178);
 cgNormal3f(0.083496, 0.388672, -0.917969);
 cgVertex3f(0.133751, 0.193942, -0.186327);
 cgNormal3f(0.134277, 0.553223, -0.822266);
 cgVertex3f(0.140326, 0.239962, -0.166604);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.134277, 0.553223, -0.822266);
 cgVertex3f(0.140326, 0.239962, -0.166604);
 cgNormal3f(0.083496, 0.388672, -0.917969);
 cgVertex3f(0.133751, 0.193942, -0.186327);
 cgNormal3f(0.072266, 0.339355, -0.937988);
 cgVertex3f(-0.066765, 0.210378, -0.199475);
 cgNormal3f(0.129395, 0.480469, -0.867188);
 cgVertex3f(-0.066765, 0.312279, -0.160030);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.175781, 0.421875, -0.889648);
 cgVertex3f(1.573523, 0.161070, -0.153455);
 cgNormal3f(0.069824, 0.180176, -0.981445);
 cgVertex3f(1.468334, 0.075604, -0.176465);
 cgNormal3f(0.039551, 0.314941, -0.948242);
 cgVertex3f(1.468334, 0.167645, -0.156743);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.027344, 0.416016, -0.909180);
 cgVertex3f(1.271105, 0.170932, -0.163317);
 cgNormal3f(0.047363, 0.239746, -0.969727);
 cgVertex3f(1.274392, 0.078892, -0.189614);
 cgNormal3f(0.043945, 0.280273, -0.958984);
 cgVertex3f(0.311257, 0.095327, -0.212624);
 cgNormal3f(0.052246, 0.437500, -0.897949);
 cgVertex3f(0.314545, 0.190655, -0.173178);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.052246, 0.437500, -0.897949);
 cgVertex3f(0.314545, 0.190655, -0.173178);
 cgNormal3f(0.043945, 0.280273, -0.958984);
 cgVertex3f(0.311257, 0.095327, -0.212624);
 cgNormal3f(0.062012, 0.263672, -0.962891);
 cgVertex3f(0.137038, 0.095327, -0.225773);
 cgNormal3f(0.083496, 0.388672, -0.917969);
 cgVertex3f(0.133751, 0.193942, -0.186327);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.083496, 0.388672, -0.917969);
 cgVertex3f(0.133751, 0.193942, -0.186327);
 cgNormal3f(0.062012, 0.263672, -0.962891);
 cgVertex3f(0.137038, 0.095327, -0.225773);
 cgNormal3f(0.051758, 0.225098, -0.973145);
 cgVertex3f(-0.070052, 0.095327, -0.238921);
 cgNormal3f(0.072266, 0.339355, -0.937988);
 cgVertex3f(-0.066765, 0.210378, -0.199475);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207031, 0.225098, -0.952148);
 cgVertex3f(1.658989, 0.075604, -0.163317);
 cgNormal3f(0.225098, 0.001953, -0.974609);
 cgVertex3f(1.691860, 0.000000, -0.163317);
 cgNormal3f(0.085938, 0.002441, -0.996582);
 cgVertex3f(1.468334, 0.000000, -0.186327);
 cgNormal3f(0.069824, 0.180176, -0.981445);
 cgVertex3f(1.468334, 0.075604, -0.176465);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047363, 0.239746, -0.969727);
 cgVertex3f(1.274392, 0.078892, -0.189614);
 cgNormal3f(0.057617, 0.004395, -0.998535);
 cgVertex3f(1.277679, 0.000000, -0.206050);
 cgNormal3f(0.041504, 0.004395, -0.999512);
 cgVertex3f(0.304683, 0.000000, -0.235634);
 cgNormal3f(0.043945, 0.280273, -0.958984);
 cgVertex3f(0.311257, 0.095327, -0.212624);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.043945, 0.280273, -0.958984);
 cgVertex3f(0.311257, 0.095327, -0.212624);
 cgNormal3f(0.041504, 0.004395, -0.999512);
 cgVertex3f(0.304683, 0.000000, -0.235634);
 cgNormal3f(0.051270, 0.002930, -0.999023);
 cgVertex3f(0.130464, 0.000000, -0.242208);
 cgNormal3f(0.062012, 0.263672, -0.962891);
 cgVertex3f(0.137038, 0.095327, -0.225773);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.524902, 0.000000, 0.851074);
 cgVertex3f(-1.605151, 0.000000, 0.093081);
 cgNormal3f(-0.533203, 0.062988, 0.843262);
 cgVertex3f(-1.598577, 0.108476, 0.093081);
 cgNormal3f(-0.668457, 0.093750, 0.737793);
 cgVertex3f(-1.611725, 0.095327, 0.093081);
 cgNormal3f(-0.668457, 0.001953, 0.743652);
 cgVertex3f(-1.618299, 0.000000, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.599609, -0.314941, 0.735352);
 cgVertex3f(1.711583, -0.082179, 0.093081);
 cgNormal3f(0.683594, 0.002441, 0.729492);
 cgVertex3f(1.728019, 0.000000, 0.093081);
 cgNormal3f(0.521973, 0.001465, 0.852539);
 cgVertex3f(1.711583, 0.000000, 0.093081);
 cgNormal3f(0.471191, -0.270020, 0.839355);
 cgVertex3f(1.695147, -0.072317, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047852, 0.002441, 0.998535);
 cgVertex3f(0.130464, 0.000000, 0.234428);
 cgNormal3f(0.056641, -0.253906, 0.965332);
 cgVertex3f(0.133751, -0.095327, 0.217993);
 cgNormal3f(0.041016, -0.275391, 0.960449);
 cgVertex3f(0.307970, -0.098614, 0.208131);
 cgNormal3f(0.037598, 0.003418, 0.999023);
 cgVertex3f(0.298109, 0.000000, 0.227854);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.037598, 0.003418, 0.999023);
 cgVertex3f(0.298109, 0.000000, 0.227854);
 cgNormal3f(0.041016, -0.275391, 0.960449);
 cgVertex3f(0.307970, -0.098614, 0.208131);
 cgNormal3f(0.048828, -0.242188, 0.968750);
 cgVertex3f(1.254669, -0.082179, 0.181834);
 cgNormal3f(0.062500, 0.003418, 0.997559);
 cgVertex3f(1.254669, 0.000000, 0.201557);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.088379, 0.003418, 0.995605);
 cgVertex3f(1.445324, 0.000000, 0.178547);
 cgNormal3f(0.070312, -0.174805, 0.981934);
 cgVertex3f(1.445324, -0.078892, 0.168685);
 cgNormal3f(0.241211, -0.214355, 0.946289);
 cgVertex3f(1.632692, -0.075604, 0.155537);
 cgNormal3f(0.288574, 0.005859, 0.957031);
 cgVertex3f(1.662276, 0.000000, 0.158824);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.050293, -0.222656, 0.973633);
 cgVertex3f(-0.066765, -0.098614, 0.231141);
 cgNormal3f(0.066406, -0.336426, 0.938965);
 cgVertex3f(-0.066765, -0.210378, 0.191695);
 cgNormal3f(0.080566, -0.392090, 0.916016);
 cgVertex3f(0.133751, -0.197229, 0.181834);
 cgNormal3f(0.056641, -0.253906, 0.965332);
 cgVertex3f(0.133751, -0.095327, 0.217993);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.056641, -0.253906, 0.965332);
 cgVertex3f(0.133751, -0.095327, 0.217993);
 cgNormal3f(0.080566, -0.392090, 0.916016);
 cgVertex3f(0.133751, -0.197229, 0.181834);
 cgNormal3f(0.055664, -0.452148, 0.890137);
 cgVertex3f(0.307970, -0.190655, 0.168685);
 cgNormal3f(0.041016, -0.275391, 0.960449);
 cgVertex3f(0.307970, -0.098614, 0.208131);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.041016, -0.275391, 0.960449);
 cgVertex3f(0.307970, -0.098614, 0.208131);
 cgNormal3f(0.055664, -0.452148, 0.890137);
 cgVertex3f(0.307970, -0.190655, 0.168685);
 cgNormal3f(0.026367, -0.428711, 0.902832);
 cgVertex3f(1.248095, -0.170932, 0.155537);
 cgNormal3f(0.048828, -0.242188, 0.968750);
 cgVertex3f(1.254669, -0.082179, 0.181834);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.052734, -0.305664, 0.950684);
 cgVertex3f(1.445324, -0.167645, 0.152250);
 cgNormal3f(0.169922, -0.408203, 0.896484);
 cgVertex3f(1.547226, -0.161070, 0.145675);
 cgNormal3f(0.070312, -0.174805, 0.981934);
 cgVertex3f(1.445324, -0.078892, 0.168685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.066406, -0.336426, 0.938965);
 cgVertex3f(-0.066765, -0.210378, 0.191695);
 cgNormal3f(0.129395, -0.500000, 0.855957);
 cgVertex3f(-0.063478, -0.308992, 0.155537);
 cgNormal3f(0.149414, -0.607910, 0.779785);
 cgVertex3f(0.140326, -0.239962, 0.162111);
 cgNormal3f(0.080566, -0.392090, 0.916016);
 cgVertex3f(0.133751, -0.197229, 0.181834);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.080566, -0.392090, 0.916016);
 cgVertex3f(0.133751, -0.197229, 0.181834);
 cgNormal3f(0.149414, -0.607910, 0.779785);
 cgVertex3f(0.140326, -0.239962, 0.162111);
 cgNormal3f(0.083496, -0.723145, 0.685547);
 cgVertex3f(0.314545, -0.216952, 0.148962);
 cgNormal3f(0.055664, -0.452148, 0.890137);
 cgVertex3f(0.307970, -0.190655, 0.168685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.055664, -0.452148, 0.890137);
 cgVertex3f(0.307970, -0.190655, 0.168685);
 cgNormal3f(0.083496, -0.723145, 0.685547);
 cgVertex3f(0.314545, -0.216952, 0.148962);
 cgNormal3f(0.018066, -0.752930, 0.658203);
 cgVertex3f(1.254669, -0.197229, 0.135814);
 cgNormal3f(0.026367, -0.428711, 0.902832);
 cgVertex3f(1.248095, -0.170932, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.096680, -0.664062, 0.741211);
 cgVertex3f(1.474908, -0.193942, 0.139101);
 cgNormal3f(0.147949, -0.932617, 0.329102);
 cgVertex3f(1.474908, -0.200516, 0.122665);
 cgNormal3f(0.382812, -0.785645, 0.485352);
 cgVertex3f(1.570236, -0.170932, 0.129239);
 cgNormal3f(0.169922, -0.408203, 0.896484);
 cgVertex3f(1.547226, -0.161070, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.034180, 0.000977, 0.999023);
 cgVertex3f(-0.546689, 0.000000, 0.257438);
 cgNormal3f(-0.020996, 0.000488, 0.999512);
 cgVertex3f(-0.809661, 0.000000, 0.267300);
 cgNormal3f(-0.008789, -0.208984, 0.977539);
 cgVertex3f(-0.796512, -0.111763, 0.254151);
 cgNormal3f(0.032227, -0.212402, 0.976562);
 cgVertex3f(-0.540114, -0.108476, 0.247577);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.080566, 0.000488, 0.996582);
 cgVertex3f(-0.957582, 0.000000, 0.254151);
 cgNormal3f(-0.055664, -0.174805, 0.982910);
 cgVertex3f(-0.951008, -0.118337, 0.244290);
 cgNormal3f(-0.008789, -0.208984, 0.977539);
 cgVertex3f(-0.796512, -0.111763, 0.254151);
 cgNormal3f(-0.020996, 0.000488, 0.999512);
 cgVertex3f(-0.809661, 0.000000, 0.267300);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.177734, 0.000488, 0.983887);
 cgVertex3f(-1.358615, 0.000000, 0.198270);
 cgNormal3f(-0.166992, -0.074219, 0.982910);
 cgVertex3f(-1.355327, -0.111763, 0.191695);
 cgNormal3f(-0.104492, -0.123047, 0.986816);
 cgVertex3f(-1.102217, -0.121625, 0.231141);
 cgNormal3f(-0.124512, 0.000977, 0.992188);
 cgVertex3f(-1.105504, 0.000000, 0.241003);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.354980, 0.000000, 0.934570);
 cgVertex3f(-1.539408, 0.000000, 0.158824);
 cgNormal3f(-0.365723, -0.061035, 0.928711);
 cgVertex3f(-1.542695, -0.108476, 0.158824);
 cgNormal3f(-0.166992, -0.074219, 0.982910);
 cgVertex3f(-1.355327, -0.111763, 0.191695);
 cgNormal3f(-0.177734, 0.000488, 0.983887);
 cgVertex3f(-1.358615, 0.000000, 0.198270);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.729980, 0.000488, 0.683594);
 cgVertex3f(-1.582141, 0.000000, 0.139101);
 cgNormal3f(-0.746094, -0.091797, 0.659668);
 cgVertex3f(-1.578854, -0.108476, 0.132527);
 cgNormal3f(-0.365723, -0.061035, 0.928711);
 cgVertex3f(-1.542695, -0.108476, 0.158824);
 cgNormal3f(-0.354980, 0.000000, 0.934570);
 cgVertex3f(-1.539408, 0.000000, 0.158824);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.524902, 0.000000, 0.851074);
 cgVertex3f(-1.605151, 0.000000, 0.093081);
 cgNormal3f(-0.533203, -0.062988, 0.843262);
 cgVertex3f(-1.598577, -0.111763, 0.093081);
 cgNormal3f(-0.746094, -0.091797, 0.659668);
 cgVertex3f(-1.578854, -0.108476, 0.132527);
 cgNormal3f(-0.729980, 0.000488, 0.683594);
 cgVertex3f(-1.582141, 0.000000, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-1.000000, 0.002441, -0.000488);
 cgVertex3f(-1.631448, 0.000000, -0.002246);
 cgNormal3f(-0.990723, -0.138184, 0.000000);
 cgVertex3f(-1.618299, -0.101902, -0.002246);
 cgNormal3f(-0.668457, -0.093262, 0.737793);
 cgVertex3f(-1.611725, -0.101902, 0.093081);
 cgNormal3f(-0.668457, 0.001953, 0.743652);
 cgVertex3f(-1.618299, 0.000000, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.050293, -0.222656, 0.973633);
 cgVertex3f(-0.066765, -0.098614, 0.231141);
 cgNormal3f(0.037598, -0.209961, 0.976562);
 cgVertex3f(-0.313301, -0.108476, 0.237715);
 cgNormal3f(0.034180, -0.326172, 0.944336);
 cgVertex3f(-0.313301, -0.216952, 0.204844);
 cgNormal3f(0.066406, -0.336426, 0.938965);
 cgVertex3f(-0.066765, -0.210378, 0.191695);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.037598, -0.209961, 0.976562);
 cgVertex3f(-0.313301, -0.108476, 0.237715);
 cgNormal3f(0.032227, -0.212402, 0.976562);
 cgVertex3f(-0.540114, -0.108476, 0.247577);
 cgNormal3f(0.026367, -0.337402, 0.940918);
 cgVertex3f(-0.536827, -0.220239, 0.208131);
 cgNormal3f(0.034180, -0.326172, 0.944336);
 cgVertex3f(-0.313301, -0.216952, 0.204844);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.026367, -0.337402, 0.940918);
 cgVertex3f(-0.536827, -0.220239, 0.208131);
 cgNormal3f(0.032227, -0.212402, 0.976562);
 cgVertex3f(-0.540114, -0.108476, 0.247577);
 cgNormal3f(-0.008789, -0.208984, 0.977539);
 cgVertex3f(-0.796512, -0.111763, 0.254151);
 cgNormal3f(0.025391, -0.318848, 0.947266);
 cgVertex3f(-0.789938, -0.226813, 0.214705);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.668457, -0.093262, 0.737793);
 cgVertex3f(-1.611725, -0.101902, 0.093081);
 cgNormal3f(-0.990723, -0.138184, 0.000000);
 cgVertex3f(-1.618299, -0.101902, -0.002246);
 cgNormal3f(-0.966309, -0.258301, 0.000000);
 cgVertex3f(-1.598577, -0.213665, -0.002246);
 cgNormal3f(-0.661133, -0.176758, 0.729004);
 cgVertex3f(-1.588715, -0.223526, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.533203, -0.062988, 0.843262);
 cgVertex3f(-1.598577, -0.111763, 0.093081);
 cgNormal3f(-0.668457, -0.093262, 0.737793);
 cgVertex3f(-1.611725, -0.101902, 0.093081);
 cgNormal3f(-0.661133, -0.176758, 0.729004);
 cgVertex3f(-1.588715, -0.223526, 0.093081);
 cgNormal3f(-0.534668, -0.152344, 0.831055);
 cgVertex3f(-1.575567, -0.226813, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.746094, -0.091797, 0.659668);
 cgVertex3f(-1.578854, -0.108476, 0.132527);
 cgNormal3f(-0.533203, -0.062988, 0.843262);
 cgVertex3f(-1.598577, -0.111763, 0.093081);
 cgNormal3f(-0.534668, -0.152344, 0.831055);
 cgVertex3f(-1.575567, -0.226813, 0.093081);
 cgNormal3f(-0.750488, -0.224609, 0.621582);
 cgVertex3f(-1.562418, -0.226813, 0.129239);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.750488, -0.224609, 0.621582);
 cgVertex3f(-1.562418, -0.226813, 0.129239);
 cgNormal3f(-0.375488, -0.135254, 0.916504);
 cgVertex3f(-1.526259, -0.223526, 0.152250);
 cgNormal3f(-0.365723, -0.061035, 0.928711);
 cgVertex3f(-1.542695, -0.108476, 0.158824);
 cgNormal3f(-0.746094, -0.091797, 0.659668);
 cgVertex3f(-1.578854, -0.108476, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.365723, -0.061035, 0.928711);
 cgVertex3f(-1.542695, -0.108476, 0.158824);
 cgNormal3f(-0.375488, -0.135254, 0.916504);
 cgVertex3f(-1.526259, -0.223526, 0.152250);
 cgNormal3f(-0.142578, -0.128906, 0.980957);
 cgVertex3f(-1.355327, -0.220239, 0.185121);
 cgNormal3f(-0.166992, -0.074219, 0.982910);
 cgVertex3f(-1.355327, -0.111763, 0.191695);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.166992, -0.074219, 0.982910);
 cgVertex3f(-1.355327, -0.111763, 0.191695);
 cgNormal3f(-0.142578, -0.128906, 0.980957);
 cgVertex3f(-1.355327, -0.220239, 0.185121);
 cgNormal3f(-0.061035, -0.198242, 0.978027);
 cgVertex3f(-1.095643, -0.230100, 0.214705);
 cgNormal3f(-0.104492, -0.123047, 0.986816);
 cgVertex3f(-1.102217, -0.121625, 0.231141);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.055664, -0.174805, 0.982910);
 cgVertex3f(-0.951008, -0.118337, 0.244290);
 cgNormal3f(0.001953, -0.260742, 0.965332);
 cgVertex3f(-0.941147, -0.226813, 0.214705);
 cgNormal3f(0.025391, -0.318848, 0.947266);
 cgVertex3f(-0.789938, -0.226813, 0.214705);
 cgNormal3f(-0.008789, -0.208984, 0.977539);
 cgVertex3f(-0.796512, -0.111763, 0.254151);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.534668, -0.152344, 0.831055);
 cgVertex3f(-1.575567, -0.226813, 0.093081);
 cgNormal3f(-0.661133, -0.176758, 0.729004);
 cgVertex3f(-1.588715, -0.223526, 0.093081);
 cgNormal3f(-0.620117, -0.319824, 0.716309);
 cgVertex3f(-1.545982, -0.348438, 0.093081);
 cgNormal3f(-0.506836, -0.249023, 0.825195);
 cgVertex3f(-1.532834, -0.338576, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.620117, -0.319824, 0.716309);
 cgVertex3f(-1.545982, -0.348438, 0.093081);
 cgNormal3f(-0.661133, -0.176758, 0.729004);
 cgVertex3f(-1.588715, -0.223526, 0.093081);
 cgNormal3f(-0.966309, -0.258301, 0.000000);
 cgVertex3f(-1.598577, -0.213665, -0.002246);
 cgNormal3f(-0.889160, -0.458496, 0.000000);
 cgVertex3f(-1.552556, -0.338576, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.506836, -0.249023, 0.825195);
 cgVertex3f(-1.532834, -0.338576, 0.093081);
 cgNormal3f(-0.620117, -0.319824, 0.716309);
 cgVertex3f(-1.545982, -0.348438, 0.093081);
 cgNormal3f(-0.497070, -0.498535, 0.710449);
 cgVertex3f(-1.503249, -0.410894, 0.093081);
 cgNormal3f(-0.421387, -0.363770, 0.830566);
 cgVertex3f(-1.493388, -0.401032, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.421387, -0.363770, 0.830566);
 cgVertex3f(-1.493388, -0.401032, 0.093081);
 cgNormal3f(-0.629395, -0.528809, 0.569824);
 cgVertex3f(-1.490101, -0.387884, 0.122665);
 cgNormal3f(-0.732422, -0.351562, 0.583496);
 cgVertex3f(-1.522972, -0.328715, 0.122665);
 cgNormal3f(-0.506836, -0.249023, 0.825195);
 cgVertex3f(-1.532834, -0.338576, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.506836, -0.249023, 0.825195);
 cgVertex3f(-1.532834, -0.338576, 0.093081);
 cgNormal3f(-0.732422, -0.351562, 0.583496);
 cgVertex3f(-1.522972, -0.328715, 0.122665);
 cgNormal3f(-0.750488, -0.224609, 0.621582);
 cgVertex3f(-1.562418, -0.226813, 0.129239);
 cgNormal3f(-0.534668, -0.152344, 0.831055);
 cgVertex3f(-1.575567, -0.226813, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.750488, -0.224609, 0.621582);
 cgVertex3f(-1.562418, -0.226813, 0.129239);
 cgNormal3f(-0.732422, -0.351562, 0.583496);
 cgVertex3f(-1.522972, -0.328715, 0.122665);
 cgNormal3f(-0.397949, -0.185547, 0.898438);
 cgVertex3f(-1.496675, -0.308992, 0.148962);
 cgNormal3f(-0.375488, -0.135254, 0.916504);
 cgVertex3f(-1.526259, -0.223526, 0.152250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.397949, -0.185547, 0.898438);
 cgVertex3f(-1.496675, -0.308992, 0.148962);
 cgNormal3f(-0.732422, -0.351562, 0.583496);
 cgVertex3f(-1.522972, -0.328715, 0.122665);
 cgNormal3f(-0.629395, -0.528809, 0.569824);
 cgVertex3f(-1.490101, -0.387884, 0.122665);
 cgNormal3f(-0.337891, -0.288086, 0.895996);
 cgVertex3f(-1.473665, -0.364874, 0.148962);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.397949, -0.185547, 0.898438);
 cgVertex3f(-1.496675, -0.308992, 0.148962);
 cgNormal3f(-0.337891, -0.288086, 0.895996);
 cgVertex3f(-1.473665, -0.364874, 0.148962);
 cgNormal3f(-0.142578, -0.128906, 0.980957);
 cgVertex3f(-1.355327, -0.220239, 0.185121);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.397949, -0.185547, 0.898438);
 cgVertex3f(-1.496675, -0.308992, 0.148962);
 cgNormal3f(-0.142578, -0.128906, 0.980957);
 cgVertex3f(-1.355327, -0.220239, 0.185121);
 cgNormal3f(-0.375488, -0.135254, 0.916504);
 cgVertex3f(-1.526259, -0.223526, 0.152250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.222656, -0.452637, 0.863281);
 cgVertex3f(-1.437506, -0.397745, 0.145675);
 cgNormal3f(-0.374023, -0.699707, 0.608887);
 cgVertex3f(-1.444080, -0.427329, 0.119378);
 cgNormal3f(-0.164551, -0.738770, 0.653320);
 cgVertex3f(-1.361902, -0.450339, 0.122665);
 cgNormal3f(-0.111328, -0.385742, 0.915527);
 cgVertex3f(-1.355327, -0.417468, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.004883, -0.744629, 0.667480);
 cgVertex3f(-1.072633, -0.470062, 0.148962);
 cgNormal3f(-0.164551, -0.738770, 0.653320);
 cgVertex3f(-1.361902, -0.450339, 0.122665);
 cgNormal3f(-0.105957, -0.512695, 0.852051);
 cgVertex3f(-1.365189, -0.466775, 0.093081);
 cgNormal3f(0.013184, -0.543945, 0.838867);
 cgVertex3f(-1.072633, -0.493072, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.025391, -0.369629, 0.928711);
 cgVertex3f(-1.079207, -0.440478, 0.165398);
 cgNormal3f(-0.111328, -0.385742, 0.915527);
 cgVertex3f(-1.355327, -0.417468, 0.145675);
 cgNormal3f(-0.164551, -0.738770, 0.653320);
 cgVertex3f(-1.361902, -0.450339, 0.122665);
 cgNormal3f(0.004883, -0.744629, 0.667480);
 cgVertex3f(-1.072633, -0.470062, 0.148962);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.374023, -0.699707, 0.608887);
 cgVertex3f(-1.444080, -0.427329, 0.119378);
 cgNormal3f(-0.254883, -0.468262, 0.846191);
 cgVertex3f(-1.444080, -0.440478, 0.093081);
 cgNormal3f(-0.105957, -0.512695, 0.852051);
 cgVertex3f(-1.365189, -0.466775, 0.093081);
 cgNormal3f(-0.164551, -0.738770, 0.653320);
 cgVertex3f(-1.361902, -0.450339, 0.122665);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.747070, -0.665039, 0.000000);
 cgVertex3f(-1.503249, -0.407607, -0.002246);
 cgNormal3f(-0.497070, -0.498535, 0.710449);
 cgVertex3f(-1.503249, -0.410894, 0.093081);
 cgNormal3f(-0.620117, -0.319824, 0.716309);
 cgVertex3f(-1.545982, -0.348438, 0.093081);
 cgNormal3f(-0.889160, -0.458496, 0.000000);
 cgVertex3f(-1.552556, -0.338576, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.231445, -0.973145, 0.000000);
 cgVertex3f(-1.352040, -0.493072, -0.002246);
 cgNormal3f(0.029785, -1.000000, 0.000000);
 cgVertex3f(-1.072633, -0.522657, -0.002246);
 cgNormal3f(0.019043, -0.646484, 0.762695);
 cgVertex3f(-1.072633, -0.506221, 0.093081);
 cgNormal3f(-0.154297, -0.647949, 0.745605);
 cgVertex3f(-1.371763, -0.476637, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.154297, -0.647949, 0.745605);
 cgVertex3f(-1.371763, -0.476637, 0.093081);
 cgNormal3f(0.019043, -0.646484, 0.762695);
 cgVertex3f(-1.072633, -0.506221, 0.093081);
 cgNormal3f(0.013184, -0.543945, 0.838867);
 cgVertex3f(-1.072633, -0.493072, 0.093081);
 cgNormal3f(-0.105957, -0.512695, 0.852051);
 cgVertex3f(-1.365189, -0.466775, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.201172, -0.979492, 0.000000);
 cgVertex3f(-0.766928, -0.447052, -0.002246);
 cgNormal3f(0.134277, -0.653809, 0.744629);
 cgVertex3f(-0.770215, -0.437191, 0.093081);
 cgNormal3f(0.150879, -0.639160, 0.753906);
 cgVertex3f(-0.921424, -0.483211, 0.093081);
 cgNormal3f(0.229492, -0.973633, 0.000000);
 cgVertex3f(-0.921424, -0.496360, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.325195, -0.615723, 0.717773);
 cgVertex3f(-1.450655, -0.450339, 0.093081);
 cgNormal3f(-0.154297, -0.647949, 0.745605);
 cgVertex3f(-1.371763, -0.476637, 0.093081);
 cgNormal3f(-0.105957, -0.512695, 0.852051);
 cgVertex3f(-1.365189, -0.466775, 0.093081);
 cgNormal3f(-0.254883, -0.468262, 0.846191);
 cgVertex3f(-1.444080, -0.440478, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.325195, -0.615723, 0.717773);
 cgVertex3f(-1.450655, -0.450339, 0.093081);
 cgNormal3f(-0.430176, -0.902832, 0.000000);
 cgVertex3f(-1.444080, -0.453627, -0.002246);
 cgNormal3f(-0.231445, -0.973145, 0.000000);
 cgVertex3f(-1.352040, -0.493072, -0.002246);
 cgNormal3f(-0.154297, -0.647949, 0.745605);
 cgVertex3f(-1.371763, -0.476637, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.134277, -0.653809, 0.744629);
 cgVertex3f(-0.770215, -0.437191, 0.093081);
 cgNormal3f(0.201172, -0.979492, 0.000000);
 cgVertex3f(-0.766928, -0.447052, -0.002246);
 cgNormal3f(0.040527, -0.999512, 0.000000);
 cgVertex3f(-0.530253, -0.420755, -0.002246);
 cgNormal3f(0.027344, -0.674316, 0.737793);
 cgVertex3f(-0.533540, -0.414181, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.027344, -0.674316, 0.737793);
 cgVertex3f(-0.533540, -0.414181, 0.093081);
 cgNormal3f(0.023438, -0.579590, 0.814453);
 cgVertex3f(-0.533540, -0.401032, 0.093081);
 cgNormal3f(0.112305, -0.572754, 0.812012);
 cgVertex3f(-0.770215, -0.424042, 0.093081);
 cgNormal3f(0.134277, -0.653809, 0.744629);
 cgVertex3f(-0.770215, -0.437191, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.134277, -0.653809, 0.744629);
 cgVertex3f(-0.770215, -0.437191, 0.093081);
 cgNormal3f(0.112305, -0.572754, 0.812012);
 cgVertex3f(-0.770215, -0.424042, 0.093081);
 cgNormal3f(0.122559, -0.555664, 0.822266);
 cgVertex3f(-0.921424, -0.470062, 0.093081);
 cgNormal3f(0.150879, -0.639160, 0.753906);
 cgVertex3f(-0.921424, -0.483211, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.112305, -0.572754, 0.812012);
 cgVertex3f(-0.770215, -0.424042, 0.093081);
 cgNormal3f(0.159180, -0.775391, 0.611328);
 cgVertex3f(-0.780076, -0.410894, 0.139101);
 cgNormal3f(0.171875, -0.744141, 0.645508);
 cgVertex3f(-0.924711, -0.450339, 0.145675);
 cgNormal3f(0.122559, -0.555664, 0.822266);
 cgVertex3f(-0.921424, -0.470062, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.159180, -0.775391, 0.611328);
 cgVertex3f(-0.780076, -0.410894, 0.139101);
 cgNormal3f(0.083496, -0.432617, 0.897461);
 cgVertex3f(-0.783363, -0.378022, 0.162111);
 cgNormal3f(0.079102, -0.381348, 0.920898);
 cgVertex3f(-0.931285, -0.420755, 0.162111);
 cgNormal3f(0.171875, -0.744141, 0.645508);
 cgVertex3f(-0.924711, -0.450339, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.025391, -0.369629, 0.928711);
 cgVertex3f(-1.079207, -0.440478, 0.165398);
 cgNormal3f(-0.061035, -0.198242, 0.978027);
 cgVertex3f(-1.095643, -0.230100, 0.214705);
 cgNormal3f(-0.142578, -0.128906, 0.980957);
 cgVertex3f(-1.355327, -0.220239, 0.185121);
 cgNormal3f(-0.111328, -0.385742, 0.915527);
 cgVertex3f(-1.355327, -0.417468, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.079102, -0.381348, 0.920898);
 cgVertex3f(-0.931285, -0.420755, 0.162111);
 cgNormal3f(0.083496, -0.432617, 0.897461);
 cgVertex3f(-0.783363, -0.378022, 0.162111);
 cgNormal3f(0.025391, -0.318848, 0.947266);
 cgVertex3f(-0.789938, -0.226813, 0.214705);
 cgNormal3f(0.001953, -0.260742, 0.965332);
 cgVertex3f(-0.941147, -0.226813, 0.214705);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.025391, -0.318848, 0.947266);
 cgVertex3f(-0.789938, -0.226813, 0.214705);
 cgNormal3f(0.083496, -0.432617, 0.897461);
 cgVertex3f(-0.783363, -0.378022, 0.162111);
 cgNormal3f(0.023926, -0.463379, 0.885742);
 cgVertex3f(-0.533540, -0.368161, 0.145675);
 cgNormal3f(0.026367, -0.337402, 0.940918);
 cgVertex3f(-0.536827, -0.220239, 0.208131);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.033203, -0.794922, 0.605957);
 cgVertex3f(-0.533540, -0.387884, 0.132527);
 cgNormal3f(0.023926, -0.463379, 0.885742);
 cgVertex3f(-0.533540, -0.368161, 0.145675);
 cgNormal3f(0.083496, -0.432617, 0.897461);
 cgVertex3f(-0.783363, -0.378022, 0.162111);
 cgNormal3f(0.159180, -0.775391, 0.611328);
 cgVertex3f(-0.780076, -0.410894, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.159180, -0.775391, 0.611328);
 cgVertex3f(-0.780076, -0.410894, 0.139101);
 cgNormal3f(0.112305, -0.572754, 0.812012);
 cgVertex3f(-0.770215, -0.424042, 0.093081);
 cgNormal3f(0.023438, -0.579590, 0.814453);
 cgVertex3f(-0.533540, -0.401032, 0.093081);
 cgNormal3f(0.033203, -0.794922, 0.605957);
 cgVertex3f(-0.533540, -0.387884, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.027344, -0.674316, 0.737793);
 cgVertex3f(-0.533540, -0.414181, 0.093081);
 cgNormal3f(0.040527, -0.999512, 0.000000);
 cgVertex3f(-0.530253, -0.420755, -0.002246);
 cgNormal3f(0.091797, -0.996094, 0.000000);
 cgVertex3f(-0.310014, -0.427329, -0.002246);
 cgNormal3f(0.061523, -0.670410, 0.739258);
 cgVertex3f(-0.310014, -0.417468, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.061523, -0.670410, 0.739258);
 cgVertex3f(-0.310014, -0.417468, 0.093081);
 cgNormal3f(0.055664, -0.562988, 0.824219);
 cgVertex3f(-0.306727, -0.407607, 0.093081);
 cgNormal3f(0.023438, -0.579590, 0.814453);
 cgVertex3f(-0.533540, -0.401032, 0.093081);
 cgNormal3f(0.027344, -0.674316, 0.737793);
 cgVertex3f(-0.533540, -0.414181, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.023438, -0.579590, 0.814453);
 cgVertex3f(-0.533540, -0.401032, 0.093081);
 cgNormal3f(0.055664, -0.562988, 0.824219);
 cgVertex3f(-0.306727, -0.407607, 0.093081);
 cgNormal3f(0.077637, -0.789062, 0.609375);
 cgVertex3f(-0.306727, -0.387884, 0.139101);
 cgNormal3f(0.033203, -0.794922, 0.605957);
 cgVertex3f(-0.533540, -0.387884, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.033203, -0.794922, 0.605957);
 cgVertex3f(-0.533540, -0.387884, 0.132527);
 cgNormal3f(0.077637, -0.789062, 0.609375);
 cgVertex3f(-0.306727, -0.387884, 0.139101);
 cgNormal3f(0.042969, -0.465820, 0.883789);
 cgVertex3f(-0.306727, -0.364874, 0.155537);
 cgNormal3f(0.023926, -0.463379, 0.885742);
 cgVertex3f(-0.533540, -0.368161, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.023926, -0.463379, 0.885742);
 cgVertex3f(-0.533540, -0.368161, 0.145675);
 cgNormal3f(0.042969, -0.465820, 0.883789);
 cgVertex3f(-0.306727, -0.364874, 0.155537);
 cgNormal3f(0.034180, -0.326172, 0.944336);
 cgVertex3f(-0.313301, -0.216952, 0.204844);
 cgNormal3f(0.026367, -0.337402, 0.940918);
 cgVertex3f(-0.536827, -0.220239, 0.208131);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.042969, -0.465820, 0.883789);
 cgVertex3f(-0.306727, -0.364874, 0.155537);
 cgNormal3f(0.129395, -0.500000, 0.855957);
 cgVertex3f(-0.063478, -0.308992, 0.155537);
 cgNormal3f(0.066406, -0.336426, 0.938965);
 cgVertex3f(-0.066765, -0.210378, 0.191695);
 cgNormal3f(0.034180, -0.326172, 0.944336);
 cgVertex3f(-0.313301, -0.216952, 0.204844);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.042969, -0.465820, 0.883789);
 cgVertex3f(-0.306727, -0.364874, 0.155537);
 cgNormal3f(0.077637, -0.789062, 0.609375);
 cgVertex3f(-0.306727, -0.387884, 0.139101);
 cgNormal3f(0.229492, -0.795898, 0.560059);
 cgVertex3f(-0.063478, -0.338576, 0.132527);
 cgNormal3f(0.129395, -0.500000, 0.855957);
 cgVertex3f(-0.063478, -0.308992, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.077637, -0.789062, 0.609375);
 cgVertex3f(-0.306727, -0.387884, 0.139101);
 cgNormal3f(0.055664, -0.562988, 0.824219);
 cgVertex3f(-0.306727, -0.407607, 0.093081);
 cgNormal3f(0.161621, -0.554199, 0.816406);
 cgVertex3f(-0.076626, -0.355012, 0.093081);
 cgNormal3f(0.229492, -0.795898, 0.560059);
 cgVertex3f(-0.063478, -0.338576, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.055664, -0.562988, 0.824219);
 cgVertex3f(-0.306727, -0.407607, 0.093081);
 cgNormal3f(0.061523, -0.670410, 0.739258);
 cgVertex3f(-0.310014, -0.417468, 0.093081);
 cgNormal3f(0.172363, -0.646973, 0.742676);
 cgVertex3f(-0.070052, -0.368161, 0.093081);
 cgNormal3f(0.161621, -0.554199, 0.816406);
 cgVertex3f(-0.076626, -0.355012, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.061523, -0.670410, 0.739258);
 cgVertex3f(-0.310014, -0.417468, 0.093081);
 cgNormal3f(0.091797, -0.996094, 0.000000);
 cgVertex3f(-0.310014, -0.427329, -0.002246);
 cgNormal3f(0.257324, -0.966309, 0.000000);
 cgVertex3f(-0.079913, -0.378022, -0.002246);
 cgNormal3f(0.172363, -0.646973, 0.742676);
 cgVertex3f(-0.070052, -0.368161, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.257324, -0.966309, 0.000000);
 cgVertex3f(-0.079913, -0.378022, -0.002246);
 cgNormal3f(0.263184, -0.964844, 0.000000);
 cgVertex3f(0.127177, -0.315566, -0.002246);
 cgNormal3f(0.169434, -0.621582, 0.764648);
 cgVertex3f(0.137038, -0.295843, 0.093081);
 cgNormal3f(0.172363, -0.646973, 0.742676);
 cgVertex3f(-0.070052, -0.368161, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.172363, -0.646973, 0.742676);
 cgVertex3f(-0.070052, -0.368161, 0.093081);
 cgNormal3f(0.169434, -0.621582, 0.764648);
 cgVertex3f(0.137038, -0.295843, 0.093081);
 cgNormal3f(0.161621, -0.562012, 0.811035);
 cgVertex3f(0.137038, -0.279408, 0.093081);
 cgNormal3f(0.161621, -0.554199, 0.816406);
 cgVertex3f(-0.076626, -0.355012, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.161621, -0.554199, 0.816406);
 cgVertex3f(-0.076626, -0.355012, 0.093081);
 cgNormal3f(0.161621, -0.562012, 0.811035);
 cgVertex3f(0.137038, -0.279408, 0.093081);
 cgNormal3f(0.233887, -0.846191, 0.478516);
 cgVertex3f(0.140326, -0.259685, 0.139101);
 cgNormal3f(0.229492, -0.795898, 0.560059);
 cgVertex3f(-0.063478, -0.338576, 0.132527);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.229492, -0.795898, 0.560059);
 cgVertex3f(-0.063478, -0.338576, 0.132527);
 cgNormal3f(0.233887, -0.846191, 0.478516);
 cgVertex3f(0.140326, -0.259685, 0.139101);
 cgNormal3f(0.149414, -0.607910, 0.779785);
 cgVertex3f(0.140326, -0.239962, 0.162111);
 cgNormal3f(0.129395, -0.500000, 0.855957);
 cgVertex3f(-0.063478, -0.308992, 0.155537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.042480, 0.001953, 0.999023);
 cgVertex3f(-0.073339, 0.000000, 0.241003);
 cgNormal3f(0.035645, 0.001465, 0.999023);
 cgVertex3f(-0.316588, 0.000000, 0.250864);
 cgNormal3f(0.037598, -0.209961, 0.976562);
 cgVertex3f(-0.313301, -0.108476, 0.237715);
 cgNormal3f(0.050293, -0.222656, 0.973633);
 cgVertex3f(-0.066765, -0.098614, 0.231141);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.050293, -0.222656, 0.973633);
 cgVertex3f(-0.066765, -0.098614, 0.231141);
 cgNormal3f(0.056641, -0.253906, 0.965332);
 cgVertex3f(0.133751, -0.095327, 0.217993);
 cgNormal3f(0.047852, 0.002441, 0.998535);
 cgVertex3f(0.130464, 0.000000, 0.234428);
 cgNormal3f(0.042480, 0.001953, 0.999023);
 cgVertex3f(-0.073339, 0.000000, 0.241003);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.035645, 0.001465, 0.999023);
 cgVertex3f(-0.316588, 0.000000, 0.250864);
 cgNormal3f(0.034180, 0.000977, 0.999023);
 cgVertex3f(-0.546689, 0.000000, 0.257438);
 cgNormal3f(0.032227, -0.212402, 0.976562);
 cgVertex3f(-0.540114, -0.108476, 0.247577);
 cgNormal3f(0.037598, -0.209961, 0.976562);
 cgVertex3f(-0.313301, -0.108476, 0.237715);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.263184, -0.964844, 0.000000);
 cgVertex3f(0.127177, -0.315566, -0.002246);
 cgNormal3f(0.122070, -0.992676, 0.000000);
 cgVertex3f(0.311257, -0.279408, -0.002246);
 cgNormal3f(0.075684, -0.616211, 0.783691);
 cgVertex3f(0.324406, -0.249823, 0.093081);
 cgNormal3f(0.169434, -0.621582, 0.764648);
 cgVertex3f(0.137038, -0.295843, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.169434, -0.621582, 0.764648);
 cgVertex3f(0.137038, -0.295843, 0.093081);
 cgNormal3f(0.075684, -0.616211, 0.783691);
 cgVertex3f(0.324406, -0.249823, 0.093081);
 cgNormal3f(0.069824, -0.601074, 0.795898);
 cgVertex3f(0.324406, -0.236675, 0.093081);
 cgNormal3f(0.161621, -0.562012, 0.811035);
 cgVertex3f(0.137038, -0.279408, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.161621, -0.562012, 0.811035);
 cgVertex3f(0.137038, -0.279408, 0.093081);
 cgNormal3f(0.069824, -0.601074, 0.795898);
 cgVertex3f(0.324406, -0.236675, 0.093081);
 cgNormal3f(0.105469, -0.916992, 0.384766);
 cgVertex3f(0.321119, -0.230100, 0.119378);
 cgNormal3f(0.233887, -0.846191, 0.478516);
 cgVertex3f(0.140326, -0.259685, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.233887, -0.846191, 0.478516);
 cgVertex3f(0.140326, -0.259685, 0.139101);
 cgNormal3f(0.105469, -0.916992, 0.384766);
 cgVertex3f(0.321119, -0.230100, 0.119378);
 cgNormal3f(0.083496, -0.723145, 0.685547);
 cgVertex3f(0.314545, -0.216952, 0.148962);
 cgNormal3f(0.149414, -0.607910, 0.779785);
 cgVertex3f(0.140326, -0.239962, 0.162111);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.122070, -0.992676, 0.000000);
 cgVertex3f(0.311257, -0.279408, -0.002246);
 cgNormal3f(0.047363, -0.999023, 0.000000);
 cgVertex3f(1.248095, -0.246536, -0.002246);
 cgNormal3f(0.030273, -0.635742, 0.770996);
 cgVertex3f(1.261244, -0.230100, 0.093081);
 cgNormal3f(0.075684, -0.616211, 0.783691);
 cgVertex3f(0.324406, -0.249823, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.075684, -0.616211, 0.783691);
 cgVertex3f(0.324406, -0.249823, 0.093081);
 cgNormal3f(0.030273, -0.635742, 0.770996);
 cgVertex3f(1.261244, -0.230100, 0.093081);
 cgNormal3f(0.020996, -0.642578, 0.766113);
 cgVertex3f(1.261244, -0.213665, 0.093081);
 cgNormal3f(0.069824, -0.601074, 0.795898);
 cgVertex3f(0.324406, -0.236675, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.069824, -0.601074, 0.795898);
 cgVertex3f(0.324406, -0.236675, 0.093081);
 cgNormal3f(0.020996, -0.642578, 0.766113);
 cgVertex3f(1.261244, -0.213665, 0.093081);
 cgNormal3f(0.025879, -0.949707, 0.312500);
 cgVertex3f(1.257957, -0.210378, 0.112804);
 cgNormal3f(0.105469, -0.916992, 0.384766);
 cgVertex3f(0.321119, -0.230100, 0.119378);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.105469, -0.916992, 0.384766);
 cgVertex3f(0.321119, -0.230100, 0.119378);
 cgNormal3f(0.025879, -0.949707, 0.312500);
 cgVertex3f(1.257957, -0.210378, 0.112804);
 cgNormal3f(0.018066, -0.752930, 0.658203);
 cgVertex3f(1.254669, -0.197229, 0.135814);
 cgNormal3f(0.083496, -0.723145, 0.685547);
 cgVertex3f(0.314545, -0.216952, 0.148962);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.127441, -0.650879, 0.748535);
 cgVertex3f(1.474908, -0.216952, 0.093081);
 cgNormal3f(0.192383, -0.981445, 0.000000);
 cgVertex3f(1.474908, -0.230100, -0.002246);
 cgNormal3f(0.456055, -0.890137, 0.000000);
 cgVertex3f(1.596533, -0.184080, -0.002246);
 cgNormal3f(0.312012, -0.609375, 0.729004);
 cgVertex3f(1.589959, -0.184080, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.312012, -0.609375, 0.729004);
 cgVertex3f(1.589959, -0.184080, 0.093081);
 cgNormal3f(0.271973, -0.540527, 0.795898);
 cgVertex3f(1.580097, -0.177506, 0.093081);
 cgNormal3f(0.099121, -0.639160, 0.762207);
 cgVertex3f(1.474908, -0.203803, 0.093081);
 cgNormal3f(0.127441, -0.650879, 0.748535);
 cgVertex3f(1.474908, -0.216952, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.271973, -0.540527, 0.795898);
 cgVertex3f(1.580097, -0.177506, 0.093081);
 cgNormal3f(0.382812, -0.785645, 0.485352);
 cgVertex3f(1.570236, -0.170932, 0.129239);
 cgNormal3f(0.147949, -0.932617, 0.329102);
 cgVertex3f(1.474908, -0.200516, 0.122665);
 cgNormal3f(0.099121, -0.639160, 0.762207);
 cgVertex3f(1.474908, -0.203803, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.169922, -0.408203, 0.896484);
 cgVertex3f(1.547226, -0.161070, 0.145675);
 cgNormal3f(0.382812, -0.785645, 0.485352);
 cgVertex3f(1.570236, -0.170932, 0.129239);
 cgNormal3f(0.507324, -0.601074, 0.617676);
 cgVertex3f(1.622830, -0.124912, 0.135814);
 cgNormal3f(0.198242, -0.316406, 0.927246);
 cgVertex3f(1.589959, -0.118337, 0.152250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.241211, -0.214355, 0.946289);
 cgVertex3f(1.632692, -0.075604, 0.155537);
 cgNormal3f(0.629883, -0.396973, 0.666992);
 cgVertex3f(1.668850, -0.075604, 0.139101);
 cgNormal3f(0.724609, 0.005859, 0.688477);
 cgVertex3f(1.691860, 0.000000, 0.139101);
 cgNormal3f(0.288574, 0.005859, 0.957031);
 cgVertex3f(1.662276, 0.000000, 0.158824);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.724609, 0.005859, 0.688477);
 cgVertex3f(1.691860, 0.000000, 0.139101);
 cgNormal3f(0.629883, -0.396973, 0.666992);
 cgVertex3f(1.668850, -0.075604, 0.139101);
 cgNormal3f(0.471191, -0.270020, 0.839355);
 cgVertex3f(1.695147, -0.072317, 0.093081);
 cgNormal3f(0.521973, 0.001465, 0.852539);
 cgVertex3f(1.711583, 0.000000, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.382812, -0.785645, 0.485352);
 cgVertex3f(1.570236, -0.170932, 0.129239);
 cgNormal3f(0.271973, -0.540527, 0.795898);
 cgVertex3f(1.580097, -0.177506, 0.093081);
 cgNormal3f(0.388184, -0.425293, 0.817383);
 cgVertex3f(1.639266, -0.131486, 0.093081);
 cgNormal3f(0.507324, -0.601074, 0.617676);
 cgVertex3f(1.622830, -0.124912, 0.135814);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.271973, -0.540527, 0.795898);
 cgVertex3f(1.580097, -0.177506, 0.093081);
 cgNormal3f(0.312012, -0.609375, 0.729004);
 cgVertex3f(1.589959, -0.184080, 0.093081);
 cgNormal3f(0.452148, -0.530273, 0.716797);
 cgVertex3f(1.655702, -0.138060, 0.093081);
 cgNormal3f(0.388184, -0.425293, 0.817383);
 cgVertex3f(1.639266, -0.131486, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.312012, -0.609375, 0.729004);
 cgVertex3f(1.589959, -0.184080, 0.093081);
 cgNormal3f(0.456055, -0.890137, 0.000000);
 cgVertex3f(1.596533, -0.184080, -0.002246);
 cgNormal3f(0.648926, -0.761230, 0.000000);
 cgVertex3f(1.662276, -0.134773, -0.002246);
 cgNormal3f(0.452148, -0.530273, 0.716797);
 cgVertex3f(1.655702, -0.138060, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.599609, -0.314941, 0.735352);
 cgVertex3f(1.711583, -0.082179, 0.093081);
 cgNormal3f(0.885254, -0.464844, 0.000000);
 cgVertex3f(1.718157, -0.078892, -0.002246);
 cgNormal3f(0.999512, 0.003418, 0.000000);
 cgVertex3f(1.731306, 0.000000, -0.002246);
 cgNormal3f(0.683594, 0.002441, 0.729492);
 cgVertex3f(1.728019, 0.000000, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.062500, 0.003418, 0.997559);
 cgVertex3f(1.254669, 0.000000, 0.201557);
 cgNormal3f(0.048828, -0.242188, 0.968750);
 cgVertex3f(1.254669, -0.082179, 0.181834);
 cgNormal3f(0.070312, -0.174805, 0.981934);
 cgVertex3f(1.445324, -0.078892, 0.168685);
 cgNormal3f(0.088379, 0.003418, 0.995605);
 cgVertex3f(1.445324, 0.000000, 0.178547);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.048828, -0.242188, 0.968750);
 cgVertex3f(1.254669, -0.082179, 0.181834);
 cgNormal3f(0.026367, -0.428711, 0.902832);
 cgVertex3f(1.248095, -0.170932, 0.155537);
 cgNormal3f(0.052734, -0.305664, 0.950684);
 cgVertex3f(1.445324, -0.167645, 0.152250);
 cgNormal3f(0.070312, -0.174805, 0.981934);
 cgVertex3f(1.445324, -0.078892, 0.168685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.025879, -0.949707, 0.312500);
 cgVertex3f(1.257957, -0.210378, 0.112804);
 cgNormal3f(0.020996, -0.642578, 0.766113);
 cgVertex3f(1.261244, -0.213665, 0.093081);
 cgNormal3f(0.099121, -0.639160, 0.762207);
 cgVertex3f(1.474908, -0.203803, 0.093081);
 cgNormal3f(0.147949, -0.932617, 0.329102);
 cgVertex3f(1.474908, -0.200516, 0.122665);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.020996, -0.642578, 0.766113);
 cgVertex3f(1.261244, -0.213665, 0.093081);
 cgNormal3f(0.030273, -0.635742, 0.770996);
 cgVertex3f(1.261244, -0.230100, 0.093081);
 cgNormal3f(0.127441, -0.650879, 0.748535);
 cgVertex3f(1.474908, -0.216952, 0.093081);
 cgNormal3f(0.099121, -0.639160, 0.762207);
 cgVertex3f(1.474908, -0.203803, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.030273, -0.635742, 0.770996);
 cgVertex3f(1.261244, -0.230100, 0.093081);
 cgNormal3f(0.047363, -0.999023, 0.000000);
 cgVertex3f(1.248095, -0.246536, -0.002246);
 cgNormal3f(0.192383, -0.981445, 0.000000);
 cgVertex3f(1.474908, -0.230100, -0.002246);
 cgNormal3f(0.127441, -0.650879, 0.748535);
 cgVertex3f(1.474908, -0.216952, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.026367, -0.428711, 0.902832);
 cgVertex3f(1.248095, -0.170932, 0.155537);
 cgNormal3f(0.018066, -0.752930, 0.658203);
 cgVertex3f(1.254669, -0.197229, 0.135814);
 cgNormal3f(0.096680, -0.664062, 0.741211);
 cgVertex3f(1.474908, -0.193942, 0.139101);
 cgNormal3f(0.052734, -0.305664, 0.950684);
 cgVertex3f(1.445324, -0.167645, 0.152250);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.018066, -0.752930, 0.658203);
 cgVertex3f(1.254669, -0.197229, 0.135814);
 cgNormal3f(0.025879, -0.949707, 0.312500);
 cgVertex3f(1.257957, -0.210378, 0.112804);
 cgNormal3f(0.147949, -0.932617, 0.329102);
 cgVertex3f(1.474908, -0.200516, 0.122665);
 cgNormal3f(0.096680, -0.664062, 0.741211);
 cgVertex3f(1.474908, -0.193942, 0.139101);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.124512, 0.000977, 0.992188);
 cgVertex3f(-1.105504, 0.000000, 0.241003);
 cgNormal3f(-0.104492, -0.123047, 0.986816);
 cgVertex3f(-1.102217, -0.121625, 0.231141);
 cgNormal3f(-0.055664, -0.174805, 0.982910);
 cgVertex3f(-0.951008, -0.118337, 0.244290);
 cgNormal3f(-0.080566, 0.000488, 0.996582);
 cgVertex3f(-0.957582, 0.000000, 0.254151);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.104492, -0.123047, 0.986816);
 cgVertex3f(-1.102217, -0.121625, 0.231141);
 cgNormal3f(-0.061035, -0.198242, 0.978027);
 cgVertex3f(-1.095643, -0.230100, 0.214705);
 cgNormal3f(0.001953, -0.260742, 0.965332);
 cgVertex3f(-0.941147, -0.226813, 0.214705);
 cgNormal3f(-0.055664, -0.174805, 0.982910);
 cgVertex3f(-0.951008, -0.118337, 0.244290);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.061035, -0.198242, 0.978027);
 cgVertex3f(-1.095643, -0.230100, 0.214705);
 cgNormal3f(-0.025391, -0.369629, 0.928711);
 cgVertex3f(-1.079207, -0.440478, 0.165398);
 cgNormal3f(0.079102, -0.381348, 0.920898);
 cgVertex3f(-0.931285, -0.420755, 0.162111);
 cgNormal3f(0.001953, -0.260742, 0.965332);
 cgVertex3f(-0.941147, -0.226813, 0.214705);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.025391, -0.369629, 0.928711);
 cgVertex3f(-1.079207, -0.440478, 0.165398);
 cgNormal3f(0.004883, -0.744629, 0.667480);
 cgVertex3f(-1.072633, -0.470062, 0.148962);
 cgNormal3f(0.171875, -0.744141, 0.645508);
 cgVertex3f(-0.924711, -0.450339, 0.145675);
 cgNormal3f(0.079102, -0.381348, 0.920898);
 cgVertex3f(-0.931285, -0.420755, 0.162111);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.004883, -0.744629, 0.667480);
 cgVertex3f(-1.072633, -0.470062, 0.148962);
 cgNormal3f(0.013184, -0.543945, 0.838867);
 cgVertex3f(-1.072633, -0.493072, 0.093081);
 cgNormal3f(0.122559, -0.555664, 0.822266);
 cgVertex3f(-0.921424, -0.470062, 0.093081);
 cgNormal3f(0.171875, -0.744141, 0.645508);
 cgVertex3f(-0.924711, -0.450339, 0.145675);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.013184, -0.543945, 0.838867);
 cgVertex3f(-1.072633, -0.493072, 0.093081);
 cgNormal3f(0.019043, -0.646484, 0.762695);
 cgVertex3f(-1.072633, -0.506221, 0.093081);
 cgNormal3f(0.150879, -0.639160, 0.753906);
 cgVertex3f(-0.921424, -0.483211, 0.093081);
 cgNormal3f(0.122559, -0.555664, 0.822266);
 cgVertex3f(-0.921424, -0.470062, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.019043, -0.646484, 0.762695);
 cgVertex3f(-1.072633, -0.506221, 0.093081);
 cgNormal3f(0.029785, -1.000000, 0.000000);
 cgVertex3f(-1.072633, -0.522657, -0.002246);
 cgNormal3f(0.229492, -0.973633, 0.000000);
 cgVertex3f(-0.921424, -0.496360, -0.002246);
 cgNormal3f(0.150879, -0.639160, 0.753906);
 cgVertex3f(-0.921424, -0.483211, 0.093081);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.724609, -0.688477, -0.039551);
 cgVertex3f(-1.503249, -0.410894, -0.097574);
 cgNormal3f(-0.462402, -0.873535, -0.154297);
 cgVertex3f(-1.450655, -0.450339, -0.097574);
 cgNormal3f(-0.430176, -0.902832, 0.000000);
 cgVertex3f(-1.444080, -0.453627, -0.002246);
 cgNormal3f(-0.325195, -0.615723, 0.717773);
 cgVertex3f(-1.450655, -0.450339, 0.093081);
 cgNormal3f(-0.497070, -0.498535, 0.710449);
 cgVertex3f(-1.503249, -0.410894, 0.093081);
 cgNormal3f(-0.747070, -0.665039, 0.000000);
 cgVertex3f(-1.503249, -0.407607, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.325195, -0.615723, 0.717773);
 cgVertex3f(-1.450655, -0.450339, 0.093081);
 cgNormal3f(-0.254883, -0.468262, 0.846191);
 cgVertex3f(-1.444080, -0.440478, 0.093081);
 cgNormal3f(-0.421387, -0.363770, 0.830566);
 cgVertex3f(-1.493388, -0.401032, 0.093081);
 cgNormal3f(-0.497070, -0.498535, 0.710449);
 cgVertex3f(-1.503249, -0.410894, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.254883, -0.468262, 0.846191);
 cgVertex3f(-1.444080, -0.440478, 0.093081);
 cgNormal3f(-0.374023, -0.699707, 0.608887);
 cgVertex3f(-1.444080, -0.427329, 0.119378);
 cgNormal3f(-0.629395, -0.528809, 0.569824);
 cgVertex3f(-1.490101, -0.387884, 0.122665);
 cgNormal3f(-0.421387, -0.363770, 0.830566);
 cgVertex3f(-1.493388, -0.401032, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.374023, -0.699707, 0.608887);
 cgVertex3f(-1.444080, -0.427329, 0.119378);
 cgNormal3f(-0.222656, -0.452637, 0.863281);
 cgVertex3f(-1.437506, -0.397745, 0.145675);
 cgNormal3f(-0.337891, -0.288086, 0.895996);
 cgVertex3f(-1.473665, -0.364874, 0.148962);
 cgNormal3f(-0.629395, -0.528809, 0.569824);
 cgVertex3f(-1.490101, -0.387884, 0.122665);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.222656, -0.452637, 0.863281);
 cgVertex3f(-1.437506, -0.397745, 0.145675);
 cgNormal3f(-0.111328, -0.385742, 0.915527);
 cgVertex3f(-1.355327, -0.417468, 0.145675);
 cgNormal3f(-0.142578, -0.128906, 0.980957);
 cgVertex3f(-1.355327, -0.220239, 0.185121);
 cgNormal3f(-0.337891, -0.288086, 0.895996);
 cgVertex3f(-1.473665, -0.364874, 0.148962);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.885254, -0.464844, 0.000000);
 cgVertex3f(1.718157, -0.078892, -0.002246);
 cgNormal3f(0.599609, -0.314941, 0.735352);
 cgVertex3f(1.711583, -0.082179, 0.093081);
 cgNormal3f(0.452148, -0.530273, 0.716797);
 cgVertex3f(1.655702, -0.138060, 0.093081);
 cgNormal3f(0.648926, -0.761230, 0.000000);
 cgVertex3f(1.662276, -0.134773, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.599609, -0.314941, 0.735352);
 cgVertex3f(1.711583, -0.082179, 0.093081);
 cgNormal3f(0.471191, -0.270020, 0.839355);
 cgVertex3f(1.695147, -0.072317, 0.093081);
 cgNormal3f(0.388184, -0.425293, 0.817383);
 cgVertex3f(1.639266, -0.131486, 0.093081);
 cgNormal3f(0.452148, -0.530273, 0.716797);
 cgVertex3f(1.655702, -0.138060, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.471191, -0.270020, 0.839355);
 cgVertex3f(1.695147, -0.072317, 0.093081);
 cgNormal3f(0.629883, -0.396973, 0.666992);
 cgVertex3f(1.668850, -0.075604, 0.139101);
 cgNormal3f(0.507324, -0.601074, 0.617676);
 cgVertex3f(1.622830, -0.124912, 0.135814);
 cgNormal3f(0.388184, -0.425293, 0.817383);
 cgVertex3f(1.639266, -0.131486, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.629883, -0.396973, 0.666992);
 cgVertex3f(1.668850, -0.075604, 0.139101);
 cgNormal3f(0.241211, -0.214355, 0.946289);
 cgVertex3f(1.632692, -0.075604, 0.155537);
 cgNormal3f(0.198242, -0.316406, 0.927246);
 cgVertex3f(1.589959, -0.118337, 0.152250);
 cgNormal3f(0.507324, -0.601074, 0.617676);
 cgVertex3f(1.622830, -0.124912, 0.135814);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.096680, -0.664062, 0.741211);
 cgVertex3f(1.474908, -0.193942, 0.139101);
 cgNormal3f(0.169922, -0.408203, 0.896484);
 cgVertex3f(1.547226, -0.161070, 0.145675);
 cgNormal3f(0.052734, -0.305664, 0.950684);
 cgVertex3f(1.445324, -0.167645, 0.152250);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.241211, -0.214355, 0.946289);
 cgVertex3f(1.632692, -0.075604, 0.155537);
 cgNormal3f(0.070312, -0.174805, 0.981934);
 cgVertex3f(1.445324, -0.078892, 0.168685);
 cgNormal3f(0.198242, -0.316406, 0.927246);
 cgVertex3f(1.589959, -0.118337, 0.152250);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.198242, -0.316406, 0.927246);
 cgVertex3f(1.589959, -0.118337, 0.152250);
 cgNormal3f(0.070312, -0.174805, 0.981934);
 cgVertex3f(1.445324, -0.078892, 0.168685);
 cgNormal3f(0.169922, -0.408203, 0.896484);
 cgVertex3f(1.547226, -0.161070, 0.145675);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.210938, -0.335938, -0.917969);
 cgVertex3f(1.616256, -0.121625, -0.156743);
 cgNormal3f(0.175781, -0.422363, -0.889648);
 cgVertex3f(1.573523, -0.164357, -0.153455);
 cgNormal3f(0.069824, -0.178711, -0.981445);
 cgVertex3f(1.468334, -0.078892, -0.176465);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.207520, -0.223145, -0.952637);
 cgVertex3f(1.658989, -0.078892, -0.163317);
 cgNormal3f(0.210938, -0.335938, -0.917969);
 cgVertex3f(1.616256, -0.121625, -0.156743);
 cgNormal3f(0.069824, -0.178711, -0.981445);
 cgVertex3f(1.468334, -0.078892, -0.176465);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.100098, -0.650879, -0.752930);
 cgVertex3f(1.501206, -0.197229, -0.146881);
 cgNormal3f(0.040039, -0.307129, -0.951172);
 cgVertex3f(1.468334, -0.170932, -0.156743);
 cgNormal3f(0.175781, -0.422363, -0.889648);
 cgVertex3f(1.573523, -0.164357, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207520, -0.223145, -0.952637);
 cgVertex3f(1.658989, -0.078892, -0.163317);
 cgNormal3f(0.652344, -0.430664, -0.624023);
 cgVertex3f(1.698434, -0.078892, -0.150168);
 cgNormal3f(0.523438, -0.648438, -0.552734);
 cgVertex3f(1.649127, -0.128199, -0.140307);
 cgNormal3f(0.210938, -0.335938, -0.917969);
 cgVertex3f(1.616256, -0.121625, -0.156743);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.652344, -0.430664, -0.624023);
 cgVertex3f(1.698434, -0.078892, -0.150168);
 cgNormal3f(0.869141, -0.477051, -0.130371);
 cgVertex3f(1.711583, -0.082179, -0.097574);
 cgNormal3f(0.645996, -0.753906, -0.119629);
 cgVertex3f(1.655702, -0.138060, -0.097574);
 cgNormal3f(0.523438, -0.648438, -0.552734);
 cgVertex3f(1.649127, -0.128199, -0.140307);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.869141, -0.477051, -0.130371);
 cgVertex3f(1.711583, -0.082179, -0.097574);
 cgNormal3f(0.885254, -0.464844, 0.000000);
 cgVertex3f(1.718157, -0.078892, -0.002246);
 cgNormal3f(0.648926, -0.761230, 0.000000);
 cgVertex3f(1.662276, -0.134773, -0.002246);
 cgNormal3f(0.645996, -0.753906, -0.119629);
 cgVertex3f(1.655702, -0.138060, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.114746, -0.398438, -0.910156);
 cgVertex3f(-1.378338, -0.427329, -0.150168);
 cgNormal3f(-0.237793, -0.454102, -0.858887);
 cgVertex3f(-1.463803, -0.404319, -0.153455);
 cgNormal3f(-0.341309, -0.270508, -0.900879);
 cgVertex3f(-1.499962, -0.368161, -0.153455);
 cgNormal3f(-0.140137, -0.126953, -0.982422);
 cgVertex3f(-1.378338, -0.223526, -0.189614);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.237793, -0.454102, -0.858887);
 cgVertex3f(-1.463803, -0.404319, -0.153455);
 cgNormal3f(-0.400391, -0.747559, -0.530273);
 cgVertex3f(-1.467091, -0.433904, -0.123871);
 cgNormal3f(-0.684082, -0.582520, -0.439941);
 cgVertex3f(-1.516398, -0.394458, -0.127158);
 cgNormal3f(-0.341309, -0.270508, -0.900879);
 cgVertex3f(-1.499962, -0.368161, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.400391, -0.747559, -0.530273);
 cgVertex3f(-1.467091, -0.433904, -0.123871);
 cgNormal3f(-0.462402, -0.873535, -0.154297);
 cgVertex3f(-1.450655, -0.450339, -0.097574);
 cgNormal3f(-0.724609, -0.688477, -0.039551);
 cgVertex3f(-1.503249, -0.410894, -0.097574);
 cgNormal3f(-0.684082, -0.582520, -0.439941);
 cgVertex3f(-1.516398, -0.394458, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.029785, -1.000000, 0.000000);
 cgVertex3f(-1.072633, -0.522657, -0.002246);
 cgNormal3f(0.025391, -0.948242, -0.317383);
 cgVertex3f(-1.072633, -0.506221, -0.097574);
 cgNormal3f(0.213379, -0.926270, -0.311523);
 cgVertex3f(-0.921424, -0.483211, -0.097574);
 cgNormal3f(0.229492, -0.973633, 0.000000);
 cgVertex3f(-0.921424, -0.496360, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.025391, -0.948242, -0.317383);
 cgVertex3f(-1.072633, -0.506221, -0.097574);
 cgNormal3f(0.007324, -0.744629, -0.667969);
 cgVertex3f(-1.089068, -0.479924, -0.153455);
 cgNormal3f(0.166504, -0.713379, -0.681152);
 cgVertex3f(-0.941147, -0.456914, -0.150168);
 cgNormal3f(0.213379, -0.926270, -0.311523);
 cgVertex3f(-0.921424, -0.483211, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.007324, -0.744629, -0.667969);
 cgVertex3f(-1.089068, -0.479924, -0.153455);
 cgNormal3f(-0.024902, -0.400391, -0.916504);
 cgVertex3f(-1.095643, -0.450339, -0.173178);
 cgNormal3f(0.086914, -0.400879, -0.912109);
 cgVertex3f(-0.947721, -0.427329, -0.169891);
 cgNormal3f(0.166504, -0.713379, -0.681152);
 cgVertex3f(-0.941147, -0.456914, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.024902, -0.400391, -0.916504);
 cgVertex3f(-1.095643, -0.450339, -0.173178);
 cgNormal3f(-0.064453, -0.198242, -0.978516);
 cgVertex3f(-1.115366, -0.233388, -0.222486);
 cgNormal3f(0.005371, -0.257812, -0.966309);
 cgVertex3f(-0.957582, -0.233388, -0.222486);
 cgNormal3f(0.086914, -0.400879, -0.912109);
 cgVertex3f(-0.947721, -0.427329, -0.169891);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.064453, -0.198242, -0.978516);
 cgVertex3f(-1.115366, -0.233388, -0.222486);
 cgNormal3f(-0.103027, -0.120605, -0.987793);
 cgVertex3f(-1.121940, -0.124912, -0.238921);
 cgNormal3f(-0.055176, -0.170410, -0.983887);
 cgVertex3f(-0.967444, -0.118337, -0.252070);
 cgNormal3f(0.005371, -0.257812, -0.966309);
 cgVertex3f(-0.957582, -0.233388, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.103027, -0.120605, -0.987793);
 cgVertex3f(-1.121940, -0.124912, -0.238921);
 cgNormal3f(-0.118652, 0.000977, -0.993164);
 cgVertex3f(-1.125227, 0.000000, -0.248783);
 cgNormal3f(-0.079102, 0.000977, -0.997070);
 cgVertex3f(-0.974018, 0.000000, -0.261931);
 cgNormal3f(-0.055176, -0.170410, -0.983887);
 cgVertex3f(-0.967444, -0.118337, -0.252070);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.040039, -0.915039, -0.402832);
 cgVertex3f(1.280967, -0.226813, -0.117297);
 cgNormal3f(0.023926, -0.669434, -0.743164);
 cgVertex3f(1.277679, -0.200516, -0.143594);
 cgNormal3f(0.100098, -0.650879, -0.752930);
 cgVertex3f(1.501206, -0.197229, -0.146881);
 cgNormal3f(0.168945, -0.917480, -0.360840);
 cgVertex3f(1.501206, -0.203803, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.023926, -0.669434, -0.743164);
 cgVertex3f(1.277679, -0.200516, -0.143594);
 cgNormal3f(0.028320, -0.410156, -0.912109);
 cgVertex3f(1.271105, -0.174219, -0.163317);
 cgNormal3f(0.040039, -0.307129, -0.951172);
 cgVertex3f(1.468334, -0.170932, -0.156743);
 cgNormal3f(0.100098, -0.650879, -0.752930);
 cgVertex3f(1.501206, -0.197229, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047363, -0.999023, 0.000000);
 cgVertex3f(1.248095, -0.246536, -0.002246);
 cgNormal3f(0.047363, -0.982422, -0.181641);
 cgVertex3f(1.261244, -0.230100, -0.097574);
 cgNormal3f(0.183594, -0.970215, -0.160645);
 cgVertex3f(1.474908, -0.216952, -0.097574);
 cgNormal3f(0.192383, -0.981445, 0.000000);
 cgVertex3f(1.474908, -0.230100, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047363, -0.982422, -0.181641);
 cgVertex3f(1.261244, -0.230100, -0.097574);
 cgNormal3f(0.040039, -0.915039, -0.402832);
 cgVertex3f(1.280967, -0.226813, -0.117297);
 cgNormal3f(0.168945, -0.917480, -0.360840);
 cgVertex3f(1.501206, -0.203803, -0.127158);
 cgNormal3f(0.183594, -0.970215, -0.160645);
 cgVertex3f(1.474908, -0.216952, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.028320, -0.410156, -0.912109);
 cgVertex3f(1.271105, -0.174219, -0.163317);
 cgNormal3f(0.047363, -0.237305, -0.970703);
 cgVertex3f(1.274392, -0.082179, -0.189614);
 cgNormal3f(0.069824, -0.178711, -0.981445);
 cgVertex3f(1.468334, -0.078892, -0.176465);
 cgNormal3f(0.040039, -0.307129, -0.951172);
 cgVertex3f(1.468334, -0.170932, -0.156743);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047363, -0.237305, -0.970703);
 cgVertex3f(1.274392, -0.082179, -0.189614);
 cgNormal3f(0.057617, 0.004395, -0.998535);
 cgVertex3f(1.277679, 0.000000, -0.206050);
 cgNormal3f(0.085938, 0.002441, -0.996582);
 cgVertex3f(1.468334, 0.000000, -0.186327);
 cgNormal3f(0.069824, -0.178711, -0.981445);
 cgVertex3f(1.468334, -0.078892, -0.176465);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.885254, -0.464844, 0.000000);
 cgVertex3f(1.718157, -0.078892, -0.002246);
 cgNormal3f(0.869141, -0.477051, -0.130371);
 cgVertex3f(1.711583, -0.082179, -0.097574);
 cgNormal3f(0.992676, 0.003906, -0.119629);
 cgVertex3f(1.728019, 0.000000, -0.097574);
 cgNormal3f(0.999512, 0.003418, 0.000000);
 cgVertex3f(1.731306, 0.000000, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.456055, -0.890137, 0.000000);
 cgVertex3f(1.596533, -0.184080, -0.002246);
 cgNormal3f(0.450684, -0.884277, -0.122070);
 cgVertex3f(1.589959, -0.184080, -0.097574);
 cgNormal3f(0.645996, -0.753906, -0.119629);
 cgVertex3f(1.655702, -0.138060, -0.097574);
 cgNormal3f(0.648926, -0.761230, 0.000000);
 cgVertex3f(1.662276, -0.134773, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.403809, -0.804688, -0.435547);
 cgVertex3f(1.596533, -0.174219, -0.133732);
 cgNormal3f(0.523438, -0.648438, -0.552734);
 cgVertex3f(1.649127, -0.128199, -0.140307);
 cgNormal3f(0.645996, -0.753906, -0.119629);
 cgVertex3f(1.655702, -0.138060, -0.097574);
 cgNormal3f(0.450684, -0.884277, -0.122070);
 cgVertex3f(1.589959, -0.184080, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.992676, 0.003906, -0.119629);
 cgVertex3f(1.728019, 0.000000, -0.097574);
 cgNormal3f(0.869141, -0.477051, -0.130371);
 cgVertex3f(1.711583, -0.082179, -0.097574);
 cgNormal3f(0.652344, -0.430664, -0.624023);
 cgVertex3f(1.698434, -0.078892, -0.150168);
 cgNormal3f(0.763184, 0.003906, -0.645996);
 cgVertex3f(1.721445, 0.000000, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.652344, -0.430664, -0.624023);
 cgVertex3f(1.698434, -0.078892, -0.150168);
 cgNormal3f(0.207520, -0.223145, -0.952637);
 cgVertex3f(1.658989, -0.078892, -0.163317);
 cgNormal3f(0.225098, 0.001953, -0.974609);
 cgVertex3f(1.691860, 0.000000, -0.163317);
 cgNormal3f(0.763184, 0.003906, -0.645996);
 cgVertex3f(1.721445, 0.000000, -0.150168);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.403809, -0.804688, -0.435547);
 cgVertex3f(1.596533, -0.174219, -0.133732);
 cgNormal3f(0.175781, -0.422363, -0.889648);
 cgVertex3f(1.573523, -0.164357, -0.153455);
 cgNormal3f(0.210938, -0.335938, -0.917969);
 cgVertex3f(1.616256, -0.121625, -0.156743);
 cgNormal3f(0.523438, -0.648438, -0.552734);
 cgVertex3f(1.649127, -0.128199, -0.140307);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.450684, -0.884277, -0.122070);
 cgVertex3f(1.589959, -0.184080, -0.097574);
 cgNormal3f(0.183594, -0.970215, -0.160645);
 cgVertex3f(1.474908, -0.216952, -0.097574);
 cgNormal3f(0.168945, -0.917480, -0.360840);
 cgVertex3f(1.501206, -0.203803, -0.127158);
 cgNormal3f(0.403809, -0.804688, -0.435547);
 cgVertex3f(1.596533, -0.174219, -0.133732);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.192383, -0.981445, 0.000000);
 cgVertex3f(1.474908, -0.230100, -0.002246);
 cgNormal3f(0.183594, -0.970215, -0.160645);
 cgVertex3f(1.474908, -0.216952, -0.097574);
 cgNormal3f(0.450684, -0.884277, -0.122070);
 cgVertex3f(1.589959, -0.184080, -0.097574);
 cgNormal3f(0.456055, -0.890137, 0.000000);
 cgVertex3f(1.596533, -0.184080, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.040039, -0.915039, -0.402832);
 cgVertex3f(1.280967, -0.226813, -0.117297);
 cgNormal3f(0.091797, -0.876953, -0.472168);
 cgVertex3f(0.327693, -0.246536, -0.127158);
 cgNormal3f(0.068848, -0.628906, -0.774902);
 cgVertex3f(0.321119, -0.223526, -0.153455);
 cgNormal3f(0.023926, -0.669434, -0.743164);
 cgVertex3f(1.277679, -0.200516, -0.143594);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047363, -0.982422, -0.181641);
 cgVertex3f(1.261244, -0.230100, -0.097574);
 cgNormal3f(0.109375, -0.968750, -0.224609);
 cgVertex3f(0.324406, -0.249823, -0.097574);
 cgNormal3f(0.091797, -0.876953, -0.472168);
 cgVertex3f(0.327693, -0.246536, -0.127158);
 cgNormal3f(0.040039, -0.915039, -0.402832);
 cgVertex3f(1.280967, -0.226813, -0.117297);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.047363, -0.999023, 0.000000);
 cgVertex3f(1.248095, -0.246536, -0.002246);
 cgNormal3f(0.122070, -0.992676, 0.000000);
 cgVertex3f(0.311257, -0.279408, -0.002246);
 cgNormal3f(0.109375, -0.968750, -0.224609);
 cgVertex3f(0.324406, -0.249823, -0.097574);
 cgNormal3f(0.047363, -0.982422, -0.181641);
 cgVertex3f(1.261244, -0.230100, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.091797, -0.876953, -0.472168);
 cgVertex3f(0.327693, -0.246536, -0.127158);
 cgNormal3f(0.207520, -0.795898, -0.569336);
 cgVertex3f(0.140326, -0.266259, -0.143594);
 cgNormal3f(0.135254, -0.558594, -0.818359);
 cgVertex3f(0.140326, -0.243249, -0.166604);
 cgNormal3f(0.068848, -0.628906, -0.774902);
 cgVertex3f(0.321119, -0.223526, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.109375, -0.968750, -0.224609);
 cgVertex3f(0.324406, -0.249823, -0.097574);
 cgNormal3f(0.249512, -0.925293, -0.285645);
 cgVertex3f(0.137038, -0.295843, -0.097574);
 cgNormal3f(0.207520, -0.795898, -0.569336);
 cgVertex3f(0.140326, -0.266259, -0.143594);
 cgNormal3f(0.091797, -0.876953, -0.472168);
 cgVertex3f(0.327693, -0.246536, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.122070, -0.992676, 0.000000);
 cgVertex3f(0.311257, -0.279408, -0.002246);
 cgNormal3f(0.263184, -0.964844, 0.000000);
 cgVertex3f(0.127177, -0.315566, -0.002246);
 cgNormal3f(0.249512, -0.925293, -0.285645);
 cgVertex3f(0.137038, -0.295843, -0.097574);
 cgNormal3f(0.109375, -0.968750, -0.224609);
 cgVertex3f(0.324406, -0.249823, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.033203, 0.001465, -0.999512);
 cgVertex3f(-0.556550, 0.000000, -0.265218);
 cgNormal3f(0.035156, 0.001953, -0.999512);
 cgVertex3f(-0.323162, 0.000000, -0.258644);
 cgNormal3f(0.035156, -0.211426, -0.977051);
 cgVertex3f(-0.319875, -0.111763, -0.245496);
 cgNormal3f(0.031250, -0.217285, -0.976074);
 cgVertex3f(-0.549976, -0.111763, -0.255357);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.062012, -0.261230, -0.963379);
 cgVertex3f(0.137038, -0.098614, -0.225773);
 cgNormal3f(0.051270, -0.223633, -0.973633);
 cgVertex3f(-0.070052, -0.101902, -0.238921);
 cgNormal3f(0.041504, 0.002441, -0.999512);
 cgVertex3f(-0.076626, 0.000000, -0.248783);
 cgNormal3f(0.051270, 0.002930, -0.999023);
 cgVertex3f(0.130464, 0.000000, -0.242208);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.035156, 0.001953, -0.999512);
 cgVertex3f(-0.323162, 0.000000, -0.258644);
 cgNormal3f(0.041504, 0.002441, -0.999512);
 cgVertex3f(-0.076626, 0.000000, -0.248783);
 cgNormal3f(0.051270, -0.223633, -0.973633);
 cgVertex3f(-0.070052, -0.101902, -0.238921);
 cgNormal3f(0.035156, -0.211426, -0.977051);
 cgVertex3f(-0.319875, -0.111763, -0.245496);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207520, -0.795898, -0.569336);
 cgVertex3f(0.140326, -0.266259, -0.143594);
 cgNormal3f(0.210449, -0.739258, -0.639648);
 cgVertex3f(-0.063478, -0.341864, -0.140307);
 cgNormal3f(0.129395, -0.483887, -0.865723);
 cgVertex3f(-0.066765, -0.315566, -0.160030);
 cgNormal3f(0.135254, -0.558594, -0.818359);
 cgVertex3f(0.140326, -0.243249, -0.166604);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.249512, -0.925293, -0.285645);
 cgVertex3f(0.137038, -0.295843, -0.097574);
 cgNormal3f(0.252441, -0.922852, -0.291992);
 cgVertex3f(-0.070052, -0.368161, -0.097574);
 cgNormal3f(0.210449, -0.739258, -0.639648);
 cgVertex3f(-0.063478, -0.341864, -0.140307);
 cgNormal3f(0.207520, -0.795898, -0.569336);
 cgVertex3f(0.140326, -0.266259, -0.143594);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.263184, -0.964844, 0.000000);
 cgVertex3f(0.127177, -0.315566, -0.002246);
 cgNormal3f(0.257324, -0.966309, 0.000000);
 cgVertex3f(-0.079913, -0.378022, -0.002246);
 cgNormal3f(0.252441, -0.922852, -0.291992);
 cgVertex3f(-0.070052, -0.368161, -0.097574);
 cgNormal3f(0.249512, -0.925293, -0.285645);
 cgVertex3f(0.137038, -0.295843, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.091797, -0.996094, 0.000000);
 cgVertex3f(-0.310014, -0.427329, -0.002246);
 cgNormal3f(0.090820, -0.958496, -0.270508);
 cgVertex3f(-0.310014, -0.417468, -0.097574);
 cgNormal3f(0.252441, -0.922852, -0.291992);
 cgVertex3f(-0.070052, -0.368161, -0.097574);
 cgNormal3f(0.257324, -0.966309, 0.000000);
 cgVertex3f(-0.079913, -0.378022, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.074707, -0.748047, -0.659668);
 cgVertex3f(-0.313301, -0.394458, -0.146881);
 cgNormal3f(0.210449, -0.739258, -0.639648);
 cgVertex3f(-0.063478, -0.341864, -0.140307);
 cgNormal3f(0.252441, -0.922852, -0.291992);
 cgVertex3f(-0.070052, -0.368161, -0.097574);
 cgNormal3f(0.090820, -0.958496, -0.270508);
 cgVertex3f(-0.310014, -0.417468, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.074707, -0.748047, -0.659668);
 cgVertex3f(-0.313301, -0.394458, -0.146881);
 cgNormal3f(0.043457, -0.448730, -0.892578);
 cgVertex3f(-0.310014, -0.368161, -0.163317);
 cgNormal3f(0.129395, -0.483887, -0.865723);
 cgVertex3f(-0.066765, -0.315566, -0.160030);
 cgNormal3f(0.210449, -0.739258, -0.639648);
 cgVertex3f(-0.063478, -0.341864, -0.140307);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.129395, -0.483887, -0.865723);
 cgVertex3f(-0.066765, -0.315566, -0.160030);
 cgNormal3f(0.043457, -0.448730, -0.892578);
 cgVertex3f(-0.310014, -0.368161, -0.163317);
 cgNormal3f(0.031738, -0.328125, -0.944336);
 cgVertex3f(-0.319875, -0.220239, -0.212624);
 cgNormal3f(0.071777, -0.344238, -0.936523);
 cgVertex3f(-0.066765, -0.213665, -0.199475);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.043457, -0.448730, -0.892578);
 cgVertex3f(-0.310014, -0.368161, -0.163317);
 cgNormal3f(0.021484, -0.443848, -0.895996);
 cgVertex3f(-0.543402, -0.374735, -0.153455);
 cgNormal3f(0.024902, -0.338867, -0.940918);
 cgVertex3f(-0.546689, -0.223526, -0.212624);
 cgNormal3f(0.031738, -0.328125, -0.944336);
 cgVertex3f(-0.319875, -0.220239, -0.212624);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.074707, -0.748047, -0.659668);
 cgVertex3f(-0.313301, -0.394458, -0.146881);
 cgNormal3f(0.032227, -0.751953, -0.658691);
 cgVertex3f(-0.543402, -0.394458, -0.140307);
 cgNormal3f(0.021484, -0.443848, -0.895996);
 cgVertex3f(-0.543402, -0.374735, -0.153455);
 cgNormal3f(0.043457, -0.448730, -0.892578);
 cgVertex3f(-0.310014, -0.368161, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.090820, -0.958496, -0.270508);
 cgVertex3f(-0.310014, -0.417468, -0.097574);
 cgNormal3f(0.040039, -0.965332, -0.257812);
 cgVertex3f(-0.533540, -0.414181, -0.097574);
 cgNormal3f(0.032227, -0.751953, -0.658691);
 cgVertex3f(-0.543402, -0.394458, -0.140307);
 cgNormal3f(0.074707, -0.748047, -0.659668);
 cgVertex3f(-0.313301, -0.394458, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.040527, -0.999512, 0.000000);
 cgVertex3f(-0.530253, -0.420755, -0.002246);
 cgNormal3f(0.040039, -0.965332, -0.257812);
 cgVertex3f(-0.533540, -0.414181, -0.097574);
 cgNormal3f(0.090820, -0.958496, -0.270508);
 cgVertex3f(-0.310014, -0.417468, -0.097574);
 cgNormal3f(0.091797, -0.996094, 0.000000);
 cgVertex3f(-0.310014, -0.427329, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.187500, -0.940430, -0.283691);
 cgVertex3f(-0.770215, -0.437191, -0.097574);
 cgNormal3f(0.145996, -0.724121, -0.674316);
 cgVertex3f(-0.793225, -0.417468, -0.146881);
 cgNormal3f(0.032227, -0.751953, -0.658691);
 cgVertex3f(-0.543402, -0.394458, -0.140307);
 cgNormal3f(0.040039, -0.965332, -0.257812);
 cgVertex3f(-0.533540, -0.414181, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.021484, -0.443848, -0.895996);
 cgVertex3f(-0.543402, -0.374735, -0.153455);
 cgNormal3f(0.032227, -0.751953, -0.658691);
 cgVertex3f(-0.543402, -0.394458, -0.140307);
 cgNormal3f(0.145996, -0.724121, -0.674316);
 cgVertex3f(-0.793225, -0.417468, -0.146881);
 cgNormal3f(0.083984, -0.425781, -0.901367);
 cgVertex3f(-0.796512, -0.384596, -0.166604);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.083984, -0.425781, -0.901367);
 cgVertex3f(-0.796512, -0.384596, -0.166604);
 cgNormal3f(0.029785, -0.319336, -0.947266);
 cgVertex3f(-0.803086, -0.230100, -0.222486);
 cgNormal3f(0.024902, -0.338867, -0.940918);
 cgVertex3f(-0.546689, -0.223526, -0.212624);
 cgNormal3f(0.021484, -0.443848, -0.895996);
 cgVertex3f(-0.543402, -0.374735, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.083984, -0.425781, -0.901367);
 cgVertex3f(-0.796512, -0.384596, -0.166604);
 cgNormal3f(0.086914, -0.400879, -0.912109);
 cgVertex3f(-0.947721, -0.427329, -0.169891);
 cgNormal3f(0.005371, -0.257812, -0.966309);
 cgVertex3f(-0.957582, -0.233388, -0.222486);
 cgNormal3f(0.029785, -0.319336, -0.947266);
 cgVertex3f(-0.803086, -0.230100, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.064453, -0.198242, -0.978516);
 cgVertex3f(-1.115366, -0.233388, -0.222486);
 cgNormal3f(-0.024902, -0.400391, -0.916504);
 cgVertex3f(-1.095643, -0.450339, -0.173178);
 cgNormal3f(-0.114746, -0.398438, -0.910156);
 cgVertex3f(-1.378338, -0.427329, -0.150168);
 cgNormal3f(-0.140137, -0.126953, -0.982422);
 cgVertex3f(-1.378338, -0.223526, -0.189614);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.083984, -0.425781, -0.901367);
 cgVertex3f(-0.796512, -0.384596, -0.166604);
 cgNormal3f(0.145996, -0.724121, -0.674316);
 cgVertex3f(-0.793225, -0.417468, -0.146881);
 cgNormal3f(0.166504, -0.713379, -0.681152);
 cgVertex3f(-0.941147, -0.456914, -0.150168);
 cgNormal3f(0.086914, -0.400879, -0.912109);
 cgVertex3f(-0.947721, -0.427329, -0.169891);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.187500, -0.940430, -0.283691);
 cgVertex3f(-0.770215, -0.437191, -0.097574);
 cgNormal3f(0.213379, -0.926270, -0.311523);
 cgVertex3f(-0.921424, -0.483211, -0.097574);
 cgNormal3f(0.166504, -0.713379, -0.681152);
 cgVertex3f(-0.941147, -0.456914, -0.150168);
 cgNormal3f(0.145996, -0.724121, -0.674316);
 cgVertex3f(-0.793225, -0.417468, -0.146881);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.201172, -0.979492, 0.000000);
 cgVertex3f(-0.766928, -0.447052, -0.002246);
 cgNormal3f(0.187500, -0.940430, -0.283691);
 cgVertex3f(-0.770215, -0.437191, -0.097574);
 cgNormal3f(0.040039, -0.965332, -0.257812);
 cgVertex3f(-0.533540, -0.414181, -0.097574);
 cgNormal3f(0.040527, -0.999512, 0.000000);
 cgVertex3f(-0.530253, -0.420755, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.430176, -0.902832, 0.000000);
 cgVertex3f(-1.444080, -0.453627, -0.002246);
 cgNormal3f(-0.462402, -0.873535, -0.154297);
 cgVertex3f(-1.450655, -0.450339, -0.097574);
 cgNormal3f(-0.211914, -0.937500, -0.276855);
 cgVertex3f(-1.371763, -0.476637, -0.097574);
 cgNormal3f(-0.231445, -0.973145, 0.000000);
 cgVertex3f(-1.352040, -0.493072, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.400391, -0.747559, -0.530273);
 cgVertex3f(-1.467091, -0.433904, -0.123871);
 cgNormal3f(-0.170410, -0.762207, -0.625000);
 cgVertex3f(-1.384912, -0.456914, -0.127158);
 cgNormal3f(-0.211914, -0.937500, -0.276855);
 cgVertex3f(-1.371763, -0.476637, -0.097574);
 cgNormal3f(-0.462402, -0.873535, -0.154297);
 cgVertex3f(-1.450655, -0.450339, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.187500, -0.940430, -0.283691);
 cgVertex3f(-0.770215, -0.437191, -0.097574);
 cgNormal3f(0.201172, -0.979492, 0.000000);
 cgVertex3f(-0.766928, -0.447052, -0.002246);
 cgNormal3f(0.229492, -0.973633, 0.000000);
 cgVertex3f(-0.921424, -0.496360, -0.002246);
 cgNormal3f(0.213379, -0.926270, -0.311523);
 cgVertex3f(-0.921424, -0.483211, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.170410, -0.762207, -0.625000);
 cgVertex3f(-1.384912, -0.456914, -0.127158);
 cgNormal3f(0.007324, -0.744629, -0.667969);
 cgVertex3f(-1.089068, -0.479924, -0.153455);
 cgNormal3f(0.025391, -0.948242, -0.317383);
 cgVertex3f(-1.072633, -0.506221, -0.097574);
 cgNormal3f(-0.211914, -0.937500, -0.276855);
 cgVertex3f(-1.371763, -0.476637, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.029785, -1.000000, 0.000000);
 cgVertex3f(-1.072633, -0.522657, -0.002246);
 cgNormal3f(-0.231445, -0.973145, 0.000000);
 cgVertex3f(-1.352040, -0.493072, -0.002246);
 cgNormal3f(-0.211914, -0.937500, -0.276855);
 cgVertex3f(-1.371763, -0.476637, -0.097574);
 cgNormal3f(0.025391, -0.948242, -0.317383);
 cgVertex3f(-1.072633, -0.506221, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.724609, -0.688477, -0.039551);
 cgVertex3f(-1.503249, -0.410894, -0.097574);
 cgNormal3f(-0.747070, -0.665039, 0.000000);
 cgVertex3f(-1.503249, -0.407607, -0.002246);
 cgNormal3f(-0.889160, -0.458496, 0.000000);
 cgVertex3f(-1.552556, -0.338576, -0.002246);
 cgNormal3f(-0.895020, -0.446289, -0.014648);
 cgVertex3f(-1.545982, -0.348438, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.114746, -0.398438, -0.910156);
 cgVertex3f(-1.378338, -0.427329, -0.150168);
 cgNormal3f(-0.024902, -0.400391, -0.916504);
 cgVertex3f(-1.095643, -0.450339, -0.173178);
 cgNormal3f(0.007324, -0.744629, -0.667969);
 cgVertex3f(-1.089068, -0.479924, -0.153455);
 cgNormal3f(-0.170410, -0.762207, -0.625000);
 cgVertex3f(-1.384912, -0.456914, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.400391, -0.747559, -0.530273);
 cgVertex3f(-1.467091, -0.433904, -0.123871);
 cgNormal3f(-0.237793, -0.454102, -0.858887);
 cgVertex3f(-1.463803, -0.404319, -0.153455);
 cgNormal3f(-0.114746, -0.398438, -0.910156);
 cgVertex3f(-1.378338, -0.427329, -0.150168);
 cgNormal3f(-0.170410, -0.762207, -0.625000);
 cgVertex3f(-1.384912, -0.456914, -0.127158);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.380371, -0.190430, -0.905273);
 cgVertex3f(-1.522972, -0.312279, -0.153455);
 cgNormal3f(-0.353516, -0.144531, -0.924316);
 cgVertex3f(-1.549269, -0.226813, -0.160030);
 cgNormal3f(-0.140137, -0.126953, -0.982422);
 cgVertex3f(-1.378338, -0.223526, -0.189614);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.380371, -0.190430, -0.905273);
 cgVertex3f(-1.522972, -0.312279, -0.153455);
 cgNormal3f(-0.140137, -0.126953, -0.982422);
 cgVertex3f(-1.378338, -0.223526, -0.189614);
 cgNormal3f(-0.341309, -0.270508, -0.900879);
 cgVertex3f(-1.499962, -0.368161, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.809082, -0.388672, -0.441895);
 cgVertex3f(-1.549269, -0.335289, -0.127158);
 cgNormal3f(-0.380371, -0.190430, -0.905273);
 cgVertex3f(-1.522972, -0.312279, -0.153455);
 cgNormal3f(-0.341309, -0.270508, -0.900879);
 cgVertex3f(-1.499962, -0.368161, -0.153455);
 cgNormal3f(-0.684082, -0.582520, -0.439941);
 cgVertex3f(-1.516398, -0.394458, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.809082, -0.388672, -0.441895);
 cgVertex3f(-1.549269, -0.335289, -0.127158);
 cgNormal3f(-0.840820, -0.241699, -0.485352);
 cgVertex3f(-1.588715, -0.230100, -0.137020);
 cgNormal3f(-0.353516, -0.144531, -0.924316);
 cgVertex3f(-1.549269, -0.226813, -0.160030);
 cgNormal3f(-0.380371, -0.190430, -0.905273);
 cgVertex3f(-1.522972, -0.312279, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.809082, -0.388672, -0.441895);
 cgVertex3f(-1.549269, -0.335289, -0.127158);
 cgNormal3f(-0.895020, -0.446289, -0.014648);
 cgVertex3f(-1.545982, -0.348438, -0.097574);
 cgNormal3f(-0.966309, -0.254395, -0.040527);
 cgVertex3f(-1.588715, -0.223526, -0.097574);
 cgNormal3f(-0.840820, -0.241699, -0.485352);
 cgVertex3f(-1.588715, -0.230100, -0.137020);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.684082, -0.582520, -0.439941);
 cgVertex3f(-1.516398, -0.394458, -0.127158);
 cgNormal3f(-0.724609, -0.688477, -0.039551);
 cgVertex3f(-1.503249, -0.410894, -0.097574);
 cgNormal3f(-0.895020, -0.446289, -0.014648);
 cgVertex3f(-1.545982, -0.348438, -0.097574);
 cgNormal3f(-0.809082, -0.388672, -0.441895);
 cgVertex3f(-1.549269, -0.335289, -0.127158);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.966309, -0.254395, -0.040527);
 cgVertex3f(-1.588715, -0.223526, -0.097574);
 cgNormal3f(-0.895020, -0.446289, -0.014648);
 cgVertex3f(-1.545982, -0.348438, -0.097574);
 cgNormal3f(-0.889160, -0.458496, 0.000000);
 cgVertex3f(-1.552556, -0.338576, -0.002246);
 cgNormal3f(-0.966309, -0.258301, 0.000000);
 cgVertex3f(-1.598577, -0.213665, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.005371, -0.257812, -0.966309);
 cgVertex3f(-0.957582, -0.233388, -0.222486);
 cgNormal3f(-0.055176, -0.170410, -0.983887);
 cgVertex3f(-0.967444, -0.118337, -0.252070);
 cgNormal3f(-0.007812, -0.208984, -0.978027);
 cgVertex3f(-0.812948, -0.115050, -0.261931);
 cgNormal3f(0.029785, -0.319336, -0.947266);
 cgVertex3f(-0.803086, -0.230100, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.140137, -0.126953, -0.982422);
 cgVertex3f(-1.378338, -0.223526, -0.189614);
 cgNormal3f(-0.170410, -0.078613, -0.982422);
 cgVertex3f(-1.378338, -0.115050, -0.202763);
 cgNormal3f(-0.103027, -0.120605, -0.987793);
 cgVertex3f(-1.121940, -0.124912, -0.238921);
 cgNormal3f(-0.064453, -0.198242, -0.978516);
 cgVertex3f(-1.115366, -0.233388, -0.222486);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.353516, -0.144531, -0.924316);
 cgVertex3f(-1.549269, -0.226813, -0.160030);
 cgNormal3f(-0.358398, -0.062988, -0.931641);
 cgVertex3f(-1.568992, -0.111763, -0.163317);
 cgNormal3f(-0.170410, -0.078613, -0.982422);
 cgVertex3f(-1.378338, -0.115050, -0.202763);
 cgNormal3f(-0.140137, -0.126953, -0.982422);
 cgVertex3f(-1.378338, -0.223526, -0.189614);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.353516, -0.144531, -0.924316);
 cgVertex3f(-1.549269, -0.226813, -0.160030);
 cgNormal3f(-0.840820, -0.241699, -0.485352);
 cgVertex3f(-1.588715, -0.230100, -0.137020);
 cgNormal3f(-0.836426, -0.095215, -0.540527);
 cgVertex3f(-1.605151, -0.111763, -0.140307);
 cgNormal3f(-0.358398, -0.062988, -0.931641);
 cgVertex3f(-1.568992, -0.111763, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.987793, -0.122070, -0.099609);
 cgVertex3f(-1.611725, -0.101902, -0.097574);
 cgNormal3f(-0.836426, -0.095215, -0.540527);
 cgVertex3f(-1.605151, -0.111763, -0.140307);
 cgNormal3f(-0.840820, -0.241699, -0.485352);
 cgVertex3f(-1.588715, -0.230100, -0.137020);
 cgNormal3f(-0.966309, -0.254395, -0.040527);
 cgVertex3f(-1.588715, -0.223526, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.990723, -0.138184, 0.000000);
 cgVertex3f(-1.618299, -0.101902, -0.002246);
 cgNormal3f(-0.987793, -0.122070, -0.099609);
 cgVertex3f(-1.611725, -0.101902, -0.097574);
 cgNormal3f(-0.966309, -0.254395, -0.040527);
 cgVertex3f(-1.588715, -0.223526, -0.097574);
 cgNormal3f(-0.966309, -0.258301, 0.000000);
 cgVertex3f(-1.598577, -0.213665, -0.002246);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.031250, -0.217285, -0.976074);
 cgVertex3f(-0.549976, -0.111763, -0.255357);
 cgNormal3f(0.024902, -0.338867, -0.940918);
 cgVertex3f(-0.546689, -0.223526, -0.212624);
 cgNormal3f(0.029785, -0.319336, -0.947266);
 cgVertex3f(-0.803086, -0.230100, -0.222486);
 cgNormal3f(-0.007812, -0.208984, -0.978027);
 cgVertex3f(-0.812948, -0.115050, -0.261931);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.031250, -0.217285, -0.976074);
 cgVertex3f(-0.549976, -0.111763, -0.255357);
 cgNormal3f(0.035156, -0.211426, -0.977051);
 cgVertex3f(-0.319875, -0.111763, -0.245496);
 cgNormal3f(0.031738, -0.328125, -0.944336);
 cgVertex3f(-0.319875, -0.220239, -0.212624);
 cgNormal3f(0.024902, -0.338867, -0.940918);
 cgVertex3f(-0.546689, -0.223526, -0.212624);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.035156, -0.211426, -0.977051);
 cgVertex3f(-0.319875, -0.111763, -0.245496);
 cgNormal3f(0.051270, -0.223633, -0.973633);
 cgVertex3f(-0.070052, -0.101902, -0.238921);
 cgNormal3f(0.071777, -0.344238, -0.936523);
 cgVertex3f(-0.066765, -0.213665, -0.199475);
 cgNormal3f(0.031738, -0.328125, -0.944336);
 cgVertex3f(-0.319875, -0.220239, -0.212624);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.990723, -0.138184, 0.000000);
 cgVertex3f(-1.618299, -0.101902, -0.002246);
 cgNormal3f(-1.000000, 0.002441, -0.000488);
 cgVertex3f(-1.631448, 0.000000, -0.002246);
 cgNormal3f(-0.990234, 0.000977, -0.139648);
 cgVertex3f(-1.618299, 0.000000, -0.097574);
 cgNormal3f(-0.987793, -0.122070, -0.099609);
 cgVertex3f(-1.611725, -0.101902, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.820801, 0.000488, -0.571777);
 cgVertex3f(-1.608438, 0.000000, -0.143594);
 cgNormal3f(-0.836426, -0.095215, -0.540527);
 cgVertex3f(-1.605151, -0.111763, -0.140307);
 cgNormal3f(-0.987793, -0.122070, -0.099609);
 cgVertex3f(-1.611725, -0.101902, -0.097574);
 cgNormal3f(-0.990234, 0.000977, -0.139648);
 cgVertex3f(-1.618299, 0.000000, -0.097574);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.836426, -0.095215, -0.540527);
 cgVertex3f(-1.605151, -0.111763, -0.140307);
 cgNormal3f(-0.820801, 0.000488, -0.571777);
 cgVertex3f(-1.608438, 0.000000, -0.143594);
 cgNormal3f(-0.360840, 0.000000, -0.933105);
 cgVertex3f(-1.565705, 0.000000, -0.166604);
 cgNormal3f(-0.358398, -0.062988, -0.931641);
 cgVertex3f(-1.568992, -0.111763, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.358398, -0.062988, -0.931641);
 cgVertex3f(-1.568992, -0.111763, -0.163317);
 cgNormal3f(-0.360840, 0.000000, -0.933105);
 cgVertex3f(-1.565705, 0.000000, -0.166604);
 cgNormal3f(-0.180176, 0.000488, -0.983887);
 cgVertex3f(-1.381625, 0.000000, -0.206050);
 cgNormal3f(-0.170410, -0.078613, -0.982422);
 cgVertex3f(-1.378338, -0.115050, -0.202763);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.170410, -0.078613, -0.982422);
 cgVertex3f(-1.378338, -0.115050, -0.202763);
 cgNormal3f(-0.180176, 0.000488, -0.983887);
 cgVertex3f(-1.381625, 0.000000, -0.206050);
 cgNormal3f(-0.118652, 0.000977, -0.993164);
 cgVertex3f(-1.125227, 0.000000, -0.248783);
 cgNormal3f(-0.103027, -0.120605, -0.987793);
 cgVertex3f(-1.121940, -0.124912, -0.238921);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.055176, -0.170410, -0.983887);
 cgVertex3f(-0.967444, -0.118337, -0.252070);
 cgNormal3f(-0.079102, 0.000977, -0.997070);
 cgVertex3f(-0.974018, 0.000000, -0.261931);
 cgNormal3f(-0.021484, 0.001465, -1.000000);
 cgVertex3f(-0.822809, 0.000000, -0.275080);
 cgNormal3f(-0.007812, -0.208984, -0.978027);
 cgVertex3f(-0.812948, -0.115050, -0.261931);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.021484, 0.001465, -1.000000);
 cgVertex3f(-0.822809, 0.000000, -0.275080);
 cgNormal3f(0.033203, 0.001465, -0.999512);
 cgVertex3f(-0.556550, 0.000000, -0.265218);
 cgNormal3f(0.031250, -0.217285, -0.976074);
 cgVertex3f(-0.549976, -0.111763, -0.255357);
 cgNormal3f(-0.007812, -0.208984, -0.978027);
 cgVertex3f(-0.812948, -0.115050, -0.261931);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.168945, -0.917480, -0.360840);
 cgVertex3f(1.501206, -0.203803, -0.127158);
 cgNormal3f(0.100098, -0.650879, -0.752930);
 cgVertex3f(1.501206, -0.197229, -0.146881);
 cgNormal3f(0.175781, -0.422363, -0.889648);
 cgVertex3f(1.573523, -0.164357, -0.153455);
 cgNormal3f(0.403809, -0.804688, -0.435547);
 cgVertex3f(1.596533, -0.174219, -0.133732);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.068848, -0.628906, -0.774902);
 cgVertex3f(0.321119, -0.223526, -0.153455);
 cgNormal3f(0.053711, -0.442383, -0.895508);
 cgVertex3f(0.314545, -0.193942, -0.173178);
 cgNormal3f(0.028320, -0.410156, -0.912109);
 cgVertex3f(1.271105, -0.174219, -0.163317);
 cgNormal3f(0.023926, -0.669434, -0.743164);
 cgVertex3f(1.277679, -0.200516, -0.143594);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.135254, -0.558594, -0.818359);
 cgVertex3f(0.140326, -0.243249, -0.166604);
 cgNormal3f(0.084473, -0.395020, -0.915039);
 cgVertex3f(0.133751, -0.200516, -0.186327);
 cgNormal3f(0.053711, -0.442383, -0.895508);
 cgVertex3f(0.314545, -0.193942, -0.173178);
 cgNormal3f(0.068848, -0.628906, -0.774902);
 cgVertex3f(0.321119, -0.223526, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.129395, -0.483887, -0.865723);
 cgVertex3f(-0.066765, -0.315566, -0.160030);
 cgNormal3f(0.071777, -0.344238, -0.936523);
 cgVertex3f(-0.066765, -0.213665, -0.199475);
 cgNormal3f(0.084473, -0.395020, -0.915039);
 cgVertex3f(0.133751, -0.200516, -0.186327);
 cgNormal3f(0.135254, -0.558594, -0.818359);
 cgVertex3f(0.140326, -0.243249, -0.166604);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.040039, -0.307129, -0.951172);
 cgVertex3f(1.468334, -0.170932, -0.156743);
 cgNormal3f(0.069824, -0.178711, -0.981445);
 cgVertex3f(1.468334, -0.078892, -0.176465);
 cgNormal3f(0.175781, -0.422363, -0.889648);
 cgVertex3f(1.573523, -0.164357, -0.153455);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.053711, -0.442383, -0.895508);
 cgVertex3f(0.314545, -0.193942, -0.173178);
 cgNormal3f(0.044434, -0.278320, -0.959961);
 cgVertex3f(0.311257, -0.101902, -0.212624);
 cgNormal3f(0.047363, -0.237305, -0.970703);
 cgVertex3f(1.274392, -0.082179, -0.189614);
 cgNormal3f(0.028320, -0.410156, -0.912109);
 cgVertex3f(1.271105, -0.174219, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.084473, -0.395020, -0.915039);
 cgVertex3f(0.133751, -0.200516, -0.186327);
 cgNormal3f(0.062012, -0.261230, -0.963379);
 cgVertex3f(0.137038, -0.098614, -0.225773);
 cgNormal3f(0.044434, -0.278320, -0.959961);
 cgVertex3f(0.311257, -0.101902, -0.212624);
 cgNormal3f(0.053711, -0.442383, -0.895508);
 cgVertex3f(0.314545, -0.193942, -0.173178);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.071777, -0.344238, -0.936523);
 cgVertex3f(-0.066765, -0.213665, -0.199475);
 cgNormal3f(0.051270, -0.223633, -0.973633);
 cgVertex3f(-0.070052, -0.101902, -0.238921);
 cgNormal3f(0.062012, -0.261230, -0.963379);
 cgVertex3f(0.137038, -0.098614, -0.225773);
 cgNormal3f(0.084473, -0.395020, -0.915039);
 cgVertex3f(0.133751, -0.200516, -0.186327);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.069824, -0.178711, -0.981445);
 cgVertex3f(1.468334, -0.078892, -0.176465);
 cgNormal3f(0.085938, 0.002441, -0.996582);
 cgVertex3f(1.468334, 0.000000, -0.186327);
 cgNormal3f(0.225098, 0.001953, -0.974609);
 cgVertex3f(1.691860, 0.000000, -0.163317);
 cgNormal3f(0.207520, -0.223145, -0.952637);
 cgVertex3f(1.658989, -0.078892, -0.163317);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.044434, -0.278320, -0.959961);
 cgVertex3f(0.311257, -0.101902, -0.212624);
 cgNormal3f(0.041504, 0.004395, -0.999512);
 cgVertex3f(0.304683, 0.000000, -0.235634);
 cgNormal3f(0.057617, 0.004395, -0.998535);
 cgVertex3f(1.277679, 0.000000, -0.206050);
 cgNormal3f(0.047363, -0.237305, -0.970703);
 cgVertex3f(1.274392, -0.082179, -0.189614);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.062012, -0.261230, -0.963379);
 cgVertex3f(0.137038, -0.098614, -0.225773);
 cgNormal3f(0.051270, 0.002930, -0.999023);
 cgVertex3f(0.130464, 0.000000, -0.242208);
 cgNormal3f(0.041504, 0.004395, -0.999512);
 cgVertex3f(0.304683, 0.000000, -0.235634);
 cgNormal3f(0.044434, -0.278320, -0.959961);
 cgVertex3f(0.311257, -0.101902, -0.212624);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.668457, 0.001953, 0.743652);
 cgVertex3f(-1.618299, 0.000000, 0.093081);
 cgNormal3f(-0.668457, -0.093262, 0.737793);
 cgVertex3f(-1.611725, -0.101902, 0.093081);
 cgNormal3f(-0.533203, -0.062988, 0.843262);
 cgVertex3f(-1.598577, -0.111763, 0.093081);
 cgNormal3f(-0.524902, 0.000000, 0.851074);
 cgVertex3f(-1.605151, 0.000000, 0.093081);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.596680, 0.264160, -0.757812);
 cgVertex3f(0.047108, 0.398612, -0.010998);
 cgNormal3f(-0.351562, 0.553223, -0.755371);
 cgVertex3f(-0.046374, 0.425419, -0.010998);
 cgNormal3f(-0.234863, 0.971680, 0.003418);
 cgVertex3f(-0.044312, 0.432980, 0.000000);
 cgNormal3f(0.732910, 0.680176, 0.003906);
 cgVertex3f(0.049170, 0.404111, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.353027, -0.555664, -0.752930);
 cgVertex3f(0.043671, 0.386927, -0.010998);
 cgNormal3f(-0.604492, -0.261230, -0.753418);
 cgVertex3f(-0.049811, 0.415796, -0.010998);
 cgNormal3f(-0.351562, 0.553223, -0.755371);
 cgVertex3f(-0.046374, 0.425419, -0.010998);
 cgNormal3f(0.596680, 0.264160, -0.757812);
 cgVertex3f(0.047108, 0.398612, -0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.230469, -0.973145, 0.012695);
 cgVertex3f(0.042296, 0.380740, 0.000000);
 cgNormal3f(-0.737793, -0.675293, 0.012207);
 cgVertex3f(-0.051873, 0.409610, 0.000000);
 cgNormal3f(-0.604492, -0.261230, -0.753418);
 cgVertex3f(-0.049811, 0.415796, -0.010998);
 cgNormal3f(0.353027, -0.555664, -0.752930);
 cgVertex3f(0.043671, 0.386927, -0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.352539, -0.544922, 0.760742);
 cgVertex3f(0.043671, 0.386927, 0.010310);
 cgNormal3f(-0.598633, -0.252441, 0.760254);
 cgVertex3f(-0.049811, 0.415796, 0.010310);
 cgNormal3f(-0.737793, -0.675293, 0.012207);
 cgVertex3f(-0.051873, 0.409610, 0.000000);
 cgNormal3f(0.230469, -0.973145, 0.012695);
 cgVertex3f(0.042296, 0.380740, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.595703, 0.260742, 0.759277);
 cgVertex3f(0.047108, 0.398612, 0.010310);
 cgNormal3f(-0.350098, 0.550293, 0.757324);
 cgVertex3f(-0.046374, 0.425419, 0.010310);
 cgNormal3f(-0.598633, -0.252441, 0.760254);
 cgVertex3f(-0.049811, 0.415796, 0.010310);
 cgNormal3f(0.352539, -0.544922, 0.760742);
 cgVertex3f(0.043671, 0.386927, 0.010310);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.732910, 0.680176, 0.003906);
 cgVertex3f(0.049170, 0.404111, 0.000000);
 cgNormal3f(-0.234863, 0.971680, 0.003418);
 cgVertex3f(-0.044312, 0.432980, 0.000000);
 cgNormal3f(-0.350098, 0.550293, 0.757324);
 cgVertex3f(-0.046374, 0.425419, 0.010310);
 cgNormal3f(0.595703, 0.260742, 0.759277);
 cgVertex3f(0.047108, 0.398612, 0.010310);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.351562, 0.553223, -0.755371);
 cgVertex3f(-0.046374, 0.425419, -0.010998);
 cgNormal3f(-0.604492, -0.261230, -0.753418);
 cgVertex3f(-0.049811, 0.415796, -0.010998);
 cgNormal3f(-0.737793, -0.675293, 0.012207);
 cgVertex3f(-0.051873, 0.409610, 0.000000);
 cgNormal3f(-0.598633, -0.252441, 0.760254);
 cgVertex3f(-0.049811, 0.415796, 0.010310);
 cgNormal3f(-0.350098, 0.550293, 0.757324);
 cgVertex3f(-0.046374, 0.425419, 0.010310);
 cgNormal3f(-0.234863, 0.971680, 0.003418);
 cgVertex3f(-0.044312, 0.432980, 0.000000);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.732910, 0.680176, 0.003906);
 cgVertex3f(0.049170, 0.404111, 0.000000);
 cgNormal3f(0.595703, 0.260742, 0.759277);
 cgVertex3f(0.047108, 0.398612, 0.010310);
 cgNormal3f(0.352539, -0.544922, 0.760742);
 cgVertex3f(0.043671, 0.386927, 0.010310);
 cgNormal3f(0.230469, -0.973145, 0.012695);
 cgVertex3f(0.042296, 0.380740, 0.000000);
 cgNormal3f(0.353027, -0.555664, -0.752930);
 cgVertex3f(0.043671, 0.386927, -0.010998);
 cgNormal3f(0.596680, 0.264160, -0.757812);
 cgVertex3f(0.047108, 0.398612, -0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.341797, 0.453125, 0.823242);
 cgVertex3f(-0.039500, 0.432980, 0.020621);
 cgNormal3f(0.561035, 0.166992, 0.810059);
 cgVertex3f(-0.034001, 0.430231, 0.020621);
 cgNormal3f(0.688965, 0.635254, 0.348145);
 cgVertex3f(-0.030565, 0.442603, 0.008936);
 cgNormal3f(-0.224609, 0.912109, 0.342285);
 cgVertex3f(-0.036064, 0.443978, 0.008936);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.324707, 0.479492, 0.814941);
 cgVertex3f(0.039547, 0.408922, 0.020621);
 cgNormal3f(0.587891, 0.179688, 0.788086);
 cgVertex3f(0.045046, 0.407548, 0.020621);
 cgNormal3f(0.774902, 0.560059, 0.291504);
 cgVertex3f(0.048482, 0.416483, 0.008936);
 cgNormal3f(-0.088379, 0.939453, 0.330078);
 cgVertex3f(0.042983, 0.419920, 0.008936);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.224609, 0.912109, 0.342285);
 cgVertex3f(-0.036064, 0.443978, 0.008936);
 cgNormal3f(0.688965, 0.635254, 0.348145);
 cgVertex3f(-0.030565, 0.442603, 0.008936);
 cgNormal3f(0.666992, 0.657715, -0.349609);
 cgVertex3f(-0.030565, 0.442603, -0.010310);
 cgNormal3f(-0.254883, 0.905762, -0.338379);
 cgVertex3f(-0.036064, 0.443978, -0.010310);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.088379, 0.939453, 0.330078);
 cgVertex3f(0.042983, 0.419920, 0.008936);
 cgNormal3f(0.774902, 0.560059, 0.291504);
 cgVertex3f(0.048482, 0.416483, 0.008936);
 cgNormal3f(0.754395, 0.565430, -0.333008);
 cgVertex3f(0.048482, 0.416483, -0.010310);
 cgNormal3f(-0.129395, 0.921387, -0.365723);
 cgVertex3f(0.042983, 0.419920, -0.010310);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.341797, 0.453125, 0.823242);
 cgVertex3f(-0.039500, 0.432980, 0.020621);
 cgNormal3f(-0.224609, 0.912109, 0.342285);
 cgVertex3f(-0.036064, 0.443978, 0.008936);
 cgNormal3f(-0.254883, 0.905762, -0.338379);
 cgVertex3f(-0.036064, 0.443978, -0.010310);
 cgNormal3f(-0.370605, 0.454590, -0.810059);
 cgVertex3f(-0.039500, 0.432980, -0.021308);
 cgNormal3f(-0.152344, 0.825684, -0.542969);
 cgVertex3f(-0.057372, 0.375242, -0.021308);
 cgNormal3f(-0.152344, 0.825684, 0.542480);
 cgVertex3f(-0.057372, 0.375242, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.561035, 0.166992, 0.810059);
 cgVertex3f(-0.034001, 0.430231, 0.020621);
 cgNormal3f(-0.341797, 0.453125, 0.823242);
 cgVertex3f(-0.039500, 0.432980, 0.020621);
 cgNormal3f(-0.152344, 0.825684, 0.542480);
 cgVertex3f(-0.057372, 0.375242, 0.020621);
 cgNormal3f(0.589355, 0.596191, 0.544434);
 cgVertex3f(-0.051873, 0.373867, 0.020621);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.538574, 0.180664, -0.822754);
 cgVertex3f(-0.034001, 0.430231, -0.021308);
 cgNormal3f(0.666992, 0.657715, -0.349609);
 cgVertex3f(-0.030565, 0.442603, -0.010310);
 cgNormal3f(0.688965, 0.635254, 0.348145);
 cgVertex3f(-0.030565, 0.442603, 0.008936);
 cgNormal3f(0.561035, 0.166992, 0.810059);
 cgVertex3f(-0.034001, 0.430231, 0.020621);
 cgNormal3f(0.589355, 0.596191, 0.544434);
 cgVertex3f(-0.051873, 0.373867, 0.020621);
 cgNormal3f(0.591309, 0.597656, -0.541016);
 cgVertex3f(-0.051873, 0.373867, -0.021308);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.370605, 0.454590, -0.810059);
 cgVertex3f(-0.039500, 0.432980, -0.021308);
 cgNormal3f(0.538574, 0.180664, -0.822754);
 cgVertex3f(-0.034001, 0.430231, -0.021308);
 cgNormal3f(0.591309, 0.597656, -0.541016);
 cgVertex3f(-0.051873, 0.373867, -0.021308);
 cgNormal3f(-0.152344, 0.825684, -0.542969);
 cgVertex3f(-0.057372, 0.375242, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.552246, 0.173340, -0.815430);
 cgVertex3f(0.045046, 0.407548, -0.021308);
 cgNormal3f(0.754395, 0.565430, -0.333008);
 cgVertex3f(0.048482, 0.416483, -0.010310);
 cgNormal3f(0.774902, 0.560059, 0.291504);
 cgVertex3f(0.048482, 0.416483, 0.008936);
 cgNormal3f(0.587891, 0.179688, 0.788086);
 cgVertex3f(0.045046, 0.407548, 0.020621);
 cgNormal3f(0.590332, 0.594727, 0.544434);
 cgVertex3f(0.027174, 0.349122, 0.020621);
 cgNormal3f(0.590332, 0.595215, -0.544922);
 cgVertex3f(0.027174, 0.349122, -0.021308);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.354980, 0.458984, -0.814453);
 cgVertex3f(0.039547, 0.408922, -0.021308);
 cgNormal3f(0.552246, 0.173340, -0.815430);
 cgVertex3f(0.045046, 0.407548, -0.021308);
 cgNormal3f(0.590332, 0.595215, -0.544922);
 cgVertex3f(0.027174, 0.349122, -0.021308);
 cgNormal3f(-0.151367, 0.825684, -0.542969);
 cgVertex3f(0.021675, 0.351184, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.324707, 0.479492, 0.814941);
 cgVertex3f(0.039547, 0.408922, 0.020621);
 cgNormal3f(-0.088379, 0.939453, 0.330078);
 cgVertex3f(0.042983, 0.419920, 0.008936);
 cgNormal3f(-0.129395, 0.921387, -0.365723);
 cgVertex3f(0.042983, 0.419920, -0.010310);
 cgNormal3f(-0.354980, 0.458984, -0.814453);
 cgVertex3f(0.039547, 0.408922, -0.021308);
 cgNormal3f(-0.151367, 0.825684, -0.542969);
 cgVertex3f(0.021675, 0.351184, -0.021308);
 cgNormal3f(-0.151367, 0.825684, 0.542480);
 cgVertex3f(0.021675, 0.351184, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.587891, 0.179688, 0.788086);
 cgVertex3f(0.045046, 0.407548, 0.020621);
 cgNormal3f(-0.324707, 0.479492, 0.814941);
 cgVertex3f(0.039547, 0.408922, 0.020621);
 cgNormal3f(-0.151367, 0.825684, 0.542480);
 cgVertex3f(0.021675, 0.351184, 0.020621);
 cgNormal3f(0.590332, 0.594727, 0.544434);
 cgVertex3f(0.027174, 0.349122, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.151367, 0.825684, 0.542480);
 cgVertex3f(0.021675, 0.351184, 0.020621);
 cgNormal3f(-0.151367, 0.825684, -0.542969);
 cgVertex3f(0.021675, 0.351184, -0.021308);
 cgNormal3f(0.591309, 0.597656, -0.541016);
 cgVertex3f(-0.051873, 0.373867, -0.021308);
 cgNormal3f(0.589355, 0.596191, 0.544434);
 cgVertex3f(-0.051873, 0.373867, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.129395, 0.921387, -0.365723);
 cgVertex3f(0.042983, 0.419920, -0.010310);
 cgNormal3f(0.754395, 0.565430, -0.333008);
 cgVertex3f(0.048482, 0.416483, -0.010310);
 cgNormal3f(0.552246, 0.173340, -0.815430);
 cgVertex3f(0.045046, 0.407548, -0.021308);
 cgNormal3f(-0.354980, 0.458984, -0.814453);
 cgVertex3f(0.039547, 0.408922, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.590332, 0.594727, 0.544434);
 cgVertex3f(0.027174, 0.349122, 0.020621);
 cgNormal3f(-0.151367, 0.825684, 0.542480);
 cgVertex3f(0.021675, 0.351184, 0.020621);
 cgNormal3f(0.589355, 0.596191, 0.544434);
 cgVertex3f(-0.051873, 0.373867, 0.020621);
 cgNormal3f(-0.152344, 0.825684, 0.542480);
 cgVertex3f(-0.057372, 0.375242, 0.020621);
 cgNormal3f(-0.057129, 0.707520, 0.704102);
 cgVertex3f(-0.082117, 0.382803, 0.032994);
 cgNormal3f(0.446777, 0.559082, 0.697754);
 cgVertex3f(0.052607, 0.341561, 0.032994);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.590332, 0.595215, -0.544922);
 cgVertex3f(0.027174, 0.349122, -0.021308);
 cgNormal3f(0.590332, 0.594727, 0.544434);
 cgVertex3f(0.027174, 0.349122, 0.020621);
 cgNormal3f(0.446777, 0.559082, 0.697754);
 cgVertex3f(0.052607, 0.341561, 0.032994);
 cgNormal3f(0.923828, 0.244141, 0.294434);
 cgVertex3f(0.069791, 0.336062, 0.010998);
 cgNormal3f(0.923828, 0.244141, -0.294922);
 cgVertex3f(0.069791, 0.336062, -0.011685);
 cgNormal3f(0.446777, 0.559082, -0.698242);
 cgVertex3f(0.052607, 0.341561, -0.033681);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.152344, 0.825684, -0.542969);
 cgVertex3f(-0.057372, 0.375242, -0.021308);
 cgNormal3f(0.591309, 0.597656, -0.541016);
 cgVertex3f(-0.051873, 0.373867, -0.021308);
 cgNormal3f(-0.151367, 0.825684, -0.542969);
 cgVertex3f(0.021675, 0.351184, -0.021308);
 cgNormal3f(0.590332, 0.595215, -0.544922);
 cgVertex3f(0.027174, 0.349122, -0.021308);
 cgNormal3f(0.446777, 0.559082, -0.698242);
 cgVertex3f(0.052607, 0.341561, -0.033681);
 cgNormal3f(-0.057129, 0.707520, -0.704590);
 cgVertex3f(-0.082117, 0.382803, -0.033681);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.152344, 0.825684, 0.542480);
 cgVertex3f(-0.057372, 0.375242, 0.020621);
 cgNormal3f(-0.152344, 0.825684, -0.542969);
 cgVertex3f(-0.057372, 0.375242, -0.021308);
 cgNormal3f(-0.057129, 0.707520, -0.704590);
 cgVertex3f(-0.082117, 0.382803, -0.033681);
 cgNormal3f(-0.653809, 0.692383, -0.304688);
 cgVertex3f(-0.099989, 0.388302, -0.011685);
 cgNormal3f(-0.653809, 0.692383, 0.304199);
 cgVertex3f(-0.099989, 0.388302, 0.010998);
 cgNormal3f(-0.057129, 0.707520, 0.704102);
 cgVertex3f(-0.082117, 0.382803, 0.032994);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.493164, -0.353516, 0.794922);
 cgVertex3f(-0.084867, 0.373867, 0.032994);
 cgNormal3f(-0.057129, 0.707520, 0.704102);
 cgVertex3f(-0.082117, 0.382803, 0.032994);
 cgNormal3f(-0.653809, 0.692383, 0.304199);
 cgVertex3f(-0.099989, 0.388302, 0.010998);
 cgNormal3f(-0.930176, -0.206055, 0.304199);
 cgVertex3f(-0.102738, 0.379366, 0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.057129, 0.707520, -0.704590);
 cgVertex3f(-0.082117, 0.382803, -0.033681);
 cgNormal3f(-0.493164, -0.353516, -0.795410);
 cgVertex3f(-0.084867, 0.373867, -0.033681);
 cgNormal3f(-0.930176, -0.206055, -0.304688);
 cgVertex3f(-0.102738, 0.379366, -0.011685);
 cgNormal3f(-0.653809, 0.692383, -0.304688);
 cgVertex3f(-0.099989, 0.388302, -0.011685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.682617, -0.662598, -0.307617);
 cgVertex3f(0.067729, 0.327126, -0.011685);
 cgNormal3f(0.923828, 0.244141, -0.294922);
 cgVertex3f(0.069791, 0.336062, -0.011685);
 cgNormal3f(0.923828, 0.244141, 0.294434);
 cgVertex3f(0.069791, 0.336062, 0.010998);
 cgNormal3f(0.682617, -0.662598, 0.307129);
 cgVertex3f(0.067729, 0.327126, 0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.446777, 0.559082, 0.697754);
 cgVertex3f(0.052607, 0.341561, 0.032994);
 cgNormal3f(0.217773, -0.562012, 0.797852);
 cgVertex3f(0.049857, 0.332625, 0.032994);
 cgNormal3f(0.682617, -0.662598, 0.307129);
 cgVertex3f(0.067729, 0.327126, 0.010998);
 cgNormal3f(0.923828, 0.244141, 0.294434);
 cgVertex3f(0.069791, 0.336062, 0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.930176, -0.206055, 0.304199);
 cgVertex3f(-0.102738, 0.379366, 0.010998);
 cgNormal3f(-0.653809, 0.692383, 0.304199);
 cgVertex3f(-0.099989, 0.388302, 0.010998);
 cgNormal3f(-0.653809, 0.692383, -0.304688);
 cgVertex3f(-0.099989, 0.388302, -0.011685);
 cgNormal3f(-0.930176, -0.206055, -0.304688);
 cgVertex3f(-0.102738, 0.379366, -0.011685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.217773, -0.562012, -0.798340);
 cgVertex3f(0.049857, 0.332625, -0.033681);
 cgNormal3f(0.446777, 0.559082, -0.698242);
 cgVertex3f(0.052607, 0.341561, -0.033681);
 cgNormal3f(0.923828, 0.244141, -0.294922);
 cgVertex3f(0.069791, 0.336062, -0.011685);
 cgNormal3f(0.682617, -0.662598, -0.307617);
 cgVertex3f(0.067729, 0.327126, -0.011685);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.493164, -0.353516, -0.795410);
 cgVertex3f(-0.084867, 0.373867, -0.033681);
 cgNormal3f(0.217773, -0.562012, -0.798340);
 cgVertex3f(0.049857, 0.332625, -0.033681);
 cgNormal3f(0.682617, -0.662598, -0.307617);
 cgVertex3f(0.067729, 0.327126, -0.011685);
 cgNormal3f(0.682617, -0.662598, 0.307129);
 cgVertex3f(0.067729, 0.327126, 0.010998);
 cgNormal3f(0.217773, -0.562012, 0.797852);
 cgVertex3f(0.049857, 0.332625, 0.032994);
 cgNormal3f(-0.493164, -0.353516, 0.794922);
 cgVertex3f(-0.084867, 0.373867, 0.032994);
 cgNormal3f(-0.930176, -0.206055, 0.304199);
 cgVertex3f(-0.102738, 0.379366, 0.010998);
 cgNormal3f(-0.930176, -0.206055, -0.304688);
 cgVertex3f(-0.102738, 0.379366, -0.011685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.538574, 0.180664, -0.822754);
 cgVertex3f(-0.034001, 0.430231, -0.021308);
 cgNormal3f(-0.370605, 0.454590, -0.810059);
 cgVertex3f(-0.039500, 0.432980, -0.021308);
 cgNormal3f(-0.254883, 0.905762, -0.338379);
 cgVertex3f(-0.036064, 0.443978, -0.010310);
 cgNormal3f(0.666992, 0.657715, -0.349609);
 cgVertex3f(-0.030565, 0.442603, -0.010310);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.493164, -0.353516, -0.795410);
 cgVertex3f(-0.084867, 0.373867, -0.033681);
 cgNormal3f(-0.057129, 0.707520, -0.704590);
 cgVertex3f(-0.082117, 0.382803, -0.033681);
 cgNormal3f(0.446777, 0.559082, -0.698242);
 cgVertex3f(0.052607, 0.341561, -0.033681);
 cgNormal3f(0.217773, -0.562012, -0.798340);
 cgVertex3f(0.049857, 0.332625, -0.033681);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.217773, -0.562012, 0.797852);
 cgVertex3f(0.049857, 0.332625, 0.032994);
 cgNormal3f(0.446777, 0.559082, 0.697754);
 cgVertex3f(0.052607, 0.341561, 0.032994);
 cgNormal3f(-0.057129, 0.707520, 0.704102);
 cgVertex3f(-0.082117, 0.382803, 0.032994);
 cgNormal3f(-0.493164, -0.353516, 0.794922);
 cgVertex3f(-0.084867, 0.373867, 0.032994);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.496094, 0.420410, -0.759766);
 cgVertex3f(-0.495911, 0.485220, -0.010998);
 cgNormal3f(-0.496582, 0.420410, -0.759766);
 cgVertex3f(-0.593517, 0.485220, -0.010998);
 cgNormal3f(-0.511719, 0.858887, 0.012207);
 cgVertex3f(-0.593517, 0.492094, 0.000000);
 cgNormal3f(0.511230, 0.858887, 0.012207);
 cgVertex3f(-0.495911, 0.492094, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.500977, -0.437012, -0.747070);
 cgVertex3f(-0.495911, 0.472160, -0.010998);
 cgNormal3f(-0.501465, -0.437012, -0.747070);
 cgVertex3f(-0.593517, 0.472160, -0.010998);
 cgNormal3f(-0.496582, 0.420410, -0.759766);
 cgVertex3f(-0.593517, 0.485220, -0.010998);
 cgNormal3f(0.496094, 0.420410, -0.759766);
 cgVertex3f(-0.495911, 0.485220, -0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.495117, -0.868652, -0.009766);
 cgVertex3f(-0.495911, 0.466661, 0.000000);
 cgNormal3f(-0.495605, -0.868652, -0.009766);
 cgVertex3f(-0.593517, 0.466661, 0.000000);
 cgNormal3f(-0.501465, -0.437012, -0.747070);
 cgVertex3f(-0.593517, 0.472160, -0.010998);
 cgNormal3f(0.500977, -0.437012, -0.747070);
 cgVertex3f(-0.495911, 0.472160, -0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.503418, -0.444824, 0.740723);
 cgVertex3f(-0.495911, 0.472160, 0.010310);
 cgNormal3f(-0.503906, -0.444824, 0.740723);
 cgVertex3f(-0.593517, 0.472160, 0.010310);
 cgNormal3f(-0.495605, -0.868652, -0.009766);
 cgVertex3f(-0.593517, 0.466661, 0.000000);
 cgNormal3f(0.495117, -0.868652, -0.009766);
 cgVertex3f(-0.495911, 0.466661, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.493164, 0.410156, 0.766602);
 cgVertex3f(-0.495911, 0.485220, 0.010310);
 cgNormal3f(-0.493652, 0.410156, 0.766602);
 cgVertex3f(-0.593517, 0.485220, 0.010310);
 cgNormal3f(-0.503906, -0.444824, 0.740723);
 cgVertex3f(-0.593517, 0.472160, 0.010310);
 cgNormal3f(0.503418, -0.444824, 0.740723);
 cgVertex3f(-0.495911, 0.472160, 0.010310);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.511230, 0.858887, 0.012207);
 cgVertex3f(-0.495911, 0.492094, 0.000000);
 cgNormal3f(-0.511719, 0.858887, 0.012207);
 cgVertex3f(-0.593517, 0.492094, 0.000000);
 cgNormal3f(-0.493652, 0.410156, 0.766602);
 cgVertex3f(-0.593517, 0.485220, 0.010310);
 cgNormal3f(0.493164, 0.410156, 0.766602);
 cgVertex3f(-0.495911, 0.485220, 0.010310);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.496582, 0.420410, -0.759766);
 cgVertex3f(-0.593517, 0.485220, -0.010998);
 cgNormal3f(-0.501465, -0.437012, -0.747070);
 cgVertex3f(-0.593517, 0.472160, -0.010998);
 cgNormal3f(-0.495605, -0.868652, -0.009766);
 cgVertex3f(-0.593517, 0.466661, 0.000000);
 cgNormal3f(-0.503906, -0.444824, 0.740723);
 cgVertex3f(-0.593517, 0.472160, 0.010310);
 cgNormal3f(-0.493652, 0.410156, 0.766602);
 cgVertex3f(-0.593517, 0.485220, 0.010310);
 cgNormal3f(-0.511719, 0.858887, 0.012207);
 cgVertex3f(-0.593517, 0.492094, 0.000000);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.511230, 0.858887, 0.012207);
 cgVertex3f(-0.495911, 0.492094, 0.000000);
 cgNormal3f(0.493164, 0.410156, 0.766602);
 cgVertex3f(-0.495911, 0.485220, 0.010310);
 cgNormal3f(0.503418, -0.444824, 0.740723);
 cgVertex3f(-0.495911, 0.472160, 0.010310);
 cgNormal3f(0.495117, -0.868652, -0.009766);
 cgVertex3f(-0.495911, 0.466661, 0.000000);
 cgNormal3f(0.500977, -0.437012, -0.747070);
 cgVertex3f(-0.495911, 0.472160, -0.010998);
 cgNormal3f(0.496094, 0.420410, -0.759766);
 cgVertex3f(-0.495911, 0.485220, -0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.480957, 0.360352, 0.798828);
 cgVertex3f(-0.588705, 0.493468, 0.020621);
 cgNormal3f(0.480469, 0.360352, 0.798828);
 cgVertex3f(-0.583206, 0.493468, 0.020621);
 cgNormal3f(0.473633, 0.828613, 0.296387);
 cgVertex3f(-0.583206, 0.503779, 0.008936);
 cgNormal3f(-0.474121, 0.828613, 0.296387);
 cgVertex3f(-0.588705, 0.503779, 0.008936);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.480957, 0.360352, 0.798828);
 cgVertex3f(-0.506221, 0.493468, 0.020621);
 cgNormal3f(0.480469, 0.360352, 0.798828);
 cgVertex3f(-0.500722, 0.493468, 0.020621);
 cgNormal3f(0.473633, 0.828613, 0.296387);
 cgVertex3f(-0.500722, 0.503779, 0.008936);
 cgNormal3f(-0.474121, 0.828613, 0.296387);
 cgVertex3f(-0.506221, 0.503779, 0.008936);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.474121, 0.828613, 0.296387);
 cgVertex3f(-0.588705, 0.503779, 0.008936);
 cgNormal3f(0.473633, 0.828613, 0.296387);
 cgVertex3f(-0.583206, 0.503779, 0.008936);
 cgNormal3f(0.475098, 0.800781, -0.363281);
 cgVertex3f(-0.583206, 0.503779, -0.010310);
 cgNormal3f(-0.475586, 0.800781, -0.363281);
 cgVertex3f(-0.588705, 0.503779, -0.010310);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.474121, 0.828613, 0.296387);
 cgVertex3f(-0.506221, 0.503779, 0.008936);
 cgNormal3f(0.473633, 0.828613, 0.296387);
 cgVertex3f(-0.500722, 0.503779, 0.008936);
 cgNormal3f(0.475098, 0.800781, -0.363281);
 cgVertex3f(-0.500722, 0.503779, -0.010310);
 cgNormal3f(-0.475586, 0.800781, -0.363281);
 cgVertex3f(-0.506221, 0.503779, -0.010310);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.480957, 0.360352, 0.798828);
 cgVertex3f(-0.588705, 0.493468, 0.020621);
 cgNormal3f(-0.474121, 0.828613, 0.296387);
 cgVertex3f(-0.588705, 0.503779, 0.008936);
 cgNormal3f(-0.475586, 0.800781, -0.363281);
 cgVertex3f(-0.588705, 0.503779, -0.010310);
 cgNormal3f(-0.474121, 0.324219, -0.818848);
 cgVertex3f(-0.588705, 0.493468, -0.021308);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.588705, 0.432980, -0.021308);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.588705, 0.432980, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.480469, 0.360352, 0.798828);
 cgVertex3f(-0.583206, 0.493468, 0.020621);
 cgNormal3f(-0.480957, 0.360352, 0.798828);
 cgVertex3f(-0.588705, 0.493468, 0.020621);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.588705, 0.432980, 0.020621);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.583206, 0.432980, 0.020621);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.473633, 0.324219, -0.818848);
 cgVertex3f(-0.583206, 0.493468, -0.021308);
 cgNormal3f(0.475098, 0.800781, -0.363281);
 cgVertex3f(-0.583206, 0.503779, -0.010310);
 cgNormal3f(0.473633, 0.828613, 0.296387);
 cgVertex3f(-0.583206, 0.503779, 0.008936);
 cgNormal3f(0.480469, 0.360352, 0.798828);
 cgVertex3f(-0.583206, 0.493468, 0.020621);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.583206, 0.432980, 0.020621);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.583206, 0.432980, -0.021308);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.474121, 0.324219, -0.818848);
 cgVertex3f(-0.588705, 0.493468, -0.021308);
 cgNormal3f(0.473633, 0.324219, -0.818848);
 cgVertex3f(-0.583206, 0.493468, -0.021308);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.583206, 0.432980, -0.021308);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.588705, 0.432980, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.473633, 0.324219, -0.818848);
 cgVertex3f(-0.500722, 0.493468, -0.021308);
 cgNormal3f(0.475098, 0.800781, -0.363281);
 cgVertex3f(-0.500722, 0.503779, -0.010310);
 cgNormal3f(0.473633, 0.828613, 0.296387);
 cgVertex3f(-0.500722, 0.503779, 0.008936);
 cgNormal3f(0.480469, 0.360352, 0.798828);
 cgVertex3f(-0.500722, 0.493468, 0.020621);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.500722, 0.432980, 0.020621);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.500722, 0.432980, -0.021308);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.474121, 0.324219, -0.818848);
 cgVertex3f(-0.506221, 0.493468, -0.021308);
 cgNormal3f(0.473633, 0.324219, -0.818848);
 cgVertex3f(-0.500722, 0.493468, -0.021308);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.500722, 0.432980, -0.021308);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.506221, 0.432980, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.480957, 0.360352, 0.798828);
 cgVertex3f(-0.506221, 0.493468, 0.020621);
 cgNormal3f(-0.474121, 0.828613, 0.296387);
 cgVertex3f(-0.506221, 0.503779, 0.008936);
 cgNormal3f(-0.475586, 0.800781, -0.363281);
 cgVertex3f(-0.506221, 0.503779, -0.010310);
 cgNormal3f(-0.474121, 0.324219, -0.818848);
 cgVertex3f(-0.506221, 0.493468, -0.021308);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.506221, 0.432980, -0.021308);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.506221, 0.432980, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.480469, 0.360352, 0.798828);
 cgVertex3f(-0.500722, 0.493468, 0.020621);
 cgNormal3f(-0.480957, 0.360352, 0.798828);
 cgVertex3f(-0.506221, 0.493468, 0.020621);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.506221, 0.432980, 0.020621);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.500722, 0.432980, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.506221, 0.432980, 0.020621);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.506221, 0.432980, -0.021308);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.583206, 0.432980, -0.021308);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.583206, 0.432980, 0.020621);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.475586, 0.800781, -0.363281);
 cgVertex3f(-0.506221, 0.503779, -0.010310);
 cgNormal3f(0.475098, 0.800781, -0.363281);
 cgVertex3f(-0.500722, 0.503779, -0.010310);
 cgNormal3f(0.473633, 0.324219, -0.818848);
 cgVertex3f(-0.500722, 0.493468, -0.021308);
 cgNormal3f(-0.474121, 0.324219, -0.818848);
 cgVertex3f(-0.506221, 0.493468, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.588705, 0.432980, 0.020621);
 cgNormal3f(-0.288086, 0.742188, 0.604980);
 cgVertex3f(-0.615512, 0.432980, 0.032994);
 cgNormal3f(0.287598, 0.742188, 0.604980);
 cgVertex3f(-0.473915, 0.432980, 0.032994);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.500722, 0.432980, 0.020621);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.506221, 0.432980, 0.020621);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.583206, 0.432980, 0.020621);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.500722, 0.432980, -0.021308);
 cgNormal3f(0.408203, 0.816406, 0.408203);
 cgVertex3f(-0.500722, 0.432980, 0.020621);
 cgNormal3f(0.287598, 0.742188, 0.604980);
 cgVertex3f(-0.473915, 0.432980, 0.032994);
 cgNormal3f(0.832031, 0.468262, 0.295410);
 cgVertex3f(-0.456044, 0.432980, 0.010998);
 cgNormal3f(0.832031, 0.468262, -0.295898);
 cgVertex3f(-0.456044, 0.432980, -0.011685);
 cgNormal3f(0.287598, 0.742188, -0.605469);
 cgVertex3f(-0.473915, 0.432980, -0.033681);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.500722, 0.432980, -0.021308);
 cgNormal3f(0.287598, 0.742188, -0.605469);
 cgVertex3f(-0.473915, 0.432980, -0.033681);
 cgNormal3f(-0.288086, 0.742188, -0.605469);
 cgVertex3f(-0.615512, 0.432980, -0.033681);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.588705, 0.432980, -0.021308);
 cgNormal3f(0.408203, 0.816406, -0.408691);
 cgVertex3f(-0.583206, 0.432980, -0.021308);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.506221, 0.432980, -0.021308);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(-0.588705, 0.432980, 0.020621);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(-0.588705, 0.432980, -0.021308);
 cgNormal3f(-0.288086, 0.742188, -0.605469);
 cgVertex3f(-0.615512, 0.432980, -0.033681);
 cgNormal3f(-0.832520, 0.468262, -0.295898);
 cgVertex3f(-0.633384, 0.432980, -0.011685);
 cgNormal3f(-0.832520, 0.468262, 0.295410);
 cgVertex3f(-0.633384, 0.432980, 0.010998);
 cgNormal3f(-0.288086, 0.742188, 0.604980);
 cgVertex3f(-0.615512, 0.432980, 0.032994);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.375977, -0.484863, 0.789551);
 cgVertex3f(-0.615512, 0.424045, 0.032994);
 cgNormal3f(-0.288086, 0.742188, 0.604980);
 cgVertex3f(-0.615512, 0.432980, 0.032994);
 cgNormal3f(-0.832520, 0.468262, 0.295410);
 cgVertex3f(-0.633384, 0.432980, 0.010998);
 cgNormal3f(-0.832520, -0.468750, 0.295410);
 cgVertex3f(-0.633384, 0.424045, 0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.288086, 0.742188, -0.605469);
 cgVertex3f(-0.615512, 0.432980, -0.033681);
 cgNormal3f(-0.375977, -0.484863, -0.790039);
 cgVertex3f(-0.615512, 0.424045, -0.033681);
 cgNormal3f(-0.832520, -0.468750, -0.295898);
 cgVertex3f(-0.633384, 0.424045, -0.011685);
 cgNormal3f(-0.832520, 0.468262, -0.295898);
 cgVertex3f(-0.633384, 0.432980, -0.011685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.832031, -0.468750, -0.295898);
 cgVertex3f(-0.456044, 0.424045, -0.011685);
 cgNormal3f(0.832031, 0.468262, -0.295898);
 cgVertex3f(-0.456044, 0.432980, -0.011685);
 cgNormal3f(0.832031, 0.468262, 0.295410);
 cgVertex3f(-0.456044, 0.432980, 0.010998);
 cgNormal3f(0.832031, -0.468750, 0.295410);
 cgVertex3f(-0.456044, 0.424045, 0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.287598, 0.742188, 0.604980);
 cgVertex3f(-0.473915, 0.432980, 0.032994);
 cgNormal3f(0.375488, -0.484863, 0.789551);
 cgVertex3f(-0.473915, 0.424045, 0.032994);
 cgNormal3f(0.832031, -0.468750, 0.295410);
 cgVertex3f(-0.456044, 0.424045, 0.010998);
 cgNormal3f(0.832031, 0.468262, 0.295410);
 cgVertex3f(-0.456044, 0.432980, 0.010998);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.832520, -0.468750, 0.295410);
 cgVertex3f(-0.633384, 0.424045, 0.010998);
 cgNormal3f(-0.832520, 0.468262, 0.295410);
 cgVertex3f(-0.633384, 0.432980, 0.010998);
 cgNormal3f(-0.832520, 0.468262, -0.295898);
 cgVertex3f(-0.633384, 0.432980, -0.011685);
 cgNormal3f(-0.832520, -0.468750, -0.295898);
 cgVertex3f(-0.633384, 0.424045, -0.011685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.375488, -0.484863, -0.790039);
 cgVertex3f(-0.473915, 0.424045, -0.033681);
 cgNormal3f(0.287598, 0.742188, -0.605469);
 cgVertex3f(-0.473915, 0.432980, -0.033681);
 cgNormal3f(0.832031, 0.468262, -0.295898);
 cgVertex3f(-0.456044, 0.432980, -0.011685);
 cgNormal3f(0.832031, -0.468750, -0.295898);
 cgVertex3f(-0.456044, 0.424045, -0.011685);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.375977, -0.484863, -0.790039);
 cgVertex3f(-0.615512, 0.424045, -0.033681);
 cgNormal3f(0.375488, -0.484863, -0.790039);
 cgVertex3f(-0.473915, 0.424045, -0.033681);
 cgNormal3f(0.832031, -0.468750, -0.295898);
 cgVertex3f(-0.456044, 0.424045, -0.011685);
 cgNormal3f(0.832031, -0.468750, 0.295410);
 cgVertex3f(-0.456044, 0.424045, 0.010998);
 cgNormal3f(0.375488, -0.484863, 0.789551);
 cgVertex3f(-0.473915, 0.424045, 0.032994);
 cgNormal3f(-0.375977, -0.484863, 0.789551);
 cgVertex3f(-0.615512, 0.424045, 0.032994);
 cgNormal3f(-0.832520, -0.468750, 0.295410);
 cgVertex3f(-0.633384, 0.424045, 0.010998);
 cgNormal3f(-0.832520, -0.468750, -0.295898);
 cgVertex3f(-0.633384, 0.424045, -0.011685);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.473633, 0.324219, -0.818848);
 cgVertex3f(-0.583206, 0.493468, -0.021308);
 cgNormal3f(-0.474121, 0.324219, -0.818848);
 cgVertex3f(-0.588705, 0.493468, -0.021308);
 cgNormal3f(-0.475586, 0.800781, -0.363281);
 cgVertex3f(-0.588705, 0.503779, -0.010310);
 cgNormal3f(0.475098, 0.800781, -0.363281);
 cgVertex3f(-0.583206, 0.503779, -0.010310);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.375977, -0.484863, -0.790039);
 cgVertex3f(-0.615512, 0.424045, -0.033681);
 cgNormal3f(-0.288086, 0.742188, -0.605469);
 cgVertex3f(-0.615512, 0.432980, -0.033681);
 cgNormal3f(0.287598, 0.742188, -0.605469);
 cgVertex3f(-0.473915, 0.432980, -0.033681);
 cgNormal3f(0.375488, -0.484863, -0.790039);
 cgVertex3f(-0.473915, 0.424045, -0.033681);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.375488, -0.484863, 0.789551);
 cgVertex3f(-0.473915, 0.424045, 0.032994);
 cgNormal3f(0.287598, 0.742188, 0.604980);
 cgVertex3f(-0.473915, 0.432980, 0.032994);
 cgNormal3f(-0.288086, 0.742188, 0.604980);
 cgVertex3f(-0.615512, 0.432980, 0.032994);
 cgNormal3f(-0.375977, -0.484863, 0.789551);
 cgVertex3f(-0.615512, 0.424045, 0.032994);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.370117, -0.423828, 0.826660);
 cgVertex3f(-0.556009, 0.456082, 0.035537);
 cgNormal3f(0.302734, -0.540039, 0.784668);
 cgVertex3f(-0.525211, 0.452528, 0.035537);
 cgNormal3f(0.401855, -0.217773, 0.889160);
 cgVertex3f(-0.508627, 0.548478, 0.035537);
 cgNormal3f(-0.320801, 0.099121, 0.941895);
 cgVertex3f(-0.542979, 0.552031, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.514160, 0.500000, 0.696777);
 cgVertex3f(-0.539425, 0.604152, 0.004738);
 cgNormal3f(-0.477051, 0.463867, -0.746582);
 cgVertex3f(-0.539425, 0.604152, -0.005923);
 cgNormal3f(-0.666016, 0.222168, -0.712402);
 cgVertex3f(-0.558378, 0.568615, -0.005923);
 cgNormal3f(-0.666016, 0.222168, 0.711914);
 cgVertex3f(-0.558378, 0.568615, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.959961, -0.281738, 0.000000);
 cgVertex3f(-0.570224, 0.458451, 0.000000);
 cgNormal3f(-0.956055, -0.293945, 0.000000);
 cgVertex3f(-0.570224, 0.458451, 0.004738);
 cgNormal3f(-0.911621, -0.187500, 0.366699);
 cgVertex3f(-0.564301, 0.489250, 0.004738);
 cgNormal3f(-0.913086, -0.408203, 0.000000);
 cgVertex3f(-0.564301, 0.489250, 0.000000);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.956055, -0.293945, 0.000000);
 cgVertex3f(-0.570224, 0.458451, -0.005923);
 cgNormal3f(-0.859375, -0.358887, -0.364746);
 cgVertex3f(-0.570224, 0.458451, -0.024876);
 cgNormal3f(-0.370117, -0.423828, -0.827148);
 cgVertex3f(-0.556009, 0.456082, -0.036721);
 cgNormal3f(0.304688, -0.540527, -0.784180);
 cgVertex3f(-0.525211, 0.452528, -0.036721);
 cgNormal3f(0.746094, -0.598633, -0.291016);
 cgVertex3f(-0.515734, 0.451344, -0.024876);
 cgNormal3f(0.745117, -0.599121, 0.292480);
 cgVertex3f(-0.515734, 0.451344, 0.023691);
 cgNormal3f(0.302734, -0.540039, 0.784668);
 cgVertex3f(-0.525211, 0.452528, 0.035537);
 cgNormal3f(-0.370117, -0.423828, 0.826660);
 cgVertex3f(-0.556009, 0.456082, 0.035537);
 cgNormal3f(-0.859375, -0.358887, 0.364258);
 cgVertex3f(-0.570224, 0.458451, 0.023691);
 cgNormal3f(-0.956055, -0.293945, 0.000000);
 cgVertex3f(-0.570224, 0.458451, 0.004738);
 cgNormal3f(-0.959961, -0.281738, 0.000000);
 cgVertex3f(-0.570224, 0.458451, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.746094, -0.598633, -0.291016);
 cgVertex3f(-0.515734, 0.451344, -0.024876);
 cgNormal3f(0.850098, -0.416504, -0.321777);
 cgVertex3f(-0.499150, 0.544924, -0.024876);
 cgNormal3f(0.856934, -0.421875, 0.295410);
 cgVertex3f(-0.499150, 0.544924, 0.023691);
 cgNormal3f(0.745117, -0.599121, 0.292480);
 cgVertex3f(-0.515734, 0.451344, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.850098, -0.416504, -0.321777);
 cgVertex3f(-0.499150, 0.544924, -0.024876);
 cgNormal3f(0.458496, -0.812988, -0.359863);
 cgVertex3f(-0.484935, 0.562693, -0.024876);
 cgNormal3f(0.463379, -0.819824, 0.336426);
 cgVertex3f(-0.484935, 0.562693, 0.023691);
 cgNormal3f(0.856934, -0.421875, 0.295410);
 cgVertex3f(-0.499150, 0.544924, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.458496, -0.812988, -0.359863);
 cgVertex3f(-0.484935, 0.562693, -0.024876);
 cgNormal3f(0.005859, -0.909180, -0.416992);
 cgVertex3f(-0.458875, 0.566246, -0.024876);
 cgNormal3f(-0.007324, -0.907227, 0.421387);
 cgVertex3f(-0.458875, 0.566246, 0.023691);
 cgNormal3f(0.463379, -0.819824, 0.336426);
 cgVertex3f(-0.484935, 0.562693, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.005859, -0.909180, -0.416992);
 cgVertex3f(-0.458875, 0.566246, -0.024876);
 cgNormal3f(-0.248535, -0.861328, -0.443848);
 cgVertex3f(-0.412677, 0.559139, -0.024876);
 cgNormal3f(-0.255371, -0.860840, 0.440918);
 cgVertex3f(-0.412677, 0.559139, 0.023691);
 cgNormal3f(-0.007324, -0.907227, 0.421387);
 cgVertex3f(-0.458875, 0.566246, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.248535, -0.861328, -0.443848);
 cgVertex3f(-0.412677, 0.559139, -0.024876);
 cgNormal3f(-0.124023, -0.890625, -0.437988);
 cgVertex3f(-0.372402, 0.541370, -0.024876);
 cgNormal3f(-0.127441, -0.892090, 0.434082);
 cgVertex3f(-0.372402, 0.541370, 0.023691);
 cgNormal3f(-0.255371, -0.860840, 0.440918);
 cgVertex3f(-0.412677, 0.559139, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.124023, -0.890625, -0.437988);
 cgVertex3f(-0.372402, 0.541370, -0.024876);
 cgNormal3f(-0.099121, -0.904297, -0.416016);
 cgVertex3f(-0.317912, 0.548478, -0.024876);
 cgNormal3f(-0.099121, -0.904297, 0.415527);
 cgVertex3f(-0.317912, 0.548478, 0.023691);
 cgNormal3f(-0.127441, -0.892090, 0.434082);
 cgVertex3f(-0.372402, 0.541370, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.099121, -0.904297, -0.416016);
 cgVertex3f(-0.317912, 0.548478, -0.024876);
 cgNormal3f(-0.136719, -0.896484, -0.421875);
 cgVertex3f(-0.261053, 0.528340, -0.024876);
 cgNormal3f(-0.137695, -0.892090, 0.430176);
 cgVertex3f(-0.261053, 0.528340, 0.023691);
 cgNormal3f(-0.099121, -0.904297, 0.415527);
 cgVertex3f(-0.317912, 0.548478, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.023438, 0.714844, 0.698730);
 cgVertex3f(-0.443476, 0.632582, 0.004738);
 cgNormal3f(-0.022949, 0.695312, -0.718262);
 cgVertex3f(-0.443476, 0.632582, -0.005923);
 cgNormal3f(-0.208984, 0.639648, -0.739746);
 cgVertex3f(-0.502704, 0.625474, -0.005923);
 cgNormal3f(-0.225098, 0.688477, 0.688965);
 cgVertex3f(-0.502704, 0.625474, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.485840, 0.490234, 0.723145);
 cgVertex3f(-0.533503, 0.604152, 0.004738);
 cgNormal3f(-0.206543, 0.669922, 0.712402);
 cgVertex3f(-0.501519, 0.620736, 0.004738);
 cgNormal3f(-0.225098, 0.688477, 0.688965);
 cgVertex3f(-0.502704, 0.625474, 0.004738);
 cgNormal3f(-0.514160, 0.500000, 0.696777);
 cgVertex3f(-0.539425, 0.604152, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.008301, 0.368164, 0.929199);
 cgVertex3f(-0.432815, 0.614813, 0.035537);
 cgNormal3f(0.032715, 0.317871, 0.947266);
 cgVertex3f(-0.358187, 0.611260, 0.035537);
 cgNormal3f(0.098145, 0.923340, 0.370605);
 cgVertex3f(-0.368848, 0.621921, 0.023691);
 cgNormal3f(-0.019043, 0.917480, 0.395996);
 cgVertex3f(-0.442291, 0.627843, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.093262, 0.310059, 0.945801);
 cgVertex3f(-0.492043, 0.607706, 0.035537);
 cgNormal3f(-0.008301, 0.368164, 0.929199);
 cgVertex3f(-0.432815, 0.614813, 0.035537);
 cgNormal3f(-0.019043, 0.917480, 0.395996);
 cgVertex3f(-0.442291, 0.627843, 0.023691);
 cgNormal3f(-0.262207, 0.857910, 0.440918);
 cgVertex3f(-0.501519, 0.620736, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.291016, 0.285156, 0.913086);
 cgVertex3f(-0.524026, 0.591122, 0.035537);
 cgNormal3f(-0.093262, 0.310059, 0.945801);
 cgVertex3f(-0.492043, 0.607706, 0.035537);
 cgNormal3f(-0.262207, 0.857910, 0.440918);
 cgVertex3f(-0.501519, 0.620736, 0.023691);
 cgNormal3f(-0.628418, 0.626953, 0.460449);
 cgVertex3f(-0.533503, 0.604152, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.320801, 0.099121, 0.941895);
 cgVertex3f(-0.542979, 0.552031, 0.035537);
 cgNormal3f(-0.291016, 0.285156, 0.913086);
 cgVertex3f(-0.524026, 0.591122, 0.035537);
 cgNormal3f(-0.628418, 0.626953, 0.460449);
 cgVertex3f(-0.533503, 0.604152, 0.023691);
 cgNormal3f(-0.858887, 0.279297, 0.429199);
 cgVertex3f(-0.553640, 0.566246, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.370117, -0.423828, 0.826660);
 cgVertex3f(-0.556009, 0.456082, 0.035537);
 cgNormal3f(-0.320801, 0.099121, 0.941895);
 cgVertex3f(-0.542979, 0.552031, 0.035537);
 cgNormal3f(-0.858887, 0.279297, 0.429199);
 cgVertex3f(-0.553640, 0.566246, 0.023691);
 cgNormal3f(-0.859375, -0.358887, 0.364258);
 cgVertex3f(-0.570224, 0.458451, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.401855, -0.217773, 0.889160);
 cgVertex3f(-0.508627, 0.548478, 0.035537);
 cgNormal3f(0.302734, -0.540039, 0.784668);
 cgVertex3f(-0.525211, 0.452528, 0.035537);
 cgNormal3f(0.745117, -0.599121, 0.292480);
 cgVertex3f(-0.515734, 0.451344, 0.023691);
 cgNormal3f(0.856934, -0.421875, 0.295410);
 cgVertex3f(-0.499150, 0.544924, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.206543, -0.366699, 0.906738);
 cgVertex3f(-0.476644, 0.576907, 0.035537);
 cgNormal3f(0.401855, -0.217773, 0.889160);
 cgVertex3f(-0.508627, 0.548478, 0.035537);
 cgNormal3f(0.856934, -0.421875, 0.295410);
 cgVertex3f(-0.499150, 0.544924, 0.023691);
 cgNormal3f(0.463379, -0.819824, 0.336426);
 cgVertex3f(-0.484935, 0.562693, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.002441, -0.343750, 0.938965);
 cgVertex3f(-0.451768, 0.580461, 0.035537);
 cgNormal3f(0.206543, -0.366699, 0.906738);
 cgVertex3f(-0.476644, 0.576907, 0.035537);
 cgNormal3f(0.463379, -0.819824, 0.336426);
 cgVertex3f(-0.484935, 0.562693, 0.023691);
 cgNormal3f(-0.007324, -0.907227, 0.421387);
 cgVertex3f(-0.458875, 0.566246, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.094238, -0.309570, 0.945801);
 cgVertex3f(-0.404385, 0.573354, 0.035537);
 cgNormal3f(-0.002441, -0.343750, 0.938965);
 cgVertex3f(-0.451768, 0.580461, 0.035537);
 cgNormal3f(-0.007324, -0.907227, 0.421387);
 cgVertex3f(-0.458875, 0.566246, 0.023691);
 cgNormal3f(-0.255371, -0.860840, 0.440918);
 cgVertex3f(-0.412677, 0.559139, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.061523, -0.436523, 0.897461);
 cgVertex3f(-0.365295, 0.555585, 0.035537);
 cgNormal3f(-0.094238, -0.309570, 0.945801);
 cgVertex3f(-0.404385, 0.573354, 0.035537);
 cgNormal3f(-0.255371, -0.860840, 0.440918);
 cgVertex3f(-0.412677, 0.559139, 0.023691);
 cgNormal3f(-0.127441, -0.892090, 0.434082);
 cgVertex3f(-0.372402, 0.541370, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.040527, -0.347656, 0.936523);
 cgVertex3f(-0.310805, 0.561508, 0.035537);
 cgNormal3f(-0.061523, -0.436523, 0.897461);
 cgVertex3f(-0.365295, 0.555585, 0.035537);
 cgNormal3f(-0.127441, -0.892090, 0.434082);
 cgVertex3f(-0.372402, 0.541370, 0.023691);
 cgNormal3f(-0.099121, -0.904297, 0.415527);
 cgVertex3f(-0.317912, 0.548478, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.069824, -0.437988, 0.895996);
 cgVertex3f(-0.259869, 0.541370, 0.035537);
 cgNormal3f(-0.040527, -0.347656, 0.936523);
 cgVertex3f(-0.310805, 0.561508, 0.035537);
 cgNormal3f(-0.099121, -0.904297, 0.415527);
 cgVertex3f(-0.317912, 0.548478, 0.023691);
 cgNormal3f(-0.137695, -0.892090, 0.430176);
 cgVertex3f(-0.261053, 0.528340, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.061523, -0.436523, 0.897461);
 cgVertex3f(-0.365295, 0.555585, 0.035537);
 cgNormal3f(-0.040527, -0.347656, 0.936523);
 cgVertex3f(-0.310805, 0.561508, 0.035537);
 cgNormal3f(0.032715, 0.317871, 0.947266);
 cgVertex3f(-0.358187, 0.611260, 0.035537);
 cgNormal3f(-0.094238, -0.309570, 0.945801);
 cgVertex3f(-0.404385, 0.573354, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.094238, -0.309570, 0.945801);
 cgVertex3f(-0.404385, 0.573354, 0.035537);
 cgNormal3f(0.032715, 0.317871, 0.947266);
 cgVertex3f(-0.358187, 0.611260, 0.035537);
 cgNormal3f(-0.008301, 0.368164, 0.929199);
 cgVertex3f(-0.432815, 0.614813, 0.035537);
 cgNormal3f(-0.002441, -0.343750, 0.938965);
 cgVertex3f(-0.451768, 0.580461, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.002441, -0.343750, 0.938965);
 cgVertex3f(-0.451768, 0.580461, 0.035537);
 cgNormal3f(-0.008301, 0.368164, 0.929199);
 cgVertex3f(-0.432815, 0.614813, 0.035537);
 cgNormal3f(-0.093262, 0.310059, 0.945801);
 cgVertex3f(-0.492043, 0.607706, 0.035537);
 cgNormal3f(0.206543, -0.366699, 0.906738);
 cgVertex3f(-0.476644, 0.576907, 0.035537);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.206543, -0.366699, 0.906738);
 cgVertex3f(-0.476644, 0.576907, 0.035537);
 cgNormal3f(-0.093262, 0.310059, 0.945801);
 cgVertex3f(-0.492043, 0.607706, 0.035537);
 cgNormal3f(-0.291016, 0.285156, 0.913086);
 cgVertex3f(-0.524026, 0.591122, 0.035537);
 cgNormal3f(-0.320801, 0.099121, 0.941895);
 cgVertex3f(-0.542979, 0.552031, 0.035537);
 cgNormal3f(0.401855, -0.217773, 0.889160);
 cgVertex3f(-0.508627, 0.548478, 0.035537);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.956055, -0.293945, 0.000000);
 cgVertex3f(-0.570224, 0.458451, 0.004738);
 cgNormal3f(-0.859375, -0.358887, 0.364258);
 cgVertex3f(-0.570224, 0.458451, 0.023691);
 cgNormal3f(-0.858887, 0.279297, 0.429199);
 cgVertex3f(-0.553640, 0.566246, 0.023691);
 cgNormal3f(-0.666016, 0.222656, 0.711914);
 cgVertex3f(-0.553640, 0.566246, 0.004738);
 cgNormal3f(-0.911621, -0.187500, 0.366699);
 cgVertex3f(-0.564301, 0.489250, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.858887, 0.279297, 0.429199);
 cgVertex3f(-0.553640, 0.566246, 0.023691);
 cgNormal3f(-0.628418, 0.626953, 0.460449);
 cgVertex3f(-0.533503, 0.604152, 0.023691);
 cgNormal3f(-0.485840, 0.490234, 0.723145);
 cgVertex3f(-0.533503, 0.604152, 0.004738);
 cgNormal3f(-0.666016, 0.222656, 0.711914);
 cgVertex3f(-0.553640, 0.566246, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.628418, 0.626953, 0.460449);
 cgVertex3f(-0.533503, 0.604152, 0.023691);
 cgNormal3f(-0.262207, 0.857910, 0.440918);
 cgVertex3f(-0.501519, 0.620736, 0.023691);
 cgNormal3f(-0.206543, 0.669922, 0.712402);
 cgVertex3f(-0.501519, 0.620736, 0.004738);
 cgNormal3f(-0.485840, 0.490234, 0.723145);
 cgVertex3f(-0.533503, 0.604152, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.262207, 0.857910, 0.440918);
 cgVertex3f(-0.501519, 0.620736, 0.023691);
 cgNormal3f(-0.019043, 0.917480, 0.395996);
 cgVertex3f(-0.442291, 0.627843, 0.023691);
 cgNormal3f(-0.014160, 0.705078, 0.708496);
 cgVertex3f(-0.442291, 0.627843, 0.004738);
 cgNormal3f(-0.206543, 0.669922, 0.712402);
 cgVertex3f(-0.501519, 0.620736, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.019043, 0.917480, 0.395996);
 cgVertex3f(-0.442291, 0.627843, 0.023691);
 cgNormal3f(0.098145, 0.923340, 0.370605);
 cgVertex3f(-0.368848, 0.621921, 0.023691);
 cgNormal3f(0.075684, 0.697266, 0.712402);
 cgVertex3f(-0.368848, 0.621921, 0.004738);
 cgNormal3f(-0.014160, 0.705078, 0.708496);
 cgVertex3f(-0.442291, 0.627843, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.023438, 0.714844, 0.698730);
 cgVertex3f(-0.443476, 0.632582, 0.004738);
 cgNormal3f(-0.225098, 0.688477, 0.688965);
 cgVertex3f(-0.502704, 0.625474, 0.004738);
 cgNormal3f(-0.206543, 0.669922, 0.712402);
 cgVertex3f(-0.501519, 0.620736, 0.004738);
 cgNormal3f(-0.014160, 0.705078, 0.708496);
 cgVertex3f(-0.442291, 0.627843, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.514160, 0.500000, 0.696777);
 cgVertex3f(-0.539425, 0.604152, 0.004738);
 cgNormal3f(-0.666016, 0.222168, 0.711914);
 cgVertex3f(-0.558378, 0.568615, 0.004738);
 cgNormal3f(-0.666016, 0.222656, 0.711914);
 cgVertex3f(-0.553640, 0.566246, 0.004738);
 cgNormal3f(-0.485840, 0.490234, 0.723145);
 cgVertex3f(-0.533503, 0.604152, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.014160, 0.705078, 0.708496);
 cgVertex3f(-0.442291, 0.627843, 0.004738);
 cgNormal3f(0.075684, 0.697266, 0.712402);
 cgVertex3f(-0.368848, 0.621921, 0.004738);
 cgNormal3f(0.069336, 0.712891, 0.697266);
 cgVertex3f(-0.367664, 0.629028, 0.004738);
 cgNormal3f(-0.023438, 0.714844, 0.698730);
 cgVertex3f(-0.443476, 0.632582, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.067383, 0.693359, -0.717285);
 cgVertex3f(-0.367664, 0.629028, -0.005923);
 cgNormal3f(-0.022949, 0.695312, -0.718262);
 cgVertex3f(-0.443476, 0.632582, -0.005923);
 cgNormal3f(-0.023438, 0.714844, 0.698730);
 cgVertex3f(-0.443476, 0.632582, 0.004738);
 cgNormal3f(0.069336, 0.712891, 0.697266);
 cgVertex3f(-0.367664, 0.629028, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.208984, 0.639648, -0.739746);
 cgVertex3f(-0.502704, 0.625474, -0.005923);
 cgNormal3f(-0.477051, 0.463867, -0.746582);
 cgVertex3f(-0.539425, 0.604152, -0.005923);
 cgNormal3f(-0.514160, 0.500000, 0.696777);
 cgVertex3f(-0.539425, 0.604152, 0.004738);
 cgNormal3f(-0.225098, 0.688477, 0.688965);
 cgVertex3f(-0.502704, 0.625474, 0.004738);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.775879, -0.363281, 0.516113);
 cgVertex3f(-0.570224, 0.492803, 0.004738);
 cgNormal3f(-0.666016, 0.222168, 0.711914);
 cgVertex3f(-0.558378, 0.568615, 0.004738);
 cgNormal3f(-0.666016, 0.222168, -0.712402);
 cgVertex3f(-0.558378, 0.568615, -0.005923);
 cgNormal3f(-0.775879, -0.363281, -0.516602);
 cgVertex3f(-0.570224, 0.492803, -0.005923);
 cgNormal3f(-0.791016, -0.612305, 0.000000);
 cgVertex3f(-0.570224, 0.492803, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.666016, 0.222656, 0.711914);
 cgVertex3f(-0.553640, 0.566246, 0.004738);
 cgNormal3f(-0.666016, 0.222168, 0.711914);
 cgVertex3f(-0.558378, 0.568615, 0.004738);
 cgNormal3f(-0.775879, -0.363281, 0.516113);
 cgVertex3f(-0.570224, 0.492803, 0.004738);
 cgNormal3f(-0.911621, -0.187500, 0.366699);
 cgVertex3f(-0.564301, 0.489250, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.775879, -0.363281, 0.516113);
 cgVertex3f(-0.570224, 0.492803, 0.004738);
 cgNormal3f(-0.791016, -0.612305, 0.000000);
 cgVertex3f(-0.570224, 0.492803, 0.000000);
 cgNormal3f(-0.913086, -0.408203, 0.000000);
 cgVertex3f(-0.564301, 0.489250, 0.000000);
 cgNormal3f(-0.911621, -0.187500, 0.366699);
 cgVertex3f(-0.564301, 0.489250, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.791016, -0.612305, 0.000000);
 cgVertex3f(-0.570224, 0.492803, 0.000000);
 cgNormal3f(-0.775879, -0.363281, -0.516602);
 cgVertex3f(-0.570224, 0.492803, -0.005923);
 cgNormal3f(-0.911621, -0.187500, -0.367188);
 cgVertex3f(-0.564301, 0.489250, -0.005923);
 cgNormal3f(-0.913086, -0.408203, 0.000000);
 cgVertex3f(-0.564301, 0.489250, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.666016, 0.222168, -0.712402);
 cgVertex3f(-0.558378, 0.568615, -0.005923);
 cgNormal3f(-0.666016, 0.222656, -0.711914);
 cgVertex3f(-0.553640, 0.566246, -0.005923);
 cgNormal3f(-0.911621, -0.187500, -0.367188);
 cgVertex3f(-0.564301, 0.489250, -0.005923);
 cgNormal3f(-0.775879, -0.363281, -0.516602);
 cgVertex3f(-0.570224, 0.492803, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.077148, 0.708008, -0.702148);
 cgVertex3f(-0.368848, 0.621921, -0.005923);
 cgNormal3f(-0.014160, 0.705078, -0.708984);
 cgVertex3f(-0.442291, 0.627843, -0.005923);
 cgNormal3f(-0.022949, 0.695312, -0.718262);
 cgVertex3f(-0.443476, 0.632582, -0.005923);
 cgNormal3f(0.067383, 0.693359, -0.717285);
 cgVertex3f(-0.367664, 0.629028, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.666016, 0.222168, -0.712402);
 cgVertex3f(-0.558378, 0.568615, -0.005923);
 cgNormal3f(-0.477051, 0.463867, -0.746582);
 cgVertex3f(-0.539425, 0.604152, -0.005923);
 cgNormal3f(-0.485840, 0.490234, -0.723633);
 cgVertex3f(-0.533503, 0.604152, -0.005923);
 cgNormal3f(-0.666016, 0.222656, -0.711914);
 cgVertex3f(-0.553640, 0.566246, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.208984, 0.639648, -0.739746);
 cgVertex3f(-0.502704, 0.625474, -0.005923);
 cgNormal3f(-0.022949, 0.695312, -0.718262);
 cgVertex3f(-0.443476, 0.632582, -0.005923);
 cgNormal3f(-0.014160, 0.705078, -0.708984);
 cgVertex3f(-0.442291, 0.627843, -0.005923);
 cgNormal3f(-0.206543, 0.669922, -0.712891);
 cgVertex3f(-0.501519, 0.620736, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.100586, 0.933594, -0.343262);
 cgVertex3f(-0.368848, 0.621921, -0.024876);
 cgNormal3f(-0.015625, 0.922852, -0.384277);
 cgVertex3f(-0.442291, 0.627843, -0.024876);
 cgNormal3f(-0.014160, 0.705078, -0.708984);
 cgVertex3f(-0.442291, 0.627843, -0.005923);
 cgNormal3f(0.077148, 0.708008, -0.702148);
 cgVertex3f(-0.368848, 0.621921, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.015625, 0.922852, -0.384277);
 cgVertex3f(-0.442291, 0.627843, -0.024876);
 cgNormal3f(-0.259277, 0.863770, -0.431641);
 cgVertex3f(-0.501519, 0.620736, -0.024876);
 cgNormal3f(-0.206543, 0.669922, -0.712891);
 cgVertex3f(-0.501519, 0.620736, -0.005923);
 cgNormal3f(-0.014160, 0.705078, -0.708984);
 cgVertex3f(-0.442291, 0.627843, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.259277, 0.863770, -0.431641);
 cgVertex3f(-0.501519, 0.620736, -0.024876);
 cgNormal3f(-0.626953, 0.631348, -0.457031);
 cgVertex3f(-0.533503, 0.604152, -0.024876);
 cgNormal3f(-0.485840, 0.490234, -0.723633);
 cgVertex3f(-0.533503, 0.604152, -0.005923);
 cgNormal3f(-0.206543, 0.669922, -0.712891);
 cgVertex3f(-0.501519, 0.620736, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.626953, 0.631348, -0.457031);
 cgVertex3f(-0.533503, 0.604152, -0.024876);
 cgNormal3f(-0.858887, 0.279297, -0.429688);
 cgVertex3f(-0.553640, 0.566246, -0.024876);
 cgNormal3f(-0.666016, 0.222656, -0.711914);
 cgVertex3f(-0.553640, 0.566246, -0.005923);
 cgNormal3f(-0.485840, 0.490234, -0.723633);
 cgVertex3f(-0.533503, 0.604152, -0.005923);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.666016, 0.222656, -0.711914);
 cgVertex3f(-0.553640, 0.566246, -0.005923);
 cgNormal3f(-0.858887, 0.279297, -0.429688);
 cgVertex3f(-0.553640, 0.566246, -0.024876);
 cgNormal3f(-0.859375, -0.358887, -0.364746);
 cgVertex3f(-0.570224, 0.458451, -0.024876);
 cgNormal3f(-0.956055, -0.293945, 0.000000);
 cgVertex3f(-0.570224, 0.458451, -0.005923);
 cgNormal3f(-0.911621, -0.187500, -0.367188);
 cgVertex3f(-0.564301, 0.489250, -0.005923);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.291016, 0.291504, -0.911621);
 cgVertex3f(-0.524026, 0.591122, -0.036721);
 cgNormal3f(-0.092285, 0.320801, -0.942871);
 cgVertex3f(-0.492043, 0.607706, -0.036721);
 cgNormal3f(0.198730, -0.354004, -0.914062);
 cgVertex3f(-0.476644, 0.576907, -0.036721);
 cgNormal3f(0.382812, -0.206543, -0.900879);
 cgVertex3f(-0.508627, 0.548478, -0.036721);
 cgNormal3f(-0.320801, 0.099121, -0.942383);
 cgVertex3f(-0.542979, 0.552031, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.005371, 0.380859, -0.924805);
 cgVertex3f(-0.432815, 0.614813, -0.036721);
 cgNormal3f(0.010254, -0.348145, -0.937500);
 cgVertex3f(-0.451768, 0.580461, -0.036721);
 cgNormal3f(0.198730, -0.354004, -0.914062);
 cgVertex3f(-0.476644, 0.576907, -0.036721);
 cgNormal3f(-0.092285, 0.320801, -0.942871);
 cgVertex3f(-0.492043, 0.607706, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.034668, 0.328125, -0.943848);
 cgVertex3f(-0.358187, 0.611260, -0.036721);
 cgNormal3f(-0.087402, -0.308594, -0.947266);
 cgVertex3f(-0.404385, 0.573354, -0.036721);
 cgNormal3f(0.010254, -0.348145, -0.937500);
 cgVertex3f(-0.451768, 0.580461, -0.036721);
 cgNormal3f(-0.005371, 0.380859, -0.924805);
 cgVertex3f(-0.432815, 0.614813, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.040527, -0.347656, -0.937012);
 cgVertex3f(-0.310805, 0.561508, -0.036721);
 cgNormal3f(-0.057129, -0.432617, -0.899902);
 cgVertex3f(-0.365295, 0.555585, -0.036721);
 cgNormal3f(-0.087402, -0.308594, -0.947266);
 cgVertex3f(-0.404385, 0.573354, -0.036721);
 cgNormal3f(0.034668, 0.328125, -0.943848);
 cgVertex3f(-0.358187, 0.611260, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.040527, -0.347656, -0.937012);
 cgVertex3f(-0.310805, 0.561508, -0.036721);
 cgNormal3f(-0.069824, -0.450195, -0.890625);
 cgVertex3f(-0.259869, 0.541370, -0.036721);
 cgNormal3f(-0.136719, -0.896484, -0.421875);
 cgVertex3f(-0.261053, 0.528340, -0.024876);
 cgNormal3f(-0.099121, -0.904297, -0.416016);
 cgVertex3f(-0.317912, 0.548478, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.057129, -0.432617, -0.899902);
 cgVertex3f(-0.365295, 0.555585, -0.036721);
 cgNormal3f(-0.040527, -0.347656, -0.937012);
 cgVertex3f(-0.310805, 0.561508, -0.036721);
 cgNormal3f(-0.099121, -0.904297, -0.416016);
 cgVertex3f(-0.317912, 0.548478, -0.024876);
 cgNormal3f(-0.124023, -0.890625, -0.437988);
 cgVertex3f(-0.372402, 0.541370, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.087402, -0.308594, -0.947266);
 cgVertex3f(-0.404385, 0.573354, -0.036721);
 cgNormal3f(-0.057129, -0.432617, -0.899902);
 cgVertex3f(-0.365295, 0.555585, -0.036721);
 cgNormal3f(-0.124023, -0.890625, -0.437988);
 cgVertex3f(-0.372402, 0.541370, -0.024876);
 cgNormal3f(-0.248535, -0.861328, -0.443848);
 cgVertex3f(-0.412677, 0.559139, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.010254, -0.348145, -0.937500);
 cgVertex3f(-0.451768, 0.580461, -0.036721);
 cgNormal3f(-0.087402, -0.308594, -0.947266);
 cgVertex3f(-0.404385, 0.573354, -0.036721);
 cgNormal3f(-0.248535, -0.861328, -0.443848);
 cgVertex3f(-0.412677, 0.559139, -0.024876);
 cgNormal3f(0.005859, -0.909180, -0.416992);
 cgVertex3f(-0.458875, 0.566246, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.198730, -0.354004, -0.914062);
 cgVertex3f(-0.476644, 0.576907, -0.036721);
 cgNormal3f(0.010254, -0.348145, -0.937500);
 cgVertex3f(-0.451768, 0.580461, -0.036721);
 cgNormal3f(0.005859, -0.909180, -0.416992);
 cgVertex3f(-0.458875, 0.566246, -0.024876);
 cgNormal3f(0.458496, -0.812988, -0.359863);
 cgVertex3f(-0.484935, 0.562693, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.850098, -0.416504, -0.321777);
 cgVertex3f(-0.499150, 0.544924, -0.024876);
 cgNormal3f(0.382812, -0.206543, -0.900879);
 cgVertex3f(-0.508627, 0.548478, -0.036721);
 cgNormal3f(0.198730, -0.354004, -0.914062);
 cgVertex3f(-0.476644, 0.576907, -0.036721);
 cgNormal3f(0.458496, -0.812988, -0.359863);
 cgVertex3f(-0.484935, 0.562693, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.304688, -0.540527, -0.784180);
 cgVertex3f(-0.525211, 0.452528, -0.036721);
 cgNormal3f(0.382812, -0.206543, -0.900879);
 cgVertex3f(-0.508627, 0.548478, -0.036721);
 cgNormal3f(0.850098, -0.416504, -0.321777);
 cgVertex3f(-0.499150, 0.544924, -0.024876);
 cgNormal3f(0.746094, -0.598633, -0.291016);
 cgVertex3f(-0.515734, 0.451344, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.320801, 0.099121, -0.942383);
 cgVertex3f(-0.542979, 0.552031, -0.036721);
 cgNormal3f(-0.370117, -0.423828, -0.827148);
 cgVertex3f(-0.556009, 0.456082, -0.036721);
 cgNormal3f(-0.859375, -0.358887, -0.364746);
 cgVertex3f(-0.570224, 0.458451, -0.024876);
 cgNormal3f(-0.858887, 0.279297, -0.429688);
 cgVertex3f(-0.553640, 0.566246, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.291016, 0.291504, -0.911621);
 cgVertex3f(-0.524026, 0.591122, -0.036721);
 cgNormal3f(-0.320801, 0.099121, -0.942383);
 cgVertex3f(-0.542979, 0.552031, -0.036721);
 cgNormal3f(-0.858887, 0.279297, -0.429688);
 cgVertex3f(-0.553640, 0.566246, -0.024876);
 cgNormal3f(-0.626953, 0.631348, -0.457031);
 cgVertex3f(-0.533503, 0.604152, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.092285, 0.320801, -0.942871);
 cgVertex3f(-0.492043, 0.607706, -0.036721);
 cgNormal3f(-0.291016, 0.291504, -0.911621);
 cgVertex3f(-0.524026, 0.591122, -0.036721);
 cgNormal3f(-0.626953, 0.631348, -0.457031);
 cgVertex3f(-0.533503, 0.604152, -0.024876);
 cgNormal3f(-0.259277, 0.863770, -0.431641);
 cgVertex3f(-0.501519, 0.620736, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.005371, 0.380859, -0.924805);
 cgVertex3f(-0.432815, 0.614813, -0.036721);
 cgNormal3f(-0.092285, 0.320801, -0.942871);
 cgVertex3f(-0.492043, 0.607706, -0.036721);
 cgNormal3f(-0.259277, 0.863770, -0.431641);
 cgVertex3f(-0.501519, 0.620736, -0.024876);
 cgNormal3f(-0.015625, 0.922852, -0.384277);
 cgVertex3f(-0.442291, 0.627843, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.034668, 0.328125, -0.943848);
 cgVertex3f(-0.358187, 0.611260, -0.036721);
 cgNormal3f(-0.005371, 0.380859, -0.924805);
 cgVertex3f(-0.432815, 0.614813, -0.036721);
 cgNormal3f(-0.015625, 0.922852, -0.384277);
 cgVertex3f(-0.442291, 0.627843, -0.024876);
 cgNormal3f(0.100586, 0.933594, -0.343262);
 cgVertex3f(-0.368848, 0.621921, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.206543, 0.669922, -0.712891);
 cgVertex3f(-0.501519, 0.620736, -0.005923);
 cgNormal3f(-0.485840, 0.490234, -0.723633);
 cgVertex3f(-0.533503, 0.604152, -0.005923);
 cgNormal3f(-0.477051, 0.463867, -0.746582);
 cgVertex3f(-0.539425, 0.604152, -0.005923);
 cgNormal3f(-0.208984, 0.639648, -0.739746);
 cgVertex3f(-0.502704, 0.625474, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.956055, -0.293945, 0.000000);
 cgVertex3f(-0.570224, 0.458451, -0.005923);
 cgNormal3f(-0.959961, -0.281738, 0.000000);
 cgVertex3f(-0.570224, 0.458451, 0.000000);
 cgNormal3f(-0.913086, -0.408203, 0.000000);
 cgVertex3f(-0.564301, 0.489250, 0.000000);
 cgNormal3f(-0.911621, -0.187500, -0.367188);
 cgVertex3f(-0.564301, 0.489250, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.304688, -0.540527, -0.784180);
 cgVertex3f(-0.525211, 0.452528, -0.036721);
 cgNormal3f(-0.370117, -0.423828, -0.827148);
 cgVertex3f(-0.556009, 0.456082, -0.036721);
 cgNormal3f(-0.320801, 0.099121, -0.942383);
 cgVertex3f(-0.542979, 0.552031, -0.036721);
 cgNormal3f(0.382812, -0.206543, -0.900879);
 cgVertex3f(-0.508627, 0.548478, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.256348, -0.511230, -0.820801);
 cgVertex3f(0.001920, 0.377901, -0.036721);
 cgNormal3f(-0.437012, -0.438477, -0.785645);
 cgVertex3f(-0.028879, 0.382639, -0.036721);
 cgNormal3f(-0.450684, -0.101562, -0.887207);
 cgVertex3f(-0.018218, 0.479773, -0.036721);
 cgNormal3f(0.342285, 0.006348, -0.939941);
 cgVertex3f(0.016134, 0.475035, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.833496, -0.552246, 0.000000);
 cgVertex3f(0.016134, 0.376716, 0.000000);
 cgNormal3f(0.833496, -0.552734, 0.000000);
 cgVertex3f(0.016134, 0.376716, -0.005923);
 cgNormal3f(0.828613, -0.427734, -0.360352);
 cgVertex3f(0.019688, 0.406330, -0.005923);
 cgNormal3f(0.774414, -0.632324, 0.000000);
 cgVertex3f(0.019688, 0.406330, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.604004, 0.341309, -0.719727);
 cgVertex3f(0.022057, 0.524787, -0.005923);
 cgNormal3f(0.378906, 0.606934, -0.698242);
 cgVertex3f(-0.005188, 0.548478, -0.005923);
 cgNormal3f(0.383301, 0.587891, -0.712402);
 cgVertex3f(-0.002819, 0.555585, -0.005923);
 cgNormal3f(0.600586, 0.336914, -0.724609);
 cgVertex3f(0.027980, 0.527156, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.118164, 0.360840, -0.925293);
 cgVertex3f(-0.072708, 0.565062, -0.036721);
 cgNormal3f(0.056641, 0.316895, -0.946777);
 cgVertex3f(-0.144966, 0.580461, -0.036721);
 cgNormal3f(0.165039, 0.923340, -0.346680);
 cgVertex3f(-0.131936, 0.589937, -0.024876);
 cgNormal3f(0.285156, 0.883301, -0.371582);
 cgVertex3f(-0.059678, 0.573354, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.188477, 0.296875, -0.936035);
 cgVertex3f(-0.018218, 0.541370, -0.036721);
 cgNormal3f(0.118164, 0.360840, -0.925293);
 cgVertex3f(-0.072708, 0.565062, -0.036721);
 cgNormal3f(0.285156, 0.883301, -0.371582);
 cgVertex3f(-0.059678, 0.573354, -0.024876);
 cgNormal3f(0.488770, 0.777344, -0.395996);
 cgVertex3f(-0.005188, 0.548478, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.367188, 0.208984, -0.906738);
 cgVertex3f(0.007842, 0.517679, -0.036721);
 cgNormal3f(0.188477, 0.296875, -0.936035);
 cgVertex3f(-0.018218, 0.541370, -0.036721);
 cgNormal3f(0.488770, 0.777344, -0.395996);
 cgVertex3f(-0.005188, 0.548478, -0.024876);
 cgNormal3f(0.780762, 0.442871, -0.440430);
 cgVertex3f(0.022057, 0.524787, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.342285, 0.006348, -0.939941);
 cgVertex3f(0.016134, 0.475035, -0.036721);
 cgNormal3f(0.367188, 0.208984, -0.906738);
 cgVertex3f(0.007842, 0.517679, -0.036721);
 cgNormal3f(0.780762, 0.442871, -0.440430);
 cgVertex3f(0.022057, 0.524787, -0.024876);
 cgNormal3f(0.905762, 0.021484, -0.422363);
 cgVertex3f(0.029165, 0.484511, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.256348, -0.511230, -0.820801);
 cgVertex3f(0.001920, 0.377901, -0.036721);
 cgNormal3f(0.342285, 0.006348, -0.939941);
 cgVertex3f(0.016134, 0.475035, -0.036721);
 cgNormal3f(0.905762, 0.021484, -0.422363);
 cgVertex3f(0.029165, 0.484511, -0.024876);
 cgNormal3f(0.736816, -0.576660, -0.353516);
 cgVertex3f(0.016134, 0.376716, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.450684, -0.101562, -0.887207);
 cgVertex3f(-0.018218, 0.479773, -0.036721);
 cgNormal3f(-0.437012, -0.438477, -0.785645);
 cgVertex3f(-0.028879, 0.382639, -0.036721);
 cgNormal3f(-0.882812, -0.370117, -0.291016);
 cgVertex3f(-0.038355, 0.383824, -0.024876);
 cgNormal3f(-0.939941, -0.181152, -0.291016);
 cgVertex3f(-0.027694, 0.479773, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.312012, -0.302734, -0.900879);
 cgVertex3f(-0.040725, 0.514125, -0.036721);
 cgNormal3f(-0.450684, -0.101562, -0.887207);
 cgVertex3f(-0.018218, 0.479773, -0.036721);
 cgNormal3f(-0.939941, -0.181152, -0.291016);
 cgVertex3f(-0.027694, 0.479773, -0.024876);
 cgNormal3f(-0.678711, -0.660645, -0.321777);
 cgVertex3f(-0.037171, 0.499911, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.105469, -0.333984, -0.937012);
 cgVertex3f(-0.064416, 0.527156, -0.036721);
 cgNormal3f(-0.312012, -0.302734, -0.900879);
 cgVertex3f(-0.040725, 0.514125, -0.036721);
 cgNormal3f(-0.678711, -0.660645, -0.321777);
 cgVertex3f(-0.037171, 0.499911, -0.024876);
 cgNormal3f(-0.274902, -0.867676, -0.415039);
 cgVertex3f(-0.060862, 0.510572, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.005371, -0.330078, -0.944336);
 cgVertex3f(-0.110614, 0.531894, -0.036721);
 cgNormal3f(-0.105469, -0.333984, -0.937012);
 cgVertex3f(-0.064416, 0.527156, -0.036721);
 cgNormal3f(-0.274902, -0.867676, -0.415039);
 cgVertex3f(-0.060862, 0.510572, -0.024876);
 cgNormal3f(0.007812, -0.900391, -0.435547);
 cgVertex3f(-0.107060, 0.517679, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.059570, -0.463379, -0.884277);
 cgVertex3f(-0.154443, 0.524787, -0.036721);
 cgNormal3f(0.005371, -0.330078, -0.944336);
 cgVertex3f(-0.110614, 0.531894, -0.036721);
 cgNormal3f(0.007812, -0.900391, -0.435547);
 cgVertex3f(-0.107060, 0.517679, -0.024876);
 cgNormal3f(-0.110840, -0.903809, -0.414062);
 cgVertex3f(-0.150889, 0.510572, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.062988, -0.358398, -0.931641);
 cgVertex3f(-0.206563, 0.544924, -0.036721);
 cgNormal3f(-0.059570, -0.463379, -0.884277);
 cgVertex3f(-0.154443, 0.524787, -0.036721);
 cgNormal3f(-0.110840, -0.903809, -0.414062);
 cgVertex3f(-0.150889, 0.510572, -0.024876);
 cgNormal3f(-0.160645, -0.901855, -0.401855);
 cgVertex3f(-0.203010, 0.531894, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.069824, -0.450195, -0.890625);
 cgVertex3f(-0.259869, 0.541370, -0.036721);
 cgNormal3f(-0.062988, -0.358398, -0.931641);
 cgVertex3f(-0.206563, 0.544924, -0.036721);
 cgNormal3f(-0.160645, -0.901855, -0.401855);
 cgVertex3f(-0.203010, 0.531894, -0.024876);
 cgNormal3f(-0.136719, -0.896484, -0.421875);
 cgVertex3f(-0.261053, 0.528340, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.056641, 0.316895, -0.946777);
 cgVertex3f(-0.144966, 0.580461, -0.036721);
 cgNormal3f(0.034668, 0.328125, -0.943848);
 cgVertex3f(-0.358187, 0.611260, -0.036721);
 cgNormal3f(0.100586, 0.933594, -0.343262);
 cgVertex3f(-0.368848, 0.621921, -0.024876);
 cgNormal3f(0.165039, 0.923340, -0.346680);
 cgVertex3f(-0.131936, 0.589937, -0.024876);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.059570, -0.463379, -0.884277);
 cgVertex3f(-0.154443, 0.524787, -0.036721);
 cgNormal3f(-0.062988, -0.358398, -0.931641);
 cgVertex3f(-0.206563, 0.544924, -0.036721);
 cgNormal3f(0.056641, 0.316895, -0.946777);
 cgVertex3f(-0.144966, 0.580461, -0.036721);
 cgNormal3f(0.005371, -0.330078, -0.944336);
 cgVertex3f(-0.110614, 0.531894, -0.036721);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.069824, -0.450195, -0.890625);
 cgVertex3f(-0.259869, 0.541370, -0.036721);
 cgNormal3f(-0.040527, -0.347656, -0.937012);
 cgVertex3f(-0.310805, 0.561508, -0.036721);
 cgNormal3f(0.034668, 0.328125, -0.943848);
 cgVertex3f(-0.358187, 0.611260, -0.036721);
 cgNormal3f(0.056641, 0.316895, -0.946777);
 cgVertex3f(-0.144966, 0.580461, -0.036721);
 cgNormal3f(-0.062988, -0.358398, -0.931641);
 cgVertex3f(-0.206563, 0.544924, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.005371, -0.330078, -0.944336);
 cgVertex3f(-0.110614, 0.531894, -0.036721);
 cgNormal3f(0.056641, 0.316895, -0.946777);
 cgVertex3f(-0.144966, 0.580461, -0.036721);
 cgNormal3f(0.118164, 0.360840, -0.925293);
 cgVertex3f(-0.072708, 0.565062, -0.036721);
 cgNormal3f(-0.105469, -0.333984, -0.937012);
 cgVertex3f(-0.064416, 0.527156, -0.036721);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.105469, -0.333984, -0.937012);
 cgVertex3f(-0.064416, 0.527156, -0.036721);
 cgNormal3f(0.118164, 0.360840, -0.925293);
 cgVertex3f(-0.072708, 0.565062, -0.036721);
 cgNormal3f(0.188477, 0.296875, -0.936035);
 cgVertex3f(-0.018218, 0.541370, -0.036721);
 cgNormal3f(-0.312012, -0.302734, -0.900879);
 cgVertex3f(-0.040725, 0.514125, -0.036721);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.312012, -0.302734, -0.900879);
 cgVertex3f(-0.040725, 0.514125, -0.036721);
 cgNormal3f(0.188477, 0.296875, -0.936035);
 cgVertex3f(-0.018218, 0.541370, -0.036721);
 cgNormal3f(0.367188, 0.208984, -0.906738);
 cgVertex3f(0.007842, 0.517679, -0.036721);
 cgNormal3f(0.342285, 0.006348, -0.939941);
 cgVertex3f(0.016134, 0.475035, -0.036721);
 cgNormal3f(-0.450684, -0.101562, -0.887207);
 cgVertex3f(-0.018218, 0.479773, -0.036721);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.833496, -0.552734, 0.000000);
 cgVertex3f(0.016134, 0.376716, -0.005923);
 cgNormal3f(0.736816, -0.576660, -0.353516);
 cgVertex3f(0.016134, 0.376716, -0.024876);
 cgNormal3f(0.905762, 0.021484, -0.422363);
 cgVertex3f(0.029165, 0.484511, -0.024876);
 cgNormal3f(0.702637, 0.019043, -0.710938);
 cgVertex3f(0.029165, 0.484511, -0.005923);
 cgNormal3f(0.828613, -0.427734, -0.360352);
 cgVertex3f(0.019688, 0.406330, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.905762, 0.021484, -0.422363);
 cgVertex3f(0.029165, 0.484511, -0.024876);
 cgNormal3f(0.780762, 0.442871, -0.440430);
 cgVertex3f(0.022057, 0.524787, -0.024876);
 cgNormal3f(0.604004, 0.341309, -0.719727);
 cgVertex3f(0.022057, 0.524787, -0.005923);
 cgNormal3f(0.702637, 0.019043, -0.710938);
 cgVertex3f(0.029165, 0.484511, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.780762, 0.442871, -0.440430);
 cgVertex3f(0.022057, 0.524787, -0.024876);
 cgNormal3f(0.488770, 0.777344, -0.395996);
 cgVertex3f(-0.005188, 0.548478, -0.024876);
 cgNormal3f(0.378906, 0.606934, -0.698242);
 cgVertex3f(-0.005188, 0.548478, -0.005923);
 cgNormal3f(0.604004, 0.341309, -0.719727);
 cgVertex3f(0.022057, 0.524787, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.488770, 0.777344, -0.395996);
 cgVertex3f(-0.005188, 0.548478, -0.024876);
 cgNormal3f(0.285156, 0.883301, -0.371582);
 cgVertex3f(-0.059678, 0.573354, -0.024876);
 cgNormal3f(0.217773, 0.681641, -0.698242);
 cgVertex3f(-0.059678, 0.573354, -0.005923);
 cgNormal3f(0.378906, 0.606934, -0.698242);
 cgVertex3f(-0.005188, 0.548478, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.285156, 0.883301, -0.371582);
 cgVertex3f(-0.059678, 0.573354, -0.024876);
 cgNormal3f(0.165039, 0.923340, -0.346680);
 cgVertex3f(-0.131936, 0.589937, -0.024876);
 cgNormal3f(0.126465, 0.706055, -0.696777);
 cgVertex3f(-0.131936, 0.589937, -0.005923);
 cgNormal3f(0.217773, 0.681641, -0.698242);
 cgVertex3f(-0.059678, 0.573354, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.165039, 0.923340, -0.346680);
 cgVertex3f(-0.131936, 0.589937, -0.024876);
 cgNormal3f(0.100586, 0.933594, -0.343262);
 cgVertex3f(-0.368848, 0.621921, -0.024876);
 cgNormal3f(0.077148, 0.708008, -0.702148);
 cgVertex3f(-0.368848, 0.621921, -0.005923);
 cgNormal3f(0.126465, 0.706055, -0.696777);
 cgVertex3f(-0.131936, 0.589937, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.067383, 0.693359, -0.717285);
 cgVertex3f(-0.367664, 0.629028, -0.005923);
 cgNormal3f(0.115234, 0.697266, -0.707520);
 cgVertex3f(-0.131936, 0.594676, -0.005923);
 cgNormal3f(0.126465, 0.706055, -0.696777);
 cgVertex3f(-0.131936, 0.589937, -0.005923);
 cgNormal3f(0.077148, 0.708008, -0.702148);
 cgVertex3f(-0.368848, 0.621921, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207520, 0.673340, -0.709473);
 cgVertex3f(-0.057308, 0.580461, -0.005923);
 cgNormal3f(0.383301, 0.587891, -0.712402);
 cgVertex3f(-0.002819, 0.555585, -0.005923);
 cgNormal3f(0.378906, 0.606934, -0.698242);
 cgVertex3f(-0.005188, 0.548478, -0.005923);
 cgNormal3f(0.217773, 0.681641, -0.698242);
 cgVertex3f(-0.059678, 0.573354, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.600586, 0.336914, -0.724609);
 cgVertex3f(0.027980, 0.527156, -0.005923);
 cgNormal3f(0.701660, 0.025879, -0.711914);
 cgVertex3f(0.036272, 0.485696, -0.005923);
 cgNormal3f(0.702637, 0.019043, -0.710938);
 cgVertex3f(0.029165, 0.484511, -0.005923);
 cgNormal3f(0.604004, 0.341309, -0.719727);
 cgVertex3f(0.022057, 0.524787, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.217773, 0.681641, -0.698242);
 cgVertex3f(-0.059678, 0.573354, -0.005923);
 cgNormal3f(0.126465, 0.706055, -0.696777);
 cgVertex3f(-0.131936, 0.589937, -0.005923);
 cgNormal3f(0.115234, 0.697266, -0.707520);
 cgVertex3f(-0.131936, 0.594676, -0.005923);
 cgNormal3f(0.207520, 0.673340, -0.709473);
 cgVertex3f(-0.057308, 0.580461, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.702637, 0.019043, -0.710938);
 cgVertex3f(0.029165, 0.484511, -0.005923);
 cgNormal3f(0.701660, 0.025879, -0.711914);
 cgVertex3f(0.036272, 0.485696, -0.005923);
 cgNormal3f(0.666016, -0.545410, -0.509277);
 cgVertex3f(0.026795, 0.408699, -0.005923);
 cgNormal3f(0.828613, -0.427734, -0.360352);
 cgVertex3f(0.019688, 0.406330, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.666016, -0.545410, -0.509277);
 cgVertex3f(0.026795, 0.408699, -0.005923);
 cgNormal3f(0.626465, -0.779297, 0.000000);
 cgVertex3f(0.026795, 0.408699, 0.000000);
 cgNormal3f(0.774414, -0.632324, 0.000000);
 cgVertex3f(0.019688, 0.406330, 0.000000);
 cgNormal3f(0.828613, -0.427734, -0.360352);
 cgVertex3f(0.019688, 0.406330, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.626465, -0.779297, 0.000000);
 cgVertex3f(0.026795, 0.408699, 0.000000);
 cgNormal3f(0.666016, -0.545410, 0.508789);
 cgVertex3f(0.026795, 0.408699, 0.004738);
 cgNormal3f(0.828613, -0.427734, 0.359863);
 cgVertex3f(0.019688, 0.406330, 0.004738);
 cgNormal3f(0.774414, -0.632324, 0.000000);
 cgVertex3f(0.019688, 0.406330, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.701660, 0.025879, 0.711426);
 cgVertex3f(0.036272, 0.485696, 0.004738);
 cgNormal3f(0.702637, 0.019043, 0.710938);
 cgVertex3f(0.029165, 0.484511, 0.004738);
 cgNormal3f(0.828613, -0.427734, 0.359863);
 cgVertex3f(0.019688, 0.406330, 0.004738);
 cgNormal3f(0.666016, -0.545410, 0.508789);
 cgVertex3f(0.026795, 0.408699, 0.004738);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.666016, -0.545410, -0.509277);
 cgVertex3f(0.026795, 0.408699, -0.005923);
 cgNormal3f(0.701660, 0.025879, -0.711914);
 cgVertex3f(0.036272, 0.485696, -0.005923);
 cgNormal3f(0.701660, 0.025879, 0.711426);
 cgVertex3f(0.036272, 0.485696, 0.004738);
 cgNormal3f(0.666016, -0.545410, 0.508789);
 cgVertex3f(0.026795, 0.408699, 0.004738);
 cgNormal3f(0.626465, -0.779297, 0.000000);
 cgVertex3f(0.026795, 0.408699, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.600586, 0.336914, -0.724609);
 cgVertex3f(0.027980, 0.527156, -0.005923);
 cgNormal3f(0.383301, 0.587891, -0.712402);
 cgVertex3f(-0.002819, 0.555585, -0.005923);
 cgNormal3f(0.383301, 0.587891, 0.711914);
 cgVertex3f(-0.002819, 0.555585, 0.004738);
 cgNormal3f(0.600586, 0.336914, 0.724121);
 cgVertex3f(0.027980, 0.527156, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207520, 0.673340, -0.709473);
 cgVertex3f(-0.057308, 0.580461, -0.005923);
 cgNormal3f(0.115234, 0.697266, -0.707520);
 cgVertex3f(-0.131936, 0.594676, -0.005923);
 cgNormal3f(0.115234, 0.697266, 0.707031);
 cgVertex3f(-0.131936, 0.594676, 0.004738);
 cgNormal3f(0.207520, 0.673340, 0.708984);
 cgVertex3f(-0.057308, 0.580461, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.125977, 0.689453, 0.712891);
 cgVertex3f(-0.131936, 0.589937, 0.004738);
 cgNormal3f(0.227539, 0.661621, 0.713867);
 cgVertex3f(-0.059678, 0.573354, 0.004738);
 cgNormal3f(0.207520, 0.673340, 0.708984);
 cgVertex3f(-0.057308, 0.580461, 0.004738);
 cgNormal3f(0.115234, 0.697266, 0.707031);
 cgVertex3f(-0.131936, 0.594676, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.701660, 0.025879, 0.711426);
 cgVertex3f(0.036272, 0.485696, 0.004738);
 cgNormal3f(0.600586, 0.336914, 0.724121);
 cgVertex3f(0.027980, 0.527156, 0.004738);
 cgNormal3f(0.595703, 0.332031, 0.730469);
 cgVertex3f(0.022057, 0.524787, 0.004738);
 cgNormal3f(0.702637, 0.019043, 0.710938);
 cgVertex3f(0.029165, 0.484511, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.383301, 0.587891, 0.711914);
 cgVertex3f(-0.002819, 0.555585, 0.004738);
 cgNormal3f(0.207520, 0.673340, 0.708984);
 cgVertex3f(-0.057308, 0.580461, 0.004738);
 cgNormal3f(0.227539, 0.661621, 0.713867);
 cgVertex3f(-0.059678, 0.573354, 0.004738);
 cgNormal3f(0.381836, 0.579590, 0.719727);
 cgVertex3f(-0.005188, 0.548478, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.115234, 0.697266, 0.707031);
 cgVertex3f(-0.131936, 0.594676, 0.004738);
 cgNormal3f(0.069336, 0.712891, 0.697266);
 cgVertex3f(-0.367664, 0.629028, 0.004738);
 cgNormal3f(0.075684, 0.697266, 0.712402);
 cgVertex3f(-0.368848, 0.621921, 0.004738);
 cgNormal3f(0.125977, 0.689453, 0.712891);
 cgVertex3f(-0.131936, 0.589937, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.098145, 0.923340, 0.370605);
 cgVertex3f(-0.368848, 0.621921, 0.023691);
 cgNormal3f(0.166016, 0.911621, 0.374512);
 cgVertex3f(-0.131936, 0.589937, 0.023691);
 cgNormal3f(0.125977, 0.689453, 0.712891);
 cgVertex3f(-0.131936, 0.589937, 0.004738);
 cgNormal3f(0.075684, 0.697266, 0.712402);
 cgVertex3f(-0.368848, 0.621921, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.166016, 0.911621, 0.374512);
 cgVertex3f(-0.131936, 0.589937, 0.023691);
 cgNormal3f(0.288574, 0.872070, 0.394531);
 cgVertex3f(-0.059678, 0.573354, 0.023691);
 cgNormal3f(0.227539, 0.661621, 0.713867);
 cgVertex3f(-0.059678, 0.573354, 0.004738);
 cgNormal3f(0.125977, 0.689453, 0.712891);
 cgVertex3f(-0.131936, 0.589937, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.288574, 0.872070, 0.394531);
 cgVertex3f(-0.059678, 0.573354, 0.023691);
 cgNormal3f(0.485840, 0.758301, 0.434082);
 cgVertex3f(-0.005188, 0.548478, 0.023691);
 cgNormal3f(0.381836, 0.579590, 0.719727);
 cgVertex3f(-0.005188, 0.548478, 0.004738);
 cgNormal3f(0.227539, 0.661621, 0.713867);
 cgVertex3f(-0.059678, 0.573354, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.485840, 0.758301, 0.434082);
 cgVertex3f(-0.005188, 0.548478, 0.023691);
 cgNormal3f(0.773438, 0.432129, 0.462402);
 cgVertex3f(0.022057, 0.524787, 0.023691);
 cgNormal3f(0.595703, 0.332031, 0.730469);
 cgVertex3f(0.022057, 0.524787, 0.004738);
 cgNormal3f(0.381836, 0.579590, 0.719727);
 cgVertex3f(-0.005188, 0.548478, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.773438, 0.432129, 0.462402);
 cgVertex3f(0.022057, 0.524787, 0.023691);
 cgNormal3f(0.905762, 0.021484, 0.421875);
 cgVertex3f(0.029165, 0.484511, 0.023691);
 cgNormal3f(0.702637, 0.019043, 0.710938);
 cgVertex3f(0.029165, 0.484511, 0.004738);
 cgNormal3f(0.595703, 0.332031, 0.730469);
 cgVertex3f(0.022057, 0.524787, 0.004738);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.702637, 0.019043, 0.710938);
 cgVertex3f(0.029165, 0.484511, 0.004738);
 cgNormal3f(0.905762, 0.021484, 0.421875);
 cgVertex3f(0.029165, 0.484511, 0.023691);
 cgNormal3f(0.736816, -0.576660, 0.353027);
 cgVertex3f(0.016134, 0.376716, 0.023691);
 cgNormal3f(0.833496, -0.552734, 0.000000);
 cgVertex3f(0.016134, 0.376716, 0.004738);
 cgNormal3f(0.828613, -0.427734, 0.359863);
 cgVertex3f(0.019688, 0.406330, 0.004738);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.360840, 0.202148, 0.910156);
 cgVertex3f(0.007842, 0.517679, 0.035537);
 cgNormal3f(0.178223, 0.291016, 0.939453);
 cgVertex3f(-0.018218, 0.541370, 0.035537);
 cgNormal3f(-0.310059, -0.298828, 0.902344);
 cgVertex3f(-0.040725, 0.514125, 0.035537);
 cgNormal3f(-0.447754, -0.098633, 0.888672);
 cgVertex3f(-0.018218, 0.479773, 0.035537);
 cgNormal3f(0.342285, 0.006348, 0.939453);
 cgVertex3f(0.016134, 0.475035, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.112305, 0.360352, 0.925781);
 cgVertex3f(-0.072708, 0.565062, 0.035537);
 cgNormal3f(-0.106445, -0.329590, 0.937988);
 cgVertex3f(-0.064416, 0.527156, 0.035537);
 cgNormal3f(-0.310059, -0.298828, 0.902344);
 cgVertex3f(-0.040725, 0.514125, 0.035537);
 cgNormal3f(0.178223, 0.291016, 0.939453);
 cgVertex3f(-0.018218, 0.541370, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.056152, 0.311523, 0.948242);
 cgVertex3f(-0.144966, 0.580461, 0.035537);
 cgNormal3f(0.000977, -0.321777, 0.946777);
 cgVertex3f(-0.110614, 0.531894, 0.035537);
 cgNormal3f(-0.106445, -0.329590, 0.937988);
 cgVertex3f(-0.064416, 0.527156, 0.035537);
 cgNormal3f(0.112305, 0.360352, 0.925781);
 cgVertex3f(-0.072708, 0.565062, 0.035537);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.032715, 0.317871, 0.947266);
 cgVertex3f(-0.358187, 0.611260, 0.035537);
 cgNormal3f(-0.040527, -0.347656, 0.936523);
 cgVertex3f(-0.310805, 0.561508, 0.035537);
 cgNormal3f(-0.069824, -0.437988, 0.895996);
 cgVertex3f(-0.259869, 0.541370, 0.035537);
 cgNormal3f(-0.063477, -0.337402, 0.938965);
 cgVertex3f(-0.206563, 0.544924, 0.035537);
 cgNormal3f(0.056152, 0.311523, 0.948242);
 cgVertex3f(-0.144966, 0.580461, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.063477, -0.337402, 0.938965);
 cgVertex3f(-0.206563, 0.544924, 0.035537);
 cgNormal3f(-0.063965, -0.442871, 0.894043);
 cgVertex3f(-0.154443, 0.524787, 0.035537);
 cgNormal3f(0.000977, -0.321777, 0.946777);
 cgVertex3f(-0.110614, 0.531894, 0.035537);
 cgNormal3f(0.056152, 0.311523, 0.948242);
 cgVertex3f(-0.144966, 0.580461, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.098145, 0.923340, 0.370605);
 cgVertex3f(-0.368848, 0.621921, 0.023691);
 cgNormal3f(0.032715, 0.317871, 0.947266);
 cgVertex3f(-0.358187, 0.611260, 0.035537);
 cgNormal3f(0.056152, 0.311523, 0.948242);
 cgVertex3f(-0.144966, 0.580461, 0.035537);
 cgNormal3f(0.166016, 0.911621, 0.374512);
 cgVertex3f(-0.131936, 0.589937, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.063477, -0.337402, 0.938965);
 cgVertex3f(-0.206563, 0.544924, 0.035537);
 cgNormal3f(-0.069824, -0.437988, 0.895996);
 cgVertex3f(-0.259869, 0.541370, 0.035537);
 cgNormal3f(-0.137695, -0.892090, 0.430176);
 cgVertex3f(-0.261053, 0.528340, 0.023691);
 cgNormal3f(-0.163574, -0.892090, 0.421875);
 cgVertex3f(-0.203010, 0.531894, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.063965, -0.442871, 0.894043);
 cgVertex3f(-0.154443, 0.524787, 0.035537);
 cgNormal3f(-0.063477, -0.337402, 0.938965);
 cgVertex3f(-0.206563, 0.544924, 0.035537);
 cgNormal3f(-0.163574, -0.892090, 0.421875);
 cgVertex3f(-0.203010, 0.531894, 0.023691);
 cgNormal3f(-0.115234, -0.895996, 0.429199);
 cgVertex3f(-0.150889, 0.510572, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.000977, -0.321777, 0.946777);
 cgVertex3f(-0.110614, 0.531894, 0.035537);
 cgNormal3f(-0.063965, -0.442871, 0.894043);
 cgVertex3f(-0.154443, 0.524787, 0.035537);
 cgNormal3f(-0.115234, -0.895996, 0.429199);
 cgVertex3f(-0.150889, 0.510572, 0.023691);
 cgNormal3f(0.003418, -0.896484, 0.443359);
 cgVertex3f(-0.107060, 0.517679, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.106445, -0.329590, 0.937988);
 cgVertex3f(-0.064416, 0.527156, 0.035537);
 cgNormal3f(0.000977, -0.321777, 0.946777);
 cgVertex3f(-0.110614, 0.531894, 0.035537);
 cgNormal3f(0.003418, -0.896484, 0.443359);
 cgVertex3f(-0.107060, 0.517679, 0.023691);
 cgNormal3f(-0.277344, -0.865234, 0.418457);
 cgVertex3f(-0.060862, 0.510572, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.310059, -0.298828, 0.902344);
 cgVertex3f(-0.040725, 0.514125, 0.035537);
 cgNormal3f(-0.106445, -0.329590, 0.937988);
 cgVertex3f(-0.064416, 0.527156, 0.035537);
 cgNormal3f(-0.277344, -0.865234, 0.418457);
 cgVertex3f(-0.060862, 0.510572, 0.023691);
 cgNormal3f(-0.678223, -0.658691, 0.326172);
 cgVertex3f(-0.037171, 0.499911, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.447754, -0.098633, 0.888672);
 cgVertex3f(-0.018218, 0.479773, 0.035537);
 cgNormal3f(-0.310059, -0.298828, 0.902344);
 cgVertex3f(-0.040725, 0.514125, 0.035537);
 cgNormal3f(-0.678223, -0.658691, 0.326172);
 cgVertex3f(-0.037171, 0.499911, 0.023691);
 cgNormal3f(-0.938965, -0.178711, 0.294922);
 cgVertex3f(-0.027694, 0.479773, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.437012, -0.438477, 0.785156);
 cgVertex3f(-0.028879, 0.382639, 0.035537);
 cgNormal3f(-0.447754, -0.098633, 0.888672);
 cgVertex3f(-0.018218, 0.479773, 0.035537);
 cgNormal3f(-0.938965, -0.178711, 0.294922);
 cgVertex3f(-0.027694, 0.479773, 0.023691);
 cgNormal3f(-0.882812, -0.370117, 0.290527);
 cgVertex3f(-0.038355, 0.383824, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.342285, 0.006348, 0.939453);
 cgVertex3f(0.016134, 0.475035, 0.035537);
 cgNormal3f(0.256348, -0.511230, 0.820312);
 cgVertex3f(0.001920, 0.377901, 0.035537);
 cgNormal3f(0.736816, -0.576660, 0.353027);
 cgVertex3f(0.016134, 0.376716, 0.023691);
 cgNormal3f(0.905762, 0.021484, 0.421875);
 cgVertex3f(0.029165, 0.484511, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.360840, 0.202148, 0.910156);
 cgVertex3f(0.007842, 0.517679, 0.035537);
 cgNormal3f(0.342285, 0.006348, 0.939453);
 cgVertex3f(0.016134, 0.475035, 0.035537);
 cgNormal3f(0.905762, 0.021484, 0.421875);
 cgVertex3f(0.029165, 0.484511, 0.023691);
 cgNormal3f(0.773438, 0.432129, 0.462402);
 cgVertex3f(0.022057, 0.524787, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.178223, 0.291016, 0.939453);
 cgVertex3f(-0.018218, 0.541370, 0.035537);
 cgNormal3f(0.360840, 0.202148, 0.910156);
 cgVertex3f(0.007842, 0.517679, 0.035537);
 cgNormal3f(0.773438, 0.432129, 0.462402);
 cgVertex3f(0.022057, 0.524787, 0.023691);
 cgNormal3f(0.485840, 0.758301, 0.434082);
 cgVertex3f(-0.005188, 0.548478, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.112305, 0.360352, 0.925781);
 cgVertex3f(-0.072708, 0.565062, 0.035537);
 cgNormal3f(0.178223, 0.291016, 0.939453);
 cgVertex3f(-0.018218, 0.541370, 0.035537);
 cgNormal3f(0.485840, 0.758301, 0.434082);
 cgVertex3f(-0.005188, 0.548478, 0.023691);
 cgNormal3f(0.288574, 0.872070, 0.394531);
 cgVertex3f(-0.059678, 0.573354, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.056152, 0.311523, 0.948242);
 cgVertex3f(-0.144966, 0.580461, 0.035537);
 cgNormal3f(0.112305, 0.360352, 0.925781);
 cgVertex3f(-0.072708, 0.565062, 0.035537);
 cgNormal3f(0.288574, 0.872070, 0.394531);
 cgVertex3f(-0.059678, 0.573354, 0.023691);
 cgNormal3f(0.166016, 0.911621, 0.374512);
 cgVertex3f(-0.131936, 0.589937, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.381836, 0.579590, 0.719727);
 cgVertex3f(-0.005188, 0.548478, 0.004738);
 cgNormal3f(0.595703, 0.332031, 0.730469);
 cgVertex3f(0.022057, 0.524787, 0.004738);
 cgNormal3f(0.600586, 0.336914, 0.724121);
 cgVertex3f(0.027980, 0.527156, 0.004738);
 cgNormal3f(0.383301, 0.587891, 0.711914);
 cgVertex3f(-0.002819, 0.555585, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.207520, 0.673340, -0.709473);
 cgVertex3f(-0.057308, 0.580461, -0.005923);
 cgNormal3f(0.207520, 0.673340, 0.708984);
 cgVertex3f(-0.057308, 0.580461, 0.004738);
 cgNormal3f(0.383301, 0.587891, 0.711914);
 cgVertex3f(-0.002819, 0.555585, 0.004738);
 cgNormal3f(0.383301, 0.587891, -0.712402);
 cgVertex3f(-0.002819, 0.555585, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.067383, 0.693359, -0.717285);
 cgVertex3f(-0.367664, 0.629028, -0.005923);
 cgNormal3f(0.069336, 0.712891, 0.697266);
 cgVertex3f(-0.367664, 0.629028, 0.004738);
 cgNormal3f(0.115234, 0.697266, 0.707031);
 cgVertex3f(-0.131936, 0.594676, 0.004738);
 cgNormal3f(0.115234, 0.697266, -0.707520);
 cgVertex3f(-0.131936, 0.594676, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.136719, -0.896484, -0.421875);
 cgVertex3f(-0.261053, 0.528340, -0.024876);
 cgNormal3f(-0.160645, -0.901855, -0.401855);
 cgVertex3f(-0.203010, 0.531894, -0.024876);
 cgNormal3f(-0.163574, -0.892090, 0.421875);
 cgVertex3f(-0.203010, 0.531894, 0.023691);
 cgNormal3f(-0.137695, -0.892090, 0.430176);
 cgVertex3f(-0.261053, 0.528340, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.160645, -0.901855, -0.401855);
 cgVertex3f(-0.203010, 0.531894, -0.024876);
 cgNormal3f(-0.110840, -0.903809, -0.414062);
 cgVertex3f(-0.150889, 0.510572, -0.024876);
 cgNormal3f(-0.115234, -0.895996, 0.429199);
 cgVertex3f(-0.150889, 0.510572, 0.023691);
 cgNormal3f(-0.163574, -0.892090, 0.421875);
 cgVertex3f(-0.203010, 0.531894, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.110840, -0.903809, -0.414062);
 cgVertex3f(-0.150889, 0.510572, -0.024876);
 cgNormal3f(0.007812, -0.900391, -0.435547);
 cgVertex3f(-0.107060, 0.517679, -0.024876);
 cgNormal3f(0.003418, -0.896484, 0.443359);
 cgVertex3f(-0.107060, 0.517679, 0.023691);
 cgNormal3f(-0.115234, -0.895996, 0.429199);
 cgVertex3f(-0.150889, 0.510572, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.007812, -0.900391, -0.435547);
 cgVertex3f(-0.107060, 0.517679, -0.024876);
 cgNormal3f(-0.274902, -0.867676, -0.415039);
 cgVertex3f(-0.060862, 0.510572, -0.024876);
 cgNormal3f(-0.277344, -0.865234, 0.418457);
 cgVertex3f(-0.060862, 0.510572, 0.023691);
 cgNormal3f(0.003418, -0.896484, 0.443359);
 cgVertex3f(-0.107060, 0.517679, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.274902, -0.867676, -0.415039);
 cgVertex3f(-0.060862, 0.510572, -0.024876);
 cgNormal3f(-0.678711, -0.660645, -0.321777);
 cgVertex3f(-0.037171, 0.499911, -0.024876);
 cgNormal3f(-0.678223, -0.658691, 0.326172);
 cgVertex3f(-0.037171, 0.499911, 0.023691);
 cgNormal3f(-0.277344, -0.865234, 0.418457);
 cgVertex3f(-0.060862, 0.510572, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.678711, -0.660645, -0.321777);
 cgVertex3f(-0.037171, 0.499911, -0.024876);
 cgNormal3f(-0.939941, -0.181152, -0.291016);
 cgVertex3f(-0.027694, 0.479773, -0.024876);
 cgNormal3f(-0.938965, -0.178711, 0.294922);
 cgVertex3f(-0.027694, 0.479773, 0.023691);
 cgNormal3f(-0.678223, -0.658691, 0.326172);
 cgVertex3f(-0.037171, 0.499911, 0.023691);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.939941, -0.181152, -0.291016);
 cgVertex3f(-0.027694, 0.479773, -0.024876);
 cgNormal3f(-0.882812, -0.370117, -0.291016);
 cgVertex3f(-0.038355, 0.383824, -0.024876);
 cgNormal3f(-0.882812, -0.370117, 0.290527);
 cgVertex3f(-0.038355, 0.383824, 0.023691);
 cgNormal3f(-0.938965, -0.178711, 0.294922);
 cgVertex3f(-0.027694, 0.479773, 0.023691);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.833496, -0.552734, 0.000000);
 cgVertex3f(0.016134, 0.376716, 0.004738);
 cgNormal3f(0.736816, -0.576660, 0.353027);
 cgVertex3f(0.016134, 0.376716, 0.023691);
 cgNormal3f(0.256348, -0.511230, 0.820312);
 cgVertex3f(0.001920, 0.377901, 0.035537);
 cgNormal3f(-0.437012, -0.438477, 0.785156);
 cgVertex3f(-0.028879, 0.382639, 0.035537);
 cgNormal3f(-0.882812, -0.370117, 0.290527);
 cgVertex3f(-0.038355, 0.383824, 0.023691);
 cgNormal3f(-0.882812, -0.370117, -0.291016);
 cgVertex3f(-0.038355, 0.383824, -0.024876);
 cgNormal3f(-0.437012, -0.438477, -0.785645);
 cgVertex3f(-0.028879, 0.382639, -0.036721);
 cgNormal3f(0.256348, -0.511230, -0.820801);
 cgVertex3f(0.001920, 0.377901, -0.036721);
 cgNormal3f(0.736816, -0.576660, -0.353516);
 cgVertex3f(0.016134, 0.376716, -0.024876);
 cgNormal3f(0.833496, -0.552734, 0.000000);
 cgVertex3f(0.016134, 0.376716, -0.005923);
 cgNormal3f(0.833496, -0.552246, 0.000000);
 cgVertex3f(0.016134, 0.376716, 0.000000);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.833496, -0.552734, 0.000000);
 cgVertex3f(0.016134, 0.376716, 0.004738);
 cgNormal3f(0.833496, -0.552246, 0.000000);
 cgVertex3f(0.016134, 0.376716, 0.000000);
 cgNormal3f(0.774414, -0.632324, 0.000000);
 cgVertex3f(0.019688, 0.406330, 0.000000);
 cgNormal3f(0.828613, -0.427734, 0.359863);
 cgVertex3f(0.019688, 0.406330, 0.004738);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.600586, 0.336914, -0.724609);
 cgVertex3f(0.027980, 0.527156, -0.005923);
 cgNormal3f(0.600586, 0.336914, 0.724121);
 cgVertex3f(0.027980, 0.527156, 0.004738);
 cgNormal3f(0.701660, 0.025879, 0.711426);
 cgVertex3f(0.036272, 0.485696, 0.004738);
 cgNormal3f(0.701660, 0.025879, -0.711914);
 cgVertex3f(0.036272, 0.485696, -0.005923);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.437012, -0.438477, 0.785156);
 cgVertex3f(-0.028879, 0.382639, 0.035537);
 cgNormal3f(0.256348, -0.511230, 0.820312);
 cgVertex3f(0.001920, 0.377901, 0.035537);
 cgNormal3f(0.342285, 0.006348, 0.939453);
 cgVertex3f(0.016134, 0.475035, 0.035537);
 cgNormal3f(-0.447754, -0.098633, 0.888672);
 cgVertex3f(-0.018218, 0.479773, 0.035537);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.589355, 0.569824, -0.572266);
 cgVertex3f(0.396497, 0.281685, 0.034283);
 cgNormal3f(0.814941, 0.406738, -0.412598);
 cgVertex3f(0.380181, 0.281685, 0.033920);
 cgNormal3f(0.344727, 0.894043, 0.284668);
 cgVertex3f(0.380181, 0.281685, 0.047698);
 cgNormal3f(0.539551, 0.763184, 0.354492);
 cgVertex3f(0.396497, 0.281685, 0.055312);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.231445, 0.451172, 0.861328);
 cgVertex3f(0.371117, 0.281685, 0.066551);
 cgNormal3f(0.048340, 0.447266, 0.892578);
 cgVertex3f(0.351176, 0.281685, 0.068727);
 cgNormal3f(0.048340, -0.447754, 0.892578);
 cgVertex3f(0.351176, 0.267182, 0.068727);
 cgNormal3f(0.231445, -0.451660, 0.861328);
 cgVertex3f(0.371117, 0.267182, 0.066551);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.539551, 0.763184, 0.354492);
 cgVertex3f(0.396497, 0.281685, 0.055312);
 cgNormal3f(0.231445, 0.451172, 0.861328);
 cgVertex3f(0.371117, 0.281685, 0.066551);
 cgNormal3f(0.231445, -0.451660, 0.861328);
 cgVertex3f(0.371117, 0.267182, 0.066551);
 cgNormal3f(0.715820, -0.516113, 0.470215);
 cgVertex3f(0.396497, 0.267182, 0.055312);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.589355, 0.569824, -0.572266);
 cgVertex3f(0.396497, 0.281685, 0.034283);
 cgNormal3f(0.539551, 0.763184, 0.354492);
 cgVertex3f(0.396497, 0.281685, 0.055312);
 cgNormal3f(0.715820, -0.516113, 0.470215);
 cgVertex3f(0.396497, 0.267182, 0.055312);
 cgNormal3f(0.584473, -0.580078, -0.567383);
 cgVertex3f(0.396497, 0.267182, 0.034283);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.814941, 0.406738, -0.412598);
 cgVertex3f(0.380181, 0.281685, 0.033920);
 cgNormal3f(0.589355, 0.569824, -0.572266);
 cgVertex3f(0.396497, 0.281685, 0.034283);
 cgNormal3f(0.584473, -0.580078, -0.567383);
 cgVertex3f(0.396497, 0.267182, 0.034283);
 cgNormal3f(0.578125, -0.566895, -0.586914);
 cgVertex3f(0.380181, 0.267182, 0.033920);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.814453, -0.403809, -0.416992);
 cgVertex3f(0.380181, 0.281685, 0.023768);
 cgNormal3f(0.814941, 0.406738, -0.412598);
 cgVertex3f(0.380181, 0.281685, 0.033920);
 cgNormal3f(0.578125, -0.566895, -0.586914);
 cgVertex3f(0.380181, 0.267182, 0.033920);
 cgNormal3f(0.569824, -0.570801, -0.591309);
 cgVertex3f(0.380181, 0.267182, 0.023768);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.814453, -0.403809, -0.416992);
 cgVertex3f(0.380181, 0.281685, 0.023768);
 cgNormal3f(0.685547, -0.526855, -0.502441);
 cgVertex3f(0.380181, 0.281685, 0.013616);
 cgNormal3f(0.681641, 0.533691, -0.499512);
 cgVertex3f(0.380181, 0.295825, 0.013616);
 cgNormal3f(0.486816, 0.775391, 0.401855);
 cgVertex3f(0.380181, 0.295825, 0.037546);
 cgNormal3f(0.344727, 0.894043, 0.284668);
 cgVertex3f(0.380181, 0.281685, 0.047698);
 cgNormal3f(0.814941, 0.406738, -0.412598);
 cgVertex3f(0.380181, 0.281685, 0.033920);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.502930, 0.464844, -0.728516);
 cgVertex3f(0.364953, 0.295825, 0.008903);
 cgNormal3f(0.681641, 0.533691, -0.499512);
 cgVertex3f(0.380181, 0.295825, 0.013616);
 cgNormal3f(0.685547, -0.526855, -0.502441);
 cgVertex3f(0.380181, 0.281685, 0.013616);
 cgNormal3f(0.391602, -0.724609, -0.567383);
 cgVertex3f(0.364953, 0.281685, 0.008903);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.836426, 0.466309, -0.287109);
 cgVertex3f(0.361327, 0.295825, 0.004190);
 cgNormal3f(0.502930, 0.464844, -0.728516);
 cgVertex3f(0.364953, 0.295825, 0.008903);
 cgNormal3f(0.391602, -0.724609, -0.567383);
 cgVertex3f(0.364953, 0.281685, 0.008903);
 cgNormal3f(0.650391, -0.726074, -0.223145);
 cgVertex3f(0.361327, 0.281685, 0.004190);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.772461, 0.489746, -0.403320);
 cgVertex3f(0.360965, 0.295825, -0.070137);
 cgNormal3f(0.836426, 0.466309, -0.287109);
 cgVertex3f(0.361327, 0.295825, 0.004190);
 cgNormal3f(0.650391, -0.726074, -0.223145);
 cgVertex3f(0.361327, 0.281685, 0.004190);
 cgNormal3f(0.772461, -0.490234, -0.403320);
 cgVertex3f(0.360965, 0.281685, -0.070137);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.378418, 0.452637, -0.807129);
 cgVertex3f(0.354801, 0.295825, -0.074488);
 cgNormal3f(0.772461, 0.489746, -0.403320);
 cgVertex3f(0.360965, 0.295825, -0.070137);
 cgNormal3f(0.772461, -0.490234, -0.403320);
 cgVertex3f(0.360965, 0.281685, -0.070137);
 cgNormal3f(0.378418, -0.453125, -0.807129);
 cgVertex3f(0.354801, 0.281685, -0.074488);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.116699, 0.450195, -0.885254);
 cgVertex3f(0.345374, 0.295825, -0.077026);
 cgNormal3f(0.378418, 0.452637, -0.807129);
 cgVertex3f(0.354801, 0.295825, -0.074488);
 cgNormal3f(0.378418, -0.453125, -0.807129);
 cgVertex3f(0.354801, 0.281685, -0.074488);
 cgNormal3f(0.116699, -0.450684, -0.885254);
 cgVertex3f(0.345374, 0.281685, -0.077026);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.685547, -0.526855, -0.502441);
 cgVertex3f(0.380181, 0.281685, 0.013616);
 cgNormal3f(0.814453, -0.403809, -0.416992);
 cgVertex3f(0.380181, 0.281685, 0.023768);
 cgNormal3f(0.000000, -0.980957, -0.196289);
 cgVertex3f(0.339573, 0.281685, 0.023768);
 cgNormal3f(0.391602, -0.724609, -0.567383);
 cgVertex3f(0.364953, 0.281685, 0.008903);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(0.391602, -0.724609, -0.567383);
 cgVertex3f(0.364953, 0.281685, 0.008903);
 cgNormal3f(0.000000, -0.980957, -0.196289);
 cgVertex3f(0.339573, 0.281685, 0.023768);
 cgNormal3f(0.650391, -0.726074, -0.223145);
 cgVertex3f(0.361327, 0.281685, 0.004190);
cgEnd();
cgBegin(CG_TRIANGLES);
 cgNormal3f(-0.390137, -0.724609, -0.568359);
 cgVertex3f(0.314194, 0.281685, 0.008903);
 cgNormal3f(-0.650879, -0.726074, -0.223145);
 cgVertex3f(0.317819, 0.281685, 0.004190);
 cgNormal3f(0.000000, -0.980957, -0.196289);
 cgVertex3f(0.339573, 0.281685, 0.023768);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.816895, -0.408691, -0.408691);
 cgVertex3f(0.298241, 0.281685, 0.023768);
 cgNormal3f(-0.679688, -0.529785, -0.507812);
 cgVertex3f(0.298241, 0.281685, 0.013616);
 cgNormal3f(-0.390137, -0.724609, -0.568359);
 cgVertex3f(0.314194, 0.281685, 0.008903);
 cgNormal3f(0.000000, -0.980957, -0.196289);
 cgVertex3f(0.339573, 0.281685, 0.023768);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.814453, -0.403809, -0.416992);
 cgVertex3f(0.380181, 0.281685, 0.023768);
 cgNormal3f(0.569824, -0.570801, -0.591309);
 cgVertex3f(0.380181, 0.267182, 0.023768);
 cgNormal3f(-0.577637, -0.577637, -0.577637);
 cgVertex3f(0.298241, 0.267182, 0.023768);
 cgNormal3f(-0.816895, -0.408691, -0.408691);
 cgVertex3f(0.298241, 0.281685, 0.023768);
 cgNormal3f(0.000000, -0.980957, -0.196289);
 cgVertex3f(0.339573, 0.281685, 0.023768);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.113281, 0.449707, -0.886230);
 cgVertex3f(0.334135, 0.295825, -0.077026);
 cgNormal3f(0.116699, 0.450195, -0.885254);
 cgVertex3f(0.345374, 0.295825, -0.077026);
 cgNormal3f(0.116699, -0.450684, -0.885254);
 cgVertex3f(0.345374, 0.281685, -0.077026);
 cgNormal3f(-0.113281, -0.450195, -0.886230);
 cgVertex3f(0.334135, 0.281685, -0.077026);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.375000, 0.452637, -0.809082);
 cgVertex3f(0.324345, 0.295825, -0.074488);
 cgNormal3f(-0.113281, 0.449707, -0.886230);
 cgVertex3f(0.334135, 0.295825, -0.077026);
 cgNormal3f(-0.113281, -0.450195, -0.886230);
 cgVertex3f(0.334135, 0.281685, -0.077026);
 cgNormal3f(-0.375000, -0.453125, -0.809082);
 cgVertex3f(0.324345, 0.281685, -0.074488);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.772949, 0.489746, -0.403320);
 cgVertex3f(0.318182, 0.295825, -0.070137);
 cgNormal3f(-0.375000, 0.452637, -0.809082);
 cgVertex3f(0.324345, 0.295825, -0.074488);
 cgNormal3f(-0.375000, -0.453125, -0.809082);
 cgVertex3f(0.324345, 0.281685, -0.074488);
 cgNormal3f(-0.772949, -0.490234, -0.403320);
 cgVertex3f(0.318182, 0.281685, -0.070137);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.836914, 0.466309, -0.287109);
 cgVertex3f(0.317819, 0.295825, 0.004190);
 cgNormal3f(-0.772949, 0.489746, -0.403320);
 cgVertex3f(0.318182, 0.295825, -0.070137);
 cgNormal3f(-0.772949, -0.490234, -0.403320);
 cgVertex3f(0.318182, 0.281685, -0.070137);
 cgNormal3f(-0.650879, -0.726074, -0.223145);
 cgVertex3f(0.317819, 0.281685, 0.004190);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.500977, 0.464844, -0.729980);
 cgVertex3f(0.314194, 0.295825, 0.008903);
 cgNormal3f(-0.836914, 0.466309, -0.287109);
 cgVertex3f(0.317819, 0.295825, 0.004190);
 cgNormal3f(-0.650879, -0.726074, -0.223145);
 cgVertex3f(0.317819, 0.281685, 0.004190);
 cgNormal3f(-0.390137, -0.724609, -0.568359);
 cgVertex3f(0.314194, 0.281685, 0.008903);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.679688, 0.529297, -0.507812);
 cgVertex3f(0.298241, 0.295825, 0.013616);
 cgNormal3f(-0.500977, 0.464844, -0.729980);
 cgVertex3f(0.314194, 0.295825, 0.008903);
 cgNormal3f(-0.390137, -0.724609, -0.568359);
 cgVertex3f(0.314194, 0.281685, 0.008903);
 cgNormal3f(-0.679688, -0.529785, -0.507812);
 cgVertex3f(0.298241, 0.281685, 0.013616);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.346680, 0.894531, 0.281250);
 cgVertex3f(0.298241, 0.281685, 0.047698);
 cgNormal3f(-0.490234, 0.775391, 0.397949);
 cgVertex3f(0.298241, 0.295825, 0.037546);
 cgNormal3f(-0.679688, 0.529297, -0.507812);
 cgVertex3f(0.298241, 0.295825, 0.013616);
 cgNormal3f(-0.679688, -0.529785, -0.507812);
 cgVertex3f(0.298241, 0.281685, 0.013616);
 cgNormal3f(-0.816895, -0.408691, -0.408691);
 cgVertex3f(0.298241, 0.281685, 0.023768);
 cgNormal3f(-0.819824, 0.404785, -0.405273);
 cgVertex3f(0.298241, 0.281685, 0.033920);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.344727, 0.894043, 0.284668);
 cgVertex3f(0.380181, 0.281685, 0.047698);
 cgNormal3f(0.486816, 0.775391, 0.401855);
 cgVertex3f(0.380181, 0.295825, 0.037546);
 cgNormal3f(-0.490234, 0.775391, 0.397949);
 cgVertex3f(0.298241, 0.295825, 0.037546);
 cgNormal3f(-0.346680, 0.894531, 0.281250);
 cgVertex3f(0.298241, 0.281685, 0.047698);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.577637, -0.577637, -0.577637);
 cgVertex3f(0.298241, 0.267182, 0.023768);
 cgNormal3f(0.569824, -0.570801, -0.591309);
 cgVertex3f(0.380181, 0.267182, 0.023768);
 cgNormal3f(0.578125, -0.566895, -0.586914);
 cgVertex3f(0.380181, 0.267182, 0.033920);
 cgNormal3f(0.584473, -0.580078, -0.567383);
 cgVertex3f(0.396497, 0.267182, 0.034283);
 cgNormal3f(0.715820, -0.516113, 0.470215);
 cgVertex3f(0.396497, 0.267182, 0.055312);
 cgNormal3f(0.231445, -0.451660, 0.861328);
 cgVertex3f(0.371117, 0.267182, 0.066551);
 cgNormal3f(0.048340, -0.447754, 0.892578);
 cgVertex3f(0.351176, 0.267182, 0.068727);
 cgNormal3f(-0.048828, -0.447754, 0.892578);
 cgVertex3f(0.327971, 0.267182, 0.068727);
 cgNormal3f(-0.229980, -0.451660, 0.862305);
 cgVertex3f(0.308030, 0.267182, 0.066551);
 cgNormal3f(-0.715332, -0.511230, 0.476562);
 cgVertex3f(0.282288, 0.267182, 0.055312);
 cgNormal3f(-0.589355, -0.576660, -0.566406);
 cgVertex3f(0.281925, 0.267182, 0.034283);
 cgNormal3f(-0.585938, -0.573242, -0.573242);
 cgVertex3f(0.298241, 0.267182, 0.033920);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.229980, 0.451172, 0.862305);
 cgVertex3f(0.308030, 0.281685, 0.066551);
 cgNormal3f(-0.048828, 0.447266, 0.892578);
 cgVertex3f(0.327971, 0.281685, 0.068727);
 cgNormal3f(0.048340, 0.447266, 0.892578);
 cgVertex3f(0.351176, 0.281685, 0.068727);
 cgNormal3f(0.231445, 0.451172, 0.861328);
 cgVertex3f(0.371117, 0.281685, 0.066551);
 cgNormal3f(0.539551, 0.763184, 0.354492);
 cgVertex3f(0.396497, 0.281685, 0.055312);
 cgNormal3f(0.344727, 0.894043, 0.284668);
 cgVertex3f(0.380181, 0.281685, 0.047698);
 cgNormal3f(-0.346680, 0.894531, 0.281250);
 cgVertex3f(0.298241, 0.281685, 0.047698);
 cgNormal3f(-0.535645, 0.765137, 0.356934);
 cgVertex3f(0.282288, 0.281685, 0.055312);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.772461, 0.489746, -0.403320);
 cgVertex3f(0.360965, 0.295825, -0.070137);
 cgNormal3f(0.378418, 0.452637, -0.807129);
 cgVertex3f(0.354801, 0.295825, -0.074488);
 cgNormal3f(0.116699, 0.450195, -0.885254);
 cgVertex3f(0.345374, 0.295825, -0.077026);
 cgNormal3f(-0.113281, 0.449707, -0.886230);
 cgVertex3f(0.334135, 0.295825, -0.077026);
 cgNormal3f(-0.375000, 0.452637, -0.809082);
 cgVertex3f(0.324345, 0.295825, -0.074488);
 cgNormal3f(-0.772949, 0.489746, -0.403320);
 cgVertex3f(0.318182, 0.295825, -0.070137);
 cgNormal3f(-0.836914, 0.466309, -0.287109);
 cgVertex3f(0.317819, 0.295825, 0.004190);
 cgNormal3f(-0.500977, 0.464844, -0.729980);
 cgVertex3f(0.314194, 0.295825, 0.008903);
 cgNormal3f(-0.679688, 0.529297, -0.507812);
 cgVertex3f(0.298241, 0.295825, 0.013616);
 cgNormal3f(-0.490234, 0.775391, 0.397949);
 cgVertex3f(0.298241, 0.295825, 0.037546);
 cgNormal3f(0.486816, 0.775391, 0.401855);
 cgVertex3f(0.380181, 0.295825, 0.037546);
 cgNormal3f(0.681641, 0.533691, -0.499512);
 cgVertex3f(0.380181, 0.295825, 0.013616);
 cgNormal3f(0.502930, 0.464844, -0.728516);
 cgVertex3f(0.364953, 0.295825, 0.008903);
 cgNormal3f(0.836426, 0.466309, -0.287109);
 cgVertex3f(0.361327, 0.295825, 0.004190);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.819824, 0.404785, -0.405273);
 cgVertex3f(0.298241, 0.281685, 0.033920);
 cgNormal3f(-0.816895, -0.408691, -0.408691);
 cgVertex3f(0.298241, 0.281685, 0.023768);
 cgNormal3f(-0.577637, -0.577637, -0.577637);
 cgVertex3f(0.298241, 0.267182, 0.023768);
 cgNormal3f(-0.585938, -0.573242, -0.573242);
 cgVertex3f(0.298241, 0.267182, 0.033920);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.589355, 0.576172, -0.566406);
 cgVertex3f(0.281925, 0.281685, 0.034283);
 cgNormal3f(-0.819824, 0.404785, -0.405273);
 cgVertex3f(0.298241, 0.281685, 0.033920);
 cgNormal3f(-0.585938, -0.573242, -0.573242);
 cgVertex3f(0.298241, 0.267182, 0.033920);
 cgNormal3f(-0.589355, -0.576660, -0.566406);
 cgVertex3f(0.281925, 0.267182, 0.034283);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.535645, 0.765137, 0.356934);
 cgVertex3f(0.282288, 0.281685, 0.055312);
 cgNormal3f(-0.589355, 0.576172, -0.566406);
 cgVertex3f(0.281925, 0.281685, 0.034283);
 cgNormal3f(-0.589355, -0.576660, -0.566406);
 cgVertex3f(0.281925, 0.267182, 0.034283);
 cgNormal3f(-0.715332, -0.511230, 0.476562);
 cgVertex3f(0.282288, 0.267182, 0.055312);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.229980, 0.451172, 0.862305);
 cgVertex3f(0.308030, 0.281685, 0.066551);
 cgNormal3f(-0.535645, 0.765137, 0.356934);
 cgVertex3f(0.282288, 0.281685, 0.055312);
 cgNormal3f(-0.715332, -0.511230, 0.476562);
 cgVertex3f(0.282288, 0.267182, 0.055312);
 cgNormal3f(-0.229980, -0.451660, 0.862305);
 cgVertex3f(0.308030, 0.267182, 0.066551);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.048828, 0.447266, 0.892578);
 cgVertex3f(0.327971, 0.281685, 0.068727);
 cgNormal3f(-0.229980, 0.451172, 0.862305);
 cgVertex3f(0.308030, 0.281685, 0.066551);
 cgNormal3f(-0.229980, -0.451660, 0.862305);
 cgVertex3f(0.308030, 0.267182, 0.066551);
 cgNormal3f(-0.048828, -0.447754, 0.892578);
 cgVertex3f(0.327971, 0.267182, 0.068727);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.048340, 0.447266, 0.892578);
 cgVertex3f(0.351176, 0.281685, 0.068727);
 cgNormal3f(-0.048828, 0.447266, 0.892578);
 cgVertex3f(0.327971, 0.281685, 0.068727);
 cgNormal3f(-0.048828, -0.447754, 0.892578);
 cgVertex3f(0.327971, 0.267182, 0.068727);
 cgNormal3f(0.048340, -0.447754, 0.892578);
 cgVertex3f(0.351176, 0.267182, 0.068727);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.378418, -0.453125, -0.807129);
 cgVertex3f(0.354801, 0.281685, -0.074488);
 cgNormal3f(0.772461, -0.490234, -0.403320);
 cgVertex3f(0.360965, 0.281685, -0.070137);
 cgNormal3f(0.650391, -0.726074, -0.223145);
 cgVertex3f(0.361327, 0.281685, 0.004190);
 cgNormal3f(0.000000, -0.980957, -0.196289);
 cgVertex3f(0.339573, 0.281685, 0.023768);
 cgNormal3f(-0.650879, -0.726074, -0.223145);
 cgVertex3f(0.317819, 0.281685, 0.004190);
 cgNormal3f(-0.772949, -0.490234, -0.403320);
 cgVertex3f(0.318182, 0.281685, -0.070137);
 cgNormal3f(-0.375000, -0.453125, -0.809082);
 cgVertex3f(0.324345, 0.281685, -0.074488);
 cgNormal3f(-0.113281, -0.450195, -0.886230);
 cgVertex3f(0.334135, 0.281685, -0.077026);
 cgNormal3f(0.116699, -0.450684, -0.885254);
 cgVertex3f(0.345374, 0.281685, -0.077026);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.819824, 0.404785, -0.405273);
 cgVertex3f(0.298241, 0.281685, 0.033920);
 cgNormal3f(-0.589355, 0.576172, -0.566406);
 cgVertex3f(0.281925, 0.281685, 0.034283);
 cgNormal3f(-0.535645, 0.765137, 0.356934);
 cgVertex3f(0.282288, 0.281685, 0.055312);
 cgNormal3f(-0.346680, 0.894531, 0.281250);
 cgVertex3f(0.298241, 0.281685, 0.047698);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.552246, 0.833008, 0.002441);
 cgVertex3f(0.432028, 0.300176, -0.046570);
 cgNormal3f(0.280762, 0.821289, 0.496094);
 cgVertex3f(0.423689, 0.300176, -0.032067);
 cgNormal3f(0.476074, 0.324219, 0.817383);
 cgVertex3f(0.426952, 0.294012, -0.028442);
 cgNormal3f(0.939941, 0.339844, 0.003906);
 cgVertex3f(0.436742, 0.294012, -0.046570);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.282227, 0.822266, -0.494141);
 cgVertex3f(0.423689, 0.300176, -0.061435);
 cgNormal3f(0.552246, 0.833008, 0.002441);
 cgVertex3f(0.432028, 0.300176, -0.046570);
 cgNormal3f(0.939941, 0.339844, 0.003906);
 cgVertex3f(0.436742, 0.294012, -0.046570);
 cgNormal3f(0.479492, 0.324707, -0.815430);
 cgVertex3f(0.426952, 0.294012, -0.065061);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.328613, 0.874512, -0.356934);
 cgVertex3f(0.394321, 0.300176, -0.061435);
 cgNormal3f(0.282227, 0.822266, -0.494141);
 cgVertex3f(0.423689, 0.300176, -0.061435);
 cgNormal3f(0.479492, 0.324707, -0.815430);
 cgVertex3f(0.426952, 0.294012, -0.065061);
 cgNormal3f(-0.637695, 0.395508, -0.661621);
 cgVertex3f(0.389608, 0.294012, -0.065061);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.328613, 0.874512, 0.356445);
 cgVertex3f(0.394321, 0.300176, -0.032067);
 cgNormal3f(-0.328613, 0.874512, -0.356934);
 cgVertex3f(0.394321, 0.300176, -0.061435);
 cgNormal3f(-0.637695, 0.395508, -0.661621);
 cgVertex3f(0.389608, 0.294012, -0.065061);
 cgNormal3f(-0.637695, 0.395508, 0.661133);
 cgVertex3f(0.389608, 0.294012, -0.028442);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.280762, 0.821289, 0.496094);
 cgVertex3f(0.423689, 0.300176, -0.032067);
 cgNormal3f(-0.328613, 0.874512, 0.356445);
 cgVertex3f(0.394321, 0.300176, -0.032067);
 cgNormal3f(-0.637695, 0.395508, 0.661133);
 cgVertex3f(0.389608, 0.294012, -0.028442);
 cgNormal3f(0.476074, 0.324219, 0.817383);
 cgVertex3f(0.426952, 0.294012, -0.028442);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.637695, 0.395508, -0.661621);
 cgVertex3f(0.389608, 0.294012, -0.065061);
 cgNormal3f(0.479492, 0.324707, -0.815430);
 cgVertex3f(0.426952, 0.294012, -0.065061);
 cgNormal3f(0.335449, 0.759277, -0.557617);
 cgVertex3f(0.426952, 0.280234, -0.065061);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(0.389608, 0.280234, -0.065061);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.637695, 0.395508, 0.661133);
 cgVertex3f(0.389608, 0.294012, -0.028442);
 cgNormal3f(-0.637695, 0.395508, -0.661621);
 cgVertex3f(0.389608, 0.294012, -0.065061);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(0.389608, 0.280234, -0.065061);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(0.389608, 0.280234, -0.028442);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.476074, 0.324219, 0.817383);
 cgVertex3f(0.426952, 0.294012, -0.028442);
 cgNormal3f(-0.637695, 0.395508, 0.661133);
 cgVertex3f(0.389608, 0.294012, -0.028442);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(0.389608, 0.280234, -0.028442);
 cgNormal3f(0.333496, 0.758301, 0.559082);
 cgVertex3f(0.426952, 0.280234, -0.028442);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.939941, 0.339844, 0.003906);
 cgVertex3f(0.436742, 0.294012, -0.046570);
 cgNormal3f(0.476074, 0.324219, 0.817383);
 cgVertex3f(0.426952, 0.294012, -0.028442);
 cgNormal3f(0.333496, 0.758301, 0.559082);
 cgVertex3f(0.426952, 0.280234, -0.028442);
 cgNormal3f(0.661133, 0.750000, 0.002441);
 cgVertex3f(0.436742, 0.280234, -0.046570);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.479492, 0.324707, -0.815430);
 cgVertex3f(0.426952, 0.294012, -0.065061);
 cgNormal3f(0.939941, 0.339844, 0.003906);
 cgVertex3f(0.436742, 0.294012, -0.046570);
 cgNormal3f(0.661133, 0.750000, 0.002441);
 cgVertex3f(0.436742, 0.280234, -0.046570);
 cgNormal3f(0.335449, 0.759277, -0.557617);
 cgVertex3f(0.426952, 0.280234, -0.065061);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.330566, 0.756836, -0.563477);
 cgVertex3f(0.449794, 0.280234, -0.093341);
 cgNormal3f(0.335449, 0.759277, -0.557617);
 cgVertex3f(0.426952, 0.280234, -0.065061);
 cgNormal3f(0.661133, 0.750000, 0.002441);
 cgVertex3f(0.436742, 0.280234, -0.046570);
 cgNormal3f(0.672852, 0.718262, -0.175293);
 cgVertex3f(0.467197, 0.280234, -0.062160);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.328613, 0.874512, -0.356934);
 cgVertex3f(0.394321, 0.300176, -0.061435);
 cgNormal3f(-0.328613, 0.874512, 0.356445);
 cgVertex3f(0.394321, 0.300176, -0.032067);
 cgNormal3f(0.280762, 0.821289, 0.496094);
 cgVertex3f(0.423689, 0.300176, -0.032067);
 cgNormal3f(0.552246, 0.833008, 0.002441);
 cgVertex3f(0.432028, 0.300176, -0.046570);
 cgNormal3f(0.282227, 0.822266, -0.494141);
 cgVertex3f(0.423689, 0.300176, -0.061435);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(0.389608, 0.280234, -0.065061);
 cgNormal3f(0.335449, 0.759277, -0.557617);
 cgVertex3f(0.426952, 0.280234, -0.065061);
 cgNormal3f(0.330566, 0.756836, -0.563477);
 cgVertex3f(0.449794, 0.280234, -0.093341);
 cgNormal3f(-0.328613, 0.756348, -0.565918);
 cgVertex3f(0.314556, 0.280234, -0.093341);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(0.389608, 0.280234, -0.028442);
 cgNormal3f(-0.408691, 0.816406, -0.408691);
 cgVertex3f(0.389608, 0.280234, -0.065061);
 cgNormal3f(-0.328613, 0.756348, -0.565918);
 cgVertex3f(0.314556, 0.280234, -0.093341);
 cgNormal3f(-0.858887, 0.458984, -0.227539);
 cgVertex3f(0.296790, 0.280234, -0.062160);
 cgNormal3f(-0.858887, 0.458984, 0.227051);
 cgVertex3f(0.296790, 0.280234, -0.031342);
 cgNormal3f(-0.329590, 0.755859, 0.564941);
 cgVertex3f(0.314556, 0.280234, -0.000161);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.333496, 0.758301, 0.559082);
 cgVertex3f(0.426952, 0.280234, -0.028442);
 cgNormal3f(-0.408691, 0.816406, 0.408203);
 cgVertex3f(0.389608, 0.280234, -0.028442);
 cgNormal3f(-0.329590, 0.755859, 0.564941);
 cgVertex3f(0.314556, 0.280234, -0.000161);
 cgNormal3f(0.329590, 0.757324, 0.562988);
 cgVertex3f(0.449794, 0.280234, 0.000201);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.333496, 0.758301, 0.559082);
 cgVertex3f(0.426952, 0.280234, -0.028442);
 cgNormal3f(0.329590, 0.757324, 0.562988);
 cgVertex3f(0.449794, 0.280234, 0.000201);
 cgNormal3f(0.859375, 0.458984, 0.223633);
 cgVertex3f(0.467197, 0.280234, -0.030980);
 cgNormal3f(0.672852, 0.718262, -0.175293);
 cgVertex3f(0.467197, 0.280234, -0.062160);
 cgNormal3f(0.661133, 0.750000, 0.002441);
 cgVertex3f(0.436742, 0.280234, -0.046570);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.437500, -0.501953, -0.746094);
 cgVertex3f(0.449794, 0.267544, -0.093341);
 cgNormal3f(0.330566, 0.756836, -0.563477);
 cgVertex3f(0.449794, 0.280234, -0.093341);
 cgNormal3f(0.672852, 0.718262, -0.175293);
 cgVertex3f(0.467197, 0.280234, -0.062160);
 cgNormal3f(0.859375, -0.458984, -0.224121);
 cgVertex3f(0.467197, 0.267544, -0.062160);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.329590, 0.757324, 0.562988);
 cgVertex3f(0.449794, 0.280234, 0.000201);
 cgNormal3f(0.436523, -0.501953, 0.746094);
 cgVertex3f(0.449794, 0.267544, 0.000201);
 cgNormal3f(0.859375, -0.458984, 0.223633);
 cgVertex3f(0.467197, 0.267544, -0.030980);
 cgNormal3f(0.859375, 0.458984, 0.223633);
 cgVertex3f(0.467197, 0.280234, -0.030980);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.858887, -0.459473, 0.227051);
 cgVertex3f(0.296790, 0.267544, -0.031342);
 cgNormal3f(-0.858887, 0.458984, 0.227051);
 cgVertex3f(0.296790, 0.280234, -0.031342);
 cgNormal3f(-0.858887, 0.458984, -0.227539);
 cgVertex3f(0.296790, 0.280234, -0.062160);
 cgNormal3f(-0.858887, -0.459473, -0.227539);
 cgVertex3f(0.296790, 0.267544, -0.062160);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.328613, 0.756348, -0.565918);
 cgVertex3f(0.314556, 0.280234, -0.093341);
 cgNormal3f(-0.435059, -0.500977, -0.748535);
 cgVertex3f(0.314556, 0.267544, -0.093341);
 cgNormal3f(-0.858887, -0.459473, -0.227539);
 cgVertex3f(0.296790, 0.267544, -0.062160);
 cgNormal3f(-0.858887, 0.458984, -0.227539);
 cgVertex3f(0.296790, 0.280234, -0.062160);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.859375, -0.458984, -0.224121);
 cgVertex3f(0.467197, 0.267544, -0.062160);
 cgNormal3f(0.672852, 0.718262, -0.175293);
 cgVertex3f(0.467197, 0.280234, -0.062160);
 cgNormal3f(0.859375, 0.458984, 0.223633);
 cgVertex3f(0.467197, 0.280234, -0.030980);
 cgNormal3f(0.859375, -0.458984, 0.223633);
 cgVertex3f(0.467197, 0.267544, -0.030980);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.436035, -0.500488, 0.747559);
 cgVertex3f(0.314556, 0.267544, -0.000161);
 cgNormal3f(-0.329590, 0.755859, 0.564941);
 cgVertex3f(0.314556, 0.280234, -0.000161);
 cgNormal3f(-0.858887, 0.458984, 0.227051);
 cgVertex3f(0.296790, 0.280234, -0.031342);
 cgNormal3f(-0.858887, -0.459473, 0.227051);
 cgVertex3f(0.296790, 0.267544, -0.031342);
cgEnd();
cgBegin(CG_POLYGON);
 cgNormal3f(0.436523, -0.501953, 0.746094);
 cgVertex3f(0.449794, 0.267544, 0.000201);
 cgNormal3f(-0.436035, -0.500488, 0.747559);
 cgVertex3f(0.314556, 0.267544, -0.000161);
 cgNormal3f(-0.858887, -0.459473, 0.227051);
 cgVertex3f(0.296790, 0.267544, -0.031342);
 cgNormal3f(-0.858887, -0.459473, -0.227539);
 cgVertex3f(0.296790, 0.267544, -0.062160);
 cgNormal3f(-0.435059, -0.500977, -0.748535);
 cgVertex3f(0.314556, 0.267544, -0.093341);
 cgNormal3f(0.437500, -0.501953, -0.746094);
 cgVertex3f(0.449794, 0.267544, -0.093341);
 cgNormal3f(0.859375, -0.458984, -0.224121);
 cgVertex3f(0.467197, 0.267544, -0.062160);
 cgNormal3f(0.859375, -0.458984, 0.223633);
 cgVertex3f(0.467197, 0.267544, -0.030980);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(0.436523, -0.501953, 0.746094);
 cgVertex3f(0.449794, 0.267544, 0.000201);
 cgNormal3f(0.329590, 0.757324, 0.562988);
 cgVertex3f(0.449794, 0.280234, 0.000201);
 cgNormal3f(-0.329590, 0.755859, 0.564941);
 cgVertex3f(0.314556, 0.280234, -0.000161);
 cgNormal3f(-0.436035, -0.500488, 0.747559);
 cgVertex3f(0.314556, 0.267544, -0.000161);
cgEnd();
cgBegin(CG_QUADS);
 cgNormal3f(-0.435059, -0.500977, -0.748535);
 cgVertex3f(0.314556, 0.267544, -0.093341);
 cgNormal3f(-0.328613, 0.756348, -0.565918);
 cgVertex3f(0.314556, 0.280234, -0.093341);
 cgNormal3f(0.330566, 0.756836, -0.563477);
 cgVertex3f(0.449794, 0.280234, -0.093341);
 cgNormal3f(0.437500, -0.501953, -0.746094);
 cgVertex3f(0.449794, 0.267544, -0.093341);
cgEnd();


	cgEndCompressedGeometryStream(&compressedBuffer,&bufferSize,&viewport);

	printf("compressed bytes: %d\n", bufferSize);
    if (cgGetError() != CG_NO_ERROR)
        fprintf(stderr, "Error during compression!\n");
}
