#pragma ident "@(#)cgpstream.h 1.11 97/05/08 SMI"

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */


/******************************************************************************
 *
 * cgpstream.h
 *
 * All internal data structures and constants used by the streaming routines.
 *
 *****************************************************************************/


/* values for dataType field */
#define CGP_STREAM_CMD_NULL  0 /* so there's no need for special cases */
#define CGP_STREAM_CMD_VTX   1
#define CGP_STREAM_CMD_SET_TABLE 2
#define CGP_STREAM_CMD_SET_STATE 3
#define CGP_STREAM_CMD_SET_COLOR 4
#define CGP_STREAM_CMD_SET_NORMAL 5
#define CGP_STREAM_CMD_MBR 6
#define CGP_STREAM_CMD_VNOP 7
#define CGP_STREAM_CMD_SET_QUANT_GEOM 8
#define CGP_STREAM_CMD_SET_QUANT_COLOR 9
#define CGP_STREAM_CMD_SET_QUANT_NORMAL 10

/* values for CGPsettable.table */
#define CGP_STREAM_TABLE_POS    0x0
#define CGP_STREAM_TABLE_COLOR  0x1
#define CGP_STREAM_TABLE_NORMAL 0x2

typedef struct cgpsettable {
    CGuint    address;
    CGboolean abs;	/* TRUE = absolute, FALSE = relative */
    CGshort   dataLen;
    CGshort   shift;
    CGubyte   table;
    struct cgpsettable* nextTableElement;
} CGPsettable;

typedef struct {
    CGbyte  dataType;
    CGvoid *data;
} CGPcommandstream;

/* compressed point format */
typedef struct {
    CGuint  header;    /* def's for this in cgpi.h */
    CGint   ix;        /* s.15 fixed point */
    CGint   iy;
    CGint   iz;
    CGshort geomLen;   /* max number of bits in geometry */
    CGshort geomTagLen;
    CGubyte geomTag;
    CGshort geomShift; /* amount to left shift the data */
} CGPvertex;

typedef struct {
    CGint   ir;        /* s.15 fixed point */
    CGint   ig;
    CGint   ib;
    CGint   ia;
    CGshort colorLen;
    CGshort colorShift;
    CGshort colorTagLen;
    CGubyte colorTag;
    CGbyte  absolute;
} CGPsetcolor;

/* values for flags field */
#define CGP_SET_NORMAL_FLAG_ABSOLUTE 0x1
#define CGP_SET_NORMAL_FLAG_SPECIAL  0x8

/* Sepcial normal tags */
#define CGP_SPECIAL_NORMAL_X_AXIS        0x30000
#define CGP_SPECIAL_NORMAL_Y_AXIS        0x34000
#define CGP_SPECIAL_NORMAL_Z_AXIS        0x38000
#define CGP_SPECIAL_NORMAL_MID_OCT       0x31000
#define CGP_SPECIAL_NORMAL_CIR_XY        0x30800
#define CGP_SPECIAL_NORMAL_CIR_YZ        0x34800
#define CGP_SPECIAL_NORMAL_CIR_XZ        0x38800

typedef struct {
    CGint   u;
    CGint   v;
    CGint   sext;
    CGint   oct;
    CGuint  index;            /* complete packed index */
    CGshort normalLen;
    CGshort normalShift;
    CGshort normalTagLen;
    CGubyte normalTag;
    CGubyte flags;
} CGPsetnormal;

typedef struct {
    CGshort numZeros;
} CGPvnop;

typedef struct {
    CGfloat nX;
    CGfloat nY;
    CGfloat nZ;
    CGfloat r;
    CGfloat g;
    CGfloat b;
    CGfloat a;
/* TODO - remove this once mesh problems resolved */
    CGfloat x;
    CGfloat y;
    CGfloat z;
} CGPmeshbuff;

#define CGP_CMD_SET_STATE_CAP    0x001  /* color alpha present */
#define CGP_CMD_SET_STATE_BCV    0x002  /* bundle colors with vertices */
#define CGP_CMD_SET_STATE_BNV    0x004  /* bundle normals with vertices */
#define CGP_CMD_SET_STATE_RCV    0x008  /* replicate colors with vertices */
#define CGP_CMD_SET_STATE_RNV    0x010  /* replicate colors with vertices */

#define CGP_CMD_SET_STATE_MBR_N  0x100  /* Mesh buffer reference don't */
                                        /*  send bundled normal        */
#define CGP_CMD_SET_STATE_MBR_C  0x200  /* Mesh buffer reference don't */
                                        /*  send bundled color        */
typedef struct {
    CGbitfield  state;
} CGPsetstate;

typedef struct {
    CGuint  mbRef;
} CGPmbr;


/* used for the type field of CGquant */
#define CGP_STREAM_QUANT_GEOM	1
#define CGP_STREAM_QUANT_COLOR	2
#define CGP_STREAM_QUANT_NORMAL	3

typedef struct {
   CGshort quant;
} CGPsetquant;

CGvoid cgpStreamData(CGPprimlist *, CGPcommandstream **, CGviewport *,
                     CGint, CGint, CGint);


/* initial size of the data stream buffer */
#define CGP_DATA_STREAM_BUFF_SIZE 5000

#define CGP_INC_CMD_POS                                                     \
        if (++cmdPos == cmdBuffSize)                                        \
        {                                                                   \
            cmdBuffSize += CGP_DATA_STREAM_BUFF_SIZE;                       \
            cmdHdr =                                                        \
                realloc(cmdHdr, sizeof(CGPcommandstream) * cmdBuffSize);    \
        }

/* maximum delta value that will fit into .15 bit number */
#define CGP_MAX_DELTA 32767

/* TODO - remove this */
#define USE_AFB 1
